/*
 * Decompiled with CFR 0.152.
 */
package diagramas.livre;

import controlador.Controler;
import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.formas.FormaNaoRetangularBase;
import desenho.formas.FormaTriangular;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.XMLGenerate;

public class LivreTriangulo
extends FormaTriangular {
    private static final long serialVersionUID = 1879344171165195360L;
    private boolean dashed = false;
    private boolean gradiente = true;
    private Color gradienteEndColor = new Color(204, 204, 204, 255);
    private Color gradienteStartColor = Color.BLACK;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private int gdirecao = 0;
    private float alfa = 0.8f;

    public LivreTriangulo(Diagrama modelo) {
        super(modelo);
        this.setDirecaoNaoNotifique(FormaNaoRetangularBase.Direcao.Right);
        this.editFonte = false;
    }

    public LivreTriangulo(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.setDirecaoNaoNotifique(FormaNaoRetangularBase.Direcao.Right);
        this.editFonte = false;
    }

    public void setDirecaoFromInspector(int di) {
        FormaNaoRetangularBase.Direcao dr = FormaNaoRetangularBase.Direcao.values()[di];
        this.setDirecaoTriangulo(dr);
    }

    public int getDirecaoForInspector() {
        return this.getDirecaoTriangulo().ordinal();
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorInteger(doc, "Direcao", this.getDirecaoForInspector()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Dashed", this.isDashed()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Gradiente", this.isGradiente()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteStartColor", this.getGradienteStartColor()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteEndColor", this.getGradienteEndColor()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "GDirecao", this.getGDirecao()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Alfa", (int)(100.0f * this.getAlfa())));
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        int l = XMLGenerate.getValorIntegerFrom(me, "Direcao");
        if (l != -1) {
            this.setDirecaoFromInspector(l);
        }
        this.setDashed(XMLGenerate.getValorBooleanFrom(me, "Dashed"));
        this.setGradiente(XMLGenerate.getValorBooleanFrom(me, "Gradiente"));
        Color c = XMLGenerate.getValorColorFrom(me, "GradienteStartColor");
        if (c != null) {
            this.setGradienteStartColor(c);
        }
        if ((c = XMLGenerate.getValorColorFrom(me, "GradienteEndColor")) != null) {
            this.setGradienteEndColor(c);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "GDirecao")) != -1) {
            this.setGDirecao(l);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "Alfa")) != -1) {
            this.SetAlfa(l);
        }
        return true;
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        res.add(InspectorProperty.PropertyFactoryMenu("direcao", "setDirecaoFromInspector", this.getDirecaoForInspector(), Editor.fromConfiguracao.getLstDirecao(Controler.Comandos.cmdEspecializacao)));
        return res;
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        GP.add(InspectorProperty.PropertyFactorySN("linha.dashed", "setDashed", this.isDashed()));
        GP.add(InspectorProperty.PropertyFactoryNumero("diagrama.detalhe.alfa", "SetAlfa", (int)(100.0f * this.getAlfa())));
        ArrayList<InspectorProperty> res = GP;
        res.add(InspectorProperty.PropertyFactorySeparador("texto.gradiente"));
        String[] grupo = new String[]{"setGradienteStartColor", "setGradienteEndColor", "setGDirecao"};
        res.add(InspectorProperty.PropertyFactorySN("texto.gradiente.is", "setGradiente", this.isGradiente()).AddCondicaoForFalse(new String[]{"setBackColor"}).AddCondicaoForTrue(grupo));
        res.add(InspectorProperty.PropertyFactoryCor("texto.gradiente.startcor", "setGradienteStartColor", this.getGradienteStartColor()));
        res.add(InspectorProperty.PropertyFactoryCor("texto.gradiente.endcor", "setGradienteEndColor", this.getGradienteEndColor()));
        res.add(InspectorProperty.PropertyFactoryMenu("texto.gradiente.direcao", "setGDirecao", this.getGDirecao(), Editor.fromConfiguracao.getLstDirecao(Controler.Comandos.cmdTexto)));
        return super.CompleteGenerateProperty(GP);
    }

    @Override
    protected void PinteRegiao(Graphics2D g) {
        Composite originalComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, this.alfa));
        g.setPaint(this.getForeColor());
        if (this.isGradiente()) {
            int dist = 0;
            int w = this.getWidth() - dist;
            int h = this.getHeight() - dist;
            int L = this.getLeft();
            int T = this.getTop();
            boolean dv = this.getGDirecao() == 0;
            GradientPaint GP = new GradientPaint(L, T, this.getGradienteStartColor(), dv ? (float)L : (float)(L + w), dv ? (float)(T + h) : (float)T, this.getGradienteEndColor(), true);
            g.setPaint(GP);
        }
        Stroke bkp = g.getStroke();
        if (this.isDashed()) {
            g.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
        }
        if (this.isGradiente()) {
            g.fill(this.getRegiao());
        }
        g.draw(this.getRegiao());
        g.setStroke(bkp);
        g.setComposite(originalComposite);
    }

    public boolean isDashed() {
        return this.dashed;
    }

    public void setDashed(boolean dasehd) {
        if (this.dashed != dasehd) {
            this.dashed = dasehd;
            this.DoMuda();
            this.InvalidateArea();
        }
    }

    public Color getGradienteStartColor() {
        return this.isDisablePainted() ? this.disabledColor : this.gradienteStartColor;
    }

    public void setGradienteStartColor(Color gradienteStartColor) {
        this.gradienteStartColor = gradienteStartColor;
        this.InvalidateArea();
    }

    public boolean isGradiente() {
        return this.gradiente;
    }

    public void setGradiente(boolean gradiente) {
        this.gradiente = gradiente;
        this.InvalidateArea();
    }

    public Color getGradienteEndColor() {
        return this.isDisablePainted() ? this.disabledColor : this.gradienteEndColor;
    }

    public void setGradienteEndColor(Color gradienteEndColor) {
        this.gradienteEndColor = gradienteEndColor;
        this.InvalidateArea();
    }

    public float getAlfa() {
        return this.alfa;
    }

    public void setAlfa(float alfa) {
        this.alfa = alfa;
    }

    public void SetAlfa(int alfa) {
        this.alfa = (float)alfa / 100.0f;
        if (this.alfa > 1.0f) {
            this.alfa = 0.5f;
        }
        this.InvalidateArea();
    }

    public int getGDirecao() {
        return this.gdirecao;
    }

    public void setGDirecao(int aDirection) {
        this.gdirecao = aDirection;
        this.InvalidateArea();
    }
}

