using System;
using System.ComponentModel.DataAnnotations;

namespace Alura.LeilaoOnline.WebApp.Models
{
    public class Leilao
    {        
        public int Id { get; set; }
        
        [Required(ErrorMessage = "Ttulo  obrigatrio")] 
        [Display(Name = "Ttulo", Prompt = "Digite o ttulo do leilo")]
        public string Titulo { get; set; }

        [Display(Name = "Descrio")]
        public string Descricao { get; set; }

        [Display(Name = "Incio do Prego")]
        [DataType(DataType.DateTime, ErrorMessage = "Data invlida")]
        public DateTime? Inicio { get; set; }

        [Display(Name = "Trmino do Prego")]
        [DataType(DataType.DateTime, ErrorMessage = "Data invlida")]
        public DateTime? Termino { get; set; }

        public int IdCategoria { get; set; }
        public Categoria Categoria { get; set; }
        public SituacaoLeilao Situacao { get; set; }
        public string PosterUrl => $"/images/poster-{Id}.jpg";
    }
}