/*
 * Decompiled with CFR 0.152.
 */
package diagramas.eap;

import controlador.Controler;
import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import desenho.formas.Forma;
import desenho.linhas.Linha;
import desenho.linhas.PontoDeLinha;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.XMLGenerate;

public class EapBarraLigacao
extends Forma {
    private static final long serialVersionUID = 1939864565434922497L;
    public final int LARG_ALT = 10;
    public final int VERTICAL = 0;
    public final int HORIZONTAL = 1;
    public final int HCENTRO = 0;
    public final int HESQUERDA = 1;
    public final int HDIREITA = 2;
    private int direcao = 1;
    private int posicao = 0;
    protected final int CONST_ORG_FULL = 24782;
    private int distancia = 10;
    private transient Forma principal = null;

    public EapBarraLigacao(Diagrama modelo) {
        super(modelo);
        this.editFonte = false;
    }

    public EapBarraLigacao(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.editFonte = false;
    }

    public int getDirecao() {
        return this.direcao;
    }

    public void setDirecao(int aDirection) {
        boolean mud = this.direcao != aDirection;
        this.direcao = aDirection;
        if (this.direcao == 0 && this.getWidth() > 10 || this.getHeight() > 10 && this.direcao == 1) {
            this.setStopRaize(true);
            if (this.direcao == 0) {
                this.setHeight(this.getWidth());
                this.setWidth(10);
            }
            if (this.direcao == 1) {
                this.setWidth(this.getHeight());
                this.setHeight(10);
            }
            this.setStopRaize(false);
            this.needRecalPts = true;
            if (this.isSelecionado()) {
                this.Reposicione();
            }
            mud = true;
        }
        this.PropagueResizeParaLigacoes();
        this.OrganizeLigacoes();
        if (mud) {
            this.DoMuda();
        }
        this.InvalidateArea();
    }

    public void SetDirecao(int aDirection) {
        boolean mud = this.direcao != aDirection;
        this.setDirecao(aDirection);
        if (mud) {
            this.OrganizeEap();
        }
    }

    public int getPosicao() {
        return this.posicao;
    }

    public void setPosicao(int posicao) {
        if (this.posicao != posicao) {
            this.posicao = posicao;
            this.OrganizeEap();
        }
    }

    public void setPosicaoDireto(int posicao) {
        this.posicao = posicao;
    }

    @Override
    public void DoPaint(Graphics2D g) {
        super.DoPaint(g);
        g.setColor(this.getForeColor());
        Rectangle r = this.getBounds();
        if (this.direcao == 0) {
            int m = r.width / 2;
            g.drawLine(r.x + m, r.y, r.x + m, r.y + r.height);
        } else {
            int m = r.height / 2;
            g.drawLine(r.x, r.y + m, r.x + r.width, r.y + m);
        }
        if (this.direcao == 0 && this.getWidth() > 10 || this.getHeight() > 10 && this.direcao == 1) {
            this.setStopRaize(true);
            if (this.direcao == 0) {
                this.setWidth(10);
            }
            if (this.direcao == 1) {
                this.setHeight(10);
            }
            this.setStopRaize(false);
            this.needRecalPts = true;
            if (this.isSelecionado()) {
                this.Reposicione();
            }
        }
    }

    @Override
    public void PinteTexto(Graphics2D g) {
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        ArrayList<InspectorProperty> res = GP;
        res.add(InspectorProperty.PropertyFactorySeparador("eapbarraligacao.organizacao"));
        res.add(InspectorProperty.PropertyFactoryMenu("diagrama.direcaovh", "SetDirecao", this.getDirecao(), Editor.fromConfiguracao.getLstDirecao(Controler.Comandos.cmdEapBarraLigacao)).AddCondicao(new String[]{"1"}, new String[]{"setPosicao"}));
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(Editor.fromConfiguracao.getValor("Inspector.lst.direcao.center"));
        tmp.add(Editor.fromConfiguracao.getValor("Inspector.lst.direcao.left"));
        tmp.add(Editor.fromConfiguracao.getValor("Inspector.lst.direcao.right"));
        res.add(InspectorProperty.PropertyFactoryMenu("eapbarraligacao.posicao", "setPosicao", this.getPosicao(), tmp));
        res.add(InspectorProperty.PropertyFactoryNumero("eapbarraligacao.distancia", "setDistancia", this.getDistancia()));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "diagrama.comando.organizar"));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "diagrama.comando.fullorganizar").setTag(24782));
        return super.CompleteGenerateProperty(GP);
    }

    @Override
    public void PosicionePonto(PontoDeLinha ponto) {
        PontoDeLinha outraponta = ponto.getDono().getOutraPonta(ponto);
        if (outraponta.getTopHeight() < this.getTop()) {
            if (this.getDirecao() == 1) {
                int recuo = -1;
                int to = this.getTop() + this.getHeight() / 2 - ponto.getHeight() / 2;
                if (outraponta.getLeft() < this.getLeft()) {
                    ponto.setLado(0);
                    ponto.setLocation(this.getLeft() - ponto.getWidth() / 2 + recuo, to);
                    return;
                }
                if (outraponta.getLeft() > this.getLeftWidth()) {
                    ponto.setLado(2);
                    ponto.setLocation(this.getLeftWidth() - ponto.getWidth() / 2 + recuo, to);
                    return;
                }
            }
            ponto.setLado(1);
            ponto.setCentro(this.getLeft() + this.getWidth() / 2, this.getTop() + (this.getDirecao() == 1 ? this.getHeight() / 2 - 1 : 0));
            return;
        }
        if (this.getDirecao() == 1) {
            ponto.setLado(3);
            ponto.setTop(this.getTop() + this.getHeight() / 2 - ponto.getHeight() / 2);
        } else {
            if (outraponta.getLeft() > this.getLeftWidth()) {
                ponto.setLado(2);
            } else {
                ponto.setLado(0);
            }
            ponto.setLeft(this.getLeft() + this.getWidth() / 2 - ponto.getWidth() / 2);
        }
    }

    @Override
    protected void PropagueResizeParaLigacoes() {
        super.PropagueResizeParaLigacoes();
        ArrayList<PontoDeLinha> lst = this.getListaDePontosLigados();
        for (PontoDeLinha pt : lst) {
            this.PosicionePonto(pt);
        }
    }

    @Override
    public boolean CanLiga(Forma forma, Linha lin) {
        if (super.CanLiga(forma, lin)) {
            if (forma == this) {
                return false;
            }
            return forma == null || this.getListaDeFormasLigadas().indexOf(forma) < 0;
        }
        return false;
    }

    @Override
    public void mouseDblClicked(MouseEvent e) {
        super.mouseDblClicked(e);
        this.OrganizeEap();
    }

    public int getDistancia() {
        return this.distancia;
    }

    public void setDistancia(int distancia) {
        this.distancia = distancia;
        this.DoMuda();
    }

    protected void PreOrganizeEap() {
        if (this.getMaster().IsMultSelecionado()) {
            return;
        }
        ArrayList<Forma> lst = this.getListaDeFormasLigadas();
        ArrayList<PontoDeLinha> lstp = this.getListaDePontosLigados();
        this.RemovaLinhasNaoLigadas(lstp);
        Forma maisAci = this.capturePrincipal();
        PontoDeLinha pt = this.getPontoLigadoA(lstp, maisAci);
        int dist = this.getDistancia();
        if (lst.size() < 2) {
            return;
        }
        int recuo = -1;
        boolean corecuo = true;
        this.HidePontos(true);
        if (this.getDirecao() == 0) {
            int meiopt = pt.getWidth() / 2;
            int tamPt = pt.getWidth();
            int le = (maisAci.getWidth() - this.getWidth()) / 2 + maisAci.getLeft();
            int to = maisAci.getTopHeight() + this.getWidth();
            PontoDeLinha opt = pt.getDono().getOutraPonta(pt);
            this.setLocation(le, to);
            this.Reposicione();
            this.Reenquadre();
            le = maisAci.getLeft() + (maisAci.getWidth() - tamPt) / 2;
            opt.setLado(3);
            opt.setLocation(le, maisAci.getTopHeight() - meiopt + 1);
            pt.setLado(1);
            pt.setLocation(le, this.getTop() - meiopt + -1);
            lst.remove(maisAci);
            lstp.remove(pt);
            int posiL = this.getLeft() + this.getWidth() / 2;
            while (lst.size() > 0) {
                to = maisAci.getTopHeight() + 2 * dist;
                le = this.getLeftWidth() + this.getWidth();
                maisAci = this.getFormaMaisAcima(lst);
                pt = this.getPontoLigadoA(lstp, maisAci);
                opt = pt.getDono().getOutraPonta(pt);
                maisAci.setLocation(le, to);
                maisAci.ManualResized();
                to = maisAci.getTop() + (maisAci.getHeight() - tamPt) / 2;
                if (this.getTopHeight() < to) {
                    this.setHeight(to - this.getTop() + meiopt);
                    this.Reposicione();
                    this.Reenquadre();
                }
                pt.setLado(2);
                pt.setLocation(posiL, to);
                opt.setLado(0);
                opt.setLocation(maisAci.getLeft() - meiopt + -1, to);
                lst.remove(maisAci);
                lstp.remove(pt);
            }
            if (this.getTopHeight() > to) {
                int tmp = to - this.getTop() + meiopt;
                this.setHeight(Math.max(tmp, 10));
                this.Reposicione();
            }
        } else {
            int meiopt = pt.getHeight() / 2;
            int le = maisAci.getLeft() + maisAci.getWidth() / 2 + meiopt;
            int to = maisAci.getTopHeight() + this.getHeight() + this.getHeight() / 2;
            lst.remove(maisAci);
            lstp.remove(pt);
            PontoDeLinha opt = pt.getDono().getOutraPonta(pt);
            opt.setLado(3);
            opt.setLocation(le - meiopt, maisAci.getTopHeight() - meiopt + 1);
            lst = this.ordeneMenor(lst);
            int tam = 0;
            for (Forma forma : lst) {
                tam += forma.getWidth() + dist;
            }
            tam = tam - dist - (lst.get(0).getWidth() / 2 + lst.get(lst.size() - 1).getWidth() / 2) - 1;
            tam = Math.max(tam, 10);
            if (this.getPosicao() == 1) {
                this.SetBounds(le + lst.get(0).getWidth() + this.getHeight(), to, tam, this.getHeight());
                this.Reposicione();
                pt.setLado(0);
                to = this.getTop() + this.getHeight() / 2 - 1;
                pt.setLocation(this.getLeft() - pt.getWidth() / 2 + -1, to);
            } else if (this.getPosicao() == 2) {
                this.SetBounds(le - tam - this.getHeight() - lst.get(lst.size() - 1).getWidth() - this.getHeight(), to, tam, this.getHeight());
                this.Reposicione();
                pt.setLado(2);
                to = this.getTop() + this.getHeight() / 2 - 1;
                pt.setLocation(this.getLeftWidth() - pt.getWidth() / 2 + -1, to);
            } else {
                this.SetBounds(le - tam / 2, to, tam, this.getHeight());
                this.Reposicione();
                pt.setLado(1);
                to = this.getTop() + this.getHeight() / 2 - 1;
                pt.setCentro(this.getLeft() + this.getWidth() / 2, to);
            }
            this.Reenquadre();
            int tl = lst.size();
            int posiT = this.getTop() + this.getHeight() / 2 - 1;
            to = this.getTopHeight() + this.getHeight() + this.getHeight() / 2;
            le = this.getLeft();
            maisAci = this.getFormaMaisEsquerda(lst);
            for (int i = 0; i < tl; ++i) {
                maisAci.setLocation(le - maisAci.getWidth() / 2, to);
                maisAci.ManualResized();
                pt = this.getPontoLigadoA(lstp, maisAci);
                opt = pt.getDono().getOutraPonta(pt);
                pt.setLado(3);
                pt.setLocation(le - opt.getWidth() / 2 + -1, posiT);
                opt.setLado(1);
                opt.setLocation(le - opt.getWidth() / 2 + -1, to - this.getHeight() / 2 + 1);
                lst.remove(maisAci);
                lstp.remove(pt);
                le = maisAci.getLeftWidth() + dist;
                maisAci = this.getFormaMaisEsquerda(lst);
                if (maisAci == null) continue;
                le += maisAci.getWidth() / 2;
            }
        }
        this.HidePontos(false);
        this.PropagueResizeParaLigacoes();
        this.OrganizeLigacoes();
    }

    protected int getLarguraEapHorizontal(ArrayList<EapBarraLigacao> ja, HashMap<Forma, EapBarraLigacao> areas) {
        boolean hor;
        if (ja.indexOf(this) > -1) {
            return 0;
        }
        ja.add(this);
        ArrayList<Forma> lst = this.getListaDeFormasLigadas();
        Forma ma = this.capturePrincipal();
        lst.remove(ma);
        int tam = 0;
        int dist = this.getDistancia();
        boolean bl = hor = this.getDirecao() == 1;
        if (hor) {
            for (Forma forma : lst) {
                tam += areas.get(forma) == null ? forma.getWidth() + dist : areas.get(forma).getLarguraEapHorizontal(ja, areas);
            }
            if (this.getPosicao() != 0) {
                tam += ma.getWidth() + this.getHeight();
            }
        } else {
            tam = ma.getWidth() + this.getDistancia() - ma.getWidth() / 2;
            int subtam = 0;
            for (Forma forma : lst) {
                if (areas.get(forma) == null) {
                    subtam = Math.max(forma.getWidth(), subtam);
                    continue;
                }
                subtam = Math.max(areas.get(forma).getLarguraEapHorizontal(ja, areas), subtam);
            }
            tam += subtam;
        }
        return tam;
    }

    protected Point calcDifCentroEapHorizontal(HashMap<Forma, EapBarraLigacao> areas) {
        ArrayList<Forma> lst = this.getListaDeFormasLigadas();
        Forma ma = this.capturePrincipal();
        lst.remove(ma);
        Forma fmE = this.getFormaMaisEsquerda(lst);
        Forma fmD = this.getFormaMaisDireita(lst);
        ArrayList<EapBarraLigacao> jatmp = new ArrayList<EapBarraLigacao>();
        fmE = areas.get(fmE) == null ? fmE : areas.get(fmE).calcMaisAEsquerda(jatmp, areas);
        jatmp = new ArrayList();
        fmD = areas.get(fmD) == null ? fmD : areas.get(fmD).calcMaisADireita(jatmp, areas);
        int tamE = ma.getLeft() + ma.getWidth() / 2 - fmE.getLeft();
        int tamD = fmD.getLeftWidth() - (ma.getLeftWidth() - ma.getWidth() / 2);
        return new Point(tamE, tamD);
    }

    protected Forma calcMaisAEsquerda(ArrayList<EapBarraLigacao> ja, HashMap<Forma, EapBarraLigacao> areas) {
        if (ja.indexOf(this) > -1) {
            return null;
        }
        ja.add(this);
        ArrayList<Forma> lst = this.getListaDeFormasLigadas();
        Forma ma = this.capturePrincipal();
        lst.remove(ma);
        for (Forma forma : lst) {
            Forma tmp;
            if (areas.get(forma) != null && (tmp = areas.get(forma).calcMaisAEsquerda(ja, areas)) != null) {
                forma = tmp;
            }
            if (forma.getLeft() >= ma.getLeft()) continue;
            ma = forma;
        }
        return ma;
    }

    protected Forma calcMaisADireita(ArrayList<EapBarraLigacao> ja, HashMap<Forma, EapBarraLigacao> areas) {
        if (ja.indexOf(this) > -1) {
            return null;
        }
        ja.add(this);
        ArrayList<Forma> lst = this.getListaDeFormasLigadas();
        Forma ma = this.capturePrincipal();
        lst.remove(ma);
        for (Forma forma : lst) {
            Forma tmp;
            if (areas.get(forma) != null && (tmp = areas.get(forma).calcMaisADireita(ja, areas)) != null) {
                forma = tmp;
            }
            if (forma.getLeftWidth() <= ma.getLeftWidth()) continue;
            ma = forma;
        }
        return ma;
    }

    protected int EndOrganizeEap(ArrayList<EapBarraLigacao> ja, HashMap<Forma, EapBarraLigacao> areas) {
        int retorno = 0;
        if (ja.indexOf(this) == -1) {
            this.releasePrinciapal();
            return retorno;
        }
        ja.remove(this);
        ArrayList<Forma> lst = this.getListaDeFormasLigadas();
        ArrayList<PontoDeLinha> lstp = this.getListaDePontosLigados();
        this.RemovaLinhasNaoLigadas(lstp);
        Forma maisAci = this.capturePrincipal();
        this.releasePrinciapal();
        PontoDeLinha pt = this.getPontoLigadoA(lstp, maisAci);
        int dist = this.getDistancia();
        if (lst.size() < 2) {
            return 0;
        }
        int recuo = -1;
        boolean corecuo = true;
        this.HidePontos(true);
        if (this.getDirecao() == 0) {
            int meiopt = pt.getWidth() / 2;
            int tamPt = pt.getWidth();
            int le = (maisAci.getWidth() - this.getWidth()) / 2 + maisAci.getLeft();
            int to = maisAci.getTopHeight() + this.getWidth();
            PontoDeLinha opt = pt.getDono().getOutraPonta(pt);
            this.setLocation(le, to);
            this.Reposicione();
            this.Reenquadre();
            le = maisAci.getLeft() + (maisAci.getWidth() - tamPt) / 2;
            opt.setLado(3);
            opt.setLocation(le, maisAci.getTopHeight() - meiopt + 1);
            pt.setLado(1);
            pt.setLocation(le, this.getTop() - meiopt + -1);
            lst.remove(maisAci);
            lstp.remove(pt);
            int posiL = this.getLeft() + this.getWidth() / 2;
            to = maisAci.getTopHeight() + 2 * dist;
            le = this.getLeftWidth() + this.getWidth();
            while (lst.size() > 0) {
                maisAci = this.getFormaMaisAcima(lst);
                pt = this.getPontoLigadoA(lstp, maisAci);
                opt = pt.getDono().getOutraPonta(pt);
                if (areas.get(maisAci) != null && areas.get(maisAci).getDirecao() == 1 && areas.get(maisAci).getPosicao() == 2) {
                    ArrayList<EapBarraLigacao> jatmp = new ArrayList<EapBarraLigacao>();
                    int letmp = areas.get(maisAci).getLarguraEapHorizontal(jatmp, areas);
                    le += letmp - maisAci.getWidth();
                }
                maisAci.setLocation(le, to);
                maisAci.ManualResized();
                int oldTO = to;
                to = maisAci.getTop() + (maisAci.getHeight() - tamPt) / 2;
                if (this.getTopHeight() < to) {
                    this.setHeight(to - this.getTop() + meiopt);
                    this.Reposicione();
                    this.Reenquadre();
                }
                pt.setLado(2);
                pt.setLocation(posiL, to);
                opt.setLado(0);
                opt.setLocation(maisAci.getLeft() - meiopt + -1, to);
                lst.remove(maisAci);
                lstp.remove(pt);
                if (areas.get(maisAci) == null) {
                    to = maisAci.getTopHeight() + 2 * dist;
                } else if (areas.get(maisAci).getDirecao() == 1 && areas.get(maisAci).getPosicao() == 0) {
                    ArrayList<EapBarraLigacao> jatmp = new ArrayList<EapBarraLigacao>();
                    jatmp.addAll(ja);
                    to = areas.get(maisAci).EndOrganizeEap(ja, areas);
                    Point p = areas.get(maisAci).calcDifCentroEapHorizontal(areas);
                    if (p.x != p.y) {
                        maisAci.setLocation(le += p.x - maisAci.getWidth() / 2, oldTO);
                        maisAci.ManualResized();
                        areas.get(maisAci).EndOrganizeEap(jatmp, areas);
                    }
                } else {
                    to = areas.get(maisAci).EndOrganizeEap(ja, areas);
                }
                le = this.getLeftWidth() + this.getWidth();
            }
            if (this.getTopHeight() > to) {
                int tmp = to - this.getTop() + meiopt;
                this.setHeight(Math.max(tmp, 10));
                this.Reposicione();
            }
            retorno = to;
        } else {
            int meiopt = pt.getHeight() / 2;
            int le = maisAci.getLeft() + maisAci.getWidth() / 2 + meiopt;
            int to = maisAci.getTopHeight() + this.getHeight() + this.getHeight() / 2;
            lst.remove(maisAci);
            lstp.remove(pt);
            PontoDeLinha opt = pt.getDono().getOutraPonta(pt);
            opt.setLado(3);
            opt.setLocation(le - meiopt, maisAci.getTopHeight() - meiopt + 1);
            lst = this.ordeneMenor(lst);
            int tam = 0;
            HashMap<Forma, Integer> tams = new HashMap<Forma, Integer>();
            HashMap<Forma, Integer> meios = new HashMap<Forma, Integer>();
            Forma fmD = this.getFormaMaisDireita(lst);
            Forma fmE = this.getFormaMaisEsquerda(lst);
            for (Forma forma : lst) {
                int x;
                Point p;
                if (areas.get(forma) == null) {
                    tam += forma.getWidth() + dist;
                    continue;
                }
                ArrayList<EapBarraLigacao> jatmp = new ArrayList<EapBarraLigacao>();
                int tmp = areas.get(forma).getLarguraEapHorizontal(jatmp, areas);
                tams.put(forma, tmp);
                if (fmE == forma) {
                    switch (areas.get(forma).getPosicao()) {
                        case 1: {
                            tmp -= forma.getWidth() / 2;
                            break;
                        }
                        case 0: {
                            tmp = (tmp - dist) / 2 + dist;
                            if (areas.get(fmE).getDirecao() != 1 || areas.get(fmE).getPosicao() != 0) break;
                            jatmp = new ArrayList();
                            jatmp.addAll(ja);
                            areas.get(fmE).EndOrganizeEap(jatmp, areas);
                            p = areas.get(fmE).calcDifCentroEapHorizontal(areas);
                            x = 0;
                            if (p.x != p.y) {
                                x = (p.y - p.x) / 2;
                            }
                            tmp += x;
                            meios.put(fmE, x);
                            break;
                        }
                        case 2: {
                            tmp = forma.getWidth() / 2 + dist;
                        }
                    }
                } else if (fmD == forma) {
                    switch (areas.get(forma).getPosicao()) {
                        case 1: {
                            tmp = forma.getWidth() / 2 + dist;
                            break;
                        }
                        case 2: {
                            tmp -= forma.getWidth() / 2;
                            break;
                        }
                        case 0: {
                            tmp = (tmp - dist) / 2 + dist;
                            if (areas.get(fmD).getDirecao() != 1 || areas.get(fmD).getPosicao() != 0) break;
                            jatmp = new ArrayList();
                            jatmp.addAll(ja);
                            areas.get(fmD).EndOrganizeEap(jatmp, areas);
                            p = areas.get(fmD).calcDifCentroEapHorizontal(areas);
                            x = 0;
                            if (p.x != p.y) {
                                x = (p.x - p.y) / 2;
                            }
                            tmp += x;
                            meios.put(fmD, x);
                        }
                    }
                }
                tam += tmp;
            }
            tam -= dist;
            if (lst.size() > 1) {
                if (areas.get(fmE) == null) {
                    tam -= fmE.getWidth() / 2;
                }
                if (areas.get(fmD) == null) {
                    int tmp = fmD.getWidth() / 2;
                    tam -= tmp;
                }
                --tam;
            } else {
                tam = maisAci.getWidth();
            }
            tam = Math.max(tam, 10);
            switch (this.getPosicao()) {
                case 1: {
                    this.SetBounds(le + fmE.getWidth() + this.getHeight(), to, tam, this.getHeight());
                    this.Reposicione();
                    pt.setLado(0);
                    to = this.getTop() + this.getHeight() / 2 - 1;
                    pt.setLocation(this.getLeft() - pt.getWidth() / 2 + -1, to);
                    break;
                }
                case 2: {
                    this.SetBounds(le - tam - this.getHeight() - fmD.getWidth() - this.getHeight(), to, tam, this.getHeight());
                    this.Reposicione();
                    pt.setLado(2);
                    to = this.getTop() + this.getHeight() / 2 - 1;
                    pt.setLocation(this.getLeftWidth() - pt.getWidth() / 2 + -1, to);
                    break;
                }
                default: {
                    this.SetBounds(le - tam / 2, to, tam, this.getHeight());
                    this.Reposicione();
                    pt.setLado(1);
                    to = this.getTop() + this.getHeight() / 2 - 1;
                    pt.setCentro(this.getLeft() + this.getWidth() / 2, to);
                }
            }
            this.Reenquadre();
            int posiT = this.getTop() + this.getHeight() / 2 - 1;
            to = this.getTopHeight() + this.getHeight() + this.getHeight() / 2;
            le = this.getLeft();
            int larg = 0;
            maisAci = this.getFormaMaisEsquerda(lst);
            le -= maisAci.getWidth() / 2;
            retorno = maisAci.getTopHeight();
            while (lst.size() > 0) {
                maisAci.setLocation(le, to);
                maisAci.ManualResized();
                retorno = Math.max(retorno, maisAci.getTopHeight());
                int meio = maisAci.getWidth() / 2;
                pt = this.getPontoLigadoA(lstp, maisAci);
                opt = pt.getDono().getOutraPonta(pt);
                pt.setLado(3);
                pt.setLocation(le + meio - opt.getWidth() / 2 + -1, posiT);
                opt.setLado(1);
                opt.setLocation(le + meio - opt.getWidth() / 2 + -1, to - this.getHeight() / 2 + 1);
                lst.remove(maisAci);
                lstp.remove(pt);
                le = maisAci.getLeftWidth() + dist;
                larg = 0;
                if (areas.get(maisAci) != null) {
                    retorno = Math.max(retorno, areas.get(maisAci).EndOrganizeEap(ja, areas) - 2 * dist);
                    larg = (Integer)tams.get(maisAci) - dist;
                    if (areas.get(maisAci).getDirecao() == 0) {
                        larg -= maisAci.getWidth();
                    } else {
                        switch (areas.get(maisAci).getPosicao()) {
                            case 0: {
                                larg = (larg - maisAci.getWidth()) / 2;
                                if (maisAci != fmE) break;
                                larg += ((Integer)meios.get(fmE)).intValue();
                                break;
                            }
                            case 2: {
                                larg = 0;
                                break;
                            }
                            case 1: {
                                larg -= maisAci.getWidth();
                            }
                        }
                    }
                }
                le += larg;
                maisAci = this.getFormaMaisEsquerda(lst);
                larg = 0;
                if (areas.get(maisAci) != null) {
                    larg = (Integer)tams.get(maisAci) - dist;
                    if (areas.get(maisAci).getDirecao() == 0) {
                        larg -= maisAci.getWidth();
                    } else {
                        switch (areas.get(maisAci).getPosicao()) {
                            case 0: {
                                larg = (larg - maisAci.getWidth()) / 2;
                                if (maisAci != fmD) break;
                                larg += ((Integer)meios.get(fmD)).intValue();
                                break;
                            }
                            case 2: {
                                larg -= maisAci.getWidth();
                                break;
                            }
                            case 1: {
                                larg = 0;
                            }
                        }
                    }
                }
                le += larg;
            }
            retorno += 2 * dist;
        }
        this.HidePontos(false);
        this.PropagueResizeParaLigacoes();
        this.OrganizeLigacoes();
        return retorno;
    }

    public Forma capturePrincipal() {
        if (this.principal == null) {
            ArrayList<Forma> lst = this.getListaDeFormasLigadas();
            this.principal = this.getFormaMaisAcima(lst);
        }
        return this.principal;
    }

    public void releasePrinciapal() {
        this.principal = null;
    }

    public void OrganizeEap() {
        boolean bkp = this.getMaster().isCarregando;
        this.getMaster().isCarregando = true;
        this.capturePrincipal();
        this.PreOrganizeEap();
        this.releasePrinciapal();
        this.getMaster().isCarregando = bkp;
        this.getMaster().repaint();
        this.DoMuda();
    }

    public void FullOrganizeEap() {
        if (this.getMaster().IsMultSelecionado()) {
            return;
        }
        boolean bkp = this.getMaster().isCarregando;
        this.getMaster().isCarregando = true;
        ArrayList<EapBarraLigacao> ja = new ArrayList<EapBarraLigacao>();
        this.getAllEap(ja);
        ja.stream().forEach(eap -> {
            eap.releasePrinciapal();
            eap.capturePrincipal();
        });
        ArrayList maximas = new ArrayList();
        HashMap<Forma, EapBarraLigacao> areas = new HashMap<Forma, EapBarraLigacao>();
        ja.stream().forEach(eap -> {
            eap.PreOrganizeEap();
            Forma maisAci = eap.capturePrincipal();
            maximas.add(maisAci);
            areas.put(maisAci, (EapBarraLigacao)eap);
        });
        List maximasOrd = maximas.stream().sorted((f1, f2) -> Integer.compare(f1.getTop(), f2.getTop())).collect(Collectors.toList());
        EapBarraLigacao prin = (EapBarraLigacao)areas.get(maximasOrd.get(0));
        for (int i = 0; i < maximasOrd.size(); ++i) {
            if (((Forma)maximasOrd.get(i)).getListaDePontosLigados().size() != 1) continue;
            prin = areas.get(maximasOrd.get(i));
            break;
        }
        prin.EndOrganizeEap(ja, areas);
        this.getMaster().isCarregando = bkp;
        this.getMaster().repaint();
        this.DoMuda();
    }

    protected void getAllEap(ArrayList<EapBarraLigacao> ja) {
        ja.add(this);
        ArrayList<EapBarraLigacao> lst = new ArrayList<EapBarraLigacao>();
        this.getListaDeFormasLigadas().stream().forEach(f -> lst.addAll(f.getListaDeFormasLigadas().stream().filter(b -> b instanceof EapBarraLigacao && ja.indexOf(b) == -1).map(b -> (EapBarraLigacao)b).collect(Collectors.toList())));
        lst.forEach(eap -> eap.getAllEap(ja));
    }

    private Forma getFormaMaisAcima(ArrayList<Forma> lst) {
        if (lst.isEmpty()) {
            return null;
        }
        Forma res = lst.get(0);
        for (Forma forma : lst) {
            if (forma.getTop() >= res.getTop()) continue;
            res = forma;
        }
        return res;
    }

    private Forma getFormaMaisEsquerda(ArrayList<Forma> lst) {
        if (lst.isEmpty()) {
            return null;
        }
        Forma res = lst.get(0);
        for (Forma forma : lst) {
            if (forma.getLeft() >= res.getLeft()) continue;
            res = forma;
        }
        return res;
    }

    private Forma getFormaMaisDireita(ArrayList<Forma> lst) {
        if (lst.isEmpty()) {
            return null;
        }
        Forma res = lst.get(0);
        for (Forma forma : lst) {
            if (forma.getLeft() <= res.getLeft()) continue;
            res = forma;
        }
        return res;
    }

    private PontoDeLinha getPontoLigadoA(ArrayList<PontoDeLinha> lstp, Forma maisAci) {
        for (PontoDeLinha pt : lstp) {
            if (pt.getDono().getOutraPonta(this) != maisAci) continue;
            return pt;
        }
        return null;
    }

    private void RemovaLinhasNaoLigadas(ArrayList<PontoDeLinha> lstp) {
        int i = 0;
        while (i < lstp.size()) {
            PontoDeLinha pt = lstp.get(i);
            if (pt.getDono().getOutraPonta(this) == null) {
                lstp.remove(pt);
                continue;
            }
            ++i;
        }
    }

    private ArrayList<Forma> ordeneMenor(ArrayList<Forma> lst) {
        ArrayList<Forma> res = new ArrayList<Forma>();
        while (!lst.isEmpty()) {
            Forma menor = this.getFormaMaisEsquerda(lst);
            lst.remove(menor);
            res.add(menor);
        }
        return res;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorColor(doc, "BackColor", this.getBackColor()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Direcao", this.getDirecao()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Posicao", this.getPosicao()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Distancia", this.getDistancia()));
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        Color c;
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        int l = XMLGenerate.getValorIntegerFrom(me, "Direcao");
        if (l != -1) {
            this.setDirecao(l);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "Posicao")) != -1) {
            this.posicao = l;
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "Distancia")) != -1) {
            this.setDistancia(Math.min(10, l));
        }
        if ((c = XMLGenerate.getValorColorFrom(me, "BackColor")) != null) {
            this.setBackColor(c);
        }
        return true;
    }

    @Override
    public void DoAnyThing(int Tag) {
        if (Tag == 24782) {
            this.FullOrganizeEap();
        } else {
            this.OrganizeEap();
        }
    }
}

