/*
 * Decompiled with CFR 0.152.
 */
package diagramas.eap;

import controlador.Controler;
import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.Elementar;
import desenho.FormaElementar;
import desenho.formas.Desenhador;
import desenho.formas.Forma;
import desenho.formas.Legenda;
import diagramas.conceitual.Texto;
import diagramas.eap.EapBarraLigacao;
import diagramas.eap.EapLigacao;
import diagramas.eap.EapProcesso;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import principal.cli.FormCli;

public class DiagramaEap
extends Diagrama {
    private static final long serialVersionUID = -2209832873627630709L;
    private final Class[] classesDoDiagrama = new Class[]{EapProcesso.class, EapBarraLigacao.class, EapLigacao.class, Texto.class, Desenhador.class, Legenda.class};
    protected final String COMM_CLI = "CLI";
    private final int ATAG = 95;

    public DiagramaEap(Editor omaster) {
        super(omaster);
        this.setTipo(Diagrama.TipoDeDiagrama.tpEap);
        this.meusComandos.add(Controler.Comandos.cmdEapProcesso.name());
        this.meusComandos.add(Controler.Comandos.cmdEapBarraLigacao.name());
        this.meusComandos.add(Controler.Comandos.cmdEapLigacao.name());
    }

    @Override
    public Class[] getCassesDoDiagrama() {
        return this.classesDoDiagrama;
    }

    @Override
    protected FormaElementar RealiseComando(Point posi) {
        this.ClearSelect(false);
        FormaElementar resu = null;
        Controler.Comandos com = this.getComando();
        switch (com) {
            case cmdEapProcesso: {
                EapProcesso ep = new EapProcesso(this, EapProcesso.class.getSimpleName());
                ep.SetBounds(posi.x, posi.y, 120, 58);
                ep.Reenquadre();
                resu = ep;
                break;
            }
            case cmdEapBarraLigacao: {
                EapBarraLigacao bl = new EapBarraLigacao(this, EapBarraLigacao.class.getSimpleName());
                bl.SetBounds(posi.x, posi.y, 120, 10);
                bl.Reenquadre();
                resu = bl;
                break;
            }
            case cmdEapLigacao: {
                FormaElementar obj2;
                if (this.cliq1 == null) {
                    Elementar res = this.CaptureFromPoint(posi);
                    FormaElementar obj1 = null;
                    if (res instanceof FormaElementar) {
                        obj1 = (FormaElementar)res;
                    }
                    this.cliq1 = new Diagrama.clickForma(obj1, posi);
                    return null;
                }
                if (this.cliq2 == null) {
                    obj2 = null;
                    Elementar res = this.CaptureFromPoint(posi);
                    if (res instanceof FormaElementar) {
                        obj2 = (FormaElementar)res;
                    }
                    this.cliq2 = new Diagrama.clickForma(obj2, posi);
                }
                EapLigacao linha = new EapLigacao(this);
                resu = linha;
                Point pt1 = this.cliq1.getPonto();
                Point pt2 = this.cliq2.getPonto();
                FormaElementar obj1 = this.cliq1.getForma();
                if (obj1 != (obj2 = this.cliq2.getForma()) && obj1 instanceof EapProcesso && obj2 instanceof EapProcesso) {
                    int x = obj1.getLeft() <= obj2.getLeft() ? (obj1.getLeftWidth() + obj2.getLeft()) / 2 : (obj2.getLeftWidth() + obj1.getLeft()) / 2;
                    int y = obj1.getTop() <= obj2.getTop() ? (obj1.getTopHeight() + obj2.getTop()) / 2 : (obj2.getTopHeight() + obj1.getTop()) / 2;
                    Point ptcentral = new Point(x, y);
                    this.setComando(Controler.Comandos.cmdEapBarraLigacao);
                    FormaElementar resLi = this.RealiseComando(ptcentral);
                    resLi.setLocation(resLi.getLeft() - resLi.getWidth() / 2, resLi.getTop() - resLi.getHeight() / 2);
                    obj1.BringToFront();
                    obj2.BringToFront();
                    resLi.BringToFront();
                    resu = resLi;
                    Point pt3 = ((Forma)resLi).getMelhorPontoDeLigacao(pt1);
                    linha.FormasALigar = new Forma[]{(Forma)obj1, (Forma)resLi};
                    linha.Inicie(new Rectangle(pt3.x, pt3.y, pt1.x - pt3.x, pt1.y - pt3.y));
                    linha = new EapLigacao(this);
                    linha.FormasALigar = new Forma[]{(Forma)obj2, (Forma)resLi};
                    pt1 = pt2;
                    pt2 = ((Forma)resLi).getMelhorPontoDeLigacao(pt2);
                }
                linha.Inicie(new Rectangle(pt2.x, pt2.y, pt1.x - pt2.x, pt1.y - pt2.y));
            }
        }
        if (resu == null) {
            resu = super.RealiseComando(posi);
        } else {
            this.cliq1 = null;
            this.cliq2 = null;
            if (!this.master.isControlDown()) {
                this.setComando(null);
            } else {
                this.setComando(com);
            }
            resu.BringToFront();
        }
        return resu;
    }

    @Override
    public void populeComandos(JMenuItem menu) {
        super.populeComandos(menu);
        menu.removeAll();
        menu.setEnabled(true);
        String tmp = Editor.fromConfiguracao.getValor("Controler.interface.Diagrama.Command.Eap.Cli.descricao");
        Diagrama.AcaoDiagrama ac = (Diagrama)this.new Diagrama.AcaoDiagrama(this, tmp, "Controler.interface.Diagrama.Command.Eap.Cli.img", tmp, "CLI");
        ac.normal = false;
        JMenuItem mi = new JMenuItem(ac);
        mi.setName(tmp);
        menu.add(mi);
    }

    @Override
    public void rodaComando(String comm) {
        FormCli fm = new FormCli((Frame)((Object)this.getEditor().getFramePrincipal()), false);
        fm.setLocationRelativeTo((Frame)((Object)this.getEditor().getFramePrincipal()));
        fm.SetDiagrama(this);
        fm.setVisible(true);
    }

    @Override
    public void EndProperty(ArrayList<InspectorProperty> res) {
        super.EndProperty(res);
        res.add(InspectorProperty.PropertyFactorySeparador("cli"));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "cli").setTag(95));
    }

    @Override
    public void DoAnyThing(int Tag) {
        super.DoAnyThing(Tag);
        if (Tag == 95) {
            this.rodaComando("");
        }
    }
}

