/*
 * Decompiled with CFR 0.152.
 */
package desenho.preAnyDiagrama;

import controlador.Diagrama;
import controlador.Editor;
import controlador.apoios.TreeItem;
import controlador.inspector.InspectorProperty;
import desenho.formas.FormaTextoBase;
import desenho.linhas.Linha;
import desenho.linhas.PontoDeLinha;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import util.DesenhadorDeTexto;

public class PreCardinalidade
extends FormaTextoBase {
    private static final long serialVersionUID = 7310412510571815118L;
    private String papel = "";
    private TiposCard Card = TiposCard.C0N;
    private boolean TamanhoAutmatico = true;
    private boolean MovimentacaoManual = false;
    private transient double z = 0.0;
    private PontoDeLinha Fixo = null;
    private Linha ligadoA = null;

    public PreCardinalidade(Diagrama modelo) {
        super(modelo);
        this.AceitaAjusteAutmatico = false;
    }

    public PreCardinalidade(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.AceitaAjusteAutmatico = false;
    }

    public void Posicione() {
        if (this.isMovimentacaoManual() || this.Fixo == null || this.isSelecionado() || !this.Fixo.isEstaLigado()) {
            return;
        }
        this.DirectPosicione();
    }

    private void DirectPosicione() {
        int lado = this.Fixo.getLado();
        int x = 0;
        int y = 0;
        int corr = 4;
        switch (lado) {
            case 0: 
            case 2: {
                x = lado == 0 ? this.Fixo.getLeft() - this.getWidth() - 4 : this.Fixo.getLeft() + this.Fixo.getWidth() + 4;
                y = this.Fixo.getTop() - this.getHeight() - 2 + corr;
                break;
            }
            case 1: 
            case 3: {
                y = lado == 1 ? this.Fixo.getTop() - this.getHeight() - 4 : this.Fixo.getTop() + this.Fixo.getHeight() + 4;
                x = this.Fixo.getLeft() - this.getWidth() - 2 + corr;
            }
        }
        this.setLocation(x, y);
    }

    public String getPapel() {
        return this.papel;
    }

    public void setPapel(String papel) {
        if (this.papel == null ? papel != null : !this.papel.equals(papel)) {
            this.papel = papel;
            this.InvalidateArea();
        }
    }

    public TiposCard getCard() {
        return this.Card;
    }

    public void setCard(TiposCard Card) {
        if (this.Card != Card) {
            this.Card = Card;
            this.InvalidateArea();
        }
    }

    public void setCard(int Card) {
        try {
            this.setCard(TiposCard.values()[Card]);
        }
        catch (Exception e) {
            this.setCard(TiposCard.C0N);
        }
    }

    public String CardToString(TiposCard card) {
        String res = "(?,?)";
        if (card == null) {
            return res;
        }
        switch (card) {
            case C01: {
                res = "(0,1)";
                break;
            }
            case C11: {
                res = "(1,1)";
                break;
            }
            case C1N: {
                res = "(1,n)";
                break;
            }
            case C0N: {
                res = "(0,n)";
            }
        }
        return res;
    }

    public static String CardToString(int c) {
        String res = "(?,?)";
        if (c < 0 || c > TiposCard.values().length) {
            return res;
        }
        TiposCard card = TiposCard.values()[c];
        switch (card) {
            case C01: {
                res = "(0,1)";
                break;
            }
            case C11: {
                res = "(1,1)";
                break;
            }
            case C1N: {
                res = "(1,n)";
                break;
            }
            case C0N: {
                res = "(0,n)";
            }
        }
        return res;
    }

    public final String CardToString() {
        return this.CardToString(this.getCard());
    }

    public final String FullCard() {
        String p = this.getPapel();
        if (p == null || "".equals(p)) {
            return this.CardToString();
        }
        return this.CardToString() + " " + this.getPapel();
    }

    public TiposCard StringToCard(String card) {
        for (TiposCard c : TiposCard.values()) {
            if (!card.equals(this.CardToString(c))) continue;
            return c;
        }
        return TiposCard.C0N;
    }

    public TiposCard IntToCard(int card) {
        if (card >= 0 && card < TiposCard.values().length) {
            return TiposCard.values()[card];
        }
        return TiposCard.C0N;
    }

    public int CardToInt(TiposCard card) {
        return card.ordinal();
    }

    public int CardToInt() {
        return this.CardToInt(this.getCard());
    }

    public boolean isMovimentacaoManual() {
        return this.MovimentacaoManual;
    }

    public void setMovimentacaoManual(boolean MovimentacaoManual) {
        if (this.MovimentacaoManual != MovimentacaoManual) {
            this.MovimentacaoManual = MovimentacaoManual;
            if (this.MovimentacaoManual || this.Fixo == null || this.getMaster().IsMultSelecionado() || !this.Fixo.isEstaLigado()) {
                return;
            }
            this.DirectPosicione();
            this.Reposicione();
        }
    }

    public boolean isTamanhoAutmatico() {
        return this.TamanhoAutmatico;
    }

    public void setTamanhoAutmatico(boolean TamanhoAutmatico) {
        if (this.TamanhoAutmatico != TamanhoAutmatico) {
            this.TamanhoAutmatico = TamanhoAutmatico;
            this.InvalidateArea();
        }
    }

    @Override
    public void DoPaint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        if (this.TamanhoAutmatico) {
            int tamLetra = g.getFontMetrics(this.getFont()).stringWidth("M");
            int largura = g.getFontMetrics(this.getFont()).stringWidth(this.FullCard()) + tamLetra;
            int altura = g.getFontMetrics(this.getFont()).getHeight();
            if (this.getWidth() != largura || this.getHeight() != altura) {
                this.setStopRaize(true);
                this.setWidth(largura);
                this.setHeight(altura);
                this.setStopRaize(false);
                this.Posicione();
                if (this.isSelecionado()) {
                    this.Reposicione();
                }
            }
        }
        super.DoPaint(g);
    }

    @Override
    public void PinteTexto(Graphics2D g) {
        if (this.getMaster().getZoom() != this.z) {
            this.setTextoFormatado(null);
            this.z = this.getMaster().getZoom();
        }
        DesenhadorDeTexto txtf = this.getTextoFormatado();
        txtf.PinteTexto(g, this.getForeColor(), this.getArea(), this.FullCard());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        this.MovimentacaoManual = true;
    }

    public void Fixe(PontoDeLinha pt) {
        this.Fixo = pt;
        if (this.Fixo == null) {
            this.setVisible(false);
        }
        this.MovimentacaoManual = false;
    }

    public Linha getLigadoA() {
        return this.ligadoA;
    }

    public void setLigadoA(Linha ligadoA) {
        this.ligadoA = ligadoA;
    }

    @Override
    public boolean AskToDelete() {
        if (this.getLigadoA() != null) {
            if (this.getLigadoA().isSelecionado()) {
                return false;
            }
            return this.getMaster().Remove(this.getLigadoA(), false);
        }
        return super.AskToDelete();
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        GP = super.CompleteGenerateProperty(GP);
        if (this.getLigadoA() != null) {
            GP.add(InspectorProperty.PropertyFactoryTexto("cardinalidade.papel", "setPapel", this.getPapel()));
            GP.add(InspectorProperty.PropertyFactorySeparador("ligacoes"));
            String tmp = Editor.fromConfiguracao.getValor("Inspector.obj.diagrama.linha.nome");
            GP.add(InspectorProperty.PropertyFactoryActionSelect(tmp, tmp, String.valueOf(this.getLigadoA().getID())));
        }
        return GP;
    }

    @Override
    public boolean getIsLoadedFromXML() {
        return false;
    }

    @Override
    public boolean MostreSeParaExibicao(TreeItem root) {
        return false;
    }

    public static enum TiposCard {
        C11,
        C01,
        C1N,
        C0N;

    }
}

