/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.pattern;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.jfugue.midi.MidiDictionary;
import org.jfugue.parser.ParserListener;
import org.jfugue.pattern.Atom;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.pattern.Token;
import org.jfugue.pattern.TokenProducer;
import org.staccato.IVLSubparser;
import org.staccato.StaccatoParser;
import org.staccato.StaccatoParserPatternHelper;

public class Pattern
implements PatternProducer,
TokenProducer {
    protected StringBuilder patternSB = new StringBuilder();
    private int explicitVoice = -1;
    private int explicitLayer = -1;
    private int explicitInstrument = -1;
    private int explicitTempo = -1;
    private static final int UNDECLARED_EXPLICIT = -1;

    public Pattern() {
    }

    public Pattern(String string) {
        this();
        this.patternSB.append(string);
    }

    public Pattern(String ... strings) {
        this();
        for (String string : strings) {
            this.patternSB.append(string);
            this.patternSB.append(" ");
        }
    }

    public Pattern(PatternProducer ... producers) {
        this();
        this.add(producers);
    }

    public Pattern add(PatternProducer ... producers) {
        for (PatternProducer producer : producers) {
            this.add(producer.getPattern().toString());
        }
        return this;
    }

    public Pattern add(String string) {
        if (this.patternSB.length() > 0) {
            this.patternSB.append(" ");
        }
        this.patternSB.append(string);
        return this;
    }

    public Pattern add(PatternProducer producer, int repetitions) {
        for (int i = 0; i < repetitions; ++i) {
            this.add(producer);
        }
        return this;
    }

    public Pattern add(String string, int repetitions) {
        for (int i = 0; i < repetitions; ++i) {
            this.add(string);
        }
        return this;
    }

    public Pattern prepend(PatternProducer ... producers) {
        StringBuilder temp = new StringBuilder();
        for (PatternProducer producer : producers) {
            temp.append(producer.getPattern().toString());
            temp.append(" ");
        }
        this.prepend(temp.toString().trim());
        return this;
    }

    public Pattern prepend(String string) {
        if (this.patternSB.length() > 0) {
            this.patternSB.insert(0, " ");
        }
        this.patternSB.insert(0, string);
        return this;
    }

    public Pattern clear() {
        this.patternSB.delete(0, this.patternSB.length());
        return this;
    }

    public Pattern repeat(int n) {
        Pattern p2 = new Pattern();
        for (int i = 0; i < n; ++i) {
            p2.add(this.patternSB.toString());
        }
        this.patternSB = p2.patternSB;
        return this;
    }

    public Pattern atomize() {
        String[] currentLayer = new String[16];
        String[] currentInstrument = new String[16];
        List<Token> tokens = this.getTokens();
        String currentVoice = "V" + this.valueOrZero(this.explicitVoice);
        currentLayer[this.valueOrZero((int)this.explicitVoice)] = "L" + this.valueOrZero(this.explicitLayer);
        currentInstrument[this.valueOrZero((int)this.explicitVoice)] = "I" + this.valueOrZero(this.explicitInstrument);
        this.patternSB.delete(0, this.patternSB.length());
        this.explicitVoice = -1;
        this.explicitLayer = -1;
        this.explicitInstrument = -1;
        int voiceCounter = 0;
        block6: for (Token token : tokens) {
            String s = token.getPattern().toString();
            switch (token.getType()) {
                case VOICE: {
                    currentVoice = s;
                    voiceCounter = IVLSubparser.getInstance().getValue(currentVoice, null);
                    if (currentLayer[voiceCounter] == null) {
                        currentLayer[voiceCounter] = "L0";
                    }
                    if (currentInstrument[voiceCounter] != null) continue block6;
                    currentInstrument[voiceCounter] = "I0";
                    continue block6;
                }
                case LAYER: {
                    currentLayer[voiceCounter] = s;
                    continue block6;
                }
                case INSTRUMENT: {
                    currentInstrument[voiceCounter] = s;
                    continue block6;
                }
                case NOTE: {
                    this.add(new Atom(currentVoice, currentLayer[voiceCounter], currentInstrument[voiceCounter], s));
                    continue block6;
                }
            }
            this.add(s);
        }
        return this;
    }

    private int valueOrZero(int value) {
        return value == -1 ? 0 : value;
    }

    @Override
    public Pattern getPattern() {
        return this;
    }

    @Override
    public List<Token> getTokens() {
        StaccatoParserPatternHelper spph = new StaccatoParserPatternHelper();
        return spph.getTokens(this.getPattern());
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        if (this.explicitTempo != -1) {
            b2.append('T');
            b2.append(this.explicitTempo);
            b2.append(" ");
        }
        if (this.explicitVoice != -1) {
            b2.append('V');
            b2.append(this.explicitVoice);
            b2.append(" ");
        }
        if (this.explicitLayer != -1) {
            b2.append('L');
            b2.append(this.explicitVoice);
            b2.append(" ");
        }
        if (this.explicitInstrument != -1) {
            b2.append('I');
            b2.append("[");
            b2.append(MidiDictionary.INSTRUMENT_BYTE_TO_STRING.get((byte)this.explicitInstrument));
            b2.append("] ");
        }
        b2.append((CharSequence)this.patternSB);
        return b2.toString();
    }

    public Pattern setTempo(int explicitTempo) {
        this.explicitTempo = explicitTempo;
        return this;
    }

    public Pattern setTempo(String tempo) {
        if (!MidiDictionary.TEMPO_STRING_TO_INT.containsKey(tempo.toUpperCase())) {
            throw new RuntimeException("The tempo '" + tempo + "' is not recognized");
        }
        return this.setTempo(MidiDictionary.TEMPO_STRING_TO_INT.get(tempo.toUpperCase()));
    }

    public Pattern setVoice(int voice) {
        this.explicitVoice = voice;
        return this;
    }

    public Pattern setLayer(int layer) {
        this.explicitLayer = layer;
        return this;
    }

    public Pattern setInstrument(int instrument) {
        this.explicitInstrument = instrument;
        return this;
    }

    public Pattern setInstrument(String instrument) {
        if (!MidiDictionary.INSTRUMENT_STRING_TO_BYTE.containsKey(instrument.toUpperCase())) {
            throw new RuntimeException("The instrument '" + instrument + "' is not recognized");
        }
        return this.setInstrument(MidiDictionary.INSTRUMENT_STRING_TO_BYTE.get(instrument.toUpperCase()).byteValue());
    }

    public Pattern addToEachNoteToken(String decoratorString) {
        int currentDecorator = 0;
        String[] decorators = decoratorString.split(" ");
        StringBuilder b2 = new StringBuilder();
        List<Token> tokens = this.getTokens();
        for (Token token : tokens) {
            if (token.getType() == Token.TokenType.NOTE) {
                b2.append(token);
                b2.append(decorators[currentDecorator++ % decorators.length]);
            } else {
                b2.append(token);
            }
            b2.append(" ");
        }
        this.patternSB = new StringBuilder(b2.toString().trim());
        return this;
    }

    public Pattern save(File file) throws IOException {
        return this.save(file, new String[]{null});
    }

    public Pattern save(File file, String ... comments) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        if (comments.length > 0) {
            writer.write("# \n");
        }
        for (String comment : comments) {
            writer.write("# ");
            writer.write(comment);
            writer.write("\n");
        }
        if (comments.length > 0) {
            writer.write("# \n\n");
        }
        writer.write(this.toString());
        writer.close();
        return this;
    }

    public static Pattern load(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        Pattern pattern = new Pattern();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            pattern.add(line);
        }
        reader.close();
        return pattern;
    }

    public Pattern transform(ParserListener listener) {
        return this.parseAndListen(listener);
    }

    public Pattern measure(ParserListener listener) {
        return this.parseAndListen(listener);
    }

    private Pattern parseAndListen(ParserListener listener) {
        StaccatoParser parser = new StaccatoParser();
        parser.addParserListener(listener);
        parser.parse(this.getPattern());
        return this;
    }
}

