/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.midi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;

public class PatchProvider {
    private File soundbankFile;
    private boolean patchesProvided = false;
    private List<Patch> patches;
    public static final String STATUS_OK = "OK";
    public static final String STATUS_NO_SOUNDBANK_FILE = "PatchProvider has no soundbank file";
    public static final String STATUS_SOUNDBANK_NOT_SUPPORTED = "Soundbank not supported by synthesizer";

    public PatchProvider(File soundbankFile, int ... patchIndexes) {
        this.soundbankFile = soundbankFile;
        this.patches = new ArrayList<Patch>();
        for (int patchIndex : patchIndexes) {
            this.patches.add(new Patch(0, patchIndex));
        }
        this.patchesProvided = true;
    }

    public PatchProvider(File soundbankFile, List<Patch> patches) {
        this.soundbankFile = soundbankFile;
        this.patches = patches;
        this.patchesProvided = true;
    }

    public PatchProvider(File soundbankFile) {
        this.soundbankFile = soundbankFile;
        this.patchesProvided = false;
    }

    public File getSoundbankFile() {
        return this.soundbankFile;
    }

    public List<Patch> getPatches() {
        return this.patches;
    }

    public String loadPatchesIntoSynthesizer(Synthesizer synth) throws InvalidMidiDataException, IOException {
        if (this.getSoundbankFile() == null) {
            return STATUS_NO_SOUNDBANK_FILE;
        }
        Soundbank soundbank = MidiSystem.getSoundbank(this.getSoundbankFile());
        if (!synth.isSoundbankSupported(soundbank)) {
            return STATUS_SOUNDBANK_NOT_SUPPORTED;
        }
        if (this.patchesProvided) {
            synth.loadInstruments(soundbank, this.getPatches().toArray(new Patch[0]));
        } else {
            synth.loadAllInstruments(soundbank);
        }
        return STATUS_OK;
    }
}

