/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import org.jfugue.midi.MidiDictionary;
import org.jfugue.pattern.Token;
import org.staccato.StaccatoParserContext;
import org.staccato.StaccatoUtil;
import org.staccato.Subparser;

public class IVLSubparser
implements Subparser {
    public static final char INSTRUMENT = 'I';
    public static final char LAYER = 'L';
    public static final char VOICE = 'V';
    private static IVLSubparser instance;

    public static IVLSubparser getInstance() {
        if (instance == null) {
            instance = new IVLSubparser();
        }
        return instance;
    }

    @Override
    public boolean matches(String music) {
        return music.charAt(0) == 'V' || music.charAt(0) == 'I' || music.charAt(0) == 'L';
    }

    @Override
    public Token.TokenType getTokenType(String tokenString) {
        if (tokenString.charAt(0) == 'V') {
            return Token.TokenType.VOICE;
        }
        if (tokenString.charAt(0) == 'I') {
            return Token.TokenType.INSTRUMENT;
        }
        if (tokenString.charAt(0) == 'L') {
            return Token.TokenType.LAYER;
        }
        return Token.TokenType.UNKNOWN_TOKEN;
    }

    @Override
    public int parse(String music, StaccatoParserContext context) {
        if (this.matches(music)) {
            int posNextSpace = StaccatoUtil.findNextOrEnd(music, ' ', 0);
            byte value = -1;
            if (posNextSpace > 1) {
                value = this.getValue(music.substring(0, posNextSpace), context);
            }
            switch (music.charAt(0)) {
                case 'I': {
                    context.getParser().fireInstrumentParsed(value);
                    break;
                }
                case 'L': {
                    context.getParser().fireLayerChanged(value);
                    break;
                }
                case 'V': {
                    context.getParser().fireTrackChanged(value);
                    break;
                }
            }
            return posNextSpace + 1;
        }
        return 0;
    }

    public byte getValue(String ivl, StaccatoParserContext context) {
        String instrumentId = ivl.substring(1, ivl.length());
        if (instrumentId.matches("\\d+")) {
            return Byte.parseByte(instrumentId);
        }
        if (instrumentId.charAt(0) == '[') {
            instrumentId = instrumentId.substring(1, instrumentId.length() - 1);
        }
        return (Byte)context.getDictionary().get(instrumentId);
    }

    public static void populateContext(StaccatoParserContext context) {
        context.getDictionary().put("PERCUSSION", (byte)9);
        context.getDictionary().putAll(MidiDictionary.INSTRUMENT_STRING_TO_BYTE);
    }
}

