/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import org.jfugue.pattern.Token;
import org.staccato.ParenSpacesPreprocessor;
import org.staccato.StaccatoParserContext;
import org.staccato.StaccatoUtil;
import org.staccato.Subparser;
import org.staccato.SubparserFunction;
import org.staccato.functions.FunctionManager;

public class FunctionSubparser
implements Subparser {
    public static final char FUNCTION = ':';
    private static FunctionSubparser instance;

    public static FunctionSubparser getInstance() {
        if (instance == null) {
            instance = new FunctionSubparser();
        }
        return instance;
    }

    @Override
    public boolean matches(String music) {
        return music.charAt(0) == ':';
    }

    @Override
    public Token.TokenType getTokenType(String tokenString) {
        if (tokenString.charAt(0) == ':') {
            return Token.TokenType.FUNCTION;
        }
        return Token.TokenType.UNKNOWN_TOKEN;
    }

    @Override
    public int parse(String music, StaccatoParserContext context) {
        if (music.charAt(0) == ':') {
            int posOpenParen = StaccatoUtil.findNextOrEnd(music, '(', 0);
            int posCloseParen = StaccatoUtil.findNextOrEnd(music, ')', posOpenParen);
            String functionName = music.substring(1, posOpenParen);
            String params = music.substring(posOpenParen + 1, posCloseParen);
            params = ParenSpacesPreprocessor.unprocess(params);
            SubparserFunction function = FunctionManager.getInstance().getSubparserFunction(functionName);
            if (function != null) {
                context.getParser().fireFunctionParsed(functionName, params);
                function.apply(params, context);
            }
            return Math.min(posCloseParen + 1, music.length());
        }
        return 0;
    }

    public static String generateFunctionCall(String functionName, Object val) {
        StringBuilder buddy = new StringBuilder();
        buddy.append(':');
        buddy.append(functionName);
        buddy.append("(");
        FunctionSubparser.appendList(buddy, val.toString());
        buddy.append(")");
        return buddy.toString();
    }

    public static String generateFunctionCall(String functionName, byte ... vals) {
        StringBuilder buddy = new StringBuilder();
        buddy.append(':');
        buddy.append(functionName);
        buddy.append("(");
        FunctionSubparser.appendList(buddy, FunctionSubparser.getStringForPossibleArray(vals));
        buddy.append(")");
        return buddy.toString();
    }

    private static String getStringForPossibleArray(byte ... vals) {
        if (vals.length == 0) {
            return "";
        }
        StringBuilder bach = new StringBuilder();
        byte[] byArray = vals;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte val = byArray[i];
            bach.append(((Object)val).toString());
            bach.append(",");
        }
        return bach.substring(0, bach.length() - 1);
    }

    public static String generateParenParamIfNecessary(String functionId, String value) {
        StringBuilder buddy = new StringBuilder();
        buddy.append(functionId);
        if (value.indexOf(32) + value.indexOf(39) == -2) {
            buddy.append(value);
        } else {
            buddy.append("(");
            buddy.append(value);
            buddy.append(")");
        }
        return buddy.toString();
    }

    private static void appendList(StringBuilder buddy, Object ... vals) {
        for (int i = 0; i < vals.length - 1; ++i) {
            buddy.append(vals[i]);
            buddy.append(",");
        }
        buddy.append(vals[vals.length - 1]);
    }
}

