/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.theory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.jfugue.pattern.NoteProducer;
import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.pattern.ReplacementFormatUtil;
import org.jfugue.provider.NoteProviderFactory;
import org.jfugue.theory.Note;
import org.staccato.NoteSubparser;

public class Intervals
implements PatternProducer,
NoteProducer {
    private static Map<Integer, Integer> wholeNumberDegreeToHalfsteps = new HashMap<Integer, Integer>();
    private static Map<Integer, Integer> halfstepsToWholeNumberDegree;
    private String intervalPattern;
    private Note rootNote;
    private static java.util.regex.Pattern numberPattern;
    private String asSequence;
    private static String[] CANDIDATE_INTERVALS;

    public Intervals(String intervalPattern) {
        this.intervalPattern = intervalPattern;
    }

    public Intervals setRoot(String root) {
        return this.setRoot(NoteProviderFactory.getNoteProvider().createNote(root));
    }

    public Intervals setRoot(Note root) {
        this.rootNote = root;
        return this;
    }

    @Override
    public Pattern getPattern() {
        assert (this.rootNote != null);
        String[] intervals = this.intervalPattern.split(" ");
        int counter = 0;
        PatternProducer[] candidateNotes = new Note[intervals.length];
        for (String interval : intervals) {
            Note note = new Note((byte)(this.rootNote.getValue() + Intervals.getHalfsteps(interval)));
            candidateNotes[counter++] = note;
        }
        Pattern intervalNotes = new Pattern(candidateNotes);
        if (this.asSequence != null) {
            return ReplacementFormatUtil.replaceDollarsWithCandidates(this.asSequence, candidateNotes, intervalNotes);
        }
        return intervalNotes;
    }

    @Override
    public List<Note> getNotes() {
        ArrayList<Note> noteList = new ArrayList<Note>();
        Pattern pattern = this.getPattern();
        for (String split : pattern.toString().split(" ")) {
            if (!NoteSubparser.getInstance().matches(split)) continue;
            noteList.add(new Note(split));
        }
        return noteList;
    }

    public String getNthInterval(int n) {
        return this.intervalPattern.split(" ")[n];
    }

    public int size() {
        return this.intervalPattern.split(" ").length;
    }

    public static int getHalfsteps(String wholeNumberDegree) {
        return wholeNumberDegreeToHalfsteps.get(Intervals.getNumberPortionOfInterval(wholeNumberDegree)) + Intervals.calculateHalfstepDeltaFromFlatsAndSharps(wholeNumberDegree);
    }

    public int[] toHalfstepArray() {
        String[] intervals = this.intervalPattern.split(" ");
        int[] halfSteps = new int[intervals.length];
        for (int i = 0; i < intervals.length; ++i) {
            halfSteps[i] = Intervals.getHalfsteps(intervals[i]);
        }
        return halfSteps;
    }

    private static int calculateHalfstepDeltaFromFlatsAndSharps(String wholeNumberDegree) {
        int numHalfsteps = 0;
        for (char ch : wholeNumberDegree.toUpperCase().toCharArray()) {
            if (ch == 'B') {
                --numHalfsteps;
                continue;
            }
            if (ch != '#') continue;
            ++numHalfsteps;
        }
        return numHalfsteps;
    }

    private static int getNumberPortionOfInterval(String interval) {
        Matcher m = numberPattern.matcher(interval);
        if (m.find()) {
            return Integer.parseInt(m.group());
        }
        return 0;
    }

    public Intervals rotate(int n) {
        int i;
        String[] intervals = this.intervalPattern.split(" ");
        n %= intervals.length;
        StringBuilder buddy = new StringBuilder();
        for (i = 0; i < intervals.length - n; ++i) {
            buddy.append(intervals[n + i]);
            buddy.append(" ");
        }
        for (i = 0; i < n; ++i) {
            buddy.append(intervals[i]);
            buddy.append(" ");
        }
        this.intervalPattern = buddy.toString().trim();
        return this;
    }

    public boolean has(String note) {
        return this.has(NoteProviderFactory.getNoteProvider().createNote(note));
    }

    public boolean has(Note note) {
        if (this.rootNote == null) {
            return false;
        }
        for (String interval : this.intervalPattern.split(" ")) {
            int intervalValue = (this.rootNote.getValue() + Intervals.getHalfsteps(interval)) % 12;
            if (intervalValue != note.getPositionInOctave()) continue;
            return true;
        }
        return false;
    }

    public Intervals as(String asSequence) {
        this.asSequence = asSequence;
        return this;
    }

    public String toString() {
        return this.intervalPattern;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Intervals)) {
            return false;
        }
        return ((Intervals)o).toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static Intervals createIntervalsFromNotes(Pattern pattern) {
        return Intervals.createIntervalsFromNotes(pattern.toString());
    }

    public static Intervals createIntervalsFromNotes(String noteString) {
        String[] noteStrings = noteString.split(" ");
        Note[] notes = new Note[noteStrings.length];
        for (int i = 0; i < noteStrings.length; ++i) {
            notes[i] = NoteProviderFactory.getNoteProvider().createNote(noteStrings[i]);
        }
        return Intervals.createIntervalsFromNotes(notes);
    }

    public static Intervals createIntervalsFromNotes(Note[] notes) {
        StringBuilder buddy = new StringBuilder();
        buddy.append("1 ");
        for (int i = 1; i < notes.length; ++i) {
            int diff = 0;
            diff = notes[i].getPositionInOctave() < notes[0].getPositionInOctave() ? notes[i].getPositionInOctave() + 12 - notes[0].getPositionInOctave() : notes[i].getPositionInOctave() - notes[0].getPositionInOctave();
            if (!halfstepsToWholeNumberDegree.containsKey(diff)) {
                ++diff;
                buddy.append("b");
            }
            int wholeNumberDegree = halfstepsToWholeNumberDegree.get(diff);
            buddy.append(wholeNumberDegree);
            buddy.append(" ");
        }
        return new Intervals(buddy.toString().trim());
    }

    static {
        wholeNumberDegreeToHalfsteps.put(1, 0);
        wholeNumberDegreeToHalfsteps.put(2, 2);
        wholeNumberDegreeToHalfsteps.put(3, 4);
        wholeNumberDegreeToHalfsteps.put(4, 5);
        wholeNumberDegreeToHalfsteps.put(5, 7);
        wholeNumberDegreeToHalfsteps.put(6, 9);
        wholeNumberDegreeToHalfsteps.put(7, 11);
        wholeNumberDegreeToHalfsteps.put(8, 12);
        wholeNumberDegreeToHalfsteps.put(9, 14);
        wholeNumberDegreeToHalfsteps.put(10, 16);
        wholeNumberDegreeToHalfsteps.put(11, 17);
        wholeNumberDegreeToHalfsteps.put(12, 19);
        wholeNumberDegreeToHalfsteps.put(13, 21);
        wholeNumberDegreeToHalfsteps.put(14, 23);
        wholeNumberDegreeToHalfsteps.put(15, 24);
        halfstepsToWholeNumberDegree = new HashMap<Integer, Integer>();
        halfstepsToWholeNumberDegree.put(0, 1);
        halfstepsToWholeNumberDegree.put(2, 2);
        halfstepsToWholeNumberDegree.put(4, 3);
        halfstepsToWholeNumberDegree.put(5, 4);
        halfstepsToWholeNumberDegree.put(7, 5);
        halfstepsToWholeNumberDegree.put(9, 6);
        halfstepsToWholeNumberDegree.put(11, 7);
        halfstepsToWholeNumberDegree.put(12, 8);
        halfstepsToWholeNumberDegree.put(14, 9);
        halfstepsToWholeNumberDegree.put(16, 10);
        halfstepsToWholeNumberDegree.put(17, 11);
        halfstepsToWholeNumberDegree.put(19, 12);
        halfstepsToWholeNumberDegree.put(21, 13);
        halfstepsToWholeNumberDegree.put(23, 14);
        halfstepsToWholeNumberDegree.put(24, 15);
        numberPattern = java.util.regex.Pattern.compile("\\d+");
        CANDIDATE_INTERVALS = new String[]{"b1", "1", "#1", "b2", "2", "#2", "b3", "3", "#3", "b4", "4", "#4", "b5", "5", "#5", "b6", "6", "#6", "b7", "7", "#7", "b8", "8", "#8", "b9", "9", "#9", "b10", "10", "#10", "b11", "11", "#11", "b12", "12", "#12", "b13", "13", "#13", "b14", "14", "#14", "b15", "15", "#15"};
    }
}

