/*
 * Decompiled with CFR 0.152.
 */
package controlador;

import controlador.Configuer;
import controlador.Editor;
import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import util.BrLogger;
import util.TratadorDeImagens;

public class Acao
extends AbstractAction {
    private final Editor editor;
    private final Image icone;
    public boolean normal = true;
    public int IDX = 0;

    public Acao(Editor editor, String texto, String ico, String descricao, String command) {
        super(texto);
        this.editor = editor;
        ImageIcon ic = null;
        try {
            ic = Configuer.getImageIconFromResource(ico);
        }
        catch (Exception e) {
            BrLogger.Logger("ERROR_CREATE_ACAO", ico + "_" + e.getMessage());
        }
        if (ic != null) {
            this.icone = this.makeColorTransparent(ic.getImage(), Color.WHITE);
            ic = this.reescale(this.icone);
            String key = ico.substring("diagrama.".length(), ico.length() - 4);
            if (!editor.getControler().ImagemDeDiagrama.containsKey(key)) {
                editor.getControler().ImagemDeDiagrama.put(key, ic);
            }
            if (ico.startsWith("Controler.interface.Diagrama.Icone.")) {
                this.putValue("SwingLargeIconKey", ic);
            } else {
                this.putValue("SwingLargeIconKey", new ImageIcon(this.icone));
            }
            this.putValue("SmallIcon", ic);
        } else {
            this.icone = null;
        }
        this.putValue("ShortDescription", Editor.fromConfiguracao.getValor(descricao));
        this.putValue("Name", texto);
        this.putValue("ActionCommandKey", command);
    }

    public void Renomeie(String desc) {
        this.putValue("Name", Editor.fromConfiguracao.getValor(desc));
    }

    private Image makeColorTransparent(Image im, Color color) {
        return TratadorDeImagens.makeColorTransparent(im, color);
    }

    private ImageIcon reescale(Image img) {
        Image newimg = img.getScaledInstance(16, 16, 4);
        return new ImageIcon(newimg);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.normal) {
            this.editor.DoAction(ev);
        } else {
            this.editor.DoActionExtender(ev);
        }
    }
}

