/*
 * Decompiled with CFR 0.152.
 */
package desenho.formas;

import controlador.Diagrama;
import desenho.formas.FormaNaoRetangularBase;
import desenho.linhas.PontoDeLinha;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;

public class FormaLosangular
extends FormaNaoRetangularBase {
    private static final long serialVersionUID = 8855549220259709835L;
    protected Point[] SubPointos = null;

    public FormaLosangular(Diagrama modelo) {
        super(modelo);
        this.setTipo(FormaNaoRetangularBase.TipoDePontos.tp4Pontos);
    }

    public FormaLosangular(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.setTipo(FormaNaoRetangularBase.TipoDePontos.tp4Pontos);
    }

    @Override
    public Shape getRegiao() {
        if (this.Regiao == null) {
            Rectangle r = new Rectangle(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
            Polygon los = new Polygon();
            los.addPoint(r.x, r.y + r.height / 2);
            los.addPoint(r.x + r.width / 2, r.y);
            los.addPoint(r.x + r.width, r.y + r.height / 2);
            los.addPoint(r.x + r.width / 2, r.y + r.height);
            this.Regiao = los;
        }
        return this.Regiao;
    }

    public Point[] getAllSubPoints() {
        this.calculePontos();
        return this.SubPointos;
    }

    @Override
    protected void calculePontos() {
        if (!this.needRecalPts) {
            return;
        }
        super.calculePontos();
        int x = this.pontoPosi6.x - this.pontoPosi3.x;
        int y = this.pontoPosi3.y - this.pontoPosi7.y;
        int tam = x / 3;
        int nvX1 = x - tam;
        int nvX2 = nvX1 - tam;
        tam = y / 3;
        int nvY2 = y - tam;
        int nvY1 = nvY2 - tam;
        this.SubPointos = new Point[12];
        this.SubPointos[0] = this.pontoPosi7;
        this.SubPointos[1] = this.pontoPosi4;
        this.SubPointos[2] = this.pontoPosi5;
        this.SubPointos[3] = this.pontoPosi6;
        this.SubPointos[4] = new Point(nvX2 + this.pontoPosi0.x, nvY2 + this.pontoPosi0.y);
        this.SubPointos[5] = new Point(nvX1 + this.pontoPosi0.x, nvY1 + this.pontoPosi0.y);
        this.SubPointos[6] = new Point(nvX1 + this.pontoPosi4.x, nvY2 + this.pontoPosi1.y);
        this.SubPointos[7] = new Point(nvX2 + this.pontoPosi6.x, nvY2 + this.pontoPosi5.y);
        this.SubPointos[11] = new Point(nvX1 + this.pontoPosi7.x, nvY2 + this.pontoPosi7.y);
        this.SubPointos[9] = new Point(nvX2 + this.pontoPosi4.x, nvY1 + this.pontoPosi1.y);
        this.SubPointos[10] = new Point(nvX1 + this.pontoPosi6.x, nvY1 + this.pontoPosi5.y);
        this.SubPointos[8] = new Point(nvX2 + this.pontoPosi7.x, nvY1 + this.pontoPosi7.y);
    }

    @Override
    protected void Posicione4Pontos(PontoDeLinha ponto) {
        Point centro = ponto.getCentro();
        Point[] ll = this.getAllSubPoints();
        int mx = this.retorneProximidade(centro, ll);
        ponto.setCentro(ll[mx]);
        if (mx > 3) {
            mx -= 4;
        }
        if (mx > 3) {
            mx -= 4;
        }
        ponto.setLado(mx);
    }

    @Override
    protected void DoPaintDoks(Graphics2D g) {
        Point[] pts = this.getAllSubPoints();
        Paint bkpP = g.getPaint();
        g.setPaint(Color.orange);
        for (Point pt : pts) {
            g.fillRect(pt.x - 2, pt.y - 2, 4, 4);
        }
        g.setPaint(bkpP);
    }
}

