/*
 * Decompiled with CFR 0.152.
 */
package desenho.formas;

import controlador.Controler;
import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.Elementar;
import desenho.ElementarListener;
import desenho.FormaElementar;
import desenho.formas.DimensionadorArea;
import desenho.formas.Forma;
import desenho.linhas.SuperLinha;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util.BrLogger;
import util.DesenhadorDeTexto;
import util.XMLGenerate;

public class FormaArea
extends Forma {
    private static final long serialVersionUID = 4366780837704194852L;
    private ArrayList<DimensionadorArea> regioes = new ArrayList();
    private transient int alturaTexto = 20;
    private boolean dashed = false;
    private boolean gradiente = true;
    private Color gradienteEndColor = Color.white;
    private Color gradienteStartColor = Color.LIGHT_GRAY;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private int gdirecao = 1;
    private float alfa = 0.4f;
    private transient double z = 0.0;
    private String areaDefault = Editor.fromConfiguracao.getValor("Inspector.obj.formaarea.area.default");
    private boolean autoCapture = true;
    private boolean moverSubs = true;

    public FormaArea(Diagrama modelo) {
        super(modelo);
    }

    public FormaArea(Diagrama modelo, String texto) {
        super(modelo, texto);
    }

    public int getLocalDaLinha(DimensionadorArea aThis) {
        int res = this.getLeft();
        for (DimensionadorArea fr : this.getRegioes()) {
            res += fr.getLargura();
            if (fr == aThis) {
                return res;
            }
            res += fr.getWidth();
        }
        return res;
    }

    public ArrayList<DimensionadorArea> getRegioes() {
        return this.regioes;
    }

    public void AddRegiao(int largura) {
        DimensionadorArea nr = new DimensionadorArea(this);
        nr.setLargura(largura);
        this.getRegioes().add(nr);
        this.RePosicioneRegioes();
        nr.setTexto(this.NomeieDimensoes());
        this.DoMuda();
        this.InvalidateArea();
    }

    public DimensionadorArea AddRegiao() {
        DimensionadorArea nr = new DimensionadorArea(this);
        this.getRegioes().add(nr);
        return nr;
    }

    public void Remova(DimensionadorArea regiao) {
        this.getRegioes().remove(regiao);
        this.RemoveSubItem(regiao);
        this.getMaster().setCursor(new Cursor(0));
        this.RePosicioneRegioes();
        this.DoMuda();
        this.InvalidateArea();
    }

    @Override
    public void mouseDblClicked(MouseEvent e) {
        this.AdicionarSubItem(-1);
    }

    public int getAlturaTexto() {
        return this.alturaTexto;
    }

    @Override
    public void DoPaint(Graphics2D g) {
        g.setFont(this.getFont());
        int larg = this.getMaster().getPontoWidth();
        this.alturaTexto = g.getFontMetrics().getHeight();
        this.alturaTexto += this.alturaTexto / 2;
        int top = this.getTop() + this.alturaTexto;
        int lastlarg = 2 + this.getLeft();
        this.PaintGradiente(g);
        boolean excesso = false;
        for (DimensionadorArea regiao : this.getRegioes()) {
            int x = this.getLocalDaLinha(regiao);
            if (x < this.getLeftWidth() - 2 && x > this.getLeft()) {
                x += larg / 2;
                Stroke bkps = g.getStroke();
                if (this.isDashed()) {
                    g.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
                }
                g.setColor(this.getForeColor());
                g.drawLine(x, top + 1, x, this.getTopHeight() - 2);
                if (this.isDashed()) {
                    g.setStroke(bkps);
                }
                DesenhadorDeTexto dz = new DesenhadorDeTexto(regiao.getTexto(), this.getFont(), true);
                dz.LimitarAreaDePintura = true;
                dz.PinteTexto(g, this.getForeColor(), new Rectangle(x - regiao.getLargura(), top + 1, regiao.getLargura(), this.alturaTexto - 2), regiao.getTexto());
                lastlarg = x;
                continue;
            }
            excesso = true;
            break;
        }
        DesenhadorDeTexto dz = new DesenhadorDeTexto(excesso ? "... " + this.areaDefault : this.areaDefault, this.getFont(), true);
        dz.LimitarAreaDePintura = true;
        dz.PinteTexto(g, this.getForeColor(), new Rectangle(lastlarg, top + 1, this.getLeftWidth() - lastlarg, this.alturaTexto - 2), excesso ? "... " + this.areaDefault : this.areaDefault);
        Stroke bkps = g.getStroke();
        if (this.isDashed()) {
            g.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
        }
        g.drawLine(this.getLeft(), top - 1 + this.alturaTexto, this.getLeftWidth(), top - 1 + this.alturaTexto);
        g.setStroke(bkps);
        super.DoPaint(g);
    }

    protected void PaintGradiente(Graphics2D g) {
        Paint bkp = g.getPaint();
        int dist = 2;
        int W = this.getWidth() - dist;
        int H = 2 * this.alturaTexto - 1 - dist;
        boolean dv = this.getGDirecao() == 0;
        Composite originalComposite = g.getComposite();
        int type = 3;
        g.setComposite(AlphaComposite.getInstance(type, this.alfa));
        Stroke bkps = g.getStroke();
        if (this.isDashed()) {
            g.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
        }
        int w = this.getWidth() - dist;
        int h = this.getHeight() - dist;
        int L = this.getLeft();
        int T = this.getTop();
        GradientPaint GP = new GradientPaint(L, T, this.getGradienteStartColor(), dv ? (float)L : (float)(L + w), dv ? (float)(T + h) : (float)T, this.getGradienteEndColor(), true);
        g.setPaint(GP);
        g.fillRect(this.getLeft() + 1, this.getTop() + 1, W, H);
        g.setComposite(originalComposite);
        g.setPaint(bkp);
        g.setStroke(bkps);
    }

    public boolean isDashed() {
        return this.dashed;
    }

    public void setDashed(boolean dasehd) {
        if (this.dashed != dasehd) {
            this.dashed = dasehd;
            this.DoMuda();
            this.InvalidateArea();
        }
    }

    public Color getGradienteStartColor() {
        return this.isDisablePainted() ? this.disabledColor : this.gradienteStartColor;
    }

    public void setGradienteStartColor(Color gradienteStartColor) {
        this.gradienteStartColor = gradienteStartColor;
        this.InvalidateArea();
    }

    public boolean isGradiente() {
        return this.gradiente;
    }

    public void setGradiente(boolean gradiente) {
        this.gradiente = gradiente;
        this.InvalidateArea();
    }

    public Color getGradienteEndColor() {
        return this.isDisablePainted() ? this.disabledColor : this.gradienteEndColor;
    }

    public void setGradienteEndColor(Color gradienteEndColor) {
        this.gradienteEndColor = gradienteEndColor;
        this.InvalidateArea();
    }

    public float getAlfa() {
        return this.alfa;
    }

    public void setAlfa(float alfa) {
        this.alfa = alfa;
    }

    public void SetAlfa(int alfa) {
        this.alfa = (float)alfa / 100.0f;
        if (this.alfa > 1.0f) {
            this.alfa = 0.5f;
        }
        this.InvalidateArea();
    }

    public int getGDirecao() {
        return this.gdirecao;
    }

    public void setGDirecao(int aDirection) {
        this.gdirecao = aDirection;
        this.InvalidateArea();
    }

    @Override
    public void reSetBounds() {
        super.reSetBounds();
        this.RePosicioneRegioes();
    }

    public void RePosicioneRegioes() {
        this.HideDimensionador(true);
    }

    public boolean EmAreaVisivel(DimensionadorArea regiao) {
        return regiao.getLeft() < this.getLeftWidth() - 2 && regiao.getLeft() > this.getLeft();
    }

    public void HideDimensionador(boolean mostar) {
        for (DimensionadorArea regiao : this.getRegioes()) {
            if (mostar) {
                regiao.Posicione();
                if (this.EmAreaVisivel(regiao)) {
                    regiao.setVisible(mostar);
                    continue;
                }
                regiao.setVisible(false);
                continue;
            }
            regiao.setVisible(mostar);
        }
    }

    @Override
    public void setSelecionado(boolean selecionado) {
        super.setSelecionado(selecionado);
        this.HideDimensionador(this.isSelecionado());
    }

    @Override
    public DesenhadorDeTexto getTextoFormatado() {
        DesenhadorDeTexto dz = super.getTextoFormatado();
        dz.setCentrarTextoVertical(false);
        dz.LimitarAreaDePintura = true;
        dz.CorretorPosicao = new Point(0, 6);
        return dz;
    }

    @Override
    public void PinteTexto(Graphics2D g) {
        if (this.getMaster().getZoom() != this.z) {
            this.setTextoFormatado(null);
            this.z = this.getMaster().getZoom();
        }
        Rectangle r = this.getArea();
        r = new Rectangle(r.x, r.y, r.width, this.alturaTexto);
        this.getTextoFormatado().PinteTexto(g, this.getForeColor(), r, this.getTexto());
    }

    public String getAreaDefault() {
        return this.areaDefault;
    }

    public void setAreaDefault(String areaDefault) {
        this.areaDefault = areaDefault;
        this.InvalidateArea();
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        return res;
    }

    public void SetDimensaoTexto(String txt) {
        if (this.getMaster().getEditor().getInspectorEditor().getSelecionado() == null) {
            return;
        }
        int tag = this.getMaster().getEditor().getInspectorEditor().getSelecionado().getTag();
        DimensionadorArea dime = this.getRegioes().get(tag);
        dime.setTexto(txt);
        this.InvalidateArea();
    }

    public void SetDimensaoLargura(int larg) {
        if (this.getMaster().getEditor().getInspectorEditor().getSelecionado() == null) {
            return;
        }
        int tag = this.getMaster().getEditor().getInspectorEditor().getSelecionado().getTag();
        DimensionadorArea dime = this.getRegioes().get(tag);
        dime.setLargura(larg);
        this.RePosicioneRegioes();
        this.InvalidateArea();
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorBoolean(doc, "MoverSubs", this.isMoverSubs()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "autoCapture", this.isAutoCapture()));
        me.appendChild(XMLGenerate.ValorString(doc, "areaDefault", this.getAreaDefault()));
        Element dime = doc.createElement("Dimensoes");
        this.getRegioes().forEach(c -> c.ToXmlValores(doc, dime));
        me.appendChild(dime);
        this.SerializeListener(doc, me);
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Dashed", this.isDashed()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteStartColor", this.getGradienteStartColor()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteEndColor", this.getGradienteEndColor()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "GDirecao", this.getGDirecao()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Alfa", (int)(100.0f * this.getAlfa())));
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        int l;
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        this.setAreaDefault(XMLGenerate.getValorStringFrom(me, "areaDefault"));
        this.setMoverSubs(XMLGenerate.getValorBooleanFrom(me, "MoverSubs"));
        this.setAutoCapture(XMLGenerate.getValorBooleanFrom(me, "autoCapture"));
        NodeList ptLst = me.getElementsByTagName("Dimensoes");
        Element pontos = (Element)ptLst.item(0);
        ptLst = pontos.getChildNodes();
        for (int i = 0; i < ptLst.getLength(); ++i) {
            Node tmp = ptLst.item(i);
            if (tmp.getNodeType() != 1) continue;
            DimensionadorArea c = this.AddRegiao();
            c.LoadFromXML((Element)ptLst.item(i), colando);
        }
        this.setDashed(XMLGenerate.getValorBooleanFrom(me, "Dashed"));
        Color c = XMLGenerate.getValorColorFrom(me, "GradienteStartColor");
        if (c != null) {
            this.setGradienteStartColor(c);
        }
        if ((c = XMLGenerate.getValorColorFrom(me, "GradienteEndColor")) != null) {
            this.setGradienteEndColor(c);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "GDirecao")) != -1) {
            this.setGDirecao(l);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "Alfa")) != -1) {
            this.SetAlfa(l);
        }
        return true;
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        ArrayList<InspectorProperty> res = GP;
        res.add(InspectorProperty.PropertyFactorySeparador("texto.gradiente"));
        GP.add(InspectorProperty.PropertyFactorySN("linha.dashed", "setDashed", this.isDashed()));
        GP.add(InspectorProperty.PropertyFactoryNumero("diagrama.detalhe.alfa", "SetAlfa", (int)(100.0f * this.getAlfa())));
        res.add(InspectorProperty.PropertyFactoryCor("texto.gradiente.startcor", "setGradienteStartColor", this.getGradienteStartColor()));
        res.add(InspectorProperty.PropertyFactoryCor("texto.gradiente.endcor", "setGradienteEndColor", this.getGradienteEndColor()));
        res.add(InspectorProperty.PropertyFactoryMenu("texto.gradiente.direcao", "setGDirecao", this.getGDirecao(), Editor.fromConfiguracao.getLstDirecao(Controler.Comandos.cmdTexto)));
        ArrayList<FormaElementar> overme = this.WhoIsOverMe();
        res.add(InspectorProperty.PropertyFactorySeparador("formaarea.overme"));
        res.add(InspectorProperty.PropertyFactorySN("formaarea.movesubs", "setMoverSubs", this.isMoverSubs()));
        res.add(InspectorProperty.PropertyFactorySN("formaarea.autocapture", "setAutoCapture", this.isAutoCapture()));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "formaarea.capture").setTag(99));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "formaarea.uncapture").setTag(-99));
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("formaarea.capturados", String.valueOf(overme.size())));
        if (!overme.isEmpty()) {
            res.add(InspectorProperty.PropertyFactorySeparador("formaarea.capturados", true));
            overme.stream().filter(dime -> dime instanceof Forma).map(dime -> (Forma)dime).forEach(f -> res.add(InspectorProperty.PropertyFactoryActionSelect(Editor.fromConfiguracao.getValor("diagrama." + Editor.getClassTexto(f) + ".nome"), f.getTexto(), String.valueOf(((FormaElementar)f.getPrincipal()).getID()))));
        }
        res.add(InspectorProperty.PropertyFactorySeparador("formaarea.area", true));
        res.add(InspectorProperty.PropertyFactoryTexto("formaarea.area.default", "setAreaDefault", this.getAreaDefault()));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdAdicionarSubItem.name()).setTag(-1));
        int i = 0;
        for (DimensionadorArea dime2 : this.getRegioes()) {
            res.add(InspectorProperty.PropertyFactorySeparador("formaarea.area", true));
            res.add(InspectorProperty.PropertyFactoryTexto("formaarea.area", "SetDimensaoTexto", dime2.getTexto()).setTag(i));
            res.add(InspectorProperty.PropertyFactoryNumero("formaarea.largura", "SetDimensaoLargura", dime2.getLargura()).setTag(i));
            res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdExcluirSubItem.name()).setTag(i));
            ++i;
        }
        return super.CompleteGenerateProperty(GP);
    }

    public boolean isAutoCapture() {
        return this.autoCapture;
    }

    public void setAutoCapture(boolean autoCapture) {
        this.autoCapture = autoCapture;
    }

    @Override
    public boolean IsMe(Point p) {
        boolean s = super.IsMe(p);
        return s && p.y <= this.getTop() + 2 * this.alturaTexto - 1;
    }

    @Override
    public void DoPontoCor(boolean verde) {
        super.DoPontoCor(verde);
        Color cor = verde ? this.getMaster().getPontoCorMultSel() : this.getMaster().getPontoCor();
        this.getRegioes().forEach(dim -> dim.setBackColor(cor));
    }

    @Override
    public void HidePontos(boolean esconde) {
        super.HidePontos(esconde);
        this.getRegioes().forEach(dim -> dim.setIsHide(esconde));
    }

    @Override
    public void Reposicione() {
        super.Reposicione();
        this.RePosicioneRegioes();
    }

    private String NomeieDimensoes() {
        String txt = Editor.fromConfiguracao.getValor("Inspector.obj.formaarea.area");
        int res = 1;
        ArrayList<String> txts = new ArrayList<String>();
        txts.add(this.areaDefault);
        this.getRegioes().forEach(el -> txts.add(el.getTexto()));
        while (txts.indexOf(txt + "_" + res) != -1) {
            ++res;
        }
        return txt + "_" + res;
    }

    @Override
    public void ExcluirSubItem(int idx) {
        super.ExcluirSubItem(idx);
        try {
            this.Remova(this.getRegioes().get(idx));
        }
        catch (Exception e) {
            BrLogger.Logger("MSG-EXCLUIR_SUBITEM", e.getMessage());
        }
    }

    @Override
    public void AdicionarSubItem(int idx) {
        this.AddRegiao(Math.max(this.getWidth() / (this.getRegioes().size() + 2), 20));
    }

    public boolean isMoverSubs() {
        return this.moverSubs;
    }

    public void setMoverSubs(boolean moverSubs) {
        this.moverSubs = moverSubs;
    }

    @Override
    public void DoMove(int movX, int movY) {
        if (!this.isMoverSubs()) {
            super.DoMove(movX, movY);
            return;
        }
        ArrayList<FormaElementar> overme = this.WhoIsOverMe();
        overme.stream().filter(el -> !el.isSelecionado() && el.isVisible() && this.IsThatOverAndCanMove((FormaElementar)el)).forEach(el -> el.DoMove(movX, movY));
        overme.stream().filter(item -> !item.Reenquadre()).forEach(item -> item.Reposicione());
        super.DoMove(movX, movY);
    }

    public boolean IsThatOverAndCanMove(FormaElementar el) {
        Point r = el.getLocation();
        Point lr = this.getLocation();
        return r.x > lr.x && r.y > lr.y && el.getLeftWidth() < this.getLeftWidth() && el.getTopHeight() < this.getTopHeight();
    }

    public boolean IsThatOverAndCanCapture(FormaElementar el) {
        Point r = el.getLocation();
        Point lr = this.getLocation();
        return r.x > lr.x && r.y > lr.y && el.getLeftWidth() < this.getLeftWidth() && el.getTopHeight() < this.getTopHeight() && !(el instanceof SuperLinha);
    }

    public void comandoCaptureOverMe() {
        this.comandoUnCapture();
        this.getMaster().getListaDeItens().stream().filter(el -> el != this && el.isVisible() && this.IsThatOverAndCanCapture((FormaElementar)el)).forEach(el -> this.Capture((FormaElementar)el));
    }

    public void comandoUnCapture() {
        ArrayList<FormaElementar> overme = this.WhoIsOverMe();
        overme.forEach(el -> this.PerformLigacao((Elementar)el, false));
    }

    private void Capture(FormaElementar el) {
        if (el.getListeners() != null) {
            int i = 0;
            while (i < el.getListeners().size()) {
                ElementarListener lig = el.getListeners().get(i);
                if (lig instanceof FormaArea) {
                    FormaArea tmp = (FormaArea)lig;
                    el.PerformLigacao(tmp, false);
                    continue;
                }
                ++i;
            }
        }
        this.PerformLigacao(el, true);
    }

    public void TestAndCapture(FormaElementar el) {
        if (!this.IsThatOverAndCanCapture(el)) {
            return;
        }
        this.PerformLigacao(el, false);
        if (el.getListeners() != null) {
            int i = 0;
            while (i < el.getListeners().size()) {
                ElementarListener lig = el.getListeners().get(i);
                if (lig instanceof FormaArea) {
                    FormaArea tmp = (FormaArea)lig;
                    el.PerformLigacao(tmp, false);
                    continue;
                }
                ++i;
            }
        }
        this.PerformLigacao(el, true);
    }

    @Override
    public void DoAnyThing(int Tag) {
        super.DoAnyThing(Tag);
        if (Tag == 99) {
            this.comandoCaptureOverMe();
        } else if (Tag == -99) {
            this.comandoUnCapture();
        }
    }

    private ArrayList<FormaElementar> WhoIsOverMe() {
        ArrayList<FormaElementar> overme = new ArrayList<FormaElementar>();
        if (this.getListeners() != null) {
            for (int i = 0; i < this.getListeners().size(); ++i) {
                ElementarListener lig = this.getListeners().get(i);
                if (!(lig instanceof FormaElementar)) continue;
                overme.add((FormaElementar)lig);
            }
        }
        return overme;
    }

    @Override
    public boolean CommitXML(Element me, HashMap<Element, FormaElementar> mapa) {
        this.UnSerializeListener(me, mapa);
        return super.CommitXML(me, mapa);
    }
}

