/*
 * Decompiled with CFR 0.152.
 */
package controlador.editores;

import controlador.Controler;
import controlador.Editor;
import controlador.apoios.PainelPintador;
import controlador.inspector.Inspector;
import controlador.inspector.InspectorDicas;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import desenho.preDiagrama.baseDrawerItem;
import desenho.preDiagrama.iBaseDrawer;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import util.BrLogger;
import util.Dialogos;
import util.Utilidades;

public class DrawerEditor
extends JDialog
implements Editor.iParaOutrosInspectors {
    private Editor omaster = null;
    private iBaseDrawer Item = null;
    baseDrawerItem Selecionado = null;
    private JList Lista;
    private JButton btnDescer;
    private JButton btnDuplique;
    private JButton btnExcluir;
    private JButton btnNovo;
    private JButton btnPronto;
    private JButton btnSubir;
    private Inspector inspector1;
    private InspectorDicas inspectorDicas1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane3;
    private JToolBar jToolBar1;
    private PainelPintador painelPintador1;

    public DrawerEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.inspector1.setDicas(this.inspectorDicas1);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.btnNovo = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.btnDuplique = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.btnExcluir = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.btnSubir = new JButton();
        this.btnDescer = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.Lista = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.painelPintador1 = new PainelPintador();
        this.jSplitPane3 = new JSplitPane();
        this.inspector1 = new Inspector();
        this.inspectorDicas1 = new InspectorDicas();
        this.jPanel1 = new JPanel();
        this.btnPronto = new JButton();
        this.setDefaultCloseOperation(2);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        ResourceBundle bundle = ResourceBundle.getBundle("principal/Formularios_pt_BR");
        this.btnNovo.setText(bundle.getString("DrawerEditor.Novo"));
        this.btnNovo.setFocusable(false);
        this.btnNovo.setHorizontalTextPosition(0);
        this.btnNovo.setVerticalTextPosition(3);
        this.btnNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrawerEditor.this.btnNovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnNovo);
        this.jToolBar1.add(this.jSeparator2);
        this.btnDuplique.setText(bundle.getString("DrawerEditor.Duplique"));
        this.btnDuplique.setFocusable(false);
        this.btnDuplique.setHorizontalTextPosition(0);
        this.btnDuplique.setVerticalTextPosition(3);
        this.btnDuplique.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrawerEditor.this.btnDupliqueActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnDuplique);
        this.jToolBar1.add(this.jSeparator3);
        this.btnExcluir.setText(bundle.getString("DrawerEditor.Excluir"));
        this.btnExcluir.setFocusable(false);
        this.btnExcluir.setHorizontalTextPosition(0);
        this.btnExcluir.setVerticalTextPosition(3);
        this.btnExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrawerEditor.this.btnExcluirActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnExcluir);
        this.jToolBar1.add(this.jSeparator1);
        this.btnSubir.setIcon(new ImageIcon(this.getClass().getResource("/imagens/up.png")));
        this.btnSubir.setFocusable(false);
        this.btnSubir.setHorizontalTextPosition(0);
        this.btnSubir.setVerticalTextPosition(3);
        this.btnSubir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrawerEditor.this.btnSubirActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnSubir);
        this.btnDescer.setIcon(new ImageIcon(this.getClass().getResource("/imagens/down.png")));
        this.btnDescer.setFocusable(false);
        this.btnDescer.setHorizontalTextPosition(0);
        this.btnDescer.setVerticalTextPosition(3);
        this.btnDescer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrawerEditor.this.btnDescerActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnDescer);
        this.jSplitPane1.setDividerLocation(360);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane2.setOrientation(0);
        this.jScrollPane1.setMinimumSize(new Dimension(35, 130));
        this.Lista.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.Lista);
        this.jSplitPane2.setTopComponent(this.jScrollPane1);
        GroupLayout painelPintador1Layout = new GroupLayout(this.painelPintador1);
        this.painelPintador1.setLayout(painelPintador1Layout);
        painelPintador1Layout.setHorizontalGroup(painelPintador1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 345, Short.MAX_VALUE));
        painelPintador1Layout.setVerticalGroup(painelPintador1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 205, Short.MAX_VALUE));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.painelPintador1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.painelPintador1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane2.setViewportView(this.jPanel3);
        this.jSplitPane2.setRightComponent(this.jScrollPane2);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2));
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.jSplitPane3.setOrientation(0);
        this.jSplitPane3.setResizeWeight(1.0);
        this.jSplitPane3.setTopComponent(this.inspector1);
        GroupLayout inspectorDicas1Layout = new GroupLayout(this.inspectorDicas1);
        this.inspectorDicas1.setLayout(inspectorDicas1Layout);
        inspectorDicas1Layout.setHorizontalGroup(inspectorDicas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 207, Short.MAX_VALUE));
        inspectorDicas1Layout.setVerticalGroup(inspectorDicas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.jSplitPane3.setRightComponent(this.inspectorDicas1);
        this.jSplitPane1.setRightComponent(this.jSplitPane3);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.btnPronto.setText(bundle.getString("DrawerEditor.Pronto"));
        this.btnPronto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrawerEditor.this.btnProntoActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnPronto).addGap(2, 2, 2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.btnPronto)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane1, -1, 692, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addGap(0, 0, 0).addComponent(this.jSplitPane1).addGap(0, 0, 0).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void btnProntoActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void btnNovoActionPerformed(ActionEvent evt) {
        int idx = this.Lista.getSelectedIndex();
        this.Item.AddItem();
        this.PopuleLista();
        this.Lista.setSelectedIndex(idx);
        this.painelPintador1.repaint();
        this.Item.DoMuda();
        this.Item.InvalidateArea();
    }

    private void btnExcluirActionPerformed(ActionEvent evt) {
        int idx = this.Lista.getSelectedIndex();
        this.Item.getItens().remove(this.Selecionado);
        this.PopuleLista();
        if (idx < this.Lista.getModel().getSize()) {
            this.Lista.setSelectedIndex(idx);
        } else if (this.Lista.getModel().getSize() > 0) {
            this.Lista.setSelectedIndex(this.Lista.getModel().getSize() - 1);
        } else {
            this.Lista.setSelectedIndex(-1);
        }
        this.Item.InvalidateArea();
        this.Item.DoMuda();
    }

    private void btnSubirActionPerformed(ActionEvent evt) {
        int idx = this.Lista.getSelectedIndex();
        if (idx > 0) {
            int nv = idx - 1;
            this.Item.getItens().remove(this.Selecionado);
            this.Item.getItens().add(nv, this.Selecionado);
            this.PopuleLista();
            this.Lista.setSelectedIndex(nv);
            this.Item.InvalidateArea();
            this.Item.DoMuda();
        }
    }

    private void btnDescerActionPerformed(ActionEvent evt) {
        int idx = this.Lista.getSelectedIndex();
        if (idx < this.Lista.getModel().getSize()) {
            int nv = idx + 1;
            this.Item.getItens().remove(this.Selecionado);
            this.Item.getItens().add(nv, this.Selecionado);
            this.PopuleLista();
            this.Lista.setSelectedIndex(nv);
            this.Item.InvalidateArea();
            this.Item.DoMuda();
        }
    }

    private void btnDupliqueActionPerformed(ActionEvent evt) {
        int idx = this.Lista.getSelectedIndex();
        this.Item.AddItem().Clone(this.Selecionado);
        this.PopuleLista();
        this.Lista.setSelectedIndex(idx);
        this.painelPintador1.repaint();
        this.Item.DoMuda();
        this.Item.InvalidateArea();
    }

    @Override
    public boolean AceitaEdicao(InspectorProperty propriedade, String valor) {
        try {
            switch (propriedade.property) {
                case "SetTipo": {
                    this.Selecionado.SetTipo(Integer.valueOf(valor));
                    DefaultListModel dlm = (DefaultListModel)this.Lista.getModel();
                    dlm.set(this.Lista.getSelectedIndex(), Integer.toString(this.Lista.getSelectedIndex()) + " " + Editor.fromConfiguracao.getValor("Inspector.lst.basedraweritem." + this.Selecionado.getTipo().name().toLowerCase()));
                    break;
                }
                case "setPath": {
                    this.Selecionado.setPath(valor);
                    break;
                }
                case "setFill": {
                    this.Selecionado.setFill(Boolean.valueOf(valor));
                    break;
                }
                case "setRecivePaint": {
                    this.Selecionado.setRecivePaint(Boolean.valueOf(valor));
                    break;
                }
                case "setCor": {
                    this.Selecionado.setCor(Utilidades.StringToColor(valor));
                    break;
                }
                case "setRetangulo": {
                    this.Selecionado.setRetangulo(valor);
                    break;
                }
                case "setElipse": {
                    this.Selecionado.setElipse(valor);
                    break;
                }
                case "setCurva": {
                    this.Selecionado.setCurva(valor);
                    break;
                }
                case "setArco": {
                    this.Selecionado.setArco(valor);
                    break;
                }
                case "setPosiImagem": {
                    this.Selecionado.setPosiImagem(valor);
                    break;
                }
                case "setVertical": {
                    this.Selecionado.setVertical(Boolean.valueOf(valor));
                    break;
                }
                case "setGradiente": {
                    this.Selecionado.setGradiente(Boolean.valueOf(valor));
                    break;
                }
                case "setGradienteStartColor": {
                    this.Selecionado.setGradienteStartColor(Utilidades.StringToColor(valor));
                    break;
                }
                case "setGradienteEndColor": {
                    this.Selecionado.setGradienteEndColor(Utilidades.StringToColor(valor));
                    break;
                }
                case "setDirecaogradiente": {
                    this.Selecionado.setDirecaogradiente(Integer.valueOf(valor));
                }
            }
        }
        catch (Exception e) {
            BrLogger.Logger("AceitaEdicao", e.getMessage());
            this.PerformInspectorFor();
            this.Item.InvalidateArea();
            return false;
        }
        this.PerformInspectorFor();
        this.Item.DoMuda();
        this.Item.InvalidateArea();
        return true;
    }

    @Override
    public boolean ProcesseCmdFromInspector(String property) {
        FormaElementar.nomeComandos cmd;
        try {
            cmd = FormaElementar.nomeComandos.valueOf(property);
        }
        catch (Exception e) {
            return false;
        }
        switch (cmd) {
            case cmdLoadImg: {
                String res = Dialogos.ShowDlgFileImg(this.getRootPane());
                if (res == null) {
                    return true;
                }
                if (this.Selecionado.LoadImageFromFile(res)) {
                    this.PerformInspectorFor();
                    this.Item.DoMuda();
                    this.Item.InvalidateArea();
                    return true;
                }
                this.PerformInspectorFor();
                break;
            }
            case cmdDoAnyThing: {
                this.Selecionado.DoAnyThing(this.inspector1.getSelecionado().getPropriedade().Tag);
                this.PerformInspectorFor();
                this.Item.DoMuda();
                this.Item.InvalidateArea();
                return true;
            }
        }
        return false;
    }

    public void Inicie(FormaElementar selecionado) {
        this.omaster = selecionado.getMaster().getEditor();
        this.omaster.InicieNovoInspector(this.inspector1, this);
        this.Item = (iBaseDrawer)((Object)selecionado);
        this.PopuleLista();
        this.PerformInspectorFor();
        this.Lista.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.PerformInspectorFor();
        });
        this.painelPintador1.setSize(new Dimension(selecionado.getWidth(), selecionado.getHeight()));
        this.painelPintador1.setPreferredSize(this.painelPintador1.getSize());
    }

    public void PerformInspectorFor() {
        this.Selecionado = null;
        if (this.omaster == null || this.Item == null) {
            this.RefreshMenus();
            return;
        }
        this.omaster.setTextoDica(null, "");
        ArrayList<InspectorProperty> res = new ArrayList<InspectorProperty>();
        res.add(InspectorProperty.PropertyFactorySeparador("basedraweritem.titulo"));
        this.painelPintador1.getPintaveis().clear();
        if (this.Lista.getSelectedIndex() > -1) {
            this.Selecionado = this.Item.getItens().get(this.Lista.getSelectedIndex());
            this.Popule(res);
            this.painelPintador1.getPintaveis().add(this.Selecionado);
        }
        this.painelPintador1.repaint();
        this.inspector1.Carrege(res);
        this.RefreshMenus();
    }

    private void Popule(ArrayList<InspectorProperty> res) {
        if (this.Selecionado == null) {
            return;
        }
        ArrayList<String> menu = new ArrayList<String>();
        menu.add(Editor.fromConfiguracao.getValor("Inspector.lst.basedraweritem.tpretangulo"));
        menu.add(Editor.fromConfiguracao.getValor("Inspector.lst.basedraweritem.tpelipse"));
        menu.add(Editor.fromConfiguracao.getValor("Inspector.lst.basedraweritem.tpcurva"));
        menu.add(Editor.fromConfiguracao.getValor("Inspector.lst.basedraweritem.tparco"));
        menu.add(Editor.fromConfiguracao.getValor("Inspector.lst.basedraweritem.tppath"));
        menu.add(Editor.fromConfiguracao.getValor("Inspector.lst.basedraweritem.tpimagem"));
        res.add(InspectorProperty.PropertyFactoryMenu("basedraweritem.tipo", "SetTipo", this.Selecionado.getTipo().ordinal(), menu).AddCondicao(new String[]{"0"}, new String[]{"setRetangulo"}).AddCondicao(new String[]{"1"}, new String[]{"setElipse"}).AddCondicao(new String[]{"2"}, new String[]{"setCurva"}).AddCondicao(new String[]{"3"}, new String[]{"setArco"}).AddCondicao(new String[]{"4"}, new String[]{"setPath"}).AddCondicao(new String[]{"5"}, new String[]{FormaElementar.nomeComandos.cmdLoadImg.name(), FormaElementar.nomeComandos.cmdDoAnyThing.name(), "desenhador.imagem.size", "setPosiImagem"}));
        res.add(InspectorProperty.PropertyFactoryTexto("basedraweritem.retangulo", "setRetangulo", this.Selecionado.getRetangulo()));
        res.add(InspectorProperty.PropertyFactoryTexto("basedraweritem.elipse", "setElipse", this.Selecionado.getElipse()));
        res.add(InspectorProperty.PropertyFactoryTexto("basedraweritem.curva", "setCurva", this.Selecionado.getCurva()));
        res.add(InspectorProperty.PropertyFactoryTexto("basedraweritem.arco", "setArco", this.Selecionado.getArco()));
        res.add(InspectorProperty.PropertyFactoryTexto("basedraweritem.path", "setPath", this.Selecionado.getPath()));
        res.add(InspectorProperty.PropertyFactoryTexto("basedraweritem.posiimg", "setPosiImagem", this.Selecionado.getPosiImagem()));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdLoadImg.name()));
        Point p = this.Selecionado.GetImgSize();
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("desenhador.imagem.size", "(" + String.valueOf(p.x) + " ," + String.valueOf(p.y) + ")"));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "desenhador.imagem.resize").setTag(1));
        res.add(InspectorProperty.PropertyFactorySN("basedraweritem.fill", "setFill", this.Selecionado.isFill()).PropertyForceDisable(this.Selecionado.getTipo() == baseDrawerItem.tipoDrawer.tpImagem || this.Selecionado.getTipo() == baseDrawerItem.tipoDrawer.tpMedida));
        String[] g = new String[]{"setCor", "setGradiente", "setGradienteStartColor", "setGradienteEndColor", "setDirecaogradiente"};
        res.add(InspectorProperty.PropertyFactorySN("basedraweritem.recivepaint", "setRecivePaint", this.Selecionado.isRecivePaint()).AddCondicaoForFalse(g));
        res.add(InspectorProperty.PropertyFactoryCor("basedraweritem.cor", "setCor", this.Selecionado.getCor()));
        String[] grupo = new String[]{"setGradienteStartColor", "setGradienteEndColor", "setDirecaogradiente"};
        res.add(InspectorProperty.PropertyFactorySeparador("basedraweritem.gradiente"));
        res.add(InspectorProperty.PropertyFactorySN("basedraweritem.gradiente.is", "setGradiente", this.Selecionado.isGradiente()).AddCondicaoForFalse(new String[]{"setCor"}).AddCondicaoForTrue(grupo));
        res.add(InspectorProperty.PropertyFactoryCor("basedraweritem.gradiente.startcor", "setGradienteStartColor", this.Selecionado.getGradienteStartColor()));
        res.add(InspectorProperty.PropertyFactoryCor("basedraweritem.gradiente.endcor", "setGradienteEndColor", this.Selecionado.getGradienteEndColor()));
        res.add(InspectorProperty.PropertyFactoryMenu("basedraweritem.gradiente.direcao", "setDirecaogradiente", this.Selecionado.getDirecaogradiente(), Editor.fromConfiguracao.getLstDirecao(Controler.Comandos.cmdTexto)));
    }

    private void PopuleLista() {
        DefaultListModel<String> lst = new DefaultListModel<String>();
        int t = 0;
        for (baseDrawerItem bi : this.Item.getItens()) {
            lst.addElement(Integer.toString(t++) + " " + Editor.fromConfiguracao.getValor("Inspector.lst.basedraweritem." + bi.getTipo().name().toLowerCase()));
        }
        this.Lista.setModel(lst);
    }

    private void RefreshMenus() {
        if (this.Selecionado == null) {
            this.btnDescer.setEnabled(false);
            this.btnSubir.setEnabled(false);
            this.btnExcluir.setEnabled(false);
            this.btnDuplique.setEnabled(false);
            return;
        }
        this.btnExcluir.setEnabled(true);
        this.btnDuplique.setEnabled(true);
        int utimo = this.Lista.getModel().getSize() - 1;
        int idx = this.Lista.getSelectedIndex();
        this.btnDescer.setEnabled(idx < utimo);
        this.btnSubir.setEnabled(idx > 0);
    }
}

