/*
 * Decompiled with CFR 0.152.
 */
package controlador;

import controlador.BaseControlador;
import controlador.Impressor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class ImpressorPreview
extends BaseControlador {
    private final Impressor prn;
    int h = 0;
    int w = 0;
    int t = 0;
    int l = 0;
    private int pgatual = 0;
    private int tlpagina = 0;
    public int Largura;
    public int Altura;

    public ImpressorPreview(Impressor prn) {
        this.setDoubleBuffered(true);
        this.prn = prn;
        this.w = prn.Impressora.getPageWidth();
        this.h = prn.Impressora.getPageHeigth();
        this.l = (int)prn.Impressora.getPage().getPaper().getImageableX();
        this.t = (int)prn.Impressora.getPage().getPaper().getImageableY();
        this.tlpagina = prn.getQtdPagina();
        this.Largura = prn.Impressora.getRealFolhaWidth();
        this.Altura = prn.Impressora.getRealFolhaHeigth();
        this.setBackground(Color.WHITE);
    }

    public int getPgatual() {
        return this.pgatual;
    }

    public void setPgatual(int pgatual) {
        this.pgatual = pgatual;
        if (pgatual > this.tlpagina || pgatual < 0) {
            pgatual = 0;
        }
    }

    public int getTlpagina() {
        return this.tlpagina;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Graphics2D Canvas = (Graphics2D)g;
        Canvas.addRenderingHints(renderHints);
        Canvas.setPaint(Color.BLACK);
        BasicStroke stroke = new BasicStroke(1.0f, 2, 0);
        Canvas.setStroke(stroke);
        Canvas.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        Canvas.setPaint(Color.GRAY);
        Canvas.drawRect(0, 0, this.getWidth() - 2, this.getHeight() - 2);
        if (this.pgatual == 0) {
            return;
        }
        float[] dash4 = new float[]{2.0f, 2.0f, 2.0f};
        BasicStroke bs4 = new BasicStroke(1.0f, 0, 1, 1.0f, dash4, 2.0f);
        Canvas.setStroke(bs4);
        Canvas.drawLine(this.l - 1, 1, this.l - 1, this.getHeight() - 1);
        Canvas.drawLine(this.l + this.w + 1, 1, this.l + this.w + 1, this.getHeight() - 1);
        Canvas.drawLine(1, this.t - 1, this.getWidth() - 1, this.t - 1);
        Canvas.drawLine(1, this.t + this.h + 1, this.getWidth() - 1, this.t + this.h + 1);
        Canvas.setStroke(new BasicStroke(1.0f, 1, 1));
        Canvas.setPaint(Color.BLACK);
        this.DrawPagina(Canvas);
    }

    private void DrawPagina(Graphics2D Canvas) {
        if (this.pgatual > 0) {
            Canvas.drawImage(this.prn.imgs[this.pgatual - 1], this.l, this.t, this.w, this.h, null);
        }
    }

    public void PrintPg() {
        int pg = this.pgatual;
        this.prn.iniceImpressaoNoPreview(pg);
        this.prn.Impressora.print();
        this.prn.finalizeImpressaoNoPreview();
    }

    public void Print() {
        this.prn.Impressora.print();
    }
}

