/*
 * Decompiled with CFR 0.152.
 */
package controlador.apoios;

import controlador.Diagrama;
import controlador.apoios.TreeItem;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import desenho.formas.Forma;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.Utilidades;
import util.XMLGenerate;

public class InfoDiagrama
extends Forma {
    private static final long serialVersionUID = 4149452269833523526L;
    private String autores = "";
    private String realDiagramaUniversalUnicID = "";
    private String diagramaUniversalUnicID;
    private transient String diagramaOldUniversalUnicID = "";
    private int alinhamento_v = 50;
    private int alinhamento_h = 60;

    public InfoDiagrama(Diagrama modelo) {
        super(modelo);
        this.setVisible(false);
        this.setSelecionavel(false);
        this.realDiagramaUniversalUnicID = this.diagramaUniversalUnicID = this.geraUnicDiagramaID();
    }

    public InfoDiagrama(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.setVisible(false);
        this.realDiagramaUniversalUnicID = this.diagramaUniversalUnicID = this.geraUnicDiagramaID();
    }

    private String geraUnicDiagramaID() {
        Random r = new Random();
        String res = "";
        for (int i = 0; i < 10; ++i) {
            res = res + Integer.toHexString(r.nextInt(256)) + (i % 3 != 0 ? "-" : "");
        }
        return res.toUpperCase();
    }

    public final void ReGeraGuardaUnicDiagramaID() {
        this.diagramaUniversalUnicID = this.geraUnicDiagramaID();
    }

    @Override
    public void DoPaint(Graphics2D g) {
        g.setPaint(this.getForeColor());
        super.DoPaint(g);
        g.drawRect(this.getLeft(), this.getTop(), this.getWidth() - 1, this.getHeight() - 1);
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = new ArrayList<InspectorProperty>();
        this.getMaster().BeginProperty(res);
        res.add(InspectorProperty.PropertyFactorySeparador("diagrama.versao.titulo"));
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("diagrama.versao", this.getMaster().getVersao()));
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("diagrama.nome", this.getMaster().getNome()));
        if (this.getMaster().getEditor().isMostrarIDs()) {
            res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("diagrama.unicid", this.getRealDiagramaUniversalUnicID()));
        }
        String arq = "".equals(this.getMaster().getArquivo()) ? "" : new File(this.getMaster().getArquivo()).getName();
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("diagrama.arquivo", arq));
        res.add(InspectorProperty.PropertyFactoryTextoL("diagrama.autores", "setAutores", this.getAutores()));
        res.add(InspectorProperty.PropertyFactoryTextoL("diagrama.observacao", "setObservacao", this.getObservacao()));
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("diagrama.tipo", this.getMaster().getTipoDeDiagramaFormatado()));
        res.add(InspectorProperty.PropertyFactorySeparador("dimensoes"));
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("width", Integer.toString(this.getMaster().getWidth())));
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("height", Integer.toString(this.getMaster().getHeight())));
        ArrayList<String> vl = new ArrayList<String>();
        for (int i = 0; i < this.getMaster().getEditor().zoonsd.length; ++i) {
            vl.add(Double.toString(this.getMaster().getEditor().zoonsd[i] * 100.0) + "%");
        }
        res.add(InspectorProperty.PropertyFactoryMenu("zoom", "setZoonInt", this.getZoonInt(), vl));
        res.add(InspectorProperty.PropertyFactorySeparador("diagrama.alinhamento"));
        res.add(InspectorProperty.PropertyFactoryNumero("diagrama.alinhamento_h", "setAlinhamento_h", this.getAlinhamento_h()));
        res.add(InspectorProperty.PropertyFactoryNumero("diagrama.alinhamento_v", "setAlinhamento_v", this.getAlinhamento_v()));
        res.add(InspectorProperty.PropertyFactorySeparador("fonte"));
        Font f = this.getFont();
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("fonte.nome", f.getName()));
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("fonte.tamanho", Integer.toString(f.getSize())));
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("fonte.estilo", Utilidades.decodeFontStyle(f.getStyle())));
        if (this.editFonte) {
            res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdFonte.name(), FormaElementar.nomeComandos.cmdFonte.name().toLowerCase(), this.getFont().getFontName()));
        }
        this.getMaster().EndProperty(res);
        return res;
    }

    public int getZoonInt() {
        int res = 4;
        double z = this.getMaster().getZoom();
        for (int i = 0; i < this.getMaster().getEditor().zoonsd.length; ++i) {
            if (this.getMaster().getEditor().zoonsd[i] != z) continue;
            res = i;
        }
        return res;
    }

    public void setZoonInt(int zoonInt) {
        this.getMaster().getEditor().setZoom(this.getMaster().getEditor().zoonsd[zoonInt]);
    }

    public String getAutores() {
        return this.autores;
    }

    public void setAutores(String autores) {
        this.autores = autores;
    }

    public boolean IsTheShame() {
        return this.diagramaUniversalUnicID.equals(this.diagramaOldUniversalUnicID);
    }

    public String getRealDiagramaUniversalUnicID() {
        return this.realDiagramaUniversalUnicID;
    }

    public void setDiagramaUniversalUnicID(String diagramaUniversalUnicID) {
        this.diagramaUniversalUnicID = diagramaUniversalUnicID;
    }

    public String getDiagramaUniversalUnicID() {
        return this.diagramaUniversalUnicID;
    }

    public String getDiagramaOldUniversalUnicID() {
        return this.diagramaOldUniversalUnicID;
    }

    public void setDiagramaOldUniversalUnicID(String uid) {
        this.diagramaOldUniversalUnicID = uid;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        me.appendChild(XMLGenerate.ValorString(doc, "Versao", this.getMaster().getVersao()));
        me.appendChild(XMLGenerate.ValorText(doc, "Autores", this.getAutores()));
        me.appendChild(XMLGenerate.ValorText(doc, "Observacao", this.getObservacao()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Width", this.getMaster().getWidth()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Height", this.getMaster().getHeight()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Alinhamento_v", this.getAlinhamento_v()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Alinhamento_h", this.getAlinhamento_h()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Zoom", (int)(this.getMaster().getZoom() * 100.0)));
        me.appendChild(XMLGenerate.ValorFonte(doc, this.getFont()));
        me.appendChild(XMLGenerate.ValorPoint(doc, "Localizacao", this.getMaster().ScrPosicao));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Realce", this.getMaster().isRealce()));
        this.getMaster().InfoDiagrama_ToXmlValores(doc, me);
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        if (!colando) {
            this.realDiagramaUniversalUnicID = this.diagramaUniversalUnicID = me.getAttribute("UniversalUnicID");
        }
        this.setAutores(XMLGenerate.getValorTextoFrom(me, "Autores"));
        this.setObservacao(XMLGenerate.getValorTextoFrom(me, "Observacao"));
        this.setFont(XMLGenerate.getValorFonte(me));
        this.getMaster().setZoom((double)XMLGenerate.getValorIntegerFrom(me, "Zoom") / 100.0);
        this.getMaster().ScrPosicao = XMLGenerate.getValorPointFrom(me, "Localizacao");
        this.setAlinhamento_h(XMLGenerate.getValorIntegerFrom(me, "Alinhamento_h"));
        this.setAlinhamento_v(XMLGenerate.getValorIntegerFrom(me, "Alinhamento_v"));
        this.getMaster().SetRealce(XMLGenerate.getValorBooleanFrom(me, "Realce"));
        this.getMaster().LoadVersao(XMLGenerate.getValorStringFrom(me, "Versao"));
        return this.getMaster().InfoDiagrama_LoadFromXML(me, colando);
    }

    @Override
    public boolean MostreSeParaExibicao(TreeItem root) {
        return false;
    }

    @Override
    public void DoAnyThing(int Tag) {
        super.DoAnyThing(Tag);
        this.getMaster().DoAnyThing(Tag);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.getMaster().setFont(font);
    }

    public int getAlinhamento_v() {
        return this.alinhamento_v;
    }

    public void setAlinhamento_v(int alinhamento_v) {
        this.alinhamento_v = alinhamento_v;
    }

    public int getAlinhamento_h() {
        return this.alinhamento_h;
    }

    public void setAlinhamento_h(int alinhamento_h) {
        this.alinhamento_h = alinhamento_h;
    }

    public void setFromString(String str) {
        int tag = this.getMaster().getEditor().getInspectorEditor().getSelecionado().getTag();
        this.getMaster().setFromString(str, tag);
    }
}

