/*
 * Decompiled with CFR 0.152.
 */
package helper;

import helper.ParteAjuda;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import util.BrLogger;

public class AjudaManager
extends ParteAjuda {
    private static final long serialVersionUID = -3897772703895330700L;
    private boolean mudou = false;

    public AjudaManager(int id, String titulo) {
        super(id, titulo);
        this.master = this;
    }

    public static AjudaManager LoadDataHelp() {
        String tmp = System.getProperty("user.dir") + File.separator + "Ajuda.brMh";
        return AjudaManager.LoadData(tmp);
    }

    public static AjudaManager LoadData(String arq) {
        try {
            AjudaManager res;
            FileInputStream fi = new FileInputStream(arq);
            try (ObjectInputStream in = new ObjectInputStream(fi);){
                res = (AjudaManager)in.readObject();
                in.close();
            }
            return res;
        }
        catch (IOException | ClassNotFoundException | NullPointerException iOException) {
            BrLogger.Logger("ERROR_HELP_LOAD", iOException.getMessage());
            return null;
        }
    }

    public static boolean SaveData(AjudaManager obj, String fileName) {
        try {
            FileOutputStream fo = new FileOutputStream(fileName);
            try (ObjectOutputStream out = new ObjectOutputStream(fo);){
                out.writeObject(obj);
            }
            return true;
        }
        catch (IOException iOException) {
            BrLogger.Logger("ERROR_HELP_SAVE", iOException.getMessage());
            return false;
        }
    }

    public static boolean SaveDataHelp(AjudaManager obj) {
        String tmp = System.getProperty("user.dir") + File.separator + "Ajuda.brMh";
        obj.setMudou(false);
        if (!AjudaManager.SaveData(obj, tmp)) {
            obj.setMudou(true);
            return false;
        }
        return true;
    }

    public boolean isMudou() {
        return this.mudou;
    }

    public void setMudou(boolean mudou) {
        this.mudou = mudou;
    }

    @Override
    public void doMuda() {
        this.setMudou(true);
    }
}

