/*
 * Decompiled with CFR 0.152.
 */
package diagramas.logico;

import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.Elementar;
import desenho.FormaElementar;
import desenho.formas.Forma;
import desenho.linhas.PontoDeLinha;
import desenho.linhas.SuperLinha;
import desenho.preAnyDiagrama.PreCardinalidade;
import diagramas.logico.LogicoCardinalidade;
import diagramas.logico.Tabela;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.XMLGenerate;

public class LogicoLinha
extends SuperLinha {
    private static final long serialVersionUID = 250742280172172228L;
    private LogicoCardinalidade CardA;
    private LogicoCardinalidade CardB;
    private boolean setaAutomatica = true;

    public LogicoLinha(Diagrama modelo) {
        super(modelo);
        this.setInteligente(true);
        this.InitLCC();
    }

    public LogicoLinha(Diagrama modelo, boolean comCard) {
        super(modelo);
        this.setInteligente(true);
        if (comCard) {
            this.InitLCC();
        }
    }

    protected final void InitLCC() {
        this.setCardA(new LogicoCardinalidade(this.getMaster(), LogicoCardinalidade.class.getSimpleName()));
        this.setCardB(new LogicoCardinalidade(this.getMaster(), LogicoCardinalidade.class.getSimpleName()));
        this.getCardA().setCard(1);
        this.getCardA().Fixe(null);
        this.getCardB().Fixe(null);
    }

    public LogicoCardinalidade getCardA() {
        return this.CardA;
    }

    public LogicoCardinalidade getCardB() {
        return this.CardB;
    }

    public void setCardA(LogicoCardinalidade aCard) {
        if (this.CardA != aCard) {
            if (this.CardA != null) {
                this.CardA.setLigadoA(null);
            }
            this.CardA = aCard;
            if (this.CardA != null) {
                this.CardA.setLigadoA(this);
            }
        }
    }

    public void setCardB(LogicoCardinalidade aCard) {
        if (this.CardB != aCard) {
            if (this.CardB != null) {
                this.CardB.setLigadoA(null);
            }
            this.CardB = aCard;
            if (this.CardB != null) {
                this.CardB.setLigadoA(this);
            }
        }
    }

    public void SuperInicie(int tlPt, Point ptPrimeiro, Point ptFinal) {
        this.Inicie(tlPt, ptPrimeiro, ptFinal);
        this.AnexePontos();
        this.OrganizeLinha();
        this.reSetBounds();
    }

    public void SuperSetInteligente(boolean sn) {
        this.SetInteligente(sn);
        this.OrganizeLinha();
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        res.stream().filter(iip -> iip.tipo == InspectorProperty.TipoDeProperty.tpNumero).forEach(iip -> {
            iip.tipo = InspectorProperty.TipoDeProperty.tpApenasLeituraTexto;
        });
        res.add(InspectorProperty.PropertyFactoryCor("forecolor", "setForeColor", this.getForeColor()));
        res.add(InspectorProperty.PropertyFactorySN("linha.auto", "SuperSetInteligente", this.isInteligente()));
        return res;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        NodeList nl = me.getElementsByTagName("Bounds");
        me.removeChild(nl.item(0));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Inteligente", this.isInteligente()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "SetaAutomatica", this.isSetaAutomatica()));
        if (!this.getForeColor().equals(Elementar.defaultColor)) {
            me.appendChild(XMLGenerate.ValorColor(doc, "ForeColor", this.getForeColor()));
        }
        me.appendChild(XMLGenerate.ValorInteger(doc, "Largura", (int)this.getLargura()));
        Element lig = doc.createElement("Ligacoes");
        XMLGenerate.AtributoRefFormElementar(lig, "PontaA", this.getFormaPontaA());
        XMLGenerate.AtributoRefFormElementar(lig, "PontaB", this.getFormaPontaB());
        me.appendChild(lig);
        Element sbPontos = doc.createElement("Pontos");
        for (PontoDeLinha pl : this.getPontos()) {
            sbPontos.appendChild(XMLGenerate.ValorPoint(doc, "Ponto", pl.getLocation()));
        }
        me.appendChild(sbPontos);
        if (this.getCardA() != null) {
            this.getCardA().ToXlm(doc, me);
        }
        if (this.getCardB() != null) {
            this.getCardB().ToXlm(doc, me);
        }
    }

    @Override
    public boolean CommitXML(Element me, HashMap<Element, FormaElementar> mapa) {
        FormaElementar resB;
        Element lig = XMLGenerate.FindByNodeName(me, "Ligacoes");
        String idPt = lig.getAttribute("PontaA");
        FormaElementar resA = XMLGenerate.FindWhoHasID(idPt, mapa);
        if (resA instanceof Forma) {
            this.getPontaA().SetEm((Forma)resA);
        }
        if ((resB = XMLGenerate.FindWhoHasID(idPt = lig.getAttribute("PontaB"), mapa)) instanceof Forma) {
            this.getPontaB().SetEm((Forma)resB);
        }
        if (resA instanceof Forma) {
            ((Forma)resA).PosicionePonto(this.getPontaA());
        }
        if (resB instanceof Forma) {
            ((Forma)resB).PosicionePonto(this.getPontaB());
        }
        this.OrganizeLinha();
        this.PrepareCardinalidade();
        return super.CommitXML(me, mapa);
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        int l;
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        this.setInteligente(XMLGenerate.getValorBooleanFrom(me, "Inteligente"));
        this.setSetaAutomatica(XMLGenerate.getValorBooleanFrom(me, "SetaAutomatica"));
        Color c = XMLGenerate.getValorColorFrom(me, "ForeColor");
        if (c != null) {
            this.setForeColor(c);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "Largura")) != -1) {
            this.setLargura(l);
        }
        NodeList ptLst = me.getElementsByTagName("Pontos");
        Element pontos = (Element)ptLst.item(0);
        ptLst = pontos.getChildNodes();
        this.Inicie(ptLst.getLength() - 2, new Point(20, 20), new Point(40, 40));
        ArrayList<PontoDeLinha> arrpontos = this.getPontos();
        for (int i = 0; i < ptLst.getLength(); ++i) {
            Point p = XMLGenerate.getValorPoint((Element)ptLst.item(i));
            arrpontos.get(i).setLocation(p);
        }
        NodeList tmp = me.getElementsByTagName(Editor.getClassTexto(this.getCardA()));
        this.getCardA().LoadFromXML((Element)tmp.item(0), colando);
        if (tmp.getLength() > 0) {
            me.removeChild(tmp.item(0));
            this.getCardB().LoadFromXML((Element)tmp.item(0), colando);
        }
        return true;
    }

    public void PrepareCardinalidade() {
        LogicoCardinalidade card;
        if (this.getPontaA() == null || this.getPontaB() == null) {
            return;
        }
        if (!this.getPontaA().isEstaLigado()) {
            this.getCardA().Fixe(null);
        } else {
            card = this.getCardA();
            card.setVisible(true);
            card.Fixe(this.getPontaA());
            card.Posicione();
        }
        if (!this.getPontaB().isEstaLigado()) {
            this.getCardB().Fixe(null);
        } else {
            card = this.getCardB();
            card.setVisible(true);
            card.Fixe(this.getPontaB());
            card.Posicione();
        }
    }

    @Override
    public void reSetBounds() {
        super.reSetBounds();
        this.PrepareCardinalidade();
    }

    @Override
    public boolean AnexePontos() {
        boolean res = super.AnexePontos();
        if (!res) {
            this.PrepareCardinalidade();
        }
        return res;
    }

    @Override
    public boolean Destroy() {
        this.PerformRoqued(false);
        ArrayList<PontoDeLinha> pontos = this.getPontos();
        for (PontoDeLinha pdl : pontos) {
            pdl.Destroy();
        }
        this.getCardA().setCanBeDeleted(true);
        this.getCardB().setCanBeDeleted(true);
        this.getMaster().Remove(this.getCardA(), false);
        this.getMaster().Remove(this.getCardB(), false);
        if (this.getFormaPontaA() instanceof Tabela) {
            Tabela tab1 = (Tabela)this.getFormaPontaA();
            tab1.Desligacao(this);
        }
        if (this.getFormaPontaB() instanceof Tabela) {
            Tabela tab2 = (Tabela)this.getFormaPontaB();
            tab2.Desligacao(this);
        }
        return super.Destroy();
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        GP = super.CompleteGenerateProperty(GP);
        if (this.showConfigSeta) {
            InspectorProperty tmp = InspectorProperty.FindByProperty(GP, "seta.titulo");
            GP.add(GP.indexOf(tmp) + 1, InspectorProperty.PropertyFactorySN("seta.setaautomatica", "setSetaAutomatica", this.isSetaAutomatica()).AddCondicaoForFalse(new String[]{"setTemSetaPontaA", "setTemSetaPontaB"}));
        }
        ArrayList<Forma> lst = new ArrayList<Forma>();
        if (this.getFormaPontaA() != null) {
            lst.add(this.getFormaPontaA());
        }
        if (this.getFormaPontaB() != null) {
            lst.add(this.getFormaPontaB());
        }
        if (this.getCardB().isVisible()) {
            lst.add(0, this.getCardB());
        }
        if (this.getCardA().isVisible()) {
            lst.add(0, this.getCardA());
        }
        boolean ja = false;
        for (Forma f : lst) {
            InspectorProperty ipp = InspectorProperty.PropertyFactoryActionSelect(Editor.fromConfiguracao.getValor("diagrama." + Editor.getClassTexto(f) + ".nome"), f.getTexto(), String.valueOf(f.getID()));
            if (!ja) {
                ja = true;
                GP.add(InspectorProperty.PropertyFactorySeparador("ligacoes"));
            }
            GP.add(ipp);
        }
        return GP;
    }

    public void AlterCard(LogicoCardinalidade aThis) {
        LogicoCardinalidade card;
        if (aThis.getCard() == PreCardinalidade.TiposCard.C01 || aThis.getCard() == PreCardinalidade.TiposCard.C11) {
            return;
        }
        LogicoCardinalidade logicoCardinalidade = card = aThis == this.getCardA() ? this.getCardB() : this.getCardA();
        if (card.getCard() == PreCardinalidade.TiposCard.C0N) {
            card.setCard(PreCardinalidade.TiposCard.C01);
        } else if (card.getCard() == PreCardinalidade.TiposCard.C1N) {
            card.setCard(PreCardinalidade.TiposCard.C11);
        }
        this.ajusteSeta();
    }

    @Override
    public FormaElementar getSub(int i) {
        if (i == 0) {
            return this.getCardA();
        }
        if (i == 1) {
            return this.getCardB();
        }
        return super.getSub(i);
    }

    public boolean isSetaAutomatica() {
        return this.setaAutomatica;
    }

    public void setSetaAutomatica(boolean setaAutomatica) {
        if (this.setaAutomatica == setaAutomatica) {
            return;
        }
        this.setaAutomatica = setaAutomatica;
        if (setaAutomatica) {
            this.ajusteSeta();
        }
        this.InvalidateArea();
    }

    public void ajusteSeta() {
        if (this.isSetaAutomatica()) {
            int cardD;
            int cardO = this.getCardA().getCard().ordinal();
            if (cardO > (cardD = this.getCardB().getCard().ordinal())) {
                this.setTemSetaPontaA(true);
                this.setTemSetaPontaB(false);
            } else if (cardO == cardD) {
                this.setTemSetaPontaA(true);
                this.setTemSetaPontaB(true);
            } else {
                this.setTemSetaPontaA(false);
                this.setTemSetaPontaB(true);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        this.PerformRoqued(false);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        this.PerformRoqued(true);
    }

    public void PerformRoqued(boolean sn) {
        Forma fmA = this.getFormaPontaA();
        Forma fmB = this.getFormaPontaB();
        if (fmA instanceof Tabela && fmB instanceof Tabela) {
            ((Tabela)fmA).setRoqued(sn, this);
            ((Tabela)fmB).setRoqued(sn, this);
        }
    }

    public void SetFatorLargura(float f) {
        this.fator_largura = f;
    }
}

