/*
 * Decompiled with CFR 0.152.
 */
package diagramas.fluxo;

import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.preAnyDiagrama.PreTextoApenso;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.XMLGenerate;

public class FluxTexto
extends PreTextoApenso {
    private static final long serialVersionUID = -757285006393666224L;
    private boolean positivo = true;

    public FluxTexto(Diagrama modelo) {
        super(modelo);
        this.setPositivo(true);
    }

    public FluxTexto(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.setPositivo(true);
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        InspectorProperty tmp = InspectorProperty.FindByProperty(res, "setTexto");
        tmp.ReSetCaptionFromConfig("texto");
        tmp.tipo = InspectorProperty.TipoDeProperty.tpApenasLeituraTexto;
        ArrayList<String> sn = new ArrayList<String>();
        sn.add(Editor.fromConfiguracao.getValor("Inspector.obj.fluxtexto.positivo"));
        sn.add(Editor.fromConfiguracao.getValor("Inspector.obj.fluxtexto.negativo"));
        res.add(InspectorProperty.PropertyFactoryMenu("fluxtexto.condicao", "setPositivoByInt", this.getPositivoByInt(), sn));
        res.add(InspectorProperty.PropertyFactoryMenu("texto.alinhamento", "setAlinhamentoByInt", this.getAlinhamento().ordinal(), Editor.fromConfiguracao.getLstTextoAlin()));
        res.add(InspectorProperty.PropertyFactorySN("texto.alinhamento.v", "setCentrarVertical", this.isCentrarVertical()));
        tmp = InspectorProperty.FindByProperty(res, "setForeColor");
        tmp.ReSetCaptionFromConfig("texto.forecolor");
        tmp = InspectorProperty.FindByProperty(res, "setTextoAdicional");
        res.remove(tmp);
        res.add(InspectorProperty.PropertyFactorySeparador("texto.atreladoalinha"));
        res.add(InspectorProperty.PropertyFactorySN("texto.movimentacaomanual", "setMovimentacaoManual", this.isMovimentacaoManual()));
        return res;
    }

    public boolean isPositivo() {
        return this.positivo;
    }

    public final void setPositivo(boolean positivo) {
        this.positivo = positivo;
        if (this.isPositivo()) {
            this.setTexto(Editor.fromConfiguracao.getValor("Inspector.obj.fluxtexto.positivo"));
        } else {
            this.setTexto(Editor.fromConfiguracao.getValor("Inspector.obj.fluxtexto.negativo"));
        }
    }

    public int getPositivoByInt() {
        return this.isPositivo() ? 0 : 1;
    }

    public void setPositivoByInt(int vl) {
        this.setPositivo(vl == 0);
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Positivo", this.isAutosize()));
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        this.setPositivo(XMLGenerate.getValorBooleanFrom(me, "Positivo"));
        return true;
    }

    @Override
    public boolean isAlinhavel() {
        return false;
    }
}

