/*
 * Decompiled with CFR 0.152.
 */
package diagramas.livre;

import controlador.Diagrama;
import desenho.linhas.PontoDeLinha;
import diagramas.livre.LivreBase;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;

public class LivreJuncao
extends LivreBase {
    private static final long serialVersionUID = -6937144218354697754L;
    private transient boolean isover = false;

    public LivreJuncao(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.setTipoDesenho(LivreBase.TipoDraw.tpCirculo);
        this.setDashed(true);
        this.editFonte = false;
        this.noNewProperty = true;
    }

    public LivreJuncao(Diagrama modelo) {
        super(modelo);
        this.setTipoDesenho(LivreBase.TipoDraw.tpCirculo);
        this.setDashed(true);
        this.editFonte = false;
        this.noNewProperty = true;
    }

    @Override
    protected void Posicione4Pontos(PontoDeLinha ponto) {
        super.Posicione4Pontos(ponto);
        int x = this.getLeft() + this.getWidth() / 2;
        int y = this.getTop() + this.getHeight() / 2;
        ponto.setCentro(x, y);
    }

    @Override
    public void PinteTexto(Graphics2D g) {
    }

    @Override
    public void ReciveFormaResize(Rectangle ret) {
        Rectangle rec = new Rectangle(0, 0, 0, 0);
        super.ReciveFormaResize(rec);
    }

    @Override
    public Shape getRegiaoCirculo() {
        if (this.Regiao == null) {
            this.Regiao = new Ellipse2D.Float(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        }
        return this.Regiao;
    }

    @Override
    protected void DoPaintDoks(Graphics2D g) {
        super.DoPaintDoks(g);
        Stroke bkp = g.getStroke();
        g.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
        Ellipse2D.Float t = new Ellipse2D.Float(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        g.draw(t);
        g.setStroke(bkp);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        if (!this.isover) {
            this.isover = true;
            this.InvalidateArea();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        if (this.isover) {
            this.isover = false;
            this.InvalidateArea();
        }
    }

    @Override
    protected void PinteRegiao(Graphics2D g) {
        g.setPaint(this.getForeColor());
        int x = this.getLeft() + this.getWidth() / 2;
        int y = this.getTop() + this.getHeight() / 2;
        g.draw(new Rectangle(x - 1, y - 1, 2, 2));
        if (this.isover || this.isSelecionado()) {
            Stroke bkp = g.getStroke();
            g.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
            g.draw(this.getRegiao());
            g.setStroke(bkp);
        }
    }
}

