/*
 * Decompiled with CFR 0.152.
 */
package controlador;

import controlador.Acao;
import controlador.Controler;
import controlador.Editor;
import controlador.apoios.GuardaPadraoBrM;
import controlador.apoios.InfoDiagrama;
import controlador.apoios.TreeItem;
import controlador.inspector.InspectorItemBase;
import controlador.inspector.InspectorItemExtender;
import controlador.inspector.InspectorProperty;
import desenho.Ancorador;
import desenho.Elementar;
import desenho.FormaElementar;
import desenho.formas.Desenhador;
import desenho.formas.Forma;
import desenho.formas.FormaTextoBase;
import desenho.formas.Legenda;
import desenho.linhas.SuperLinha;
import desenho.preAnyDiagrama.PreTexto;
import diagramas.atividade.DiagramaAtividade;
import diagramas.conceitual.DiagramaConceitual;
import diagramas.conceitual.Texto;
import diagramas.eap.DiagramaEap;
import diagramas.fluxo.DiagramaFluxo;
import diagramas.livre.DiagramaLivre;
import diagramas.logico.DiagramaLogico;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util.Arquivo;
import util.BoxingJava;
import util.BrLogger;
import util.Dialogos;
import util.TransferableImage;
import util.Utilidades;
import util.XMLGenerate;

public class Diagrama
implements Serializable,
ClipboardOwner {
    private static final long serialVersionUID = 21212121212121L;
    private final Class[] classesDoDiagrama = new Class[0];
    protected transient Editor master;
    private int baseRecuo = 3;
    private boolean draging = false;
    protected Color pontoCor = Color.BLACK;
    protected Color pontoCorMultSel = Color.GREEN;
    protected FormaElementar infoDiagrama = null;
    static final String VERSAO_A = "3";
    static final String VERSAO_B = "2";
    static final String VERSAO_C = "0";
    protected String versaoA = "3";
    protected String versaoB = "2";
    protected String versaoC = "0";
    private TipoDeDiagrama tipo = TipoDeDiagrama.tpConceitual;
    private transient String nome;
    private transient String Arquivo = "";
    private Font font;
    private Color foreColor = Elementar.defaultColor;
    private int heigth = 4096;
    private int width = 4096;
    private double zoom = 1.0;
    private Ancorador superAncorador = null;
    public static final int totalInicialDeItens = 1;
    protected ArrayList<Elementar> subItens = new ArrayList();
    protected ArrayList<FormaElementar> ListaDeItens = new ArrayList();
    private ArrayList<FormaElementar> itensSelecionados = new ArrayList();
    public final ArrayList<String> meusComandos = new ArrayList();
    int _tick = 0;
    private transient TreeItem TreeNavegacao = null;
    private FormaElementar overDraw = null;
    private transient Elementar elementarSobMouse = null;
    Point DiagramaDownPos = new Point(0, 0);
    boolean isMouseDown = false;
    public transient boolean IsStopEvents = false;
    public transient boolean isCarregando = false;
    protected transient boolean isLoadCreate = false;
    private boolean mudou = false;
    protected int TotalID = 0;
    public Point ScrPosicao = new Point(0, 0);
    private transient Controler.Comandos comando = null;
    protected transient clickForma cliq1 = null;
    protected transient clickForma cliq2 = null;
    public static final String nodePrincipal = "DIAGRAMA";
    private boolean realce = false;
    private final String v300 = "3.0.0";
    private final String v310 = "3.1.0";

    public Class[] getCassesDoDiagrama() {
        return this.classesDoDiagrama;
    }

    public Cursor getCursor() {
        return this.master.getBox().getCursor();
    }

    public void setCursor(Cursor cursor) {
        if (this.getComando() != null) {
            this.master.getBox().setCursor(this.getEditor().getControler().MakeCursor(this.getComando()));
            return;
        }
        this.master.getBox().setCursor(cursor);
    }

    public int getPontoWidth() {
        return this.master.getBox().getPontoWidth();
    }

    public int getPontoHeigth() {
        return this.master.getBox().getPontoHeigth();
    }

    public Color getBackground() {
        return this.master.getBox().getBackground();
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public void setForeColor(Color foreColor) {
        this.foreColor = foreColor;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getHeight() {
        return this.heigth;
    }

    public int getWidth() {
        return this.width;
    }

    public String getArquivo() {
        return this.Arquivo;
    }

    public void setArquivo(String Arquivo2) {
        this.Arquivo = Arquivo2;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
        if (this.master != null) {
            this.master.RePopuleBarraDiagramas(false);
        }
    }

    public void SetNome(String nome) {
        this.nome = nome;
    }

    public TipoDeDiagrama getTipo() {
        return this.tipo;
    }

    protected void setTipo(TipoDeDiagrama tipo) {
        this.tipo = tipo;
    }

    public String getTipoDeDiagramaFormatado() {
        return Editor.fromConfiguracao.getValor("Inspector.lst.tipodiagrama." + this.getTipo().name().substring(2).toLowerCase());
    }

    public String getVersao() {
        return this.versaoA + "." + this.versaoB + "." + this.versaoC;
    }

    public boolean isMostrarInfoDiagrama() {
        return this.infoDiagrama.isVisible();
    }

    public void setMostrarInfoDiagrama(boolean mostrarInfoDiagrama) {
        this.infoDiagrama.setVisible(mostrarInfoDiagrama);
    }

    public Editor getEditor() {
        return this.master;
    }

    public Color getPontoCorMultSel() {
        return this.pontoCorMultSel;
    }

    public void setPontoCorMultSel(Color pc) {
        this.pontoCorMultSel = pc;
    }

    public Color getPontoCor() {
        return this.pontoCor;
    }

    public void setPontoCor(Color pontoCor) {
        this.pontoCor = pontoCor;
    }

    public final Color getEditorBackColor() {
        return this.master.getBox().getBackground();
    }

    public int getBaseRecuo() {
        return this.baseRecuo;
    }

    public void setBaseRecuo(int baseRecuo) {
        this.baseRecuo = baseRecuo;
    }

    public ArrayList<Elementar> getSubItens() {
        return this.subItens;
    }

    public ArrayList<FormaElementar> getListaDeItens() {
        return this.ListaDeItens;
    }

    public ArrayList<FormaElementar> getItensSelecionados() {
        return this.itensSelecionados;
    }

    public Diagrama(Editor omaster) {
        this.master = omaster;
        this.font = Elementar.CloneFont(this.master.getBox().getFont());
        this.isLoadCreate = true;
        this.infoDiagrama = new InfoDiagrama(this);
        this.infoDiagrama.SetBounds(5, 5, 300, 150);
        this.isLoadCreate = false;
        this.master.getBox().getClass();
        this.heigth = 4096;
        this.master.getBox().getClass();
        this.width = 4096;
        this.meusComandos.add(Controler.Comandos.cmdDesenhador.name());
        this.meusComandos.add(Controler.Comandos.cmdLegenda.name());
        this.meusComandos.add(Controler.Comandos.cmdTexto.name());
        this.meusComandos.add(Controler.Comandos.cmdApagar.name());
        this.nome = "";
        this.superAncorador = new Ancorador(this);
        this.superAncorador.SetBounds(50, 50, 18, 36);
    }

    public void setMaster(Editor master) {
        this.master = master;
    }

    private void tick() {
        ++this._tick;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    private void PinteGrade(Graphics2D g) {
        int i;
        int w = this.master.getGridWidth();
        int gW = this.getWidth() / w + 1;
        int gH = this.getHeight() / w + 1;
        int ww = this.getWidth();
        int hh = this.getHeight();
        Paint bkppaint = g.getPaint();
        g.setColor(new Color(241, 246, 251));
        for (i = 1; i < gW; ++i) {
            g.drawLine(w * i, 0, w * i, hh);
        }
        for (i = 1; i < gH; ++i) {
            g.drawLine(0, w * i, ww, w * i);
        }
        g.setPaint(bkppaint);
    }

    public void PaintAI(Graphics2D g, int wdt, int ht) {
        Paint bkppaint = g.getPaint();
        g.setColor(new Color(221, 221, 221));
        for (int w = wdt; w < this.getWidth(); w += wdt) {
            g.drawLine(w, 1, w, this.getHeight() - 1);
        }
        for (int h = ht; h < this.getHeight(); h += ht) {
            g.drawLine(1, h, this.getWidth() - 1, h);
        }
        g.setPaint(bkppaint);
    }

    public TreeItem AtualizeTreeNavegacao(boolean atualisar) {
        if (atualisar || this.TreeNavegacao == null) {
            this.TreeNavegacao = new TreeItem(this.getNomeFormatado());
            this.getListaDeItens().stream().filter(it -> it instanceof Forma).map(it -> (Forma)it).forEach(it -> it.MostreSeParaExibicao(this.TreeNavegacao));
        }
        return this.TreeNavegacao;
    }

    public TreeItem getTreeNavegacao() {
        return this.AtualizeTreeNavegacao(false);
    }

    public void SelecioneByID(int i, boolean mostrar) {
        FormaElementar e = this.FindByID(i);
        if (e == null) {
            this.master.AtualizeTreeNavegacao();
            return;
        }
        this.DiagramaDoSelecao(e, false, false);
        if (mostrar) {
            this.master.Mostre(e.getLocation());
        }
    }

    public void BeginProperty(ArrayList<InspectorProperty> res) {
    }

    public void EndProperty(ArrayList<InspectorProperty> res) {
    }

    public void DoAnyThing(int Tag) {
    }

    public void populeComandos(JMenuItem item) {
        item.setEnabled(false);
    }

    public void rodaComando(String comm) {
    }

    public int getID() {
        return this.infoDiagrama.getID();
    }

    public String getUniversalUnicID() {
        return ((InfoDiagrama)this.infoDiagrama).getDiagramaUniversalUnicID();
    }

    public final void ReGeraUniversalUnicID() {
        ((InfoDiagrama)this.infoDiagrama).ReGeraGuardaUnicDiagramaID();
    }

    public String getNomeFormatado() {
        return this.getNome().isEmpty() ? "<<" + this.getTipoDeDiagramaFormatado() + ">>" : this.getNome();
    }

    public void setFromString(String str, int tag) {
    }

    public void OnAfterLoad(boolean isXml) {
    }

    public boolean isAlterado() {
        return this.getListaDeItens().size() > 1 || this.getMudou() || !"".equals(this.getArquivo());
    }

    public void ProcessPaint(Graphics2D Canvas) {
        double z = this.master.getBox().getZoom();
        Canvas.scale(z, z);
        if (this.master.isShowGrid()) {
            this.PinteGrade(Canvas);
        }
        if (this.master.getBox().isMostrarAreaImpressao()) {
            this.PaintAI(Canvas, this.master.getBox().areaImpressaoWidth, this.master.getBox().areaImpressaoHeigth);
        }
        for (int i = this.subItens.size() - 1; i > -1; --i) {
            Elementar e = this.subItens.get(i);
            if (!e.CanPaint()) continue;
            e.DoPaint(Canvas);
        }
        this.superAncorador.DoPaint(Canvas);
    }

    public void ExternalPaint(Graphics g) {
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Graphics2D Canvas = (Graphics2D)g;
        Canvas.addRenderingHints(renderHints);
        Canvas.setStroke(new BasicStroke(1.0f, 1, 1));
        Canvas.setPaint(Color.BLACK);
        for (int i = this.subItens.size() - 1; i > -1; --i) {
            Elementar e = this.subItens.get(i);
            if (!e.CanPaint()) continue;
            e.DoPaint(Canvas);
        }
    }

    public void ExternalPaintSelecao(Graphics g) {
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Graphics2D Canvas = (Graphics2D)g;
        Canvas.addRenderingHints(renderHints);
        Canvas.setStroke(new BasicStroke(1.0f, 1, 1));
        Canvas.setPaint(Color.BLACK);
        for (int i = this.getItensSelecionados().size() - 1; i > -1; --i) {
            FormaElementar e = this.getItensSelecionados().get(i);
            e.HidePontos(true);
            if (e.CanPaint()) {
                e.DoPaint(Canvas);
            }
            e.HidePontos(false);
        }
    }

    public Point getPontoExtremo() {
        int borda = 4;
        int rX = 0;
        int rY = 0;
        for (FormaElementar el : this.ListaDeItens) {
            rX = Math.max(rX, el.getLeftWidth());
            rY = Math.max(rY, el.getTopHeight());
        }
        if (rX > 0) {
            rX += 4;
        }
        if (rY > 0) {
            rY += 4;
        }
        return new Point(rX, rY);
    }

    public Point getPontoExtremoSelecionado() {
        int borda = 4;
        int rX = 0;
        int rY = 0;
        for (FormaElementar el : this.getItensSelecionados()) {
            rX = Math.max(rX, el.getLeftWidth());
            rY = Math.max(rY, el.getTopHeight());
        }
        if (rX > 0) {
            rX += 4;
        }
        if (rY > 0) {
            rY += 4;
        }
        return new Point(rX, rY);
    }

    public Point getPontoMenorSelecionado() {
        int rX = this.getWidth();
        int rY = this.getHeight();
        for (FormaElementar el : this.getItensSelecionados()) {
            rX = Math.min(rX, el.getLeft());
            rY = Math.min(rY, el.getTop());
        }
        return new Point(rX, rY);
    }

    public void mouseClick(MouseEvent e) {
    }

    public void mouseDblClick(MouseEvent e) {
        this.setElementarSobMouse(this.superAncorador.IsMe((e = this.tradutorZoom(e)).getPoint()) ? this.superAncorador : this.CaptureFromPoint(e.getPoint()));
        if (this.elementarSobMouse != null) {
            this.elementarSobMouse.mouseDblClicked(e);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.master.requestFocus();
        e = this.tradutorZoom(e);
        if (this.comando != null) {
            this.isLoadCreate = true;
            this.RealiseComando(e.getPoint());
            this.isLoadCreate = false;
            if (this.cliq1 == null) {
                this.DoMuda(null);
            }
            return;
        }
        if (this.elementarSobMouse == null || this.elementarSobMouse != this.elementarSobMouse.IsMeOrMine(e.getPoint())) {
            this.setElementarSobMouse(this.CaptureFromPoint(e.getPoint()));
        }
        if (this.elementarSobMouse != null) {
            this.elementarSobMouse.mousePressed(e);
            this.draging = true;
            if (this.elementarSobMouse != this.superAncorador) {
                this.superAncorador.SetVisible(false);
            }
        } else {
            this.DiagramaDownPos.setLocation(e.getPoint());
            this.isMouseDown = true;
            this.master.InitMultiSel(this.DiagramaDownPos);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.processaMouseEntredExited(e, this.elementarSobMouse, false);
    }

    private void processaMouseEntredExited(MouseEvent ev, Elementar el, boolean enter) {
        ev = this.tradutorZoom(ev);
        if (el != null) {
            if (enter) {
                el.mouseEntered(ev);
            } else {
                el.mouseExited(ev);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        e = this.tradutorZoom(e);
        if (this.draging && this.elementarSobMouse != null) {
            this.elementarSobMouse.mouseDragged(e);
            return;
        }
        if (this.isMouseDown) {
            int x = e.getX();
            int y = e.getY();
            final int ALeft = x < this.DiagramaDownPos.x ? x : this.DiagramaDownPos.x;
            final int ATop = y < this.DiagramaDownPos.y ? y : this.DiagramaDownPos.y;
            final int AWidth = Math.abs(x - this.DiagramaDownPos.x);
            final int AHeight = Math.abs(y - this.DiagramaDownPos.y);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Diagrama.this.master.getMultSel().setBounds(ALeft, ATop, AWidth, AHeight);
                    Diagrama.this.master.repaint();
                }
            });
        }
    }

    protected MouseEvent tradutorZoom(MouseEvent e) {
        double z = 1.0 / this.getZoom();
        Point p = new Point((int)((double)e.getX() * z), (int)((double)e.getY() * z));
        MouseEvent ex = new MouseEvent(this.master.getBox(), e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), false);
        return ex;
    }

    protected Point tradutorZoom(Point e) {
        double z = 1.0 / this.getZoom();
        return new Point((int)((double)e.x * z), (int)((double)e.y * z));
    }

    public Rectangle ZoomRectangle(Rectangle r) {
        double z = this.getZoom();
        return new Rectangle((int)((double)r.x * z), (int)((double)r.y * z), (int)((double)r.width * z), (int)((double)r.height * z));
    }

    public void mouseMoved(MouseEvent e) {
        if (this.isMouseDown || this.draging) {
            this.mouseReleased(e);
            return;
        }
        e = this.tradutorZoom(e);
        Elementar olde = this.elementarSobMouse;
        this.setElementarSobMouse(this.superAncorador.IsMe(e.getPoint()) ? this.superAncorador : this.CaptureFromPoint(e.getPoint()));
        if (this.elementarSobMouse != null) {
            this.elementarSobMouse.mouseMoved(e);
        } else {
            this.setCursor(new Cursor(0));
        }
        if (this.comando != null) {
            Elementar composicao = this.elementarSobMouse;
            if (composicao != null && this.elementarSobMouse.isComposto()) {
                composicao = composicao.ProcessaComposicao(e.getPoint());
            }
            this.ProcessaOverDraw(false, composicao);
        } else if (olde != this.elementarSobMouse) {
            this.processaMouseEntredExited(e, olde, false);
            this.processaMouseEntredExited(e, this.elementarSobMouse, true);
        }
    }

    public Rectangle AlmentarRetangulo(Rectangle r, int x, int y) {
        return Utilidades.Grow(r, x, y, 0);
    }

    public void ProcessaOverDraw(boolean limpa, Elementar el) {
        int x = 4;
        int y = 4;
        if (limpa) {
            if (this.overDraw != null) {
                this.overDraw.setOverMe(false);
                Rectangle rec = this.AlmentarRetangulo(this.overDraw.getBounds(), x, y);
                this.overDraw.InvalidateArea(rec);
                this.overDraw = null;
            }
            return;
        }
        if (el == null && this.overDraw != null) {
            this.overDraw.setOverMe(false);
            Rectangle rec = this.AlmentarRetangulo(this.overDraw.getBounds(), x, y);
            this.overDraw.InvalidateArea(rec);
            this.overDraw = null;
        } else if (el != null && el instanceof FormaElementar && el != this.overDraw) {
            Rectangle rec;
            if (this.overDraw != null) {
                this.overDraw.setOverMe(false);
                rec = this.AlmentarRetangulo(this.overDraw.getBounds(), x, y);
                this.overDraw.InvalidateArea(rec);
            }
            this.overDraw = (FormaElementar)el;
            this.overDraw.setOverMe(true);
            rec = this.AlmentarRetangulo(this.overDraw.getBounds(), x, y);
            this.overDraw.InvalidateArea(rec);
        }
    }

    public Elementar CaptureFromPoint(Point ponto) {
        Elementar res = this.getSelecionado();
        if (res != null && (res = ((Elementar)res).IsMeOrMine(ponto)) != null) {
            return res;
        }
        for (Elementar el : this.subItens) {
            res = el.IsMeOrMine(ponto);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public Elementar CaptureFromPoint(Elementar nor, Point ponto) {
        Elementar res = null;
        for (Elementar el : this.subItens) {
            res = el.IsMeOrMine(ponto, nor);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public Forma CaptureBaseFromPoint(Elementar nor, Point ponto) {
        Elementar res = null;
        for (Elementar el : this.subItens) {
            res = el.IsMeOrMineBase(ponto, nor);
            if (res == null) continue;
            return (Forma)res;
        }
        return null;
    }

    public Elementar getElementarSobMouse() {
        return this.elementarSobMouse;
    }

    public void setElementarSobMouse(Elementar elementarSobMouse) {
        this.elementarSobMouse = elementarSobMouse;
    }

    public void mouseReleased(MouseEvent e) {
        e = this.tradutorZoom(e);
        if (this.isMouseDown) {
            boolean combine;
            this.isMouseDown = false;
            Rectangle recsel = this.master.getMultSel().getBounds();
            boolean bl = combine = this.isShiftDown() || this.isControlDown();
            if (!combine) {
                this.ClearSelect();
            }
            Point p = e.getPoint();
            this.master.FinishMultiSel();
            this.subItens.stream().filter(c -> c instanceof FormaElementar).map(c -> (FormaElementar)c).filter(item -> item.IntersectPath(recsel)).sorted((p1, p2) -> Double.compare(Utilidades.distance(p1.getLocation(), p), Utilidades.distance(p2.getLocation(), p))).forEach(item -> this.DiagramaDoSelecao((FormaElementar)item, true, true));
            this.repaint(Utilidades.Grow(recsel, 2, 2, 0));
        }
        if (this.draging && this.elementarSobMouse != null) {
            this.elementarSobMouse.mouseReleased(e);
            this.superAncorador.Posicione(this.getSelecionado());
        }
        this.draging = false;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isControlDown()) {
            if (e.getWheelRotation() < 0) {
                this.getEditor().ZoomMais();
            } else {
                this.getEditor().ZoomMenos();
            }
            e.consume();
        }
    }

    public int getElementarID() {
        return ++this.TotalID;
    }

    public boolean getMudou() {
        return this.mudou;
    }

    public void setMudou(boolean value) {
        if (this.mudou != value) {
            this.mudou = value;
            if (!value) {
                this.PerformInspector();
            }
            this.getEditor().getShowDiagramas().repaint();
        }
    }

    public void HidePontosOnSelecao(boolean esconde) {
        for (FormaElementar item : this.itensSelecionados) {
            item.HidePontos(esconde);
        }
    }

    public boolean DiagramaDoSelecao(FormaElementar item) {
        return this.DiagramaDoSelecao(item, false, false);
    }

    public boolean DiagramaDoSelecao(FormaElementar item, boolean ehmouse, boolean ForcarMultSel) {
        boolean combine;
        if (item == null) {
            this.ClearSelect();
            return false;
        }
        if (!item.isSelecionavel()) {
            this.master.getControler().makeEnableComands();
            return false;
        }
        boolean bl = combine = (this.isShiftDown() || this.isControlDown()) && ehmouse || ForcarMultSel;
        if (this.itensSelecionados.indexOf(item) == -1) {
            if (combine) {
                this.AddSelect(item);
            } else {
                if (this.itensSelecionados.size() > 0) {
                    this.ClearSelect(false);
                }
                this.AddSelect(item);
            }
            this.PerformInspector();
            this.master.getControler().makeEnableComands();
            this.superAncorador.Posicione(this.getSelecionado());
            return true;
        }
        if (combine && this.itensSelecionados.size() > 1) {
            this.RemoveSelect(item);
            this.PerformInspector();
            this.superAncorador.Posicione(this.getSelecionado());
            return false;
        }
        this.master.getControler().makeEnableComands();
        this.superAncorador.Posicione(this.getSelecionado());
        return true;
    }

    private void PontosCor(FormaElementar item) {
        this.PontosCor(item, false);
    }

    private void PontosCor(FormaElementar item, boolean verde) {
        item.DoPontoCor(verde);
    }

    private void AddSelect(FormaElementar item) {
        this.itensSelecionados.add(item);
        if (this.itensSelecionados.size() > 1) {
            this.PontosCor(item, true);
        }
        item.setSelecionado(true);
    }

    public void PromoveToFirstSelect(FormaElementar item) {
        int idx = this.itensSelecionados.indexOf(item);
        if (idx > 0) {
            this.PontosCor(this.itensSelecionados.get(0), true);
            this.itensSelecionados.remove(item);
            this.itensSelecionados.add(0, item);
            this.PontosCor(item);
        }
    }

    private void RemoveSelect(FormaElementar item) {
        if (this.itensSelecionados.indexOf(item) == -1) {
            return;
        }
        this.itensSelecionados.remove(item);
        this.PontosCor(item);
        item.setSelecionado(false);
        this.PontosCor(this.itensSelecionados.get(0));
    }

    public void ClearSelect() {
        this.ClearSelect(true);
    }

    public void ClearSelect(boolean performInsp) {
        this.itensSelecionados.forEach(item -> {
            this.PontosCor((FormaElementar)item);
            item.setSelecionado(false);
        });
        this.itensSelecionados.clear();
        if (performInsp) {
            this.master.getControler().makeEnableComands();
            this.PerformInspector();
        }
        this.superAncorador.SetVisible(false);
    }

    public boolean TemSelecionado() {
        return this.itensSelecionados.size() > 0;
    }

    public FormaElementar getSelecionado() {
        if (this.TemSelecionado()) {
            return this.itensSelecionados.get(0);
        }
        return null;
    }

    public void setSelecionado(FormaElementar sel) {
        this.DiagramaDoSelecao(sel, false, false);
    }

    public void ReciveProcessMove(FormaElementar nor, int x, int y) {
        this.itensSelecionados.stream().filter(item -> item != nor).forEach(item -> item.DoMove(x, y));
    }

    public boolean isShiftDown() {
        return this.master.isShiftDown();
    }

    public boolean isAltDown() {
        return this.master.isAltDown();
    }

    public boolean isControlDown() {
        return this.master.isControlDown();
    }

    public void DoFormaResize(Rectangle ret) {
        if (ret.x == 0 && ret.y == 0 && ret.width == 0 && ret.height == 0) {
            return;
        }
        this.itensSelecionados.stream().filter(de -> de instanceof Forma).map(de -> (Forma)de).forEach(item -> item.ReciveFormaResize(ret));
        this.repaint();
    }

    public void DoBaseReenquadreReposicione() {
        this.itensSelecionados.stream().filter(item -> !item.Reenquadre()).forEach(item -> item.Reposicione());
    }

    public void ProcesseTeclas(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setComando(null);
            return;
        }
        if (e.getKeyCode() == 10) {
            InspectorItemBase ppr = this.getEditor().getInspectorEditor().FindByProperty("setTexto");
            if (ppr != null) {
                if (this.getEditor().getInspectorEditor().getSelecionado() == ppr) {
                    this.getEditor().getInspectorEditor().PerformSelect(null);
                }
                this.getEditor().getInspectorEditor().PerformSelect(ppr);
                if (ppr instanceof InspectorItemExtender) {
                    ((InspectorItemExtender)ppr).ExternalRun();
                }
            }
            return;
        }
        if (this.itensSelecionados.isEmpty()) {
            return;
        }
        FormaElementar item = this.itensSelecionados.get(0);
        int x = 0;
        int y = 0;
        int inc = 3;
        if (e.isControlDown()) {
            inc = 1;
        }
        switch (e.getKeyCode()) {
            case 37: {
                x = -inc;
                y = 0;
                break;
            }
            case 39: {
                x = inc;
                y = 0;
                break;
            }
            case 38: {
                x = 0;
                y = -inc;
                break;
            }
            case 40: {
                x = 0;
                y = inc;
            }
        }
        if (item.isAncorado()) {
            e.consume();
        } else if (x != 0 || y != 0) {
            if (e.isShiftDown() && item instanceof Forma) {
                Rectangle rec = new Rectangle(0, 0, -x, -y);
                ((Forma)item).DoFormaResize(rec);
            } else {
                item.DoRaiseMove(x, y);
            }
            this.superAncorador.Posicione(item);
            this.DoBaseReenquadreReposicione();
            this.HidePontosOnSelecao(false);
            this.PerformInspector();
            e.consume();
        }
    }

    public void ProcesseTeclas(int k) {
        if (this.itensSelecionados.isEmpty()) {
            return;
        }
        FormaElementar item = this.itensSelecionados.get(0);
        if (item.isAncorado()) {
            return;
        }
        int x = 0;
        int y = 0;
        int inc = this.isControlDown() ? 1 : 3;
        switch (k) {
            case 37: {
                x = -inc;
                y = 0;
                break;
            }
            case 39: {
                x = inc;
                y = 0;
                break;
            }
            case 38: {
                x = 0;
                y = -inc;
                break;
            }
            case 40: {
                x = 0;
                y = inc;
            }
        }
        if (x != 0 || y != 0) {
            if (this.isShiftDown() && item instanceof Forma) {
                Rectangle rec = new Rectangle(0, 0, -x, -y);
                ((Forma)item).DoFormaResize(rec);
            } else {
                item.DoRaiseMove(x, y);
            }
            this.superAncorador.Posicione(item);
            this.DoBaseReenquadreReposicione();
            this.HidePontosOnSelecao(false);
        }
        this.master.requestFocus();
        this.PerformInspector();
    }

    public boolean SelecioneProximo() {
        block4: {
            if (this.itensSelecionados.isEmpty()) {
                return false;
            }
            FormaElementar item = this.itensSelecionados.get(0);
            if (this.itensSelecionados.size() == 1 && this.ListaDeItens.size() > 1) {
                int idxAtual;
                int idx = idxAtual = this.ListaDeItens.indexOf(item);
                do {
                    if (++idx >= this.ListaDeItens.size()) {
                        idx = 0;
                    }
                    if (idx == idxAtual) break block4;
                } while (!(item = this.ListaDeItens.get(idx)).isSelecionavel());
                this.DiagramaDoSelecao(item, false, false);
                return true;
            }
        }
        return false;
    }

    public boolean SelecioneAnterior() {
        block4: {
            if (this.itensSelecionados.isEmpty()) {
                return false;
            }
            FormaElementar item = this.itensSelecionados.get(0);
            if (this.itensSelecionados.size() == 1 && this.ListaDeItens.size() > 1) {
                int idxAtual;
                int idx = idxAtual = this.ListaDeItens.indexOf(item);
                do {
                    if (--idx < 0) {
                        idx = this.ListaDeItens.size() - 1;
                    }
                    if (idx == idxAtual) break block4;
                } while (!(item = this.ListaDeItens.get(idx)).isSelecionavel());
                this.DiagramaDoSelecao(item, false, false);
                return true;
            }
        }
        return false;
    }

    public void SelecioneTodos() {
        this.ClearSelect(false);
        for (FormaElementar it : this.getListaDeItens()) {
            this.DiagramaDoSelecao(it, false, true);
        }
        this.PerformInspector();
    }

    public final void Add(FormaElementar aThis) {
        this.subItens.add(aThis);
        this.ListaDeItens.add(aThis);
    }

    public boolean IsMultSelecionado() {
        return this.itensSelecionados.size() > 1;
    }

    private boolean Remove(FormaElementar item) {
        if (!item.isCanBeDeleted()) {
            return item.AskToDelete();
        }
        this.ListaDeItens.remove(item);
        this.subItens.remove(item);
        item.Destroy();
        return true;
    }

    public boolean Remove(FormaElementar item, boolean removeSel) {
        if (this.Remove(item)) {
            if (removeSel) {
                this.itensSelecionados.remove(item);
            }
            return true;
        }
        return false;
    }

    public boolean deleteSelecao() {
        if (this.TemSelecionado()) {
            this.itensSelecionados.stream().forEach(el -> this.Remove((FormaElementar)el));
            this.itensSelecionados.clear();
            this.DoMuda(null);
            this.repaint();
            this.master.getControler().makeEnableComands();
            return true;
        }
        return false;
    }

    protected void setComando(Controler.Comandos cmd) {
        this.comando = cmd;
        if (cmd == null) {
            this.master.NoAction();
            this.setCursor(new Cursor(0));
            this.ProcessaOverDraw(true, null);
        }
    }

    public Controler.Comandos getComando() {
        return this.comando;
    }

    public void DoAction(ActionEvent ev) {
        if (ev.getActionCommand() == null || ev.getActionCommand().isEmpty()) {
            this.setComando(null);
            return;
        }
        try {
            Controler.Comandos cmd = Controler.Comandos.valueOf(ev.getActionCommand());
            if (this.comando != cmd) {
                this.cliq1 = null;
                this.cliq2 = null;
            }
            this.setComando(cmd);
        }
        catch (Exception e) {
            this.setComando(null);
        }
    }

    public FormaElementar ExternalRealiseComando(Controler.Comandos cmd, Point posi) {
        Controler.Comandos c = this.getComando();
        this.setComando(cmd);
        FormaElementar res = this.RealiseComando(posi);
        this.setComando(c);
        return res;
    }

    protected FormaElementar RealiseComando(Point posi) {
        FormaElementar resu = null;
        Controler.Comandos com = this.comando;
        Elementar res = null;
        switch (com) {
            case cmdDesenhador: {
                Desenhador dz = new Desenhador(this);
                dz.SetBounds(posi.x, posi.y, 250, 150);
                dz.Reenquadre();
                resu = dz;
                break;
            }
            case cmdLegenda: {
                Legenda leg = new Legenda(this);
                leg.SetBounds(posi.x, posi.y, 150, 45);
                leg.Reenquadre();
                resu = leg;
                break;
            }
            case cmdTexto: {
                res = this.CaptureFromPoint(posi);
                Texto Tx = new Texto(this, "Texto");
                if (res instanceof SuperLinha) {
                    Tx.SetBounds(posi.x, posi.y, 100, 18);
                    Tx.setAlinhamento(FormaTextoBase.AlinhamentoTexto.alEsquerda);
                    Tx.setTipo(PreTexto.TipoTexto.tpEmBranco);
                    Tx.setCentrarVertical(false);
                    ((SuperLinha)res).setTag(Tx);
                } else {
                    Tx.SetBounds(posi.x, posi.y, 150, 36);
                    Tx.Reenquadre();
                }
                resu = Tx;
                break;
            }
            case cmdApagar: {
                res = this.CaptureFromPoint(posi);
                if (res instanceof FormaElementar) {
                    resu = (FormaElementar)res;
                    this.ClearSelect();
                    this.setSelecionado(resu);
                    this.deleteSelecao();
                }
                resu = null;
            }
        }
        this.cliq1 = null;
        this.cliq2 = null;
        if (!this.master.isControlDown()) {
            this.setComando(null);
        } else {
            this.setComando(com);
        }
        if (resu != null) {
            resu.BringToFront();
        }
        return resu;
    }

    public void PerformInspector() {
        if (!this.itensSelecionados.isEmpty()) {
            this.getEditor().PerformInspectorFor(this.itensSelecionados.get(0));
        } else {
            this.getEditor().PerformInspectorFor(this.infoDiagrama);
        }
    }

    public void PerformInspector(boolean force) {
        if (force) {
            this.getEditor().getInspectorEditor().ForceFullOnCarregue();
        }
        this.PerformInspector();
    }

    public Object processeEdicaoSubItem(FormaElementar ed, BoxingJava bj) {
        return ed;
    }

    public boolean AceitaEdicao(InspectorProperty prop, String valor) {
        FormaElementar param = this.itensSelecionados.isEmpty() ? this.infoDiagrama : this.itensSelecionados.get(0);
        Object ed = param;
        String P = prop.property;
        if (P.indexOf(46) > 0) {
            BoxingJava bj = new BoxingJava(P);
            ed = this.processeEdicaoSubItem(param, bj);
            P = bj.Str;
        }
        String propriedade = P;
        Class[] par2 = new Class[1];
        Object[] vl = new Object[1];
        try {
            switch (prop.tipo) {
                case tpBooleano: {
                    par2[0] = Boolean.TYPE;
                    vl[0] = Boolean.parseBoolean(valor);
                    break;
                }
                case tpCor: {
                    par2[0] = Color.class;
                    vl[0] = Utilidades.StringToColor(valor);
                    break;
                }
                case tpMenu: {
                    par2[0] = Integer.TYPE;
                    int p = Integer.parseInt(valor);
                    vl[0] = p;
                    break;
                }
                case tpNumero: {
                    par2[0] = Integer.TYPE;
                    int tmp = Integer.parseInt(valor);
                    vl[0] = tmp;
                    String[] pprtMv = new String[]{"setLeft", "setTop", "setWidth", "setHeight"};
                    if (Arrays.asList(pprtMv).indexOf(propriedade) <= -1 || !(ed instanceof Forma)) break;
                    this.IsStopEvents = true;
                    this.itensSelecionados.stream().filter(e -> e.getClass().equals(param.getClass())).map(f -> (Forma)f).forEach(Ed -> {
                        Rectangle ret = propriedade.equals(pprtMv[0]) ? new Rectangle(Ed.getLeft() - tmp, 0, 0, 0) : (propriedade.equals(pprtMv[1]) ? new Rectangle(0, Ed.getTop() - tmp, 0, 0) : (propriedade.equals(pprtMv[2]) ? new Rectangle(0, 0, Ed.getWidth() - tmp, 0) : new Rectangle(0, 0, 0, Ed.getHeight() - tmp)));
                        Ed.ReciveFormaResize(ret);
                        Ed.DoRaizeReenquadreReposicione();
                    });
                    this.IsStopEvents = false;
                    this.DoMuda(param);
                    return true;
                }
                default: {
                    par2[0] = String.class;
                    vl[0] = valor;
                }
            }
            String[] multi = new String[]{"setForeColor", "setTipoAtributo"};
            if (Arrays.asList(multi).indexOf(propriedade) == -1 || ed instanceof Forma && ((Forma)ed).getPrincipal() != null) {
                Class<?> cl = ed.getClass();
                Method mthd = cl.getMethod(propriedade, par2);
                mthd.invoke(ed, vl);
                this.DoMuda(param);
            } else {
                String[] multi_any = new String[]{"setForeColor"};
                List lst = Arrays.asList(multi_any).indexOf(propriedade) > -1 ? this.itensSelecionados.stream().collect(Collectors.toList()) : this.itensSelecionados.stream().filter(e -> e.getClass().equals(param.getClass())).collect(Collectors.toList());
                this.IsStopEvents = true;
                for (FormaElementar Ed2 : lst) {
                    Class<?> cl = Ed2.getClass();
                    Method mthd = cl.getMethod(propriedade, par2);
                    mthd.invoke((Object)Ed2, vl);
                }
                this.IsStopEvents = false;
                this.DoMuda(param);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
            BrLogger.Logger("ERROR_SET_PROPERTY", e2.getMessage());
            this.IsStopEvents = false;
            this.superAncorador.InvalidateArea();
            return false;
        }
        this.superAncorador.InvalidateArea();
        return true;
    }

    public boolean ColeFormatacao(FormaElementar param, InspectorProperty prop, String valor) {
        Object ed = param;
        String propriedade = prop.property;
        if (propriedade.indexOf(46) > 0) {
            BoxingJava bj = new BoxingJava(propriedade);
            ed = this.processeEdicaoSubItem(param, bj);
            propriedade = bj.Str;
        }
        Class[] par2 = new Class[1];
        Object[] vl = new Object[1];
        try {
            switch (prop.tipo) {
                case tpBooleano: {
                    par2[0] = Boolean.TYPE;
                    vl[0] = Boolean.parseBoolean(valor);
                    break;
                }
                case tpCor: {
                    par2[0] = Color.class;
                    vl[0] = Utilidades.StringToColor(valor);
                    break;
                }
                case tpMenu: {
                    par2[0] = Integer.TYPE;
                    int p = Integer.parseInt(valor);
                    vl[0] = p;
                    break;
                }
                case tpNumero: {
                    par2[0] = Integer.TYPE;
                    int tmp = Integer.parseInt(valor);
                    vl[0] = tmp;
                    String[] pprtMv = new String[]{"setLeft", "setTop", "setWidth", "setHeight"};
                    if (Arrays.asList(pprtMv).indexOf(propriedade) <= -1 || !(ed instanceof Forma)) break;
                    Forma Ed = (Forma)ed;
                    Rectangle ret = propriedade.equals(pprtMv[0]) ? new Rectangle(Ed.getLeft() - tmp, 0, 0, 0) : (propriedade.equals(pprtMv[1]) ? new Rectangle(0, Ed.getTop() - tmp, 0, 0) : (propriedade.equals(pprtMv[2]) ? new Rectangle(0, 0, Ed.getWidth() - tmp, 0) : new Rectangle(0, 0, 0, Ed.getHeight() - tmp)));
                    Ed.DoFormaResize(ret);
                    Ed.DoRaizeReenquadreReposicione();
                    this.DoMuda(Ed);
                    return true;
                }
                default: {
                    par2[0] = String.class;
                    vl[0] = valor;
                }
            }
            Class<?> cl = ed.getClass();
            Method mthd = cl.getMethod(propriedade, par2);
            mthd.invoke(ed, vl);
            this.DoMuda(param);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            BrLogger.Logger("ERROR_SET_PROPERTY", e.getMessage());
            return false;
        }
        return true;
    }

    public final String Nomeie(String padrao) {
        String txt = Editor.fromConfiguracao.getValor("diagrama." + padrao + ".nome");
        int res = 1;
        ArrayList txts = new ArrayList();
        this.ListaDeItens.stream().filter(el -> el instanceof Forma).map(el -> (Forma)el).forEach(el -> el.EscrevaTexto(txts));
        while (txts.indexOf(txt + "_" + res) != -1) {
            ++res;
        }
        return txt + "_" + res;
    }

    public FormaElementar FindByID(int id) {
        for (FormaElementar f : this.getListaDeItens()) {
            if (f.getID() != id) continue;
            return f;
        }
        return null;
    }

    public void DoMuda(FormaElementar who) {
        if (this.isLoadCreate || this.isCarregando) {
            return;
        }
        this.setMudou(true);
        try {
            this.master.DoDiagramaMuda();
        }
        catch (Exception e) {
            BrLogger.Logger("ERROR_DIAGRAMA_MUDA", e.getMessage());
        }
        this.PerformInspector();
    }

    public static synchronized ByteArrayOutputStream SaveToStream(Diagrama othis) {
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            try (ObjectOutputStream out = new ObjectOutputStream(ba);){
                out.writeObject(othis);
            }
            othis.tick();
            return ba;
        }
        catch (IOException iOException) {
            BrLogger.Logger("ERROR_DIAGRAMA_SAVELOAD_STREAM", iOException.getMessage());
            return null;
        }
    }

    private static TipoDeDiagrama GetTipoOnXml(Document doc) {
        try {
            NodeList nodeLst = doc.getElementsByTagName(nodePrincipal);
            Element prin = (Element)nodeLst.item(0);
            String tp = prin.getAttribute("TIPO");
            return TipoDeDiagrama.valueOf(tp);
        }
        catch (Exception e) {
            BrLogger.Logger("ERROR_DIAGRAMA_LOAD_TIPO_XML", e.getMessage());
            return null;
        }
    }

    public static synchronized Diagrama LoadFromStream(ByteArrayOutputStream ba) {
        try {
            byte[] bytes = ba.toByteArray();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Diagrama res = (Diagrama)in.readObject();
            in.close();
            return res;
        }
        catch (IOException | ClassNotFoundException e) {
            BrLogger.Logger("ERROR_DIAGRAMA_LOAD", e.getMessage());
            return null;
        }
    }

    public static synchronized Diagrama LoadFromFile(File arq, Editor master) {
        if (arq == null || master.IsOpen(arq)) {
            return null;
        }
        Diagrama res = null;
        String onome = arq.getName();
        onome = util.Arquivo.IsbrM3(arq) ? onome.substring(0, onome.length() - "brM3".length() - 1) : onome.substring(0, onome.length() - "xml".length() - 1);
        if (util.Arquivo.IsbrM3(arq)) {
            try {
                FileInputStream fi = new FileInputStream(arq);
                try (ObjectInputStream in = new ObjectInputStream(fi);){
                    GuardaPadraoBrM seguranca = (GuardaPadraoBrM)in.readObject();
                    in.close();
                    res = seguranca.getDiagrama();
                    res.setMaster(master);
                }
                res.ReGeraUniversalUnicID();
                res.setArquivo(arq.getAbsolutePath());
                master.addLastOpened(arq.getAbsolutePath());
                res.SetNome(onome);
                return res;
            }
            catch (IOException | ClassNotFoundException | NullPointerException iOException) {
                BrLogger.Logger("ERROR_DIAGRAMA_LOAD_FILE_BRM", iOException.getMessage());
                return null;
            }
        }
        Document doc = XMLGenerate.LoadDocument(arq);
        if (doc == null) {
            return null;
        }
        TipoDeDiagrama tp = Diagrama.GetTipoOnXml(doc);
        res = master.Novo(tp);
        if (!res.LoadFromXML(doc, false)) {
            BrLogger.Logger("ERROR_DIAGRAMA_LOAD_FILE_XML", "[IS BRM XML?]");
        }
        res.ReGeraUniversalUnicID();
        res.setArquivo(arq.getAbsolutePath());
        res.SetNome(onome);
        master.addLastOpened(arq.getAbsolutePath());
        return res;
    }

    public static synchronized Diagrama LoadFromBrm(GuardaPadraoBrM seguranca, Editor master) {
        if (seguranca == null) {
            return null;
        }
        Diagrama res = seguranca.getDiagrama();
        res.setMaster(master);
        res.ReGeraUniversalUnicID();
        res.setArquivo("");
        res.SetNome(seguranca.Tag);
        return res;
    }

    public boolean LoadFromXML(Document doc, boolean colando) {
        HashMap<Element, FormaElementar> link = new HashMap<Element, FormaElementar>();
        try {
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPathExpression xpathExp = xpathFactory.newXPath().compile("//text()[normalize-space(.) = '']");
            NodeList emptyTextNodes = (NodeList)xpathExp.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < emptyTextNodes.getLength(); ++i) {
                Node emptyTextNode = emptyTextNodes.item(i);
                emptyTextNode.getParentNode().removeChild(emptyTextNode);
            }
            NodeList nodeLst = doc.getElementsByTagName(nodePrincipal);
            Node mer = nodeLst.item(0);
            nodeLst = mer.getChildNodes();
            if (colando) {
                this.ClearSelect(true);
                ((InfoDiagrama)this.infoDiagrama).setDiagramaOldUniversalUnicID(String.valueOf(((Element)mer).getAttribute("UniversalUnicID")));
            }
            this.isLoadCreate = true;
            this.isCarregando = true;
            int tl = 0;
            int maxID = 0;
            for (int s = 0; s < nodeLst.getLength(); ++s) {
                Node fstNode = nodeLst.item(s);
                if (fstNode.getNodeType() != 1) continue;
                Element fstElmnt = (Element)fstNode;
                FormaElementar res = this.runCriadorFromXml(fstElmnt, colando);
                if (res == null) {
                    BrLogger.Logger("ERROR_DIAGRAMA_LOAD", "Lixo ou objeto alien\u00edgena encontrado: " + fstElmnt.toString() + " - n\u00e3o \u00e9 poss\u00edvel colar este objeto", "[]");
                    continue;
                }
                ++tl;
                if (!colando) {
                    maxID = Math.max(maxID, res.getID());
                }
                link.put(fstElmnt, res);
                maxID = this.OnLoadingXMLitem(res, fstElmnt, colando, maxID, link);
            }
            if (!colando) {
                this.TotalID = maxID;
            }
            this.isLoadCreate = false;
            link.keySet().stream().forEach(el -> {
                FormaElementar proc = (FormaElementar)link.get(el);
                proc.CommitXML((Element)el, link);
            });
            this.isCarregando = false;
            if (colando && ((Element)mer).hasAttribute("FIRST_SEL")) {
                this.ReestrutureSelecao(((Element)mer).getAttribute("FIRST_SEL"), link);
            }
            if (tl > 0 && colando) {
                this.DoMuda(null);
            }
            this.PerformInspector();
        }
        catch (Exception e) {
            BrLogger.Logger("ERROR_DIAGRAMA_LOAD", e.getMessage());
            this.isLoadCreate = false;
            this.isCarregando = false;
            return false;
        }
        this.repaint();
        return true;
    }

    protected int OnLoadingXMLitem(FormaElementar res, Element fstElmnt, boolean colando, int maxID, HashMap<Element, FormaElementar> link) {
        return maxID;
    }

    protected void ReestrutureSelecao(String oid, HashMap<Element, FormaElementar> link) {
        FormaElementar ja = null;
        for (Element el : link.keySet()) {
            FormaElementar proc = link.get(el);
            if (ja == null && el.hasAttribute("ID") && el.getAttribute("ID").equals(oid)) {
                ja = proc;
            }
            this.DiagramaDoSelecao(proc, false, true);
        }
        if (ja != null) {
            this.PromoveToFirstSelect(ja);
        }
    }

    protected FormaElementar ReflectionObj(Class classeDoObj) {
        Class[] argsConstr = new Class[]{Diagrama.class};
        Object[] omodelo = new Object[]{this};
        try {
            Constructor construtor = classeDoObj.getConstructor(argsConstr);
            try {
                FormaElementar res = (FormaElementar)construtor.newInstance(omodelo);
                return res;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                BrLogger.Logger("ERROR_DIAGRAMA_LOAD_REFLECTION_CREATE_OBJ", e.getMessage());
            }
        }
        catch (NoSuchMethodException e) {
            BrLogger.Logger("ERROR_DIAGRAMA_LOAD_REFLECTION_CONSTRUCTOR", e.getMessage());
        }
        return null;
    }

    protected FormaElementar runCriadorFromXml(Element xml, boolean colando) {
        Class[] classes;
        int classe = xml.getNodeName().hashCode();
        if (classe == InfoDiagrama.class.getSimpleName().hashCode()) {
            if (!colando) {
                this.LoadFromXML(this.infoDiagrama, xml, false);
            }
            return this.infoDiagrama;
        }
        for (Class cl : classes = this.getCassesDoDiagrama()) {
            if (cl.getSimpleName().hashCode() != classe) continue;
            FormaElementar res = this.ReflectionObj(cl);
            if (res != null) {
                this.LoadFromXML(res, xml, colando);
            }
            return res;
        }
        return null;
    }

    protected void LoadFromXML(FormaElementar obj, Element xml, boolean colando) {
        try {
            obj.LoadFromXML(xml, colando);
        }
        catch (Exception e) {
            BrLogger.Logger("ERROR_OBJECT_LOAD", Integer.toString(obj.getID()) + " - " + obj.getClass().getSimpleName(), e.getMessage());
        }
    }

    public static String SaveToXml(Diagrama othis, boolean justSel) {
        return XMLGenerate.GeraXMLFrom(othis, justSel);
    }

    public boolean Salvar() {
        File arq = Dialogos.ShowDlgSaveDiagrama(this.master.getRootPane(), this);
        if (arq == null) {
            return false;
        }
        return this.Salvar(arq, true);
    }

    public boolean Salvar(String fileName) {
        if ("".equals(fileName) || fileName == null) {
            return this.Salvar();
        }
        File arq = new File(fileName);
        return this.Salvar(arq, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean Salvar(File fileName, boolean pergunta) {
        if (fileName.exists() && pergunta && Dialogos.ShowMessageConfirm(this.master.getRootPane(), Editor.fromConfiguracao.getValor("Controler.MSG_QUESTION_REWRITE")) != 0) {
            return false;
        }
        String txt = this.getNome();
        String onome = fileName.getName();
        this.versaoA = VERSAO_A;
        this.versaoB = VERSAO_B;
        this.versaoC = VERSAO_C;
        onome = util.Arquivo.IsbrM3(fileName) ? onome.substring(0, onome.length() - "brM3".length() - 1) : onome.substring(0, onome.length() - "xml".length() - 1);
        this.setNome(onome);
        if (util.Arquivo.IsbrM3(fileName)) {
            try {
                FileOutputStream fo = new FileOutputStream(fileName);
                try (ObjectOutputStream out2 = new ObjectOutputStream(fo);){
                    this.setArquivo("");
                    GuardaPadraoBrM seg = new GuardaPadraoBrM(this);
                    seg.versaoDiagrama = this.versaoA + "." + this.versaoB + "." + this.versaoC;
                    out2.writeObject(seg);
                }
                this.setArquivo(fileName.getAbsolutePath());
                this.master.addLastOpened(fileName.getAbsolutePath());
                this.setMudou(false);
                this.master.DoAutoSaveCompleto();
                this.PerformInspector();
                return true;
            }
            catch (IOException iOException) {
                BrLogger.Logger("ERROR_DIAGRAMA_SAVE_BRM", iOException.getMessage());
                this.setNome(txt);
                return false;
            }
        }
        try {
            StringWriter ou = XMLGenerate.GeraXMLtoSaveFrom(this, false);
            try (BufferedWriter out = new BufferedWriter(new FileWriter(fileName));){
                out.write(ou.getBuffer().toString());
                this.setArquivo(fileName.getAbsolutePath());
                this.master.addLastOpened(fileName.getAbsolutePath());
                this.setMudou(false);
                this.master.DoAutoSaveCompleto();
                this.PerformInspector();
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            BrLogger.Logger("ERROR_DIAGRAMA_SAVE_XML", iOException.getMessage());
            this.setNome(txt);
            return false;
        }
    }

    public boolean AutoSalvar(ArrayList<byte[]> as) {
        this.versaoA = VERSAO_A;
        this.versaoB = VERSAO_B;
        this.versaoC = VERSAO_C;
        try {
            ByteArrayOutputStream fo = new ByteArrayOutputStream();
            try (ObjectOutputStream out = new ObjectOutputStream(fo);){
                GuardaPadraoBrM seg = new GuardaPadraoBrM(this);
                seg.versaoDiagrama = this.versaoA + "." + this.versaoB + "." + this.versaoC;
                seg.Tag = this.getNome();
                out.writeObject(seg);
            }
            as.add(fo.toByteArray());
            return true;
        }
        catch (IOException iOException) {
            BrLogger.Logger("ERROR_DIAGRAMA_AUTOSAVE_MEM", iOException.getMessage());
            return false;
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void doCopy() {
        String res = Diagrama.SaveToXml(this, true);
        StringSelection vai = new StringSelection(res);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(vai, this);
    }

    public void doCopy(BufferedImage img) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        TransferableImage trans = new TransferableImage(img);
        clipboard.setContents(trans, this);
    }

    public void doPaste() {
        String txt = Diagrama.getClipboardContents();
        if (!"".equals(txt)) {
            Document doc = XMLGenerate.LoadDocument(txt);
            this.processePaste(doc);
        } else {
            BufferedImage img = Diagrama.getClipboardContentsImage();
            if (img != null) {
                int x = this.getEditor().getMargem() >= this.ScrPosicao.x ? 4 : this.ScrPosicao.x + 4 - this.getEditor().getMargem();
                int y = this.getEditor().getMargem() >= this.ScrPosicao.y ? 4 : this.ScrPosicao.y + 4 - this.getEditor().getMargem();
                Point p = this.tradutorZoom(new Point(x, y));
                x = p.x;
                y = p.y;
                FormaElementar xres = this.ExternalRealiseComando(Controler.Comandos.cmdDesenhador, p);
                Desenhador de = (Desenhador)xres;
                de.setTipoImg();
                de.setImagem(img);
                de.SetBounds(x, y, img.getWidth(), img.getHeight());
                de.InvalidateArea();
                this.DiagramaDoSelecao(de, false, false);
                this.DoMuda(null);
                this.PerformInspector();
            }
        }
    }

    public boolean doPaste(String txt) {
        if (!"".equals(txt)) {
            Document doc = XMLGenerate.LoadDocument(txt);
            return this.processePaste(doc);
        }
        return false;
    }

    private boolean processePaste(Document doc) {
        if (doc != null) {
            boolean res = this.LoadFromXML(doc, true);
            if (res) {
                Point p = this.getPontoMenorSelecionado();
                Point q = new Point(this.getEditor().getMargem() >= this.ScrPosicao.x ? this.ScrPosicao.x : this.ScrPosicao.x - this.getEditor().getMargem(), this.getEditor().getMargem() >= this.ScrPosicao.y ? this.ScrPosicao.y : this.ScrPosicao.y - this.getEditor().getMargem());
                q = this.tradutorZoom(q);
                int x = p.x - q.x;
                int y = p.y - q.y;
                ArrayList lst = new ArrayList();
                this.getItensSelecionados().stream().forEach(f -> lst.add(f));
                this.setSelecionado(null);
                lst.stream().filter(f -> f instanceof Forma).forEach(fe -> {
                    fe.HidePontos(true);
                    fe.DoMove(-x + 2 * fe.distSelecao, -y + 2 * fe.distSelecao);
                    fe.Reposicione();
                    fe.HidePontos(false);
                });
                lst.stream().filter(f -> f instanceof SuperLinha).map(sl -> (SuperLinha)sl).forEach(fe -> {
                    fe.HidePontos(true);
                    int n = -x;
                    fe.getClass();
                    int a = n + 2 * 2;
                    int n2 = -y;
                    fe.getClass();
                    int b = n2 + 2 * 2;
                    if (fe.getPontaA().getEm() == null && fe.getPontaB().getEm() == null) {
                        fe.DoMove(a, b);
                    } else {
                        if (fe.getPontaA().getEm() != null && fe.getPontaB().getEm() == null) {
                            fe.getPontos().stream().filter(pt -> pt != fe.getPontaA()).forEach(pt -> pt.DoMove(a, b));
                        }
                        if (fe.getPontaB().getEm() != null && fe.getPontaA().getEm() == null) {
                            fe.getPontos().stream().filter(pt -> pt != fe.getPontaB()).forEach(pt -> pt.DoMove(a, b));
                        }
                    }
                    fe.Reposicione();
                    fe.HidePontos(false);
                });
                if (!lst.isEmpty()) {
                    lst.stream().forEach(el -> this.DiagramaDoSelecao((FormaElementar)el, false, true));
                    this.PromoveToFirstSelect((FormaElementar)lst.get(0));
                }
            }
            return true;
        }
        return false;
    }

    public void repaint() {
        if (this.isCarregando) {
            return;
        }
        this.master.getBox().repaint();
    }

    public void repaint(Rectangle r) {
        if (this.isCarregando) {
            return;
        }
        r = this.ZoomRectangle(r);
        this.master.getBox().repaint(r);
    }

    public static String getClipboardContents() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException ex) {
                BrLogger.Logger("ERROR_DIAGRAMA_CLIPBOARD", ex.getMessage());
            }
        }
        return result;
    }

    public static BufferedImage getClipboardContentsImage() {
        boolean hasTransferableImg;
        BufferedImage result = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableImg = contents != null && contents.isDataFlavorSupported(DataFlavor.imageFlavor);
        if (hasTransferableImg) {
            try {
                result = (BufferedImage)contents.getTransferData(DataFlavor.imageFlavor);
            }
            catch (UnsupportedFlavorException | IOException ex) {
                BrLogger.Logger("ERROR_DIAGRAMA_CLIPBOARD", ex.getMessage());
            }
        }
        return result;
    }

    public String toString() {
        return super.toString() + "{" + Diagrama.SaveToXml(this, false) + "}";
    }

    public static Diagrama Factory(TipoDeDiagrama otipo, Editor ed) {
        Diagrama res = null;
        switch (otipo) {
            case tpConceitual: {
                res = new DiagramaConceitual(ed);
                break;
            }
            case tpLogico: {
                res = new DiagramaLogico(ed);
                break;
            }
            case tpFluxo: {
                res = new DiagramaFluxo(ed);
                break;
            }
            case tpAtividade: {
                res = new DiagramaAtividade(ed);
                break;
            }
            case tpEap: {
                res = new DiagramaEap(ed);
                break;
            }
            case tpLivre: {
                res = new DiagramaLivre(ed);
                break;
            }
            default: {
                res = new Diagrama(ed);
            }
        }
        ed.NomeieDiagrama(res);
        return res;
    }

    public boolean EstaColandoNoMesmoDigDaOrigem() {
        return ((InfoDiagrama)this.infoDiagrama).IsTheShame();
    }

    public int AlinhamentoH() {
        return ((InfoDiagrama)this.infoDiagrama).getAlinhamento_h();
    }

    public int AlinhamentoV() {
        return ((InfoDiagrama)this.infoDiagrama).getAlinhamento_v();
    }

    public void ExternalSuperAncorador() {
        this.superAncorador.Posicione(this.getSelecionado());
    }

    public void InfoDiagrama_ToXmlValores(Document doc, Element me) {
    }

    public boolean InfoDiagrama_LoadFromXML(Element me, boolean colando) {
        return true;
    }

    public boolean isRealce() {
        return this.realce;
    }

    public void SetRealce(boolean realce) {
        this.realce = realce;
    }

    public void setRealce(boolean realce) {
        if (this.realce == realce) {
            return;
        }
        this.realce = realce;
        if (!realce) {
            this.getListaDeItens().stream().filter(fo -> fo instanceof FormaElementar).forEach(fo -> fo.setDisablePainted(false));
        } else {
            ArrayList res = new ArrayList();
            this.getListaDeItens().stream().filter(f -> this.getItensSelecionados().indexOf(f) > -1).forEach(item -> {
                if (item instanceof Forma) {
                    this.AdicionePrinFromRealce(res, (FormaElementar)item);
                    Forma f = (Forma)item;
                    f.getListaDeFormasLigadas().forEach(lfl -> this.AdicioneSubsFromRealce(res, (FormaElementar)lfl));
                    f.getListaDeLigacoes().stream().filter(l -> l instanceof SuperLinha).forEach(lfl -> this.AdicioneSubsFromRealce(res, (FormaElementar)lfl));
                } else if (item instanceof SuperLinha) {
                    this.AdicionePrinFromRealce(res, (FormaElementar)item);
                    SuperLinha sl = (SuperLinha)item;
                    res.add(sl.getFormaPontaA());
                    res.add(sl.getFormaPontaB());
                }
            });
            this.getListaDeItens().stream().filter(f -> res.indexOf(f) == -1).forEach(fo -> fo.setDisablePainted(true));
        }
        this.repaint();
    }

    protected void AdicioneSubsFromRealce(ArrayList<FormaElementar> res, FormaElementar item) {
        Forma f;
        if (item instanceof Forma && (f = (Forma)item).isParte()) {
            res.add((Forma)f.getPrincipal());
            return;
        }
        res.add(item);
    }

    protected void AdicionePrinFromRealce(ArrayList<FormaElementar> res, FormaElementar item) {
        this.AdicioneSubsFromRealce(res, item);
    }

    public boolean LoadVersao(String fromXml) {
        if (fromXml == null || fromXml.isEmpty()) {
            return false;
        }
        ArrayList<String> ver = new ArrayList<String>();
        ver.add("3.0.0");
        ver.add("3.1.0");
        ver.add("3.2.0");
        fromXml = fromXml.trim();
        if (ver.indexOf(ver) == -1) {
            return false;
        }
        String[] v = fromXml.split("\\.");
        this.versaoA = v[0];
        this.versaoB = v[1];
        this.versaoC = v[2];
        return true;
    }

    public class AcaoDiagrama
    extends Acao {
        private Diagrama d;
        private String comm;

        public AcaoDiagrama(Editor editor, String texto, String ico, String descricao, String command) {
            super(editor, texto, ico, descricao, command);
            this.d = null;
            this.comm = "";
            this.comm = command;
        }

        public AcaoDiagrama(Diagrama diag, String texto, String ico, String descricao, String command) {
            this(diag.getEditor(), texto, ico, descricao, command);
            this.d = diag;
            this.comm = command;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (this.d != null) {
                this.d.rodaComando(this.comm);
            }
        }
    }

    public class clickForma {
        private final FormaElementar forma;
        private final Point ponto;

        public clickForma(FormaElementar forma, Point ponto) {
            this.forma = forma;
            this.ponto = ponto;
        }

        public FormaElementar getForma() {
            return this.forma;
        }

        public Point getPonto() {
            return this.ponto;
        }
    }

    public static enum TipoDeDiagrama {
        tpConceitual,
        tpLogico,
        tpFluxo,
        tpAtividade,
        tpEap,
        tpLivre;

    }
}

