/*
 * Decompiled with CFR 0.152.
 */
package desenho.preAnyDiagrama;

import controlador.Diagrama;
import desenho.preAnyDiagrama.PreLigacaoSetaComApenso;
import desenho.preAnyDiagrama.PreTexto;
import diagramas.atividade.SetaAtividade;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.XMLGenerate;

public class PreTextoApenso
extends PreTexto {
    private static final long serialVersionUID = 6920592210168176051L;
    private boolean MovimentacaoManual = false;
    private PreLigacaoSetaComApenso LinhaMestre = null;
    private transient double z = 0.0;

    public PreTextoApenso(Diagrama modelo) {
        super(modelo);
        this.AceitaAjusteAutmatico = false;
    }

    public PreTextoApenso(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.AceitaAjusteAutmatico = false;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorInteger(doc, "Alinhamento", this.getAlinhamento().ordinal()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "CentrarVertical", this.isCentrarVertical()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Tipo", this.getTipo().ordinal()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Autosize", this.isAutosize()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "MovimentacaoManual", this.isMovimentacaoManual()));
        NodeList nl = me.getElementsByTagName("Dicionario");
        if (nl != null && nl.getLength() > 0) {
            me.removeChild(nl.item(0));
        }
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        int l = XMLGenerate.getValorIntegerFrom(me, "GDirecao");
        if (l != -1) {
            this.setGDirecao(l);
        }
        this.setAlinhamentoByInt(XMLGenerate.getValorIntegerFrom(me, "Alinhamento"));
        this.setCentrarVertical(XMLGenerate.getValorBooleanFrom(me, "CentrarVertical"));
        this.setTipobyInt(XMLGenerate.getValorIntegerFrom(me, "Tipo"));
        Color c = XMLGenerate.getValorColorFrom(me, "BackColor");
        if (c != null) {
            this.setBackColor(c);
        }
        this.setMovimentacaoManual(XMLGenerate.getValorBooleanFrom(me, "MovimentacaoManual"));
        this.setAutosize(XMLGenerate.getValorBooleanFrom(me, "Autosize"));
        return true;
    }

    public boolean isMovimentacaoManual() {
        return this.MovimentacaoManual;
    }

    public void setMovimentacaoManual(boolean MovimentacaoManual) {
        if (this.MovimentacaoManual != MovimentacaoManual) {
            this.MovimentacaoManual = MovimentacaoManual;
            if (this.MovimentacaoManual || this.LinhaMestre == null || this.getMaster().IsMultSelecionado()) {
                return;
            }
            this.LinhaMestre.PrepareTexto();
            this.Reposicione();
        }
    }

    public void SetLinhaMestre(SetaAtividade LinhaMestre) {
        if (this.LinhaMestre == LinhaMestre) {
            return;
        }
        this.LinhaMestre = LinhaMestre;
        this.MovimentacaoManual = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        this.MovimentacaoManual = true;
    }

    public PreLigacaoSetaComApenso getLinhaMestre() {
        return this.LinhaMestre;
    }

    public void SetLinhaMestre(PreLigacaoSetaComApenso LinhaMestre) {
        if (this.LinhaMestre == LinhaMestre) {
            return;
        }
        this.LinhaMestre = LinhaMestre;
        this.MovimentacaoManual = false;
    }

    public void setLinhaMestre(PreLigacaoSetaComApenso LinhaMestre) {
        if (this.LinhaMestre == LinhaMestre) {
            return;
        }
        if (this.LinhaMestre != null) {
            this.LinhaMestre.SetTag(null);
        }
        this.LinhaMestre = LinhaMestre;
        if (this.LinhaMestre != null) {
            this.LinhaMestre.SetTag(this);
        }
        this.MovimentacaoManual = false;
    }

    @Override
    public void Posicione() {
        if (this.isMovimentacaoManual() || this.LinhaMestre == null || this.isSelecionado()) {
            return;
        }
        this.LinhaMestre.PrepareTexto();
    }

    @Override
    public boolean Destroy() {
        this.setLinhaMestre(null);
        return super.Destroy();
    }

    @Override
    public boolean AskToDelete() {
        if (this.LinhaMestre != null) {
            if (this.LinhaMestre.isSelecionado()) {
                return false;
            }
            return this.getMaster().Remove(this.LinhaMestre, false);
        }
        return super.AskToDelete();
    }

    @Override
    protected void ReSizedByAutoSize() {
        super.ReSizedByAutoSize();
        if (this.MovimentacaoManual || this.LinhaMestre == null || this.getMaster().IsMultSelecionado()) {
            return;
        }
        this.LinhaMestre.PrepareTexto();
        this.Reposicione();
    }

    @Override
    public void PinteTexto(Graphics2D g) {
        if (this.getMaster().getZoom() != this.z) {
            this.setTextoFormatado(null);
            this.z = this.getMaster().getZoom();
        }
        this.getTextoFormatado().PinteTexto(g, this.getForeColor(), this.getArea(), this.getTexto());
    }

    @Override
    public boolean getIsLoadedFromXML() {
        return false;
    }
}

