/*
 * Decompiled with CFR 0.152.
 */
package util;

import controlador.Configuer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import util.BrLogger;

public class TratadorDeImagens {
    public static Image makeColorTransparent(Image im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    public static Image ReColorBlackImg(ImageIcon im, Color novaCor) {
        BufferedImage destImage = new BufferedImage(im.getIconWidth(), im.getIconHeight(), 2);
        Graphics2D g = destImage.createGraphics();
        g.drawImage(im.getImage(), 0, 0, null);
        g.dispose();
        for (int i = 0; i < destImage.getHeight(); ++i) {
            for (int j = 0; j < destImage.getWidth(); ++j) {
                int rgb = destImage.getRGB(j, i);
                if (rgb == 0 || rgb == -1) continue;
                destImage.setRGB(j, i, novaCor.getRGB());
            }
        }
        return destImage;
    }

    public static ImageIcon loadFromResource(String key, boolean reescale) {
        try {
            ImageIcon ic = Configuer.getImageIconFromResource(key);
            Image img = TratadorDeImagens.makeColorTransparent(ic.getImage(), Color.WHITE);
            if (reescale) {
                return new ImageIcon(img.getScaledInstance(16, 16, 4));
            }
            return new ImageIcon(img);
        }
        catch (Exception e) {
            BrLogger.Logger("ERROR_LOAD_ICON", e.getMessage());
            return null;
        }
    }

    public static BufferedImage fromByteArray(byte[] imagebytes) {
        try {
            if (imagebytes != null && imagebytes.length > 0) {
                BufferedImage im = ImageIO.read(new ByteArrayInputStream(imagebytes));
                return im;
            }
        }
        catch (IOException e) {
            BrLogger.Logger("ERROR_IMG_FROMBYTES", e.getMessage());
        }
        return null;
    }

    public static byte[] toByteArray(BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            BufferedImage image = bufferedImage;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)image, "png", baos);
            }
            catch (IOException e) {
                BrLogger.Logger("ERROR_IMG_TOBYTES", e.getMessage());
            }
            byte[] b = baos.toByteArray();
            return b;
        }
        return new byte[0];
    }

    public static BufferedImage dye(ImageIcon image, Color color) {
        int w = image.getIconWidth();
        int h = image.getIconHeight();
        BufferedImage dyed = new BufferedImage(w, h, 2);
        Graphics2D g = dyed.createGraphics();
        g.drawImage(image.getImage(), 0, 0, null);
        g.setComposite(AlphaComposite.SrcAtop);
        g.setColor(color);
        g.fillRect(0, 0, w, h);
        g.dispose();
        return dyed;
    }
}

