/*
 * Decompiled with CFR 0.152.
 */
package desenho.linhas;

import controlador.Diagrama;
import controlador.inspector.InspectorProperty;
import desenho.Elementar;
import desenho.FormaElementar;
import desenho.formas.Forma;
import desenho.linhas.Linha;
import desenho.linhas.PontoDeLinha;
import desenho.preAnyDiagrama.PreTexto;
import diagramas.conceitual.Texto;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.XMLGenerate;

public class SuperLinha
extends Linha {
    private static final long serialVersionUID = -6648325468968978514L;
    private boolean inteligente = false;
    protected boolean showConfigSeta = true;
    public static final int distancia = 10;
    private PreTexto tag = null;
    private boolean temSetaPontaA = false;
    private boolean temSetaPontaB = false;
    protected int setaLargura = 10;
    private Shape SetaA = null;
    private Shape SetaB = null;
    private boolean setaAberta = true;

    public SuperLinha(Diagrama master) {
        super(master);
    }

    public boolean isInteligente() {
        return this.inteligente;
    }

    public void setInteligente(boolean inteligente) {
        if (this.inteligente != inteligente) {
            this.inteligente = inteligente;
        }
    }

    public void SetInteligente(boolean inteligente) {
        boolean md = this.inteligente != inteligente;
        this.setInteligente(inteligente);
        if (md && inteligente) {
            this.Clean();
        }
    }

    public void Inicie(int maisQuantosPontos, Point pFim, Point pIni) {
        if (this.getPontos().isEmpty()) {
            PontoDeLinha pt1 = this.NovoPonto();
            pt1.setCentro(pFim);
            PontoDeLinha ant = pt1;
            for (int i = 0; i < maisQuantosPontos; ++i) {
                ant = this.InserirPonto(ant);
                ant.IsTopOrBotton = false;
            }
            pt1 = this.InserirPonto(ant);
            pt1.IsTopOrBotton = true;
            pt1.setCentro(pIni);
        }
    }

    @Override
    public void ReciveClick(Elementar sender, boolean dbl, MouseEvent e) {
        if (dbl && sender instanceof PontoDeLinha) {
            PontoDeLinha pt = (PontoDeLinha)sender;
            if (pt.IsTopOrBotton) {
                return;
            }
            this.RemoveSubItem(pt);
            this.reSetBounds();
        }
    }

    @Override
    protected void ProcessaDblClick(MouseEvent e) {
        Point p = e.getPoint();
        for (int i = 1; i < this.getPontosParaDesenho().length; ++i) {
            if (!Linha.SegmentIntersectRectangle(p.x - 1, p.y - 1, p.x + 1, p.y + 1, this.getPontosParaDesenho()[i - 1].x, this.getPontosParaDesenho()[i - 1].y, this.getPontosParaDesenho()[i].x, this.getPontosParaDesenho()[i].y)) continue;
            PontoDeLinha pt = this.InserirPonto(i);
            pt.setCentro(p);
            pt.setVisible(true);
            this.mouseExited(null);
            return;
        }
    }

    @Override
    public synchronized void OrganizeLinha() {
        Point[] pointArray;
        int letra;
        int BLeft;
        if (!this.isInteligente()) {
            return;
        }
        Forma A = this.getFormaPontaA();
        Forma B = this.getFormaPontaB();
        if (A == null || B == null || A.isSelecionado() && B.isSelecionado()) {
            return;
        }
        A = (Forma)A.ProcessaComposicao();
        B = (Forma)B.ProcessaComposicao();
        int ladoA = this.getPontaA().getLado();
        int ladoB = this.getPontaB().getLado();
        Point pontaA = this.getPontaA().getCentro();
        Point pontaB = this.getPontaB().getCentro();
        boolean inver = false;
        int ATop = A.getTop();
        int BTop = B.getTop();
        int ALeft = A.getLeft();
        if (ALeft < (BLeft = B.getLeft())) {
            if (ATop < BTop) {
                letra = 67;
                if (A.getLeftWidth() >= BLeft) {
                    letra = 68;
                } else if (A.getTopHeight() >= BTop) {
                    letra = 66;
                }
            } else if (ATop > BTop) {
                letra = 73;
                if (A.getLeftWidth() >= BLeft) {
                    letra = 68;
                    inver = true;
                } else if (pontaA.y <= B.getTopHeight()) {
                    letra = 66;
                }
            } else {
                letra = 66;
            }
        } else if (ALeft > BLeft) {
            if (ATop < BTop) {
                letra = 73;
                inver = true;
                if (B.getLeftWidth() >= ALeft) {
                    letra = 68;
                    inver = false;
                } else if (pontaA.y >= BTop) {
                    letra = 66;
                }
            } else if (ATop > BTop) {
                letra = 67;
                inver = true;
                if (B.getLeftWidth() >= ALeft) {
                    letra = 68;
                } else if (B.getTopHeight() >= ATop) {
                    letra = 66;
                }
            } else {
                letra = 66;
                inver = true;
            }
        } else if (ATop > BTop) {
            letra = 68;
            inver = true;
        } else {
            letra = ATop < BTop ? 68 : 66;
        }
        if (inver) {
            B = this.getFormaPontaA();
            A = this.getFormaPontaB();
            A = (Forma)A.ProcessaComposicao();
            B = (Forma)B.ProcessaComposicao();
            ladoB = this.getPontaA().getLado();
            ladoA = this.getPontaB().getLado();
            pontaB = this.getPontaA().getCentro();
            pontaA = this.getPontaB().getCentro();
            ATop = A.getTop();
            BTop = B.getTop();
            ALeft = A.getLeft();
            BLeft = B.getLeft();
        }
        Rectangle r = A.getBounds();
        r.grow(10, 10);
        Point A1 = new Point(r.x, r.y);
        Point A0 = new Point(r.x, pontaA.y);
        Point A7 = new Point(r.x, r.y + r.height);
        Point A2 = new Point(pontaA.x, r.y);
        Point A6 = new Point(pontaA.x, r.y + r.height);
        Point A3 = new Point(r.x + r.width, r.y);
        Point A4 = new Point(r.x + r.width, pontaA.y);
        Point A5 = new Point(r.x + r.width, r.y + r.height);
        r = B.getBounds();
        r.grow(10, 10);
        Point B1 = new Point(r.x, r.y);
        Point B0 = new Point(r.x, pontaB.y);
        Point B7 = new Point(r.x, r.y + r.height);
        Point B2 = new Point(pontaB.x, r.y);
        Point B6 = new Point(pontaB.x, r.y + r.height);
        Point B3 = new Point(r.x + r.width, r.y);
        Point B4 = new Point(r.x + r.width, pontaB.y);
        Point B5 = new Point(r.x + r.width, r.y + r.height);
        int tmp1 = ALeft > BLeft ? (BLeft + ALeft + B.getWidth()) / 2 : (BLeft + ALeft + A.getWidth()) / 2;
        int tmp2 = ATop > BTop ? (BTop + ATop + B.getHeight()) / 2 : (BTop + ATop + A.getHeight()) / 2;
        Point pc = new Point(tmp1, tmp2);
        Point tmpPoint = null;
        Point p1 = null;
        Point p2 = null;
        Point p3 = null;
        Point p4 = null;
        block0 : switch (letra) {
            case 66: {
                block6 : switch (ladoA) {
                    case 0: {
                        switch (ladoB) {
                            case 0: {
                                p1 = A0;
                                if (this.pontoMaisProx(A0.y, A1.y, A7.y)) {
                                    if (A1.y + 10 < pontaB.y) {
                                        p2 = A1;
                                        p3 = new Point(pc.x, A1.y);
                                        p4 = new Point(pc.x, B0.y);
                                        break;
                                    }
                                    p2 = new Point(A0.x, B0.y);
                                    break;
                                }
                                if (A7.y - 10 > pontaB.y) {
                                    p2 = A7;
                                    p3 = new Point(pc.x, A7.y);
                                    p4 = new Point(pc.x, B0.y);
                                    break;
                                }
                                p2 = new Point(A7.x, B0.y);
                                break;
                            }
                            case 1: {
                                p1 = A0;
                                tmpPoint = this.menorPonto(A1, B2, false);
                                p2 = new Point(A1.x, tmpPoint.y);
                                p3 = new Point(B2.x, tmpPoint.y);
                                break;
                            }
                            case 2: {
                                p1 = A0;
                                if (this.pontoMaisProx(A0.y, A1.y, A7.y)) {
                                    tmpPoint = this.menorPonto(A1, B3, false);
                                    p2 = new Point(A1.x, tmpPoint.y);
                                    p3 = new Point(B3.x, tmpPoint.y);
                                } else {
                                    tmpPoint = this.maiorPonto(A7, B5, false);
                                    p2 = new Point(A7.x, tmpPoint.y);
                                    p3 = new Point(B5.x, tmpPoint.y);
                                }
                                p4 = B4;
                                break;
                            }
                            case 3: {
                                p1 = A0;
                                tmpPoint = this.maiorPonto(A7, B6, false);
                                p2 = new Point(A7.x, tmpPoint.y);
                                p3 = new Point(B6.x, tmpPoint.y);
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (ladoB) {
                            case 0: {
                                if (pontaA.y - 10 < pontaB.y) {
                                    p1 = A2;
                                    p2 = new Point(pc.x, A2.y);
                                    p4 = new Point(pc.x, B0.y);
                                    break;
                                }
                                p1 = new Point(A2.x, B0.y);
                                break;
                            }
                            case 1: {
                                tmpPoint = this.menorPonto(A2, B2, false);
                                p1 = new Point(A2.x, tmpPoint.y);
                                p2 = new Point(B2.x, tmpPoint.y);
                                break;
                            }
                            case 2: {
                                tmpPoint = this.menorPonto(A2, B3, false);
                                p1 = new Point(A2.x, tmpPoint.y);
                                p2 = new Point(B3.x, tmpPoint.y);
                                p3 = B4;
                                break;
                            }
                            case 3: {
                                p1 = A2;
                                p2 = new Point(pc.x, A2.y);
                                p3 = new Point(pc.x, B6.y);
                                p4 = B6;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (ladoB) {
                            case 0: {
                                p1 = new Point(pc.x, A4.y);
                                p2 = new Point(pc.x, B0.y);
                                break;
                            }
                            case 1: {
                                if (pontaB.y - 10 < pontaA.y) {
                                    p1 = new Point(pc.x, A4.y);
                                    p2 = new Point(pc.x, B2.y);
                                    p3 = B2;
                                    break;
                                }
                                p1 = new Point(B2.x, A4.y);
                                break;
                            }
                            case 2: {
                                p1 = new Point(pc.x, A4.y);
                                if (this.pontoMaisProx(B4.y, B3.y, B5.y)) {
                                    p2 = new Point(pc.x, B3.y);
                                    p3 = B3;
                                } else {
                                    p2 = new Point(pc.x, B5.y);
                                    p3 = B5;
                                }
                                p4 = B4;
                                break;
                            }
                            case 3: {
                                if (pontaA.y > pontaB.y + 10) {
                                    p1 = new Point(B6.x, A4.y);
                                    break;
                                }
                                p1 = new Point(pc.x, A4.y);
                                p2 = new Point(pc.x, B6.y);
                                p3 = B6;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (ladoB) {
                            case 0: {
                                if (A6.y > pontaB.y) {
                                    p1 = A6;
                                    p2 = new Point(pc.x, A6.y);
                                    p3 = new Point(pc.x, B0.y);
                                    break block6;
                                }
                                p1 = new Point(A6.x, B0.y);
                                break block6;
                            }
                            case 1: {
                                p1 = A6;
                                p2 = new Point(pc.x, A6.y);
                                p3 = new Point(pc.x, B2.y);
                                p4 = B2;
                                break block6;
                            }
                            case 2: {
                                tmpPoint = this.maiorPonto(A6, B5, false);
                                p1 = new Point(A6.x, tmpPoint.y);
                                p2 = new Point(B5.x, tmpPoint.y);
                                p4 = B4;
                                break block6;
                            }
                            case 3: {
                                tmpPoint = this.maiorPonto(A6, B6, false);
                                p1 = new Point(A6.x, tmpPoint.y);
                                p2 = new Point(B6.x, tmpPoint.y);
                            }
                        }
                    }
                }
                break;
            }
            case 67: {
                block36 : switch (ladoA) {
                    case 0: {
                        switch (ladoB) {
                            case 0: {
                                p1 = A0;
                                p2 = new Point(A0.x, B0.y);
                                break;
                            }
                            case 1: {
                                p1 = A0;
                                p2 = new Point(A0.x, pc.y);
                                p3 = new Point(B2.x, pc.y);
                                break;
                            }
                            case 2: {
                                p1 = A0;
                                if (this.pontoMaisProx(A0.y, A1.y, A7.y)) {
                                    p2 = A1;
                                    p3 = new Point(B4.x, A1.y);
                                } else {
                                    p2 = new Point(A1.x, pc.y);
                                    p3 = new Point(B4.x, pc.y);
                                }
                                p4 = B4;
                                break;
                            }
                            case 3: {
                                p1 = A0;
                                p2 = new Point(A0.x, B6.y);
                                p3 = B6;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (ladoB) {
                            case 0: {
                                p1 = A2;
                                p2 = new Point(pc.x, A2.y);
                                p3 = new Point(pc.x, B0.y);
                                break;
                            }
                            case 1: {
                                p1 = A2;
                                p2 = new Point(B2.x, A2.y);
                                break;
                            }
                            case 2: {
                                p1 = A2;
                                p2 = new Point(B4.x, A2.y);
                                p3 = B4;
                                break;
                            }
                            case 3: {
                                p1 = A2;
                                p2 = new Point(pc.x, A2.y);
                                p3 = new Point(pc.x, B6.y);
                                p4 = B6;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (ladoB) {
                            case 0: {
                                p1 = new Point(pc.x, A4.y);
                                p2 = new Point(pc.x, B0.y);
                                break;
                            }
                            case 1: {
                                p1 = new Point(B2.x, A4.y);
                                break;
                            }
                            case 2: {
                                p1 = new Point(B4.x, A4.y);
                                p2 = B4;
                                break;
                            }
                            case 3: {
                                p1 = new Point(pc.x, A4.y);
                                p2 = new Point(pc.x, B6.y);
                                p3 = B6;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (ladoB) {
                            case 0: {
                                p1 = new Point(A6.x, B0.y);
                                break block36;
                            }
                            case 1: {
                                p1 = new Point(A6.x, pc.y);
                                p2 = new Point(B2.x, pc.y);
                                break block36;
                            }
                            case 2: {
                                p1 = new Point(A6.x, B3.y);
                                p2 = B3;
                                p4 = B4;
                                break block36;
                            }
                            case 3: {
                                p1 = new Point(A6.x, B6.y);
                                p2 = B6;
                            }
                        }
                    }
                }
                break;
            }
            case 68: {
                block66 : switch (ladoA) {
                    case 0: {
                        switch (ladoB) {
                            case 0: {
                                tmpPoint = this.menorPonto(A0, B0, true);
                                p1 = new Point(tmpPoint.x, A0.y);
                                p2 = new Point(tmpPoint.x, B0.y);
                                break;
                            }
                            case 1: {
                                if (pontaB.x + 10 > pontaA.x) {
                                    p1 = A0;
                                    p2 = new Point(A0.x, pc.y);
                                    p3 = new Point(B2.x, pc.y);
                                    break;
                                }
                                p1 = new Point(B2.x, A0.y);
                                break;
                            }
                            case 2: {
                                p1 = A0;
                                p2 = new Point(A0.x, pc.y);
                                p3 = new Point(B4.x, pc.y);
                                p4 = B4;
                                break;
                            }
                            case 3: {
                                tmpPoint = this.menorPonto(A0, B7, true);
                                p1 = new Point(tmpPoint.x, A0.y);
                                p2 = new Point(tmpPoint.x, B7.y);
                                p3 = B6;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (ladoB) {
                            case 0: {
                                tmpPoint = this.menorPonto(A1, B0, true);
                                p1 = A2;
                                p2 = new Point(tmpPoint.x, A1.y);
                                p3 = new Point(tmpPoint.x, B0.y);
                                break;
                            }
                            case 1: {
                                p1 = A2;
                                if (this.pontoMaisProx(A2.x, A1.x, A3.x)) {
                                    if (A1.x < pontaB.x) {
                                        p2 = A1;
                                        p3 = new Point(A1.x, B2.y);
                                        p4 = B2;
                                        break;
                                    }
                                    p2 = new Point(B2.x, A1.y);
                                    break;
                                }
                                if (A3.x > pontaB.x) {
                                    p2 = A3;
                                    p3 = new Point(A3.x, B2.y);
                                    p4 = B2;
                                    break;
                                }
                                p2 = new Point(B2.x, A3.y);
                                break;
                            }
                            case 2: {
                                p1 = A2;
                                tmpPoint = this.maiorPonto(A3, B4, true);
                                p2 = new Point(tmpPoint.x, A3.y);
                                p3 = new Point(tmpPoint.x, B4.y);
                                break;
                            }
                            case 3: {
                                p1 = A2;
                                if (this.pontoMaisProx(A2.x, A1.x, A3.x)) {
                                    tmpPoint = this.menorPonto(A1, B7, true);
                                    p2 = new Point(tmpPoint.x, A1.y);
                                    p3 = new Point(tmpPoint.x, B7.y);
                                } else {
                                    tmpPoint = this.maiorPonto(A3, B5, true);
                                    p2 = new Point(tmpPoint.x, A3.y);
                                    p3 = new Point(tmpPoint.x, B5.y);
                                }
                                p4 = B6;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (ladoB) {
                            case 0: {
                                p1 = A4;
                                p2 = new Point(A4.x, pc.y);
                                p3 = new Point(B0.x, pc.y);
                                p4 = B0;
                                break;
                            }
                            case 1: {
                                if (pontaA.x + 10 > pontaB.x) {
                                    p1 = A4;
                                    p2 = new Point(A4.x, pc.y);
                                    p3 = new Point(B2.x, pc.y);
                                    break;
                                }
                                p1 = new Point(B2.x, A4.y);
                                break;
                            }
                            case 2: {
                                tmpPoint = this.maiorPonto(A4, B4, true);
                                p1 = new Point(tmpPoint.x, A4.y);
                                p2 = new Point(tmpPoint.x, B4.y);
                                break;
                            }
                            case 3: {
                                tmpPoint = this.maiorPonto(A4, B5, true);
                                p2 = new Point(tmpPoint.x, A4.y);
                                p3 = new Point(tmpPoint.x, B5.y);
                                p4 = B6;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (ladoB) {
                            case 0: {
                                if (A6.y > pontaB.y || A6.x > pontaB.x - 10) {
                                    p1 = new Point(A6.x, pc.y);
                                    p2 = new Point(B1.x, pc.y);
                                    p3 = new Point(B1.x, pc.y);
                                    p4 = B0;
                                    break block66;
                                }
                                p1 = new Point(A6.x, B0.y);
                                break block66;
                            }
                            case 1: {
                                p1 = new Point(A6.x, pc.y);
                                p2 = new Point(B2.x, pc.y);
                                break block66;
                            }
                            case 2: {
                                if (pontaA.x > pontaB.x + 10) {
                                    p1 = new Point(A6.x, B4.y);
                                    break block66;
                                }
                                p1 = new Point(A6.x, pc.y);
                                p2 = new Point(B4.x, pc.y);
                                p4 = B4;
                                break block66;
                            }
                            case 3: {
                                if (A6.x < B0.x || A6.x > B4.x) {
                                    p1 = new Point(A6.x, B6.y);
                                    p2 = B6;
                                    break block66;
                                }
                                p1 = new Point(A6.x, pc.y);
                                if (this.pontoMaisProx(A6.x, A7.x, A5.x)) {
                                    p2 = new Point(B7.x, pc.y);
                                    p3 = B7;
                                } else {
                                    p2 = new Point(B5.x, pc.y);
                                    p3 = B5;
                                }
                                p4 = B6;
                            }
                        }
                    }
                }
                break;
            }
            case 73: {
                switch (ladoA) {
                    case 0: {
                        switch (ladoB) {
                            case 0: {
                                p1 = A0;
                                p2 = new Point(A0.x, B0.y);
                                break block0;
                            }
                            case 1: {
                                p1 = A0;
                                p2 = new Point(A0.x, B2.y);
                                p3 = B2;
                                break block0;
                            }
                            case 2: {
                                p1 = A0;
                                p2 = new Point(A0.x, B3.y);
                                p3 = B3;
                                p4 = B4;
                                break block0;
                            }
                            case 3: {
                                p1 = A0;
                                tmpPoint = this.maiorPonto(A7, B6, false);
                                p2 = new Point(A7.x, tmpPoint.y);
                                p3 = new Point(B6.x, tmpPoint.y);
                            }
                        }
                        break block0;
                    }
                    case 1: {
                        switch (ladoB) {
                            case 0: {
                                p1 = new Point(A2.x, B0.y);
                                break block0;
                            }
                            case 1: {
                                p1 = new Point(A2.x, B2.y);
                                p2 = B2;
                                break block0;
                            }
                            case 2: {
                                p1 = new Point(A2.x, pc.y);
                                p2 = new Point(B4.x, pc.y);
                                p3 = B4;
                                break block0;
                            }
                            case 3: {
                                p1 = new Point(A2.x, pc.y);
                                p2 = new Point(B6.x, pc.y);
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        switch (ladoB) {
                            case 0: {
                                p1 = new Point(pc.x, A4.y);
                                p2 = new Point(pc.x, B0.y);
                                break block0;
                            }
                            case 1: {
                                p1 = new Point(pc.x, A4.y);
                                p2 = new Point(pc.x, B2.y);
                                p3 = B2;
                                break block0;
                            }
                            case 2: {
                                p1 = new Point(B4.x, A4.y);
                                p2 = B4;
                                break block0;
                            }
                            case 3: {
                                p1 = new Point(B6.x, A4.y);
                            }
                        }
                        break block0;
                    }
                    case 3: {
                        switch (ladoB) {
                            case 0: {
                                p1 = A6;
                                p2 = new Point(pc.x, A6.y);
                                p3 = new Point(pc.x, B0.y);
                                break block0;
                            }
                            case 1: {
                                p1 = A6;
                                p2 = new Point(pc.x, A6.y);
                                p3 = new Point(pc.x, B2.y);
                                p4 = B2;
                                break block0;
                            }
                            case 2: {
                                p1 = A6;
                                p2 = new Point(B4.x, A6.y);
                                p4 = B4;
                                break block0;
                            }
                            case 3: {
                                p1 = A6;
                                p2 = new Point(B6.x, A6.y);
                            }
                        }
                    }
                }
            }
        }
        ArrayList<PontoDeLinha> pontos = this.getPontos();
        while (pontos.size() > 2) {
            this.RemoveSubItem(pontos.get(pontos.size() - 2));
        }
        if (inver) {
            Point[] pointArray2 = new Point[4];
            pointArray2[0] = p4;
            pointArray2[1] = p3;
            pointArray2[2] = p2;
            pointArray = pointArray2;
            pointArray2[3] = p1;
        } else {
            Point[] pointArray3 = new Point[4];
            pointArray3[0] = p1;
            pointArray3[1] = p2;
            pointArray3[2] = p3;
            pointArray = pointArray3;
            pointArray3[3] = p4;
        }
        Point[] todos = pointArray;
        int tl = 0;
        boolean isvisi = this.getPontaA().isVisible();
        for (int i = 0; i < 4; ++i) {
            if (todos[i] == null) continue;
            PontoDeLinha px = this.InserirPonto(++tl);
            px.setVisible(isvisi);
            px.setCentro(todos[i]);
        }
    }

    private boolean pontoMaisProx(int quem, int deste, int naoDeste) {
        return naoDeste - quem > quem - deste;
    }

    private Point maiorPonto(Point A, Point B, boolean x) {
        if (x) {
            if (A.x > B.x) {
                return A;
            }
            return B;
        }
        if (A.y > B.y) {
            return A;
        }
        return B;
    }

    private Point menorPonto(Point A, Point B, boolean x) {
        if (x) {
            if (A.x < B.x) {
                return A;
            }
            return B;
        }
        if (A.y < B.y) {
            return A;
        }
        return B;
    }

    public PreTexto getTag() {
        return this.tag;
    }

    public void setTag(PreTexto tag) {
        if (this.tag == tag) {
            return;
        }
        if (this.tag != null) {
            this.tag.SetLinhaMestre(null);
        }
        this.tag = tag;
        if (this.tag != null) {
            this.tag.SetLinhaMestre(this);
        }
    }

    public void SetTag(PreTexto tag) {
        if (this.tag == tag) {
            return;
        }
        this.tag = tag;
    }

    @Override
    public boolean Destroy() {
        this.setTag(null);
        return super.Destroy();
    }

    @Override
    public void reSetBounds() {
        this.SetaA = null;
        this.SetaB = null;
        super.reSetBounds();
        if (this.tag != null) {
            this.tag.Posicione();
        }
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        Element lig = doc.createElement("Tag");
        XMLGenerate.AtributoRefFormElementar(lig, "LinhaMestre", this.getTag());
        me.appendChild(lig);
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Dashed", this.isDashed()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Ancorado", this.isAncorado()));
        if (this.showConfigSeta) {
            me.appendChild(XMLGenerate.ValorBoolean(doc, "TemSetaPontaA", this.isTemSetaPontaA()));
            me.appendChild(XMLGenerate.ValorBoolean(doc, "TemSetaPontaB", this.isTemSetaPontaB()));
            me.appendChild(XMLGenerate.ValorBoolean(doc, "SetaAberta", this.isSetaAberta()));
            me.appendChild(XMLGenerate.ValorInteger(doc, "SetaLargura", this.getSetaLargura()));
        }
    }

    @Override
    public boolean CommitXML(Element me, HashMap<Element, FormaElementar> mapa) {
        Element lig = XMLGenerate.FindByNodeName(me, "Tag");
        String stag = lig.getAttribute("LinhaMestre");
        FormaElementar resA = XMLGenerate.FindWhoHasID(stag, mapa);
        if (resA instanceof Texto) {
            this.setTag((PreTexto)resA);
        }
        return super.CommitXML(me, mapa);
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        this.setDashed(XMLGenerate.getValorBooleanFrom(me, "Dashed"));
        this.setAncorado(XMLGenerate.getValorBooleanFrom(me, "Ancorado"));
        if (this.showConfigSeta) {
            this.setTemSetaPontaA(XMLGenerate.getValorBooleanFrom(me, "TemSetaPontaA"));
            this.setTemSetaPontaB(XMLGenerate.getValorBooleanFrom(me, "TemSetaPontaB"));
            this.setSetaAberta(XMLGenerate.getValorBooleanFrom(me, "SetaAberta"));
            this.setSetaLargura(XMLGenerate.getValorIntegerFrom(me, "SetaLargura"));
        }
        return super.LoadFromXML(me, colando);
    }

    public boolean isTemSetaPontaA() {
        return this.temSetaPontaA;
    }

    public void setTemSetaPontaA(boolean temSetaPontaA) {
        if (this.temSetaPontaA == temSetaPontaA) {
            return;
        }
        this.temSetaPontaA = temSetaPontaA;
        this.Invalidate();
    }

    public boolean isTemSetaPontaB() {
        return this.temSetaPontaB;
    }

    public void setTemSetaPontaB(boolean temSetaPontaB) {
        if (this.temSetaPontaB == temSetaPontaB) {
            return;
        }
        this.temSetaPontaB = temSetaPontaB;
        this.Invalidate();
    }

    public int getSetaLargura() {
        return this.setaLargura;
    }

    public void setSetaLargura(int setaLargura) {
        if (this.setaLargura == setaLargura) {
            return;
        }
        this.setaLargura = setaLargura;
        if (this.setaLargura > 99 || this.setaLargura < 10) {
            this.setaLargura = 10;
        }
        this.InvalidateArea();
        this.SetaA = null;
        this.SetaB = null;
    }

    public void paintSeta(Graphics2D g) {
        if (!this.isTemSetaPontaA() && !this.isTemSetaPontaB() || !this.showConfigSeta) {
            return;
        }
        this.CalculeSetas();
        if (this.isTemSetaPontaA()) {
            g.fill(this.SetaA);
        }
        if (this.isTemSetaPontaB()) {
            g.fill(this.SetaB);
        }
    }

    public boolean isSetaAberta() {
        return this.setaAberta;
    }

    public void setSetaAberta(boolean setaAberta) {
        if (this.setaAberta != setaAberta) {
            this.setaAberta = setaAberta;
            this.InvalidateArea();
            this.SetaA = null;
            this.SetaB = null;
        }
    }

    @Override
    public void InvalidateArea() {
        Rectangle r;
        super.InvalidateArea();
        if (this.SetaA != null) {
            r = this.SetaA.getBounds();
            this.InvalidateArea(r);
        }
        if (this.SetaB != null) {
            r = this.SetaB.getBounds();
            this.InvalidateArea(r);
        }
    }

    @Override
    public boolean IsMe(Point p) {
        boolean im = super.IsMe(p);
        if (!im && this.showConfigSeta && (this.isTemSetaPontaA() || this.isTemSetaPontaB())) {
            if (this.SetaA != null) {
                im = this.SetaA.contains(p);
            }
            if (!im && this.SetaB != null) {
                im = this.SetaB.contains(p);
            }
        }
        return im;
    }

    protected void CalculeSetas() {
        if (!this.isTemSetaPontaA() && !this.isTemSetaPontaB() || !this.showConfigSeta) {
            return;
        }
        int len = this.getSetaLargura() / 2;
        if (this.isTemSetaPontaA() && this.SetaA == null) {
            int x1 = this.getPontos().get((int)0).getCentro().x;
            int y1 = this.getPontos().get((int)0).getCentro().y;
            int x2 = this.getPontos().get((int)1).getCentro().x;
            int y2 = this.getPontos().get((int)1).getCentro().y;
            double dx = x2 - x1;
            double dy = y2 - y1;
            double angle = Math.atan2(dy, dx);
            AffineTransform at = new AffineTransform();
            at.rotate(angle, x1, y1);
            Path2D.Double res = new Path2D.Double();
            ((Path2D)res).moveTo(x1, y1);
            ((Path2D)res).lineTo(x1 + len, y1 - len);
            if (this.isSetaAberta()) {
                ((Path2D)res).lineTo(x1 + 2, y1);
            }
            ((Path2D)res).lineTo(x1 + len, y1 + len);
            ((Path2D)res).lineTo(x1, y1);
            this.SetaA = res.createTransformedShape(at);
        }
        if (this.isTemSetaPontaB() && this.SetaB == null) {
            int tmp = this.getPontos().size() - 1;
            int x1 = this.getPontos().get((int)tmp).getCentro().x;
            int y1 = this.getPontos().get((int)tmp).getCentro().y;
            int x2 = this.getPontos().get((int)(--tmp)).getCentro().x;
            int y2 = this.getPontos().get((int)tmp).getCentro().y;
            double dx = x2 - x1;
            double dy = y2 - y1;
            double angle = Math.atan2(dy, dx);
            AffineTransform at = new AffineTransform();
            at.rotate(angle, x1, y1);
            Path2D.Double res = new Path2D.Double();
            ((Path2D)res).moveTo(x1, y1);
            ((Path2D)res).lineTo(x1 + len, y1 - len);
            if (this.isSetaAberta()) {
                ((Path2D)res).lineTo(x1 + 2, y1);
            }
            ((Path2D)res).lineTo(x1 + len, y1 + len);
            ((Path2D)res).lineTo(x1, y1);
            this.SetaB = res.createTransformedShape(at);
        }
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        res.add(InspectorProperty.PropertyFactorySN("ancorado", "setAncorado", this.isAncorado()));
        return res;
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        ArrayList<InspectorProperty> res = super.CompleteGenerateProperty(GP);
        res.add(InspectorProperty.PropertyFactorySN("linha.dashed", "setDashed", this.isDashed()));
        if (this.showConfigSeta) {
            res.add(InspectorProperty.PropertyFactorySeparador("seta.titulo"));
            res.add(InspectorProperty.PropertyFactorySN("seta.pontadireita", "setTemSetaPontaA", this.isTemSetaPontaA()));
            res.add(InspectorProperty.PropertyFactorySN("seta.pontaesquerda", "setTemSetaPontaB", this.isTemSetaPontaB()));
            res.add(InspectorProperty.PropertyFactorySN("seta.setaaberta", "setSetaAberta", this.isSetaAberta()));
            res.add(InspectorProperty.PropertyFactoryNumero("seta.largura", "setSetaLargura", this.getSetaLargura()));
        }
        return res;
    }

    @Override
    public void DoPaint(Graphics2D g) {
        super.DoPaint(g);
        this.paintSeta(g);
    }
}

