/*
 * Decompiled with CFR 0.152.
 */
package desenho;

import controlador.Diagrama;
import desenho.ElementarEvento;
import desenho.ElementarListener;
import desenho.FormaElementar;
import desenho.formas.Forma;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Elementar
implements ElementarListener,
Serializable {
    static final long serialVersionUID = 2103191058069777L;
    private Diagrama master;
    private boolean visible = true;
    private Font font;
    private Color backColor = Color.LIGHT_GRAY;
    private int left = 0;
    private int top = 0;
    private int width = 20;
    private int height = 20;
    private Dimension size = new Dimension(20, 20);
    public static Color defaultColor = Color.BLACK;
    private Color foreColor = defaultColor;
    private Cursor cursor = Cursor.getDefaultCursor();
    private Rectangle clientRectangle = new Rectangle(0, 0, 20, 20);
    private boolean stopRaize = false;
    private boolean canPaint = true;
    private boolean canBeDeleted = true;
    private FormaElementar criador;
    private List<ElementarListener> listeners;
    private boolean destruido = false;
    protected Color disabledColor = new Color(221, 221, 221);
    private boolean disablePainted = false;

    public boolean isCanBeDeleted() {
        return this.canBeDeleted;
    }

    public void setCanBeDeleted(boolean canBeDeleted) {
        this.canBeDeleted = canBeDeleted;
    }

    public Diagrama getMaster() {
        return this.master;
    }

    public void setMaster(Diagrama master) {
        if (this.master == master) {
            return;
        }
        Diagrama bkp = this.master;
        this.master = master;
        if (master == null && bkp != null && this.isVisible()) {
            bkp.repaint();
        } else {
            this.InvalidateArea();
        }
        this.master = master;
    }

    public boolean isStopRaize() {
        return this.stopRaize;
    }

    public void setStopRaize(boolean stopRaize) {
        this.stopRaize = stopRaize;
    }

    public boolean CanPaint() {
        return this.isCanPaint();
    }

    public boolean isCanPaint() {
        return this.canPaint && this.isVisible();
    }

    public void setCanPaint(boolean canPaint) {
        this.canPaint = canPaint;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.InvalidateArea();
    }

    public Color getBackColor() {
        return this.isDisablePainted() ? this.disabledColor : this.backColor;
    }

    public void setBackColor(Color backColor) {
        if (this.backColor != backColor) {
            this.backColor = backColor;
            this.InvalidateArea();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            if (!visible) {
                this.DoMasterInvalidate();
            } else {
                this.InvalidateArea();
            }
        }
    }

    public Point getLocation() {
        return new Point(this.left, this.top);
    }

    public void setLocation(Point location) {
        this.left = location.x;
        this.top = location.y;
        this.RecrieBounds();
    }

    public void setLocation(int x, int y) {
        this.left = x;
        this.top = y;
        this.RecrieBounds();
    }

    public int getLeft() {
        return this.left;
    }

    public int getLeftWidth() {
        return this.left + this.width;
    }

    public int getTopHeight() {
        return this.top + this.height;
    }

    public void setLeft(int left) {
        if (this.left != left) {
            this.left = left;
            this.RecrieBounds();
        }
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        if (this.top != top) {
            this.top = top;
            this.RecrieBounds();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.RecrieBounds();
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (this.height != height) {
            this.height = height;
            this.RecrieBounds();
        }
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        if (this.size != size) {
            this.size = size;
            this.width = size.width;
            this.height = size.height;
            this.RecrieBounds();
        }
    }

    public Color getForeColor() {
        return this.isDisablePainted() ? this.disabledColor : this.foreColor;
    }

    public void setForeColor(Color foreColor) {
        if (this.foreColor != foreColor) {
            this.foreColor = foreColor;
            this.InvalidateArea();
        }
    }

    public void SetForeColor(Color foreColor) {
        this.foreColor = foreColor;
        this.InvalidateArea();
    }

    public void setForeColorWithOutRepaint(Color foreColor) {
        this.foreColor = foreColor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public Rectangle getClientRectangle() {
        return this.clientRectangle.getBounds();
    }

    public void setClientRectangle(Rectangle clientRectangle) {
        if (clientRectangle == null) {
            clientRectangle = new Rectangle(0, 0, 0, 0);
        }
        this.SetBounds(clientRectangle.x, clientRectangle.y, clientRectangle.width, clientRectangle.height);
    }

    public Rectangle getBounds() {
        return this.getClientRectangle();
    }

    public void setBounds(Rectangle bounds) {
        this.setClientRectangle(bounds);
    }

    public FormaElementar getCriador() {
        return this.criador;
    }

    public boolean isParte() {
        return false;
    }

    public boolean isComposto() {
        return false;
    }

    public Elementar ProcessaComposicao() {
        return this;
    }

    public Elementar ProcessaComposicao(Point pt) {
        return this;
    }

    public Elementar getPrimeiroSubComponente() {
        return null;
    }

    public Elementar getPrincipal() {
        return this;
    }

    public void SetBounds(int left, int top, int width, int height) {
        this.setBounds(left, top, width, height);
    }

    public void setBounds(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.RecrieBounds();
    }

    protected void SetFontAndBackColorFromModelo() {
        this.font = Elementar.CloneFont(this.master.getFont());
        this.backColor = this.master.getBackground();
    }

    protected void DoMasterInvalidate() {
        if (this.master != null) {
            this.master.repaint();
        }
    }

    public void SetBounds(Rectangle rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void RecrieBounds() {
        this.width = this.width < 2 ? 2 : this.width;
        this.height = this.height < 2 ? 2 : this.height;
        this.clientRectangle = new Rectangle(this.left, this.top, this.width, this.height);
        if (this.isStopRaize()) {
            return;
        }
        this.ReSized();
        if (this.visible) {
            this.DoMasterInvalidate();
        }
    }

    public void DoMove(int movX, int movY) {
        this.setLocation(new Point(this.left + movX, this.top + movY));
    }

    public static Font CloneFont(Font origem) {
        return new Font(origem.getName(), origem.getStyle(), origem.getSize());
    }

    public void Invalidate() {
        if (this.master != null) {
            this.master.repaint();
        }
    }

    public void repaint() {
        if (this.master != null) {
            this.master.repaint(this.clientRectangle);
        }
    }

    public void InvalidateArea(Rectangle area) {
        if (this.master != null) {
            this.master.repaint(area);
        }
    }

    public void InvalidateArea() {
        if (this.master != null) {
            Rectangle r = (Rectangle)this.clientRectangle.clone();
            r.grow(1, 1);
            this.master.repaint(r);
        }
    }

    public Elementar() {
    }

    public Elementar(FormaElementar pai) {
        this.InitElementar(pai);
    }

    private void InitElementar(FormaElementar pai) {
        this.criador = pai;
        if (this.criador != null) {
            this.master = this.criador.getMaster();
            this.criador.getSubItens().add(this);
            this.SetFontAndBackColorFromModelo();
        }
        this.cursor = new Cursor(12);
    }

    protected void DoMuda() {
    }

    public void SendToBack() {
        List<Elementar> lista;
        if (this.criador != null) {
            lista = this.criador.getSubItens();
        } else {
            List<Elementar> list = lista = this.master != null ? this.master.getSubItens() : null;
        }
        if (lista == null) {
            return;
        }
        int tmp = lista.indexOf(this);
        if (tmp == lista.size() - 1 || tmp == -1) {
            return;
        }
        lista.remove(this);
        lista.add(this);
    }

    public void BringToFront() {
        List<Elementar> lista;
        if (this.criador != null) {
            lista = this.criador.getSubItens();
        } else {
            List<Elementar> list = lista = this.master != null ? this.master.getSubItens() : null;
        }
        if (lista == null) {
            return;
        }
        if (lista.indexOf(this) < 1) {
            return;
        }
        lista.remove(this);
        lista.add(0, this);
    }

    public boolean IsMe(Point p) {
        if (!this.isVisible()) {
            return false;
        }
        return this.clientRectangle.contains(p);
    }

    public Elementar IsMeOrMine(Point p) {
        if (this.IsMe(p)) {
            return this;
        }
        return null;
    }

    public Elementar IsMeOrMine(Point p, Elementar nor) {
        if (this != nor && this.IsMe(p)) {
            return this;
        }
        return null;
    }

    public Elementar IsMeOrMineBase(Point p, Elementar nor) {
        if (this != nor && this.IsMe(p) && this instanceof Forma) {
            return this;
        }
        return null;
    }

    public void DoPaint(Graphics2D g) {
        g.setFont(this.getFont());
    }

    public boolean Reenquadre() {
        int ATop;
        if (this.master == null) {
            return false;
        }
        int ALeft = this.left < 0 ? 0 : this.left;
        int n = ATop = this.top < 0 ? 0 : this.top;
        if (this.left + this.width > this.master.getWidth()) {
            ALeft = this.master.getWidth() - this.width;
        }
        if (this.top + this.height > this.master.getHeight()) {
            ATop = this.master.getHeight() - this.height;
        }
        if (ALeft != this.left || ATop != this.top) {
            this.BeforeReenquadre(ALeft - this.left, ATop - this.top);
            this.SetBounds(ALeft, ATop, this.width, this.height);
            this.Reposicione();
            return true;
        }
        return false;
    }

    protected void BeforeReenquadre(int movidoX, int movidoY) {
    }

    protected void Reposicione() {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDblClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.master == null) {
            return;
        }
        if (this.master.getCursor().getType() != this.getCursor().getType()) {
            this.master.setCursor(new Cursor(this.getCursor().getType()));
        }
    }

    public List<ElementarListener> getListeners() {
        return this.listeners;
    }

    private void addElementarListener(ElementarListener el) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ElementarListener>();
        }
        this.listeners.add(el);
    }

    private void removeElementarListener(ElementarListener el) {
        if (this.listeners != null) {
            this.listeners.remove(el);
        }
    }

    @Override
    public final void SendNotificacao(int cod) {
        if (this.isStopRaize()) {
            return;
        }
        if (this.listeners != null) {
            ElementarEvento evt = new ElementarEvento(this, cod);
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).ReciveNotificacao(evt);
            }
        }
    }

    public final void SendNotificacao(Object msg, int cod) {
        if (this.isStopRaize()) {
            return;
        }
        if (this.listeners != null) {
            ElementarEvento evt = new ElementarEvento(this, msg, cod);
            for (ElementarListener el : this.listeners) {
                el.ReciveNotificacao(evt);
            }
        }
    }

    public void PerformLigacao(Elementar emQuem, boolean isIN) {
        if (emQuem == null || emQuem == this) {
            return;
        }
        if (isIN) {
            this.addElementarListener(emQuem);
            emQuem.addElementarListener(this);
        } else {
            this.removeElementarListener(emQuem);
            emQuem.removeElementarListener(this);
        }
    }

    @Override
    public void ReciveNotificacao(ElementarEvento evt) {
        int i = evt.getCod();
        if (i == 1) {
            this.removeElementarListener(evt.getSender());
        }
    }

    public boolean Destroy() {
        this.destruido = true;
        if (this.master == null || this.master.IsStopEvents) {
            return false;
        }
        this.SendNotificacao(1);
        return true;
    }

    public void ReSized() {
    }

    public boolean isDestruido() {
        return this.destruido;
    }

    public final void SetVisible(boolean sn) {
        this.visible = sn;
    }

    public boolean isDisablePainted() {
        return this.disablePainted;
    }

    public void setDisablePainted(boolean disablePainted) {
        this.disablePainted = disablePainted;
    }

    public final void SetDisablePainted(boolean disablePainted) {
        this.disablePainted = disablePainted;
    }
}

