/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.rhythm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.rhythm.RhythmAltLayerProvider;
import org.staccato.StaccatoUtil;

public class Rhythm
implements PatternProducer {
    private List<String> layers = new ArrayList<String>();
    private Map<Integer, List<AltLayer>> altLayers = new HashMap<Integer, List<AltLayer>>();
    private Map<Character, String> rhythmKit;
    private int length = 1;
    public static final Map<Character, String> DEFAULT_RHYTHM_KIT = new HashMap<Character, String>(){
        {
            this.put(Character.valueOf('.'), "Ri");
            this.put(Character.valueOf('O'), "[BASS_DRUM]i");
            this.put(Character.valueOf('o'), "Rs [BASS_DRUM]s");
            this.put(Character.valueOf('S'), "[ACOUSTIC_SNARE]i");
            this.put(Character.valueOf('s'), "Rs [ACOUSTIC_SNARE]s");
            this.put(Character.valueOf('^'), "[PEDAL_HI_HAT]i");
            this.put(Character.valueOf('`'), "[PEDAL_HI_HAT]s Rs");
            this.put(Character.valueOf('*'), "[CRASH_CYMBAL_1]i");
            this.put(Character.valueOf('+'), "[CRASH_CYMBAL_1]s Rs");
            this.put(Character.valueOf('X'), "[HAND_CLAP]i");
            this.put(Character.valueOf('x'), "Rs [HAND_CLAP]s");
            this.put(Character.valueOf(' '), "Ri");
        }
    };

    public Rhythm() {
        this(DEFAULT_RHYTHM_KIT);
    }

    public Rhythm(String ... layers) {
        this(DEFAULT_RHYTHM_KIT, layers);
    }

    public Rhythm(Map<Character, String> rhythmKit) {
        this.setRhythmKit(rhythmKit);
    }

    public Rhythm(Map<Character, String> rhythmKit, String ... layers) {
        this(rhythmKit);
        for (String layer : layers) {
            this.addLayer(layer);
        }
    }

    public Rhythm setRhythmKit(Map<Character, String> rhythmKit) {
        this.rhythmKit = rhythmKit;
        return this;
    }

    public Map<Character, String> getRhythmKit() {
        return this.rhythmKit;
    }

    public Rhythm addLayer(String layer) {
        if (this.layers.size() < 16) {
            this.layers.add(layer);
        }
        return this;
    }

    public String getLayer(int layer) {
        return this.layers.get(layer);
    }

    public List<String> getLayers() {
        return this.layers;
    }

    public Rhythm setLayers(List<String> layers) {
        if (layers.size() > 16) {
            throw new RuntimeException("Size of the List<String> provided to Rhythm.setLayers() is greater than 16");
        }
        this.layers = layers;
        return this;
    }

    public String[] getLayersAt(int segment) {
        String[] retVal = new String[this.layers.size()];
        for (int layer = 0; layer < this.layers.size(); ++layer) {
            List<AltLayer> altLayers = this.getSortedAltLayersForLayer(layer);
            retVal[layer] = this.getLayer(layer);
            for (AltLayer altLayer : altLayers) {
                String rhythmOrNull;
                if (!altLayer.shouldProvideAltLayer(segment) || (rhythmOrNull = altLayer.getAltLayer(segment)) == null) continue;
                retVal[layer] = rhythmOrNull;
            }
        }
        return retVal;
    }

    public boolean canAddLayer() {
        return this.layers.size() < 16;
    }

    public Rhythm clone() {
        return new Rhythm(this.rhythmKit, this.getLayers().toArray(new String[0]));
    }

    public List<AltLayer> getAltLayersForLayer(int layer) {
        if (this.altLayers.get(layer) == null) {
            this.altLayers.put(layer, new ArrayList());
        }
        return this.altLayers.get(layer);
    }

    public List<AltLayer> getSortedAltLayersForLayer(int layer) {
        List<AltLayer> retVal = this.getAltLayersForLayer(layer);
        Collections.sort(retVal, new Comparator<AltLayer>(){

            @Override
            public int compare(AltLayer altLayer1, AltLayer altLayer2) {
                if (altLayer1.zOrder < altLayer2.zOrder) {
                    return -1;
                }
                if (altLayer1.zOrder > altLayer2.zOrder) {
                    return 1;
                }
                return 0;
            }
        });
        return retVal;
    }

    public Rhythm addRecurringAltLayer(int layer, int start, int end, int recurrence, String rhythmString) {
        return this.addRecurringAltLayer(layer, start, end, recurrence, rhythmString, 1);
    }

    public Rhythm addRecurringAltLayer(int layer, int start, int end, int recurrence, String rhythmString, int zOrder) {
        this.getAltLayersForLayer(layer).add(new AltLayer(start, end, recurrence, rhythmString, null, zOrder));
        return this;
    }

    public Rhythm addRangedAltLayer(int layer, int start, int end, String rhythmString) {
        return this.addRangedAltLayer(layer, start, end, rhythmString, 2);
    }

    public Rhythm addRangedAltLayer(int layer, int start, int end, String rhythmString, int zOrder) {
        this.getAltLayersForLayer(layer).add(new AltLayer(start, end, -1, rhythmString, null, zOrder));
        return this;
    }

    public Rhythm addOneTimeAltLayer(int layer, int oneTime, String rhythmString) {
        return this.addOneTimeAltLayer(layer, oneTime, rhythmString, 3);
    }

    public Rhythm addOneTimeAltLayer(int layer, int oneTime, String rhythmString, int zOrder) {
        this.getAltLayersForLayer(layer).add(new AltLayer(oneTime, oneTime, -1, rhythmString, null, zOrder));
        return this;
    }

    public Rhythm addAltLayerProvider(int layer, RhythmAltLayerProvider altLayerProvider) {
        return this.addAltLayerProvider(layer, altLayerProvider, 4);
    }

    public Rhythm addAltLayerProvider(int layer, RhythmAltLayerProvider altLayerProvider, int zOrder) {
        this.getAltLayersForLayer(layer).add(new AltLayer(0, this.getLength(), -1, null, altLayerProvider, zOrder));
        return this;
    }

    public static Rhythm combine(Rhythm ... rhythms) {
        Rhythm retVal = new Rhythm();
        for (Rhythm rhythm : rhythms) {
            retVal.getRhythmKit().putAll(rhythm.getRhythmKit());
            for (String layer : rhythm.getLayers()) {
                if (retVal.canAddLayer()) {
                    retVal.addLayer(layer);
                    continue;
                }
                return retVal;
            }
            Iterator<Object> iterator = rhythm.altLayers.keySet().iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                retVal.getAltLayersForLayer(key).addAll(rhythm.getAltLayersForLayer(key));
            }
            if (retVal.getLength() >= rhythm.getLength()) continue;
            retVal.setLength(rhythm.getLength());
        }
        return retVal;
    }

    public Rhythm setLength(int length) {
        this.length = length;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public String getStaccatoStringForRhythm(String rhythm) {
        StringBuilder buddy = new StringBuilder();
        for (char ch : rhythm.toCharArray()) {
            if (this.rhythmKit.get(Character.valueOf(ch)) == null) {
                throw new RuntimeException("The character '" + ch + "' used in the rhythm layer \"" + rhythm + "\" is not associated with a Staccato music string in the RhythmKit " + this.rhythmKit);
            }
            buddy.append(this.rhythmKit.get(Character.valueOf(ch)));
            buddy.append(" ");
        }
        return buddy.toString().trim();
    }

    public Pattern getPatternAt(int segment) {
        Pattern pattern = new Pattern(StaccatoUtil.createTrackElement((byte)9));
        byte layerCounter = 0;
        for (String layer : this.getLayersAt(segment)) {
            pattern.add(StaccatoUtil.createLayerElement(layerCounter));
            layerCounter = (byte)(layerCounter + 1);
            pattern.add(this.getStaccatoStringForRhythm(layer));
        }
        return pattern;
    }

    @Override
    public Pattern getPattern() {
        Pattern fullPattern = new Pattern();
        for (int segment = 0; segment < this.getLength(); ++segment) {
            fullPattern.add(this.getPatternAt(segment));
        }
        return fullPattern;
    }

    public String[] getRhythm() {
        StringBuilder[] builders = new StringBuilder[this.layers.size()];
        for (int i = 0; i < this.layers.size(); ++i) {
            builders[i] = new StringBuilder();
            for (int segment = 0; segment < this.getLength(); ++segment) {
                builders[i].append(this.getLayersAt(segment)[i]);
            }
        }
        String[] retVal = new String[this.layers.size()];
        for (int i = 0; i < this.layers.size(); ++i) {
            retVal[i] = builders[i].toString();
        }
        return retVal;
    }

    class AltLayer {
        public String rhythmString;
        public RhythmAltLayerProvider altLayerProvider;
        public int startIndex;
        public int endIndex;
        public int recurrence;
        public int zOrder;

        public AltLayer(int start, int end, int recurrence, String rhythmString, RhythmAltLayerProvider altLayerProvider, int zOrder) {
            this.startIndex = start;
            this.endIndex = end;
            this.recurrence = recurrence;
            this.rhythmString = rhythmString;
            this.altLayerProvider = altLayerProvider;
            this.zOrder = zOrder;
        }

        public boolean shouldProvideAltLayer(int segment) {
            if (this.altLayerProvider != null) {
                return true;
            }
            if (segment >= this.startIndex && segment <= this.endIndex) {
                if (this.recurrence == -1) {
                    return true;
                }
                if (this.recurrence != -1 && segment % this.recurrence == this.startIndex) {
                    return true;
                }
            }
            return false;
        }

        public String getAltLayer(int segment) {
            if (this.altLayerProvider != null) {
                return this.altLayerProvider.provideAltLayer(segment);
            }
            return this.rhythmString;
        }
    }
}

