/*!
 * Copyright 2002 - 2017 Webdetails, a Hitachi Vantara company. All rights reserved.
 *
 * This software was developed by Webdetails and is provided under the terms
 * of the Mozilla Public License, Version 2.0, or any later version. You may not use
 * this file except in compliance with the license. If you need a copy of the license,
 * please go to http://mozilla.org/MPL/2.0/. The Initial Developer is Webdetails.
 *
 * Software distributed under the Mozilla Public License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. Please refer to
 * the license for the specific language governing your rights and limitations.
 */

define(['./SelectBaseComponent', '../lib/jquery'], function(SelectBaseComponent, $) {

  /**
   * @class cdf.components.SelectMultiComponent
   * @amd cdf/components/SelectMultiComponent
   * @extends cdf.components.SelectBaseComponent
   * @classdesc Multi select component. Allows selecting multiple items.
   * @ignore
   */
  return SelectBaseComponent.extend(/** @lends cdf.components.SelectMultiComponent# */{
    /**
     * Gets the values selected of the select tag.
     *
     * @return {array|*} an empty array or the values selected
     */
    getValue : function() {
      var ph = this.placeholder("select");
      var val = ph.val();
      return val == null ? [] : val;
    },

    /**
     * Obtains the normalized and defaulted value of
     * the {@link #isMultiple} option.
     *
     * @return {boolean} `true` if multiple values are allowed, `false` otherwise.
     * @private
     */
    _allowMultipleValues: function() {
      return this.isMultiple == null || !!this.isMultiple;
    },

    /**
     * When the size option is unspecified, and multiple values are allowed,
     * returns the number of items in the provided possible values list.
     *
     * @param {object[]} values The values list.
     * @return {number} The values list size.
     * @private
     */
    _getListSize: function(values) {
      var size = this.base(values);
      if(size == null) {
        if(!this._allowMultipleValues()) {
          size = values.length;
        } // TODO: otherwise no default... Why?
      }

      return size;
    },

    topIndex: function(_) {
      var $elem = this.placeholder("select");
      var elem = $elem[0];
      
      var L = elem.length;
      if(!L) {return arguments.length ? this : 0;}

      var h  = Math.max(1, elem.scrollHeight);
      var hi = Math.max(1, h / L);

      if(arguments.length) {
        var topIndex = + _ ;
        
        topIndex = isNaN(topIndex) ? 0 : Math.max(0, Math.min(topIndex, L - 1));
        
        $elem.scrollTop(Math.ceil(topIndex * hi));
        
        return this;
      }
      return Math.round($elem.scrollTop() / hi);
    },

    indexOf: function(value) {
      if(value != null) {
        var $options = this.placeholder("select option");
        var L = $options.length;
        if(L) {
          value = String(value);
          for(var i = 0; i < L; i++) {
            if($options[i].value === value) { 
              return i; 
            }
          }
        }
      }
      return -1;
    },

    valueAt: function(index) {
      if(index >= 0) {
        return this.placeholder("select :nth-child(" + (index + 1) + ")").val();
      }
    },

    topValue: function(_) {
      if(arguments.length) {
        var topIndex = this.indexOf(_);
        if(topIndex >= 0) {
          this.topIndex(topIndex);
        }
        return this;
      }
      
      return this.valueAt(this.topIndex());
    }
  });

});
