SET CLUSTER '';
SET DEFAULT_TABLE_TYPE 0;
SET WRITE_DELAY 20;
SET DEFAULT_LOCK_TIMEOUT 2000;
SET CACHE_SIZE 16384;
CREATE USER IF NOT EXISTS SA SALT '7d05c8d2a01c0aba' HASH 'f09718976f975f0a3b18a1753d13f55a2fe09b97c5570eb293509bf211b91d7c';
CREATE USER IF NOT EXISTS PENTAHO_USER SALT 'a4bb952fbbe2b4db' HASH '97e849cfb81c6a207d7dd9f4c06ba17b3744fe1185d083bb867835c816aee295' ADMIN;
DROP TABLE IF EXISTS PUBLIC.DIM_TERRITORIES;
DROP SEQUENCE IF EXISTS PUBLIC.SYSTEM_SEQUENCE_B4ADD799_499E_49DC_997F_E4924C2E21EC;
CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_B4ADD799_499E_49DC_997F_E4924C2E21EC START WITH 6 BELONGS_TO_TABLE;
DROP TABLE IF EXISTS PUBLIC.QUADRANT_ACTUALS;
CREATE MEMORY TABLE PUBLIC.QUADRANT_ACTUALS(
    REGION VARCHAR(50) NOT NULL,
    DEPARTMENT VARCHAR(50) NOT NULL,
    POSITIONTITLE VARCHAR(50) NOT NULL,
    ACTUAL DECIMAL(18, 4),
    BUDGET DECIMAL(18, 4),
    VARIANCE DECIMAL(18, 4)
);
-- 148 +/- SELECT COUNT(*) FROM PUBLIC.QUADRANT_ACTUALS;
INSERT INTO PUBLIC.QUADRANT_ACTUALS(REGION, DEPARTMENT, POSITIONTITLE, ACTUAL, BUDGET, VARIANCE) VALUES
('Central', 'Sales', 'District Manager', 682625.0000, 617250.0000, -65375.0000),
('Central', 'Sales', 'Senior Sales Rep', 497223.0000, 484820.0000, -12403.0000),
('Central', 'Sales', 'Sales Rep', 675975.0000, 612500.0000, -63475.0000),
('Central', 'Sales', 'Account Executive', 409975.0000, 422500.0000, 12525.0000),
('Central', 'Sales', 'Pre-Sales', 649375.0000, 593500.0000, -55875.0000),
('Central', 'Executive Management', 'CEO', 549625.0000, 522250.0000, -27375.0000),
('Central', 'Executive Management', 'SVP WW Operations', 476000.0000, 725887.0000, 249887.0000),
('Central', 'Executive Management', 'SVP Strategic Development', 383242.0000, 403405.0000, 20163.0000),
('Central', 'Executive Management', 'SVP Partnerships', 367415.0000, 392100.0000, 24685.0000),
('Central', 'Finance', 'CFO', 770272.0000, 719855.0000, -50417.0000),
('Central', 'Finance', 'Administrative Assisitant', 827861.0000, 760990.0000, -66871.0000),
('Central', 'Finance', 'IS', 570759.0000, 577346.0000, 6587.0000),
('Central', 'Finance', 'Controller', 570373.0000, 577070.0000, 6697.0000),
('Central', 'Finance', 'Payroll', 367415.0000, 432100.0000, 64685.0000),
('Central', 'Human Resource', 'Administration', 549625.0000, 552250.0000, 2625.0000),
('Central', 'Human Resource', 'SVP HR', 574895.0000, 570300.0000, -4595.0000),
('Central', 'Human Resource', 'HR Generalists', 856190.0000, 771225.0000, -84965.0000),
('Central', 'Human Resource', 'HR Training', 397473.0000, 443570.0000, 46097.0000),
('Central', 'Human Resource', 'Sexual Harassment', 530473.0000, 538570.0000, 8097.0000),
('Central', 'Human Resource', 'EOE', 530207.0000, 538380.0000, 8173.0000),
('Central', 'Marketing & Communication', 'CMO', 827861.0000, 760990.0000, -66871.0000),
('Central', 'Marketing & Communication', 'Product Marketing Mgr', 693531.0000, 665040.0000, -28491.0000),
('Central', 'Marketing & Communication', 'Analyst Relations', 383375.0000, 443500.0000, 60125.0000),
('Central', 'Marketing & Communication', 'Press Relations', 497296.0000, 524872.0000, 27576.0000),
('Central', 'Marketing & Communication', 'Graphics', 782375.0000, 728500.0000, -53875.0000),
('Central', 'Marketing & Communication', 'Writer', 405985.0000, 459650.0000, 53665.0000),
('Central', 'Product Development', 'CTO', 405985.0000, 459650.0000, 53665.0000),
('Central', 'Product Development', 'VP Engineering', 383242.0000, 443405.0000, 60163.0000),
('Central', 'Product Development', 'Senior Engineer', 770272.0000, 719855.0000, -50417.0000),
('Central', 'Product Development', 'Engineer', 695925.0000, 666750.0000, -29175.0000),
('Central', 'Product Development', 'QA Manager', 374863.0000, 437420.0000, 62557.0000),
('Central', 'Product Development', 'QA Engineer', 367415.0000, 432100.0000, 64685.0000),
('Central', 'Professional Services', 'SVP Services', 4042220.0000, 4180000.0000, 137780.0000),
('Central', 'Professional Services', 'Services Mgr', 4401586.0000, 4680000.0000, 278414.0000),
('Central', 'Professional Services', 'Senior Consultant', 3994859.0000, 3980000.0000, -14859.0000),
('Central', 'Professional Services', 'Staff Consultant', 3824426.0000, 4180000.0000, 355574.0000),
('Central', 'Professional Services', 'Trainer', 3804948.0000, 3380000.0000, -424948.0000),
('Eastern', 'Sales', 'District Manager', 700000.0000, 700250.0000, 250.0000),
('Eastern', 'Sales', 'Senior Sales Rep', 421200.0000, 433299.0000, 12099.0000),
('Eastern', 'Sales', 'Sales Rep', 690000.0000, 690675.0000, 675.0000),
('Eastern', 'Sales', 'Account Executive', 290000.0000, 307675.0000, 17675.0000),
('Eastern', 'Sales', 'Pre-Sales', 650000.0000, 652375.0000, 2375.0000),
('Eastern', 'Executive Management', 'CEO', 500000.0000, 488750.0000, -11250.0000),
('Eastern', 'Executive Management', 'SVP WW Operations', 249800.0000, 249184.0000, -616.0000),
('Eastern', 'Executive Management', 'SVP Strategic Development', 226000.0000, 226395.0000, 395.0000),
('Eastern', 'Executive Management', 'SVP Partnerships', 531780.0000, 519179.0000, -12601.0000),
('Eastern', 'Finance', 'CFO', 831800.0000, 816449.0000, -15351.0000);
INSERT INTO PUBLIC.QUADRANT_ACTUALS(REGION, DEPARTMENT, POSITIONTITLE, ACTUAL, BUDGET, VARIANCE) VALUES
('Eastern', 'Finance', 'Administrative Assisitant', 918400.0000, 899368.0000, -19032.0000),
('Eastern', 'Finance', 'IS', 531780.0000, 529179.0000, -2601.0000),
('Eastern', 'Finance', 'Controller', 531200.0000, 528624.0000, -2576.0000),
('Eastern', 'Finance', 'Payroll', 226000.0000, 236395.0000, 10395.0000),
('Eastern', 'Human Resource', 'Administration', 500000.0000, 498750.0000, -1250.0000),
('Eastern', 'Human Resource', 'SVP HR', 538000.0000, 535135.0000, -2865.0000),
('Eastern', 'Human Resource', 'HR Generalists', 961000.0000, 940158.0000, -20842.0000),
('Eastern', 'Human Resource', 'HR Training', 271200.0000, 279674.0000, 8474.0000),
('Eastern', 'Human Resource', 'Sexual Harassment', 471200.0000, 471174.0000, -26.0000),
('Eastern', 'Human Resource', 'EOE', 470800.0000, 470791.0000, -9.0000),
('Eastern', 'Marketing & Communication', 'CMO', 918400.0000, 894368.0000, -24032.0000),
('Eastern', 'Marketing & Communication', 'Product Marketing Mgr', 716400.0000, 700953.0000, -15447.0000),
('Eastern', 'Marketing & Communication', 'Analyst Relations', 250000.0000, 254375.0000, 4375.0000),
('Eastern', 'Marketing & Communication', 'Press Relations', 421310.0000, 418404.0000, -2906.0000),
('Eastern', 'Marketing & Communication', 'Graphics', 850000.0000, 828875.0000, -21125.0000),
('Eastern', 'Marketing & Communication', 'Writer', 284000.0000, 286930.0000, 2930.0000),
('Eastern', 'Product Development', 'CTO', 284000.0000, 286930.0000, 2930.0000),
('Eastern', 'Product Development', 'VP Engineering', 249800.0000, 254184.0000, 4384.0000),
('Eastern', 'Product Development', 'Senior Engineer', 831800.0000, 811449.0000, -20351.0000),
('Eastern', 'Product Development', 'Engineer', 720000.0000, 704400.0000, -15600.0000),
('Eastern', 'Product Development', 'QA Manager', 237200.0000, 242119.0000, 4919.0000),
('Eastern', 'Product Development', 'QA Engineer', 226000.0000, 231395.0000, 5395.0000),
('Eastern', 'Professional Services', 'SVP Services', 3793000.0000, 3900000.0000, 107000.0000),
('Eastern', 'Professional Services', 'Services Mgr', 4333400.0000, 4500000.0000, 166600.0000),
('Eastern', 'Professional Services', 'Senior Consultant', 3721780.0000, 3900000.0000, 178220.0000),
('Eastern', 'Professional Services', 'Staff Consultant', 3465490.0000, 3500000.0000, 34510.0000),
('Eastern', 'Professional Services', 'Trainer', 3436200.0000, 3300000.0000, -136200.0000),
('Southern', 'Sales', 'District Manager', 700000.0000, 690250.0000, -9750.0000),
('Southern', 'Sales', 'Senior Sales Rep', 421200.0000, 423299.0000, 2099.0000),
('Southern', 'Sales', 'Sales Rep', 690000.0000, 680675.0000, -9325.0000),
('Southern', 'Sales', 'Account Executive', 290000.0000, 297675.0000, 7675.0000),
('Southern', 'Sales', 'Pre-Sales', 650000.0000, 642375.0000, -7625.0000),
('Southern', 'Executive Management', 'CEO', 500000.0000, 498750.0000, -1250.0000),
('Southern', 'Executive Management', 'SVP WW Operations', 249800.0000, 259184.0000, 9384.0000),
('Southern', 'Executive Management', 'SVP Strategic Development', 226000.0000, 236395.0000, 10395.0000),
('Southern', 'Executive Management', 'SVP Partnerships', 531780.0000, 529179.0000, -2601.0000),
('Southern', 'Finance', 'CFO', 831800.0000, 816449.0000, -15351.0000),
('Southern', 'Finance', 'Administrative Assisitant', 918400.0000, 899368.0000, -19032.0000),
('Southern', 'Finance', 'IS', 531780.0000, 529179.0000, -2601.0000),
('Southern', 'Finance', 'Controller', 531200.0000, 528624.0000, -2576.0000),
('Southern', 'Finance', 'Payroll', 226000.0000, 236395.0000, 10395.0000),
('Southern', 'Human Resource', 'Administration', 500000.0000, 498750.0000, -1250.0000),
('Southern', 'Human Resource', 'SVP HR', 538000.0000, 535135.0000, -2865.0000),
('Southern', 'Human Resource', 'HR Generalists', 961000.0000, 940158.0000, -20842.0000),
('Southern', 'Human Resource', 'HR Training', 271200.0000, 279674.0000, 8474.0000),
('Southern', 'Human Resource', 'Sexual Harassment', 471200.0000, 471174.0000, -26.0000),
('Southern', 'Human Resource', 'EOE', 470800.0000, 470791.0000, -9.0000);
INSERT INTO PUBLIC.QUADRANT_ACTUALS(REGION, DEPARTMENT, POSITIONTITLE, ACTUAL, BUDGET, VARIANCE) VALUES
('Southern', 'Marketing & Communication', 'CMO', 918400.0000, 897368.0000, -21032.0000),
('Southern', 'Marketing & Communication', 'Product Marketing Mgr', 716400.0000, 703953.0000, -12447.0000),
('Southern', 'Marketing & Communication', 'Analyst Relations', 250000.0000, 257375.0000, 7375.0000),
('Southern', 'Marketing & Communication', 'Press Relations', 421310.0000, 421404.0000, 94.0000),
('Southern', 'Marketing & Communication', 'Graphics', 850000.0000, 831875.0000, -18125.0000),
('Southern', 'Marketing & Communication', 'Writer', 284000.0000, 289930.0000, 5930.0000),
('Southern', 'Product Development', 'CTO', 284000.0000, 289930.0000, 5930.0000),
('Southern', 'Product Development', 'VP Engineering', 249800.0000, 257184.0000, 7384.0000),
('Southern', 'Product Development', 'Senior Engineer', 831800.0000, 814449.0000, -17351.0000),
('Southern', 'Product Development', 'Engineer', 720000.0000, 707400.0000, -12600.0000),
('Southern', 'Product Development', 'QA Manager', 237200.0000, 245119.0000, 7919.0000),
('Southern', 'Product Development', 'QA Engineer', 226000.0000, 234395.0000, 8395.0000),
('Southern', 'Professional Services', 'SVP Services', 3793000.0000, 3818000.0000, 25000.0000),
('Southern', 'Professional Services', 'Services Mgr', 4333400.0000, 4318000.0000, -15400.0000),
('Southern', 'Professional Services', 'Senior Consultant', 3721780.0000, 3718000.0000, -3780.0000),
('Southern', 'Professional Services', 'Staff Consultant', 3465490.0000, 3618000.0000, 152510.0000),
('Southern', 'Professional Services', 'Trainer', 3436200.0000, 2918000.0000, -518200.0000),
('Western', 'Sales', 'District Manager', 700000.0000, 688250.0000, -11750.0000),
('Western', 'Sales', 'Senior Sales Rep', 421200.0000, 421299.0000, 99.0000),
('Western', 'Sales', 'Sales Rep', 690000.0000, 678675.0000, -11325.0000),
('Western', 'Sales', 'Account Executive', 290000.0000, 295675.0000, 5675.0000),
('Western', 'Sales', 'Pre-Sales', 650000.0000, 640375.0000, -9625.0000),
('Western', 'Executive Management', 'CEO', 500000.0000, 478750.0000, -21250.0000),
('Western', 'Executive Management', 'SVP WW Operations', 249800.0000, 239184.0000, -10616.0000),
('Western', 'Executive Management', 'SVP Strategic Development', 226000.0000, 216395.0000, -9605.0000),
('Western', 'Executive Management', 'SVP Partnerships', 531780.0000, 509179.0000, -22601.0000),
('Western', 'Finance', 'CFO', 831800.0000, 814449.0000, -17351.0000),
('Western', 'Finance', 'Administrative Assisitant', 918400.0000, 897368.0000, -21032.0000),
('Western', 'Finance', 'IS', 531780.0000, 527179.0000, -4601.0000),
('Western', 'Finance', 'Controller', 531200.0000, 526624.0000, -4576.0000),
('Western', 'Finance', 'Payroll', 226000.0000, 234395.0000, 8395.0000),
('Western', 'Human Resource', 'Administration', 500000.0000, 496750.0000, -3250.0000),
('Western', 'Human Resource', 'SVP HR', 538000.0000, 533135.0000, -4865.0000),
('Western', 'Human Resource', 'HR Generalists', 961000.0000, 938158.0000, -22842.0000),
('Western', 'Human Resource', 'HR Training', 271200.0000, 277674.0000, 6474.0000),
('Western', 'Human Resource', 'Sexual Harassment', 471200.0000, 469174.0000, -2026.0000),
('Western', 'Human Resource', 'EOE', 470800.0000, 468791.0000, -2009.0000),
('Western', 'Marketing & Communication', 'CMO', 918400.0000, 897368.0000, -21032.0000),
('Western', 'Marketing & Communication', 'Product Marketing Mgr', 716400.0000, 703953.0000, -12447.0000),
('Western', 'Marketing & Communication', 'Analyst Relations', 250000.0000, 257375.0000, 7375.0000),
('Western', 'Marketing & Communication', 'Press Relations', 421310.0000, 421404.0000, 94.0000),
('Western', 'Marketing & Communication', 'Graphics', 850000.0000, 831875.0000, -18125.0000),
('Western', 'Marketing & Communication', 'Writer', 284000.0000, 289930.0000, 5930.0000),
('Western', 'Product Development', 'CTO', 284000.0000, 289930.0000, 5930.0000),
('Western', 'Product Development', 'VP Engineering', 249800.0000, 257184.0000, 7384.0000),
('Western', 'Product Development', 'Senior Engineer', 831800.0000, 814449.0000, -17351.0000);
INSERT INTO PUBLIC.QUADRANT_ACTUALS(REGION, DEPARTMENT, POSITIONTITLE, ACTUAL, BUDGET, VARIANCE) VALUES
('Western', 'Product Development', 'Engineer', 720000.0000, 707400.0000, -12600.0000),
('Western', 'Product Development', 'QA Manager', 237200.0000, 245119.0000, 7919.0000),
('Western', 'Product Development', 'QA Engineer', 226000.0000, 234395.0000, 8395.0000),
('Western', 'Professional Services', 'SVP Services', 3793000.0000, 3818000.0000, 25000.0000),
('Western', 'Professional Services', 'Services Mgr', 4333400.0000, 4418000.0000, 84600.0000),
('Western', 'Professional Services', 'Senior Consultant', 3721780.0000, 3718000.0000, -3780.0000),
('Western', 'Professional Services', 'Staff Consultant', 3465490.0000, 3336206.0000, -129284.0000),
('Western', 'Professional Services', 'Trainer', 3436200.0000, 2918000.0000, -518200.0000);
DROP TABLE IF EXISTS PUBLIC.DEPARTMENT_MANAGERS;
CREATE MEMORY TABLE PUBLIC.DEPARTMENT_MANAGERS(
    REGION VARCHAR(50) NOT NULL,
    MANAGER_NAME VARCHAR(50) NOT NULL,
    EMAIL VARCHAR(50)
);
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.DEPARTMENT_MANAGERS;
INSERT INTO PUBLIC.DEPARTMENT_MANAGERS(REGION, MANAGER_NAME, EMAIL) VALUES
('Central', 'Joe Pentaho', 'joe.pentaho@pentaho.org'),
('Eastern', 'Suzy Pentaho', 'suzy.pentaho@pentaho.org'),
('Western', 'Pat Pentaho', 'pat.pentaho@pentaho.org'),
('Southern', 'Tiffany Pentaho', 'tiffany.pentaho@pentaho.org');
DROP TABLE IF EXISTS PUBLIC.CUSTOMERS;
CREATE MEMORY TABLE PUBLIC.CUSTOMERS(
    CUSTOMERNUMBER INTEGER NOT NULL,
    CUSTOMERNAME VARCHAR(50) NOT NULL,
    CONTACTLASTNAME VARCHAR(50) NOT NULL,
    CONTACTFIRSTNAME VARCHAR(50) NOT NULL,
    PHONE VARCHAR(50) NOT NULL,
    ADDRESSLINE1 VARCHAR(50) NOT NULL,
    ADDRESSLINE2 VARCHAR(50),
    CITY VARCHAR(50) NOT NULL,
    STATE VARCHAR(50),
    POSTALCODE VARCHAR(15),
    COUNTRY VARCHAR(50) NOT NULL,
    SALESREPEMPLOYEENUMBER INTEGER,
    CREDITLIMIT NUMERIC(17)
);
ALTER TABLE PUBLIC.CUSTOMERS ADD CONSTRAINT PUBLIC.CONSTRAINT_6 PRIMARY KEY(CUSTOMERNUMBER);
-- 122 +/- SELECT COUNT(*) FROM PUBLIC.CUSTOMERS;
INSERT INTO PUBLIC.CUSTOMERS(CUSTOMERNUMBER, CUSTOMERNAME, CONTACTLASTNAME, CONTACTFIRSTNAME, PHONE, ADDRESSLINE1, ADDRESSLINE2, CITY, STATE, POSTALCODE, COUNTRY, SALESREPEMPLOYEENUMBER, CREDITLIMIT) VALUES
(103, 'Atelier graphique', 'Schmitt', 'Carine', '40.32.2555', '54, rue Royale', NULL, 'Nantes', NULL, '44000', 'France', 1370, 21000),
(112, 'Signal Gift Stores', 'King', 'Sue', '7025551838', '8489 Strong St.', NULL, 'Las Vegas', 'NV', '83030', 'USA', 1166, 71800),
(114, 'Australian Collectors, Co.', 'Ferguson', 'Peter', '03 9520 4555', '636 St Kilda Road', 'Level 3', 'Melbourne', 'Victoria', '3004', 'Australia', 1611, 117300),
(119, 'La Rochelle Gifts', 'Labrune', 'Janine', '40.67.8555', '67, rue des Cinquante Otages', NULL, 'Nantes', NULL, '44000', 'France', 1370, 118200),
(121, 'Baane Mini Imports', 'Bergulfsen', 'Jonas', '07-98 9555', 'Erling Skakkes gate 78', NULL, 'Stavern', NULL, '4110', 'Norway', 1504, 81700),
(124, 'Mini Gifts Distributors Ltd.', 'Nelson', 'Valarie', '4155551450', '5677 Strong St.', NULL, 'San Rafael', 'CA', '97562', 'USA', 1165, 210500),
(125, 'Havel & Zbyszek Co', 'Piestrzeniewicz', 'Zbyszek', '(26) 642-7555', 'ul. Filtrowa 68', NULL, 'Warszawa', NULL, '01-012', 'Poland', NULL, 0),
(128, 'Blauer See Auto, Co.', 'Keitel', 'Roland', '+49 69 66 90 2555', 'Lyonerstr. 34', NULL, 'Frankfurt', NULL, '60528', 'Germany', 1504, 59700),
(129, 'Mini Wheels Co.', 'Murphy', 'Julie', '6505555787', '5557 North Pendale Street', NULL, 'San Francisco', 'CA', '94217', 'USA', 1165, 64600),
(131, 'Land of Toys Inc.', 'Yu', 'Kwai', '2125557818', '897 Long Airport Avenue', NULL, 'NYC', 'NY', '10022', 'USA', 1323, 114900),
(141, 'Euro+ Shopping Channel', 'Freyre', 'Diego', '(91) 555 94 44', 'C/ Moralzarzal, 86', NULL, 'Madrid', NULL, '28034', 'Spain', 1370, 227600),
(144, 'Volvo Model Replicas, Co', 'Berglund', 'Christina', '0921-12 3555', 'Berguvsv\u00e4gen  8', NULL, 'Lule\u00e5', NULL, 'S-958 22', 'Sweden', 1504, 53100),
(145, 'Danish Wholesale Imports', 'Petersen', 'Jytte', '31 12 3555', 'Vinb\u00e6ltet 34', NULL, 'Kobenhavn', NULL, '1734', 'Denmark', 1401, 83400),
(146, 'Saveley & Henriot, Co.', 'Saveley', 'Mary', '78.32.5555', '2, rue du Commerce', NULL, 'Lyon', NULL, '69004', 'France', 1337, 123900),
(148, 'Dragon Souveniers, Ltd.', 'Natividad', 'Eric', '+65 221 7555', 'Bronz Sok., Bronz Apt. 3/6 Tesvikiye', NULL, 'Singapore', NULL, '079903', 'Singapore', 1621, 103800),
(151, 'Muscle Machine Inc', 'Young', 'Jeff', '2125557413', '4092 Furth Circle', 'Suite 400', 'NYC', 'NY', '10022', 'USA', 1286, 138500),
(157, 'Diecast Classics Inc.', 'Yu', 'Kyung', '2155551555', '7586 Pompton St.', NULL, 'Allentown', 'PA', '70267', 'USA', 1216, 100600),
(161, 'Technics Stores Inc.', 'Hirano', 'Juri', '6505556809', '9408 Furth Circle', NULL, 'Burlingame', 'CA', '94217', 'USA', 1165, 84600),
(166, 'Handji Gifts& Co', 'Victorino', 'Wendy', '+65 224 1555', 'Village Close - 106 Linden Road Sandown', '2nd Floor', 'Singapore', NULL, '069045', 'Singapore', 1612, 97900),
(167, 'Herkku Gifts', 'Oeztan', 'Veysel', '+47 2267 3215', 'Drammen 121, PR 744 Sentrum', NULL, 'Bergen', NULL, 'N 5804', 'Norway', 1504, 96800),
(168, 'American Souvenirs Inc', 'Franco', 'Sue', '2035557845', '149 Spinnaker Dr.', 'Suite 101', 'New Haven', 'CT', '97823', 'USA', 1286, 0),
(169, 'Porto Imports Co.', 'de Castro', 'Isabel', '(1) 356-5555', 'Estrada da sa\u00fade n. 58', NULL, 'Lisboa', NULL, '1756', 'Portugal', NULL, 0),
(171, 'Daedalus Designs Imports', 'Ranc\u00e9', 'Martine', '20.16.1555', '184, chauss\u00e9e de Tournai', NULL, 'Lille', NULL, '59000', 'France', 1370, 82900),
(172, 'La Corne D''abondance, Co.', 'Bertrand', 'Marie', '(1) 42.34.2555', '265, boulevard Charonne', NULL, 'Paris', NULL, '75012', 'France', 1337, 84300),
(173, 'Cambridge Collectables Co.', 'Tseng', 'Kyung', '6175555555', '4658 Baden Av.', NULL, 'Cambridge', 'MA', '51247', 'USA', 1188, 43400),
(175, 'Gift Depot Inc.', 'King', 'Julie', '2035552570', '25593 South Bay Ln.', NULL, 'Bridgewater', 'CT', '97562', 'USA', 1323, 84300),
(177, 'Osaka Souveniers Co.', 'Kentary', 'Mory', '+81 06 6342 5555', 'Dojima Avanza 4F, 1-6-20 Dojima, Kita-ku', NULL, 'Osaka', 'Osaka', ' 530-0003', 'Japan', 1621, 81200);
INSERT INTO PUBLIC.CUSTOMERS(CUSTOMERNUMBER, CUSTOMERNAME, CONTACTLASTNAME, CONTACTFIRSTNAME, PHONE, ADDRESSLINE1, ADDRESSLINE2, CITY, STATE, POSTALCODE, COUNTRY, SALESREPEMPLOYEENUMBER, CREDITLIMIT) VALUES
(181, 'Vitachrome Inc.', 'Frick', 'Michael', '2125551500', '2678 Kingston Rd.', 'Suite 101', 'NYC', 'NY', '10022', 'USA', 1286, 76400),
(186, 'Toys of Finland, Co.', 'Karttunen', 'Matti', '90-224 8555', 'Keskuskatu 45', NULL, 'Helsinki', NULL, '21240', 'Finland', 1501, 96500),
(187, 'AV Stores, Co.', 'Ashworth', 'Victoria', '(171) 555-1555', 'Fauntleroy Circus', NULL, 'Manchester', NULL, 'EC2 5NT', 'UK', 1501, 136800),
(189, 'Clover Collections, Co.', 'Cassidy', 'Dean', '+353 1862 1555', '25 Maiden Lane', 'Floor No. 4', 'Dublin', NULL, '2', 'Ireland', 1504, 69400),
(198, 'Auto-Moto Classics Inc.', 'Taylor', 'Leslie', '6175558428', '16780 Pompton St.', NULL, 'Brickhaven', 'MA', '58339', 'USA', 1216, 23000),
(201, 'UK Collectables, Ltd.', 'Devon', 'Elizabeth', '(171) 555-2282', 'Berkeley Gardens 12  Brewery', NULL, 'Liverpool', NULL, 'WX1 6LT', 'UK', 1501, 92700),
(202, 'Canadian Gift Exchange Network', 'Tannamuri', 'Yoshi', '(604) 555-3392', '1900 Oak St.', NULL, 'Vancouver', 'BC', 'V3F 2K1', 'Canada', 1323, 90300),
(204, 'Online Mini Collectables', 'Barajas', 'Miguel', '6175557555', '7635 Spinnaker Dr.', NULL, 'Brickhaven', 'MA', '58339', 'USA', 1188, 68700),
(205, 'Toys4GrownUps.com', 'Young', 'Julie', '6265557265', '78934 Hillside Dr.', NULL, 'Pasadena', 'CA', '90003', 'USA', 1166, 90700),
(206, 'Asian Shopping Network, Co', 'Walker', 'Brydey', '+612 9411 1555', 'Penthouse Level, Suntec Tower Three, 8 Temasek', NULL, 'Singapore', NULL, '038988', 'Singapore', NULL, 0),
(209, 'Mini Caravy', 'Citeaux', 'Fr\u00e9d\u00e9rique', '88.60.1555', '24, place Kl\u00e9ber', NULL, 'Strasbourg', NULL, '67000', 'France', 1370, 53800),
(211, 'King Kong Collectables, Co.', 'Sunwoo', 'Michael', '+852 2251 1555', 'Bank of China Tower, 1 Garden Road', 'Level 25', 'Central Hong Kong', NULL, '', 'Hong Kong', 1621, 58600),
(216, 'Enaco Distributors', 'Saavedra', 'Eduardo', '(93) 203 4555', 'Rambla de Catalu\u00f1a, 23', NULL, 'Barcelona', NULL, '08022', 'Spain', 1702, 60300),
(219, 'Boards & Toys Co.', 'Young', 'Leslie', '3105552373', '4097 Douglas Av.', NULL, 'Glendale', 'CA', '92561', 'USA', 1166, 11000),
(223, 'Nat\u00fcrlich Autos', 'Kloss', 'Horst', '0372-555188', 'Taucherstra\u00dfe 10', NULL, 'Cunewalde', NULL, '01307', 'Germany', NULL, 0),
(227, 'Heintze Collectables', 'Ibsen', 'Palle', '86 21 3555', 'Smagsloget 45', NULL, '\u00c5rhus', NULL, '8200', 'Denmark', 1401, 120800),
(233, 'Qu\u00e9bec Home Shopping Network', 'Fresni\u00e8re', 'Jean', '(514) 555-8054', '43 rue St. Laurent', NULL, 'Montr\u00e9al', 'Qu\u00e9bec', 'H1J 1C3', 'Canada', 1286, 48700),
(237, 'ANG Resellers', 'Camino', 'Alejandra', '(91) 745 6555', 'Gran V\u00eda, 1', NULL, 'Madrid', NULL, '28001', 'Spain', NULL, 0),
(239, 'Collectable Mini Designs Co.', 'Thompson', 'Valarie', '7605558146', '361 Furth Circle', NULL, 'San Diego', 'CA', '91217', 'USA', 1166, 105000),
(240, 'giftsbymail.co.uk', 'Bennett', 'Helen', '(198) 555-8888', 'Garden House Crowther Way', NULL, 'Cowes', 'Isle of Wight', 'PO31 7PJ', 'UK', 1501, 93900),
(242, 'Alpha Cognac', 'Roulet', 'Annette', '61.77.6555', '1 rue Alsace-Lorraine', NULL, 'Toulouse', NULL, '31000', 'France', 1370, 61100),
(247, 'Messner Shopping Network', 'Messner', 'Renate', '069-0555984', 'Magazinweg 7', NULL, 'Frankfurt', NULL, '60528', 'Germany', NULL, 0),
(249, 'Amica Models & Co.', 'Accorti', 'Paolo', '011-4988555', 'Via Monte Bianco 34', NULL, 'Torino', NULL, '10100', 'Italy', 1401, 113000),
(250, 'Lyon Souveniers', 'Da Cunha', 'Daniel', '+33 1 46 62 7555', '27 rue du Colonel Pierre Avia', NULL, 'Paris', NULL, '75508', 'France', 1337, 68100),
(256, 'Auto Associ\u00e9s & Cie.', 'Tonini', 'Daniel', '30.59.8555', '67, avenue de l''Europe', NULL, 'Versailles', NULL, '78000', 'France', 1370, 77900),
(259, 'Toms Spezialit\u00e4ten, Ltd', 'Pfalzheim', 'Henriette', '0221-5554327', 'Mehrheimerstr. 369', NULL, 'K\u00f6ln', NULL, '50739', 'Germany', 1504, 120400);
INSERT INTO PUBLIC.CUSTOMERS(CUSTOMERNUMBER, CUSTOMERNAME, CONTACTLASTNAME, CONTACTFIRSTNAME, PHONE, ADDRESSLINE1, ADDRESSLINE2, CITY, STATE, POSTALCODE, COUNTRY, SALESREPEMPLOYEENUMBER, CREDITLIMIT) VALUES
(260, 'Royal Canadian Collectables, Ltd.', 'Lincoln', 'Elizabeth', '(604) 555-4555', '23 Tsawassen Blvd.', NULL, 'Tsawassen', 'BC', 'T2F 8M4', 'Canada', 1323, 89600),
(273, 'Franken Gifts, Co', 'Franken', 'Peter', '089-0877555', 'Berliner Platz 43', NULL, 'M\u00fcnchen', NULL, '80805', 'Germany', NULL, 0),
(276, 'Anna''s Decorations, Ltd', 'O''Hara', 'Anna', '02 9936 8555', '201 Miller Street', 'Level 15', 'North Sydney', 'NSW', '2060', 'Australia', 1611, 107800),
(278, 'Rovelli Gifts', 'Rovelli', 'Giovanni', '035-640555', 'Via Ludovico il Moro 22', NULL, 'Bergamo', NULL, '24100', 'Italy', 1401, 119600),
(282, 'Souveniers And Things Co.', 'Huxley', 'Adrian', '+61 2 9495 8555', 'Monitor Money Building, 815 Pacific Hwy', 'Level 6', 'Chatswood', 'NSW', '2067', 'Australia', 1611, 93300),
(286, 'Marta''s Replicas Co.', 'Hernandez', 'Marta', '6175558555', '39323 Spinnaker Dr.', NULL, 'Cambridge', 'MA', '51247', 'USA', 1216, 123700),
(293, 'BG&E Collectables', 'Pon', 'Ed', '+41 26 425 50 01', 'Rte des Arsenaux 41', NULL, 'Fribourg', NULL, '1700', 'Switzerland', NULL, 0),
(298, 'Vida Sport, Ltd', 'Holz', 'Michael', '0897-034555', 'Grenzacherweg 237', NULL, 'Gen\u00e8ve', NULL, '1203', 'Switzerland', 1702, 141300),
(299, 'Norway Gifts By Mail, Co.', 'Klaeboe', 'Jan', '+47 2212 1555', 'Drammensveien 126 A, PB 744 Sentrum', NULL, 'Oslo', NULL, 'N 0106', 'Norway', 1504, 95100),
(303, 'Schuyler Imports', 'Schuyler', 'Bradley', '+31 20 491 9555', 'Kingsfordweg 151', NULL, 'Amsterdam', NULL, '1043 GR', 'Netherlands', NULL, 0),
(307, 'Der Hund Imports', 'Anders', 'Maria', '030-0074555', 'Obere Str. 57', NULL, 'Berlin', NULL, '12209', 'Germany', NULL, 0),
(311, 'Oulu Toy Supplies, Inc.', 'Koskitalo', 'Pirkko', '981-443655', 'Torikatu 38', NULL, 'Oulu', NULL, '90110', 'Finland', 1501, 90500),
(314, 'Petit Auto', 'Dewey', 'Catherine', '(02) 5554 67', 'Rue Joseph-Bens 532', NULL, 'Bruxelles', NULL, 'B-1180', 'Belgium', 1401, 79900),
(319, 'Mini Classics', 'Frick', 'Steve', '9145554562', '3758 North Pendale Street', NULL, 'White Plains', 'NY', '24067', 'USA', 1323, 102700),
(320, 'Mini Creations Ltd.', 'Tam', 'Wing C', '5085559555', '4575 Hillside Dr.', NULL, 'New Bedford', 'MA', '50553', 'USA', 1188, 94500),
(321, 'Corporate Gift Ideas Co.', 'Brown', 'Julie', '6505551386', '7734 Strong St.', NULL, 'San Francisco', 'CA', '94217', 'USA', 1165, 105000),
(323, 'Down Under Souveniers, Inc', 'Graham', 'Mike', '+64 9 312 5555', '162-164 Grafton Road', 'Level 2', 'Auckland', NULL, '', 'New Zealand', 1612, 88000),
(324, 'Stylish Desk Decors, Co.', 'Brown', 'Ann', '(171) 555-0297', '35 King George', NULL, 'London', NULL, 'WX3 6FW', 'UK', 1501, 77000),
(328, 'Tekni Collectables Inc.', 'Brown', 'William', '2015559350', '7476 Moss Rd.', NULL, 'Newark', 'NJ', '94019', 'USA', 1323, 44100),
(333, 'Australian Gift Network, Co', 'Calaghan', 'Tony', '61-7-3844-6555', '31 Duncan St. West End', NULL, 'South Brisbane', 'Queensland', '4101', 'Australia', 1611, 51600),
(334, 'Suominen Souveniers', 'Suominen', 'Kalle', '+358 9 8045 555', 'Software Engineering Center, SEC Oy', NULL, 'Espoo', NULL, 'FIN-02271', 'Finland', 1501, 98800),
(335, 'Cramer Spezialit\u00e4ten, Ltd', 'Cramer', 'Philip', '0555-09555', 'Maubelstr. 90', NULL, 'Brandenburg', NULL, '14776', 'Germany', NULL, 0),
(339, 'Classic Gift Ideas, Inc', 'Cervantes', 'Francisca', '2155554695', '782 First Street', NULL, 'Philadelphia', 'PA', '71270', 'USA', 1188, 81100),
(344, 'CAF Imports', 'Fernandez', 'Jesus', '+34 913 728 555', 'Merchants House, 27-30 Merchant''s Quay', NULL, 'Madrid', NULL, '28023', 'Spain', 1702, 59600),
(347, 'Men ''R'' US Retailers, Ltd.', 'Chandler', 'Michael', '2155554369', '6047 Douglas Av.', NULL, 'Los Angeles', 'CA', '91003', 'USA', 1166, 57700),
(348, 'Asian Treasures, Inc.', 'McKenna', 'Patricia', '2967 555', '8 Johnstown Road', NULL, 'Cork', 'Co. Cork', NULL, 'Ireland', NULL, 0);
INSERT INTO PUBLIC.CUSTOMERS(CUSTOMERNUMBER, CUSTOMERNAME, CONTACTLASTNAME, CONTACTFIRSTNAME, PHONE, ADDRESSLINE1, ADDRESSLINE2, CITY, STATE, POSTALCODE, COUNTRY, SALESREPEMPLOYEENUMBER, CREDITLIMIT) VALUES
(350, 'Marseille Mini Autos', 'Lebihan', 'Laurence', '91.24.4555', '12, rue des Bouchers', NULL, 'Marseille', NULL, '13008', 'France', 1337, 65000),
(353, 'Reims Collectables', 'Henriot', 'Paul', '26.47.1555', '59 rue de l''Abbaye', NULL, 'Reims', NULL, '51100', 'France', 1337, 81100),
(356, 'SAR Distributors, Co', 'Kuger', 'Armand', '+27 21 550 3555', 'Century City-Montague Gardens PO Box 37177', NULL, 'Chempet', NULL, ' 7442', 'South Africa', NULL, 0),
(357, 'GiftsForHim.com', 'MacKinlay', 'Wales', '64-9-3763555', '199 Great North Road', NULL, 'Auckland', NULL, '', 'New Zealand', 1612, 77700),
(361, 'Kommission Auto', 'Josephs', 'Karin', '0251-555259', 'Luisenstr. 48', NULL, 'M\u00fcnster', NULL, '44087', 'Germany', NULL, 0),
(362, 'Gifts4AllAges.com', 'Yoshido', 'Juri', '6175559555', '8616 Spinnaker Dr.', NULL, 'Boston', 'MA', '51003', 'USA', 1216, 41900),
(363, 'Online Diecast Creations Co.', 'Young', 'Valarie', '6035558647', '2304 Long Airport Avenue', NULL, 'Nashua', 'NH', '62005', 'USA', 1216, 114200),
(369, 'Lisboa Souveniers, Inc', 'Rodriguez', 'Lino', '(1) 354-2555', 'Jardim das rosas n. 32', NULL, 'Lisboa', NULL, '1675', 'Portugal', NULL, 0),
(376, 'Precious Collectables', 'Wang', 'Yang', '0452-076555', 'Hauptstr. 29', NULL, 'Bern', NULL, '3012', 'Switzerland', 1702, 0),
(379, 'Collectables For Less Inc.', 'Nelson', 'Allen', '6175558555', '7825 Douglas Av.', NULL, 'Brickhaven', 'MA', '58339', 'USA', 1188, 70700),
(381, 'Royale Belge', 'Cartrain', 'Pascale', '(071) 23 67 2555', 'Boulevard Tirou, 255', NULL, 'Charleroi', NULL, 'B-6000', 'Belgium', 1401, 23500),
(382, 'Salzburg Collectables', 'Pipps', 'Georg', '6562-9555', 'Geislweg 14', NULL, 'Salzburg', NULL, '5020', 'Austria', 1401, 71700),
(385, 'Cruz & Sons Co.', 'Cruz', 'Arnold', '+63 2 555 3587', '15 McCallum Street - NatWest Center #13-03', NULL, 'Makati City', NULL, '1227 MM', 'Philippines', 1621, 81500),
(386, 'L''ordine Souveniers', 'Moroni', 'Maurizio', '0522-556555', 'Strada Provinciale 124', NULL, 'Reggio Emilia', NULL, '42100', 'Italy', 1401, 121400),
(398, 'Tokyo Collectables, Ltd', 'Shimamura', 'Akiko', '+81 3 3584 0555', '2-2-8 Roppongi', NULL, 'Minato-ku', 'Tokyo', '106-0032', 'Japan', 1621, 94400),
(406, 'Auto Canal+ Petit', 'Perrier', 'Dominique', '(1) 47.55.6555', '25, rue Lauriston', NULL, 'Paris', NULL, '75016', 'France', 1337, 95000),
(409, 'Stuttgart Collectable Exchange', 'M\u00fcller', 'Rita', '0711-555361', 'Adenauerallee 900', NULL, 'Stuttgart', NULL, '70563', 'Germany', NULL, 0),
(412, 'Extreme Desk Decorations, Ltd', 'McRoy', 'Sarah', '04 499 9555', '101 Lambton Quay', 'Level 11', 'Wellington', NULL, '', 'New Zealand', 1612, 86800),
(415, 'Bavarian Collectables Imports, Co.', 'Donnermeyer', 'Michael', ' +49 89 61 08 9555', 'Hansastr. 15', NULL, 'Munich', NULL, '80686', 'Germany', 1504, 77000),
(424, 'Classic Legends Inc.', 'Hernandez', 'Maria', '2125558493', '5905 Pompton St.', 'Suite 750', 'NYC', 'NY', '10022', 'USA', 1286, 67500),
(443, 'Feuer Online Stores, Inc', 'Feuer', 'Alexander', '0342-555176', 'Heerstr. 22', NULL, 'Leipzig', NULL, '04179', 'Germany', NULL, 0),
(447, 'Gift Ideas Corp.', 'Lewis', 'Dan', '2035554407', '2440 Pompton St.', NULL, 'Glendale', 'CT', '97561', 'USA', 1323, 49700),
(448, 'Scandinavian Gift Ideas', 'Larsson', 'Maria', '0695-34 6555', '\u00c5kergatan 24', NULL, 'Br\u00e4cke', NULL, 'S-844 67', 'Sweden', 1504, 116400),
(450, 'The Sharp Gifts Warehouse', 'Frick', 'Sue', '4085553659', '3086 Ingle Ln.', NULL, 'San Jose', 'CA', '94217', 'USA', 1165, 77600),
(452, 'Mini Auto Werke', 'Mendel', 'Roland', '7675-3555', 'Kirchgasse 6', NULL, 'Graz', NULL, '8010', 'Austria', 1401, 45300),
(455, 'Super Scale Inc.', 'Murphy', 'Leslie', '2035559545', '567 North Pendale Street', NULL, 'New Haven', 'CT', '97823', 'USA', 1286, 95400),
(456, 'Microscale Inc.', 'Kuo', 'Kee', '2125551957', '5290 North Pendale Street', 'Suite 200', 'NYC', 'NY', '10022', 'USA', 1286, 39800);
INSERT INTO PUBLIC.CUSTOMERS(CUSTOMERNUMBER, CUSTOMERNAME, CONTACTLASTNAME, CONTACTFIRSTNAME, PHONE, ADDRESSLINE1, ADDRESSLINE2, CITY, STATE, POSTALCODE, COUNTRY, SALESREPEMPLOYEENUMBER, CREDITLIMIT) VALUES
(458, 'Corrida Auto Replicas, Ltd', 'Sommer', 'Mart\u00edn', '(91) 555 22 82', 'C/ Araquil, 67', NULL, 'Madrid', NULL, '28023', 'Spain', 1702, 104600),
(459, 'Warburg Exchange', 'Ottlieb', 'Sven', '0241-039123', 'Walserweg 21', NULL, 'Aachen', NULL, '52066', 'Germany', NULL, 0),
(462, 'FunGiftIdeas.com', 'Benitez', 'Violeta', '5085552555', '1785 First Street', NULL, 'New Bedford', 'MA', '50553', 'USA', 1216, 85800),
(465, 'Anton Designs, Ltd.', 'Anton', 'Carmen', '+34 913 728555', 'c/ Gobelas, 19-1 Urb. La Florida', NULL, 'Madrid', NULL, '28023', 'Spain', NULL, 0),
(471, 'Australian Collectables, Ltd', 'Connery', 'Sean', '61-9-3844-6555', '7 Allen Street', NULL, 'Glen Waverly', 'Victoria', '3150', 'Australia', 1611, 60300),
(473, 'Frau da Collezione', 'Ricotti', 'Franco', '+39 022515555', '20093 Cologno Monzese, via Alessandro Volta 16', NULL, 'Milan', NULL, '', 'Italy', 1401, 34800),
(475, 'West Coast Collectables Co.', 'Thompson', 'Steve', '3105553722', '3675 Furth Circle', NULL, 'Burbank', 'CA', '94019', 'USA', 1166, 55400),
(477, 'Mit Vergn\u00fcgen & Co.', 'Moos', 'Hanna', '0621-08555', 'Forsterstr. 57', NULL, 'Mannheim', NULL, '68306', 'Germany', NULL, 0),
(480, 'Kremlin Collectables, Co.', 'Semenov', 'Alexander', '+7 812 293 0521', '2 Pobedy Square', NULL, 'Saint Petersburg', NULL, '196143', 'Russia', NULL, 0),
(481, 'Raanan Stores, Inc', 'Altagar,G M', 'Raanan', '+ 972 9 959 8555', '3 Hagalim Blv.,', NULL, 'Herzlia', NULL, '47625', 'Israel', NULL, 0),
(484, 'Iberia Gift Imports, Corp.', 'Roel', 'Jos\u00e9 Pedro', '(95) 555 82 82', 'C/ Romero, 33', NULL, 'Sevilla', NULL, '41101', 'Spain', 1702, 65700),
(486, 'Motor Mint Distributors Inc.', 'Hernandez', 'Rosa', '2155559857', '11328 Douglas Av.', NULL, 'Philadelphia', 'PA', '71270', 'USA', 1323, 72600),
(487, 'Signal Collectibles Ltd.', 'Taylor', 'Sue', '4155554312', '2793 Furth Circle', NULL, 'Brisbane', 'CA', '94217', 'USA', 1165, 60300),
(489, 'Double Decker Gift Stores, Ltd', 'Hardy', 'Thomas', '(171) 555-7555', '120 Hanover Sq.', NULL, 'London', NULL, 'WA1 1DP', 'UK', 1501, 43300),
(495, 'Diecast Collectables', 'Franco', 'Valarie', '6175552555', '6251 Ingle Ln.', NULL, 'Boston', 'MA', '51003', 'USA', 1188, 85100),
(496, 'Kelly''s Gift Shop', 'Snowden', 'Tony', '+64 9 5555500', 'Arenales 1938 3''A''', NULL, 'Auckland', NULL, '', 'New Zealand', 1612, 110000);
DROP TABLE IF EXISTS PUBLIC.EMPLOYEES;
CREATE MEMORY TABLE PUBLIC.EMPLOYEES(
    EMPLOYEENUMBER INTEGER NOT NULL,
    LASTNAME VARCHAR(50) NOT NULL,
    FIRSTNAME VARCHAR(50) NOT NULL,
    EXTENSION VARCHAR(10) NOT NULL,
    EMAIL VARCHAR(100) NOT NULL,
    OFFICECODE VARCHAR(20) NOT NULL,
    REPORTSTO INTEGER,
    JOBTITLE VARCHAR(50) NOT NULL
);
ALTER TABLE PUBLIC.EMPLOYEES ADD CONSTRAINT PUBLIC.CONSTRAINT_4 PRIMARY KEY(EMPLOYEENUMBER);
-- 23 +/- SELECT COUNT(*) FROM PUBLIC.EMPLOYEES;
INSERT INTO PUBLIC.EMPLOYEES(EMPLOYEENUMBER, LASTNAME, FIRSTNAME, EXTENSION, EMAIL, OFFICECODE, REPORTSTO, JOBTITLE) VALUES
(1002, 'Murphy', 'Diane', 'x5800', 'dmurphy@classicmodelcars.com', '1', NULL, 'President'),
(1056, 'Patterson', 'Mary', 'x4611', 'mpatterso@classicmodelcars.com', '1', 1002, 'VP Sales'),
(1076, 'Firrelli', 'Jeff', 'x9273', 'jfirrelli@classicmodelcars.com', '1', 1002, 'VP Marketing'),
(1088, 'Patterson', 'William', 'x4871', 'wpatterson@classicmodelcars.com', '6', 1056, 'Sales Manager (JAPAN, APAC)'),
(1102, 'Bondur', 'Gerard', 'x5408', 'athompson@classicmodelcars.com', '4', 1056, 'Sale Manager (EMEA)'),
(1143, 'Bow', 'Anthony', 'x5428', 'bhoward@classicmodelcars.com', '1', 1056, 'Sales Manager (NA)'),
(1165, 'Jennings', 'Leslie', 'x3291', 'ljennings@classicmodelcars.com', '1', 1143, 'Sales Rep'),
(1166, 'Thompson', 'Leslie', 'x4065', 'lthompson@classicmodelcars.com', '1', 1143, 'Sales Rep'),
(1188, 'Firrelli', 'Julie', 'x2173', 'jfirrelli@classicmodelcars.com', '2', 1143, 'Sales Rep'),
(1216, 'Patterson', 'Steve', 'x4334', 'spatterso@classicmodelcars.com', '2', 1143, 'Sales Rep'),
(1286, 'Tseng', 'Foon Yue', 'x2248', 'ftseng@classicmodelcars.com', '3', 1143, 'Sales Rep'),
(1323, 'Vanauf', 'George', 'x4102', 'gvanauf@classicmodelcars.com', '3', 1143, 'Sales Rep'),
(1337, 'Bondur', 'Loui', 'x6493', 'lbondur@classicmodelcars.com', '4', 1102, 'Sales Rep'),
(1370, 'Hernandez', 'Gerard', 'x2028', 'ghernande@classicmodelcars.com', '4', 1102, 'Sales Rep'),
(1401, 'Castillo', 'Pamela', 'x2759', 'pcastillo@classicmodelcars.com', '4', 1102, 'Sales Rep'),
(1501, 'Bott', 'Larry', 'x2311', 'lbott@classicmodelcars.com', '7', 1102, 'Sales Rep'),
(1504, 'Jones', 'Barry', 'x102', 'bjones@classicmodelcars.com', '7', 1102, 'Sales Rep'),
(1611, 'Fixter', 'Andy', 'x101', 'afixter@classicmodelcars.com', '6', 1088, 'Sales Rep'),
(1612, 'Marsh', 'Peter', 'x102', 'pmarsh@classicmodelcars.com', '6', 1088, 'Sales Rep'),
(1619, 'King', 'Tom', 'x103', 'tking@classicmodelcars.com', '6', 1088, 'Sales Rep'),
(1621, 'Nishi', 'Mami', 'x101', 'mnishi@classicmodelcars.com', '5', 1088, 'Sales Rep'),
(1625, 'Kato', 'Yoshimi', 'x102', 'ekato@classicmodelcars.com', '5', 1088, 'Sales Rep'),
(1702, 'Gerard', 'Martin', 'x2312', 'gmartin@classicmodelcars.com', '4', 1102, 'Sales Rep');
DROP TABLE IF EXISTS PUBLIC.OFFICES;
CREATE MEMORY TABLE PUBLIC.OFFICES(
    OFFICECODE VARCHAR(50) NOT NULL,
    CITY VARCHAR(50) NOT NULL,
    PHONE VARCHAR(50) NOT NULL,
    ADDRESSLINE1 VARCHAR(50) NOT NULL,
    ADDRESSLINE2 VARCHAR(50),
    STATE VARCHAR(50),
    COUNTRY VARCHAR(50) NOT NULL,
    POSTALCODE VARCHAR(10) NOT NULL,
    TERRITORY VARCHAR(10) NOT NULL
);
ALTER TABLE PUBLIC.OFFICES ADD CONSTRAINT PUBLIC.CONSTRAINT_C PRIMARY KEY(OFFICECODE);
-- 7 +/- SELECT COUNT(*) FROM PUBLIC.OFFICES;
INSERT INTO PUBLIC.OFFICES(OFFICECODE, CITY, PHONE, ADDRESSLINE1, ADDRESSLINE2, STATE, COUNTRY, POSTALCODE, TERRITORY) VALUES
('1', 'San Francisco', '+1 650 219 4782', '100 Market Street', 'Suite 300', 'CA', 'USA', '94080', 'NA'),
('2', 'Boston', '+1 215 837 0825', '1550 Court Place', 'Suite 102', 'MA', 'USA', '02107', 'NA'),
('3', 'NYC', '+1 212 555 3000', '523 East 53rd Street', 'apt. 5A', 'NY', 'USA', '10022', 'NA'),
('4', 'Paris', '+33 14 723 4404', '43 Rue Jouffroy D''abbans', NULL, '', 'France', '75017', 'EMEA'),
('5', 'Tokyo', '+81 33 224 5000', '4-1 Kioicho', NULL, 'Chiyoda-Ku', 'Japan', '102-8578', 'Japan'),
('6', 'Sydney', '+61 2 9264 2451', '5-11 Wentworth Avenue', 'Floor #2', NULL, 'Australia', 'NSW 2010', 'APAC'),
('7', 'London', '+44 20 7877 2041', '25 Old Broad Street', 'Level 7', NULL, 'UK', 'EC2N 1HN', 'EMEA');
DROP TABLE IF EXISTS PUBLIC.ORDERDETAILS;
CREATE MEMORY TABLE PUBLIC.ORDERDETAILS(
    ORDERNUMBER INTEGER NOT NULL SELECTIVITY 10,
    PRODUCTCODE VARCHAR(50) NOT NULL SELECTIVITY 10,
    QUANTITYORDERED INTEGER NOT NULL SELECTIVITY 3,
    PRICEEACH NUMERIC(17) NOT NULL SELECTIVITY 18,
    ORDERLINENUMBER SMALLINT NOT NULL SELECTIVITY 1
);
ALTER TABLE PUBLIC.ORDERDETAILS ADD CONSTRAINT PUBLIC.CONSTRAINT_B PRIMARY KEY(ORDERNUMBER, PRODUCTCODE);
-- 2996 +/- SELECT COUNT(*) FROM PUBLIC.ORDERDETAILS;
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10100, 'S18_1749', 30, 172, 3),
(10100, 'S18_2248', 50, 68, 2),
(10100, 'S18_4409', 22, 87, 4),
(10100, 'S24_3969', 49, 34, 1),
(10101, 'S18_2325', 25, 151, 4),
(10101, 'S18_2795', 26, 145, 1),
(10101, 'S24_1937', 45, 31, 3),
(10101, 'S24_2022', 46, 54, 2),
(10102, 'S18_1342', 39, 123, 2),
(10102, 'S18_1367', 41, 50, 1),
(10103, 'S10_1949', 26, 208, 11),
(10103, 'S10_4962', 42, 129, 4),
(10103, 'S12_1666', 27, 126, 8),
(10103, 'S18_1097', 35, 112, 10),
(10103, 'S18_2432', 22, 54, 2),
(10103, 'S18_2949', 27, 83, 12),
(10103, 'S18_2957', 35, 57, 14),
(10103, 'S18_3136', 25, 102, 13),
(10103, 'S18_3320', 46, 104, 16),
(10103, 'S18_4600', 36, 117, 5),
(10103, 'S18_4668', 41, 47, 9),
(10103, 'S24_2300', 36, 102, 1),
(10103, 'S24_4258', 25, 115, 15),
(10103, 'S32_1268', 31, 104, 3),
(10103, 'S32_3522', 45, 76, 7),
(10103, 'S700_2824', 42, 106, 6),
(10104, 'S12_3148', 34, 175, 1),
(10104, 'S12_4473', 41, 113, 9),
(10104, 'S18_2238', 24, 144, 8),
(10104, 'S18_2319', 29, 130, 12),
(10104, 'S18_3232', 23, 198, 13),
(10104, 'S18_4027', 38, 141, 3),
(10104, 'S24_1444', 35, 55, 6),
(10104, 'S24_2840', 44, 40, 10),
(10104, 'S24_4048', 26, 112, 5),
(10104, 'S32_2509', 35, 48, 11),
(10104, 'S32_3207', 49, 66, 4),
(10104, 'S50_1392', 33, 112, 7),
(10104, 'S50_1514', 32, 53, 2),
(10105, 'S10_4757', 50, 144, 2),
(10105, 'S12_1108', 41, 212, 15),
(10105, 'S12_3891', 29, 157, 14),
(10105, 'S18_3140', 22, 139, 11),
(10105, 'S18_3259', 38, 114, 13),
(10105, 'S18_4522', 41, 83, 10),
(10105, 'S24_2011', 43, 147, 9),
(10105, 'S24_3151', 44, 73, 4),
(10105, 'S24_3816', 50, 80, 1),
(10105, 'S700_1138', 41, 71, 5),
(10105, 'S700_1938', 29, 70, 12),
(10105, 'S700_2610', 31, 66, 3),
(10105, 'S700_3505', 39, 81, 6),
(10105, 'S700_3962', 22, 116, 7),
(10105, 'S72_3212', 25, 57, 8),
(10106, 'S18_1662', 36, 147, 12),
(10106, 'S18_2581', 34, 90, 2),
(10106, 'S18_3029', 41, 83, 18),
(10106, 'S18_3856', 41, 116, 17),
(10106, 'S24_1785', 28, 89, 4),
(10106, 'S24_2841', 49, 75, 13),
(10106, 'S24_3420', 31, 53, 14),
(10106, 'S24_3949', 50, 65, 11),
(10106, 'S24_4278', 26, 64, 3),
(10106, 'S32_4289', 33, 73, 5),
(10106, 'S50_1341', 39, 40, 6),
(10106, 'S700_1691', 31, 107, 7),
(10106, 'S700_2047', 30, 106, 16),
(10106, 'S700_2466', 34, 111, 9),
(10106, 'S700_2834', 32, 125, 1),
(10106, 'S700_3167', 44, 74, 8),
(10106, 'S700_4002', 48, 61, 10),
(10106, 'S72_1253', 48, 53, 15),
(10107, 'S10_1678', 30, 96, 2),
(10107, 'S10_2016', 39, 100, 5),
(10107, 'S10_4698', 27, 225, 4),
(10107, 'S12_2823', 21, 145, 1),
(10107, 'S18_2625', 29, 71, 6),
(10107, 'S24_1578', 25, 114, 3),
(10107, 'S24_2000', 38, 83, 7),
(10107, 'S32_1374', 20, 93, 8),
(10108, 'S12_1099', 33, 160, 6),
(10108, 'S12_3380', 45, 136, 4),
(10108, 'S12_3990', 39, 89, 7),
(10108, 'S12_4675', 36, 104, 3),
(10108, 'S18_1889', 38, 82, 2),
(10108, 'S18_3278', 26, 68, 9),
(10108, 'S18_3482', 29, 140, 8),
(10108, 'S18_3782', 43, 68, 12),
(10108, 'S18_4721', 44, 126, 11),
(10108, 'S24_2360', 35, 59, 15),
(10108, 'S24_3371', 30, 63, 5),
(10108, 'S24_3856', 40, 136, 1),
(10108, 'S24_4620', 31, 69, 10),
(10108, 'S32_2206', 27, 43, 13),
(10108, 'S32_4485', 31, 118, 16),
(10108, 'S50_4713', 34, 83, 14),
(10109, 'S18_1129', 26, 168, 4),
(10109, 'S18_1984', 38, 117, 3),
(10109, 'S18_2870', 26, 121, 1),
(10109, 'S18_3232', 46, 180, 5),
(10109, 'S18_3685', 47, 133, 2),
(10109, 'S24_2972', 29, 32, 6),
(10110, 'S18_1589', 37, 147, 16),
(10110, 'S18_1749', 42, 145, 7),
(10110, 'S18_2248', 32, 50, 6),
(10110, 'S18_2325', 33, 117, 4),
(10110, 'S18_2795', 31, 164, 1),
(10110, 'S18_4409', 28, 89, 8),
(10110, 'S18_4933', 42, 61, 9),
(10110, 'S24_1046', 36, 85, 13),
(10110, 'S24_1628', 29, 59, 15),
(10110, 'S24_1937', 20, 36, 3),
(10110, 'S24_2022', 39, 44, 2),
(10110, 'S24_2766', 43, 78, 11),
(10110, 'S24_2887', 46, 129, 10),
(10110, 'S24_3191', 27, 74, 12),
(10110, 'S24_3432', 37, 101, 14),
(10110, 'S24_3969', 48, 34, 5),
(10111, 'S18_1342', 33, 100, 6),
(10111, 'S18_1367', 48, 49, 5),
(10111, 'S18_2957', 28, 64, 2),
(10111, 'S18_3136', 43, 112, 1);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10111, 'S18_3320', 39, 107, 4),
(10111, 'S24_4258', 26, 87, 3),
(10112, 'S10_1949', 29, 249, 1),
(10112, 'S18_2949', 23, 110, 2),
(10113, 'S12_1666', 21, 163, 2),
(10113, 'S18_1097', 49, 100, 4),
(10113, 'S18_4668', 50, 50, 3),
(10113, 'S32_3522', 23, 69, 1),
(10114, 'S10_4962', 31, 139, 8),
(10114, 'S18_2319', 39, 107, 3),
(10114, 'S18_2432', 45, 69, 6),
(10114, 'S18_3232', 48, 171, 4),
(10114, 'S18_4600', 41, 117, 9),
(10114, 'S24_2300', 21, 139, 5),
(10114, 'S24_2840', 24, 30, 1),
(10114, 'S32_1268', 32, 115, 7),
(10114, 'S32_2509', 28, 56, 2),
(10114, 'S700_2824', 42, 113, 10),
(10115, 'S12_4473', 46, 124, 5),
(10115, 'S18_2238', 46, 160, 4),
(10115, 'S24_1444', 47, 69, 2),
(10115, 'S24_4048', 44, 127, 1),
(10115, 'S50_1392', 27, 105, 3),
(10116, 'S32_3207', 27, 63, 1),
(10117, 'S12_1108', 33, 183, 9),
(10117, 'S12_3148', 43, 137, 10),
(10117, 'S12_3891', 39, 152, 8),
(10117, 'S18_3140', 26, 137, 5),
(10117, 'S18_3259', 21, 96, 7),
(10117, 'S18_4027', 22, 126, 12),
(10117, 'S18_4522', 23, 97, 4),
(10117, 'S24_2011', 41, 127, 3),
(10117, 'S50_1514', 21, 49, 11),
(10117, 'S700_1938', 38, 80, 6),
(10117, 'S700_3962', 45, 83, 1),
(10117, 'S72_3212', 50, 44, 2),
(10118, 'S700_3505', 36, 117, 1),
(10119, 'S10_4757', 46, 109, 11),
(10119, 'S18_1662', 43, 161, 3),
(10119, 'S18_3029', 21, 89, 9),
(10119, 'S18_3856', 27, 100, 8),
(10119, 'S24_2841', 41, 60, 4),
(10119, 'S24_3151', 35, 88, 13),
(10119, 'S24_3420', 20, 73, 5),
(10119, 'S24_3816', 35, 91, 10),
(10119, 'S24_3949', 28, 70, 2),
(10119, 'S700_1138', 25, 77, 14),
(10119, 'S700_2047', 29, 94, 7),
(10119, 'S700_2610', 38, 66, 12),
(10119, 'S700_4002', 26, 59, 1),
(10119, 'S72_1253', 28, 48, 6),
(10120, 'S10_2016', 29, 96, 3),
(10120, 'S10_4698', 46, 201, 2),
(10120, 'S18_2581', 29, 72, 8),
(10120, 'S18_2625', 46, 58, 4),
(10120, 'S24_1578', 35, 98, 1),
(10120, 'S24_1785', 39, 119, 10),
(10120, 'S24_2000', 34, 84, 5),
(10120, 'S24_4278', 29, 85, 9),
(10120, 'S32_1374', 22, 112, 6),
(10120, 'S32_4289', 29, 72, 11),
(10120, 'S50_1341', 49, 51, 12),
(10120, 'S700_1691', 47, 82, 13),
(10120, 'S700_2466', 24, 108, 15),
(10120, 'S700_2834', 24, 142, 7),
(10120, 'S700_3167', 43, 76, 14),
(10121, 'S10_1678', 34, 81, 5),
(10121, 'S12_2823', 50, 166, 4),
(10121, 'S24_2360', 32, 77, 2),
(10121, 'S32_4485', 25, 87, 3),
(10121, 'S50_4713', 44, 75, 1),
(10122, 'S12_1099', 42, 181, 10),
(10122, 'S12_3380', 37, 100, 8),
(10122, 'S12_3990', 32, 64, 11),
(10122, 'S12_4675', 20, 107, 7),
(10122, 'S18_1129', 34, 147, 2),
(10122, 'S18_1889', 43, 72, 6),
(10122, 'S18_1984', 31, 132, 1),
(10122, 'S18_3232', 25, 144, 3),
(10122, 'S18_3278', 21, 73, 13),
(10122, 'S18_3482', 21, 118, 12),
(10122, 'S18_3782', 35, 50, 16),
(10122, 'S18_4721', 28, 128, 15),
(10122, 'S24_2972', 39, 31, 4),
(10122, 'S24_3371', 34, 50, 9),
(10122, 'S24_3856', 43, 128, 5),
(10122, 'S24_4620', 29, 71, 14),
(10122, 'S32_2206', 31, 45, 17),
(10123, 'S18_1589', 26, 118, 2),
(10123, 'S18_2870', 46, 112, 3),
(10123, 'S18_3685', 34, 157, 4),
(10123, 'S24_1628', 50, 60, 1),
(10124, 'S18_1749', 21, 136, 6),
(10124, 'S18_2248', 42, 54, 5),
(10124, 'S18_2325', 42, 106, 3),
(10124, 'S18_4409', 36, 86, 7),
(10124, 'S18_4933', 23, 58, 8),
(10124, 'S24_1046', 22, 78, 12),
(10124, 'S24_1937', 45, 38, 2),
(10124, 'S24_2022', 22, 45, 1),
(10124, 'S24_2766', 32, 73, 10),
(10124, 'S24_2887', 25, 94, 9),
(10124, 'S24_3191', 49, 83, 11),
(10124, 'S24_3432', 43, 121, 13),
(10124, 'S24_3969', 46, 33, 4),
(10125, 'S18_1342', 32, 102, 1),
(10125, 'S18_2795', 34, 191, 2),
(10126, 'S10_1949', 38, 193, 11),
(10126, 'S10_4962', 22, 152, 4),
(10126, 'S12_1666', 21, 116, 8),
(10126, 'S18_1097', 38, 102, 10),
(10126, 'S18_1367', 42, 55, 17),
(10126, 'S18_2432', 43, 65, 2),
(10126, 'S18_2949', 31, 90, 12),
(10126, 'S18_2957', 46, 74, 14),
(10126, 'S18_3136', 30, 97, 13),
(10126, 'S18_3320', 38, 82, 16),
(10126, 'S18_4600', 50, 142, 5),
(10126, 'S18_4668', 43, 54, 9),
(10126, 'S24_2300', 27, 127, 1),
(10126, 'S24_4258', 34, 105, 15),
(10126, 'S32_1268', 43, 96, 3);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10126, 'S32_3522', 26, 63, 7),
(10126, 'S700_2824', 45, 102, 6),
(10127, 'S12_1108', 46, 245, 2),
(10127, 'S12_3148', 46, 160, 3),
(10127, 'S12_3891', 42, 194, 1),
(10127, 'S12_4473', 24, 107, 11),
(10127, 'S18_2238', 45, 159, 10),
(10127, 'S18_2319', 45, 140, 14),
(10127, 'S18_3232', 22, 174, 15),
(10127, 'S18_4027', 25, 138, 5),
(10127, 'S24_1444', 20, 61, 8),
(10127, 'S24_2840', 39, 38, 12),
(10127, 'S24_4048', 20, 97, 7),
(10127, 'S32_2509', 45, 52, 13),
(10127, 'S32_3207', 29, 71, 6),
(10127, 'S50_1392', 46, 134, 9),
(10127, 'S50_1514', 46, 69, 4),
(10128, 'S18_3140', 41, 135, 2),
(10128, 'S18_3259', 41, 118, 4),
(10128, 'S18_4522', 43, 92, 1),
(10128, 'S700_1938', 32, 97, 3),
(10129, 'S10_4757', 33, 133, 2),
(10129, 'S24_2011', 45, 134, 9),
(10129, 'S24_3151', 41, 95, 4),
(10129, 'S24_3816', 50, 78, 1),
(10129, 'S700_1138', 31, 60, 5),
(10129, 'S700_2610', 45, 85, 3),
(10129, 'S700_3505', 42, 91, 6),
(10129, 'S700_3962', 30, 85, 7),
(10129, 'S72_3212', 32, 65, 8),
(10130, 'S18_3029', 40, 96, 2),
(10130, 'S18_3856', 33, 104, 1),
(10131, 'S18_1662', 21, 132, 4),
(10131, 'S24_2841', 35, 67, 5),
(10131, 'S24_3420', 29, 59, 6),
(10131, 'S24_3949', 50, 82, 3),
(10131, 'S700_2047', 22, 86, 8),
(10131, 'S700_2466', 40, 111, 1),
(10131, 'S700_4002', 26, 85, 2),
(10131, 'S72_1253', 21, 42, 7),
(10132, 'S700_3167', 36, 69, 1),
(10133, 'S18_2581', 49, 69, 3),
(10133, 'S24_1785', 41, 94, 5),
(10133, 'S24_4278', 46, 78, 4),
(10133, 'S32_1374', 23, 115, 1),
(10133, 'S32_4289', 49, 57, 6),
(10133, 'S50_1341', 27, 50, 7),
(10133, 'S700_1691', 24, 78, 8),
(10133, 'S700_2834', 27, 100, 2),
(10134, 'S10_1678', 41, 95, 2),
(10134, 'S10_2016', 27, 123, 5),
(10134, 'S10_4698', 31, 227, 4),
(10134, 'S12_2823', 20, 136, 1),
(10134, 'S18_2625', 30, 62, 6),
(10134, 'S24_1578', 35, 94, 3),
(10134, 'S24_2000', 43, 83, 7),
(10135, 'S12_1099', 42, 191, 7),
(10135, 'S12_3380', 48, 126, 5),
(10135, 'S12_3990', 24, 75, 8),
(10135, 'S12_4675', 29, 98, 4),
(10135, 'S18_1889', 48, 79, 3),
(10135, 'S18_3278', 45, 78, 10),
(10135, 'S18_3482', 42, 129, 9),
(10135, 'S18_3782', 45, 50, 13),
(10135, 'S18_4721', 31, 152, 12),
(10135, 'S24_2360', 29, 62, 16),
(10135, 'S24_2972', 20, 36, 1),
(10135, 'S24_3371', 27, 66, 6),
(10135, 'S24_3856', 47, 135, 2),
(10135, 'S24_4620', 23, 87, 11),
(10135, 'S32_2206', 33, 40, 14),
(10135, 'S32_4485', 30, 90, 17),
(10135, 'S50_4713', 44, 96, 15),
(10136, 'S18_1129', 25, 146, 2),
(10136, 'S18_1984', 36, 147, 1),
(10136, 'S18_3232', 41, 203, 3),
(10137, 'S18_1589', 44, 100, 2),
(10137, 'S18_2870', 37, 117, 3),
(10137, 'S18_3685', 31, 165, 4),
(10137, 'S24_1628', 26, 50, 1),
(10138, 'S18_1749', 33, 162, 6),
(10138, 'S18_2248', 22, 48, 5),
(10138, 'S18_2325', 38, 108, 3),
(10138, 'S18_4409', 47, 100, 7),
(10138, 'S18_4933', 23, 67, 8),
(10138, 'S24_1046', 45, 85, 12),
(10138, 'S24_1937', 22, 29, 2),
(10138, 'S24_2022', 33, 43, 1),
(10138, 'S24_2766', 28, 105, 10),
(10138, 'S24_2887', 30, 139, 9),
(10138, 'S24_3191', 49, 91, 11),
(10138, 'S24_3432', 21, 119, 13),
(10138, 'S24_3969', 29, 38, 4),
(10139, 'S18_1342', 31, 103, 7),
(10139, 'S18_1367', 49, 43, 6),
(10139, 'S18_2795', 41, 194, 8),
(10139, 'S18_2949', 46, 121, 1),
(10139, 'S18_2957', 20, 71, 3),
(10139, 'S18_3136', 20, 90, 2),
(10139, 'S18_3320', 30, 103, 5),
(10139, 'S24_4258', 29, 113, 4),
(10140, 'S10_1949', 37, 199, 11),
(10140, 'S10_4962', 26, 123, 4),
(10140, 'S12_1666', 38, 127, 8),
(10140, 'S18_1097', 32, 131, 10),
(10140, 'S18_2432', 46, 62, 2),
(10140, 'S18_4600', 40, 115, 5),
(10140, 'S18_4668', 29, 43, 9),
(10140, 'S24_2300', 47, 109, 1),
(10140, 'S32_1268', 26, 109, 3),
(10140, 'S32_3522', 28, 61, 7),
(10140, 'S700_2824', 36, 114, 6),
(10141, 'S12_4473', 21, 102, 5),
(10141, 'S18_2238', 39, 152, 4),
(10141, 'S18_2319', 47, 134, 8),
(10141, 'S18_3232', 34, 142, 9),
(10141, 'S24_1444', 20, 54, 2),
(10141, 'S24_2840', 21, 42, 6),
(10141, 'S24_4048', 40, 95, 1),
(10141, 'S32_2509', 24, 46, 7),
(10141, 'S50_1392', 44, 125, 3),
(10142, 'S12_1108', 33, 243, 12);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10142, 'S12_3148', 33, 151, 13),
(10142, 'S12_3891', 46, 206, 11),
(10142, 'S18_3140', 47, 128, 8),
(10142, 'S18_3259', 22, 98, 10),
(10142, 'S18_4027', 24, 158, 15),
(10142, 'S18_4522', 24, 70, 7),
(10142, 'S24_2011', 33, 102, 6),
(10142, 'S24_3151', 49, 98, 1),
(10142, 'S32_3207', 42, 75, 16),
(10142, 'S50_1514', 42, 50, 14),
(10142, 'S700_1138', 41, 64, 2),
(10142, 'S700_1938', 43, 84, 9),
(10142, 'S700_3505', 21, 111, 3),
(10142, 'S700_3962', 38, 85, 4),
(10142, 'S72_3212', 39, 44, 5),
(10143, 'S10_4757', 49, 114, 15),
(10143, 'S18_1662', 32, 164, 7),
(10143, 'S18_3029', 46, 75, 13),
(10143, 'S18_3856', 34, 102, 12),
(10143, 'S24_2841', 27, 61, 8),
(10143, 'S24_3420', 33, 78, 9),
(10143, 'S24_3816', 23, 81, 14),
(10143, 'S24_3949', 28, 66, 6),
(10143, 'S50_1341', 34, 37, 1),
(10143, 'S700_1691', 36, 110, 2),
(10143, 'S700_2047', 26, 100, 11),
(10143, 'S700_2466', 26, 83, 4),
(10143, 'S700_2610', 31, 85, 16),
(10143, 'S700_3167', 28, 96, 3),
(10143, 'S700_4002', 34, 86, 5),
(10143, 'S72_1253', 37, 51, 10),
(10144, 'S32_4289', 20, 82, 1),
(10145, 'S10_1678', 45, 83, 6),
(10145, 'S10_2016', 37, 140, 9),
(10145, 'S10_4698', 33, 157, 8),
(10145, 'S12_2823', 49, 170, 5),
(10145, 'S18_2581', 30, 85, 14),
(10145, 'S18_2625', 30, 50, 10),
(10145, 'S24_1578', 43, 96, 7),
(10145, 'S24_1785', 40, 88, 16),
(10145, 'S24_2000', 47, 83, 11),
(10145, 'S24_2360', 27, 61, 3),
(10145, 'S24_4278', 33, 85, 15),
(10145, 'S32_1374', 33, 94, 12),
(10145, 'S32_2206', 31, 36, 1),
(10145, 'S32_4485', 27, 120, 4),
(10145, 'S50_4713', 38, 81, 2),
(10145, 'S700_2834', 20, 138, 13),
(10146, 'S18_3782', 47, 67, 2),
(10146, 'S18_4721', 29, 153, 1),
(10147, 'S12_1099', 48, 193, 7),
(10147, 'S12_3380', 31, 113, 5),
(10147, 'S12_3990', 21, 64, 8),
(10147, 'S12_4675', 33, 98, 4),
(10147, 'S18_1889', 26, 82, 3),
(10147, 'S18_3278', 36, 86, 10),
(10147, 'S18_3482', 37, 119, 9),
(10147, 'S24_2972', 25, 43, 1),
(10147, 'S24_3371', 30, 69, 6),
(10147, 'S24_3856', 23, 126, 2),
(10147, 'S24_4620', 31, 65, 11),
(10148, 'S18_1129', 23, 117, 13),
(10148, 'S18_1589', 47, 124, 9),
(10148, 'S18_1984', 25, 169, 12),
(10148, 'S18_2870', 27, 131, 10),
(10148, 'S18_3232', 32, 169, 14),
(10148, 'S18_3685', 28, 130, 11),
(10148, 'S18_4409', 34, 106, 1),
(10148, 'S18_4933', 29, 81, 2),
(10148, 'S24_1046', 25, 60, 6),
(10148, 'S24_1628', 47, 57, 8),
(10148, 'S24_2766', 21, 74, 4),
(10148, 'S24_2887', 34, 129, 3),
(10148, 'S24_3191', 31, 74, 5),
(10148, 'S24_3432', 27, 129, 7),
(10149, 'S18_1342', 50, 118, 4),
(10149, 'S18_1367', 30, 58, 3),
(10149, 'S18_1749', 34, 158, 11),
(10149, 'S18_2248', 24, 62, 10),
(10149, 'S18_2325', 33, 150, 8),
(10149, 'S18_2795', 23, 184, 5),
(10149, 'S18_3320', 42, 94, 2),
(10149, 'S24_1937', 36, 33, 7),
(10149, 'S24_2022', 49, 49, 6),
(10149, 'S24_3969', 26, 39, 9),
(10149, 'S24_4258', 20, 91, 1),
(10150, 'S10_1949', 45, 244, 8),
(10150, 'S10_4962', 20, 160, 1),
(10150, 'S12_1666', 30, 137, 5),
(10150, 'S18_1097', 34, 137, 7),
(10150, 'S18_2949', 47, 91, 9),
(10150, 'S18_2957', 30, 50, 11),
(10150, 'S18_3136', 26, 108, 10),
(10150, 'S18_4600', 49, 132, 2),
(10150, 'S18_4668', 30, 43, 6),
(10150, 'S32_3522', 49, 58, 4),
(10150, 'S700_2824', 20, 105, 3),
(10151, 'S12_4473', 24, 139, 3),
(10151, 'S18_2238', 43, 165, 2),
(10151, 'S18_2319', 49, 110, 6),
(10151, 'S18_2432', 39, 69, 9),
(10151, 'S18_3232', 21, 178, 7),
(10151, 'S24_2300', 42, 121, 8),
(10151, 'S24_2840', 30, 40, 4),
(10151, 'S32_1268', 27, 114, 10),
(10151, 'S32_2509', 41, 64, 5),
(10151, 'S50_1392', 26, 124, 1),
(10152, 'S18_4027', 35, 129, 1),
(10152, 'S24_1444', 25, 65, 4),
(10152, 'S24_4048', 23, 122, 3),
(10152, 'S32_3207', 33, 51, 2),
(10153, 'S12_1108', 20, 245, 11),
(10153, 'S12_3148', 42, 128, 12),
(10153, 'S12_3891', 49, 144, 10),
(10153, 'S18_3140', 31, 117, 7),
(10153, 'S18_3259', 29, 89, 9),
(10153, 'S18_4522', 22, 83, 6),
(10153, 'S24_2011', 40, 136, 5),
(10153, 'S50_1514', 31, 57, 13),
(10153, 'S700_1138', 43, 65, 1),
(10153, 'S700_1938', 31, 87, 8),
(10153, 'S700_3505', 50, 88, 2);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10153, 'S700_3962', 20, 110, 3),
(10153, 'S72_3212', 50, 60, 4),
(10154, 'S24_3151', 31, 91, 2),
(10154, 'S700_2610', 36, 64, 1),
(10155, 'S10_4757', 32, 141, 13),
(10155, 'S18_1662', 38, 172, 5),
(10155, 'S18_3029', 44, 79, 11),
(10155, 'S18_3856', 29, 125, 10),
(10155, 'S24_2841', 23, 73, 6),
(10155, 'S24_3420', 34, 56, 7),
(10155, 'S24_3816', 37, 68, 12),
(10155, 'S24_3949', 44, 77, 4),
(10155, 'S700_2047', 32, 91, 9),
(10155, 'S700_2466', 20, 118, 2),
(10155, 'S700_3167', 43, 86, 1),
(10155, 'S700_4002', 44, 86, 3),
(10155, 'S72_1253', 34, 49, 8),
(10156, 'S50_1341', 20, 41, 1),
(10156, 'S700_1691', 48, 103, 2),
(10157, 'S18_2581', 33, 79, 3),
(10157, 'S24_1785', 40, 103, 5),
(10157, 'S24_4278', 33, 86, 4),
(10157, 'S32_1374', 34, 119, 1),
(10157, 'S32_4289', 28, 75, 6),
(10157, 'S700_2834', 48, 125, 2),
(10158, 'S24_2000', 22, 67, 1),
(10159, 'S10_1678', 49, 106, 14),
(10159, 'S10_2016', 37, 136, 17),
(10159, 'S10_4698', 22, 188, 16),
(10159, 'S12_1099', 41, 202, 2),
(10159, 'S12_2823', 38, 164, 13),
(10159, 'S12_3990', 24, 73, 3),
(10159, 'S18_2625', 42, 51, 18),
(10159, 'S18_3278', 21, 81, 5),
(10159, 'S18_3482', 25, 146, 4),
(10159, 'S18_3782', 21, 65, 8),
(10159, 'S18_4721', 32, 144, 7),
(10159, 'S24_1578', 44, 122, 15),
(10159, 'S24_2360', 27, 80, 11),
(10159, 'S24_3371', 50, 70, 1),
(10159, 'S24_4620', 23, 67, 6),
(10159, 'S32_2206', 35, 35, 9),
(10159, 'S32_4485', 23, 102, 12),
(10159, 'S50_4713', 31, 72, 10),
(10160, 'S12_3380', 46, 115, 6),
(10160, 'S12_4675', 50, 104, 5),
(10160, 'S18_1889', 38, 89, 4),
(10160, 'S18_3232', 20, 200, 1),
(10160, 'S24_2972', 42, 37, 2),
(10160, 'S24_3856', 35, 136, 3),
(10161, 'S18_1129', 28, 134, 12),
(10161, 'S18_1589', 43, 143, 8),
(10161, 'S18_1984', 48, 128, 11),
(10161, 'S18_2870', 23, 139, 9),
(10161, 'S18_3685', 36, 154, 10),
(10161, 'S18_4933', 25, 81, 1),
(10161, 'S24_1046', 37, 73, 5),
(10161, 'S24_1628', 23, 53, 7),
(10161, 'S24_2766', 20, 107, 3),
(10161, 'S24_2887', 25, 110, 2),
(10161, 'S24_3191', 20, 77, 4),
(10161, 'S24_3432', 30, 105, 6),
(10162, 'S18_1342', 48, 91, 2),
(10162, 'S18_1367', 45, 51, 1),
(10162, 'S18_1749', 29, 179, 9),
(10162, 'S18_2248', 27, 70, 8),
(10162, 'S18_2325', 38, 113, 6),
(10162, 'S18_2795', 48, 150, 3),
(10162, 'S18_4409', 39, 100, 10),
(10162, 'S24_1937', 37, 27, 5),
(10162, 'S24_2022', 43, 36, 4),
(10162, 'S24_3969', 37, 39, 7),
(10163, 'S10_1949', 21, 231, 1),
(10163, 'S18_2949', 31, 107, 2),
(10163, 'S18_2957', 48, 70, 4),
(10163, 'S18_3136', 40, 123, 3),
(10163, 'S18_3320', 43, 116, 6),
(10163, 'S24_4258', 42, 92, 5),
(10164, 'S10_4962', 21, 168, 2),
(10164, 'S12_1666', 49, 134, 6),
(10164, 'S18_1097', 36, 99, 8),
(10164, 'S18_4600', 45, 111, 3),
(10164, 'S18_4668', 25, 54, 7),
(10164, 'S32_1268', 24, 110, 1),
(10164, 'S32_3522', 49, 55, 5),
(10164, 'S700_2824', 39, 82, 4),
(10165, 'S12_1108', 44, 195, 3),
(10165, 'S12_3148', 34, 144, 4),
(10165, 'S12_3891', 27, 206, 2),
(10165, 'S12_4473', 48, 142, 12),
(10165, 'S18_2238', 29, 174, 11),
(10165, 'S18_2319', 46, 130, 15),
(10165, 'S18_2432', 31, 71, 18),
(10165, 'S18_3232', 47, 186, 16),
(10165, 'S18_3259', 50, 107, 1),
(10165, 'S18_4027', 28, 119, 6),
(10165, 'S24_1444', 25, 69, 9),
(10165, 'S24_2300', 32, 146, 17),
(10165, 'S24_2840', 27, 32, 13),
(10165, 'S24_4048', 24, 99, 8),
(10165, 'S32_2509', 48, 46, 14),
(10165, 'S32_3207', 44, 53, 7),
(10165, 'S50_1392', 48, 95, 10),
(10165, 'S50_1514', 38, 67, 5),
(10166, 'S18_3140', 43, 161, 2),
(10166, 'S18_4522', 26, 74, 1),
(10166, 'S700_1938', 29, 104, 3),
(10167, 'S10_4757', 44, 135, 9),
(10167, 'S18_1662', 43, 134, 1),
(10167, 'S18_3029', 46, 73, 7),
(10167, 'S18_3856', 34, 106, 6),
(10167, 'S24_2011', 33, 116, 16),
(10167, 'S24_2841', 21, 70, 2),
(10167, 'S24_3151', 20, 80, 11),
(10167, 'S24_3420', 32, 63, 3),
(10167, 'S24_3816', 29, 84, 8),
(10167, 'S700_1138', 43, 75, 12),
(10167, 'S700_2047', 29, 101, 5),
(10167, 'S700_2610', 46, 70, 10),
(10167, 'S700_3505', 24, 117, 13),
(10167, 'S700_3962', 28, 107, 14),
(10167, 'S72_1253', 40, 42, 4);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10167, 'S72_3212', 38, 49, 15),
(10168, 'S10_1678', 36, 97, 1),
(10168, 'S10_2016', 27, 136, 4),
(10168, 'S10_4698', 20, 209, 3),
(10168, 'S18_2581', 21, 71, 9),
(10168, 'S18_2625', 46, 61, 5),
(10168, 'S24_1578', 50, 115, 2),
(10168, 'S24_1785', 49, 131, 11),
(10168, 'S24_2000', 29, 75, 6),
(10168, 'S24_3949', 27, 73, 18),
(10168, 'S24_4278', 48, 78, 10),
(10168, 'S32_1374', 28, 116, 7),
(10168, 'S32_4289', 31, 74, 12),
(10168, 'S50_1341', 48, 52, 13),
(10168, 'S700_1691', 28, 99, 14),
(10168, 'S700_2466', 31, 111, 16),
(10168, 'S700_2834', 36, 126, 8),
(10168, 'S700_3167', 48, 96, 15),
(10168, 'S700_4002', 39, 83, 17),
(10169, 'S12_1099', 30, 167, 2),
(10169, 'S12_2823', 35, 133, 13),
(10169, 'S12_3990', 36, 64, 3),
(10169, 'S18_3278', 32, 71, 5),
(10169, 'S18_3482', 36, 123, 4),
(10169, 'S18_3782', 38, 68, 8),
(10169, 'S18_4721', 33, 149, 7),
(10169, 'S24_2360', 38, 74, 11),
(10169, 'S24_3371', 34, 50, 1),
(10169, 'S24_4620', 24, 95, 6),
(10169, 'S32_2206', 26, 40, 9),
(10169, 'S32_4485', 34, 115, 12),
(10169, 'S50_4713', 48, 81, 10),
(10170, 'S12_3380', 47, 116, 4),
(10170, 'S12_4675', 41, 107, 3),
(10170, 'S18_1889', 20, 63, 2),
(10170, 'S24_3856', 34, 112, 1),
(10171, 'S18_1129', 35, 129, 2),
(10171, 'S18_1984', 35, 134, 1),
(10171, 'S18_3232', 39, 141, 3),
(10171, 'S24_2972', 36, 35, 4),
(10172, 'S18_1589', 42, 118, 6),
(10172, 'S18_2870', 39, 154, 7),
(10172, 'S18_3685', 48, 114, 8),
(10172, 'S24_1046', 32, 76, 3),
(10172, 'S24_1628', 34, 43, 5),
(10172, 'S24_2766', 22, 75, 1),
(10172, 'S24_3191', 24, 81, 2),
(10172, 'S24_3432', 22, 99, 4),
(10173, 'S18_1342', 43, 117, 6),
(10173, 'S18_1367', 48, 44, 5),
(10173, 'S18_1749', 24, 146, 13),
(10173, 'S18_2248', 26, 58, 12),
(10173, 'S18_2325', 31, 145, 10),
(10173, 'S18_2795', 22, 157, 7),
(10173, 'S18_2957', 28, 54, 2),
(10173, 'S18_3136', 31, 89, 1),
(10173, 'S18_3320', 29, 95, 4),
(10173, 'S18_4409', 21, 75, 14),
(10173, 'S18_4933', 39, 72, 15),
(10173, 'S24_1937', 31, 32, 9),
(10173, 'S24_2022', 27, 41, 8),
(10173, 'S24_2887', 23, 119, 16),
(10173, 'S24_3969', 35, 33, 11),
(10173, 'S24_4258', 22, 117, 3),
(10174, 'S10_1949', 34, 236, 4),
(10174, 'S12_1666', 43, 159, 1),
(10174, 'S18_1097', 48, 93, 3),
(10174, 'S18_2949', 46, 122, 5),
(10174, 'S18_4668', 49, 45, 2),
(10175, 'S10_4962', 33, 163, 9),
(10175, 'S12_4473', 26, 136, 1),
(10175, 'S18_2319', 48, 123, 4),
(10175, 'S18_2432', 41, 69, 7),
(10175, 'S18_3232', 29, 152, 5),
(10175, 'S18_4600', 47, 109, 10),
(10175, 'S24_2300', 28, 106, 6),
(10175, 'S24_2840', 37, 31, 2),
(10175, 'S32_1268', 22, 111, 8),
(10175, 'S32_2509', 50, 63, 3),
(10175, 'S32_3522', 29, 75, 12),
(10175, 'S700_2824', 42, 86, 11),
(10176, 'S12_1108', 33, 227, 2),
(10176, 'S12_3148', 47, 178, 3),
(10176, 'S12_3891', 50, 157, 1),
(10176, 'S18_2238', 20, 183, 10),
(10176, 'S18_4027', 36, 154, 5),
(10176, 'S24_1444', 27, 69, 8),
(10176, 'S24_4048', 29, 101, 7),
(10176, 'S32_3207', 22, 64, 6),
(10176, 'S50_1392', 23, 135, 9),
(10176, 'S50_1514', 38, 64, 4),
(10177, 'S18_3140', 23, 160, 9),
(10177, 'S18_3259', 29, 106, 11),
(10177, 'S18_4522', 35, 75, 8),
(10177, 'S24_2011', 50, 122, 7),
(10177, 'S24_3151', 45, 73, 2),
(10177, 'S700_1138', 24, 76, 3),
(10177, 'S700_1938', 31, 88, 10),
(10177, 'S700_2610', 32, 77, 1),
(10177, 'S700_3505', 44, 92, 4),
(10177, 'S700_3962', 24, 105, 5),
(10177, 'S72_3212', 40, 50, 6),
(10178, 'S10_4757', 24, 146, 12),
(10178, 'S18_1662', 42, 155, 4),
(10178, 'S18_3029', 41, 82, 10),
(10178, 'S18_3856', 48, 112, 9),
(10178, 'S24_2841', 34, 81, 5),
(10178, 'S24_3420', 27, 74, 6),
(10178, 'S24_3816', 21, 72, 11),
(10178, 'S24_3949', 30, 72, 3),
(10178, 'S700_2047', 34, 97, 8),
(10178, 'S700_2466', 22, 88, 1),
(10178, 'S700_4002', 45, 76, 2),
(10178, 'S72_1253', 45, 51, 7),
(10179, 'S18_2581', 24, 79, 3),
(10179, 'S24_1785', 47, 125, 5),
(10179, 'S24_4278', 27, 85, 4),
(10179, 'S32_1374', 45, 120, 1),
(10179, 'S32_4289', 24, 72, 6),
(10179, 'S50_1341', 34, 43, 7),
(10179, 'S700_1691', 23, 108, 8),
(10179, 'S700_2834', 25, 106, 2);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10179, 'S700_3167', 39, 69, 9),
(10180, 'S10_1678', 29, 86, 9),
(10180, 'S10_2016', 42, 112, 12),
(10180, 'S10_4698', 41, 217, 11),
(10180, 'S12_2823', 40, 169, 8),
(10180, 'S18_2625', 25, 64, 13),
(10180, 'S18_3782', 21, 50, 3),
(10180, 'S18_4721', 44, 126, 2),
(10180, 'S24_1578', 48, 112, 10),
(10180, 'S24_2000', 28, 69, 14),
(10180, 'S24_2360', 35, 72, 6),
(10180, 'S24_4620', 28, 71, 1),
(10180, 'S32_2206', 34, 45, 4),
(10180, 'S32_4485', 22, 114, 7),
(10180, 'S50_4713', 21, 94, 5),
(10181, 'S12_1099', 27, 200, 14),
(10181, 'S12_3380', 28, 102, 12),
(10181, 'S12_3990', 20, 81, 15),
(10181, 'S12_4675', 36, 124, 11),
(10181, 'S18_1129', 44, 123, 6),
(10181, 'S18_1589', 42, 129, 2),
(10181, 'S18_1889', 22, 74, 10),
(10181, 'S18_1984', 21, 156, 5),
(10181, 'S18_2870', 27, 144, 3),
(10181, 'S18_3232', 45, 141, 7),
(10181, 'S18_3278', 30, 83, 17),
(10181, 'S18_3482', 22, 154, 16),
(10181, 'S18_3685', 39, 148, 4),
(10181, 'S24_1628', 34, 54, 1),
(10181, 'S24_2972', 37, 43, 8),
(10181, 'S24_3371', 23, 66, 13),
(10181, 'S24_3856', 25, 154, 9),
(10182, 'S18_1342', 25, 87, 3),
(10182, 'S18_1367', 32, 54, 2),
(10182, 'S18_1749', 44, 172, 10),
(10182, 'S18_2248', 38, 61, 9),
(10182, 'S18_2325', 20, 111, 7),
(10182, 'S18_2795', 21, 145, 4),
(10182, 'S18_3320', 33, 86, 1),
(10182, 'S18_4409', 36, 110, 11),
(10182, 'S18_4933', 44, 70, 12),
(10182, 'S24_1046', 47, 74, 16),
(10182, 'S24_1937', 39, 37, 6),
(10182, 'S24_2022', 31, 37, 5),
(10182, 'S24_2766', 36, 74, 14),
(10182, 'S24_2887', 20, 120, 13),
(10182, 'S24_3191', 33, 94, 15),
(10182, 'S24_3432', 49, 127, 17),
(10182, 'S24_3969', 23, 42, 8),
(10183, 'S10_1949', 23, 234, 8),
(10183, 'S10_4962', 28, 123, 1),
(10183, 'S12_1666', 41, 150, 5),
(10183, 'S18_1097', 21, 97, 7),
(10183, 'S18_2949', 37, 89, 9),
(10183, 'S18_2957', 39, 68, 11),
(10183, 'S18_3136', 22, 113, 10),
(10183, 'S18_4600', 21, 116, 2),
(10183, 'S18_4668', 40, 49, 6),
(10183, 'S24_4258', 47, 107, 12),
(10183, 'S32_3522', 49, 65, 4),
(10183, 'S700_2824', 23, 87, 3),
(10184, 'S12_4473', 37, 122, 6),
(10184, 'S18_2238', 46, 160, 5),
(10184, 'S18_2319', 46, 130, 9),
(10184, 'S18_2432', 44, 60, 12),
(10184, 'S18_3232', 28, 157, 10),
(10184, 'S24_1444', 31, 60, 3),
(10184, 'S24_2300', 24, 146, 11),
(10184, 'S24_2840', 42, 32, 7),
(10184, 'S24_4048', 49, 118, 2),
(10184, 'S32_1268', 46, 100, 13),
(10184, 'S32_2509', 33, 63, 8),
(10184, 'S32_3207', 48, 51, 1),
(10184, 'S50_1392', 45, 110, 4),
(10185, 'S12_1108', 21, 185, 13),
(10185, 'S12_3148', 33, 122, 14),
(10185, 'S12_3891', 43, 183, 12),
(10185, 'S18_3140', 28, 123, 9),
(10185, 'S18_3259', 49, 81, 11),
(10185, 'S18_4027', 39, 131, 16),
(10185, 'S18_4522', 47, 77, 8),
(10185, 'S24_2011', 30, 106, 7),
(10185, 'S24_3151', 33, 74, 2),
(10185, 'S50_1514', 20, 49, 15),
(10185, 'S700_1138', 21, 54, 3),
(10185, 'S700_1938', 30, 94, 10),
(10185, 'S700_2610', 39, 58, 1),
(10185, 'S700_3505', 37, 105, 4),
(10185, 'S700_3962', 22, 79, 5),
(10185, 'S72_3212', 28, 64, 6),
(10186, 'S10_4757', 26, 148, 9),
(10186, 'S18_1662', 32, 188, 1),
(10186, 'S18_3029', 32, 89, 7),
(10186, 'S18_3856', 46, 107, 6),
(10186, 'S24_2841', 22, 69, 2),
(10186, 'S24_3420', 21, 69, 3),
(10186, 'S24_3816', 36, 86, 8),
(10186, 'S700_2047', 24, 100, 5),
(10186, 'S72_1253', 28, 52, 4),
(10187, 'S18_2581', 45, 94, 1),
(10187, 'S24_1785', 46, 95, 3),
(10187, 'S24_3949', 43, 58, 10),
(10187, 'S24_4278', 33, 59, 2),
(10187, 'S32_4289', 31, 61, 4),
(10187, 'S50_1341', 41, 39, 5),
(10187, 'S700_1691', 34, 92, 6),
(10187, 'S700_2466', 44, 106, 8),
(10187, 'S700_3167', 34, 88, 7),
(10187, 'S700_4002', 44, 72, 9),
(10188, 'S10_1678', 48, 115, 1),
(10188, 'S10_2016', 38, 96, 4),
(10188, 'S10_4698', 45, 194, 3),
(10188, 'S18_2625', 32, 65, 5),
(10188, 'S24_1578', 25, 101, 2),
(10188, 'S24_2000', 40, 91, 6),
(10188, 'S32_1374', 44, 99, 7),
(10188, 'S700_2834', 29, 136, 8),
(10189, 'S12_2823', 28, 161, 1),
(10190, 'S24_2360', 42, 76, 3),
(10190, 'S32_2206', 46, 33, 1),
(10190, 'S32_4485', 42, 86, 4),
(10190, 'S50_4713', 40, 67, 2);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10191, 'S12_1099', 21, 183, 3),
(10191, 'S12_3380', 40, 140, 1),
(10191, 'S12_3990', 30, 65, 4),
(10191, 'S18_3278', 36, 95, 6),
(10191, 'S18_3482', 23, 148, 5),
(10191, 'S18_3782', 43, 73, 9),
(10191, 'S18_4721', 32, 132, 8),
(10191, 'S24_3371', 48, 60, 2),
(10191, 'S24_4620', 44, 66, 7),
(10192, 'S12_4675', 27, 131, 16),
(10192, 'S18_1129', 22, 150, 11),
(10192, 'S18_1589', 29, 147, 7),
(10192, 'S18_1889', 45, 91, 15),
(10192, 'S18_1984', 47, 158, 10),
(10192, 'S18_2870', 38, 131, 8),
(10192, 'S18_3232', 26, 151, 12),
(10192, 'S18_3685', 45, 119, 9),
(10192, 'S24_1046', 37, 70, 4),
(10192, 'S24_1628', 47, 54, 6),
(10192, 'S24_2766', 46, 84, 2),
(10192, 'S24_2887', 23, 133, 1),
(10192, 'S24_2972', 30, 31, 13),
(10192, 'S24_3191', 32, 73, 3),
(10192, 'S24_3432', 46, 121, 5),
(10192, 'S24_3856', 45, 140, 14),
(10193, 'S18_1342', 28, 111, 7),
(10193, 'S18_1367', 46, 53, 6),
(10193, 'S18_1749', 21, 150, 14),
(10193, 'S18_2248', 42, 59, 13),
(10193, 'S18_2325', 44, 106, 11),
(10193, 'S18_2795', 22, 167, 8),
(10193, 'S18_2949', 28, 93, 1),
(10193, 'S18_2957', 24, 52, 3),
(10193, 'S18_3136', 23, 120, 2),
(10193, 'S18_3320', 32, 79, 5),
(10193, 'S18_4409', 24, 98, 15),
(10193, 'S18_4933', 25, 76, 16),
(10193, 'S24_1937', 26, 29, 10),
(10193, 'S24_2022', 20, 51, 9),
(10193, 'S24_3969', 22, 41, 12),
(10193, 'S24_4258', 20, 114, 4),
(10194, 'S10_1949', 42, 174, 11),
(10194, 'S10_4962', 26, 164, 4),
(10194, 'S12_1666', 38, 130, 8),
(10194, 'S18_1097', 21, 93, 10),
(10194, 'S18_2432', 45, 70, 2),
(10194, 'S18_4600', 32, 133, 5),
(10194, 'S18_4668', 41, 45, 9),
(10194, 'S24_2300', 49, 118, 1),
(10194, 'S32_1268', 37, 97, 3),
(10194, 'S32_3522', 39, 55, 7),
(10194, 'S700_2824', 26, 89, 6),
(10195, 'S12_4473', 49, 132, 6),
(10195, 'S18_2238', 27, 190, 5),
(10195, 'S18_2319', 35, 103, 9),
(10195, 'S18_3232', 50, 152, 10),
(10195, 'S24_1444', 44, 66, 3),
(10195, 'S24_2840', 32, 28, 7),
(10195, 'S24_4048', 34, 109, 2),
(10195, 'S32_2509', 32, 43, 8),
(10195, 'S32_3207', 33, 55, 1),
(10195, 'S50_1392', 49, 105, 4),
(10196, 'S12_1108', 47, 189, 5),
(10196, 'S12_3148', 24, 159, 6),
(10196, 'S12_3891', 38, 190, 4),
(10196, 'S18_3140', 49, 141, 1),
(10196, 'S18_3259', 35, 102, 3),
(10196, 'S18_4027', 27, 168, 8),
(10196, 'S50_1514', 46, 62, 7),
(10196, 'S700_1938', 50, 94, 2),
(10197, 'S10_4757', 45, 118, 6),
(10197, 'S18_3029', 46, 88, 4),
(10197, 'S18_3856', 22, 115, 3),
(10197, 'S18_4522', 50, 102, 14),
(10197, 'S24_2011', 41, 111, 13),
(10197, 'S24_3151', 47, 83, 8),
(10197, 'S24_3816', 22, 86, 5),
(10197, 'S700_1138', 23, 65, 9),
(10197, 'S700_2047', 24, 91, 2),
(10197, 'S700_2610', 50, 79, 7),
(10197, 'S700_3505', 27, 92, 10),
(10197, 'S700_3962', 35, 93, 11),
(10197, 'S72_1253', 29, 42, 1),
(10197, 'S72_3212', 42, 50, 12),
(10198, 'S18_1662', 42, 178, 4),
(10198, 'S24_2841', 48, 68, 5),
(10198, 'S24_3420', 27, 72, 6),
(10198, 'S24_3949', 43, 66, 3),
(10198, 'S700_2466', 42, 114, 1),
(10198, 'S700_4002', 40, 64, 2),
(10199, 'S50_1341', 29, 38, 1),
(10199, 'S700_1691', 48, 83, 2),
(10199, 'S700_3167', 38, 82, 3),
(10200, 'S18_2581', 28, 93, 3),
(10200, 'S24_1785', 33, 98, 5),
(10200, 'S24_4278', 39, 72, 4),
(10200, 'S32_1374', 35, 110, 1),
(10200, 'S32_4289', 27, 67, 6),
(10200, 'S700_2834', 39, 102, 2),
(10201, 'S10_1678', 22, 99, 2),
(10201, 'S10_2016', 24, 126, 5),
(10201, 'S10_4698', 49, 165, 4),
(10201, 'S12_2823', 25, 161, 1),
(10201, 'S18_2625', 30, 65, 6),
(10201, 'S24_1578', 39, 112, 3),
(10201, 'S24_2000', 25, 74, 7),
(10202, 'S18_3782', 30, 55, 3),
(10202, 'S18_4721', 43, 137, 2),
(10202, 'S24_2360', 50, 69, 6),
(10202, 'S24_4620', 50, 87, 1),
(10202, 'S32_2206', 27, 44, 4),
(10202, 'S32_4485', 31, 102, 7),
(10202, 'S50_4713', 40, 90, 5),
(10203, 'S12_1099', 20, 197, 8),
(10203, 'S12_3380', 20, 113, 6),
(10203, 'S12_3990', 44, 83, 9),
(10203, 'S12_4675', 47, 111, 5),
(10203, 'S18_1889', 45, 85, 4),
(10203, 'S18_3232', 48, 173, 1),
(10203, 'S18_3278', 33, 86, 11),
(10203, 'S18_3482', 32, 160, 10),
(10203, 'S24_2972', 21, 37, 2);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10203, 'S24_3371', 34, 65, 7),
(10203, 'S24_3856', 47, 149, 3),
(10204, 'S18_1129', 42, 147, 17),
(10204, 'S18_1589', 40, 101, 13),
(10204, 'S18_1749', 33, 179, 4),
(10204, 'S18_1984', 38, 169, 16),
(10204, 'S18_2248', 23, 71, 3),
(10204, 'S18_2325', 26, 123, 1),
(10204, 'S18_2870', 27, 154, 14),
(10204, 'S18_3685', 35, 164, 15),
(10204, 'S18_4409', 29, 86, 5),
(10204, 'S18_4933', 45, 76, 6),
(10204, 'S24_1046', 20, 62, 10),
(10204, 'S24_1628', 45, 50, 12),
(10204, 'S24_2766', 47, 96, 8),
(10204, 'S24_2887', 42, 101, 7),
(10204, 'S24_3191', 40, 80, 9),
(10204, 'S24_3432', 48, 91, 11),
(10204, 'S24_3969', 39, 33, 2),
(10205, 'S18_1342', 36, 104, 2),
(10205, 'S18_1367', 48, 64, 1),
(10205, 'S18_2795', 40, 187, 3),
(10205, 'S24_1937', 32, 37, 5),
(10205, 'S24_2022', 24, 38, 4),
(10206, 'S10_1949', 47, 193, 6),
(10206, 'S12_1666', 28, 145, 3),
(10206, 'S18_1097', 34, 117, 5),
(10206, 'S18_2949', 37, 90, 7),
(10206, 'S18_2957', 28, 67, 9),
(10206, 'S18_3136', 30, 119, 8),
(10206, 'S18_3320', 28, 87, 11),
(10206, 'S18_4668', 21, 53, 4),
(10206, 'S24_4258', 33, 97, 10),
(10206, 'S32_3522', 36, 59, 2),
(10206, 'S700_2824', 33, 117, 1),
(10207, 'S10_4962', 31, 131, 15),
(10207, 'S12_4473', 34, 100, 7),
(10207, 'S18_2238', 44, 160, 6),
(10207, 'S18_2319', 43, 134, 10),
(10207, 'S18_2432', 37, 70, 13),
(10207, 'S18_3232', 25, 157, 11),
(10207, 'S18_4027', 40, 154, 1),
(10207, 'S18_4600', 47, 142, 16),
(10207, 'S24_1444', 49, 47, 4),
(10207, 'S24_2300', 46, 148, 12),
(10207, 'S24_2840', 42, 30, 8),
(10207, 'S24_4048', 28, 106, 3),
(10207, 'S32_1268', 49, 81, 14),
(10207, 'S32_2509', 27, 60, 9),
(10207, 'S32_3207', 45, 57, 2),
(10207, 'S50_1392', 28, 95, 5),
(10208, 'S12_1108', 46, 187, 13),
(10208, 'S12_3148', 26, 121, 14),
(10208, 'S12_3891', 20, 156, 12),
(10208, 'S18_3140', 24, 109, 9),
(10208, 'S18_3259', 48, 117, 11),
(10208, 'S18_4522', 45, 88, 8),
(10208, 'S24_2011', 35, 123, 7),
(10208, 'S24_3151', 20, 89, 2),
(10208, 'S50_1514', 30, 66, 15),
(10208, 'S700_1138', 38, 75, 3),
(10208, 'S700_1938', 40, 81, 10),
(10208, 'S700_2610', 46, 74, 1),
(10208, 'S700_3505', 37, 120, 4),
(10208, 'S700_3962', 33, 85, 5),
(10208, 'S72_3212', 42, 64, 6),
(10209, 'S10_4757', 39, 133, 8),
(10209, 'S18_3029', 28, 101, 6),
(10209, 'S18_3856', 20, 125, 5),
(10209, 'S24_2841', 43, 82, 1),
(10209, 'S24_3420', 36, 78, 2),
(10209, 'S24_3816', 22, 90, 7),
(10209, 'S700_2047', 33, 89, 4),
(10209, 'S72_1253', 48, 45, 3),
(10210, 'S10_2016', 23, 131, 2),
(10210, 'S10_4698', 34, 180, 1),
(10210, 'S18_1662', 31, 185, 17),
(10210, 'S18_2581', 50, 77, 7),
(10210, 'S18_2625', 40, 50, 3),
(10210, 'S24_1785', 27, 98, 9),
(10210, 'S24_2000', 30, 62, 4),
(10210, 'S24_3949', 29, 70, 16),
(10210, 'S24_4278', 40, 71, 8),
(10210, 'S32_1374', 46, 80, 5),
(10210, 'S32_4289', 39, 59, 10),
(10210, 'S50_1341', 43, 41, 11),
(10210, 'S700_1691', 21, 79, 12),
(10210, 'S700_2466', 26, 100, 14),
(10210, 'S700_2834', 25, 113, 6),
(10210, 'S700_3167', 31, 86, 13),
(10210, 'S700_4002', 42, 70, 15),
(10211, 'S10_1678', 41, 115, 14),
(10211, 'S12_1099', 41, 183, 2),
(10211, 'S12_2823', 36, 133, 13),
(10211, 'S12_3990', 28, 93, 3),
(10211, 'S18_3278', 35, 78, 5),
(10211, 'S18_3482', 28, 134, 4),
(10211, 'S18_3782', 46, 54, 8),
(10211, 'S18_4721', 41, 138, 7),
(10211, 'S24_1578', 25, 90, 15),
(10211, 'S24_2360', 21, 64, 11),
(10211, 'S24_3371', 48, 49, 1),
(10211, 'S24_4620', 22, 92, 6),
(10211, 'S32_2206', 41, 42, 9),
(10211, 'S32_4485', 37, 109, 12),
(10211, 'S50_4713', 40, 81, 10),
(10212, 'S12_3380', 39, 127, 16),
(10212, 'S12_4675', 33, 127, 15),
(10212, 'S18_1129', 29, 144, 10),
(10212, 'S18_1589', 38, 118, 6),
(10212, 'S18_1889', 20, 67, 14),
(10212, 'S18_1984', 41, 118, 9),
(10212, 'S18_2870', 40, 123, 7),
(10212, 'S18_3232', 40, 139, 11),
(10212, 'S18_3685', 45, 141, 8),
(10212, 'S24_1046', 41, 82, 3),
(10212, 'S24_1628', 45, 53, 5),
(10212, 'S24_2766', 45, 88, 1),
(10212, 'S24_2972', 34, 43, 12),
(10212, 'S24_3191', 27, 80, 2),
(10212, 'S24_3432', 46, 88, 4),
(10212, 'S24_3856', 49, 142, 13);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10213, 'S18_4409', 38, 95, 1),
(10213, 'S18_4933', 25, 83, 2),
(10213, 'S24_2887', 27, 103, 3),
(10214, 'S18_1749', 30, 199, 7),
(10214, 'S18_2248', 21, 63, 6),
(10214, 'S18_2325', 27, 133, 4),
(10214, 'S18_2795', 50, 191, 1),
(10214, 'S24_1937', 20, 34, 3),
(10214, 'S24_2022', 49, 48, 2),
(10214, 'S24_3969', 44, 35, 5),
(10215, 'S10_1949', 35, 174, 3),
(10215, 'S18_1097', 46, 112, 2),
(10215, 'S18_1342', 27, 89, 10),
(10215, 'S18_1367', 33, 43, 9),
(10215, 'S18_2949', 49, 112, 4),
(10215, 'S18_2957', 31, 59, 6),
(10215, 'S18_3136', 49, 108, 5),
(10215, 'S18_3320', 41, 111, 8),
(10215, 'S18_4668', 46, 45, 1),
(10215, 'S24_4258', 39, 91, 7),
(10216, 'S12_1666', 43, 134, 1),
(10217, 'S10_4962', 48, 146, 4),
(10217, 'S18_2432', 35, 61, 2),
(10217, 'S18_4600', 38, 119, 5),
(10217, 'S24_2300', 28, 112, 1),
(10217, 'S32_1268', 21, 107, 3),
(10217, 'S32_3522', 39, 62, 7),
(10217, 'S700_2824', 31, 88, 6),
(10218, 'S18_2319', 22, 122, 1),
(10218, 'S18_3232', 34, 135, 2),
(10219, 'S12_4473', 48, 102, 2),
(10219, 'S18_2238', 43, 196, 1),
(10219, 'S24_2840', 21, 40, 3),
(10219, 'S32_2509', 35, 55, 4),
(10220, 'S12_1108', 32, 224, 2),
(10220, 'S12_3148', 30, 157, 3),
(10220, 'S12_3891', 27, 187, 1),
(10220, 'S18_4027', 50, 165, 5),
(10220, 'S24_1444', 26, 56, 8),
(10220, 'S24_4048', 37, 136, 7),
(10220, 'S32_3207', 20, 53, 6),
(10220, 'S50_1392', 37, 108, 9),
(10220, 'S50_1514', 30, 69, 4),
(10221, 'S18_3140', 33, 134, 3),
(10221, 'S18_3259', 23, 81, 5),
(10221, 'S18_4522', 39, 90, 2),
(10221, 'S24_2011', 49, 139, 1),
(10221, 'S700_1938', 23, 97, 4),
(10222, 'S10_4757', 49, 122, 12),
(10222, 'S18_1662', 49, 142, 4),
(10222, 'S18_3029', 49, 95, 10),
(10222, 'S18_3856', 45, 86, 9),
(10222, 'S24_2841', 32, 82, 5),
(10222, 'S24_3151', 47, 71, 14),
(10222, 'S24_3420', 43, 70, 6),
(10222, 'S24_3816', 46, 81, 11),
(10222, 'S24_3949', 48, 57, 3),
(10222, 'S700_1138', 31, 63, 15),
(10222, 'S700_2047', 26, 102, 8),
(10222, 'S700_2466', 37, 88, 1),
(10222, 'S700_2610', 36, 81, 13),
(10222, 'S700_3505', 38, 110, 16),
(10222, 'S700_3962', 31, 95, 17),
(10222, 'S700_4002', 43, 74, 2),
(10222, 'S72_1253', 31, 46, 7),
(10222, 'S72_3212', 36, 63, 18),
(10223, 'S10_1678', 37, 107, 1),
(10223, 'S10_2016', 47, 115, 4),
(10223, 'S10_4698', 49, 199, 3),
(10223, 'S18_2581', 47, 101, 9),
(10223, 'S18_2625', 28, 61, 5),
(10223, 'S24_1578', 32, 91, 2),
(10223, 'S24_1785', 34, 106, 11),
(10223, 'S24_2000', 38, 69, 6),
(10223, 'S24_4278', 23, 75, 10),
(10223, 'S32_1374', 21, 118, 7),
(10223, 'S32_4289', 20, 66, 12),
(10223, 'S50_1341', 41, 46, 13),
(10223, 'S700_1691', 25, 101, 14),
(10223, 'S700_2834', 29, 110, 8),
(10223, 'S700_3167', 26, 67, 15),
(10224, 'S12_2823', 43, 142, 6),
(10224, 'S18_3782', 38, 58, 1),
(10224, 'S24_2360', 37, 80, 4),
(10224, 'S32_2206', 43, 39, 2),
(10224, 'S32_4485', 30, 111, 5),
(10224, 'S50_4713', 50, 77, 3),
(10225, 'S12_1099', 27, 167, 9),
(10225, 'S12_3380', 25, 100, 7),
(10225, 'S12_3990', 37, 77, 10),
(10225, 'S12_4675', 21, 128, 6),
(10225, 'S18_1129', 32, 142, 1),
(10225, 'S18_1889', 47, 65, 5),
(10225, 'S18_3232', 43, 149, 2),
(10225, 'S18_3278', 37, 96, 12),
(10225, 'S18_3482', 27, 169, 11),
(10225, 'S18_4721', 35, 150, 14),
(10225, 'S24_2972', 42, 37, 3),
(10225, 'S24_3371', 24, 50, 8),
(10225, 'S24_3856', 40, 114, 4),
(10225, 'S24_4620', 46, 70, 13),
(10226, 'S18_1589', 38, 110, 4),
(10226, 'S18_1984', 24, 162, 7),
(10226, 'S18_2870', 24, 135, 5),
(10226, 'S18_3685', 46, 160, 6),
(10226, 'S24_1046', 21, 60, 1),
(10226, 'S24_1628', 36, 43, 3),
(10226, 'S24_3432', 48, 92, 2),
(10227, 'S18_1342', 25, 118, 3),
(10227, 'S18_1367', 31, 49, 2),
(10227, 'S18_1749', 26, 143, 10),
(10227, 'S18_2248', 28, 51, 9),
(10227, 'S18_2325', 46, 153, 7),
(10227, 'S18_2795', 29, 192, 4),
(10227, 'S18_3320', 33, 111, 1),
(10227, 'S18_4409', 34, 105, 11),
(10227, 'S18_4933', 37, 58, 12),
(10227, 'S24_1937', 42, 29, 6),
(10227, 'S24_2022', 24, 48, 5),
(10227, 'S24_2766', 47, 88, 14),
(10227, 'S24_2887', 33, 132, 13),
(10227, 'S24_3191', 40, 80, 15);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10227, 'S24_3969', 27, 44, 8),
(10228, 'S10_1949', 29, 223, 2),
(10228, 'S18_1097', 32, 105, 1),
(10228, 'S18_2949', 24, 104, 3),
(10228, 'S18_2957', 45, 64, 5),
(10228, 'S18_3136', 31, 103, 4),
(10228, 'S24_4258', 33, 103, 6),
(10229, 'S10_4962', 50, 129, 9),
(10229, 'S12_1666', 25, 138, 13),
(10229, 'S12_4473', 36, 126, 1),
(10229, 'S18_2319', 26, 145, 4),
(10229, 'S18_2432', 28, 60, 7),
(10229, 'S18_3232', 22, 190, 5),
(10229, 'S18_4600', 41, 115, 10),
(10229, 'S18_4668', 39, 40, 14),
(10229, 'S24_2300', 48, 119, 6),
(10229, 'S24_2840', 33, 33, 2),
(10229, 'S32_1268', 25, 112, 8),
(10229, 'S32_2509', 23, 54, 3),
(10229, 'S32_3522', 30, 73, 12),
(10229, 'S700_2824', 50, 112, 11),
(10230, 'S12_3148', 43, 163, 1),
(10230, 'S18_2238', 49, 149, 8),
(10230, 'S18_4027', 42, 172, 3),
(10230, 'S24_1444', 36, 54, 6),
(10230, 'S24_4048', 45, 105, 5),
(10230, 'S32_3207', 46, 61, 4),
(10230, 'S50_1392', 34, 117, 7),
(10230, 'S50_1514', 43, 52, 2),
(10231, 'S12_1108', 42, 199, 2),
(10231, 'S12_3891', 49, 142, 1),
(10232, 'S18_3140', 22, 164, 6),
(10232, 'S18_3259', 48, 96, 8),
(10232, 'S18_4522', 23, 90, 5),
(10232, 'S24_2011', 46, 123, 4),
(10232, 'S700_1938', 26, 88, 7),
(10232, 'S700_3505', 48, 96, 1),
(10232, 'S700_3962', 35, 82, 2),
(10232, 'S72_3212', 24, 50, 3),
(10233, 'S24_3151', 40, 95, 2),
(10233, 'S700_1138', 36, 71, 3),
(10233, 'S700_2610', 29, 82, 1),
(10234, 'S10_4757', 48, 151, 9),
(10234, 'S18_1662', 50, 189, 1),
(10234, 'S18_3029', 48, 75, 7),
(10234, 'S18_3856', 39, 126, 6),
(10234, 'S24_2841', 44, 62, 2),
(10234, 'S24_3420', 25, 57, 3),
(10234, 'S24_3816', 31, 73, 8),
(10234, 'S700_2047', 29, 88, 5),
(10234, 'S72_1253', 40, 56, 4),
(10235, 'S18_2581', 24, 76, 3),
(10235, 'S24_1785', 23, 96, 5),
(10235, 'S24_3949', 33, 60, 12),
(10235, 'S24_4278', 40, 81, 4),
(10235, 'S32_1374', 41, 102, 1),
(10235, 'S32_4289', 34, 78, 6),
(10235, 'S50_1341', 41, 35, 7),
(10235, 'S700_1691', 25, 103, 8),
(10235, 'S700_2466', 38, 89, 10),
(10235, 'S700_2834', 25, 96, 2),
(10235, 'S700_3167', 32, 92, 9),
(10235, 'S700_4002', 34, 73, 11),
(10236, 'S10_2016', 22, 130, 1),
(10236, 'S18_2625', 23, 56, 2),
(10236, 'S24_2000', 36, 88, 3),
(10237, 'S10_1678', 23, 101, 7),
(10237, 'S10_4698', 39, 180, 9),
(10237, 'S12_2823', 32, 131, 6),
(10237, 'S18_3782', 26, 52, 1),
(10237, 'S24_1578', 20, 115, 8),
(10237, 'S24_2360', 26, 80, 4),
(10237, 'S32_2206', 26, 40, 2),
(10237, 'S32_4485', 27, 115, 5),
(10237, 'S50_4713', 20, 68, 3),
(10238, 'S12_1099', 28, 206, 3),
(10238, 'S12_3380', 29, 109, 1),
(10238, 'S12_3990', 20, 74, 4),
(10238, 'S18_3278', 41, 73, 6),
(10238, 'S18_3482', 49, 134, 5),
(10238, 'S18_4721', 44, 144, 8),
(10238, 'S24_3371', 47, 62, 2),
(10238, 'S24_4620', 22, 94, 7),
(10239, 'S12_4675', 21, 93, 5),
(10239, 'S18_1889', 46, 74, 4),
(10239, 'S18_3232', 47, 151, 1),
(10239, 'S24_2972', 20, 45, 2),
(10239, 'S24_3856', 29, 154, 3),
(10240, 'S18_1129', 41, 137, 3),
(10240, 'S18_1984', 37, 149, 2),
(10240, 'S18_3685', 37, 161, 1),
(10241, 'S18_1589', 21, 119, 11),
(10241, 'S18_1749', 41, 185, 2),
(10241, 'S18_2248', 33, 73, 1),
(10241, 'S18_2870', 44, 156, 12),
(10241, 'S18_4409', 42, 90, 3),
(10241, 'S18_4933', 30, 67, 4),
(10241, 'S24_1046', 22, 76, 8),
(10241, 'S24_1628', 21, 40, 10),
(10241, 'S24_2766', 47, 95, 6),
(10241, 'S24_2887', 28, 99, 5),
(10241, 'S24_3191', 26, 81, 7),
(10241, 'S24_3432', 27, 87, 9),
(10242, 'S24_3969', 46, 37, 1),
(10243, 'S18_2325', 47, 131, 2),
(10243, 'S24_1937', 33, 30, 1),
(10244, 'S18_1342', 40, 117, 7),
(10244, 'S18_1367', 20, 58, 6),
(10244, 'S18_2795', 43, 138, 8),
(10244, 'S18_2949', 30, 118, 1),
(10244, 'S18_2957', 24, 58, 3),
(10244, 'S18_3136', 29, 115, 2),
(10244, 'S18_3320', 36, 84, 5),
(10244, 'S24_2022', 39, 45, 9),
(10244, 'S24_4258', 40, 87, 4),
(10245, 'S10_1949', 34, 180, 9),
(10245, 'S10_4962', 28, 164, 2),
(10245, 'S12_1666', 38, 156, 6),
(10245, 'S18_1097', 29, 119, 8),
(10245, 'S18_4600', 21, 114, 3),
(10245, 'S18_4668', 45, 60, 7),
(10245, 'S32_1268', 37, 112, 1),
(10245, 'S32_3522', 44, 69, 5);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10245, 'S700_2824', 44, 105, 4),
(10246, 'S12_4473', 46, 110, 5),
(10246, 'S18_2238', 40, 164, 4),
(10246, 'S18_2319', 22, 98, 8),
(10246, 'S18_2432', 30, 62, 11),
(10246, 'S18_3232', 36, 198, 9),
(10246, 'S24_1444', 44, 53, 2),
(10246, 'S24_2300', 29, 121, 10),
(10246, 'S24_2840', 49, 36, 6),
(10246, 'S24_4048', 46, 137, 1),
(10246, 'S32_2509', 35, 49, 7),
(10246, 'S50_1392', 22, 133, 3),
(10247, 'S12_1108', 44, 241, 2),
(10247, 'S12_3148', 25, 175, 3),
(10247, 'S12_3891', 27, 154, 1),
(10247, 'S18_4027', 48, 141, 5),
(10247, 'S32_3207', 40, 50, 6),
(10247, 'S50_1514', 49, 64, 4),
(10248, 'S10_4757', 20, 146, 3),
(10248, 'S18_3029', 21, 74, 1),
(10248, 'S18_3140', 32, 119, 12),
(10248, 'S18_3259', 42, 121, 14),
(10248, 'S18_4522', 42, 75, 11),
(10248, 'S24_2011', 48, 145, 10),
(10248, 'S24_3151', 30, 102, 5),
(10248, 'S24_3816', 23, 76, 2),
(10248, 'S700_1138', 36, 71, 6),
(10248, 'S700_1938', 40, 104, 13),
(10248, 'S700_2610', 32, 76, 4),
(10248, 'S700_3505', 30, 108, 7),
(10248, 'S700_3962', 35, 90, 8),
(10248, 'S72_3212', 23, 66, 9),
(10249, 'S18_3856', 46, 122, 5),
(10249, 'S24_2841', 20, 68, 1),
(10249, 'S24_3420', 25, 70, 2),
(10249, 'S700_2047', 40, 96, 4),
(10249, 'S72_1253', 32, 58, 3),
(10250, 'S18_1662', 45, 181, 14),
(10250, 'S18_2581', 27, 99, 4),
(10250, 'S24_1785', 31, 89, 6),
(10250, 'S24_2000', 32, 88, 1),
(10250, 'S24_3949', 40, 75, 13),
(10250, 'S24_4278', 37, 75, 5),
(10250, 'S32_1374', 31, 106, 2),
(10250, 'S32_4289', 50, 61, 7),
(10250, 'S50_1341', 36, 52, 8),
(10250, 'S700_1691', 31, 91, 9),
(10250, 'S700_2466', 35, 112, 11),
(10250, 'S700_2834', 44, 138, 3),
(10250, 'S700_3167', 44, 67, 10),
(10250, 'S700_4002', 38, 62, 12),
(10251, 'S10_1678', 28, 114, 2),
(10251, 'S10_2016', 44, 131, 5),
(10251, 'S10_4698', 43, 165, 4),
(10251, 'S12_2823', 46, 164, 1),
(10251, 'S18_2625', 29, 61, 6),
(10251, 'S24_1578', 26, 101, 3),
(10252, 'S18_3278', 20, 76, 2),
(10252, 'S18_3482', 41, 165, 1),
(10252, 'S18_3782', 31, 53, 5),
(10252, 'S18_4721', 26, 137, 4),
(10252, 'S24_2360', 47, 66, 8),
(10252, 'S24_4620', 38, 87, 3),
(10252, 'S32_2206', 36, 48, 6),
(10252, 'S32_4485', 25, 113, 9),
(10252, 'S50_4713', 48, 72, 7),
(10253, 'S12_1099', 24, 163, 13),
(10253, 'S12_3380', 22, 109, 11),
(10253, 'S12_3990', 25, 90, 14),
(10253, 'S12_4675', 41, 120, 10),
(10253, 'S18_1129', 26, 117, 5),
(10253, 'S18_1589', 24, 141, 1),
(10253, 'S18_1889', 23, 84, 9),
(10253, 'S18_1984', 33, 135, 4),
(10253, 'S18_2870', 37, 140, 2),
(10253, 'S18_3232', 40, 169, 6),
(10253, 'S18_3685', 31, 130, 3),
(10253, 'S24_2972', 40, 43, 7),
(10253, 'S24_3371', 24, 53, 12),
(10253, 'S24_3856', 39, 132, 8),
(10254, 'S18_1749', 49, 143, 5),
(10254, 'S18_2248', 36, 64, 4),
(10254, 'S18_2325', 41, 111, 2),
(10254, 'S18_4409', 34, 93, 6),
(10254, 'S18_4933', 30, 58, 7),
(10254, 'S24_1046', 34, 65, 11),
(10254, 'S24_1628', 32, 60, 13),
(10254, 'S24_1937', 38, 27, 1),
(10254, 'S24_2766', 31, 101, 9),
(10254, 'S24_2887', 33, 96, 8),
(10254, 'S24_3191', 42, 97, 10),
(10254, 'S24_3432', 49, 101, 12),
(10254, 'S24_3969', 20, 43, 3),
(10255, 'S18_2795', 24, 155, 1),
(10255, 'S24_2022', 37, 46, 2),
(10256, 'S18_1342', 34, 96, 2),
(10256, 'S18_1367', 29, 52, 1),
(10257, 'S18_2949', 50, 88, 1),
(10257, 'S18_2957', 49, 54, 3),
(10257, 'S18_3136', 37, 85, 2),
(10257, 'S18_3320', 26, 89, 5),
(10257, 'S24_4258', 46, 79, 4),
(10258, 'S10_1949', 32, 240, 6),
(10258, 'S12_1666', 41, 163, 3),
(10258, 'S18_1097', 41, 133, 5),
(10258, 'S18_4668', 21, 60, 4),
(10258, 'S32_3522', 20, 61, 2),
(10258, 'S700_2824', 45, 81, 1),
(10259, 'S10_4962', 26, 155, 12),
(10259, 'S12_4473', 46, 142, 4),
(10259, 'S18_2238', 30, 190, 3),
(10259, 'S18_2319', 34, 99, 7),
(10259, 'S18_2432', 30, 49, 10),
(10259, 'S18_3232', 27, 135, 8),
(10259, 'S18_4600', 41, 114, 13),
(10259, 'S24_1444', 28, 47, 1),
(10259, 'S24_2300', 47, 112, 9),
(10259, 'S24_2840', 31, 33, 5),
(10259, 'S32_1268', 45, 87, 11),
(10259, 'S32_2509', 40, 44, 6),
(10259, 'S50_1392', 29, 105, 2),
(10260, 'S12_1108', 46, 229, 5);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10260, 'S12_3148', 30, 171, 6),
(10260, 'S12_3891', 44, 171, 4),
(10260, 'S18_3140', 32, 131, 1),
(10260, 'S18_3259', 29, 89, 3),
(10260, 'S18_4027', 23, 155, 8),
(10260, 'S24_4048', 23, 103, 10),
(10260, 'S32_3207', 27, 57, 9),
(10260, 'S50_1514', 21, 56, 7),
(10260, 'S700_1938', 33, 86, 2),
(10261, 'S10_4757', 27, 125, 1),
(10261, 'S18_4522', 20, 90, 9),
(10261, 'S24_2011', 36, 125, 8),
(10261, 'S24_3151', 22, 91, 3),
(10261, 'S700_1138', 34, 62, 4),
(10261, 'S700_2610', 44, 69, 2),
(10261, 'S700_3505', 25, 88, 5),
(10261, 'S700_3962', 50, 81, 6),
(10261, 'S72_3212', 29, 51, 7),
(10262, 'S18_1662', 49, 134, 9),
(10262, 'S18_3029', 32, 84, 15),
(10262, 'S18_3856', 34, 121, 14),
(10262, 'S24_1785', 34, 97, 1),
(10262, 'S24_2841', 24, 67, 10),
(10262, 'S24_3420', 46, 70, 11),
(10262, 'S24_3816', 49, 87, 16),
(10262, 'S24_3949', 48, 61, 8),
(10262, 'S32_4289', 40, 79, 2),
(10262, 'S50_1341', 49, 38, 3),
(10262, 'S700_1691', 40, 84, 4),
(10262, 'S700_2047', 44, 94, 13),
(10262, 'S700_2466', 33, 91, 6),
(10262, 'S700_3167', 27, 76, 5),
(10262, 'S700_4002', 35, 71, 7),
(10262, 'S72_1253', 21, 57, 12),
(10263, 'S10_1678', 34, 108, 2),
(10263, 'S10_2016', 40, 112, 5),
(10263, 'S10_4698', 41, 203, 4),
(10263, 'S12_2823', 48, 134, 1),
(10263, 'S18_2581', 33, 86, 10),
(10263, 'S18_2625', 34, 59, 6),
(10263, 'S24_1578', 42, 103, 3),
(10263, 'S24_2000', 37, 62, 7),
(10263, 'S24_4278', 24, 75, 11),
(10263, 'S32_1374', 31, 80, 8),
(10263, 'S700_2834', 47, 116, 9),
(10264, 'S18_3782', 48, 55, 3),
(10264, 'S18_4721', 20, 121, 2),
(10264, 'S24_2360', 37, 65, 6),
(10264, 'S24_4620', 47, 83, 1),
(10264, 'S32_2206', 20, 33, 4),
(10264, 'S32_4485', 34, 98, 7),
(10264, 'S50_4713', 47, 90, 5),
(10265, 'S18_3278', 45, 87, 2),
(10265, 'S18_3482', 49, 172, 1),
(10266, 'S12_1099', 44, 208, 14),
(10266, 'S12_3380', 22, 112, 12),
(10266, 'S12_3990', 35, 77, 15),
(10266, 'S12_4675', 40, 112, 11),
(10266, 'S18_1129', 21, 120, 6),
(10266, 'S18_1589', 36, 144, 2),
(10266, 'S18_1889', 33, 75, 10),
(10266, 'S18_1984', 49, 127, 5),
(10266, 'S18_2870', 20, 141, 3),
(10266, 'S18_3232', 29, 166, 7),
(10266, 'S18_3685', 33, 153, 4),
(10266, 'S24_1628', 28, 48, 1),
(10266, 'S24_2972', 34, 40, 8),
(10266, 'S24_3371', 47, 62, 13),
(10266, 'S24_3856', 24, 122, 9),
(10267, 'S18_4933', 36, 76, 1),
(10267, 'S24_1046', 40, 80, 5),
(10267, 'S24_2766', 38, 87, 3),
(10267, 'S24_2887', 43, 108, 2),
(10267, 'S24_3191', 44, 97, 4),
(10267, 'S24_3432', 43, 119, 6),
(10268, 'S18_1342', 49, 117, 3),
(10268, 'S18_1367', 26, 65, 2),
(10268, 'S18_1749', 34, 162, 10),
(10268, 'S18_2248', 31, 49, 9),
(10268, 'S18_2325', 50, 106, 7),
(10268, 'S18_2795', 35, 152, 4),
(10268, 'S18_3320', 39, 89, 1),
(10268, 'S18_4409', 35, 87, 11),
(10268, 'S24_1937', 33, 39, 6),
(10268, 'S24_2022', 40, 46, 5),
(10268, 'S24_3969', 30, 41, 8),
(10269, 'S18_2957', 32, 63, 1),
(10269, 'S24_4258', 48, 97, 2),
(10270, 'S10_1949', 21, 234, 9),
(10270, 'S10_4962', 32, 134, 2),
(10270, 'S12_1666', 28, 146, 6),
(10270, 'S18_1097', 43, 97, 8),
(10270, 'S18_2949', 31, 96, 10),
(10270, 'S18_3136', 38, 126, 11),
(10270, 'S18_4600', 38, 142, 3),
(10270, 'S18_4668', 44, 58, 7),
(10270, 'S32_1268', 32, 86, 1),
(10270, 'S32_3522', 21, 63, 5),
(10270, 'S700_2824', 46, 88, 4),
(10271, 'S12_4473', 31, 97, 5),
(10271, 'S18_2238', 50, 183, 4),
(10271, 'S18_2319', 50, 102, 8),
(10271, 'S18_2432', 25, 69, 11),
(10271, 'S18_3232', 20, 196, 9),
(10271, 'S24_1444', 45, 65, 2),
(10271, 'S24_2300', 43, 130, 10),
(10271, 'S24_2840', 38, 42, 6),
(10271, 'S24_4048', 22, 140, 1),
(10271, 'S32_2509', 35, 48, 7),
(10271, 'S50_1392', 34, 98, 3),
(10272, 'S12_1108', 35, 166, 2),
(10272, 'S12_3148', 27, 159, 3),
(10272, 'S12_3891', 39, 204, 1),
(10272, 'S18_4027', 25, 149, 5),
(10272, 'S32_3207', 45, 65, 6),
(10272, 'S50_1514', 43, 57, 4),
(10273, 'S10_4757', 30, 117, 4),
(10273, 'S18_3029', 34, 98, 2),
(10273, 'S18_3140', 40, 126, 13),
(10273, 'S18_3259', 47, 116, 15),
(10273, 'S18_3856', 50, 86, 1),
(10273, 'S18_4522', 33, 71, 12);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10273, 'S24_2011', 22, 127, 11),
(10273, 'S24_3151', 27, 104, 6),
(10273, 'S24_3816', 48, 83, 3),
(10273, 'S700_1138', 21, 65, 7),
(10273, 'S700_1938', 21, 102, 14),
(10273, 'S700_2610', 42, 62, 5),
(10273, 'S700_3505', 40, 86, 8),
(10273, 'S700_3962', 26, 114, 9),
(10273, 'S72_3212', 37, 46, 10),
(10274, 'S18_1662', 41, 164, 1),
(10274, 'S24_2841', 40, 65, 2),
(10274, 'S24_3420', 24, 72, 3),
(10274, 'S700_2047', 24, 91, 5),
(10274, 'S72_1253', 32, 59, 4),
(10275, 'S10_1678', 45, 93, 1),
(10275, 'S10_2016', 22, 132, 4),
(10275, 'S10_4698', 36, 192, 3),
(10275, 'S18_2581', 35, 90, 9),
(10275, 'S18_2625', 37, 64, 5),
(10275, 'S24_1578', 21, 103, 2),
(10275, 'S24_1785', 25, 95, 11),
(10275, 'S24_2000', 30, 80, 6),
(10275, 'S24_3949', 41, 82, 18),
(10275, 'S24_4278', 27, 62, 10),
(10275, 'S32_1374', 23, 82, 7),
(10275, 'S32_4289', 28, 64, 12),
(10275, 'S50_1341', 38, 45, 13),
(10275, 'S700_1691', 32, 90, 14),
(10275, 'S700_2466', 39, 115, 16),
(10275, 'S700_2834', 48, 133, 8),
(10275, 'S700_3167', 43, 74, 15),
(10275, 'S700_4002', 31, 73, 17),
(10276, 'S12_1099', 50, 193, 3),
(10276, 'S12_2823', 43, 121, 14),
(10276, 'S12_3380', 47, 116, 1),
(10276, 'S12_3990', 38, 84, 4),
(10276, 'S18_3278', 38, 70, 6),
(10276, 'S18_3482', 30, 131, 5),
(10276, 'S18_3782', 33, 50, 9),
(10276, 'S18_4721', 48, 119, 8),
(10276, 'S24_2360', 46, 75, 12),
(10276, 'S24_3371', 20, 61, 2),
(10276, 'S24_4620', 48, 75, 7),
(10276, 'S32_2206', 27, 37, 10),
(10276, 'S32_4485', 38, 113, 13),
(10276, 'S50_4713', 21, 71, 11),
(10277, 'S12_4675', 28, 112, 1),
(10278, 'S18_1129', 34, 137, 6),
(10278, 'S18_1589', 23, 113, 2),
(10278, 'S18_1889', 29, 91, 10),
(10278, 'S18_1984', 29, 129, 5),
(10278, 'S18_2870', 39, 111, 3),
(10278, 'S18_3232', 42, 152, 7),
(10278, 'S18_3685', 31, 133, 4),
(10278, 'S24_1628', 35, 45, 1),
(10278, 'S24_2972', 31, 39, 8),
(10278, 'S24_3856', 25, 126, 9),
(10279, 'S18_4933', 26, 61, 1),
(10279, 'S24_1046', 32, 75, 5),
(10279, 'S24_2766', 49, 80, 3),
(10279, 'S24_2887', 48, 116, 2),
(10279, 'S24_3191', 33, 71, 4),
(10279, 'S24_3432', 48, 129, 6),
(10280, 'S10_1949', 34, 236, 2),
(10280, 'S18_1097', 24, 117, 1),
(10280, 'S18_1342', 50, 105, 9),
(10280, 'S18_1367', 27, 58, 8),
(10280, 'S18_1749', 26, 141, 16),
(10280, 'S18_2248', 25, 63, 15),
(10280, 'S18_2325', 37, 128, 13),
(10280, 'S18_2795', 22, 203, 10),
(10280, 'S18_2949', 46, 111, 3),
(10280, 'S18_2957', 43, 69, 5),
(10280, 'S18_3136', 29, 104, 4),
(10280, 'S18_3320', 34, 102, 7),
(10280, 'S18_4409', 35, 106, 17),
(10280, 'S24_1937', 20, 29, 12),
(10280, 'S24_2022', 45, 47, 11),
(10280, 'S24_3969', 33, 42, 14),
(10280, 'S24_4258', 21, 79, 6),
(10281, 'S10_4962', 44, 160, 9),
(10281, 'S12_1666', 25, 118, 13),
(10281, 'S12_4473', 41, 128, 1),
(10281, 'S18_2319', 48, 120, 4),
(10281, 'S18_2432', 29, 58, 7),
(10281, 'S18_3232', 25, 168, 5),
(10281, 'S18_4600', 25, 99, 10),
(10281, 'S18_4668', 44, 60, 14),
(10281, 'S24_2300', 25, 111, 6),
(10281, 'S24_2840', 20, 41, 2),
(10281, 'S32_1268', 29, 83, 8),
(10281, 'S32_2509', 31, 55, 3),
(10281, 'S32_3522', 36, 78, 12),
(10281, 'S700_2824', 27, 86, 11),
(10282, 'S12_1108', 41, 172, 5),
(10282, 'S12_3148', 27, 162, 6),
(10282, 'S12_3891', 24, 157, 4),
(10282, 'S18_2238', 23, 141, 13),
(10282, 'S18_3140', 43, 156, 1),
(10282, 'S18_3259', 36, 116, 3),
(10282, 'S18_4027', 31, 151, 8),
(10282, 'S24_1444', 29, 47, 11),
(10282, 'S24_4048', 39, 123, 10),
(10282, 'S32_3207', 36, 60, 9),
(10282, 'S50_1392', 38, 113, 12),
(10282, 'S50_1514', 37, 67, 7),
(10282, 'S700_1938', 43, 87, 2),
(10283, 'S10_4757', 25, 120, 6),
(10283, 'S18_3029', 21, 98, 4),
(10283, 'S18_3856', 46, 126, 3),
(10283, 'S18_4522', 34, 105, 14),
(10283, 'S24_2011', 42, 127, 13),
(10283, 'S24_3151', 34, 93, 8),
(10283, 'S24_3816', 33, 73, 5),
(10283, 'S700_1138', 45, 79, 9),
(10283, 'S700_2047', 20, 94, 2),
(10283, 'S700_2610', 47, 66, 7),
(10283, 'S700_3505', 22, 88, 10),
(10283, 'S700_3962', 38, 89, 11),
(10283, 'S72_1253', 43, 58, 1),
(10283, 'S72_3212', 33, 51, 12),
(10284, 'S18_1662', 45, 128, 11);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10284, 'S18_2581', 31, 72, 1),
(10284, 'S24_1785', 22, 105, 3),
(10284, 'S24_2841', 30, 74, 12),
(10284, 'S24_3420', 39, 72, 13),
(10284, 'S24_3949', 21, 56, 10),
(10284, 'S24_4278', 21, 71, 2),
(10284, 'S32_4289', 50, 82, 4),
(10284, 'S50_1341', 33, 52, 5),
(10284, 'S700_1691', 24, 83, 6),
(10284, 'S700_2466', 45, 102, 8),
(10284, 'S700_3167', 25, 70, 7),
(10284, 'S700_4002', 32, 64, 9),
(10285, 'S10_1678', 36, 114, 6),
(10285, 'S10_2016', 47, 138, 9),
(10285, 'S10_4698', 27, 201, 8),
(10285, 'S12_2823', 49, 140, 5),
(10285, 'S18_2625', 20, 49, 10),
(10285, 'S24_1578', 34, 109, 7),
(10285, 'S24_2000', 39, 70, 11),
(10285, 'S24_2360', 38, 60, 3),
(10285, 'S32_1374', 37, 99, 12),
(10285, 'S32_2206', 37, 41, 1),
(10285, 'S32_4485', 26, 100, 4),
(10285, 'S50_4713', 39, 79, 2),
(10285, 'S700_2834', 45, 120, 13),
(10286, 'S18_3782', 38, 57, 1),
(10287, 'S12_1099', 21, 163, 12),
(10287, 'S12_3380', 45, 106, 10),
(10287, 'S12_3990', 41, 69, 13),
(10287, 'S12_4675', 23, 116, 9),
(10287, 'S18_1129', 41, 159, 4),
(10287, 'S18_1889', 44, 82, 8),
(10287, 'S18_1984', 24, 147, 3),
(10287, 'S18_2870', 44, 115, 1),
(10287, 'S18_3232', 36, 163, 5),
(10287, 'S18_3278', 43, 71, 15),
(10287, 'S18_3482', 40, 169, 14),
(10287, 'S18_3685', 27, 160, 2),
(10287, 'S18_4721', 34, 126, 17),
(10287, 'S24_2972', 36, 40, 6),
(10287, 'S24_3371', 20, 68, 11),
(10287, 'S24_3856', 36, 119, 7),
(10287, 'S24_4620', 40, 88, 16),
(10288, 'S18_1589', 20, 147, 14),
(10288, 'S18_1749', 32, 184, 5),
(10288, 'S18_2248', 28, 62, 4),
(10288, 'S18_2325', 31, 123, 2),
(10288, 'S18_4409', 35, 81, 6),
(10288, 'S18_4933', 23, 73, 7),
(10288, 'S24_1046', 36, 66, 11),
(10288, 'S24_1628', 50, 52, 13),
(10288, 'S24_1937', 29, 38, 1),
(10288, 'S24_2766', 35, 81, 9),
(10288, 'S24_2887', 48, 136, 8),
(10288, 'S24_3191', 34, 68, 10),
(10288, 'S24_3432', 41, 119, 12),
(10288, 'S24_3969', 33, 41, 3),
(10289, 'S18_1342', 38, 120, 2),
(10289, 'S18_1367', 24, 56, 1),
(10289, 'S18_2795', 43, 192, 3),
(10289, 'S24_2022', 45, 48, 4),
(10290, 'S18_3320', 26, 96, 2),
(10290, 'S24_4258', 45, 115, 1),
(10291, 'S10_1949', 37, 193, 11),
(10291, 'S10_4962', 30, 129, 4),
(10291, 'S12_1666', 41, 156, 8),
(10291, 'S18_1097', 41, 114, 10),
(10291, 'S18_2432', 26, 58, 2),
(10291, 'S18_2949', 47, 122, 12),
(10291, 'S18_2957', 37, 51, 14),
(10291, 'S18_3136', 23, 125, 13),
(10291, 'S18_4600', 48, 110, 5),
(10291, 'S18_4668', 29, 52, 9),
(10291, 'S24_2300', 48, 112, 1),
(10291, 'S32_1268', 26, 84, 3),
(10291, 'S32_3522', 32, 72, 7),
(10291, 'S700_2824', 28, 116, 6),
(10292, 'S12_4473', 21, 105, 8),
(10292, 'S18_2238', 26, 175, 7),
(10292, 'S18_2319', 41, 110, 11),
(10292, 'S18_3232', 21, 135, 12),
(10292, 'S18_4027', 44, 162, 2),
(10292, 'S24_1444', 40, 54, 5),
(10292, 'S24_2840', 39, 30, 9),
(10292, 'S24_4048', 27, 142, 4),
(10292, 'S32_2509', 50, 47, 10),
(10292, 'S32_3207', 31, 68, 3),
(10292, 'S50_1392', 41, 122, 6),
(10292, 'S50_1514', 35, 55, 1),
(10293, 'S12_1108', 46, 183, 8),
(10293, 'S12_3148', 24, 177, 9),
(10293, 'S12_3891', 45, 183, 7),
(10293, 'S18_3140', 24, 117, 4),
(10293, 'S18_3259', 22, 110, 6),
(10293, 'S18_4522', 49, 101, 3),
(10293, 'S24_2011', 21, 140, 2),
(10293, 'S700_1938', 29, 72, 5),
(10293, 'S72_3212', 32, 60, 1),
(10294, 'S700_3962', 45, 104, 1),
(10295, 'S10_4757', 24, 143, 1),
(10295, 'S24_3151', 46, 85, 3),
(10295, 'S700_1138', 26, 75, 4),
(10295, 'S700_2610', 44, 59, 2),
(10295, 'S700_3505', 34, 102, 5),
(10296, 'S18_1662', 36, 158, 7),
(10296, 'S18_3029', 21, 96, 13),
(10296, 'S18_3856', 22, 85, 12),
(10296, 'S24_2841', 21, 71, 8),
(10296, 'S24_3420', 31, 54, 9),
(10296, 'S24_3816', 22, 77, 14),
(10296, 'S24_3949', 32, 72, 6),
(10296, 'S50_1341', 26, 48, 1),
(10296, 'S700_1691', 42, 102, 2),
(10296, 'S700_2047', 34, 102, 11),
(10296, 'S700_2466', 24, 102, 4),
(10296, 'S700_3167', 22, 81, 3),
(10296, 'S700_4002', 47, 87, 5),
(10296, 'S72_1253', 21, 45, 10),
(10297, 'S18_2581', 25, 83, 4),
(10297, 'S24_1785', 32, 127, 6),
(10297, 'S24_2000', 32, 66, 1),
(10297, 'S24_4278', 23, 72, 5);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10297, 'S32_1374', 26, 110, 2),
(10297, 'S32_4289', 28, 80, 7),
(10297, 'S700_2834', 35, 114, 3),
(10298, 'S10_2016', 39, 96, 1),
(10298, 'S18_2625', 32, 48, 2),
(10299, 'S10_1678', 23, 113, 9),
(10299, 'S10_4698', 29, 230, 11),
(10299, 'S12_2823', 24, 173, 8),
(10299, 'S18_3782', 39, 56, 3),
(10299, 'S18_4721', 49, 162, 2),
(10299, 'S24_1578', 47, 116, 10),
(10299, 'S24_2360', 33, 66, 6),
(10299, 'S24_4620', 32, 81, 1),
(10299, 'S32_2206', 24, 42, 4),
(10299, 'S32_4485', 38, 115, 7),
(10299, 'S50_4713', 44, 81, 5),
(10300, 'S12_1099', 33, 167, 5),
(10300, 'S12_3380', 29, 137, 3),
(10300, 'S12_3990', 22, 77, 6),
(10300, 'S12_4675', 23, 122, 2),
(10300, 'S18_1889', 41, 92, 1),
(10300, 'S18_3278', 49, 79, 8),
(10300, 'S18_3482', 23, 165, 7),
(10300, 'S24_3371', 31, 59, 4),
(10301, 'S18_1129', 37, 160, 8),
(10301, 'S18_1589', 32, 107, 4),
(10301, 'S18_1984', 47, 159, 7),
(10301, 'S18_2870', 22, 147, 5),
(10301, 'S18_3232', 23, 174, 9),
(10301, 'S18_3685', 39, 165, 6),
(10301, 'S24_1046', 27, 72, 1),
(10301, 'S24_1628', 22, 51, 3),
(10301, 'S24_2972', 48, 34, 10),
(10301, 'S24_3432', 22, 96, 2),
(10301, 'S24_3856', 50, 154, 11),
(10302, 'S18_1749', 43, 170, 1),
(10302, 'S18_4409', 38, 89, 2),
(10302, 'S18_4933', 23, 73, 3),
(10302, 'S24_2766', 49, 108, 5),
(10302, 'S24_2887', 45, 123, 4),
(10302, 'S24_3191', 48, 74, 6),
(10303, 'S18_2248', 46, 49, 2),
(10303, 'S24_3969', 24, 40, 1),
(10304, 'S10_1949', 47, 216, 6),
(10304, 'S12_1666', 39, 164, 3),
(10304, 'S18_1097', 46, 98, 5),
(10304, 'S18_1342', 37, 96, 13),
(10304, 'S18_1367', 37, 49, 12),
(10304, 'S18_2325', 24, 102, 17),
(10304, 'S18_2795', 20, 179, 14),
(10304, 'S18_2949', 46, 100, 7),
(10304, 'S18_2957', 24, 65, 9),
(10304, 'S18_3136', 26, 86, 8),
(10304, 'S18_3320', 38, 104, 11),
(10304, 'S18_4668', 34, 49, 4),
(10304, 'S24_1937', 23, 30, 16),
(10304, 'S24_2022', 44, 39, 15),
(10304, 'S24_4258', 33, 101, 10),
(10304, 'S32_3522', 36, 73, 2),
(10304, 'S700_2824', 40, 105, 1),
(10305, 'S10_4962', 38, 176, 13),
(10305, 'S12_4473', 38, 126, 5),
(10305, 'S18_2238', 27, 146, 4),
(10305, 'S18_2319', 36, 134, 8),
(10305, 'S18_2432', 41, 53, 11),
(10305, 'S18_3232', 37, 202, 9),
(10305, 'S18_4600', 22, 99, 14),
(10305, 'S24_1444', 45, 62, 2),
(10305, 'S24_2300', 24, 133, 10),
(10305, 'S24_2840', 48, 31, 6),
(10305, 'S24_4048', 36, 129, 1),
(10305, 'S32_1268', 28, 113, 12),
(10305, 'S32_2509', 40, 58, 7),
(10305, 'S50_1392', 42, 110, 3),
(10306, 'S12_1108', 31, 212, 13),
(10306, 'S12_3148', 34, 147, 14),
(10306, 'S12_3891', 20, 182, 12),
(10306, 'S18_3140', 32, 117, 9),
(10306, 'S18_3259', 40, 92, 11),
(10306, 'S18_4027', 23, 157, 16),
(10306, 'S18_4522', 39, 90, 8),
(10306, 'S24_2011', 29, 111, 7),
(10306, 'S24_3151', 31, 84, 2),
(10306, 'S32_3207', 46, 50, 17),
(10306, 'S50_1514', 34, 60, 15),
(10306, 'S700_1138', 50, 54, 3),
(10306, 'S700_1938', 38, 92, 10),
(10306, 'S700_2610', 43, 75, 1),
(10306, 'S700_3505', 32, 90, 4),
(10306, 'S700_3962', 30, 117, 5),
(10306, 'S72_3212', 35, 60, 6),
(10307, 'S10_4757', 22, 122, 9),
(10307, 'S18_1662', 39, 189, 1),
(10307, 'S18_3029', 31, 83, 7),
(10307, 'S18_3856', 48, 87, 6),
(10307, 'S24_2841', 25, 75, 2),
(10307, 'S24_3420', 22, 72, 3),
(10307, 'S24_3816', 22, 91, 8),
(10307, 'S700_2047', 34, 98, 5),
(10307, 'S72_1253', 34, 54, 4),
(10308, 'S10_2016', 34, 119, 2),
(10308, 'S10_4698', 20, 229, 1),
(10308, 'S18_2581', 27, 83, 7),
(10308, 'S18_2625', 34, 52, 3),
(10308, 'S24_1785', 31, 113, 9),
(10308, 'S24_2000', 47, 63, 4),
(10308, 'S24_3949', 43, 76, 16),
(10308, 'S24_4278', 44, 83, 8),
(10308, 'S32_1374', 24, 80, 5),
(10308, 'S32_4289', 46, 66, 10),
(10308, 'S50_1341', 47, 44, 11),
(10308, 'S700_1691', 21, 106, 12),
(10308, 'S700_2466', 35, 89, 14),
(10308, 'S700_2834', 31, 129, 6),
(10308, 'S700_3167', 21, 87, 13),
(10308, 'S700_4002', 39, 68, 15),
(10309, 'S10_1678', 41, 107, 5),
(10309, 'S12_2823', 26, 179, 4),
(10309, 'S24_1578', 21, 126, 6),
(10309, 'S24_2360', 24, 56, 2),
(10309, 'S32_4485', 50, 85, 3),
(10309, 'S50_4713', 28, 89, 1);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10310, 'S12_1099', 33, 210, 10),
(10310, 'S12_3380', 24, 129, 8),
(10310, 'S12_3990', 49, 81, 11),
(10310, 'S12_4675', 25, 100, 7),
(10310, 'S18_1129', 37, 168, 2),
(10310, 'S18_1889', 20, 92, 6),
(10310, 'S18_1984', 24, 144, 1),
(10310, 'S18_3232', 48, 186, 3),
(10310, 'S18_3278', 27, 80, 13),
(10310, 'S18_3482', 49, 128, 12),
(10310, 'S18_3782', 42, 67, 16),
(10310, 'S18_4721', 40, 134, 15),
(10310, 'S24_2972', 33, 42, 4),
(10310, 'S24_3371', 38, 57, 9),
(10310, 'S24_3856', 45, 122, 5),
(10310, 'S24_4620', 49, 97, 14),
(10310, 'S32_2206', 36, 43, 17),
(10311, 'S18_1589', 29, 101, 9),
(10311, 'S18_2870', 43, 123, 10),
(10311, 'S18_3685', 32, 113, 11),
(10311, 'S18_4409', 41, 82, 1),
(10311, 'S18_4933', 25, 67, 2),
(10311, 'S24_1046', 26, 87, 6),
(10311, 'S24_1628', 45, 49, 8),
(10311, 'S24_2766', 28, 94, 4),
(10311, 'S24_2887', 43, 107, 3),
(10311, 'S24_3191', 25, 83, 5),
(10311, 'S24_3432', 46, 92, 7),
(10312, 'S10_1949', 48, 242, 3),
(10312, 'S18_1097', 32, 131, 2),
(10312, 'S18_1342', 43, 89, 10),
(10312, 'S18_1367', 25, 44, 9),
(10312, 'S18_1749', 48, 168, 17),
(10312, 'S18_2248', 30, 61, 16),
(10312, 'S18_2325', 31, 153, 14),
(10312, 'S18_2795', 25, 155, 11),
(10312, 'S18_2949', 37, 100, 4),
(10312, 'S18_2957', 35, 54, 6),
(10312, 'S18_3136', 38, 117, 5),
(10312, 'S18_3320', 33, 107, 8),
(10312, 'S18_4668', 39, 57, 1),
(10312, 'S24_1937', 39, 30, 13),
(10312, 'S24_2022', 23, 38, 12),
(10312, 'S24_3969', 31, 35, 15),
(10312, 'S24_4258', 44, 111, 7),
(10313, 'S10_4962', 40, 167, 7),
(10313, 'S12_1666', 21, 127, 11),
(10313, 'S18_2319', 29, 118, 2),
(10313, 'S18_2432', 34, 53, 5),
(10313, 'S18_3232', 25, 183, 3),
(10313, 'S18_4600', 28, 103, 8),
(10313, 'S24_2300', 42, 133, 4),
(10313, 'S32_1268', 27, 88, 6),
(10313, 'S32_2509', 38, 45, 1),
(10313, 'S32_3522', 34, 56, 10),
(10313, 'S700_2824', 30, 99, 9),
(10314, 'S12_1108', 38, 210, 5),
(10314, 'S12_3148', 46, 139, 6),
(10314, 'S12_3891', 36, 192, 4),
(10314, 'S12_4473', 45, 137, 14),
(10314, 'S18_2238', 42, 138, 13),
(10314, 'S18_3140', 20, 137, 1),
(10314, 'S18_3259', 23, 108, 3),
(10314, 'S18_4027', 29, 145, 8),
(10314, 'S24_1444', 44, 53, 11),
(10314, 'S24_2840', 39, 37, 15),
(10314, 'S24_4048', 38, 105, 10),
(10314, 'S32_3207', 35, 66, 9),
(10314, 'S50_1392', 28, 122, 12),
(10314, 'S50_1514', 38, 62, 7),
(10314, 'S700_1938', 23, 76, 2),
(10315, 'S18_4522', 36, 100, 7),
(10315, 'S24_2011', 35, 120, 6),
(10315, 'S24_3151', 24, 87, 1),
(10315, 'S700_1138', 41, 62, 2),
(10315, 'S700_3505', 31, 86, 3),
(10315, 'S700_3962', 37, 91, 4),
(10315, 'S72_3212', 40, 56, 5),
(10316, 'S10_4757', 33, 125, 17),
(10316, 'S18_1662', 27, 137, 9),
(10316, 'S18_3029', 21, 95, 15),
(10316, 'S18_3856', 47, 87, 14),
(10316, 'S24_1785', 25, 115, 1),
(10316, 'S24_2841', 34, 64, 10),
(10316, 'S24_3420', 47, 77, 11),
(10316, 'S24_3816', 25, 92, 16),
(10316, 'S24_3949', 30, 78, 8),
(10316, 'S32_4289', 24, 59, 2),
(10316, 'S50_1341', 34, 48, 3),
(10316, 'S700_1691', 34, 82, 4),
(10316, 'S700_2047', 45, 93, 13),
(10316, 'S700_2466', 23, 118, 6),
(10316, 'S700_2610', 48, 74, 18),
(10316, 'S700_3167', 48, 75, 5),
(10316, 'S700_4002', 44, 62, 7),
(10316, 'S72_1253', 34, 44, 12),
(10317, 'S24_4278', 35, 83, 1),
(10318, 'S10_1678', 46, 95, 1),
(10318, 'S10_2016', 45, 124, 4),
(10318, 'S10_4698', 37, 207, 3),
(10318, 'S18_2581', 31, 101, 9),
(10318, 'S18_2625', 42, 53, 5),
(10318, 'S24_1578', 48, 134, 2),
(10318, 'S24_2000', 26, 87, 6),
(10318, 'S32_1374', 47, 113, 7),
(10318, 'S700_2834', 50, 142, 8),
(10319, 'S12_2823', 30, 137, 9),
(10319, 'S18_3278', 46, 74, 1),
(10319, 'S18_3782', 44, 59, 4),
(10319, 'S18_4721', 45, 176, 3),
(10319, 'S24_2360', 31, 82, 7),
(10319, 'S24_4620', 43, 86, 2),
(10319, 'S32_2206', 29, 38, 5),
(10319, 'S32_4485', 22, 119, 8),
(10319, 'S50_4713', 45, 77, 6),
(10320, 'S12_1099', 31, 222, 3),
(10320, 'S12_3380', 35, 139, 1),
(10320, 'S12_3990', 38, 73, 4),
(10320, 'S18_3482', 25, 140, 5),
(10320, 'S24_3371', 26, 61, 2),
(10321, 'S12_4675', 24, 124, 15),
(10321, 'S18_1129', 41, 142, 10);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10321, 'S18_1589', 44, 102, 6),
(10321, 'S18_1889', 37, 79, 14),
(10321, 'S18_1984', 25, 149, 9),
(10321, 'S18_2870', 27, 106, 7),
(10321, 'S18_3232', 33, 173, 11),
(10321, 'S18_3685', 28, 151, 8),
(10321, 'S24_1046', 30, 71, 3),
(10321, 'S24_1628', 48, 42, 5),
(10321, 'S24_2766', 30, 73, 1),
(10321, 'S24_2972', 37, 33, 12),
(10321, 'S24_3191', 39, 85, 2),
(10321, 'S24_3432', 21, 90, 4),
(10321, 'S24_3856', 26, 156, 13),
(10322, 'S10_1949', 40, 150, 1),
(10322, 'S10_4962', 46, 62, 8),
(10322, 'S12_1666', 27, 177, 9),
(10322, 'S18_1097', 22, 102, 10),
(10322, 'S18_1342', 43, 86, 14),
(10322, 'S18_1367', 41, 58, 5),
(10322, 'S18_2325', 50, 251, 6),
(10322, 'S18_2432', 35, 61, 11),
(10322, 'S18_2795', 36, 161, 2),
(10322, 'S18_2949', 33, 107, 12),
(10322, 'S18_2957', 41, 30, 13),
(10322, 'S18_3136', 48, 47, 7),
(10322, 'S24_1937', 20, 131, 3),
(10322, 'S24_2022', 30, 117, 4),
(10323, 'S18_3320', 33, 91, 2),
(10323, 'S18_4600', 47, 132, 1),
(10324, 'S12_3148', 27, 54, 1),
(10324, 'S12_4473', 26, 58, 7),
(10324, 'S18_2238', 47, 153, 8),
(10324, 'S18_2319', 33, 37, 10),
(10324, 'S18_3232', 27, 117, 12),
(10324, 'S18_4027', 49, 110, 13),
(10324, 'S18_4668', 38, 180, 6),
(10324, 'S24_1444', 25, 69, 14),
(10324, 'S24_2300', 31, 123, 2),
(10324, 'S24_2840', 30, 111, 9),
(10324, 'S24_4258', 33, 190, 3),
(10324, 'S32_1268', 20, 98, 11),
(10324, 'S32_3522', 48, 171, 4),
(10324, 'S700_2824', 34, 125, 5),
(10325, 'S10_4757', 47, 65, 6),
(10325, 'S12_1108', 42, 64, 8),
(10325, 'S12_3891', 24, 108, 1),
(10325, 'S18_3140', 24, 69, 9),
(10325, 'S24_4048', 44, 121, 5),
(10325, 'S32_2509', 38, 233, 3),
(10325, 'S32_3207', 28, 192, 2),
(10325, 'S50_1392', 38, 137, 4),
(10325, 'S50_1514', 44, 135, 7),
(10326, 'S18_3259', 32, 119, 6),
(10326, 'S18_4522', 50, 86, 5),
(10326, 'S24_2011', 41, 106, 4),
(10326, 'S24_3151', 41, 86, 3),
(10326, 'S24_3816', 20, 92, 2),
(10326, 'S700_1138', 39, 60, 1),
(10327, 'S18_1662', 25, 112, 6),
(10327, 'S18_2581', 45, 106, 8),
(10327, 'S18_3029', 25, 46, 5),
(10327, 'S700_1938', 20, 173, 7),
(10327, 'S700_2610', 21, 96, 1),
(10327, 'S700_3505', 43, 80, 2),
(10327, 'S700_3962', 37, 87, 3),
(10327, 'S72_3212', 37, 87, 4),
(10328, 'S18_3856', 34, 112, 6),
(10328, 'S24_1785', 47, 88, 14),
(10328, 'S24_2841', 48, 59, 1),
(10328, 'S24_3420', 20, 73, 2),
(10328, 'S24_3949', 35, 76, 3),
(10328, 'S24_4278', 43, 61, 4),
(10328, 'S32_4289', 24, 81, 5),
(10328, 'S50_1341', 34, 52, 7),
(10328, 'S700_1691', 27, 102, 8),
(10328, 'S700_2047', 41, 101, 9),
(10328, 'S700_2466', 37, 109, 10),
(10328, 'S700_2834', 33, 123, 11),
(10328, 'S700_3167', 33, 64, 13),
(10328, 'S700_4002', 39, 86, 12),
(10329, 'S10_1678', 42, 105, 1),
(10329, 'S10_2016', 20, 159, 2),
(10329, 'S10_4698', 26, 226, 3),
(10329, 'S12_1099', 41, 71, 5),
(10329, 'S12_2823', 24, 148, 6),
(10329, 'S12_3380', 46, 84, 13),
(10329, 'S12_3990', 33, 109, 14),
(10329, 'S12_4675', 39, 65, 15),
(10329, 'S18_1889', 29, 102, 9),
(10329, 'S18_2625', 38, 139, 12),
(10329, 'S18_3278', 38, 59, 10),
(10329, 'S24_1578', 30, 88, 7),
(10329, 'S24_2000', 37, 94, 4),
(10329, 'S32_1374', 45, 64, 11),
(10329, 'S72_1253', 44, 86, 8),
(10330, 'S18_3482', 37, 119, 3),
(10330, 'S18_3782', 29, 70, 2),
(10330, 'S18_4721', 50, 122, 4),
(10330, 'S24_2360', 42, 81, 1),
(10331, 'S18_1129', 46, 140, 6),
(10331, 'S18_1589', 44, 110, 14),
(10331, 'S18_1749', 44, 74, 7),
(10331, 'S18_1984', 30, 32, 8),
(10331, 'S18_2870', 26, 65, 10),
(10331, 'S18_3232', 27, 154, 11),
(10331, 'S18_3685', 26, 68, 12),
(10331, 'S24_2972', 27, 42, 13),
(10331, 'S24_3371', 25, 123, 9),
(10331, 'S24_3856', 21, 149, 1),
(10331, 'S24_4620', 41, 139, 2),
(10331, 'S32_2206', 28, 147, 3),
(10331, 'S32_4485', 32, 157, 4),
(10331, 'S50_4713', 20, 183, 5),
(10332, 'S18_1342', 46, 95, 15),
(10332, 'S18_1367', 27, 90, 16),
(10332, 'S18_2248', 38, 84, 9),
(10332, 'S18_2325', 35, 65, 8),
(10332, 'S18_2795', 24, 53, 1),
(10332, 'S18_2957', 26, 115, 17),
(10332, 'S18_3136', 40, 40, 18),
(10332, 'S18_4409', 50, 146, 2),
(10332, 'S18_4933', 21, 165, 3);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10332, 'S24_1046', 23, 57, 4),
(10332, 'S24_1628', 20, 88, 5),
(10332, 'S24_1937', 45, 82, 6),
(10332, 'S24_2022', 26, 86, 10),
(10332, 'S24_2766', 39, 87, 7),
(10332, 'S24_2887', 44, 42, 11),
(10332, 'S24_3191', 45, 34, 12),
(10332, 'S24_3432', 31, 37, 13),
(10332, 'S24_3969', 41, 77, 14),
(10333, 'S10_1949', 26, 116, 3),
(10333, 'S12_1666', 33, 99, 6),
(10333, 'S18_1097', 29, 40, 7),
(10333, 'S18_2949', 31, 90, 5),
(10333, 'S18_3320', 46, 246, 2),
(10333, 'S18_4668', 24, 80, 8),
(10333, 'S24_4258', 39, 113, 1),
(10333, 'S32_3522', 33, 74, 4),
(10334, 'S10_4962', 26, 123, 2),
(10334, 'S18_2319', 46, 126, 6),
(10334, 'S18_2432', 34, 61, 1),
(10334, 'S18_3232', 20, 144, 3),
(10334, 'S18_4600', 49, 138, 4),
(10334, 'S24_2300', 42, 132, 5),
(10335, 'S24_2840', 33, 37, 2),
(10335, 'S32_1268', 44, 108, 1),
(10335, 'S32_2509', 40, 61, 3),
(10336, 'S12_1108', 33, 57, 10),
(10336, 'S12_3148', 33, 123, 11),
(10336, 'S12_3891', 49, 63, 1),
(10336, 'S12_4473', 38, 168, 3),
(10336, 'S18_2238', 49, 152, 6),
(10336, 'S18_3140', 48, 120, 12),
(10336, 'S18_3259', 21, 106, 7),
(10336, 'S24_1444', 45, 133, 4),
(10336, 'S24_4048', 31, 149, 5),
(10336, 'S32_3207', 31, 85, 9),
(10336, 'S50_1392', 23, 137, 8),
(10336, 'S700_2824', 46, 208, 2),
(10337, 'S10_4757', 25, 48, 8),
(10337, 'S18_4027', 36, 158, 3),
(10337, 'S18_4522', 29, 155, 2),
(10337, 'S24_2011', 29, 72, 4),
(10337, 'S50_1514', 21, 109, 6),
(10337, 'S700_1938', 36, 70, 9),
(10337, 'S700_3505', 31, 89, 1),
(10337, 'S700_3962', 36, 72, 7),
(10337, 'S72_3212', 42, 97, 5),
(10338, 'S18_1662', 41, 137, 1),
(10338, 'S18_3029', 28, 83, 3),
(10338, 'S18_3856', 45, 123, 2),
(10339, 'S10_2016', 40, 69, 4),
(10339, 'S10_4698', 39, 77, 3),
(10339, 'S18_2581', 27, 104, 2),
(10339, 'S18_2625', 30, 62, 1),
(10339, 'S24_1578', 27, 84, 10),
(10339, 'S24_1785', 21, 51, 7),
(10339, 'S24_2841', 55, 113, 12),
(10339, 'S24_3151', 55, 196, 13),
(10339, 'S24_3420', 29, 100, 14),
(10339, 'S24_3816', 42, 59, 16),
(10339, 'S24_3949', 45, 97, 11),
(10339, 'S700_1138', 22, 128, 5),
(10339, 'S700_2047', 55, 71, 15),
(10339, 'S700_2610', 50, 74, 9),
(10339, 'S700_4002', 50, 58, 8),
(10339, 'S72_1253', 27, 76, 6),
(10340, 'S24_2000', 55, 80, 8),
(10340, 'S24_4278', 40, 85, 1),
(10340, 'S32_1374', 55, 118, 2),
(10340, 'S32_4289', 39, 59, 3),
(10340, 'S50_1341', 40, 51, 4),
(10340, 'S700_1691', 30, 89, 5),
(10340, 'S700_2466', 55, 88, 7),
(10340, 'S700_2834', 29, 141, 6),
(10341, 'S10_1678', 41, 189, 9),
(10341, 'S12_1099', 45, 80, 2),
(10341, 'S12_2823', 55, 148, 8),
(10341, 'S12_3380', 44, 96, 1),
(10341, 'S12_3990', 36, 94, 10),
(10341, 'S12_4675', 55, 75, 7),
(10341, 'S24_2360', 32, 103, 6),
(10341, 'S32_4485', 31, 71, 4),
(10341, 'S50_4713', 38, 123, 3),
(10341, 'S700_3167', 34, 107, 5),
(10342, 'S18_1129', 40, 161, 2),
(10342, 'S18_1889', 55, 65, 1),
(10342, 'S18_1984', 22, 144, 3),
(10342, 'S18_3232', 30, 168, 4),
(10342, 'S18_3278', 25, 67, 5),
(10342, 'S18_3482', 55, 119, 7),
(10342, 'S18_3782', 26, 56, 8),
(10342, 'S18_4721', 38, 165, 11),
(10342, 'S24_2972', 39, 40, 9),
(10342, 'S24_3371', 48, 62, 10),
(10342, 'S24_3856', 42, 119, 6),
(10343, 'S18_1589', 36, 162, 4),
(10343, 'S18_2870', 25, 52, 3),
(10343, 'S18_3685', 44, 85, 2),
(10343, 'S24_1628', 27, 36, 6),
(10343, 'S24_4620', 30, 103, 1),
(10343, 'S32_2206', 29, 128, 5),
(10344, 'S18_1749', 45, 170, 1),
(10344, 'S18_2248', 40, 57, 2),
(10344, 'S18_2325', 30, 131, 3),
(10344, 'S18_4409', 21, 105, 4),
(10344, 'S18_4933', 26, 63, 5),
(10344, 'S24_1046', 29, 60, 7),
(10344, 'S24_1937', 20, 35, 6),
(10345, 'S24_2022', 43, 54, 1),
(10346, 'S18_1342', 42, 36, 3),
(10346, 'S24_2766', 25, 115, 1),
(10346, 'S24_2887', 24, 87, 5),
(10346, 'S24_3191', 24, 139, 2),
(10346, 'S24_3432', 26, 96, 6),
(10346, 'S24_3969', 22, 97, 4),
(10347, 'S10_1949', 30, 131, 1),
(10347, 'S10_4962', 27, 164, 2),
(10347, 'S12_1666', 29, 124, 3),
(10347, 'S18_1097', 42, 50, 5),
(10347, 'S18_1367', 21, 59, 7),
(10347, 'S18_2432', 50, 137, 8),
(10347, 'S18_2795', 21, 229, 6),
(10347, 'S18_2949', 48, 100, 9);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10347, 'S18_2957', 34, 65, 10),
(10347, 'S18_3136', 45, 110, 11),
(10347, 'S18_3320', 26, 102, 12),
(10347, 'S18_4600', 45, 131, 4),
(10348, 'S12_1108', 48, 52, 8),
(10348, 'S12_3148', 47, 102, 4),
(10348, 'S18_4668', 29, 245, 6),
(10348, 'S24_2300', 37, 162, 1),
(10348, 'S24_4258', 39, 50, 2),
(10348, 'S32_1268', 42, 152, 3),
(10348, 'S32_3522', 31, 101, 5),
(10348, 'S700_2824', 32, 83, 7),
(10349, 'S12_3891', 26, 170, 10),
(10349, 'S12_4473', 48, 109, 9),
(10349, 'S18_2238', 38, 177, 8),
(10349, 'S18_2319', 38, 137, 7),
(10349, 'S18_3232', 48, 154, 6),
(10349, 'S18_4027', 34, 129, 5),
(10349, 'S24_1444', 48, 47, 4),
(10349, 'S24_2840', 36, 37, 3),
(10349, 'S24_4048', 23, 138, 2),
(10349, 'S32_2509', 33, 47, 1),
(10350, 'S10_4757', 26, 75, 5),
(10350, 'S18_3029', 43, 65, 6),
(10350, 'S18_3140', 44, 118, 1),
(10350, 'S18_3259', 41, 93, 2),
(10350, 'S18_4522', 30, 101, 3),
(10350, 'S24_2011', 34, 50, 7),
(10350, 'S24_3151', 30, 101, 9),
(10350, 'S24_3816', 25, 60, 10),
(10350, 'S32_3207', 27, 163, 14),
(10350, 'S50_1392', 31, 71, 8),
(10350, 'S50_1514', 44, 148, 17),
(10350, 'S700_1138', 46, 77, 11),
(10350, 'S700_1938', 28, 104, 4),
(10350, 'S700_2610', 29, 75, 12),
(10350, 'S700_3505', 31, 77, 13),
(10350, 'S700_3962', 25, 114, 16),
(10350, 'S72_3212', 20, 112, 15),
(10351, 'S18_1662', 39, 100, 1),
(10351, 'S18_3856', 20, 169, 2),
(10351, 'S24_2841', 25, 75, 5),
(10351, 'S24_3420', 38, 68, 4),
(10351, 'S24_3949', 34, 59, 3),
(10352, 'S700_2047', 23, 102, 3),
(10352, 'S700_2466', 49, 101, 2),
(10352, 'S700_4002', 22, 76, 1),
(10352, 'S72_1253', 49, 53, 4),
(10353, 'S18_2581', 27, 130, 1),
(10353, 'S24_1785', 28, 72, 2),
(10353, 'S24_4278', 35, 90, 3),
(10353, 'S32_1374', 46, 81, 5),
(10353, 'S32_4289', 40, 45, 7),
(10353, 'S50_1341', 40, 82, 8),
(10353, 'S700_1691', 39, 129, 9),
(10353, 'S700_2834', 48, 69, 4),
(10353, 'S700_3167', 43, 82, 6),
(10354, 'S10_1678', 42, 86, 6),
(10354, 'S10_2016', 20, 105, 2),
(10354, 'S10_4698', 42, 213, 3),
(10354, 'S12_1099', 31, 93, 9),
(10354, 'S12_2823', 35, 183, 4),
(10354, 'S12_3380', 29, 73, 11),
(10354, 'S12_3990', 23, 51, 12),
(10354, 'S12_4675', 28, 87, 13),
(10354, 'S18_1889', 21, 110, 8),
(10354, 'S18_2625', 28, 166, 10),
(10354, 'S18_3278', 36, 82, 7),
(10354, 'S24_1578', 21, 114, 5),
(10354, 'S24_2000', 28, 69, 1),
(10355, 'S18_3482', 23, 138, 7),
(10355, 'S18_3782', 31, 53, 1),
(10355, 'S18_4721', 25, 168, 2),
(10355, 'S24_2360', 41, 71, 3),
(10355, 'S24_2972', 36, 39, 4),
(10355, 'S24_3371', 44, 62, 6),
(10355, 'S24_3856', 32, 166, 8),
(10355, 'S24_4620', 28, 95, 9),
(10355, 'S32_2206', 38, 40, 10),
(10355, 'S32_4485', 40, 108, 5),
(10356, 'S18_1129', 43, 98, 8),
(10356, 'S18_1342', 50, 50, 9),
(10356, 'S18_1367', 22, 72, 6),
(10356, 'S18_1984', 27, 65, 2),
(10356, 'S18_2325', 29, 125, 3),
(10356, 'S18_2795', 30, 149, 1),
(10356, 'S24_1937', 48, 203, 5),
(10356, 'S24_2022', 26, 32, 7),
(10356, 'S50_4713', 26, 151, 4),
(10357, 'S10_1949', 32, 178, 10),
(10357, 'S10_4962', 43, 134, 9),
(10357, 'S12_1666', 49, 122, 8),
(10357, 'S18_1097', 39, 98, 1),
(10357, 'S18_2432', 41, 62, 7),
(10357, 'S18_2949', 41, 87, 6),
(10357, 'S18_2957', 49, 71, 5),
(10357, 'S18_3136', 44, 117, 4),
(10357, 'S18_3320', 25, 104, 3),
(10357, 'S18_4600', 28, 127, 2),
(10358, 'S12_3148', 49, 55, 5),
(10358, 'S12_4473', 42, 64, 9),
(10358, 'S18_2238', 20, 121, 10),
(10358, 'S18_2319', 20, 36, 11),
(10358, 'S18_3232', 32, 93, 12),
(10358, 'S18_4027', 25, 101, 13),
(10358, 'S18_4668', 30, 177, 8),
(10358, 'S24_1444', 44, 61, 14),
(10358, 'S24_2300', 41, 139, 7),
(10358, 'S24_2840', 36, 83, 4),
(10358, 'S24_4258', 41, 167, 6),
(10358, 'S32_1268', 41, 108, 1),
(10358, 'S32_3522', 36, 157, 2),
(10358, 'S700_2824', 27, 139, 3),
(10359, 'S10_4757', 48, 55, 6),
(10359, 'S12_1108', 42, 113, 8),
(10359, 'S12_3891', 49, 62, 5),
(10359, 'S24_4048', 22, 118, 7),
(10359, 'S32_2509', 36, 177, 3),
(10359, 'S32_3207', 22, 196, 1),
(10359, 'S50_1392', 46, 106, 2),
(10359, 'S50_1514', 25, 65, 4),
(10360, 'S18_1662', 50, 59, 12);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10360, 'S18_2581', 41, 87, 13),
(10360, 'S18_3029', 46, 77, 14),
(10360, 'S18_3140', 29, 175, 8),
(10360, 'S18_3259', 29, 101, 18),
(10360, 'S18_3856', 40, 87, 15),
(10360, 'S18_4522', 40, 86, 1),
(10360, 'S24_1785', 22, 115, 17),
(10360, 'S24_2011', 31, 119, 2),
(10360, 'S24_2841', 49, 57, 16),
(10360, 'S24_3151', 36, 114, 3),
(10360, 'S24_3816', 22, 111, 4),
(10360, 'S700_1138', 32, 101, 5),
(10360, 'S700_1938', 26, 97, 6),
(10360, 'S700_2610', 30, 125, 7),
(10360, 'S700_3505', 35, 66, 9),
(10360, 'S700_3962', 31, 104, 10),
(10360, 'S72_3212', 31, 96, 11),
(10361, 'S10_1678', 20, 73, 13),
(10361, 'S10_2016', 26, 51, 8),
(10361, 'S24_3420', 34, 114, 6),
(10361, 'S24_3949', 26, 143, 7),
(10361, 'S24_4278', 25, 62, 1),
(10361, 'S32_4289', 49, 72, 2),
(10361, 'S50_1341', 33, 83, 3),
(10361, 'S700_1691', 20, 61, 4),
(10361, 'S700_2047', 24, 45, 14),
(10361, 'S700_2466', 26, 106, 9),
(10361, 'S700_2834', 44, 72, 5),
(10361, 'S700_3167', 44, 114, 10),
(10361, 'S700_4002', 35, 122, 11),
(10361, 'S72_1253', 23, 95, 12),
(10362, 'S10_4698', 22, 167, 4),
(10362, 'S12_2823', 22, 176, 1),
(10362, 'S18_2625', 23, 50, 3),
(10362, 'S24_1578', 50, 97, 2),
(10363, 'S12_1099', 33, 85, 3),
(10363, 'S12_3380', 34, 97, 4),
(10363, 'S12_3990', 34, 82, 5),
(10363, 'S12_4675', 46, 88, 6),
(10363, 'S18_1889', 22, 168, 7),
(10363, 'S18_3278', 46, 60, 10),
(10363, 'S18_3482', 24, 173, 11),
(10363, 'S18_3782', 32, 89, 12),
(10363, 'S18_4721', 28, 58, 13),
(10363, 'S24_2000', 21, 171, 8),
(10363, 'S24_2360', 43, 61, 14),
(10363, 'S24_3371', 21, 117, 15),
(10363, 'S24_3856', 31, 95, 1),
(10363, 'S24_4620', 43, 120, 9),
(10363, 'S32_1374', 50, 132, 2),
(10364, 'S32_2206', 48, 48, 1),
(10365, 'S18_1129', 30, 87, 1),
(10365, 'S32_4485', 22, 156, 3),
(10365, 'S50_4713', 44, 113, 2),
(10366, 'S18_1984', 34, 124, 3),
(10366, 'S18_2870', 49, 125, 2),
(10366, 'S18_3232', 34, 185, 1),
(10367, 'S18_1589', 49, 56, 1),
(10367, 'S18_1749', 37, 127, 3),
(10367, 'S18_2248', 45, 197, 4),
(10367, 'S18_2325', 27, 155, 5),
(10367, 'S18_2795', 32, 95, 7),
(10367, 'S18_3685', 46, 105, 6),
(10367, 'S18_4409', 43, 63, 8),
(10367, 'S18_4933', 44, 85, 9),
(10367, 'S24_1046', 21, 60, 10),
(10367, 'S24_1628', 38, 39, 11),
(10367, 'S24_1937', 23, 36, 13),
(10367, 'S24_2022', 28, 31, 12),
(10367, 'S24_2972', 36, 139, 2),
(10368, 'S24_2766', 40, 103, 2),
(10368, 'S24_2887', 31, 136, 5),
(10368, 'S24_3191', 46, 80, 1),
(10368, 'S24_3432', 20, 100, 4),
(10368, 'S24_3969', 46, 37, 3),
(10369, 'S10_1949', 41, 110, 2),
(10369, 'S18_1342', 44, 210, 8),
(10369, 'S18_1367', 32, 99, 7),
(10369, 'S18_2949', 42, 109, 1),
(10369, 'S18_2957', 28, 44, 6),
(10369, 'S18_3136', 21, 94, 5),
(10369, 'S18_3320', 45, 73, 4),
(10369, 'S24_4258', 40, 87, 3),
(10370, 'S10_4962', 35, 66, 4),
(10370, 'S12_1666', 49, 173, 8),
(10370, 'S18_1097', 27, 145, 1),
(10370, 'S18_2319', 22, 180, 5),
(10370, 'S18_2432', 22, 97, 7),
(10370, 'S18_3232', 27, 57, 9),
(10370, 'S18_4600', 29, 58, 6),
(10370, 'S18_4668', 20, 137, 2),
(10370, 'S32_3522', 25, 126, 3),
(10371, 'S12_1108', 32, 111, 6),
(10371, 'S12_4473', 49, 36, 4),
(10371, 'S18_2238', 25, 104, 7),
(10371, 'S24_1444', 25, 97, 12),
(10371, 'S24_2300', 20, 172, 5),
(10371, 'S24_2840', 45, 123, 8),
(10371, 'S24_4048', 28, 50, 9),
(10371, 'S32_1268', 26, 156, 1),
(10371, 'S32_2509', 20, 66, 2),
(10371, 'S32_3207', 30, 100, 11),
(10371, 'S50_1392', 48, 57, 10),
(10371, 'S700_2824', 34, 127, 3),
(10372, 'S12_3148', 40, 147, 4),
(10372, 'S12_3891', 34, 175, 1),
(10372, 'S18_3140', 28, 138, 3),
(10372, 'S18_3259', 25, 85, 5),
(10372, 'S18_4027', 48, 146, 6),
(10372, 'S18_4522', 41, 87, 7),
(10372, 'S24_2011', 37, 106, 8),
(10372, 'S50_1514', 24, 59, 9),
(10372, 'S700_1938', 44, 102, 2),
(10373, 'S10_4757', 39, 104, 3),
(10373, 'S18_1662', 28, 58, 4),
(10373, 'S18_3029', 22, 87, 5),
(10373, 'S18_3856', 50, 60, 6),
(10373, 'S24_2841', 38, 70, 7),
(10373, 'S24_3151', 33, 57, 12),
(10373, 'S24_3420', 46, 66, 11),
(10373, 'S24_3816', 23, 104, 10),
(10373, 'S24_3949', 39, 73, 13);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10373, 'S700_1138', 44, 105, 14),
(10373, 'S700_2047', 32, 84, 15),
(10373, 'S700_2610', 41, 70, 16),
(10373, 'S700_3505', 34, 96, 2),
(10373, 'S700_3962', 37, 109, 8),
(10373, 'S700_4002', 45, 56, 17),
(10373, 'S72_1253', 25, 65, 9),
(10373, 'S72_3212', 29, 137, 1),
(10374, 'S10_2016', 39, 136, 5),
(10374, 'S10_4698', 22, 174, 1),
(10374, 'S18_2581', 42, 69, 2),
(10374, 'S18_2625', 22, 53, 4),
(10374, 'S24_1578', 38, 110, 6),
(10374, 'S24_1785', 46, 94, 3),
(10375, 'S10_1678', 21, 35, 12),
(10375, 'S12_1099', 45, 76, 7),
(10375, 'S12_2823', 49, 79, 13),
(10375, 'S24_2000', 23, 106, 9),
(10375, 'S24_2360', 20, 102, 14),
(10375, 'S24_4278', 43, 233, 2),
(10375, 'S32_1374', 37, 172, 3),
(10375, 'S32_4289', 44, 82, 4),
(10375, 'S32_4485', 41, 115, 15),
(10375, 'S50_1341', 49, 66, 5),
(10375, 'S50_4713', 49, 110, 8),
(10375, 'S700_1691', 37, 82, 6),
(10375, 'S700_2466', 33, 117, 1),
(10375, 'S700_2834', 25, 67, 10),
(10375, 'S700_3167', 44, 118, 11),
(10376, 'S12_3380', 35, 114, 1),
(10377, 'S12_3990', 24, 68, 5),
(10377, 'S12_4675', 50, 104, 1),
(10377, 'S18_1129', 35, 168, 2),
(10377, 'S18_1889', 31, 68, 4),
(10377, 'S18_1984', 36, 121, 6),
(10377, 'S18_3232', 39, 186, 3),
(10378, 'S18_1589', 34, 43, 5),
(10378, 'S18_3278', 22, 112, 4),
(10378, 'S18_3482', 43, 96, 10),
(10378, 'S18_3782', 28, 165, 9),
(10378, 'S18_4721', 49, 67, 8),
(10378, 'S24_2972', 41, 143, 7),
(10378, 'S24_3371', 46, 42, 6),
(10378, 'S24_3856', 33, 53, 3),
(10378, 'S24_4620', 41, 119, 2),
(10378, 'S32_2206', 40, 82, 1),
(10379, 'S18_1749', 39, 138, 2),
(10379, 'S18_2248', 27, 49, 1),
(10379, 'S18_2870', 29, 177, 5),
(10379, 'S18_3685', 32, 71, 4),
(10379, 'S24_1628', 32, 124, 3),
(10380, 'S18_1342', 27, 93, 13),
(10380, 'S18_2325', 40, 123, 10),
(10380, 'S18_2795', 21, 47, 8),
(10380, 'S18_4409', 32, 106, 1),
(10380, 'S18_4933', 24, 189, 2),
(10380, 'S24_1046', 34, 101, 3),
(10380, 'S24_1937', 32, 71, 4),
(10380, 'S24_2022', 27, 68, 5),
(10380, 'S24_2766', 36, 38, 6),
(10380, 'S24_2887', 44, 36, 7),
(10380, 'S24_3191', 44, 79, 9),
(10380, 'S24_3432', 34, 116, 11),
(10380, 'S24_3969', 43, 95, 12),
(10381, 'S10_1949', 36, 229, 3),
(10381, 'S10_4962', 37, 168, 6),
(10381, 'S12_1666', 20, 148, 1),
(10381, 'S18_1097', 48, 98, 2),
(10381, 'S18_1367', 25, 53, 9),
(10381, 'S18_2432', 35, 49, 7),
(10381, 'S18_2949', 41, 105, 8),
(10381, 'S18_2957', 40, 68, 4),
(10381, 'S18_3136', 35, 123, 5),
(10382, 'S12_1108', 34, 112, 10),
(10382, 'S12_3148', 37, 110, 11),
(10382, 'S12_3891', 34, 95, 12),
(10382, 'S12_4473', 32, 67, 13),
(10382, 'S18_2238', 25, 88, 5),
(10382, 'S18_3320', 50, 179, 7),
(10382, 'S18_4600', 39, 125, 1),
(10382, 'S18_4668', 39, 201, 2),
(10382, 'S24_2300', 20, 133, 3),
(10382, 'S24_4258', 33, 139, 4),
(10382, 'S32_1268', 26, 104, 6),
(10382, 'S32_3522', 48, 142, 8),
(10382, 'S700_2824', 34, 55, 9),
(10383, 'S18_2319', 27, 142, 11),
(10383, 'S18_3140', 24, 62, 9),
(10383, 'S18_3232', 47, 146, 6),
(10383, 'S18_3259', 26, 128, 12),
(10383, 'S18_4027', 38, 141, 1),
(10383, 'S18_4522', 28, 59, 7),
(10383, 'S24_1444', 22, 92, 2),
(10383, 'S24_2840', 40, 152, 3),
(10383, 'S24_4048', 21, 94, 4),
(10383, 'S32_2509', 32, 53, 5),
(10383, 'S32_3207', 44, 36, 8),
(10383, 'S50_1392', 29, 106, 13),
(10383, 'S50_1514', 38, 60, 10),
(10384, 'S10_4757', 34, 143, 4),
(10384, 'S24_2011', 28, 81, 3),
(10384, 'S24_3151', 43, 98, 2),
(10384, 'S700_1938', 49, 131, 1),
(10385, 'S24_3816', 37, 86, 2),
(10385, 'S700_1138', 25, 77, 1),
(10386, 'S18_1662', 25, 55, 7),
(10386, 'S18_2581', 21, 75, 18),
(10386, 'S18_3029', 37, 93, 5),
(10386, 'S18_3856', 22, 58, 6),
(10386, 'S24_1785', 33, 42, 11),
(10386, 'S24_2841', 39, 56, 1),
(10386, 'S24_3420', 35, 64, 9),
(10386, 'S24_3949', 41, 73, 12),
(10386, 'S24_4278', 50, 63, 8),
(10386, 'S700_2047', 29, 86, 13),
(10386, 'S700_2466', 37, 84, 14),
(10386, 'S700_2610', 37, 136, 10),
(10386, 'S700_3167', 32, 94, 17),
(10386, 'S700_3505', 45, 92, 2),
(10386, 'S700_3962', 30, 95, 3),
(10386, 'S700_4002', 44, 86, 15),
(10386, 'S72_1253', 50, 87, 16);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10386, 'S72_3212', 43, 126, 4),
(10387, 'S32_1374', 44, 95, 1),
(10388, 'S10_1678', 42, 76, 4),
(10388, 'S10_2016', 50, 45, 5),
(10388, 'S10_4698', 21, 87, 7),
(10388, 'S12_2823', 44, 135, 6),
(10388, 'S32_4289', 35, 112, 8),
(10388, 'S50_1341', 27, 119, 1),
(10388, 'S700_1691', 46, 219, 2),
(10388, 'S700_2834', 50, 143, 3),
(10389, 'S12_1099', 26, 99, 4),
(10389, 'S12_3380', 25, 72, 6),
(10389, 'S12_3990', 36, 70, 7),
(10389, 'S12_4675', 47, 112, 8),
(10389, 'S18_1889', 49, 79, 3),
(10389, 'S18_2625', 39, 179, 5),
(10389, 'S24_1578', 45, 102, 1),
(10389, 'S24_2000', 49, 81, 2),
(10390, 'S18_1129', 36, 94, 14),
(10390, 'S18_1984', 34, 43, 15),
(10390, 'S18_2325', 31, 99, 16),
(10390, 'S18_2795', 26, 78, 7),
(10390, 'S18_3278', 40, 137, 9),
(10390, 'S18_3482', 50, 148, 1),
(10390, 'S18_3782', 36, 141, 2),
(10390, 'S18_4721', 49, 140, 3),
(10390, 'S24_2360', 35, 65, 4),
(10390, 'S24_2972', 37, 132, 5),
(10390, 'S24_3371', 46, 53, 6),
(10390, 'S24_3856', 45, 150, 8),
(10390, 'S24_4620', 30, 82, 10),
(10390, 'S32_2206', 41, 45, 11),
(10390, 'S32_4485', 45, 49, 12),
(10390, 'S50_4713', 22, 159, 13),
(10391, 'S10_1949', 24, 101, 4),
(10391, 'S10_4962', 37, 47, 7),
(10391, 'S12_1666', 39, 63, 9),
(10391, 'S18_1097', 29, 85, 10),
(10391, 'S18_1342', 35, 159, 2),
(10391, 'S18_1367', 42, 119, 3),
(10391, 'S18_2432', 44, 39, 5),
(10391, 'S18_2949', 32, 45, 6),
(10391, 'S24_1937', 33, 253, 8),
(10391, 'S24_2022', 24, 168, 1),
(10392, 'S18_2957', 37, 60, 3),
(10392, 'S18_3136', 29, 87, 2),
(10392, 'S18_3320', 36, 112, 1),
(10393, 'S12_3148', 35, 109, 8),
(10393, 'S12_4473', 32, 101, 10),
(10393, 'S18_2238', 20, 70, 11),
(10393, 'S18_2319', 38, 100, 7),
(10393, 'S18_4600', 30, 121, 9),
(10393, 'S18_4668', 44, 110, 1),
(10393, 'S24_2300', 33, 177, 2),
(10393, 'S24_4258', 33, 98, 3),
(10393, 'S32_1268', 38, 145, 4),
(10393, 'S32_3522', 31, 58, 5),
(10393, 'S700_2824', 21, 102, 6),
(10394, 'S18_3232', 22, 152, 5),
(10394, 'S18_4027', 37, 172, 1),
(10394, 'S24_1444', 31, 50, 2),
(10394, 'S24_2840', 46, 39, 6),
(10394, 'S24_4048', 37, 141, 7),
(10394, 'S32_2509', 36, 63, 3),
(10394, 'S32_3207', 30, 60, 4),
(10395, 'S10_4757', 32, 105, 2),
(10395, 'S12_1108', 33, 69, 1),
(10395, 'S50_1392', 46, 124, 4),
(10395, 'S50_1514', 45, 199, 3),
(10396, 'S12_3891', 33, 185, 3),
(10396, 'S18_3140', 33, 160, 2),
(10396, 'S18_3259', 24, 90, 4),
(10396, 'S18_4522', 45, 105, 5),
(10396, 'S24_2011', 49, 117, 6),
(10396, 'S24_3151', 27, 83, 7),
(10396, 'S24_3816', 37, 91, 8),
(10396, 'S700_1138', 39, 67, 1),
(10397, 'S700_1938', 32, 81, 5),
(10397, 'S700_2610', 22, 67, 4),
(10397, 'S700_3505', 48, 108, 3),
(10397, 'S700_3962', 36, 105, 2),
(10397, 'S72_3212', 34, 62, 1),
(10398, 'S18_1662', 33, 128, 11),
(10398, 'S18_2581', 34, 77, 15),
(10398, 'S18_3029', 28, 72, 18),
(10398, 'S18_3856', 45, 107, 17),
(10398, 'S24_1785', 43, 129, 16),
(10398, 'S24_2841', 28, 58, 3),
(10398, 'S24_3420', 34, 72, 13),
(10398, 'S24_3949', 41, 68, 2),
(10398, 'S24_4278', 45, 78, 14),
(10398, 'S32_4289', 22, 67, 4),
(10398, 'S50_1341', 49, 37, 5),
(10398, 'S700_1691', 47, 88, 6),
(10398, 'S700_2047', 36, 109, 7),
(10398, 'S700_2466', 22, 87, 8),
(10398, 'S700_2834', 23, 122, 9),
(10398, 'S700_3167', 29, 66, 10),
(10398, 'S700_4002', 36, 87, 12),
(10398, 'S72_1253', 34, 40, 1),
(10399, 'S10_1678', 40, 114, 8),
(10399, 'S10_2016', 51, 124, 7),
(10399, 'S10_4698', 22, 159, 6),
(10399, 'S12_2823', 29, 164, 5),
(10399, 'S18_2625', 30, 68, 4),
(10399, 'S24_1578', 57, 106, 3),
(10399, 'S24_2000', 58, 89, 2),
(10399, 'S32_1374', 32, 100, 1),
(10400, 'S10_4757', 64, 151, 9),
(10400, 'S18_1662', 34, 189, 1),
(10400, 'S18_3029', 30, 75, 7),
(10400, 'S18_3856', 58, 126, 6),
(10400, 'S24_2841', 24, 62, 2),
(10400, 'S24_3420', 38, 57, 3),
(10400, 'S24_3816', 42, 73, 8),
(10400, 'S700_2047', 46, 88, 5),
(10400, 'S72_1253', 20, 56, 4),
(10401, 'S18_2581', 42, 76, 3),
(10401, 'S24_1785', 38, 96, 5),
(10401, 'S24_3949', 64, 60, 12),
(10401, 'S24_4278', 52, 81, 4),
(10401, 'S32_1374', 49, 102, 1);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10401, 'S32_4289', 62, 78, 6),
(10401, 'S50_1341', 56, 35, 7),
(10401, 'S700_1691', 11, 103, 8),
(10401, 'S700_2466', 85, 89, 10),
(10401, 'S700_2834', 21, 96, 2),
(10401, 'S700_3167', 77, 92, 9),
(10401, 'S700_4002', 28, 73, 11),
(10402, 'S10_2016', 45, 130, 1),
(10402, 'S18_2625', 55, 56, 2),
(10402, 'S24_2000', 59, 88, 3),
(10403, 'S10_1678', 24, 101, 7),
(10403, 'S10_4698', 66, 180, 9),
(10403, 'S12_2823', 66, 131, 6),
(10403, 'S18_3782', 36, 52, 1),
(10403, 'S24_1578', 46, 115, 8),
(10403, 'S24_2360', 27, 80, 4),
(10403, 'S32_2206', 30, 40, 2),
(10403, 'S32_4485', 45, 115, 5),
(10403, 'S50_4713', 31, 68, 3),
(10404, 'S12_1099', 64, 206, 3),
(10404, 'S12_3380', 43, 109, 1),
(10404, 'S12_3990', 77, 74, 4),
(10404, 'S18_3278', 90, 73, 6),
(10404, 'S18_3482', 28, 134, 5),
(10404, 'S18_4721', 48, 144, 8),
(10404, 'S24_3371', 49, 62, 2),
(10404, 'S24_4620', 48, 94, 7),
(10405, 'S12_4675', 97, 93, 5),
(10405, 'S18_1889', 61, 74, 4),
(10405, 'S18_3232', 55, 151, 1),
(10405, 'S24_2972', 47, 45, 2),
(10405, 'S24_3856', 76, 154, 3),
(10406, 'S18_1129', 61, 137, 3),
(10406, 'S18_1984', 48, 149, 2),
(10406, 'S18_3685', 65, 161, 1),
(10407, 'S18_1589', 59, 119, 11),
(10407, 'S18_1749', 76, 185, 2),
(10407, 'S18_2248', 42, 73, 1),
(10407, 'S18_2870', 41, 156, 12),
(10407, 'S18_4409', 6, 90, 3),
(10407, 'S18_4933', 66, 67, 4),
(10407, 'S24_1046', 26, 76, 8),
(10407, 'S24_1628', 64, 40, 10),
(10407, 'S24_2766', 76, 95, 6),
(10407, 'S24_2887', 59, 99, 5),
(10407, 'S24_3191', 13, 81, 7),
(10407, 'S24_3432', 43, 87, 9),
(10408, 'S24_3969', 15, 37, 1),
(10409, 'S18_2325', 6, 131, 2),
(10409, 'S24_1937', 61, 30, 1),
(10410, 'S18_1342', 65, 117, 7),
(10410, 'S18_1367', 44, 58, 6),
(10410, 'S18_2795', 56, 138, 8),
(10410, 'S18_2949', 47, 118, 1),
(10410, 'S18_2957', 53, 58, 3),
(10410, 'S18_3136', 34, 115, 2),
(10410, 'S18_3320', 44, 84, 5),
(10410, 'S24_2022', 31, 45, 9),
(10410, 'S24_4258', 50, 87, 4),
(10411, 'S10_1949', 23, 180, 9),
(10411, 'S10_4962', 27, 164, 2),
(10411, 'S12_1666', 40, 156, 6),
(10411, 'S18_1097', 27, 119, 8),
(10411, 'S18_4600', 46, 114, 3),
(10411, 'S18_4668', 35, 60, 7),
(10411, 'S32_1268', 26, 112, 1),
(10411, 'S32_3522', 27, 69, 5),
(10411, 'S700_2824', 34, 105, 4),
(10412, 'S12_4473', 54, 110, 5),
(10412, 'S18_2238', 41, 164, 4),
(10412, 'S18_2319', 56, 98, 8),
(10412, 'S18_2432', 47, 62, 11),
(10412, 'S18_3232', 60, 198, 9),
(10412, 'S24_1444', 21, 53, 2),
(10412, 'S24_2300', 70, 121, 10),
(10412, 'S24_2840', 30, 36, 6),
(10412, 'S24_4048', 31, 137, 1),
(10412, 'S32_2509', 19, 49, 7),
(10412, 'S50_1392', 26, 133, 3),
(10413, 'S12_1108', 36, 241, 2),
(10413, 'S12_3148', 47, 175, 3),
(10413, 'S12_3891', 22, 154, 1),
(10413, 'S18_4027', 49, 141, 5),
(10413, 'S32_3207', 24, 50, 6),
(10413, 'S50_1514', 51, 64, 4),
(10414, 'S10_4757', 19, 146, 3),
(10414, 'S18_3029', 44, 74, 1),
(10414, 'S18_3140', 41, 119, 12),
(10414, 'S18_3259', 48, 121, 14),
(10414, 'S18_4522', 16, 75, 11),
(10414, 'S24_2011', 23, 145, 10),
(10414, 'S24_3151', 60, 102, 5),
(10414, 'S24_3816', 51, 76, 2),
(10414, 'S700_1138', 37, 71, 6),
(10414, 'S700_1938', 34, 104, 13),
(10414, 'S700_2610', 31, 76, 4),
(10414, 'S700_3505', 28, 108, 7),
(10414, 'S700_3962', 27, 90, 8),
(10414, 'S72_3212', 47, 66, 9),
(10415, 'S18_3856', 51, 122, 5),
(10415, 'S24_2841', 21, 68, 1),
(10415, 'S24_3420', 18, 70, 2),
(10415, 'S700_2047', 32, 96, 4),
(10415, 'S72_1253', 42, 58, 3),
(10416, 'S18_1662', 24, 181, 14),
(10416, 'S18_2581', 15, 99, 4),
(10416, 'S24_1785', 47, 89, 6),
(10416, 'S24_2000', 32, 88, 1),
(10416, 'S24_3949', 18, 75, 13),
(10416, 'S24_4278', 48, 75, 5),
(10416, 'S32_1374', 45, 106, 2),
(10416, 'S32_4289', 26, 61, 7),
(10416, 'S50_1341', 37, 52, 8),
(10416, 'S700_1691', 23, 91, 9),
(10416, 'S700_2466', 22, 112, 11),
(10416, 'S700_2834', 41, 138, 3),
(10416, 'S700_3167', 39, 67, 10),
(10416, 'S700_4002', 43, 62, 12),
(10417, 'S10_1678', 66, 114, 2),
(10417, 'S10_2016', 45, 131, 5),
(10417, 'S10_4698', 56, 165, 4),
(10417, 'S12_2823', 21, 164, 1);
INSERT INTO PUBLIC.ORDERDETAILS(ORDERNUMBER, PRODUCTCODE, QUANTITYORDERED, PRICEEACH, ORDERLINENUMBER) VALUES
(10417, 'S18_2625', 36, 61, 6),
(10417, 'S24_1578', 35, 101, 3),
(10418, 'S18_3278', 16, 76, 2),
(10418, 'S18_3482', 27, 165, 1),
(10418, 'S18_3782', 33, 53, 5),
(10418, 'S18_4721', 28, 137, 4),
(10418, 'S24_2360', 52, 66, 8),
(10418, 'S24_4620', 10, 87, 3),
(10418, 'S32_2206', 43, 48, 6),
(10418, 'S32_4485', 50, 113, 9),
(10418, 'S50_4713', 40, 72, 7),
(10419, 'S12_1099', 12, 163, 13),
(10419, 'S12_3380', 10, 109, 11),
(10419, 'S12_3990', 34, 90, 14),
(10419, 'S12_4675', 32, 120, 10),
(10419, 'S18_1129', 38, 117, 5),
(10419, 'S18_1589', 37, 141, 1),
(10419, 'S18_1889', 39, 84, 9),
(10419, 'S18_1984', 34, 135, 4),
(10419, 'S18_2870', 55, 140, 2),
(10419, 'S18_3232', 35, 169, 6),
(10419, 'S18_3685', 43, 130, 3),
(10419, 'S24_2972', 15, 43, 7),
(10419, 'S24_3371', 55, 53, 12),
(10419, 'S24_3856', 70, 132, 8),
(10420, 'S18_1749', 37, 143, 5),
(10420, 'S18_2248', 36, 64, 4),
(10420, 'S18_2325', 45, 111, 2),
(10420, 'S18_4409', 66, 93, 6),
(10420, 'S18_4933', 36, 58, 7),
(10420, 'S24_1046', 60, 65, 11),
(10420, 'S24_1628', 37, 60, 13),
(10420, 'S24_1937', 45, 27, 1),
(10420, 'S24_2766', 39, 101, 9),
(10420, 'S24_2887', 55, 96, 8),
(10420, 'S24_3191', 35, 97, 10),
(10420, 'S24_3432', 26, 101, 12),
(10420, 'S24_3969', 15, 43, 3),
(10421, 'S18_2795', 35, 155, 1),
(10421, 'S24_2022', 40, 46, 2),
(10422, 'S18_1342', 51, 96, 2),
(10422, 'S18_1367', 25, 52, 1),
(10423, 'S18_2949', 10, 88, 1),
(10423, 'S18_2957', 31, 54, 3),
(10423, 'S18_3136', 21, 85, 2),
(10423, 'S18_3320', 21, 89, 5),
(10423, 'S24_4258', 28, 79, 4),
(10424, 'S10_1949', 50, 240, 6),
(10424, 'S12_1666', 49, 163, 3),
(10424, 'S18_1097', 54, 133, 5),
(10424, 'S18_4668', 26, 60, 4),
(10424, 'S32_3522', 44, 61, 2),
(10424, 'S700_2824', 46, 81, 1),
(10425, 'S10_4962', 38, 155, 12),
(10425, 'S12_4473', 33, 142, 4),
(10425, 'S18_2238', 28, 190, 3),
(10425, 'S18_2319', 38, 99, 7),
(10425, 'S18_2432', 19, 49, 10),
(10425, 'S18_3232', 28, 135, 8),
(10425, 'S18_4600', 38, 114, 13),
(10425, 'S24_1444', 55, 47, 1),
(10425, 'S24_2300', 49, 112, 9),
(10425, 'S24_2840', 31, 33, 5),
(10425, 'S32_1268', 41, 87, 11),
(10425, 'S32_2509', 11, 44, 6),
(10425, 'S50_1392', 18, 105, 2);
DROP TABLE IF EXISTS PUBLIC.ORDERS;
CREATE MEMORY TABLE PUBLIC.ORDERS(
    ORDERNUMBER INTEGER NOT NULL,
    ORDERDATE TIMESTAMP NOT NULL,
    REQUIREDDATE TIMESTAMP NOT NULL,
    SHIPPEDDATE TIMESTAMP,
    STATUS VARCHAR(15) NOT NULL,
    COMMENTS LONGVARCHAR,
    CUSTOMERNUMBER INTEGER NOT NULL
);
ALTER TABLE PUBLIC.ORDERS ADD CONSTRAINT PUBLIC.CONSTRAINT_8 PRIMARY KEY(ORDERNUMBER);
-- 326 +/- SELECT COUNT(*) FROM PUBLIC.ORDERS;
INSERT INTO PUBLIC.ORDERS(ORDERNUMBER, ORDERDATE, REQUIREDDATE, SHIPPEDDATE, STATUS, COMMENTS, CUSTOMERNUMBER) VALUES
(10100, TIMESTAMP '2003-01-06 00:00:00.0', TIMESTAMP '2003-01-13 00:00:00.0', TIMESTAMP '2003-01-10 00:00:00.0', 'Shipped', NULL, 363),
(10101, TIMESTAMP '2003-01-09 00:00:00.0', TIMESTAMP '2003-01-18 00:00:00.0', TIMESTAMP '2003-01-11 00:00:00.0', 'Shipped', 'Check on availability.', 128),
(10102, TIMESTAMP '2003-01-10 00:00:00.0', TIMESTAMP '2003-01-18 00:00:00.0', TIMESTAMP '2003-01-14 00:00:00.0', 'Shipped', NULL, 181),
(10103, TIMESTAMP '2003-01-29 00:00:00.0', TIMESTAMP '2003-02-07 00:00:00.0', TIMESTAMP '2003-02-02 00:00:00.0', 'Shipped', NULL, 121),
(10104, TIMESTAMP '2003-01-31 00:00:00.0', TIMESTAMP '2003-02-09 00:00:00.0', TIMESTAMP '2003-02-01 00:00:00.0', 'Shipped', NULL, 141),
(10105, TIMESTAMP '2003-02-11 00:00:00.0', TIMESTAMP '2003-02-21 00:00:00.0', TIMESTAMP '2003-02-12 00:00:00.0', 'Shipped', NULL, 145),
(10106, TIMESTAMP '2003-02-17 00:00:00.0', TIMESTAMP '2003-02-24 00:00:00.0', TIMESTAMP '2003-02-21 00:00:00.0', 'Shipped', NULL, 278),
(10107, TIMESTAMP '2003-02-24 00:00:00.0', TIMESTAMP '2003-03-03 00:00:00.0', TIMESTAMP '2003-02-26 00:00:00.0', 'Shipped', 'Difficult to negotiate with customer. We need more marketing materials', 131),
(10108, TIMESTAMP '2003-03-03 00:00:00.0', TIMESTAMP '2003-03-12 00:00:00.0', TIMESTAMP '2003-03-08 00:00:00.0', 'Shipped', NULL, 385),
(10109, TIMESTAMP '2003-03-10 00:00:00.0', TIMESTAMP '2003-03-19 00:00:00.0', TIMESTAMP '2003-03-11 00:00:00.0', 'Shipped', 'Customer requested that FedEx Ground is used for this shipping', 486),
(10110, TIMESTAMP '2003-03-18 00:00:00.0', TIMESTAMP '2003-03-24 00:00:00.0', TIMESTAMP '2003-03-20 00:00:00.0', 'Shipped', NULL, 187),
(10111, TIMESTAMP '2003-03-25 00:00:00.0', TIMESTAMP '2003-03-31 00:00:00.0', TIMESTAMP '2003-03-30 00:00:00.0', 'Shipped', NULL, 129),
(10112, TIMESTAMP '2003-03-24 00:00:00.0', TIMESTAMP '2003-04-03 00:00:00.0', TIMESTAMP '2003-03-29 00:00:00.0', 'Shipped', 'Customer requested that ad materials (such as posters, pamphlets) be included in the shippment', 144),
(10113, TIMESTAMP '2003-03-26 00:00:00.0', TIMESTAMP '2003-04-02 00:00:00.0', TIMESTAMP '2003-03-27 00:00:00.0', 'Shipped', NULL, 124),
(10114, TIMESTAMP '2003-04-01 00:00:00.0', TIMESTAMP '2003-04-07 00:00:00.0', TIMESTAMP '2003-04-02 00:00:00.0', 'Shipped', NULL, 172),
(10115, TIMESTAMP '2003-04-04 00:00:00.0', TIMESTAMP '2003-04-12 00:00:00.0', TIMESTAMP '2003-04-07 00:00:00.0', 'Shipped', NULL, 424),
(10116, TIMESTAMP '2003-04-11 00:00:00.0', TIMESTAMP '2003-04-19 00:00:00.0', TIMESTAMP '2003-04-13 00:00:00.0', 'Shipped', NULL, 381),
(10117, TIMESTAMP '2003-04-16 00:00:00.0', TIMESTAMP '2003-04-24 00:00:00.0', TIMESTAMP '2003-04-17 00:00:00.0', 'Shipped', NULL, 148),
(10118, TIMESTAMP '2003-04-21 00:00:00.0', TIMESTAMP '2003-04-29 00:00:00.0', TIMESTAMP '2003-04-26 00:00:00.0', 'Shipped', 'Customer has worked with some of our vendors in the past and is aware of their MSRP', 216),
(10119, TIMESTAMP '2003-04-28 00:00:00.0', TIMESTAMP '2003-05-05 00:00:00.0', TIMESTAMP '2003-05-02 00:00:00.0', 'Shipped', NULL, 382),
(10120, TIMESTAMP '2003-04-29 00:00:00.0', TIMESTAMP '2003-05-08 00:00:00.0', TIMESTAMP '2003-05-01 00:00:00.0', 'Shipped', NULL, 114),
(10121, TIMESTAMP '2003-05-07 00:00:00.0', TIMESTAMP '2003-05-13 00:00:00.0', TIMESTAMP '2003-05-13 00:00:00.0', 'Shipped', NULL, 353),
(10122, TIMESTAMP '2003-05-08 00:00:00.0', TIMESTAMP '2003-05-16 00:00:00.0', TIMESTAMP '2003-05-13 00:00:00.0', 'Shipped', NULL, 350),
(10123, TIMESTAMP '2003-05-20 00:00:00.0', TIMESTAMP '2003-05-29 00:00:00.0', TIMESTAMP '2003-05-22 00:00:00.0', 'Shipped', NULL, 103),
(10124, TIMESTAMP '2003-05-21 00:00:00.0', TIMESTAMP '2003-05-29 00:00:00.0', TIMESTAMP '2003-05-25 00:00:00.0', 'Shipped', 'Customer very concerned about the exact color of the models. There is high risk that he may dispute the order because there is a slight color mismatch', 112),
(10125, TIMESTAMP '2003-05-21 00:00:00.0', TIMESTAMP '2003-05-27 00:00:00.0', TIMESTAMP '2003-05-24 00:00:00.0', 'Shipped', NULL, 114);
INSERT INTO PUBLIC.ORDERS(ORDERNUMBER, ORDERDATE, REQUIREDDATE, SHIPPEDDATE, STATUS, COMMENTS, CUSTOMERNUMBER) VALUES
(10126, TIMESTAMP '2003-05-28 00:00:00.0', TIMESTAMP '2003-06-07 00:00:00.0', TIMESTAMP '2003-06-02 00:00:00.0', 'Shipped', NULL, 458),
(10127, TIMESTAMP '2003-06-03 00:00:00.0', TIMESTAMP '2003-06-09 00:00:00.0', TIMESTAMP '2003-06-06 00:00:00.0', 'Shipped', 'Customer requested special shippment. The instructions were passed along to the warehouse', 151),
(10128, TIMESTAMP '2003-06-06 00:00:00.0', TIMESTAMP '2003-06-12 00:00:00.0', TIMESTAMP '2003-06-11 00:00:00.0', 'Shipped', NULL, 141),
(10129, TIMESTAMP '2003-06-12 00:00:00.0', TIMESTAMP '2003-06-18 00:00:00.0', TIMESTAMP '2003-06-14 00:00:00.0', 'Shipped', NULL, 324),
(10130, TIMESTAMP '2003-06-16 00:00:00.0', TIMESTAMP '2003-06-24 00:00:00.0', TIMESTAMP '2003-06-21 00:00:00.0', 'Shipped', NULL, 198),
(10131, TIMESTAMP '2003-06-16 00:00:00.0', TIMESTAMP '2003-06-25 00:00:00.0', TIMESTAMP '2003-06-21 00:00:00.0', 'Shipped', NULL, 447),
(10132, TIMESTAMP '2003-06-25 00:00:00.0', TIMESTAMP '2003-07-01 00:00:00.0', TIMESTAMP '2003-06-28 00:00:00.0', 'Shipped', NULL, 323),
(10133, TIMESTAMP '2003-06-27 00:00:00.0', TIMESTAMP '2003-07-04 00:00:00.0', TIMESTAMP '2003-07-03 00:00:00.0', 'Shipped', NULL, 141),
(10134, TIMESTAMP '2003-07-01 00:00:00.0', TIMESTAMP '2003-07-10 00:00:00.0', TIMESTAMP '2003-07-05 00:00:00.0', 'Shipped', NULL, 250),
(10135, TIMESTAMP '2003-07-02 00:00:00.0', TIMESTAMP '2003-07-12 00:00:00.0', TIMESTAMP '2003-07-03 00:00:00.0', 'Shipped', NULL, 124),
(10136, TIMESTAMP '2003-07-04 00:00:00.0', TIMESTAMP '2003-07-14 00:00:00.0', TIMESTAMP '2003-07-06 00:00:00.0', 'Shipped', 'Customer is interested in buying more Ferrari models', 242),
(10137, TIMESTAMP '2003-07-10 00:00:00.0', TIMESTAMP '2003-07-20 00:00:00.0', TIMESTAMP '2003-07-14 00:00:00.0', 'Shipped', NULL, 353),
(10138, TIMESTAMP '2003-07-07 00:00:00.0', TIMESTAMP '2003-07-16 00:00:00.0', TIMESTAMP '2003-07-13 00:00:00.0', 'Shipped', NULL, 496),
(10139, TIMESTAMP '2003-07-16 00:00:00.0', TIMESTAMP '2003-07-23 00:00:00.0', TIMESTAMP '2003-07-21 00:00:00.0', 'Shipped', NULL, 282),
(10140, TIMESTAMP '2003-07-24 00:00:00.0', TIMESTAMP '2003-08-02 00:00:00.0', TIMESTAMP '2003-07-30 00:00:00.0', 'Shipped', NULL, 161),
(10141, TIMESTAMP '2003-08-01 00:00:00.0', TIMESTAMP '2003-08-09 00:00:00.0', TIMESTAMP '2003-08-04 00:00:00.0', 'Shipped', NULL, 334),
(10142, TIMESTAMP '2003-08-08 00:00:00.0', TIMESTAMP '2003-08-16 00:00:00.0', TIMESTAMP '2003-08-13 00:00:00.0', 'Shipped', NULL, 124),
(10143, TIMESTAMP '2003-08-10 00:00:00.0', TIMESTAMP '2003-08-18 00:00:00.0', TIMESTAMP '2003-08-12 00:00:00.0', 'Shipped', 'Can we deliver the new Ford Mustang models by end-of-quarter?', 320),
(10144, TIMESTAMP '2003-08-13 00:00:00.0', TIMESTAMP '2003-08-21 00:00:00.0', TIMESTAMP '2003-08-14 00:00:00.0', 'Shipped', NULL, 381),
(10145, TIMESTAMP '2003-08-25 00:00:00.0', TIMESTAMP '2003-09-02 00:00:00.0', TIMESTAMP '2003-08-31 00:00:00.0', 'Shipped', NULL, 205),
(10146, TIMESTAMP '2003-09-03 00:00:00.0', TIMESTAMP '2003-09-13 00:00:00.0', TIMESTAMP '2003-09-06 00:00:00.0', 'Shipped', NULL, 447),
(10147, TIMESTAMP '2003-09-05 00:00:00.0', TIMESTAMP '2003-09-12 00:00:00.0', TIMESTAMP '2003-09-09 00:00:00.0', 'Shipped', NULL, 379),
(10148, TIMESTAMP '2003-09-11 00:00:00.0', TIMESTAMP '2003-09-21 00:00:00.0', TIMESTAMP '2003-09-15 00:00:00.0', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 276),
(10149, TIMESTAMP '2003-09-12 00:00:00.0', TIMESTAMP '2003-09-18 00:00:00.0', TIMESTAMP '2003-09-17 00:00:00.0', 'Shipped', NULL, 487),
(10150, TIMESTAMP '2003-09-19 00:00:00.0', TIMESTAMP '2003-09-27 00:00:00.0', TIMESTAMP '2003-09-21 00:00:00.0', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 148),
(10151, TIMESTAMP '2003-09-21 00:00:00.0', TIMESTAMP '2003-09-30 00:00:00.0', TIMESTAMP '2003-09-24 00:00:00.0', 'Shipped', NULL, 311),
(10152, TIMESTAMP '2003-09-25 00:00:00.0', TIMESTAMP '2003-10-03 00:00:00.0', TIMESTAMP '2003-10-01 00:00:00.0', 'Shipped', NULL, 333);
INSERT INTO PUBLIC.ORDERS(ORDERNUMBER, ORDERDATE, REQUIREDDATE, SHIPPEDDATE, STATUS, COMMENTS, CUSTOMERNUMBER) VALUES
(10153, TIMESTAMP '2003-09-28 00:00:00.0', TIMESTAMP '2003-10-05 00:00:00.0', TIMESTAMP '2003-10-03 00:00:00.0', 'Shipped', NULL, 141),
(10154, TIMESTAMP '2003-10-02 00:00:00.0', TIMESTAMP '2003-10-12 00:00:00.0', TIMESTAMP '2003-10-08 00:00:00.0', 'Shipped', NULL, 219),
(10155, TIMESTAMP '2003-10-06 00:00:00.0', TIMESTAMP '2003-10-13 00:00:00.0', TIMESTAMP '2003-10-07 00:00:00.0', 'Shipped', NULL, 186),
(10156, TIMESTAMP '2003-10-08 00:00:00.0', TIMESTAMP '2003-10-17 00:00:00.0', TIMESTAMP '2003-10-11 00:00:00.0', 'Shipped', NULL, 141),
(10157, TIMESTAMP '2003-10-09 00:00:00.0', TIMESTAMP '2003-10-15 00:00:00.0', TIMESTAMP '2003-10-14 00:00:00.0', 'Shipped', NULL, 473),
(10158, TIMESTAMP '2003-10-10 00:00:00.0', TIMESTAMP '2003-10-18 00:00:00.0', TIMESTAMP '2003-10-15 00:00:00.0', 'Shipped', NULL, 121),
(10159, TIMESTAMP '2003-10-10 00:00:00.0', TIMESTAMP '2003-10-19 00:00:00.0', TIMESTAMP '2003-10-16 00:00:00.0', 'Shipped', NULL, 321),
(10160, TIMESTAMP '2003-10-11 00:00:00.0', TIMESTAMP '2003-10-17 00:00:00.0', TIMESTAMP '2003-10-17 00:00:00.0', 'Shipped', NULL, 347),
(10161, TIMESTAMP '2003-10-17 00:00:00.0', TIMESTAMP '2003-10-25 00:00:00.0', TIMESTAMP '2003-10-20 00:00:00.0', 'Shipped', NULL, 227),
(10162, TIMESTAMP '2003-10-18 00:00:00.0', TIMESTAMP '2003-10-26 00:00:00.0', TIMESTAMP '2003-10-19 00:00:00.0', 'Shipped', NULL, 321),
(10163, TIMESTAMP '2003-10-20 00:00:00.0', TIMESTAMP '2003-10-27 00:00:00.0', TIMESTAMP '2003-10-24 00:00:00.0', 'Shipped', NULL, 424),
(10164, TIMESTAMP '2003-10-21 00:00:00.0', TIMESTAMP '2003-10-30 00:00:00.0', TIMESTAMP '2003-10-23 00:00:00.0', 'Resolved', 'This order was disputed, but resolved on 11/1/2003; Customer doesn''t like the colors and precision of the models.', 452),
(10165, TIMESTAMP '2003-10-22 00:00:00.0', TIMESTAMP '2003-10-31 00:00:00.0', TIMESTAMP '2003-12-26 00:00:00.0', 'Shipped', 'This order was on hold because customers''s credit limit had been exceeded. Order will ship when payment is received', 148),
(10166, TIMESTAMP '2003-10-21 00:00:00.0', TIMESTAMP '2003-10-30 00:00:00.0', TIMESTAMP '2003-10-27 00:00:00.0', 'Shipped', NULL, 462),
(10167, TIMESTAMP '2003-10-23 00:00:00.0', TIMESTAMP '2003-10-30 00:00:00.0', NULL, 'Cancelled', 'Customer called to cancel. The warehouse was notified in time and the order didn''t ship. They have a new VP of Sales and are shifting their sales model. Our VP of Sales should contact them.', 448),
(10168, TIMESTAMP '2003-10-28 00:00:00.0', TIMESTAMP '2003-11-03 00:00:00.0', TIMESTAMP '2003-11-01 00:00:00.0', 'Shipped', NULL, 161),
(10169, TIMESTAMP '2003-11-04 00:00:00.0', TIMESTAMP '2003-11-14 00:00:00.0', TIMESTAMP '2003-11-09 00:00:00.0', 'Shipped', NULL, 276),
(10170, TIMESTAMP '2003-11-04 00:00:00.0', TIMESTAMP '2003-11-12 00:00:00.0', TIMESTAMP '2003-11-07 00:00:00.0', 'Shipped', NULL, 452),
(10171, TIMESTAMP '2003-11-05 00:00:00.0', TIMESTAMP '2003-11-13 00:00:00.0', TIMESTAMP '2003-11-07 00:00:00.0', 'Shipped', NULL, 233),
(10172, TIMESTAMP '2003-11-05 00:00:00.0', TIMESTAMP '2003-11-14 00:00:00.0', TIMESTAMP '2003-11-11 00:00:00.0', 'Shipped', NULL, 175),
(10173, TIMESTAMP '2003-11-05 00:00:00.0', TIMESTAMP '2003-11-15 00:00:00.0', TIMESTAMP '2003-11-09 00:00:00.0', 'Shipped', 'Cautious optimism. We have happy customers here, if we can keep them well stocked.  I need all the information I can get on the planned shippments of Porches', 278),
(10174, TIMESTAMP '2003-11-06 00:00:00.0', TIMESTAMP '2003-11-15 00:00:00.0', TIMESTAMP '2003-11-10 00:00:00.0', 'Shipped', NULL, 333),
(10175, TIMESTAMP '2003-11-06 00:00:00.0', TIMESTAMP '2003-11-14 00:00:00.0', TIMESTAMP '2003-11-09 00:00:00.0', 'Shipped', NULL, 324),
(10176, TIMESTAMP '2003-11-06 00:00:00.0', TIMESTAMP '2003-11-15 00:00:00.0', TIMESTAMP '2003-11-12 00:00:00.0', 'Shipped', NULL, 386),
(10177, TIMESTAMP '2003-11-07 00:00:00.0', TIMESTAMP '2003-11-17 00:00:00.0', TIMESTAMP '2003-11-12 00:00:00.0', 'Shipped', NULL, 344),
(10178, TIMESTAMP '2003-11-08 00:00:00.0', TIMESTAMP '2003-11-16 00:00:00.0', TIMESTAMP '2003-11-10 00:00:00.0', 'Shipped', 'Custom shipping instructions sent to warehouse', 242);
INSERT INTO PUBLIC.ORDERS(ORDERNUMBER, ORDERDATE, REQUIREDDATE, SHIPPEDDATE, STATUS, COMMENTS, CUSTOMERNUMBER) VALUES
(10179, TIMESTAMP '2003-11-11 00:00:00.0', TIMESTAMP '2003-11-17 00:00:00.0', TIMESTAMP '2003-11-13 00:00:00.0', 'Cancelled', 'Customer cancelled due to urgent budgeting issues. Must be cautious when dealing with them in the future. Since order shipped already we must discuss who would cover the shipping charges.', 496),
(10180, TIMESTAMP '2003-11-11 00:00:00.0', TIMESTAMP '2003-11-19 00:00:00.0', TIMESTAMP '2003-11-14 00:00:00.0', 'Shipped', NULL, 171),
(10181, TIMESTAMP '2003-11-12 00:00:00.0', TIMESTAMP '2003-11-19 00:00:00.0', TIMESTAMP '2003-11-15 00:00:00.0', 'Shipped', NULL, 167),
(10182, TIMESTAMP '2003-11-12 00:00:00.0', TIMESTAMP '2003-11-21 00:00:00.0', TIMESTAMP '2003-11-18 00:00:00.0', 'Shipped', NULL, 124),
(10183, TIMESTAMP '2003-11-13 00:00:00.0', TIMESTAMP '2003-11-22 00:00:00.0', TIMESTAMP '2003-11-15 00:00:00.0', 'Shipped', 'We need to keep in close contact with their Marketing VP. He is the decision maker for all their purchases.', 339),
(10184, TIMESTAMP '2003-11-14 00:00:00.0', TIMESTAMP '2003-11-22 00:00:00.0', TIMESTAMP '2003-11-20 00:00:00.0', 'Shipped', NULL, 484),
(10185, TIMESTAMP '2003-11-14 00:00:00.0', TIMESTAMP '2003-11-21 00:00:00.0', TIMESTAMP '2003-11-20 00:00:00.0', 'Shipped', NULL, 320),
(10186, TIMESTAMP '2003-11-14 00:00:00.0', TIMESTAMP '2003-11-20 00:00:00.0', TIMESTAMP '2003-11-18 00:00:00.0', 'Shipped', 'They want to reevaluate their terms agreement with the VP of Sales', 489),
(10187, TIMESTAMP '2003-11-15 00:00:00.0', TIMESTAMP '2003-11-24 00:00:00.0', TIMESTAMP '2003-11-16 00:00:00.0', 'Shipped', NULL, 211),
(10188, TIMESTAMP '2003-11-18 00:00:00.0', TIMESTAMP '2003-11-26 00:00:00.0', TIMESTAMP '2003-11-24 00:00:00.0', 'Shipped', NULL, 167),
(10189, TIMESTAMP '2003-11-18 00:00:00.0', TIMESTAMP '2003-11-25 00:00:00.0', TIMESTAMP '2003-11-24 00:00:00.0', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 205),
(10190, TIMESTAMP '2003-11-19 00:00:00.0', TIMESTAMP '2003-11-29 00:00:00.0', TIMESTAMP '2003-11-20 00:00:00.0', 'Shipped', NULL, 141),
(10191, TIMESTAMP '2003-11-20 00:00:00.0', TIMESTAMP '2003-11-30 00:00:00.0', TIMESTAMP '2003-11-24 00:00:00.0', 'Shipped', 'We must be cautions with this customer. Their VP of Sales resigned. Company may be heading down.', 259),
(10192, TIMESTAMP '2003-11-20 00:00:00.0', TIMESTAMP '2003-11-29 00:00:00.0', TIMESTAMP '2003-11-25 00:00:00.0', 'Shipped', NULL, 363),
(10193, TIMESTAMP '2003-11-21 00:00:00.0', TIMESTAMP '2003-11-28 00:00:00.0', TIMESTAMP '2003-11-27 00:00:00.0', 'Shipped', NULL, 471),
(10194, TIMESTAMP '2003-11-25 00:00:00.0', TIMESTAMP '2003-12-02 00:00:00.0', TIMESTAMP '2003-11-26 00:00:00.0', 'Shipped', NULL, 146),
(10195, TIMESTAMP '2003-11-25 00:00:00.0', TIMESTAMP '2003-12-01 00:00:00.0', TIMESTAMP '2003-11-28 00:00:00.0', 'Shipped', NULL, 319),
(10196, TIMESTAMP '2003-11-26 00:00:00.0', TIMESTAMP '2003-12-03 00:00:00.0', TIMESTAMP '2003-12-01 00:00:00.0', 'Shipped', NULL, 455),
(10197, TIMESTAMP '2003-11-26 00:00:00.0', TIMESTAMP '2003-12-02 00:00:00.0', TIMESTAMP '2003-12-01 00:00:00.0', 'Shipped', 'Customer inquired about remote controlled models and gold models.', 216),
(10198, TIMESTAMP '2003-11-27 00:00:00.0', TIMESTAMP '2003-12-06 00:00:00.0', TIMESTAMP '2003-12-03 00:00:00.0', 'Shipped', NULL, 385),
(10199, TIMESTAMP '2003-12-01 00:00:00.0', TIMESTAMP '2003-12-10 00:00:00.0', TIMESTAMP '2003-12-06 00:00:00.0', 'Shipped', NULL, 475),
(10200, TIMESTAMP '2003-12-01 00:00:00.0', TIMESTAMP '2003-12-09 00:00:00.0', TIMESTAMP '2003-12-06 00:00:00.0', 'Shipped', NULL, 211),
(10201, TIMESTAMP '2003-12-01 00:00:00.0', TIMESTAMP '2003-12-11 00:00:00.0', TIMESTAMP '2003-12-02 00:00:00.0', 'Shipped', NULL, 129),
(10202, TIMESTAMP '2003-12-02 00:00:00.0', TIMESTAMP '2003-12-09 00:00:00.0', TIMESTAMP '2003-12-06 00:00:00.0', 'Shipped', NULL, 357),
(10203, TIMESTAMP '2003-12-02 00:00:00.0', TIMESTAMP '2003-12-11 00:00:00.0', TIMESTAMP '2003-12-07 00:00:00.0', 'Shipped', NULL, 141),
(10204, TIMESTAMP '2003-12-02 00:00:00.0', TIMESTAMP '2003-12-10 00:00:00.0', TIMESTAMP '2003-12-04 00:00:00.0', 'Shipped', NULL, 151);
INSERT INTO PUBLIC.ORDERS(ORDERNUMBER, ORDERDATE, REQUIREDDATE, SHIPPEDDATE, STATUS, COMMENTS, CUSTOMERNUMBER) VALUES
(10205, TIMESTAMP '2003-12-03 00:00:00.0', TIMESTAMP '2003-12-09 00:00:00.0', TIMESTAMP '2003-12-07 00:00:00.0', 'Shipped', ' I need all the information I can get on our competitors.', 141),
(10206, TIMESTAMP '2003-12-05 00:00:00.0', TIMESTAMP '2003-12-13 00:00:00.0', TIMESTAMP '2003-12-08 00:00:00.0', 'Shipped', 'Can we renegotiate this one?', 202),
(10207, TIMESTAMP '2003-12-09 00:00:00.0', TIMESTAMP '2003-12-17 00:00:00.0', TIMESTAMP '2003-12-11 00:00:00.0', 'Shipped', 'Check on availability.', 495),
(10208, TIMESTAMP '2004-01-02 00:00:00.0', TIMESTAMP '2004-01-11 00:00:00.0', TIMESTAMP '2004-01-04 00:00:00.0', 'Shipped', NULL, 146),
(10209, TIMESTAMP '2004-01-09 00:00:00.0', TIMESTAMP '2004-01-15 00:00:00.0', TIMESTAMP '2004-01-12 00:00:00.0', 'Shipped', NULL, 347),
(10210, TIMESTAMP '2004-01-12 00:00:00.0', TIMESTAMP '2004-01-22 00:00:00.0', TIMESTAMP '2004-01-20 00:00:00.0', 'Shipped', NULL, 177),
(10211, TIMESTAMP '2004-01-15 00:00:00.0', TIMESTAMP '2004-01-25 00:00:00.0', TIMESTAMP '2004-01-18 00:00:00.0', 'Shipped', NULL, 406),
(10212, TIMESTAMP '2004-01-16 00:00:00.0', TIMESTAMP '2004-01-24 00:00:00.0', TIMESTAMP '2004-01-18 00:00:00.0', 'Shipped', NULL, 141),
(10213, TIMESTAMP '2004-01-22 00:00:00.0', TIMESTAMP '2004-01-28 00:00:00.0', TIMESTAMP '2004-01-27 00:00:00.0', 'Shipped', 'Difficult to negotiate with customer. We need more marketing materials', 489),
(10214, TIMESTAMP '2004-01-26 00:00:00.0', TIMESTAMP '2004-02-04 00:00:00.0', TIMESTAMP '2004-01-29 00:00:00.0', 'Shipped', NULL, 458),
(10215, TIMESTAMP '2004-01-29 00:00:00.0', TIMESTAMP '2004-02-08 00:00:00.0', TIMESTAMP '2004-02-01 00:00:00.0', 'Shipped', 'Customer requested that FedEx Ground is used for this shipping', 475),
(10216, TIMESTAMP '2004-02-02 00:00:00.0', TIMESTAMP '2004-02-10 00:00:00.0', TIMESTAMP '2004-02-04 00:00:00.0', 'Shipped', NULL, 256),
(10217, TIMESTAMP '2004-02-04 00:00:00.0', TIMESTAMP '2004-02-14 00:00:00.0', TIMESTAMP '2004-02-06 00:00:00.0', 'Shipped', NULL, 166),
(10218, TIMESTAMP '2004-02-09 00:00:00.0', TIMESTAMP '2004-02-16 00:00:00.0', TIMESTAMP '2004-02-11 00:00:00.0', 'Shipped', 'Customer requested that ad materials (such as posters, pamphlets) be included in the shippment', 473),
(10219, TIMESTAMP '2004-02-10 00:00:00.0', TIMESTAMP '2004-02-17 00:00:00.0', TIMESTAMP '2004-02-12 00:00:00.0', 'Shipped', NULL, 487),
(10220, TIMESTAMP '2004-02-12 00:00:00.0', TIMESTAMP '2004-02-19 00:00:00.0', TIMESTAMP '2004-02-16 00:00:00.0', 'Shipped', NULL, 189),
(10221, TIMESTAMP '2004-02-18 00:00:00.0', TIMESTAMP '2004-02-26 00:00:00.0', TIMESTAMP '2004-02-19 00:00:00.0', 'Shipped', NULL, 314),
(10222, TIMESTAMP '2004-02-19 00:00:00.0', TIMESTAMP '2004-02-27 00:00:00.0', TIMESTAMP '2004-02-20 00:00:00.0', 'Shipped', NULL, 239),
(10223, TIMESTAMP '2004-02-20 00:00:00.0', TIMESTAMP '2004-02-29 00:00:00.0', TIMESTAMP '2004-02-24 00:00:00.0', 'Shipped', NULL, 114),
(10224, TIMESTAMP '2004-02-21 00:00:00.0', TIMESTAMP '2004-03-02 00:00:00.0', TIMESTAMP '2004-02-26 00:00:00.0', 'Shipped', 'Customer has worked with some of our vendors in the past and is aware of their MSRP', 171),
(10225, TIMESTAMP '2004-02-22 00:00:00.0', TIMESTAMP '2004-03-01 00:00:00.0', TIMESTAMP '2004-02-24 00:00:00.0', 'Shipped', NULL, 298),
(10226, TIMESTAMP '2004-02-26 00:00:00.0', TIMESTAMP '2004-03-06 00:00:00.0', TIMESTAMP '2004-03-02 00:00:00.0', 'Shipped', NULL, 239),
(10227, TIMESTAMP '2004-03-02 00:00:00.0', TIMESTAMP '2004-03-12 00:00:00.0', TIMESTAMP '2004-03-08 00:00:00.0', 'Shipped', NULL, 146),
(10228, TIMESTAMP '2004-03-10 00:00:00.0', TIMESTAMP '2004-03-18 00:00:00.0', TIMESTAMP '2004-03-13 00:00:00.0', 'Shipped', NULL, 173),
(10229, TIMESTAMP '2004-03-11 00:00:00.0', TIMESTAMP '2004-03-20 00:00:00.0', TIMESTAMP '2004-03-12 00:00:00.0', 'Shipped', NULL, 124),
(10230, TIMESTAMP '2004-03-15 00:00:00.0', TIMESTAMP '2004-03-24 00:00:00.0', TIMESTAMP '2004-03-20 00:00:00.0', 'Shipped', 'Customer very concerned about the exact color of the models. There is high risk that he may dispute the order because there is a slight color mismatch', 128);
INSERT INTO PUBLIC.ORDERS(ORDERNUMBER, ORDERDATE, REQUIREDDATE, SHIPPEDDATE, STATUS, COMMENTS, CUSTOMERNUMBER) VALUES
(10231, TIMESTAMP '2004-03-19 00:00:00.0', TIMESTAMP '2004-03-26 00:00:00.0', TIMESTAMP '2004-03-25 00:00:00.0', 'Shipped', NULL, 344),
(10232, TIMESTAMP '2004-03-20 00:00:00.0', TIMESTAMP '2004-03-30 00:00:00.0', TIMESTAMP '2004-03-25 00:00:00.0', 'Shipped', NULL, 240),
(10233, TIMESTAMP '2004-03-29 00:00:00.0', TIMESTAMP '2004-04-04 00:00:00.0', TIMESTAMP '2004-04-02 00:00:00.0', 'Shipped', 'Customer requested special shippment. The instructions were passed along to the warehouse', 328),
(10234, TIMESTAMP '2004-03-30 00:00:00.0', TIMESTAMP '2004-04-05 00:00:00.0', TIMESTAMP '2004-04-02 00:00:00.0', 'Shipped', NULL, 412),
(10235, TIMESTAMP '2004-04-02 00:00:00.0', TIMESTAMP '2004-04-12 00:00:00.0', TIMESTAMP '2004-04-06 00:00:00.0', 'Shipped', NULL, 260),
(10236, TIMESTAMP '2004-04-03 00:00:00.0', TIMESTAMP '2004-04-11 00:00:00.0', TIMESTAMP '2004-04-08 00:00:00.0', 'Shipped', NULL, 486),
(10237, TIMESTAMP '2004-04-05 00:00:00.0', TIMESTAMP '2004-04-12 00:00:00.0', TIMESTAMP '2004-04-10 00:00:00.0', 'Shipped', NULL, 181),
(10238, TIMESTAMP '2004-04-09 00:00:00.0', TIMESTAMP '2004-04-16 00:00:00.0', TIMESTAMP '2004-04-10 00:00:00.0', 'Shipped', NULL, 145),
(10239, TIMESTAMP '2004-04-12 00:00:00.0', TIMESTAMP '2004-04-21 00:00:00.0', TIMESTAMP '2004-04-17 00:00:00.0', 'Shipped', NULL, 311),
(10240, TIMESTAMP '2004-04-13 00:00:00.0', TIMESTAMP '2004-04-20 00:00:00.0', TIMESTAMP '2004-04-20 00:00:00.0', 'Shipped', NULL, 177),
(10241, TIMESTAMP '2004-04-13 00:00:00.0', TIMESTAMP '2004-04-20 00:00:00.0', TIMESTAMP '2004-04-19 00:00:00.0', 'Shipped', NULL, 209),
(10242, TIMESTAMP '2004-04-20 00:00:00.0', TIMESTAMP '2004-04-28 00:00:00.0', TIMESTAMP '2004-04-25 00:00:00.0', 'Shipped', 'Customer is interested in buying more Ferrari models', 456),
(10243, TIMESTAMP '2004-04-26 00:00:00.0', TIMESTAMP '2004-05-03 00:00:00.0', TIMESTAMP '2004-04-28 00:00:00.0', 'Shipped', NULL, 495),
(10244, TIMESTAMP '2004-04-29 00:00:00.0', TIMESTAMP '2004-05-09 00:00:00.0', TIMESTAMP '2004-05-04 00:00:00.0', 'Shipped', NULL, 141),
(10245, TIMESTAMP '2004-05-04 00:00:00.0', TIMESTAMP '2004-05-12 00:00:00.0', TIMESTAMP '2004-05-09 00:00:00.0', 'Shipped', NULL, 455),
(10246, TIMESTAMP '2004-05-05 00:00:00.0', TIMESTAMP '2004-05-13 00:00:00.0', TIMESTAMP '2004-05-06 00:00:00.0', 'Shipped', NULL, 141),
(10247, TIMESTAMP '2004-05-05 00:00:00.0', TIMESTAMP '2004-05-11 00:00:00.0', TIMESTAMP '2004-05-08 00:00:00.0', 'Shipped', NULL, 334),
(10248, TIMESTAMP '2004-05-07 00:00:00.0', TIMESTAMP '2004-05-14 00:00:00.0', NULL, 'Cancelled', 'Order was mistakenly placed. The warehouse noticed the lack of documentation.', 131),
(10249, TIMESTAMP '2004-05-08 00:00:00.0', TIMESTAMP '2004-05-17 00:00:00.0', TIMESTAMP '2004-05-11 00:00:00.0', 'Shipped', 'Can we deliver the new Ford Mustang models by end-of-quarter?', 173),
(10250, TIMESTAMP '2004-05-11 00:00:00.0', TIMESTAMP '2004-05-19 00:00:00.0', TIMESTAMP '2004-05-15 00:00:00.0', 'Shipped', NULL, 450),
(10251, TIMESTAMP '2004-05-18 00:00:00.0', TIMESTAMP '2004-05-24 00:00:00.0', TIMESTAMP '2004-05-24 00:00:00.0', 'Shipped', NULL, 328),
(10252, TIMESTAMP '2004-05-26 00:00:00.0', TIMESTAMP '2004-06-04 00:00:00.0', TIMESTAMP '2004-05-29 00:00:00.0', 'Shipped', NULL, 406),
(10253, TIMESTAMP '2004-06-01 00:00:00.0', TIMESTAMP '2004-06-09 00:00:00.0', TIMESTAMP '2004-06-02 00:00:00.0', 'Cancelled', 'Customer disputed the order and we agreed to cancel it. We must be more cautions with this customer going forward, since they are very hard to please. We must cover the shipping fees.', 201),
(10254, TIMESTAMP '2004-06-03 00:00:00.0', TIMESTAMP '2004-06-13 00:00:00.0', TIMESTAMP '2004-06-04 00:00:00.0', 'Shipped', 'Customer requested that DHL is used for this shipping', 323),
(10255, TIMESTAMP '2004-06-04 00:00:00.0', TIMESTAMP '2004-06-12 00:00:00.0', TIMESTAMP '2004-06-09 00:00:00.0', 'Shipped', NULL, 209),
(10256, TIMESTAMP '2004-06-08 00:00:00.0', TIMESTAMP '2004-06-16 00:00:00.0', TIMESTAMP '2004-06-10 00:00:00.0', 'Shipped', NULL, 145);
INSERT INTO PUBLIC.ORDERS(ORDERNUMBER, ORDERDATE, REQUIREDDATE, SHIPPEDDATE, STATUS, COMMENTS, CUSTOMERNUMBER) VALUES
(10257, TIMESTAMP '2004-06-14 00:00:00.0', TIMESTAMP '2004-06-24 00:00:00.0', TIMESTAMP '2004-06-15 00:00:00.0', 'Shipped', NULL, 450),
(10258, TIMESTAMP '2004-06-15 00:00:00.0', TIMESTAMP '2004-06-25 00:00:00.0', TIMESTAMP '2004-06-23 00:00:00.0', 'Shipped', NULL, 398),
(10259, TIMESTAMP '2004-06-15 00:00:00.0', TIMESTAMP '2004-06-22 00:00:00.0', TIMESTAMP '2004-06-17 00:00:00.0', 'Shipped', NULL, 166),
(10260, TIMESTAMP '2004-06-16 00:00:00.0', TIMESTAMP '2004-06-22 00:00:00.0', NULL, 'Cancelled', 'Customer heard complaints from their customers and called to cancel this order. Will notify the Sales Manager.', 357),
(10261, TIMESTAMP '2004-06-17 00:00:00.0', TIMESTAMP '2004-06-25 00:00:00.0', TIMESTAMP '2004-06-22 00:00:00.0', 'Shipped', NULL, 233),
(10262, TIMESTAMP '2004-06-24 00:00:00.0', TIMESTAMP '2004-07-01 00:00:00.0', NULL, 'Cancelled', 'This customer found a better offer from one of our competitors. Will call back to renegotiate.', 141),
(10263, TIMESTAMP '2004-06-28 00:00:00.0', TIMESTAMP '2004-07-04 00:00:00.0', TIMESTAMP '2004-07-02 00:00:00.0', 'Shipped', NULL, 175),
(10264, TIMESTAMP '2004-06-30 00:00:00.0', TIMESTAMP '2004-07-06 00:00:00.0', TIMESTAMP '2004-07-01 00:00:00.0', 'Shipped', 'Customer will send a truck to our local warehouse on 7/1/2004', 362),
(10265, TIMESTAMP '2004-07-02 00:00:00.0', TIMESTAMP '2004-07-09 00:00:00.0', TIMESTAMP '2004-07-07 00:00:00.0', 'Shipped', NULL, 471),
(10266, TIMESTAMP '2004-07-06 00:00:00.0', TIMESTAMP '2004-07-14 00:00:00.0', TIMESTAMP '2004-07-10 00:00:00.0', 'Shipped', NULL, 386),
(10267, TIMESTAMP '2004-07-07 00:00:00.0', TIMESTAMP '2004-07-17 00:00:00.0', TIMESTAMP '2004-07-09 00:00:00.0', 'Shipped', NULL, 151),
(10268, TIMESTAMP '2004-07-12 00:00:00.0', TIMESTAMP '2004-07-18 00:00:00.0', TIMESTAMP '2004-07-14 00:00:00.0', 'Shipped', NULL, 412),
(10269, TIMESTAMP '2004-07-16 00:00:00.0', TIMESTAMP '2004-07-22 00:00:00.0', TIMESTAMP '2004-07-18 00:00:00.0', 'Shipped', NULL, 382),
(10270, TIMESTAMP '2004-07-19 00:00:00.0', TIMESTAMP '2004-07-27 00:00:00.0', TIMESTAMP '2004-07-24 00:00:00.0', 'Shipped', 'Can we renegotiate this one?', 282),
(10271, TIMESTAMP '2004-07-20 00:00:00.0', TIMESTAMP '2004-07-29 00:00:00.0', TIMESTAMP '2004-07-23 00:00:00.0', 'Shipped', NULL, 124),
(10272, TIMESTAMP '2004-07-20 00:00:00.0', TIMESTAMP '2004-07-26 00:00:00.0', TIMESTAMP '2004-07-22 00:00:00.0', 'Shipped', NULL, 157),
(10273, TIMESTAMP '2004-07-21 00:00:00.0', TIMESTAMP '2004-07-28 00:00:00.0', TIMESTAMP '2004-07-22 00:00:00.0', 'Shipped', NULL, 314),
(10274, TIMESTAMP '2004-07-21 00:00:00.0', TIMESTAMP '2004-07-29 00:00:00.0', TIMESTAMP '2004-07-22 00:00:00.0', 'Shipped', NULL, 379),
(10275, TIMESTAMP '2004-07-23 00:00:00.0', TIMESTAMP '2004-08-02 00:00:00.0', TIMESTAMP '2004-07-29 00:00:00.0', 'Shipped', NULL, 119),
(10276, TIMESTAMP '2004-08-02 00:00:00.0', TIMESTAMP '2004-08-11 00:00:00.0', TIMESTAMP '2004-08-08 00:00:00.0', 'Shipped', NULL, 204),
(10277, TIMESTAMP '2004-08-04 00:00:00.0', TIMESTAMP '2004-08-12 00:00:00.0', TIMESTAMP '2004-08-05 00:00:00.0', 'Shipped', NULL, 148),
(10278, TIMESTAMP '2004-08-06 00:00:00.0', TIMESTAMP '2004-08-16 00:00:00.0', TIMESTAMP '2004-08-09 00:00:00.0', 'Shipped', NULL, 112),
(10279, TIMESTAMP '2004-08-09 00:00:00.0', TIMESTAMP '2004-08-19 00:00:00.0', TIMESTAMP '2004-08-15 00:00:00.0', 'Shipped', 'Cautious optimism. We have happy customers here, if we can keep them well stocked.  I need all the information I can get on the planned shippments of Porches', 141),
(10280, TIMESTAMP '2004-08-17 00:00:00.0', TIMESTAMP '2004-08-27 00:00:00.0', TIMESTAMP '2004-08-19 00:00:00.0', 'Shipped', NULL, 249),
(10281, TIMESTAMP '2004-08-19 00:00:00.0', TIMESTAMP '2004-08-28 00:00:00.0', TIMESTAMP '2004-08-23 00:00:00.0', 'Shipped', NULL, 157),
(10282, TIMESTAMP '2004-08-20 00:00:00.0', TIMESTAMP '2004-08-26 00:00:00.0', TIMESTAMP '2004-08-22 00:00:00.0', 'Shipped', NULL, 124),
(10283, TIMESTAMP '2004-08-20 00:00:00.0', TIMESTAMP '2004-08-30 00:00:00.0', TIMESTAMP '2004-08-23 00:00:00.0', 'Shipped', NULL, 260);
INSERT INTO PUBLIC.ORDERS(ORDERNUMBER, ORDERDATE, REQUIREDDATE, SHIPPEDDATE, STATUS, COMMENTS, CUSTOMERNUMBER) VALUES
(10284, TIMESTAMP '2004-08-21 00:00:00.0', TIMESTAMP '2004-08-29 00:00:00.0', TIMESTAMP '2004-08-26 00:00:00.0', 'Shipped', 'Custom shipping instructions sent to warehouse', 299),
(10285, TIMESTAMP '2004-08-27 00:00:00.0', TIMESTAMP '2004-09-04 00:00:00.0', TIMESTAMP '2004-08-31 00:00:00.0', 'Shipped', NULL, 286),
(10286, TIMESTAMP '2004-08-28 00:00:00.0', TIMESTAMP '2004-09-06 00:00:00.0', TIMESTAMP '2004-09-01 00:00:00.0', 'Shipped', NULL, 172),
(10287, TIMESTAMP '2004-08-30 00:00:00.0', TIMESTAMP '2004-09-06 00:00:00.0', TIMESTAMP '2004-09-01 00:00:00.0', 'Shipped', NULL, 298),
(10288, TIMESTAMP '2004-09-01 00:00:00.0', TIMESTAMP '2004-09-11 00:00:00.0', TIMESTAMP '2004-09-05 00:00:00.0', 'Shipped', NULL, 166),
(10289, TIMESTAMP '2004-09-03 00:00:00.0', TIMESTAMP '2004-09-13 00:00:00.0', TIMESTAMP '2004-09-04 00:00:00.0', 'Shipped', 'We need to keep in close contact with their Marketing VP. He is the decision maker for all their purchases.', 167),
(10290, TIMESTAMP '2004-09-07 00:00:00.0', TIMESTAMP '2004-09-15 00:00:00.0', TIMESTAMP '2004-09-13 00:00:00.0', 'Shipped', NULL, 198),
(10291, TIMESTAMP '2004-09-08 00:00:00.0', TIMESTAMP '2004-09-17 00:00:00.0', TIMESTAMP '2004-09-14 00:00:00.0', 'Shipped', NULL, 448),
(10292, TIMESTAMP '2004-09-08 00:00:00.0', TIMESTAMP '2004-09-18 00:00:00.0', TIMESTAMP '2004-09-11 00:00:00.0', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 131),
(10293, TIMESTAMP '2004-09-09 00:00:00.0', TIMESTAMP '2004-09-18 00:00:00.0', TIMESTAMP '2004-09-14 00:00:00.0', 'Shipped', NULL, 249),
(10294, TIMESTAMP '2004-09-10 00:00:00.0', TIMESTAMP '2004-09-17 00:00:00.0', TIMESTAMP '2004-09-14 00:00:00.0', 'Shipped', NULL, 204),
(10295, TIMESTAMP '2004-09-10 00:00:00.0', TIMESTAMP '2004-09-17 00:00:00.0', TIMESTAMP '2004-09-14 00:00:00.0', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 362),
(10296, TIMESTAMP '2004-09-15 00:00:00.0', TIMESTAMP '2004-09-22 00:00:00.0', TIMESTAMP '2004-09-16 00:00:00.0', 'Shipped', NULL, 415),
(10297, TIMESTAMP '2004-09-16 00:00:00.0', TIMESTAMP '2004-09-22 00:00:00.0', TIMESTAMP '2004-09-21 00:00:00.0', 'Shipped', 'We must be cautions with this customer. Their VP of Sales resigned. Company may be heading down.', 189),
(10298, TIMESTAMP '2004-09-27 00:00:00.0', TIMESTAMP '2004-10-05 00:00:00.0', TIMESTAMP '2004-10-01 00:00:00.0', 'Shipped', NULL, 103),
(10299, TIMESTAMP '2004-09-30 00:00:00.0', TIMESTAMP '2004-10-10 00:00:00.0', TIMESTAMP '2004-10-01 00:00:00.0', 'Shipped', NULL, 186),
(10300, TIMESTAMP '2003-10-04 00:00:00.0', TIMESTAMP '2003-10-13 00:00:00.0', TIMESTAMP '2003-10-09 00:00:00.0', 'Shipped', NULL, 128),
(10301, TIMESTAMP '2003-10-05 00:00:00.0', TIMESTAMP '2003-10-15 00:00:00.0', TIMESTAMP '2003-10-08 00:00:00.0', 'Shipped', NULL, 299),
(10302, TIMESTAMP '2003-10-06 00:00:00.0', TIMESTAMP '2003-10-16 00:00:00.0', TIMESTAMP '2003-10-07 00:00:00.0', 'Shipped', NULL, 201),
(10303, TIMESTAMP '2004-10-06 00:00:00.0', TIMESTAMP '2004-10-14 00:00:00.0', TIMESTAMP '2004-10-09 00:00:00.0', 'Shipped', 'Customer inquired about remote controlled models and gold models.', 484),
(10304, TIMESTAMP '2004-10-11 00:00:00.0', TIMESTAMP '2004-10-20 00:00:00.0', TIMESTAMP '2004-10-17 00:00:00.0', 'Shipped', NULL, 256),
(10305, TIMESTAMP '2004-10-13 00:00:00.0', TIMESTAMP '2004-10-22 00:00:00.0', TIMESTAMP '2004-10-15 00:00:00.0', 'Shipped', 'Check on availability.', 286),
(10306, TIMESTAMP '2004-10-14 00:00:00.0', TIMESTAMP '2004-10-21 00:00:00.0', TIMESTAMP '2004-10-17 00:00:00.0', 'Shipped', NULL, 187),
(10307, TIMESTAMP '2004-10-14 00:00:00.0', TIMESTAMP '2004-10-23 00:00:00.0', TIMESTAMP '2004-10-20 00:00:00.0', 'Shipped', NULL, 339),
(10308, TIMESTAMP '2004-10-15 00:00:00.0', TIMESTAMP '2004-10-24 00:00:00.0', TIMESTAMP '2004-10-20 00:00:00.0', 'Shipped', 'Customer requested that FedEx Ground is used for this shipping', 319),
(10309, TIMESTAMP '2004-10-15 00:00:00.0', TIMESTAMP '2004-10-24 00:00:00.0', TIMESTAMP '2004-10-18 00:00:00.0', 'Shipped', NULL, 121);
INSERT INTO PUBLIC.ORDERS(ORDERNUMBER, ORDERDATE, REQUIREDDATE, SHIPPEDDATE, STATUS, COMMENTS, CUSTOMERNUMBER) VALUES
(10310, TIMESTAMP '2004-10-16 00:00:00.0', TIMESTAMP '2004-10-24 00:00:00.0', TIMESTAMP '2004-10-18 00:00:00.0', 'Shipped', NULL, 259),
(10311, TIMESTAMP '2004-10-16 00:00:00.0', TIMESTAMP '2004-10-23 00:00:00.0', TIMESTAMP '2004-10-20 00:00:00.0', 'Shipped', 'Difficult to negotiate with customer. We need more marketing materials', 141),
(10312, TIMESTAMP '2004-10-21 00:00:00.0', TIMESTAMP '2004-10-27 00:00:00.0', TIMESTAMP '2004-10-23 00:00:00.0', 'Shipped', NULL, 124),
(10313, TIMESTAMP '2004-10-22 00:00:00.0', TIMESTAMP '2004-10-28 00:00:00.0', TIMESTAMP '2004-10-25 00:00:00.0', 'Shipped', 'Customer requested that FedEx Ground is used for this shipping', 202),
(10314, TIMESTAMP '2004-10-22 00:00:00.0', TIMESTAMP '2004-11-01 00:00:00.0', TIMESTAMP '2004-10-23 00:00:00.0', 'Shipped', NULL, 227),
(10315, TIMESTAMP '2004-10-29 00:00:00.0', TIMESTAMP '2004-11-08 00:00:00.0', TIMESTAMP '2004-10-30 00:00:00.0', 'Shipped', NULL, 119),
(10316, TIMESTAMP '2004-11-01 00:00:00.0', TIMESTAMP '2004-11-09 00:00:00.0', TIMESTAMP '2004-11-07 00:00:00.0', 'Shipped', 'Customer requested that ad materials (such as posters, pamphlets) be included in the shippment', 240),
(10317, TIMESTAMP '2004-11-02 00:00:00.0', TIMESTAMP '2004-11-12 00:00:00.0', TIMESTAMP '2004-11-08 00:00:00.0', 'Shipped', NULL, 161),
(10318, TIMESTAMP '2004-11-02 00:00:00.0', TIMESTAMP '2004-11-09 00:00:00.0', TIMESTAMP '2004-11-07 00:00:00.0', 'Shipped', NULL, 157),
(10319, TIMESTAMP '2004-11-03 00:00:00.0', TIMESTAMP '2004-11-11 00:00:00.0', TIMESTAMP '2004-11-06 00:00:00.0', 'Shipped', 'Customer requested that DHL is used for this shipping', 456),
(10320, TIMESTAMP '2004-11-03 00:00:00.0', TIMESTAMP '2004-11-13 00:00:00.0', TIMESTAMP '2004-11-07 00:00:00.0', 'Shipped', NULL, 144),
(10321, TIMESTAMP '2004-11-04 00:00:00.0', TIMESTAMP '2004-11-12 00:00:00.0', TIMESTAMP '2004-11-07 00:00:00.0', 'Shipped', NULL, 462),
(10322, TIMESTAMP '2004-11-04 00:00:00.0', TIMESTAMP '2004-11-12 00:00:00.0', TIMESTAMP '2004-11-10 00:00:00.0', 'Shipped', 'Customer has worked with some of our vendors in the past and is aware of their MSRP', 363),
(10323, TIMESTAMP '2004-11-05 00:00:00.0', TIMESTAMP '2004-11-12 00:00:00.0', TIMESTAMP '2004-11-09 00:00:00.0', 'Shipped', NULL, 128),
(10324, TIMESTAMP '2004-11-05 00:00:00.0', TIMESTAMP '2004-11-11 00:00:00.0', TIMESTAMP '2004-11-08 00:00:00.0', 'Shipped', NULL, 181),
(10325, TIMESTAMP '2004-11-05 00:00:00.0', TIMESTAMP '2004-11-13 00:00:00.0', TIMESTAMP '2004-11-08 00:00:00.0', 'Shipped', NULL, 121),
(10326, TIMESTAMP '2004-11-09 00:00:00.0', TIMESTAMP '2004-11-16 00:00:00.0', TIMESTAMP '2004-11-10 00:00:00.0', 'Shipped', NULL, 144),
(10327, TIMESTAMP '2004-11-10 00:00:00.0', TIMESTAMP '2004-11-19 00:00:00.0', TIMESTAMP '2004-11-13 00:00:00.0', 'Resolved', 'Order was disputed and resolved on 12/1/04. The Sales Manager was involved. Customer claims the scales of the models don''t match what was discussed.', 145),
(10328, TIMESTAMP '2004-11-12 00:00:00.0', TIMESTAMP '2004-11-21 00:00:00.0', TIMESTAMP '2004-11-18 00:00:00.0', 'Shipped', 'Customer very concerned about the exact color of the models. There is high risk that he may dispute the order because there is a slight color mismatch', 278),
(10329, TIMESTAMP '2004-11-15 00:00:00.0', TIMESTAMP '2004-11-24 00:00:00.0', TIMESTAMP '2004-11-16 00:00:00.0', 'Shipped', NULL, 131),
(10330, TIMESTAMP '2004-11-16 00:00:00.0', TIMESTAMP '2004-11-25 00:00:00.0', TIMESTAMP '2004-11-21 00:00:00.0', 'Shipped', NULL, 385),
(10331, TIMESTAMP '2004-11-17 00:00:00.0', TIMESTAMP '2004-11-23 00:00:00.0', TIMESTAMP '2004-11-23 00:00:00.0', 'Shipped', 'Customer requested special shippment. The instructions were passed along to the warehouse', 486),
(10332, TIMESTAMP '2004-11-17 00:00:00.0', TIMESTAMP '2004-11-25 00:00:00.0', TIMESTAMP '2004-11-18 00:00:00.0', 'Shipped', NULL, 187),
(10333, TIMESTAMP '2004-11-18 00:00:00.0', TIMESTAMP '2004-11-27 00:00:00.0', TIMESTAMP '2004-11-20 00:00:00.0', 'Shipped', NULL, 129);
INSERT INTO PUBLIC.ORDERS(ORDERNUMBER, ORDERDATE, REQUIREDDATE, SHIPPEDDATE, STATUS, COMMENTS, CUSTOMERNUMBER) VALUES
(10334, TIMESTAMP '2004-11-19 00:00:00.0', TIMESTAMP '2004-11-28 00:00:00.0', NULL, 'On Hold', 'The outstaniding balance for this customer exceeds their credit limit. Order will be shipped when a payment is received.', 144),
(10335, TIMESTAMP '2004-11-19 00:00:00.0', TIMESTAMP '2004-11-29 00:00:00.0', TIMESTAMP '2004-11-23 00:00:00.0', 'Shipped', NULL, 124),
(10336, TIMESTAMP '2004-11-20 00:00:00.0', TIMESTAMP '2004-11-26 00:00:00.0', TIMESTAMP '2004-11-24 00:00:00.0', 'Shipped', 'Customer requested that DHL is used for this shipping', 172),
(10337, TIMESTAMP '2004-11-21 00:00:00.0', TIMESTAMP '2004-11-30 00:00:00.0', TIMESTAMP '2004-11-26 00:00:00.0', 'Shipped', NULL, 424),
(10338, TIMESTAMP '2004-11-22 00:00:00.0', TIMESTAMP '2004-12-02 00:00:00.0', TIMESTAMP '2004-11-27 00:00:00.0', 'Shipped', NULL, 381),
(10339, TIMESTAMP '2004-11-23 00:00:00.0', TIMESTAMP '2004-11-30 00:00:00.0', TIMESTAMP '2004-11-30 00:00:00.0', 'Shipped', NULL, 398),
(10340, TIMESTAMP '2004-11-24 00:00:00.0', TIMESTAMP '2004-12-01 00:00:00.0', TIMESTAMP '2004-11-25 00:00:00.0', 'Shipped', 'Customer is interested in buying more Ferrari models', 216),
(10341, TIMESTAMP '2004-11-24 00:00:00.0', TIMESTAMP '2004-12-01 00:00:00.0', TIMESTAMP '2004-11-29 00:00:00.0', 'Shipped', NULL, 382),
(10342, TIMESTAMP '2004-11-24 00:00:00.0', TIMESTAMP '2004-12-01 00:00:00.0', TIMESTAMP '2004-11-29 00:00:00.0', 'Shipped', NULL, 114),
(10343, TIMESTAMP '2004-11-24 00:00:00.0', TIMESTAMP '2004-12-01 00:00:00.0', TIMESTAMP '2004-11-26 00:00:00.0', 'Shipped', NULL, 353),
(10344, TIMESTAMP '2004-11-25 00:00:00.0', TIMESTAMP '2004-12-02 00:00:00.0', TIMESTAMP '2004-11-29 00:00:00.0', 'Shipped', NULL, 350),
(10345, TIMESTAMP '2004-11-25 00:00:00.0', TIMESTAMP '2004-12-01 00:00:00.0', TIMESTAMP '2004-11-26 00:00:00.0', 'Shipped', NULL, 103),
(10346, TIMESTAMP '2004-11-29 00:00:00.0', TIMESTAMP '2004-12-05 00:00:00.0', TIMESTAMP '2004-11-30 00:00:00.0', 'Shipped', NULL, 112),
(10347, TIMESTAMP '2004-11-29 00:00:00.0', TIMESTAMP '2004-12-07 00:00:00.0', TIMESTAMP '2004-11-30 00:00:00.0', 'Shipped', 'Can we deliver the new Ford Mustang models by end-of-quarter?', 114),
(10348, TIMESTAMP '2004-11-01 00:00:00.0', TIMESTAMP '2004-11-08 00:00:00.0', TIMESTAMP '2004-11-05 00:00:00.0', 'Shipped', NULL, 458),
(10349, TIMESTAMP '2004-12-01 00:00:00.0', TIMESTAMP '2004-12-07 00:00:00.0', TIMESTAMP '2004-12-03 00:00:00.0', 'Shipped', NULL, 151),
(10350, TIMESTAMP '2004-12-02 00:00:00.0', TIMESTAMP '2004-12-08 00:00:00.0', TIMESTAMP '2004-12-05 00:00:00.0', 'Shipped', NULL, 141),
(10351, TIMESTAMP '2004-12-03 00:00:00.0', TIMESTAMP '2004-12-11 00:00:00.0', TIMESTAMP '2004-12-07 00:00:00.0', 'Shipped', NULL, 324),
(10352, TIMESTAMP '2004-12-03 00:00:00.0', TIMESTAMP '2004-12-12 00:00:00.0', TIMESTAMP '2004-12-09 00:00:00.0', 'Shipped', NULL, 198),
(10353, TIMESTAMP '2004-12-04 00:00:00.0', TIMESTAMP '2004-12-11 00:00:00.0', TIMESTAMP '2004-12-05 00:00:00.0', 'Shipped', NULL, 447),
(10354, TIMESTAMP '2004-12-04 00:00:00.0', TIMESTAMP '2004-12-10 00:00:00.0', TIMESTAMP '2004-12-05 00:00:00.0', 'Shipped', NULL, 323),
(10355, TIMESTAMP '2004-12-07 00:00:00.0', TIMESTAMP '2004-12-14 00:00:00.0', TIMESTAMP '2004-12-13 00:00:00.0', 'Shipped', NULL, 141),
(10356, TIMESTAMP '2004-12-09 00:00:00.0', TIMESTAMP '2004-12-15 00:00:00.0', TIMESTAMP '2004-12-12 00:00:00.0', 'Shipped', NULL, 250),
(10357, TIMESTAMP '2004-12-10 00:00:00.0', TIMESTAMP '2004-12-16 00:00:00.0', TIMESTAMP '2004-12-14 00:00:00.0', 'Shipped', NULL, 124),
(10358, TIMESTAMP '2004-12-10 00:00:00.0', TIMESTAMP '2004-12-16 00:00:00.0', TIMESTAMP '2004-12-16 00:00:00.0', 'Shipped', 'Customer requested that DHL is used for this shipping', 141),
(10359, TIMESTAMP '2004-12-15 00:00:00.0', TIMESTAMP '2004-12-23 00:00:00.0', TIMESTAMP '2004-12-18 00:00:00.0', 'Shipped', NULL, 353),
(10360, TIMESTAMP '2004-12-16 00:00:00.0', TIMESTAMP '2004-12-22 00:00:00.0', TIMESTAMP '2004-12-18 00:00:00.0', 'Shipped', NULL, 496),
(10361, TIMESTAMP '2004-12-17 00:00:00.0', TIMESTAMP '2004-12-24 00:00:00.0', TIMESTAMP '2004-12-20 00:00:00.0', 'Shipped', NULL, 282);
INSERT INTO PUBLIC.ORDERS(ORDERNUMBER, ORDERDATE, REQUIREDDATE, SHIPPEDDATE, STATUS, COMMENTS, CUSTOMERNUMBER) VALUES
(10362, TIMESTAMP '2005-01-05 00:00:00.0', TIMESTAMP '2005-01-16 00:00:00.0', TIMESTAMP '2005-01-10 00:00:00.0', 'Shipped', NULL, 161),
(10363, TIMESTAMP '2005-01-06 00:00:00.0', TIMESTAMP '2005-01-12 00:00:00.0', TIMESTAMP '2005-01-10 00:00:00.0', 'Shipped', NULL, 334),
(10364, TIMESTAMP '2005-01-06 00:00:00.0', TIMESTAMP '2005-01-17 00:00:00.0', TIMESTAMP '2005-01-09 00:00:00.0', 'Shipped', NULL, 350),
(10365, TIMESTAMP '2005-01-07 00:00:00.0', TIMESTAMP '2005-01-18 00:00:00.0', TIMESTAMP '2005-01-11 00:00:00.0', 'Shipped', NULL, 320),
(10366, TIMESTAMP '2005-01-10 00:00:00.0', TIMESTAMP '2005-01-19 00:00:00.0', TIMESTAMP '2005-01-12 00:00:00.0', 'Shipped', NULL, 381),
(10367, TIMESTAMP '2005-01-12 00:00:00.0', TIMESTAMP '2005-01-21 00:00:00.0', TIMESTAMP '2005-01-16 00:00:00.0', 'Resolved', 'This order was disputed and resolved on 2/1/2005. Customer claimed that container with shipment was damaged. FedEx''s investigation proved this wrong.', 205),
(10368, TIMESTAMP '2005-01-19 00:00:00.0', TIMESTAMP '2005-01-27 00:00:00.0', TIMESTAMP '2005-01-24 00:00:00.0', 'Shipped', 'Can we renegotiate this one?', 124),
(10369, TIMESTAMP '2005-01-20 00:00:00.0', TIMESTAMP '2005-01-28 00:00:00.0', TIMESTAMP '2005-01-24 00:00:00.0', 'Shipped', NULL, 379),
(10370, TIMESTAMP '2005-01-20 00:00:00.0', TIMESTAMP '2005-02-01 00:00:00.0', TIMESTAMP '2005-01-25 00:00:00.0', 'Shipped', NULL, 276),
(10371, TIMESTAMP '2005-01-23 00:00:00.0', TIMESTAMP '2005-02-03 00:00:00.0', TIMESTAMP '2005-01-25 00:00:00.0', 'Shipped', NULL, 124),
(10372, TIMESTAMP '2005-01-26 00:00:00.0', TIMESTAMP '2005-02-05 00:00:00.0', TIMESTAMP '2005-01-28 00:00:00.0', 'Shipped', NULL, 398),
(10373, TIMESTAMP '2005-01-31 00:00:00.0', TIMESTAMP '2005-02-08 00:00:00.0', TIMESTAMP '2005-02-06 00:00:00.0', 'Shipped', NULL, 311),
(10374, TIMESTAMP '2005-02-02 00:00:00.0', TIMESTAMP '2005-02-09 00:00:00.0', TIMESTAMP '2005-02-03 00:00:00.0', 'Shipped', NULL, 333),
(10375, TIMESTAMP '2005-02-03 00:00:00.0', TIMESTAMP '2005-02-10 00:00:00.0', TIMESTAMP '2005-02-06 00:00:00.0', 'Shipped', NULL, 119),
(10376, TIMESTAMP '2005-02-08 00:00:00.0', TIMESTAMP '2005-02-18 00:00:00.0', TIMESTAMP '2005-02-13 00:00:00.0', 'Shipped', NULL, 219),
(10377, TIMESTAMP '2005-02-09 00:00:00.0', TIMESTAMP '2005-02-21 00:00:00.0', TIMESTAMP '2005-02-12 00:00:00.0', 'Shipped', 'Cautious optimism. We have happy customers here, if we can keep them well stocked.  I need all the information I can get on the planned shippments of Porches', 186),
(10378, TIMESTAMP '2005-02-10 00:00:00.0', TIMESTAMP '2005-02-18 00:00:00.0', TIMESTAMP '2005-02-11 00:00:00.0', 'Shipped', NULL, 141),
(10379, TIMESTAMP '2005-02-10 00:00:00.0', TIMESTAMP '2005-02-18 00:00:00.0', TIMESTAMP '2005-02-11 00:00:00.0', 'Shipped', NULL, 141),
(10380, TIMESTAMP '2005-02-16 00:00:00.0', TIMESTAMP '2005-02-24 00:00:00.0', TIMESTAMP '2005-02-18 00:00:00.0', 'Shipped', NULL, 141),
(10381, TIMESTAMP '2005-02-17 00:00:00.0', TIMESTAMP '2005-02-25 00:00:00.0', TIMESTAMP '2005-02-18 00:00:00.0', 'Shipped', NULL, 321),
(10382, TIMESTAMP '2005-02-17 00:00:00.0', TIMESTAMP '2005-02-23 00:00:00.0', TIMESTAMP '2005-02-18 00:00:00.0', 'Shipped', 'Custom shipping instructions sent to warehouse', 124),
(10383, TIMESTAMP '2005-02-22 00:00:00.0', TIMESTAMP '2005-03-02 00:00:00.0', TIMESTAMP '2005-02-25 00:00:00.0', 'Shipped', NULL, 141),
(10384, TIMESTAMP '2005-02-23 00:00:00.0', TIMESTAMP '2005-03-06 00:00:00.0', TIMESTAMP '2005-02-27 00:00:00.0', 'Shipped', NULL, 321),
(10385, TIMESTAMP '2005-02-28 00:00:00.0', TIMESTAMP '2005-03-09 00:00:00.0', TIMESTAMP '2005-03-01 00:00:00.0', 'Shipped', NULL, 124),
(10386, TIMESTAMP '2005-03-01 00:00:00.0', TIMESTAMP '2005-03-09 00:00:00.0', TIMESTAMP '2005-03-06 00:00:00.0', 'Resolved', 'Disputed then Resolved on 3/15/2005. Customer doesn''t like the craftsmaship of the models.', 141),
(10387, TIMESTAMP '2005-03-02 00:00:00.0', TIMESTAMP '2005-03-09 00:00:00.0', TIMESTAMP '2005-03-06 00:00:00.0', 'Shipped', 'We need to keep in close contact with their Marketing VP. He is the decision maker for all their purchases.', 148);
INSERT INTO PUBLIC.ORDERS(ORDERNUMBER, ORDERDATE, REQUIREDDATE, SHIPPEDDATE, STATUS, COMMENTS, CUSTOMERNUMBER) VALUES
(10388, TIMESTAMP '2005-03-03 00:00:00.0', TIMESTAMP '2005-03-11 00:00:00.0', TIMESTAMP '2005-03-09 00:00:00.0', 'Shipped', NULL, 462),
(10389, TIMESTAMP '2005-03-03 00:00:00.0', TIMESTAMP '2005-03-09 00:00:00.0', TIMESTAMP '2005-03-08 00:00:00.0', 'Shipped', NULL, 448),
(10390, TIMESTAMP '2005-03-04 00:00:00.0', TIMESTAMP '2005-03-11 00:00:00.0', TIMESTAMP '2005-03-07 00:00:00.0', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 124),
(10391, TIMESTAMP '2005-03-09 00:00:00.0', TIMESTAMP '2005-03-20 00:00:00.0', TIMESTAMP '2005-03-15 00:00:00.0', 'Shipped', NULL, 276),
(10392, TIMESTAMP '2005-03-10 00:00:00.0', TIMESTAMP '2005-03-18 00:00:00.0', TIMESTAMP '2005-03-12 00:00:00.0', 'Shipped', NULL, 452),
(10393, TIMESTAMP '2005-03-11 00:00:00.0', TIMESTAMP '2005-03-22 00:00:00.0', TIMESTAMP '2005-03-14 00:00:00.0', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 323),
(10394, TIMESTAMP '2005-03-15 00:00:00.0', TIMESTAMP '2005-03-25 00:00:00.0', TIMESTAMP '2005-03-19 00:00:00.0', 'Shipped', NULL, 141),
(10395, TIMESTAMP '2005-03-17 00:00:00.0', TIMESTAMP '2005-03-24 00:00:00.0', TIMESTAMP '2005-03-23 00:00:00.0', 'Shipped', 'We must be cautions with this customer. Their VP of Sales resigned. Company may be heading down.', 250),
(10396, TIMESTAMP '2005-03-23 00:00:00.0', TIMESTAMP '2005-04-02 00:00:00.0', TIMESTAMP '2005-03-28 00:00:00.0', 'Shipped', NULL, 124),
(10397, TIMESTAMP '2005-03-28 00:00:00.0', TIMESTAMP '2005-04-09 00:00:00.0', TIMESTAMP '2005-04-01 00:00:00.0', 'Shipped', NULL, 242),
(10398, TIMESTAMP '2005-03-30 00:00:00.0', TIMESTAMP '2005-04-09 00:00:00.0', TIMESTAMP '2005-03-31 00:00:00.0', 'Shipped', NULL, 353),
(10399, TIMESTAMP '2005-04-01 00:00:00.0', TIMESTAMP '2005-04-12 00:00:00.0', TIMESTAMP '2005-04-03 00:00:00.0', 'Shipped', NULL, 496),
(10400, TIMESTAMP '2005-04-01 00:00:00.0', TIMESTAMP '2005-04-11 00:00:00.0', TIMESTAMP '2005-04-04 00:00:00.0', 'Shipped', 'Customer requested that DHL is used for this shipping', 450),
(10401, TIMESTAMP '2005-04-03 00:00:00.0', TIMESTAMP '2005-04-14 00:00:00.0', NULL, 'On Hold', 'Customer credit limit exceeded. Will ship when a payment is received.', 328),
(10402, TIMESTAMP '2005-04-07 00:00:00.0', TIMESTAMP '2005-04-14 00:00:00.0', TIMESTAMP '2005-04-12 00:00:00.0', 'Shipped', NULL, 406),
(10403, TIMESTAMP '2005-04-08 00:00:00.0', TIMESTAMP '2005-04-18 00:00:00.0', TIMESTAMP '2005-04-11 00:00:00.0', 'Shipped', NULL, 201),
(10404, TIMESTAMP '2005-04-08 00:00:00.0', TIMESTAMP '2005-04-14 00:00:00.0', TIMESTAMP '2005-04-11 00:00:00.0', 'Shipped', NULL, 323),
(10405, TIMESTAMP '2005-04-14 00:00:00.0', TIMESTAMP '2005-04-24 00:00:00.0', TIMESTAMP '2005-04-20 00:00:00.0', 'Shipped', NULL, 209),
(10406, TIMESTAMP '2005-04-15 00:00:00.0', TIMESTAMP '2005-04-25 00:00:00.0', TIMESTAMP '2005-04-21 00:00:00.0', 'Disputed', 'Customer claims container with shipment was damaged during shipping and some items were missing. I am talking to FedEx about this.', 145),
(10407, TIMESTAMP '2005-04-22 00:00:00.0', TIMESTAMP '2005-05-04 00:00:00.0', NULL, 'On Hold', 'Customer credit limit exceeded. Will ship when a payment is received.', 450),
(10408, TIMESTAMP '2005-04-22 00:00:00.0', TIMESTAMP '2005-04-29 00:00:00.0', TIMESTAMP '2005-04-27 00:00:00.0', 'Shipped', NULL, 398),
(10409, TIMESTAMP '2005-04-23 00:00:00.0', TIMESTAMP '2005-05-05 00:00:00.0', TIMESTAMP '2005-04-24 00:00:00.0', 'Shipped', NULL, 166),
(10410, TIMESTAMP '2005-04-29 00:00:00.0', TIMESTAMP '2005-05-10 00:00:00.0', TIMESTAMP '2005-04-30 00:00:00.0', 'Shipped', NULL, 357),
(10411, TIMESTAMP '2005-05-01 00:00:00.0', TIMESTAMP '2005-05-08 00:00:00.0', TIMESTAMP '2005-05-06 00:00:00.0', 'Shipped', NULL, 233),
(10412, TIMESTAMP '2005-05-03 00:00:00.0', TIMESTAMP '2005-05-13 00:00:00.0', TIMESTAMP '2005-05-05 00:00:00.0', 'Shipped', NULL, 141),
(10413, TIMESTAMP '2005-05-05 00:00:00.0', TIMESTAMP '2005-05-14 00:00:00.0', TIMESTAMP '2005-05-09 00:00:00.0', 'Shipped', 'Customer requested that DHL is used for this shipping', 175);
INSERT INTO PUBLIC.ORDERS(ORDERNUMBER, ORDERDATE, REQUIREDDATE, SHIPPEDDATE, STATUS, COMMENTS, CUSTOMERNUMBER) VALUES
(10414, TIMESTAMP '2005-05-06 00:00:00.0', TIMESTAMP '2005-05-13 00:00:00.0', NULL, 'On Hold', 'Customer credit limit exceeded. Will ship when a payment is received.', 362),
(10415, TIMESTAMP '2005-05-09 00:00:00.0', TIMESTAMP '2005-05-20 00:00:00.0', TIMESTAMP '2005-05-12 00:00:00.0', 'Disputed', 'Customer claims the scales of the models don''t match what was discussed. I keep all the paperwork though to prove otherwise', 471),
(10416, TIMESTAMP '2005-05-10 00:00:00.0', TIMESTAMP '2005-05-16 00:00:00.0', TIMESTAMP '2005-05-14 00:00:00.0', 'Shipped', NULL, 386),
(10417, TIMESTAMP '2005-05-13 00:00:00.0', TIMESTAMP '2005-05-19 00:00:00.0', TIMESTAMP '2005-05-19 00:00:00.0', 'Disputed', 'Customer doesn''t like the colors and precision of the models.', 141),
(10418, TIMESTAMP '2005-05-16 00:00:00.0', TIMESTAMP '2005-05-24 00:00:00.0', TIMESTAMP '2005-05-20 00:00:00.0', 'Shipped', NULL, 412),
(10419, TIMESTAMP '2005-05-17 00:00:00.0', TIMESTAMP '2005-05-28 00:00:00.0', TIMESTAMP '2005-05-19 00:00:00.0', 'Shipped', NULL, 382),
(10420, TIMESTAMP '2005-05-29 00:00:00.0', TIMESTAMP '2005-06-07 00:00:00.0', NULL, 'In Process', NULL, 282),
(10421, TIMESTAMP '2005-05-29 00:00:00.0', TIMESTAMP '2005-06-06 00:00:00.0', NULL, 'In Process', 'Custom shipping instructions were sent to warehouse', 124),
(10422, TIMESTAMP '2005-05-30 00:00:00.0', TIMESTAMP '2005-06-11 00:00:00.0', NULL, 'In Process', NULL, 157),
(10423, TIMESTAMP '2005-05-30 00:00:00.0', TIMESTAMP '2005-06-05 00:00:00.0', NULL, 'In Process', NULL, 314),
(10424, TIMESTAMP '2005-05-31 00:00:00.0', TIMESTAMP '2005-06-08 00:00:00.0', NULL, 'In Process', NULL, 141),
(10425, TIMESTAMP '2005-05-31 00:00:00.0', TIMESTAMP '2005-06-07 00:00:00.0', NULL, 'In Process', NULL, 119);
DROP TABLE IF EXISTS PUBLIC.PAYMENTS;
CREATE MEMORY TABLE PUBLIC.PAYMENTS(
    CUSTOMERNUMBER INTEGER NOT NULL,
    CHECKNUMBER VARCHAR(50) NOT NULL,
    PAYMENTDATE TIMESTAMP NOT NULL,
    AMOUNT NUMERIC(17) NOT NULL
);
ALTER TABLE PUBLIC.PAYMENTS ADD CONSTRAINT PUBLIC.CONSTRAINT_81 PRIMARY KEY(CUSTOMERNUMBER, CHECKNUMBER);
-- 272 +/- SELECT COUNT(*) FROM PUBLIC.PAYMENTS;
INSERT INTO PUBLIC.PAYMENTS(CUSTOMERNUMBER, CHECKNUMBER, PAYMENTDATE, AMOUNT) VALUES
(103, 'HQ336336', TIMESTAMP '2004-10-19 00:00:00.0', 5308),
(103, 'JM555205', TIMESTAMP '2003-06-05 00:00:00.0', 16560),
(103, 'OM314933', TIMESTAMP '2004-12-18 00:00:00.0', 2312),
(112, 'BO864823', TIMESTAMP '2004-12-17 00:00:00.0', 14450),
(112, 'HQ55022', TIMESTAMP '2003-06-06 00:00:00.0', 33848),
(112, 'ND748579', TIMESTAMP '2004-08-20 00:00:00.0', 34454),
(114, 'GG31455', TIMESTAMP '2003-05-20 00:00:00.0', 50398),
(114, 'MA765515', TIMESTAMP '2004-12-15 00:00:00.0', 85591),
(114, 'NP603840', TIMESTAMP '2003-05-31 00:00:00.0', 9738),
(114, 'NR27552', TIMESTAMP '2004-03-10 00:00:00.0', 49638),
(119, 'DB933704', TIMESTAMP '2004-11-14 00:00:00.0', 20720),
(119, 'LN373447', TIMESTAMP '2004-08-08 00:00:00.0', 56003),
(119, 'NG94694', TIMESTAMP '2005-02-22 00:00:00.0', 59617),
(121, 'DB889831', TIMESTAMP '2003-02-16 00:00:00.0', 54702),
(121, 'FD317790', TIMESTAMP '2003-10-28 00:00:00.0', 1475),
(121, 'KI831359', TIMESTAMP '2004-11-04 00:00:00.0', 19770),
(121, 'MA302151', TIMESTAMP '2004-11-28 00:00:00.0', 40653),
(124, 'AE215433', TIMESTAMP '2005-02-18 00:00:00.0', 51826),
(124, 'AQ50522', TIMESTAMP '2005-06-03 00:00:00.0', 32195),
(124, 'BG255406', TIMESTAMP '2004-08-28 00:00:00.0', 93929),
(124, 'CQ287967', TIMESTAMP '2003-04-11 00:00:00.0', 12399),
(124, 'ET64396', TIMESTAMP '2005-04-16 00:00:00.0', 121973),
(124, 'HI366474', TIMESTAMP '2004-12-27 00:00:00.0', 50548),
(124, 'HR86578', TIMESTAMP '2004-11-02 00:00:00.0', 63075),
(124, 'KI131716', TIMESTAMP '2003-08-15 00:00:00.0', 122369),
(124, 'LF217299', TIMESTAMP '2004-03-26 00:00:00.0', 48923),
(124, 'NT141748', TIMESTAMP '2003-11-25 00:00:00.0', 50361),
(128, 'DI925118', TIMESTAMP '2003-01-28 00:00:00.0', 11432),
(128, 'FA465482', TIMESTAMP '2003-10-18 00:00:00.0', 27258),
(128, 'FH668230', TIMESTAMP '2004-03-24 00:00:00.0', 37266),
(128, 'IP383901', TIMESTAMP '2004-11-18 00:00:00.0', 9215),
(129, 'DM826140', TIMESTAMP '2004-12-08 00:00:00.0', 30349),
(129, 'ID449593', TIMESTAMP '2003-12-11 00:00:00.0', 25432),
(129, 'PI42991', TIMESTAMP '2003-04-09 00:00:00.0', 18696),
(131, 'CL442705', TIMESTAMP '2003-03-12 00:00:00.0', 25784),
(131, 'KG113538', TIMESTAMP '2004-05-22 00:00:00.0', 45358),
(131, 'MA724562', TIMESTAMP '2004-12-02 00:00:00.0', 53152),
(131, 'NB445135', TIMESTAMP '2004-09-11 00:00:00.0', 39776),
(141, 'AU364101', TIMESTAMP '2003-07-19 00:00:00.0', 39616),
(141, 'DB583216', TIMESTAMP '2004-11-01 00:00:00.0', 34872),
(141, 'DL460618', TIMESTAMP '2005-05-19 00:00:00.0', 22354),
(141, 'HJ32686', TIMESTAMP '2004-01-30 00:00:00.0', 65165),
(141, 'ID10962', TIMESTAMP '2004-12-31 00:00:00.0', 133589),
(141, 'IN446258', TIMESTAMP '2005-03-25 00:00:00.0', 95065),
(141, 'JE105477', TIMESTAMP '2005-03-18 00:00:00.0', 90136),
(141, 'JN355280', TIMESTAMP '2003-10-26 00:00:00.0', 53502),
(141, 'JN722010', TIMESTAMP '2003-02-25 00:00:00.0', 44622),
(141, 'KT52578', TIMESTAMP '2003-12-09 00:00:00.0', 72488),
(141, 'MC46946', TIMESTAMP '2004-07-09 00:00:00.0', 91328),
(141, 'MF629602', TIMESTAMP '2004-08-16 00:00:00.0', 21986),
(141, 'NU627706', TIMESTAMP '2004-05-17 00:00:00.0', 28328),
(144, 'IR846303', TIMESTAMP '2004-12-12 00:00:00.0', 66006),
(144, 'LA685678', TIMESTAMP '2003-04-09 00:00:00.0', 9749),
(145, 'CN328545', TIMESTAMP '2004-07-03 00:00:00.0', 4749),
(145, 'ED39322', TIMESTAMP '2004-04-26 00:00:00.0', 31330),
(145, 'HR182688', TIMESTAMP '2004-12-01 00:00:00.0', 24079),
(145, 'JJ246391', TIMESTAMP '2003-02-20 00:00:00.0', 58871),
(146, 'FP549817', TIMESTAMP '2004-03-18 00:00:00.0', 46802),
(146, 'FU793410', TIMESTAMP '2004-01-16 00:00:00.0', 54537),
(146, 'LJ160635', TIMESTAMP '2003-12-10 00:00:00.0', 41535),
(148, 'BI507030', TIMESTAMP '2003-04-22 00:00:00.0', 43657),
(148, 'DD635282', TIMESTAMP '2004-08-11 00:00:00.0', 3128),
(148, 'KM172879', TIMESTAMP '2003-12-26 00:00:00.0', 122029),
(148, 'ME497970', TIMESTAMP '2005-03-27 00:00:00.0', 4176),
(151, 'BF686658', TIMESTAMP '2003-12-22 00:00:00.0', 64316),
(151, 'GB852215', TIMESTAMP '2004-07-26 00:00:00.0', 23252),
(151, 'IP568906', TIMESTAMP '2003-06-18 00:00:00.0', 68462);
INSERT INTO PUBLIC.PAYMENTS(CUSTOMERNUMBER, CHECKNUMBER, PAYMENTDATE, AMOUNT) VALUES
(151, 'KI884577', TIMESTAMP '2004-12-14 00:00:00.0', 41707),
(157, 'HI618861', TIMESTAMP '2004-11-19 00:00:00.0', 44041),
(157, 'NN711988', TIMESTAMP '2004-09-07 00:00:00.0', 71931),
(161, 'BR352384', TIMESTAMP '2004-11-14 00:00:00.0', 2916),
(161, 'BR478494', TIMESTAMP '2003-11-18 00:00:00.0', 62305),
(161, 'KG644125', TIMESTAMP '2005-02-02 00:00:00.0', 13530),
(161, 'NI908214', TIMESTAMP '2003-08-05 00:00:00.0', 42032),
(166, 'BQ327613', TIMESTAMP '2004-09-16 00:00:00.0', 42903),
(166, 'DC979307', TIMESTAMP '2004-07-07 00:00:00.0', 45789),
(166, 'LA318629', TIMESTAMP '2004-02-28 00:00:00.0', 24220),
(167, 'ED743615', TIMESTAMP '2004-09-19 00:00:00.0', 16363),
(167, 'GN228846', TIMESTAMP '2003-12-03 00:00:00.0', 95277),
(171, 'GB878038', TIMESTAMP '2004-03-15 00:00:00.0', 20178),
(171, 'IL104425', TIMESTAMP '2003-11-22 00:00:00.0', 48874),
(172, 'AD832091', TIMESTAMP '2004-09-09 00:00:00.0', 2174),
(172, 'CE51751', TIMESTAMP '2004-12-04 00:00:00.0', 56813),
(172, 'EH208589', TIMESTAMP '2003-04-20 00:00:00.0', 38217),
(173, 'GP545698', TIMESTAMP '2004-05-13 00:00:00.0', 14381),
(173, 'IG462397', TIMESTAMP '2004-03-29 00:00:00.0', 21783),
(175, 'IO448913', TIMESTAMP '2003-11-19 00:00:00.0', 26116),
(175, 'PI15215', TIMESTAMP '2004-07-10 00:00:00.0', 44131),
(177, 'AU750837', TIMESTAMP '2004-04-17 00:00:00.0', 17114),
(177, 'CI381435', TIMESTAMP '2004-01-19 00:00:00.0', 50491),
(181, 'CM564612', TIMESTAMP '2004-04-25 00:00:00.0', 24804),
(181, 'GQ132144', TIMESTAMP '2003-01-30 00:00:00.0', 6864),
(181, 'OH367219', TIMESTAMP '2004-11-16 00:00:00.0', 56373),
(186, 'AE192287', TIMESTAMP '2005-03-10 00:00:00.0', 26423),
(186, 'AK412714', TIMESTAMP '2003-10-27 00:00:00.0', 42084),
(186, 'KA602407', TIMESTAMP '2004-10-21 00:00:00.0', 42744),
(187, 'AM968797', TIMESTAMP '2004-11-03 00:00:00.0', 57828),
(187, 'BQ39062', TIMESTAMP '2004-12-08 00:00:00.0', 48962),
(187, 'KL124726', TIMESTAMP '2003-03-27 00:00:00.0', 51018),
(189, 'BO711618', TIMESTAMP '2004-10-03 00:00:00.0', 18972),
(189, 'NM916675', TIMESTAMP '2004-03-01 00:00:00.0', 38784),
(198, 'FI192930', TIMESTAMP '2004-12-06 00:00:00.0', 11529),
(198, 'HQ920205', TIMESTAMP '2003-07-06 00:00:00.0', 7277),
(198, 'IS946883', TIMESTAMP '2004-09-21 00:00:00.0', 7673),
(201, 'DP677013', TIMESTAMP '2003-10-20 00:00:00.0', 26797),
(201, 'OO846801', TIMESTAMP '2004-06-15 00:00:00.0', 50408),
(202, 'HI358554', TIMESTAMP '2003-12-18 00:00:00.0', 38662),
(202, 'IQ627690', TIMESTAMP '2004-11-08 00:00:00.0', 36577),
(204, 'GC697638', TIMESTAMP '2004-08-13 00:00:00.0', 52505),
(204, 'IS150005', TIMESTAMP '2004-09-24 00:00:00.0', 4693),
(205, 'GL756480', TIMESTAMP '2003-12-04 00:00:00.0', 4512),
(205, 'LL562733', TIMESTAMP '2003-09-05 00:00:00.0', 55776),
(205, 'NM739638', TIMESTAMP '2005-02-06 00:00:00.0', 44273),
(209, 'ED520529', TIMESTAMP '2004-06-21 00:00:00.0', 5417),
(209, 'PH785937', TIMESTAMP '2004-05-04 00:00:00.0', 39341),
(211, 'BJ535230', TIMESTAMP '2003-12-09 00:00:00.0', 48784),
(216, 'BG407567', TIMESTAMP '2003-05-09 00:00:00.0', 4219),
(216, 'ML780814', TIMESTAMP '2004-12-06 00:00:00.0', 21250),
(216, 'MM342086', TIMESTAMP '2003-12-14 00:00:00.0', 44009),
(219, 'BN17870', TIMESTAMP '2005-03-02 00:00:00.0', 3987),
(219, 'BR941480', TIMESTAMP '2003-10-18 00:00:00.0', 5142),
(227, 'MQ413968', TIMESTAMP '2003-10-31 00:00:00.0', 40322),
(227, 'NU21326', TIMESTAMP '2004-11-02 00:00:00.0', 60274),
(233, 'II180006', TIMESTAMP '2004-07-01 00:00:00.0', 24565),
(233, 'JG981190', TIMESTAMP '2003-11-18 00:00:00.0', 15947),
(239, 'NQ865547', TIMESTAMP '2004-03-15 00:00:00.0', 87489),
(240, 'IF245157', TIMESTAMP '2004-11-16 00:00:00.0', 51334),
(240, 'JO719695', TIMESTAMP '2004-03-28 00:00:00.0', 26907),
(242, 'AF40894', TIMESTAMP '2003-11-22 00:00:00.0', 38098),
(242, 'HR224331', TIMESTAMP '2005-06-03 00:00:00.0', 15139),
(242, 'KI744716', TIMESTAMP '2003-07-21 00:00:00.0', 17251),
(249, 'IJ399820', TIMESTAMP '2004-09-19 00:00:00.0', 38039),
(249, 'NE404084', TIMESTAMP '2004-09-04 00:00:00.0', 56078),
(250, 'EQ12267', TIMESTAMP '2005-05-17 00:00:00.0', 20322);
INSERT INTO PUBLIC.PAYMENTS(CUSTOMERNUMBER, CHECKNUMBER, PAYMENTDATE, AMOUNT) VALUES
(250, 'HD284647', TIMESTAMP '2004-12-30 00:00:00.0', 32624),
(250, 'HN114306', TIMESTAMP '2003-07-18 00:00:00.0', 25625),
(256, 'EP227123', TIMESTAMP '2004-02-10 00:00:00.0', 5759),
(256, 'HE84936', TIMESTAMP '2004-10-22 00:00:00.0', 59075),
(259, 'EU280955', TIMESTAMP '2004-11-06 00:00:00.0', 68943),
(259, 'GB361972', TIMESTAMP '2003-12-07 00:00:00.0', 31363),
(260, 'IO164641', TIMESTAMP '2004-08-30 00:00:00.0', 43332),
(260, 'NH776924', TIMESTAMP '2004-04-24 00:00:00.0', 31303),
(276, 'EM979878', TIMESTAMP '2005-02-09 00:00:00.0', 29852),
(276, 'KM841847', TIMESTAMP '2003-11-13 00:00:00.0', 41792),
(276, 'LE432182', TIMESTAMP '2003-09-28 00:00:00.0', 47192),
(276, 'OJ819725', TIMESTAMP '2005-04-30 00:00:00.0', 35160),
(278, 'BJ483870', TIMESTAMP '2004-12-05 00:00:00.0', 41697),
(278, 'GP636783', TIMESTAMP '2003-03-02 00:00:00.0', 56181),
(278, 'NI983021', TIMESTAMP '2003-11-24 00:00:00.0', 40078),
(282, 'IA793562', TIMESTAMP '2003-08-03 00:00:00.0', 28397),
(282, 'JT819493', TIMESTAMP '2004-08-02 00:00:00.0', 41297),
(282, 'OD327378', TIMESTAMP '2005-01-03 00:00:00.0', 37905),
(286, 'DR578578', TIMESTAMP '2004-10-28 00:00:00.0', 54252),
(286, 'KH910279', TIMESTAMP '2004-09-05 00:00:00.0', 48829),
(298, 'AJ574927', TIMESTAMP '2004-03-13 00:00:00.0', 50433),
(298, 'LF501133', TIMESTAMP '2004-09-18 00:00:00.0', 67281),
(299, 'AD304085', TIMESTAMP '2003-10-24 00:00:00.0', 45079),
(299, 'NR157385', TIMESTAMP '2004-09-05 00:00:00.0', 34145),
(311, 'DG336041', TIMESTAMP '2005-02-15 00:00:00.0', 49055),
(311, 'FA728475', TIMESTAMP '2003-10-06 00:00:00.0', 37502),
(311, 'NQ966143', TIMESTAMP '2004-04-25 00:00:00.0', 17813),
(314, 'LQ244073', TIMESTAMP '2004-08-09 00:00:00.0', 47760),
(314, 'MD809704', TIMESTAMP '2004-03-03 00:00:00.0', 18800),
(319, 'HL685576', TIMESTAMP '2004-11-06 00:00:00.0', 46873),
(319, 'OM548174', TIMESTAMP '2003-12-07 00:00:00.0', 38683),
(320, 'GJ597719', TIMESTAMP '2005-01-18 00:00:00.0', 11021),
(320, 'HO576374', TIMESTAMP '2003-08-20 00:00:00.0', 45738),
(320, 'MU817160', TIMESTAMP '2003-11-24 00:00:00.0', 52191),
(321, 'DJ15149', TIMESTAMP '2003-11-03 00:00:00.0', 95679),
(321, 'LA556321', TIMESTAMP '2005-03-15 00:00:00.0', 54204),
(323, 'AL493079', TIMESTAMP '2005-05-23 00:00:00.0', 39268),
(323, 'ES347491', TIMESTAMP '2004-06-24 00:00:00.0', 40035),
(323, 'HG738664', TIMESTAMP '2003-07-05 00:00:00.0', 2477),
(323, 'PQ803830', TIMESTAMP '2004-12-24 00:00:00.0', 43931),
(324, 'DQ409197', TIMESTAMP '2004-12-13 00:00:00.0', 13740),
(324, 'FP443161', TIMESTAMP '2003-07-07 00:00:00.0', 32376),
(324, 'HB150714', TIMESTAMP '2003-11-23 00:00:00.0', 42688),
(328, 'EN930356', TIMESTAMP '2004-04-16 00:00:00.0', 8722),
(328, 'NR631421', TIMESTAMP '2004-05-30 00:00:00.0', 27987),
(333, 'HL209210', TIMESTAMP '2003-11-15 00:00:00.0', 27099),
(333, 'JK479662', TIMESTAMP '2003-10-17 00:00:00.0', 10640),
(333, 'NF959653', TIMESTAMP '2005-03-01 00:00:00.0', 21730),
(334, 'CS435306', TIMESTAMP '2005-01-27 00:00:00.0', 51373),
(334, 'HH517378', TIMESTAMP '2003-08-16 00:00:00.0', 31569),
(334, 'LF737277', TIMESTAMP '2004-05-22 00:00:00.0', 31018),
(339, 'AP286625', TIMESTAMP '2004-10-24 00:00:00.0', 27445),
(339, 'DA98827', TIMESTAMP '2003-11-28 00:00:00.0', 40062),
(344, 'AF246722', TIMESTAMP '2003-11-24 00:00:00.0', 34311),
(344, 'NJ906924', TIMESTAMP '2004-04-02 00:00:00.0', 15331),
(347, 'DG700707', TIMESTAMP '2004-01-18 00:00:00.0', 23889),
(347, 'LG808674', TIMESTAMP '2003-10-24 00:00:00.0', 24159),
(350, 'BQ602907', TIMESTAMP '2004-12-11 00:00:00.0', 20137),
(350, 'CI471510', TIMESTAMP '2003-05-25 00:00:00.0', 52482),
(350, 'OB648482', TIMESTAMP '2005-01-29 00:00:00.0', 2317),
(353, 'CO351193', TIMESTAMP '2005-01-10 00:00:00.0', 48896),
(353, 'ED878227', TIMESTAMP '2003-07-21 00:00:00.0', 15146),
(353, 'GT878649', TIMESTAMP '2003-05-21 00:00:00.0', 18972),
(353, 'HJ618252', TIMESTAMP '2005-06-09 00:00:00.0', 52029),
(357, 'AG240323', TIMESTAMP '2003-12-16 00:00:00.0', 23295),
(357, 'NB291497', TIMESTAMP '2004-07-01 00:00:00.0', 41419);
INSERT INTO PUBLIC.PAYMENTS(CUSTOMERNUMBER, CHECKNUMBER, PAYMENTDATE, AMOUNT) VALUES
(362, 'FP170292', TIMESTAMP '2004-07-11 00:00:00.0', 19548),
(362, 'OG208861', TIMESTAMP '2004-09-21 00:00:00.0', 15345),
(363, 'HL575273', TIMESTAMP '2004-11-17 00:00:00.0', 55571),
(363, 'IS232033', TIMESTAMP '2003-01-16 00:00:00.0', 12133),
(363, 'PN238558', TIMESTAMP '2003-12-05 00:00:00.0', 63981),
(379, 'CA762595', TIMESTAMP '2005-02-12 00:00:00.0', 31475),
(379, 'FR499138', TIMESTAMP '2003-09-16 00:00:00.0', 34992),
(379, 'GB890854', TIMESTAMP '2004-08-02 00:00:00.0', 15111),
(381, 'BC726082', TIMESTAMP '2004-12-03 00:00:00.0', 13463),
(381, 'CC475233', TIMESTAMP '2003-04-19 00:00:00.0', 1711),
(381, 'GB117430', TIMESTAMP '2005-02-03 00:00:00.0', 16628),
(381, 'MS154481', TIMESTAMP '2003-08-22 00:00:00.0', 1637),
(382, 'CC871084', TIMESTAMP '2003-05-12 00:00:00.0', 38629),
(382, 'CT821147', TIMESTAMP '2004-08-01 00:00:00.0', 6693),
(382, 'PH29054', TIMESTAMP '2004-11-27 00:00:00.0', 37353),
(385, 'BN347084', TIMESTAMP '2003-12-02 00:00:00.0', 22842),
(385, 'CP804873', TIMESTAMP '2004-11-19 00:00:00.0', 15929),
(385, 'EK785462', TIMESTAMP '2003-03-09 00:00:00.0', 55245),
(386, 'DO106109', TIMESTAMP '2003-11-18 00:00:00.0', 44670),
(386, 'HG438769', TIMESTAMP '2004-07-18 00:00:00.0', 56422),
(398, 'AJ478695', TIMESTAMP '2005-02-14 00:00:00.0', 38191),
(398, 'DO787644', TIMESTAMP '2004-06-21 00:00:00.0', 25929),
(398, 'KB54275', TIMESTAMP '2004-11-29 00:00:00.0', 44802),
(406, 'HJ217687', TIMESTAMP '2004-01-28 00:00:00.0', 51173),
(406, 'NA197101', TIMESTAMP '2004-06-17 00:00:00.0', 27931),
(412, 'GH197075', TIMESTAMP '2004-07-25 00:00:00.0', 35912),
(412, 'PJ434867', TIMESTAMP '2004-04-14 00:00:00.0', 36409),
(415, 'ER54537', TIMESTAMP '2004-09-28 00:00:00.0', 34994),
(424, 'KF480160', TIMESTAMP '2004-12-07 00:00:00.0', 27733),
(424, 'LM271923', TIMESTAMP '2003-04-16 00:00:00.0', 24777),
(424, 'OA595449', TIMESTAMP '2003-10-31 00:00:00.0', 25285),
(447, 'AO757239', TIMESTAMP '2003-09-15 00:00:00.0', 7600),
(447, 'ER615123', TIMESTAMP '2003-06-25 00:00:00.0', 20351),
(447, 'OU516561', TIMESTAMP '2004-12-17 00:00:00.0', 29343),
(448, 'EQ620556', TIMESTAMP '2003-11-06 00:00:00.0', 48711),
(448, 'FS299615', TIMESTAMP '2005-04-18 00:00:00.0', 31607),
(448, 'KR822727', TIMESTAMP '2004-09-30 00:00:00.0', 53942),
(450, 'EF485824', TIMESTAMP '2004-06-21 00:00:00.0', 64600),
(452, 'ED473873', TIMESTAMP '2003-11-15 00:00:00.0', 28551),
(452, 'FN640986', TIMESTAMP '2003-11-20 00:00:00.0', 14938),
(452, 'HG635467', TIMESTAMP '2005-05-03 00:00:00.0', 8775),
(455, 'HA777606', TIMESTAMP '2003-12-05 00:00:00.0', 42499),
(455, 'IR662429', TIMESTAMP '2004-05-12 00:00:00.0', 36973),
(456, 'GJ715659', TIMESTAMP '2004-11-13 00:00:00.0', 31446),
(456, 'MO743231', TIMESTAMP '2004-04-30 00:00:00.0', 1699),
(458, 'DD995006', TIMESTAMP '2004-11-15 00:00:00.0', 34547),
(458, 'NA377824', TIMESTAMP '2004-02-06 00:00:00.0', 24995),
(458, 'OO606861', TIMESTAMP '2003-06-13 00:00:00.0', 61073),
(462, 'ED203908', TIMESTAMP '2005-04-15 00:00:00.0', 37558),
(462, 'GC60330', TIMESTAMP '2003-11-08 00:00:00.0', 11862),
(462, 'PE176846', TIMESTAMP '2004-11-27 00:00:00.0', 49504),
(471, 'AB661578', TIMESTAMP '2004-07-28 00:00:00.0', 12335),
(471, 'CO645196', TIMESTAMP '2003-12-10 00:00:00.0', 37879),
(473, 'LL427009', TIMESTAMP '2004-02-17 00:00:00.0', 7279),
(473, 'PC688499', TIMESTAMP '2003-10-27 00:00:00.0', 21673),
(475, 'JP113227', TIMESTAMP '2003-12-09 00:00:00.0', 8235),
(475, 'PB951268', TIMESTAMP '2004-02-13 00:00:00.0', 37850),
(484, 'GK294076', TIMESTAMP '2004-10-26 00:00:00.0', 3221),
(484, 'JH546765', TIMESTAMP '2003-11-29 00:00:00.0', 51503),
(486, 'BL66528', TIMESTAMP '2004-04-14 00:00:00.0', 7287),
(486, 'HS86661', TIMESTAMP '2004-11-23 00:00:00.0', 48996),
(486, 'JB117768', TIMESTAMP '2003-03-20 00:00:00.0', 27399),
(487, 'AH612904', TIMESTAMP '2003-09-28 00:00:00.0', 34100),
(487, 'PT550181', TIMESTAMP '2004-02-29 00:00:00.0', 16118),
(489, 'OC773849', TIMESTAMP '2003-12-04 00:00:00.0', 27542),
(489, 'PO860906', TIMESTAMP '2004-01-31 00:00:00.0', 8477),
(495, 'BH167026', TIMESTAMP '2003-12-26 00:00:00.0', 63731);
INSERT INTO PUBLIC.PAYMENTS(CUSTOMERNUMBER, CHECKNUMBER, PAYMENTDATE, AMOUNT) VALUES
(495, 'FN155234', TIMESTAMP '2004-05-14 00:00:00.0', 7129),
(496, 'EU531600', TIMESTAMP '2005-06-25 00:00:00.0', 34332),
(496, 'MB342426', TIMESTAMP '2003-07-16 00:00:00.0', 37754),
(496, 'MN89921', TIMESTAMP '2004-12-31 00:00:00.0', 58593),
(496, 'PL783960', TIMESTAMP '2003-11-29 00:00:00.0', 26421);
DROP TABLE IF EXISTS PUBLIC.PRODUCTS;
CREATE MEMORY TABLE PUBLIC.PRODUCTS(
    PRODUCTCODE VARCHAR(50) NOT NULL,
    PRODUCTNAME VARCHAR(70) NOT NULL,
    PRODUCTLINE VARCHAR(50) NOT NULL,
    PRODUCTSCALE VARCHAR(10) NOT NULL,
    PRODUCTVENDOR VARCHAR(50) NOT NULL,
    PRODUCTDESCRIPTION LONGVARCHAR NOT NULL,
    QUANTITYINSTOCK SMALLINT NOT NULL,
    BUYPRICE NUMERIC(17) NOT NULL,
    MSRP NUMERIC(17) NOT NULL
);
ALTER TABLE PUBLIC.PRODUCTS ADD CONSTRAINT PUBLIC.CONSTRAINT_F PRIMARY KEY(PRODUCTCODE);
-- 110 +/- SELECT COUNT(*) FROM PUBLIC.PRODUCTS;
INSERT INTO PUBLIC.PRODUCTS(PRODUCTCODE, PRODUCTNAME, PRODUCTLINE, PRODUCTSCALE, PRODUCTVENDOR, PRODUCTDESCRIPTION, QUANTITYINSTOCK, BUYPRICE, MSRP) VALUES
('S10_1678', '1969 Harley Davidson Ultimate Chopper', 'Motorcycles', '1:10', 'Min Lin Diecast', 'This replica features working kickstand, front suspension, gear-shift lever, footbrake lever, drive chain, wheels and steering. All parts are particularly delicate due to their precise scale and require special care and attention.', 7933, 49, 96),
('S10_1949', '1952 Alpine Renault 1300', 'Classic Cars', '1:10', 'Classic Metal Creations', 'Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 7305, 99, 214),
('S10_2016', '1996 Moto Guzzi 1100i', 'Motorcycles', '1:10', 'Highway 66 Mini Classics', 'Official Moto Guzzi logos and insignias, saddle bags located on side of motorcycle, detailed engine, working steering, working suspension, two leather seats, luggage rack, dual exhaust pipes, small saddle bag located on handle bars, two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand, diecast metal with plastic parts and baked enamel finish.', 6625, 69, 119),
('S10_4698', '2003 Harley-Davidson Eagle Drag Bike', 'Motorcycles', '1:10', 'Red Start Diecast', 'Model features, official Harley Davidson logos and insignias, detachable rear wheelie bar, heavy diecast metal with resin parts, authentic multi-color tampo-printed graphics, separate engine drive belts, free-turning front fork, rotating tires and rear racing slick, certificate of authenticity, detailed engine, display stand\u000d\u000a, precision diecast replica, baked enamel finish, 1:10 scale model, removable fender, seat and tank cover piece for displaying the superior detail of the v-twin engine', 5582, 91, 194),
('S10_4757', '1972 Alfa Romeo GTA', 'Classic Cars', '1:10', 'Motor City Art Classics', 'Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 3252, 86, 136),
('S10_4962', '1962 LanciaA Delta 16V', 'Classic Cars', '1:10', 'Second Gear Diecast', 'Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 6791, 103, 148),
('S12_1099', '1968 Ford Mustang', 'Classic Cars', '1:12', 'Autoart Studio Design', 'Hood, doors and trunk all open to reveal highly detailed interior features. Steering wheel actually turns the front wheels. Color dark green.', 68, 95, 195),
('S12_1108', '2001 Ferrari Enzo', 'Classic Cars', '1:12', 'Second Gear Diecast', 'Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 3619, 96, 208),
('S12_1666', '1958 Setra Bus', 'Trucks and Buses', '1:12', 'Welly Diecast Productions', 'Model features 30 windows, skylights & glare resistant glass, working steering system, original logos', 1579, 78, 137),
('S12_2823', '2002 Suzuki XREO', 'Motorcycles', '1:12', 'Unimax Art Galleries', 'Official logos and insignias, saddle bags located on side of motorcycle, detailed engine, working steering, working suspension, two leather seats, luggage rack, dual exhaust pipes, small saddle bag located on handle bars, two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand, diecast metal with plastic parts and baked enamel finish.', 9997, 66, 151),
('S12_3148', '1969 Corvair Monza', 'Classic Cars', '1:18', 'Welly Diecast Productions', '1:18 scale die-cast about 10 long doors open, hood opens, trunk opens and wheels roll', 6906, 89, 151),
('S12_3380', '1968 Dodge Charger', 'Classic Cars', '1:12', 'Welly Diecast Productions', '1:12 scale model of a 1968 Dodge Charger. Hood, doors and trunk all open to reveal highly detailed interior features. Steering wheel actually turns the front wheels. Color black', 9123, 75, 117),
('S12_3891', '1969 Ford Falcon', 'Classic Cars', '1:12', 'Second Gear Diecast', 'Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 1049, 83, 173);
INSERT INTO PUBLIC.PRODUCTS(PRODUCTCODE, PRODUCTNAME, PRODUCTLINE, PRODUCTSCALE, PRODUCTVENDOR, PRODUCTDESCRIPTION, QUANTITYINSTOCK, BUYPRICE, MSRP) VALUES
('S12_3990', '1970 Plymouth Hemi Cuda', 'Classic Cars', '1:12', 'Studio M Art Models', 'Very detailed 1970 Plymouth Cuda model in 1:12 scale. The Cuda is generally accepted as one of the fastest original muscle cars from the 1970s. This model is a reproduction of one of the orginal 652 cars built in 1970. Red color.', 5663, 32, 80),
('S12_4473', '1957 Chevy Pickup', 'Trucks and Buses', '1:12', 'Exoto Designs', '1:12 scale die-cast about 20 long Hood opens, Rubber wheels', 6125, 56, 119),
('S12_4675', '1969 Dodge Charger', 'Classic Cars', '1:12', 'Welly Diecast Productions', 'Detailed model of the 1969 Dodge Charger. This model includes finely detailed interior and exterior features. Painted in red and white.', 7323, 59, 115),
('S18_1097', '1940 Ford Pickup Truck', 'Trucks and Buses', '1:18', 'Studio M Art Models', 'This model features soft rubber tires, working steering, rubber mud guards, authentic Ford logos, detailed undercarriage, opening doors and hood,  removable split rear gate, full size spare mounted in bed, detailed interior with opening glove box', 2613, 58, 117),
('S18_1129', '1993 Mazda RX-7', 'Classic Cars', '1:18', 'Highway 66 Mini Classics', 'This model features, opening hood, opening doors, detailed engine, rear spoiler, opening trunk, working steering, tinted windows, baked enamel finish. Color red.', 3975, 84, 142),
('S18_1342', '1937 Lincoln Berline', 'Vintage Cars', '1:18', 'Motor City Art Classics', 'Features opening engine cover, doors, trunk, and fuel filler cap. Color black', 8693, 61, 103),
('S18_1367', '1936 Mercedes-Benz 500K Special Roadster', 'Vintage Cars', '1:18', 'Studio M Art Models', 'This 1:18 scale replica is constructed of heavy die-cast metal and has all the features of the original: working doors and rumble seat, independent spring suspension, detailed interior, working steering system, and a bifold hood that reveals an engine so accurate that it even includes the wiring. All this is topped off with a baked enamel finish. Color white.', 8635, 24, 54),
('S18_1589', '1965 Aston Martin DB5', 'Classic Cars', '1:18', 'Classic Metal Creations', 'Die-cast model of the silver 1965 Aston Martin DB5 in silver. This model includes full wire wheels and doors that open with fully detailed passenger compartment. In 1:18 scale, this model measures approximately 10 inches/20 cm long.', 9042, 66, 124),
('S18_1662', '1980s Black Hawk Helicopter', 'Planes', '1:18', 'Red Start Diecast', '1:18 scale replica of actual Army''s UH-60L BLACK HAWK Helicopter. 100% hand-assembled. Features rotating rotor blades, propeller blades and rubber wheels.', 5330, 77, 158),
('S18_1749', '1917 Grand Touring Sedan', 'Vintage Cars', '1:18', 'Welly Diecast Productions', 'This 1:18 scale replica of the 1917 Grand Touring car has all the features you would expect from museum quality reproductions: all four doors and bi-fold hood opening, detailed engine and instrument panel, chrome-look trim, and tufted upholstery, all topped off with a factory baked-enamel finish.', 2724, 87, 170),
('S18_1889', '1948 Porsche 356-A Roadster', 'Classic Cars', '1:18', 'Gearbox Collectibles', 'This precision die-cast replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 8826, 54, 77),
('S18_1984', '1995 Honda Civic', 'Classic Cars', '1:18', 'Min Lin Diecast', 'This model features, opening hood, opening doors, detailed engine, rear spoiler, opening trunk, working steering, tinted windows, baked enamel finish. Color yellow.', 9772, 94, 142),
('S18_2238', '1998 Chrysler Plymouth Prowler', 'Classic Cars', '1:18', 'Gearbox Collectibles', 'Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 4724, 102, 164),
('S18_2248', '1911 Ford Town Car', 'Vintage Cars', '1:18', 'Motor City Art Classics', 'Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system', 540, 33, 61);
INSERT INTO PUBLIC.PRODUCTS(PRODUCTCODE, PRODUCTNAME, PRODUCTLINE, PRODUCTSCALE, PRODUCTVENDOR, PRODUCTDESCRIPTION, QUANTITYINSTOCK, BUYPRICE, MSRP) VALUES
('S18_2319', '1964 Mercedec Tour Bus', 'Trucks and Buses', '1:18', 'Unimax Art Galleries', 'Exact replica. 100+ parts. working steering system, original logos', 8258, 75, 123),
('S18_2325', '1932 Model A Ford J-Coupe', 'Vintage Cars', '1:18', 'Autoart Studio Design', 'This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system, chrome-covered spare, opening doors, detailed and wired engine', 9354, 58, 127),
('S18_2432', '1926 Ford Fire Engine', 'Trucks and Buses', '1:18', 'Carousel DieCast Legends', 'Gleaming red handsome appearance. Everything is here the fire hoses, ladder, axes, bells, lanterns, ready to fight any inferno.', 2018, 25, 61),
('S18_2581', 'P-51-D Mustang', 'Planes', '1:72', 'Gearbox Collectibles', 'Has retractable wheels and comes with a stand', 992, 49, 84),
('S18_2625', '1936 Harley Davidson El Knucklehead', 'Motorcycles', '1:18', 'Welly Diecast Productions', 'Intricately detailed with chrome accents and trim, official die-struck logos and baked enamel finish.', 4357, 24, 61),
('S18_2795', '1928 Mercedes-Benz SSK', 'Vintage Cars', '1:18', 'Gearbox Collectibles', 'This 1:18 replica features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system, chrome-covered spare, opening doors, detailed and wired engine. Color black.', 548, 73, 169),
('S18_2870', '1999 Indy 500 Monte Carlo SS', 'Classic Cars', '1:18', 'Red Start Diecast', 'Features include opening and closing doors. Color: Red', 8164, 57, 132),
('S18_2949', '1913 Ford Model T Speedster', 'Vintage Cars', '1:18', 'Carousel DieCast Legends', 'This 250 part reproduction includes moving handbrakes, clutch, throttle and foot pedals, squeezable horn, detailed wired engine, removable water, gas, and oil cans, pivoting monocle windshield, all topped with a baked enamel red finish. Each replica comes with an Owners Title and Certificate of Authenticity. Color red.', 4189, 61, 101),
('S18_2957', '1934 Ford V8 Coupe', 'Vintage Cars', '1:18', 'Min Lin Diecast', 'Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System', 5649, 34, 62),
('S18_3029', '1999 Yamaha Speed Boat', 'Ships', '1:18', 'Min Lin Diecast', 'Exact replica. Wood and Metal. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.', 4259, 52, 86),
('S18_3136', '18th Century Vintage Horse Carriage', 'Vintage Cars', '1:18', 'Red Start Diecast', 'Hand crafted diecast-like metal horse carriage is re-created in about 1:18 scale of antique horse carriage. This antique style metal Stagecoach is all hand-assembled with many different parts.\u000d\u000a\u000d\u000aThis collectible metal horse carriage is painted in classic Red, and features turning steering wheel and is entirely hand-finished.', 5992, 61, 105),
('S18_3140', '1903 Ford Model A', 'Vintage Cars', '1:18', 'Unimax Art Galleries', 'Features opening trunk,  working steering system', 3913, 68, 137),
('S18_3232', '1992 Ferrari 360 Spider red', 'Classic Cars', '1:18', 'Unimax Art Galleries', 'his replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 8347, 78, 169),
('S18_3233', '1985 Toyota Supra', 'Classic Cars', '1:18', 'Highway 66 Mini Classics', 'This model features soft rubber tires, working steering, rubber mud guards, authentic Ford logos, detailed undercarriage, opening doors and hood, removable split rear gate, full size spare mounted in bed, detailed interior with opening glove box', 7733, 57, 108),
('S18_3259', 'Collectable Wooden Train', 'Trains', '1:18', 'Carousel DieCast Legends', 'Hand crafted wooden toy train set is in about 1:18 scale, 25 inches in total length including 2 additional carts, of actual vintage train. This antique style wooden toy train model set is all hand-assembled with 100% wood.', 6450, 68, 101);
INSERT INTO PUBLIC.PRODUCTS(PRODUCTCODE, PRODUCTNAME, PRODUCTLINE, PRODUCTSCALE, PRODUCTVENDOR, PRODUCTDESCRIPTION, QUANTITYINSTOCK, BUYPRICE, MSRP) VALUES
('S18_3278', '1969 Dodge Super Bee', 'Classic Cars', '1:18', 'Min Lin Diecast', 'This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 1917, 49, 80),
('S18_3320', '1917 Maxwell Touring Car', 'Vintage Cars', '1:18', 'Exoto Designs', 'Features Gold Trim, Full Size Spare Tire, Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System', 7913, 58, 99),
('S18_3482', '1976 Ford Gran Torino', 'Classic Cars', '1:18', 'Gearbox Collectibles', 'Highly detailed 1976 Ford Gran Torino Starsky and Hutch diecast model. Very well constructed and painted in red and white patterns.', 9127, 73, 147),
('S18_3685', '1948 Porsche Type 356 Roadster', 'Classic Cars', '1:18', 'Gearbox Collectibles', 'This model features working front and rear suspension on accurately replicated and actuating shock absorbers as well as opening engine cover, rear stabilizer flap,  and 4 opening doors.', 8990, 62, 141),
('S18_3782', '1957 Vespa GS150', 'Motorcycles', '1:18', 'Studio M Art Models', 'Features rotating wheels , working kick stand. Comes with stand.', 7689, 33, 62),
('S18_3856', '1941 Chevrolet Special Deluxe Cabriolet', 'Vintage Cars', '1:18', 'Exoto Designs', 'Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system, leather upholstery. Color black.', 2378, 65, 106),
('S18_4027', '1970 Triumph Spitfire', 'Classic Cars', '1:18', 'Min Lin Diecast', 'Features include opening and closing doors. Color: White.', 5545, 92, 144),
('S18_4409', '1932 Alfa Romeo 8C2300 Spider Sport', 'Vintage Cars', '1:18', 'Exoto Designs', 'This 1:18 scale precision die cast replica features the 6 front headlights of the original, plus a detailed version of the 142 horsepower straight 8 engine, dual spares and their famous comprehensive dashboard. Color black.', 6553, 43, 92),
('S18_4522', '1904 Buick Runabout', 'Vintage Cars', '1:18', 'Exoto Designs', 'Features opening trunk,  working steering system', 8290, 53, 88),
('S18_4600', '1940s Ford truck', 'Trucks and Buses', '1:18', 'Motor City Art Classics', 'This 1940s Ford Pick-Up truck is re-created in 1:18 scale of original 1940s Ford truck. This antique style metal 1940s Ford Flatbed truck is all hand-assembled. This collectible 1940''s Pick-Up truck is painted in classic dark green color, and features rotating wheels.', 3128, 85, 121),
('S18_4668', '1939 Cadillac Limousine', 'Vintage Cars', '1:18', 'Studio M Art Models', 'Features completely detailed interior including Velvet flocked drapes,deluxe wood grain floor, and a wood grain casket with seperate chrome handles', 6645, 23, 50),
('S18_4721', '1957 Corvette Convertible', 'Classic Cars', '1:18', 'Classic Metal Creations', '1957 die cast Corvette Convertible in Roman Red with white sides and whitewall tires. 1:18 scale quality die-cast with detailed engine and underbvody. Now you can own The Classic Corvette.', 1249, 70, 149),
('S18_4933', '1957 Ford Thunderbird', 'Classic Cars', '1:18', 'Studio M Art Models', 'This 1:18 scale precision die-cast replica, with its optional porthole hardtop and factory baked-enamel Thunderbird Bronze finish, is a 100% accurate rendition of this American classic.', 3209, 34, 71),
('S24_1046', '1970 Chevy Chevelle SS 454', 'Classic Cars', '1:24', 'Unimax Art Galleries', 'This model features rotating wheels, working streering system and opening doors. All parts are particularly delicate due to their precise scale and require special care and attention. It should not be picked up by the doors, roof, hood or trunk.', 1005, 49, 73),
('S24_1444', '1970 Dodge Coronet', 'Classic Cars', '1:24', 'Highway 66 Mini Classics', '1:24 scale die-cast about 18 long doors open, hood opens and rubber wheels', 4074, 32, 58);
INSERT INTO PUBLIC.PRODUCTS(PRODUCTCODE, PRODUCTNAME, PRODUCTLINE, PRODUCTSCALE, PRODUCTVENDOR, PRODUCTDESCRIPTION, QUANTITYINSTOCK, BUYPRICE, MSRP) VALUES
('S24_1578', '1997 BMW R 1100 S', 'Motorcycles', '1:24', 'Autoart Studio Design', 'Detailed scale replica with working suspension and constructed from over 70 parts', 7003, 61, 113),
('S24_1628', '1966 Shelby Cobra 427 S/C', 'Classic Cars', '1:24', 'Carousel DieCast Legends', 'This diecast model of the 1966 Shelby Cobra 427 S/C includes many authentic details and operating parts. The 1:24 scale model of this iconic lighweight sports car from the 1960s comes in silver and it''s own display case.', 8197, 29, 50),
('S24_1785', '1928 British Royal Navy Airplane', 'Planes', '1:24', 'Classic Metal Creations', 'Official logos and insignias', 3627, 67, 109),
('S24_1937', '1939 Chevrolet Deluxe Coupe', 'Vintage Cars', '1:24', 'Motor City Art Classics', 'This 1:24 scale die-cast replica of the 1939 Chevrolet Deluxe Coupe has the same classy look as the original. Features opening trunk, hood and doors and a showroom quality baked enamel finish.', 7332, 23, 33),
('S24_2000', '1960 BSA Gold Star DBD34 1960', 'Motorcycles', '1:24', 'Highway 66 Mini Classics', 'Detailed scale replica with working suspension and constructed from over 70 parts', 15, 37, 76),
('S24_2011', '18th century schooner', 'Ships', '1:24', 'Carousel DieCast Legends', 'All wood with canvas sails. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with 4 masts, all square-rigged.', 1898, 82, 123),
('S24_2022', '1938 Cadillac V-16 Presidential Limousine', 'Vintage Cars', '1:24', 'Classic Metal Creations', 'This 1:24 scale precision die cast replica of the 1938 Cadillac V-16 Presidential Limousine has all the details of the original, from the flags on the front to an opening back seat compartment complete with telephone and rifle. Features factory baked-enamel black finish, hood goddess ornament, working jump seats.', 2847, 21, 45),
('S24_2300', '1962 Volkswagen Microbus', 'Trucks and Buses', '1:24', 'Autoart Studio Design', 'This 1:18 scale die cast replica of the 1962 Microbus is loaded with features: A working steering system, opening front doors and tailgate, and famous two-tone factory baked enamel finish, are all topped of by the sliding, real fabric, sunroof.', 2327, 61, 128),
('S24_2360', '1982 Ducati 900 Monster', 'Motorcycles', '1:24', 'Highway 66 Mini Classics', 'Features two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand', 6840, 47, 69),
('S24_2766', '1949 Jaguar XK 120', 'Classic Cars', '1:24', 'Classic Metal Creations', 'Precision-engineered from original Jaguar specification in perfect scale ratio. Features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 2350, 47, 91),
('S24_2840', '1958 Chevy Corvette Limited Edition', 'Classic Cars', '1:24', 'Carousel DieCast Legends', 'The operating parts of this 1958 Chevy Corvette Limited Edition are particularly delicate due to their precise scale and require special care and attention. Features rotating wheels, working streering, opening doors and trunk. Color dark green.', 2542, 16, 35),
('S24_2841', '1900s Vintage Bi-Plane', 'Planes', '1:24', 'Autoart Studio Design', 'Hand crafted diecast-like metal bi-plane is re-created in about 1:24 scale of antique pioneer airplane. All hand-assembled with many different parts. Hand-painted in classic yellow and features correct markings of original airplane.', 5942, 34, 69),
('S24_2887', '1952 Citroen-15CV', 'Classic Cars', '1:24', 'Exoto Designs', 'Precision crafted hand-assembled 1:18 scale reproduction of the 1952 15CV, with its independent spring suspension, working steering system, opening doors and hood, detailed engine and instrument panel, all topped of with a factory fresh baked enamel finish.', 1452, 73, 117),
('S24_2972', '1982 Lamborghini Diablo', 'Classic Cars', '1:24', 'Second Gear Diecast', 'This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 7723, 16, 38);
INSERT INTO PUBLIC.PRODUCTS(PRODUCTCODE, PRODUCTNAME, PRODUCTLINE, PRODUCTSCALE, PRODUCTVENDOR, PRODUCTDESCRIPTION, QUANTITYINSTOCK, BUYPRICE, MSRP) VALUES
('S24_3151', '1912 Ford Model T Delivery Wagon', 'Vintage Cars', '1:24', 'Min Lin Diecast', 'This model features chrome trim and grille, opening hood, opening doors, opening trunk, detailed engine, working steering system. Color white.', 9173, 47, 89),
('S24_3191', '1969 Chevrolet Camaro Z28', 'Classic Cars', '1:24', 'Exoto Designs', '1969 Z/28 Chevy Camaro 1:24 scale replica. The operating parts of this limited edition 1:24 scale diecast model car 1969 Chevy Camaro Z28- hood, trunk, wheels, streering, suspension and doors- are particularly delicate due to their precise scale and require special care and attention.', 4695, 51, 86),
('S24_3371', '1971 Alpine Renault 1600s', 'Classic Cars', '1:24', 'Welly Diecast Productions', 'This 1971 Alpine Renault 1600s replica Features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 7995, 39, 61),
('S24_3420', '1937 Horch 930V Limousine', 'Vintage Cars', '1:24', 'Autoart Studio Design', 'Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system', 2902, 26, 66),
('S24_3432', '2002 Chevy Corvette', 'Classic Cars', '1:24', 'Gearbox Collectibles', 'The operating parts of this limited edition Diecast 2002 Chevy Corvette 50th Anniversary Pace car Limited Edition are particularly delicate due to their precise scale and require special care and attention. Features rotating wheels, poseable streering, opening doors and trunk.', 9446, 62, 107),
('S24_3816', '1940 Ford Delivery Sedan', 'Vintage Cars', '1:24', 'Carousel DieCast Legends', 'Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System. Color black.', 6621, 49, 84),
('S24_3856', '1956 Porsche 356A Coupe', 'Classic Cars', '1:18', 'Classic Metal Creations', 'Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 6600, 98, 140),
('S24_3949', 'Corsair F4U ( Bird Cage)', 'Planes', '1:24', 'Second Gear Diecast', 'Has retractable wheels and comes with a stand. Official logos and insignias.', 6812, 29, 68),
('S24_3969', '1936 Mercedes Benz 500k Roadster', 'Vintage Cars', '1:24', 'Red Start Diecast', 'This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system and rubber wheels. Color black.', 2081, 22, 41),
('S24_4048', '1992 Porsche Cayenne Turbo Silver', 'Classic Cars', '1:24', 'Exoto Designs', 'This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 6582, 70, 118),
('S24_4258', '1936 Chrysler Airflow', 'Vintage Cars', '1:24', 'Second Gear Diecast', 'Features opening trunk,  working steering system. Color dark green.', 4710, 57, 97),
('S24_4278', '1900s Vintage Tri-Plane', 'Planes', '1:24', 'Unimax Art Galleries', 'Hand crafted diecast-like metal Triplane is Re-created in about 1:24 scale of antique pioneer airplane. This antique style metal triplane is all hand-assembled with many different parts.', 2756, 36, 72),
('S24_4620', '1961 Chevrolet Impala', 'Classic Cars', '1:18', 'Classic Metal Creations', 'This 1:18 scale precision die-cast reproduction of the 1961 Chevrolet Impala has all the features-doors, hood and trunk that open; detailed 409 cubic-inch engine; chrome dashboard and stick shift, two-tone interior; working steering system; all topped of with a factory baked-enamel finish.', 7869, 32, 81),
('S32_1268', '1980\u0092s GM Manhattan Express', 'Trucks and Buses', '1:32', 'Motor City Art Classics', 'This 1980\u0092s era new look Manhattan express is still active, running from the Bronx to mid-town Manhattan. Has 35 opeining windows and working lights. Needs a battery.', 5099, 54, 96);
INSERT INTO PUBLIC.PRODUCTS(PRODUCTCODE, PRODUCTNAME, PRODUCTLINE, PRODUCTSCALE, PRODUCTVENDOR, PRODUCTDESCRIPTION, QUANTITYINSTOCK, BUYPRICE, MSRP) VALUES
('S32_1374', '1997 BMW F650 ST', 'Motorcycles', '1:32', 'Exoto Designs', 'Features official die-struck logos and baked enamel finish. Comes with stand.', 178, 67, 100),
('S32_2206', '1982 Ducati 996 R', 'Motorcycles', '1:32', 'Gearbox Collectibles', 'Features rotating wheels , working kick stand. Comes with stand.', 9241, 24, 40),
('S32_2509', '1954 Greyhound Scenicruiser', 'Trucks and Buses', '1:32', 'Classic Metal Creations', 'Model features bi-level seating, 50 windows, skylights & glare resistant glass, working steering system, original logos', 2874, 26, 54),
('S32_3207', '1950''s Chicago Surface Lines Streetcar', 'Trains', '1:32', 'Gearbox Collectibles', 'This streetcar is a joy to see. It has 80 separate windows, electric wire guides, detailed interiors with seats, poles and drivers controls, rolling and turning wheel assemblies, plus authentic factory baked-enamel finishes (Green Hornet for Chicago and Cream and Crimson for Boston).', 8601, 27, 62),
('S32_3522', '1996 Peterbilt 379 Stake Bed with Outrigger', 'Trucks and Buses', '1:32', 'Red Start Diecast', 'This model features, opening doors, detailed engine, working steering, tinted windows, detailed interior, die-struck logos, removable stakes operating outriggers, detachable second trailer, functioning 360-degree self loader, precision molded resin trailer and trim, baked enamel finish on cab', 814, 34, 65),
('S32_4289', '1928 Ford Phaeton Deluxe', 'Vintage Cars', '1:32', 'Highway 66 Mini Classics', 'This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system', 136, 33, 69),
('S32_4485', '1974 Ducati 350 Mk3 Desmo', 'Motorcycles', '1:32', 'Second Gear Diecast', 'This model features two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand', 3341, 56, 102),
('S50_1341', '1930 Buick Marquette Phaeton', 'Vintage Cars', '1:50', 'Studio M Art Models', 'Features opening trunk,  working steering system', 7062, 27, 44),
('S50_1392', 'Diamond T620 Semi-Skirted Tanker', 'Trucks and Buses', '1:50', 'Highway 66 Mini Classics', 'This limited edition model is licensed and perfectly scaled for Lionel Trains. The Diamond T620 has been produced in solid precision diecast and painted with a fire baked enamel finish. It comes with a removable tanker and is a perfect model to add authenticity to your static train or car layout or to just have on display.', 1016, 68, 116),
('S50_1514', '1962 City of Detroit Streetcar', 'Trains', '1:50', 'Classic Metal Creations', 'This streetcar is a joy to see. It has 99 separate windows, electric wire guides, detailed interiors with seats, poles and drivers controls, rolling and turning wheel assemblies, plus authentic factory baked-enamel finishes (Green Hornet for Chicago and Cream and Crimson for Boston).', 1645, 37, 59),
('S50_4713', '2002 Yamaha YZR M1', 'Motorcycles', '1:50', 'Autoart Studio Design', 'Features rotating wheels , working kick stand. Comes with stand.', 600, 34, 81),
('S700_1138', 'The Schooner Bluenose', 'Ships', '1:700', 'Autoart Studio Design', 'All wood with canvas sails. Measures 31 1/2 inches in Length, 22 inches High and 4 3/4 inches Wide. Many extras.\u000d\u000aThe schooner Bluenose was built in Nova Scotia in 1921 to fish the rough waters off the coast of Newfoundland. Because of the Bluenose racing prowess she became the pride of all Canadians. Still featured on stamps and the Canadian dime, the Bluenose was lost off Haiti in 1946.', 1897, 34, 67),
('S700_1691', 'American Airlines: B767-300', 'Planes', '1:700', 'Min Lin Diecast', 'Exact replia with official logos and insignias and retractable wheels', 5841, 51, 91),
('S700_1938', 'The Mayflower', 'Ships', '1:700', 'Studio M Art Models', 'Measures 31 1/2 inches Long x 25 1/2 inches High x 10 5/8 inches Wide\u000d\u000aAll wood with canvas sail. Extras include long boats, rigging, ladders, railing, anchors, side cannons, hand painted, etc.\u000d\u000a\u000d\u000aThe Mayfower was already old in 1620, when the pilgrims charted her to bring their band of 103 to North America.', 737, 43, 87);
INSERT INTO PUBLIC.PRODUCTS(PRODUCTCODE, PRODUCTNAME, PRODUCTLINE, PRODUCTSCALE, PRODUCTVENDOR, PRODUCTDESCRIPTION, QUANTITYINSTOCK, BUYPRICE, MSRP) VALUES
('S700_2047', 'HMS Bounty', 'Ships', '1:700', 'Unimax Art Galleries', 'Measures 30 inches Long x 27 1/2 inches High x 4 3/4 inches Wide. \u000d\u000aMany extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.', 3501, 40, 91),
('S700_2466', 'America West Airlines B757-200', 'Planes', '1:700', 'Motor City Art Classics', 'Official logos and insignias. Working steering system. Rotating jet engines', 9653, 69, 100),
('S700_2610', 'The USS Constitution Ship', 'Ships', '1:700', 'Red Start Diecast', 'All wood with canvas sails. Measures 31 1/2 Length x 22 3/8 High x 8 1/4 Width. Extras include 4 boats on deck, sea sprite on bow, anchors, copper railing, pilot houses, etc.\u000d\u000a\u000d\u000aThis was one of six warships commissioned by George Washington and launched in 1797. The nickname Old Ironsides was given the ship when British cannonballs bounced off the 21-inch oak planking of the American frigate''s hull. The Constitution has been restored and now resides in Boston Harbor.', 7083, 34, 72),
('S700_2824', '1982 Camaro Z28', 'Classic Cars', '1:18', 'Carousel DieCast Legends', 'Features include opening and closing doors. Color: White. \u000d\u000aMeasures approximately 9 1/2 Long.', 6934, 47, 101),
('S700_2834', 'ATA: B757-300', 'Planes', '1:700', 'Highway 66 Mini Classics', 'Exact replia with official logos and insignias and retractable wheels', 7106, 59, 119),
('S700_3167', 'F/A 18 Hornet 1/72', 'Planes', '1:72', 'Motor City Art Classics', '10 Wingspan with retractable landing gears.Comes with pilot', 551, 54, 80),
('S700_3505', 'The Titanic', 'Ships', '1:700', 'Carousel DieCast Legends', 'Completed model measures 19 1/2 inches long, 9 inches high, 3inches wide and is in barn red/black. All wood and metal.', 1956, 51, 100),
('S700_3962', 'The Queen Mary', 'Ships', '1:700', 'Welly Diecast Productions', 'Exact replica. Wood and Metal. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.', 5088, 54, 99),
('S700_4002', 'American Airlines: MD-11S', 'Planes', '1:700', 'Second Gear Diecast', 'Polished finish. Exact replia with official logos and insignias and retractable wheels', 8820, 36, 74),
('S72_1253', 'Boeing X-32A JSF', 'Planes', '1:72', 'Motor City Art Classics', '10 Wingspan with retractable landing gears.Comes with pilot', 4857, 33, 50),
('S72_3212', 'Pont Yacht', 'Ships', '1:72', 'Unimax Art Galleries', 'Measures 38 inches Long x 33 3/4 inches High. Includes a stand.\u000d\u000aMany extras including rigging, long boats, pilot house, anchors, etc. Comes with 2 masts, all square-rigged', 414, 33, 55);
DROP TABLE IF EXISTS PUBLIC.TRIAL_BALANCE;
CREATE MEMORY TABLE PUBLIC.TRIAL_BALANCE(
    "Type" CHAR(1),
    "Account_Num" INTEGER,
    "Category" VARCHAR(57),
    "Category2" VARCHAR(57),
    "Detail" VARCHAR(57),
    "Amount" INTEGER
);
-- 22 +/- SELECT COUNT(*) FROM PUBLIC.TRIAL_BALANCE;
INSERT INTO PUBLIC.TRIAL_BALANCE("Type", "Account_Num", "Category", "Category2", "Detail", "Amount") VALUES
('I', 4100, 'Revenue', 'Direct Sales', 'Direct Sales', 400000),
('I', 4200, 'Revenue', 'Channel Sales', 'Channel Sales', 150000),
('I', 5010, 'Cost of goods', 'Cost of goods available for sale', 'Beginning inventory', -40000),
('I', 5020, 'Cost of goods', 'Cost of goods available for sale', 'Net purchases', -325000),
('I', 5040, 'Cost of goods', 'Ending inventory', 'Ending inventory', 35000),
('E', 5110, 'Expenses', 'Selling expenses', 'Sales salaries', -48000),
('E', 5120, 'Expenses', 'Selling expenses', 'Nonrecurring item', -12000),
('E', 5130, 'Expenses', 'Selling expenses', 'Other', -13000),
('E', 5310, 'Expenses', 'General and administrative expenses', 'Office salaries', -27100),
('E', 5320, 'Expenses', 'General and administrative expenses', 'Depreciation', -5500),
('E', 5330, 'Expenses', 'General and administrative expenses', 'Amortization', -3200),
('E', 5340, 'Expenses', 'General and administrative expenses', 'Bad debt', -4500),
('E', 5350, 'Expenses', 'General and administrative expenses', 'Other', -24200),
('I', 6110, 'Other revenues', 'Interest', 'Interest', 5200),
('I', 6120, 'Other revenues', 'Dividends', 'Dividends', 7200),
('I', 6130, 'Other revenues', 'Gain on sale of equipment', 'Gain on sale of equipment', 8600),
('E', 7110, 'Other expenses', 'Interest', 'Interest', -9400),
('E', 7120, 'Other expenses', 'Writeoff - goodwill', 'Writeoff - goodwill', -5000),
('E', 7130, 'Other expenses', 'Unusual item - loss on sale of long-term investment', 'Unusual item - loss on sale of long-term investment', -5100),
('E', 7200, 'Income tax expense', 'Income tax expense', 'Income tax expense', -33600),
('I', 9100, 'Extraordinary item - gain on disposal of business segment', 'Extraordinary item - gain on disposal of business segment', 'Extraordinary item - gain on disposal of business segment', 24000),
('I', 9200, 'Other Comprehensive Income', 'Other Comprehensive Income', 'Other Comprehensive Income', 12000);
CREATE CACHED TABLE PUBLIC.DIM_TERRITORIES(
    ID BIGINT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_B4ADD799_499E_49DC_997F_E4924C2E21EC) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_B4ADD799_499E_49DC_997F_E4924C2E21EC,
    TERRITORY VARCHAR(20)
);
ALTER TABLE PUBLIC.DIM_TERRITORIES ADD CONSTRAINT PUBLIC.CONSTRAINT_FF PRIMARY KEY(ID);
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.DIM_TERRITORIES;
INSERT INTO PUBLIC.DIM_TERRITORIES(ID, TERRITORY) VALUES
(1, 'USA'),
(2, 'EMEA'),
(3, 'Japan'),
(4, 'N/A'),
(5, 'Asia');
CREATE UNIQUE INDEX PUBLIC.IDX_DIM_TERRITORIES_PK ON PUBLIC.DIM_TERRITORIES(ID);
CREATE INDEX PUBLIC.IDX_DIM_TERRITORIES_LOOKUP ON PUBLIC.DIM_TERRITORIES(TERRITORY);
DROP TABLE IF EXISTS PUBLIC.CHECK_SEQUENCE;
CREATE CACHED TABLE PUBLIC.CHECK_SEQUENCE(
    PID TINYINT,
    VALUE VARCHAR(1),
    SEQUENCE DOUBLE
);
-- 60 +/- SELECT COUNT(*) FROM PUBLIC.CHECK_SEQUENCE;
INSERT INTO PUBLIC.CHECK_SEQUENCE(PID, VALUE, SEQUENCE) VALUES
(1, 'A', 1.0),
(2, 'B', 2.0),
(3, 'C', 3.0),
(4, 'D', 4.0),
(5, 'E', 5.0),
(6, 'F', 6.0),
(1, 'A', 1.0),
(2, 'B', 2.0),
(3, 'C', 3.0),
(4, 'D', 4.0),
(5, 'E', 5.0),
(6, 'F', 6.0),
(1, 'A', 1.0),
(2, 'B', 2.0),
(3, 'C', 3.0),
(4, 'D', 4.0),
(5, 'E', 5.0),
(6, 'F', 6.0),
(1, 'A', 1.0),
(2, 'B', 2.0),
(3, 'C', 3.0),
(4, 'D', 4.0),
(5, 'E', 5.0),
(6, 'F', 6.0),
(1, 'A', 1.0),
(2, 'B', 2.0),
(3, 'C', 3.0),
(4, 'D', 4.0),
(5, 'E', 5.0),
(6, 'F', 6.0),
(1, 'A', 1.0),
(2, 'B', 2.0),
(3, 'C', 3.0),
(4, 'D', 4.0),
(5, 'E', 5.0),
(6, 'F', 6.0),
(1, 'A', 1.0),
(2, 'B', 2.0),
(3, 'C', 3.0),
(4, 'D', 4.0),
(5, 'E', 5.0),
(6, 'F', 6.0),
(1, 'A', 1.0),
(2, 'B', 2.0),
(3, 'C', 3.0),
(4, 'D', 4.0),
(5, 'E', 5.0),
(6, 'F', 6.0),
(1, 'A', 1.0),
(2, 'B', 2.0),
(3, 'C', 3.0),
(4, 'D', 4.0),
(5, 'E', 5.0),
(6, 'F', 6.0),
(1, 'A', 1.0),
(2, 'B', 2.0),
(3, 'C', 3.0),
(4, 'D', 4.0),
(5, 'E', 5.0),
(6, 'F', 6.0);
DROP TABLE IF EXISTS PUBLIC.BLOB_TEST;
CREATE CACHED TABLE PUBLIC.BLOB_TEST(
    FILENAME VARCHAR(500),
    SHORT_FILENAME VARCHAR(500),
    PATH VARCHAR(500),
    TYPE VARCHAR(500),
    "EXISTS" BOOLEAN,
    ISHIDDEN BOOLEAN,
    ISREADABLE BOOLEAN,
    ISWRITEABLE BOOLEAN,
    LASTMODIFIEDTIME TIMESTAMP,
    SIZE DOUBLE,
    EXTENSION VARCHAR(2147483647),
    URI VARCHAR(2147483647),
    ROOTURI VARCHAR(2147483647),
    CONTENT BLOB
);
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.BLOB_TEST;
DROP TABLE IF EXISTS SYSTEM_LOB_STREAM;
CREATE TABLE SYSTEM_LOB_STREAM(ID INT NOT NULL, PART INT NOT NULL, CDATA VARCHAR, BDATA BINARY);
CREATE PRIMARY KEY SYSTEM_LOB_STREAM_PRIMARY_KEY ON SYSTEM_LOB_STREAM(ID, PART);
CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_CLOB FOR "org.h2.command.dml.ScriptCommand.combineClob";
CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_BLOB FOR "org.h2.command.dml.ScriptCommand.combineBlob";
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 0, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 1, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 2, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 3, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 4, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 5, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 6, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 7, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 8, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 9, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 10, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 11, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 12, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 13, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 14, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 15, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 16, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 17, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 18, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 19, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 20, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 21, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 22, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 23, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 24, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 25, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 26, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 27, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 28, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 29, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 30, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 31, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 32, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 33, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 34, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 35, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 36, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 37, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 38, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 39, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 40, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 41, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 42, NULL, 'd28e7a613c179e0bd25c5f04066bf9ed9122f867ff5d9123fff4f1f17ff22308080282802020080802828020200808028280202008080282c02111f8ff7627261492c3582f0000000049454e44ae426082');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 0, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 1, NULL, 'a65f0a20f9d27efa55f0e7c41f91efdb2691d1eaa524cb49daf4ef6f9bf482e3e4199f6be3df9ef1b99da4847efff6b1a0419a3138d6cb55707fdd284ff20f8601acae7df7dd75c682f7fada9fdff8a3beb6addf3be39a361638a5c6d0a0e8fee7cfff522f4df62019fa6f3acdd92e5623cf22cc1067e69d3ee498d664c31e8749b484c69d8eb65ff020794df7038aeefdccc612b341a08c98c1342424f997cf9c16e869283691c6b14dcd499a7e5b3f107da2f397fda8b5b02851af5b76bb694ecda5325f3a24a0343032c211cab9b0165b76f1ade842bcc9819e044a43dc077309d1584b23dccabb4458cf69d4fbb961155fe588541498075aa759ae74360a94dd78e909d6f1e69dce2e2895fe76da21237b05ef63fabfe0b202a2d909b40b90a574aa6d772d3b23e8c67a370bb3cda773babb4a58e7c4f3a8002a800a144e81ab7fd180072a800aa00209152043baff3df838d983f4e2592709495e36efe4a5044ae79cea37ebe457669dfce2cc93ffd074f26fa69dfacbc9a7febcf1d41f8f3bf587a34ffde1f0e3fff5a6ceffdf57e9b895ffec1885903f230a21df9a855c71ace1d2f7e928f8ebff9bec417a68c4c504473bc75c7668f4a572c4d939e88bfcf3c7c78f755d4ea094bc1a7a938013833cc99f64015e02a56487181b4a3f75f3497210348547c3ec5fb188e85da70f0d08edac768aafb37fc581edfc4d640c4d427c9b4f2327fbff9202d5f7b75df0107951d33c79c63fece7df9ef10f6f9012fa3dfe1b06a5779e7ea55ee3859b8320152d531a236b3c5d37e0f4b38ed062fb4e6cbc791eff4cadbdf0444333a3cdfbf6edebfb90d220cb054b13ed0259f8b78daf917c1d34b23a56b4d1c81b66123fcfda65b57de13146205a63594a46aa67b5b34ab91a4c43ca57cf9e16e8692876fe63ae2a98aaa79d75279f75b9efbe1f8beca228d1f630d90dbff33f0dcd9991cce00b4f3693d796c93ba5c4c8a0278439c25d72d034e229cd2f7a9303771028353b43e03ed61b792ed052657950becbadae9ee372baecd8c4110dcdd4954cde28cb95ce53b45ea40c5b4e97e9e27d155e0eccb9d1bd42f631b138b0b85e5807d03ba19140bb00956ec12519da7bf52bd7fc89d0c50ffabfc3b6d8cee9ec2a3e27c5d334fe4c0d0f5400154005500154001540056a48013262fcf4805f7c71c2f17ed34f5c3c9badf36afdfb9ba6537f39f5c33f9b7cea8f269cfaaf634efdfeb0e3bf7743d7bf3f870e90f9d0c82ee4e239272f9c7df2abb34e7e79d6c92fcc3af98fb34ec9424862b31002a557b031f0859f6ebff18b1d43fa1d1a79f1a1519748433a877eb973d017ba06c0d5776ffa20024a0f1d3a445e2b25686aac75f4c941bf24c72706d2a3a1ffaf5bbb3eead79f7cf865433389679ea01c3294ae7e44c7d0677536f4ff156592bede8984dc86fe82e1c16642536c3c4a09f08c9b7b1d27ffa13d80d2b748c9c1a87d3dc9482b8a3d667f040ce086b140d3599d9437e89b93a428661859eb881af96b5a1d05cc03e7d3af42da755667bfc719420f255944b1fb1e2291d5ada71935da163a13ccfe28b4ed24727b2131831ad9dacc15204d08cc169f99d994af7e701a6f0265065db1292155bcf66bda046100f1542f55431425144e263b6c20139c2913184ca1f407a7c53bc2ed5c267bdfb30b69d3a426e433a3c7c31b6f66e799017d2f901738b75235ec6e491dcd3cab4413d5b179bf2eb7461bacf57369b9e688c61f839255af086ca0cee2170879cab0fef429b0df820be7acf758ffdc35913541fa8541a9dd2b5846e94ae6e2beef3f4d7b359148ca228d7127d05aa1740b3a18e83cfae5ac5fb9d6a5ea63dbaf5b3d3a67fc8f40ecaf0426400550015400154005500154a0b6142083beff7ec32fc8be2f5f9e74e2fce9142fed7f7f33e3d4a7a77df8df277ff807133efc8fa34efdcee0e3675cd3f9db67b3482953c32ee48299a7facd3c79eeac9367cf3ef9f95927ff8140695008496c1642c2ad571c27e7dbcefdef07aefec78303bedc31e47c69c6a1a1e7760e39bb73e0e7bb06fc43cf8d7fc3cf37102225b105fe871d29252c4af686215c4af68681df7e72f86f3e31fc57e46818f471c3fcdf501210ff7ed33c7e2be590e90c0fd4bf53133f4356dfd97a1a81d83bc5ba4ae4cbd615eb69e26b9d278331f13fbe45d0b7df7779a49426e6301c7d34cc0b06f75fe90cb2b380d2c5bf6cb8fb630a4b9ff90131a6f1753ad09fc4aa609f2948f3af780966bb58edfd36bf27bf68dbf614dd9af22b9d7a7af63d19fd033bc312b80519d84efb05fbd7f6ddded33f432cff55337d6198fe6bfd2e67fbbb4873b8d9cfce2136872ae6a8023aa89370386bc2dd74771f687922d98d06b6aed92a9419c8388440e9677ec00a8c71449867a1ec7d7da7365e439b4f124f7c51f9a9edb157e90b9cfff85684fb1ab85084d998a36575b01c697c8cc1037a4127e1cefa95289fc01beb57e24ff2faaede751beea60f90c03f12308fbc70409760b9f8e5e0ee15862b4107f84df3f41f9cae379c1aa9ae4a9940eb4eaa2141bbc43329c7e56c66341c1a6f1bbcf4c23b67ec8f00264005500154a0d00a34f4ff080f5400154005922a40c6887f78cd2ffe76e8f17f1d77fccb93dd50fa574d1ffec5b40fffdfc91ffe97091ffeeec80fffdd2dc74fbbb2f39367d20132afcea710388a350bb9fe970dd7d078d2bb67fde1fe4bff96ecfe42b8f4f8f71f23670e0dfacaa141671f1af8c5ce01ffdcd5ff73ddd7ff55cf357f41eb8d865202a2dbb76f7ff5d5578d19bc9f1addf78991bf2107a1537234dcf41c2181601aed5da7dff49b86457d64b02e1780215f9df1072da7b1c434fd652d3c318596cb424f360cdf4501e35f76f15ca79d47c26eb470fe67f4210d38fdbc5e3b3b31409dff17615bbf278920040ce6c9afec76c94a8931e2dd4e12cf0caa80e9851affeb39d96a432898c02d086bbe508955d130bcf7f4ff25cf50cdb9a9a7fd8b50324231bb0aad75819d32d919ec0cd384c08fb7eca02768ce6596f332a11f9d8e88f02c973de8692da7df1438972900b572764b59b2104af78e54d2e8993106eb4da6ad3eafd77084f8135c02f685c0ae91bb4e9f1579e1802e21d2936b2da45718ae547f865c447602a315ac076a9764d8e5ec4c06dd1a6b9b4fe78cfd11c004a8002a800a145a01fadc1f0f5400154005122a40c6eefff9ca5f7c7ac0f1cf8e38fe2fe38e7fb1f1c4171b4f7e7ee2897f9974e29f269ff8dc94937f3de5d4a7279ffad349a7fe68fca9ff38fac333869e3aadfff14f5e76e8135f64abefb2ea4a2d8490edf534dcbaf70bff99cce0dd7ff967dbaffb9783377ef1e04d5f3c78e3e73b6efc978e1bffe9d00d9febbceeafbbaefa74f7e57fda7dc91f359030297935548fd8c4fc45b78419df478fd1ea307ef76d26acf08d21850114c05e7ec69f7b05eb8eda29961deeeeeb1787ca1516a1f4ea9242692935360cff0d7d3ee3fad75873c2860995a2df96a239e64505500154001540055001540015a82505c850fa772f39f227d7bdf7995bdeff3f43dfffbf238efdfdc8639f1df9c167477df0b7633ef8abb11f7c7aec2ffe74cc2ffe68d4f1df1f7e9c4cdcfd7ffaffe293d7bedf70d181867f7d82e4e5529458880cb7befd4fbfbbfb2b7fb2f76b9f79f71bffa7ed8affbbefaabfdf77c567f75df9d9fd57feed812bfeeae0659f3e78c99f767ced8f3afafd3e8552cea59f1afa2b72fcf6c88ffe9f311fd3633c3b1a7f631cbf3dee37e41050aa732964d4d396f6f1f9a5679c7f189eafd8676e00fbf751f3528d9f6d1b44e29ebe7ee7df75c6bfee4a6ae469039e3f838534cff8dfcf9f06403d6939b94a4f1a1220228b940e88d13013e34f1bad82c332f2c94282db4eaf1561a385aafa8593891f735e482ddd78b02da8002a800aa002a8002a800a40053a8e7cf4991bdb7effeb6d7f7c45db9f5f7be0d3d7efffcb1bf6fdc5f5fbffe78d07fefcc603fffdc6037f7c53c77fbdb1e3f76f38f4bbd775fcbbab0ffdd6e5873e71f18186737ffaa7177f5742698985d0706bff8f4821af9eff9957fef9f75ff9d21fef3ce7cf777ef5d33bbffa973bcffb8bd7befa3f5f3fefcfdf38f7bfbf75ee1fbff5e5fffab3b37effad2ffe6e03d9568143295fbb8872e9f05f9a683afe63cea26144eaec0a7c029e9c0a5bf9ee226700fa043f79623ebfb4f2a6e6b3463e09534e13cda791b56755d52f9cda93145b840aa002a8002a800aa002a8409d283078e389d7de39f6992b7ff83b677ee73f9ef3f47f3af7c9ff7cee13ffe99c277effdca77effbca77fefdc677ee7dc67fffdb9df3ffd9c1f92958d3e75e6b39f38f3870d9f7fe64f2f7e62e7db47485eae5249856c38cea174f0fae3477ff6dabf9df39907fef7ef6cfebbffb8e9b3ffe9e1cffde787ffee3f6dfedcef6ff9dcef6ffdecef6dffbbdfd9f1b7fffeb1bf397dfb5ffd368552ba47ea751f7caaff317ad090e97181a6844e19a0f2e353237e6d1fdc6e1e65c5031540055081fc2b80ef68a102a8002a800aa002a8002a50ab0a9c36f8d78337d0956f13fd23514d928be4e5b2a42f64fd07a7dd7c8a2ee17bfd2f4fbbe1d4e03bc4cea3b1c634345cdede70f52176f4d23d4bfb1f254b1f7d6ad03171504095075d6ed73888d1c1c6301edbb4d4d682cbb823052a800a1453015cd0121540055081422880232b54001540058aa000596b97ad6c4456dca5db9c92fd60ae3ad970f5297a900f571c6fb8f4b8f82fff208f4bdf6ff8da7b0de4bfe44cc3175f69f8cace4f9cf3da27cfa547c3056ff3e31317ede147c325fb1a2e6a6fb8e480382edbaf3ef393e45b3c50015400154005500154001540053254e0bc7d0d78a002a8002a907f052edcd77061bbfbf7ea2b7b1ace62c71783e34bef883ff97972f03384482994322e9568ca01d53878027ac8f420a3fa5626c30fa8002a800ae44f01fea387072a800aa0023957400cb7f8580b0f540015400572ac40063fa787bbdfcefcf8ecf0e7cb74646e2a16880aa002a8002a800aa002a8002a800aa002a8002a5045051aca5177998894145b0e6bb14c5400154005500154001540055001540015400550816a2980509a7da0b85abec47a51015400154005500154001540055001540015289c0208a508a5a8002a800aa002a8002a800aa002a8002a800aa0025553c01b4a5f997ff6d9f377fabd809a6cfaeea2f6f6eef61bfd5e432d1cf457c7e096010decdf8896aa75acea341cf6cf243dd6cbdacc0bf4bb9abc6cc3a250015400154005500154001540055081c22a604129197973a011ff066ce763f1242372134a09766a1ba69e7c601158098943a944d348463507e89ab55f58fd4a760c26db9ba4e109f9e1e9d5bad644f2b3573d9db010bbc9f78e68c8540ad2b9cba406d496ba529a4d9a1074bcd49796bfe38c946119fd0b4c6d336644055001540015400550015400154005ea4f0117943a23a24946e40e288d88851a149a144aa5b5946a066ccfdc85491a9e9227b3ada21c3a646ba1f211834ff6e7ce555f38fbec2f88d06e26d5f91782509af9558305a20235adc045235ebf71c6dbfd17ec85c7e0256de418ba621f3986df1a7ff09478a002a8002a800aa002055580dff89cc7a0057be0c16f97e4d6496ea061b8e401a546a454052743c3715e500ac3a72a52baf3816e11546d7f72a73d0dd811295508ad088746f644a49719499b3060');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 2, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 3, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 4, NULL, 'e1aebbbf73e4eeef1ca6c7bf05c76387ef26c7a387373eda4b8f1dbd1bb7ab63fd969ec5dfee9cf56db214025b01febe436bb6f590f9b7e6f1935fb492e355727c208e573e680d8ec79f7fefd647ba667eb383bc504a8e99f71cba6d0b9d099ca890ef3cf7deeafb3a9bd6b4cbe9bb9580d29222a5da7a450d2290e68c9b05ab14d1f580d22d740466e7f2858eb419c27dec2d55f64f541169064b67acb7149c1184a6d6559255f153fab247ec6f3873d87c41d60ff80a92cadd50a7d4c1f46d2a502bdcf6c5788158e9ccbc97cd2a51f6f45d84d2dcf2031a860a64ae805c7d976c09337dfd7e7290158fc86ea533be7560e6bd8251c98ba66187b6f50bb9a9df7328d1f67498181540055001540015a88a0274173478b0ad4ae94166e1ca83bd262a68f3f6034db71f98be663f796b141e7cc55d7854024a4b5a7db72028e53013ac5594412362a6a766500316914881740b1df92c589df9e8190b44055081cc1520504ab6f99eb274efa495bbc93179e5ee29b7ee9dbae6dd696bdaa6ada50785d53bd9c190d5719004c1316ded3e9a110f5400154005500154a0080a90fbddd4d5f4205ba3c983ecdd1d764c59b197ec44ca0f72eb84076151b2ee2e3926ce7f7bccb857cbbbd05149fb942602851c240651b96c2272a24d08a539702e34c1397dd71ef8e2acddcc61000b4405f2a000422922342a800aa002a840dd2a503e28fdfa654fc9bb3c5d3b141ea52f745457509a33744273caa50042691ec0006d4005aaa50081d2c6d97b262edf3b71f99e72fdca60b9a8002a800aa002a8407d283091444a17ed1dd5f86a19a1948f18d2ef535a1f9ec056164e014f28add68819eb45055081b22a80505ab81f6d341815400550015420b70af842a9b6d1a6fe87e75d1fa134b79d000d4ba70042a9e7b58fc950819a5400a134dd2f27e64205500154001540056c05bca03493f1044229f6bf1a5300a134935f062c041528a80208a535f6938ecd41055001540015a8a20208a555141fab2eb60208a5056509341b15c8440184d262ff82a3f5a8002a800aa002795200a1344fde405b0aa500426926237b2c041528a80208a585fac146635101540015400572ad801b4ac968bb1c47e59438b6f3c9efeefca072f595505398a9f6f90235aa043d0a94955c23fd6fb862c2d8c1ab96cdbaf7eed50f3fb0ae1c570d96890aa002f95400a1b4403fd7682a2a800aa002a840ce1580502aeffb0de4d3b83103b33dd2bf534a604c41f2e69f1ff390b4acfc9655e1bc1c8452db9fed4fab31e88b3b7ffe5df311c9932f3eede812117e2105ca8714b43bf9f5a2b88e468c3cf34bff74e1055fb9f1facb860fbd71cca801d95e32581a2a800ae4590184d2b8df48fc1e1540055001540015f0550042a9bcfb0b28f52dc32f5d4950aa11c5d31db13566c58dce8ab22d1ca15417f9839f6ddefc907271c78bc1672894f199a78ff44bc78beb5f6aa735910f4ffeecbdd81ee4938074e9952b576edab4e9cd37df3c76ecd8471f7de493abba69d25f8655b5bba066575533acbcec0a2094965d62ac00154005500154a06e1480502a1b9d6328ed6b7b49128b8aa006812f1853e51cabce58286b47cc18d5fcfc451197e30c6395f09e0cdc41b66128c533326368e1b24661b3230d8894babe7dfa2511240cca341b954dc42f4fbd9dc81bd2a83028955d22fa61818c4b03e22db1e108a5250ae89f1da1d45f2b4c593105104a2b263556840aa002a8002a50f30a54024a67cf9e4d76364d3fac84b0a1e661ea744a698d9c11d1b02068a6ce50e47bb14d73a7134a6509a2225709d1f04332b28a6468ae2f38a36ae767c2a6efca6f8359a6d47885af76c36ba8976a30afb72b0c4a6597888b60d318e977378b670d596886509a858a5e65a4fff5f02a1e13a1026914a83e94b636f25dc31b5bd3d85f6b79da9afbf56bd66ff3b5d6446c0f2a800aa00235ac40d9a194112939fad20f2bedf8277188f6a229894f3edd61438b73926784333d4b70c28f6da4a2d39040ae01a54609b6f12ad607dfb1f498cc5ca0fe1b0196a6208108706ab7beba950c3e8b98761cb526d509a134a962a9d3a7fff5485d25664405e2147042693f8e89f45fb9098920695c1599701a29c46892b3d84cea8ad33ceafbaa1b508af198171540055081ba57c0174a23163f8cd690ddcbfa4a8552356dd5f58621b7c01329cb01a530e8aacc20335189b56d2f29e3019dcac8a7424dd7b7b26992bab326ab9c5d02240e9c64fa2e8cacc62a139b20a11608a509054b9f1ca134bd7698b36c0ab8a154722265b97286307dcacf80d320fab636f20665506c19bc924fabcad0502c1215400550819a542001943adb1f3b580c1eb0961629951130ba2e2be75230595758a67846cc7705697ca7ef9a61b790e9bbc67b89807682aaa94de4f34b649d58beac8e9d06464ac3be654d13c68b3476c36baa67265ee848768958e68c4d905048d2f967ce9c5ea70b1d5576fc17fb3b93d075981c15c840811828ed23381740a90a36b233f2f25160493ed1af544223086a94400b774464f5ec517f311b1a1b8318a83094e6302a06ad086eb532724a0be8d7dc4c4d696ce58d62ff6567c0bc62106b358a37db6bb5df0cd3aaf2b9c94a87c6e6e8aa59bbccec1974032c02154005500154201305d240290d7d06ff62078b3c7166ef947242538b09e9733883ad44e8962169173a12bb9b4a8051b36ae192b0b45eb8d011795f91079355d51c44b58564f534faf45db3047b3eb0c3a4f56aa7934cba433e0a016b3ead576f02db91f0c05ad125dae1d641ae59cd658052b24fe99deb6ef7597d37cb979d4a0042e3824d6f956d4398552558ebff3b938f9e8b56d497023150aa428c149c6488917d12a4474994fca374d5dac8892ee0d82028c925b54b70852bedeceaead30959d415f0a72cde01a501f6c1a0af06d581c5124ae53bae420165bc1962350db68c841d8a7fc92015b2beb20b7ea5aa066945abcb1abfaeaf4b005b8b0aa002a840860a54084a89c5b1f89a61abb02854a0020a902e7ded2d13268c1dfcd4538fc76e09931eff326d4919a134cc4e84d24c3d8885e5478198774ae13c5e6b4e2f6350c27b2cc0c8594bc0aa6bdd2278114990735c593c6c08f051a747f5baab0c6c0a353d5e4f8565c3628d661aa606b1d3365e9169b36e300ca8ca86185156bb7cd9219c558336ab706e7efa105a820aa002a8002a1028900c4ab59f771602e5635cfbbf526119564528c55e57630a902e7dd5907923a72c5bb56cd6cfde7a2d7a9f52134ad548cb9ee0a7af9002820922c0e21868aa996974f0a7b288a1ae543e064a1359654cd20bac526550a3c2fe529318c5dc3f60346ba63687107f3d6aecdaa98de644454ae165eb424a76657232151f014a86b325bcba431ff780ec4e7a74f0a10794d25c4124331194c2b2dd360706dbdf5219839f02fe6d5228b56741c72d0e551b9d135b810aa002a840e1144806a5bc7929a6ef4a702d9c4068302a10a60087d2614d1b17debef9debb57ef6b7b27422b1d4a9dd3f9f45970a02c35a74d4e60e35116388b0d9ca1835c382710141509a549ac62b02986d17cd029878cc6fc433588b4ca878580112f6c19b71da1142fc31c2a103f7d575c0beec9b7e4754cce476dcdf47ae56f3cb2ffb173da4f86eff45d33bb62633087964b096b90dc0821502693b8ac3d0ed35f8e95053aa01150a9d12cb3bd51460ad3b41220faeb2d12c9225b9dc32e8526a102a8002a50c70a2094d6b1f3b1e9a52920a174eefa1fae7ff8870f3fb0aefdc0deb022b511a61d398978fc0f688d0756c46852c520d59222217302955151509ac82adb60300a0c9d40684c6234032302b3016d0bcb114a4bebaa98bb2c0ac42d74c4e70904d7acbef48f361d40511b8f19baf69351d7bbfe92a4d63247767e4a9fb5c0fed67e40e07c8dd01596e0140e512c5be88863b4fa5db2e72d2bbb8c8d722c83a155ac1c99822faaa4454a79a581627ca123cd183d817a765696ee8085a202a8002a800a94a4401a288515c60e1671fa6e49fec1cc39560042e9ed5bdffde6b657c899302e8d81d298196e34f6d9ca9742710efe029558bab03981345132288db02a144ab9297113087984c384521e22b5991423a539be0cead834279416460febeaab84e58e8bbb12d5621da8002a800aa002f957200194866d551adb48cea5b1f81a5b0e26400572a58001a51bbed375efa33bf96562a3a9c7f45dfdd529bda9943649a0808701c266a6b1af1c73024151c9a7ef86581506a5f6fc43d7044271ce1e16abd092d67efcf5c855cf4763b80208a59e3d01044acbb971aba735980c15400550015420970af84269e9c6e3b0b2740db1845c296043e9c6277ac9c1d1d4e05239c74c4c6db527e385ce70638d862f4f4996b3a6ba85cc0954b29950aad62e0bde10332619865915337d579b7fe89a4068bd90266c74876ff0d723573d1f8da90528452fa202a8002a800aa0027952200d94a61b20a6cb9527add016544053200c4a259746cce68d92b29c33dcd25f86e5b44aa901270c038dd29b8d7d1615289b02c58e94964d162c18154005500154001548a1401a284d510dc9028795613381f13c2a907f0564ff8f805218320d9bd06b5c479599e19694ee2a639594228c7c939a9dee370a73a102891440284d24172646055001540015400522144803a5e90688e972a1f35081dc2a100ba51c4d61e03465ec343b090a7a1916d4ececfc8625e5510184d23c7a056d4205500154001528a60269a0345d4b7158994e37cc955b05fca1d449a7f98f09a385a8002a10a10042696e7f9cd13054001540055081c22900a154de7c1bc8a77163068635261d5ea6cb553841d1e0fa512005944a3ac50fa8002a5074059c508a188f0aa002a8002a800aa0029e0a406a80502a470831509a8e3a104ad3e986b972ab004269d1a102ed47054a51200c4ac9235d3c50015400154005500154205a8163ef1d4803a511bcebc90c08a59e4261b2a22840baf4ca952b376ddaf4e69b6f1e3b76eca38f3e2a8ae568272a800a94ae400494965eb8b38488194c65aa118b0d53007d919fbe81be405fe44701b424910211502acb71444ac390d213359f7df65999f2b3c39fc7031528b402fc5241284df4d3838951811a53201a4ac9bd36db43be56936db1585a0a05d01729442b5316f44599844d512cfa22856898252c52dad9f92e390e1dda1b03a50d0d0db2081f2825444ab22094161ac3d078a80042698dd10536071548a1402c941eee7e3bc3030ef8322c168b4aa100fa22856865ca82be2893b0298a455fa410adceb344444adf7fbfe7bdf7ba8f1eedcc184a0991229422d4d5920208a52946f0980515a83105104aeb76388583effcb81e7d81bec88f026849520522a09413e991238742a194e3a5fcc767303aff0b071fb983d245ededdded37567e1671b5eaad7c4b6bbd4684d21aa30b6c0e2a90420184d2a4e30f95fe95f9679f3d7f67a691e4f4c624370341a8926a47d755aa2fecae58f0ce5945d794ea8be45762151b8b5567a24004941e3edcc18ffc454a09ce054386f62777961a738b80435ed14f77c92a16fcb4af2f8c6093426674bd55e1e47cd2e3bd87d500f1a7ed0f749bc3c5f69f1e96fda1afefe4038bd85bcab16e55c51c5e505ac3114a538ce0310b2a50630aa483d29dab06ac7ee5edc32d0346b4249bdc1b3ae02363e8e051f1d9ab9ea60385b2');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 5, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 6, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 7, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 8, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 9, NULL, '676a554f2b84d2ea698f35a302d55700a1b4fa3ea8aa05084255955fab1c7d81bec88f026889bf021940a97f652465c650aa56d7874b9f7166d55fc6e8d7dc4c97d163d37855fc0d2c11cedfd8e02bfb89c47c47b644edc3c4992a80509aa99c58182a800a944f0184d2286dfda720f9a7b4eb4b91374596907646815076b594af03d752c9e88bfc78131f10e4c717f9b72403284d1a29955b95a65407feb8abf9b9207ae65cf85ee1a5951204545b1bd9f6df3271aaf9bf29db85d99c230cb90abf7a44a06f4e901bdd30529a1b57a021a8401514f086527b0318eb8cf5e434ac3d915bc280fd3ab37dd1210562f967f14f698992266b449e84c5a504a184b5e0642e9f6b3b6b5f98af12898d827c4ca9fb3408a575df05120890019426a80d244d84b25a15f0c7c1de980c6e8066d32929c8f19a221f100431517887487ab748a705e60a532046ff7c3d334028c58e8c0ad4b3029e502a1f8bcac7a1d619f0c317f723e78052fdb69897c93efe3753ff94566f6b6d4c0edf08a5b578d1660da581462574ce5a94d9ab4d08a55e326122a64006509a0e2fd3e5a22643d47492a4746d1894ba6f5b019a2294e6e7da88b901e4ebfe80509a9f8e8396a0029557c00f4aed493df619f0cb16f7231705a5f276c90ba1ff6d6c241381e82358f1745620ab119865e9d90b2fea79ad9644bb0b8354ae8cc2116159b427c5c1fb35ea159c7ecdadcc785e8ad510fd151ba6a47d07070d57e9ada7dbe004af4f17c590c8d5bd1c83efec6b09b32a2f0f1f2a7fdd396b2c972f8ceb517903f50ff53c42694e2e8a4298910194a66b6706504a2aa620c97f0bd427658f134aed946dcd8de296c732d8b7c0742dc45ca52be01c90d139d6c100254feffc229496ee702c011528ae0289a154ac8900576e939fe584de98d05f0c94f22a24cbf1f5ea69d9c107fa7fe72b2dc16f2b0fd5d2c1b7f8dd152fb9888ce2acf89e8dd1653a6d757cf163aeeed44191d61965adcea8104a65d1f0cecfdbe18452333dc866df6560e45ac8ef7a3fc8eaa9d6e0bb2cb58006da6216f7eac9d8f272f942eb2da8bf97d7104abd64c2444c810ca0341d5ea6cb454dd66f21ec26c8ee1bd623492da60aefec664afd1d45fb96867da55a0a38a114b82f570f27114aabd54db05e54200f0a6408a5010341c87337311994ca1020fc006f88328c6a0427c5c281fa4b2ec6bdd219a594564bd43416cf771612fd428d09063a383aa1540d0018643b1f3d470f211cab1b981e89994a6dc65fc5c8459ffc05ab09b9bf399fb683a70679b816aa6e43b97c11363e44fdc35d8e505af5cba140066400a5e95a9b1e4ad3d587b95081322b80505a6681b1785420d70a248652153c0c87bdb8656d124edf0de6a51a506a8463439fccea2fb9940f4a1936aa20ac63fa6e30a197d2b28edae9a0944245508d4d7dcec7a356678c07a12c6a713f6d4728d2dd512e5f209426ff0d46284dae59fde6c8004ad3e165ba5cf5eb286c79ee154028cdbd8bd04054a08c0af841a99a2c2b39c25ae8489ff619f99242249406e518514a13baac975f5c5ce77ac92564e62dd7d8003945e0fa8c5ff0428d1024c8287013e096603a58b2c5a46cce1478c323d8e6ad8d5b25d2cb6c2cb99e4691a32acaf57e502c942a60ceb216d0409c3e1a7a39bba6ef8a870e25795cebd5a8bfd7cf2942a9974c988829900194a65312a1349d6e982bb70a2094e6d63568182a5001053ca114eca12de767ca574840c8544ce44cfe4ea99a01aa87fe220280749c1efc33280ec0a4dcccdb35e334e4fd4fa93bac5d5b4109be7a6314225e7e95d6d1759ac40baed25cc59fdabc60beef78787ab991b94803bc22cf7086159b7f1812b9fa9363f01d3836c35a42accad5bb2c15b8da62aa28972fec472d4667ae7ed37367014269ee5c9263833280d244782937294d942bc702a269a8805000a114bb022a50cf0a7843699622d5e380cf359916ac4464c9eb37f9b674afd4a32f4a57ad3c25a02fcaa36b9a52d1176954abd73c19406922e9248b229426d20d13e75f0184d2fcfb082d4405caa7004269f9b4d54a7640661493c6bd969b99d565187cab551841203b33836bb8a032f8a286d52a6fd3d017e5d5b7b64acf004a13e12542696df51f6c8d5200a1147b032a50cf0a4440291996e1810aa002a8002a800aa002110a6400a589462108a589e4c2c4055200a1b440ce42535181cc15c04869e69216ab408c08e5c75fe80bf4457e14404bfc15c8004a53444ac9449444b9fcdb832951816a2980505a2de5b15e54200f0a2094e6c10b55b40141a88ae21b55a32fd017f951002df157200328f5af8ca474464ae1ea47f81915289602b2ff239426fa29c0c4a8408d2980501ae550ffd586fc53daf5a5c89b224b483b1184f27345bb7d11bca2eb5eaad8ee09d9f58dfc2853794bf0baa8bce6c5ad3103284d14f3c4e9bbc5ed2b6879b40208a5d84350817a56c01b4aad0d60e4fe246a4b523b8d5b5ac73ea56a4b18b05f67ccce3209fd9662b0ee9fc53fa565759aac11791216e7f485125e2b8ded30633a453fc937a101fc2476c849e8abfa4cee02a16073da30b7464029d81048ed769aed35e5f2535b33db1eb8b551a7e8d6c6f2579d61b74128cd50cc9a2f2a03284da411426922b93071811440282d90b3d054542073053ca1542e144b07ba6cb0699d91dfb0ef2207a00e10d2f7ebcccbfe95fe80e79fd272619ad17a59a114ee790a2ba29ff926aaa00dc649c79ffd8c1c99f7e19a29d00142e0aa723733144ae14518006209bdd45b6407930a3a4628f5161113164b810ca03469a4544ece2c9652682d2a10ad004229f61054a09e15f08352b0798918d7469e51c4ea96360a4a490e5e85fa2f01211a486d6c15835b81ac2a10c446bb2c7d73a308b9f2345a1239225767592a574661775816ad68550885351e196c654de0a5580db14289ac653ee941ec8b63bf150cd34531247279c3ed0bf8c821308cdb683c70304fb2bf65eb6931cda069f57ca579b4dd82527d731dee0857b7d7cff368b6bde110c8c99e2db08b25e8bde2ba5121556d3b1ff1acc175198276d97b01a9a74b95e0610f89bd9360a4d45b2a4cd8970194a6533111caa6ab0273a102955400a1b4926a635da840de14480ca562b00b87bcfc33a4959811680c94f22a24cb71fc92d340453d1615b321b71804f334f48c3c21c18f16a490957cb2334a272902d7b3306bcc42608d4ec894e163953b88387ba507d96c811d18693f3870f4be305f88ccaaa2e09346a5d649a518f060a1426455bc42dd9152c9a2066aaa871d1c41cd79ef0211e1ac03fd214bf04d643fe15fd26bc479195a6af1a0ac0897826f114aabd8b1b0ea322b900194a6c3cb74b9caac06168f0aa45700a134bd7698131528be02d941a916b6d35e2bb4544a06a5daa01c041ec16ba8228c6a041bc55bafc1d85b1bc4339b38b5da406840a991c0ce6205714574949763d70b00de62bff0f432fe28cb144dd0625aaa6a1518e309dc73a2437d6198ad4400546a9f04942aaa2c1a8d54f19a8e8752dba7ce5e0d9f027036954f508cabc9e8423229ac484e5b303a9eeb5943c80ba541afaea2b809abc6486942c1ea3a7906509a4e3f84d274ba61aedc2a80509a5bd7a061a8400514480ca5301406a10bda1ac72109a7ef06b316e178daae22942d835179b9a1944d5b3547ff31501a18ed8c94aa413fe3401b4a65fcca490b715ee01e8bf00529404ebe3568c89c49caa8979ed46271fac4e60af4e68257e105a5060ac64229d524888542ef984f70807676bfb233dabd2b6af22e4269c1bb269a1fa94006509a0e2fd3e5426fa202b95500a134b7ae41c350810a28e007a5f6b2468e3381b57048eb6e412494061311c322758a8af5d89f8bebd832a001b109a80b9979eb046cab2eda368a5aa185883062908ed72de6124b0c90b1461be1a2d2ab10a55da6125d550d67098776a5585f04ac09d4b61bc9c10786d464857e6c5c81ae9eff2ae2a1144ed3d57aacab6fc8d078cc9302ab9f0097993dcd89b54ad9b0c9bb08a5f9ef7d68617a053280d274952394a6d30d73e5560184d2dcba060d43052aa0802794720cd367815a678213b1af10466e09a3afab1311a281c13b0387004c72a3ad201e688b4db33650a9bac0646028882a84aa205e2fe555f3056bb550a35aaa09c6ab84a9e1e9a513e422b8d20770595c7e5234594e720ef14a4cd4da8d9a56e4962ae63c593c1aa9c0451756850794ea93e461b797579f5820d9b83c449da26f188b285b69cd7ee51329655dc0f942292c3e2f0b6bc7b919a7efc62984df2b053280d27478992e17ba0e15c8ad0208a5b9750d1a860a5440016f28cdd2967a1cf0b902866085194bde4a0518ebd11759f6e52ccb425f64a9666965a12f4ad3afbe726700a5e9042b114add4fae6c53622648a4b31d73a1020e05104ab15ba002f5ac00426985bcef80cc2826d5964a2aa78938f82ea7bac9ca465f24d3ab9ca9d117e554b7d6cace004a13e1a5dca434512e4375f5ca07fd42ccf0717ba6528f486bad5f607b922b80509a5c33cc810ad48e0211504a866578a002a8002a800aa002a8408402194069a2318564d112a014aca2ceebe6e449ff2b76060f56ed56f154f59688f1420bcb1bb54b78a2e661e23a5600a1b48e9d8f4d4705fa30525ae79d002342f9e900e80bf4457e14404bfc15c8004a13e16506501a367507c64fe51268e6f45dd7427fd1bb84fb6b8929eb5b0184d2faf63fb6bede154028adf31e8020949f0e80be405fe44701b4c45f810ca0d4bf3292b2bc506aec45d60656ab53d154b1b07df866df7cb1b4a22c6c96487e4c5c4605104acb282e168d0ae45e0184d22817f9bf4ae39fd2ae2f45de145942da8920949f6bd4ed8b60255cf7f0ceee09d9f58dfc2853794bf0baa8bce6c5ad3103284d112925cc972897ae6fc4f4dd0038c53e5fe9a094d786685adc5e5d1dcb114aaba33bd68a0ae443016f28b5b784096e3ada735563db18772323b784099ead663eb64e51a07f16ff94962469b246e449585ce49630aaacb0651a1de7e129b6310dfdc74eaa9ea219697cc705d24ff2320196452ecb918f4b2bb9152e100a868e616e8d8052e008a17cc2be91bc05dc736c7b60be3d4ce049b53353ba422b9e0ba1b4e29217b8c20ca03451eb338894ca1db145c5c12f2afc8d90dc4a7f4ad8e52cbe754ddf85bb9bb17753b55dc2c92f822c44fc28c0ddd530a09ac8ffb59c18a1b496bd8b6d4305e214f08452b950ac7963111b62d26a9c699cf54781101b49e7e516e53f88f74f6929d2da18bbb1ab95a77c500a97fd0d6aa13ed11f3df0bfdce7a16dda60066c8e69a481bbacf2b6d204467ae3cf7e74558eb8ee5dacefddfb94465f0da1500a0321012096d04bbd95349954d1a98cbb789755c58408a55514bf70556700a589629e9940a9f8050f76b2b69f21c11bb1b9c1b17ae2056155fe76939f66f9183bb877209416ae5f57c36084d26aa88e75a2027951c00f4ac1e625c6b856fd199ec66a6b64740eae02a8ad05d8d82a6e84d6dd93d109b3246afd3f69aaeb7e6a6414268765d16ee7fa4d993f706e650b192abe722e6ac8bf66ba999016921ec4bef89dde0a86a913f47bfd2f679fb307dfd0a5ac9290795e61e7b51e12f40a7e123eb7003154fe0d644c991c86f8a4a8b49866a0705e2ea652edb07ca1c67574e4a89e0480b8a3a38bf294f68643a03730c0677d3e');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 10, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 11, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 12, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 13, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 14, NULL, '2794f279bc22580a82a2104735f4623083c3e2622bc0623278a00275aec0f2fb0f3cf2f49189eb7a47aeea19bcac7bc0a2eefe0bba6e98db75c3bcae6b67d3e39a59f4b8a2a9f3f2e99d974debbc78d2a10bc6b55f3e71cf7ddb0e2ebd9bcda45dfb6e29852c2385b0b8e8f26fef7fe2c93d3b563db47de1dd2d73ee6c99717bcbf45bb74e59b975eaaaad93969363cbc4655b262edd326ee1e6b10b378f9ebf69f8ec87074dfff688053bb6beb978cd6e09a58448478f7a9e474a55ac880c88e5885c9d65236276beb9b181ffd306c96159b4a25521243e44c6ff3488d84acba47f06e5b3da09d7d9b5b0213aa405fed9991e462359f956304c6bb1de7ef73dd62752ca2d529423ffe662298365282c3859d6fb7acd156e81908c28b26ec37b94ee6121be769ea7b4371c0239d91306d6e783de2b3aa60aa98a13bc56d01b5967b5ae14e60bdd5c3d8deae1c0b04a4072ca5e82509a52b8bacc86505a976e2fa1d1144a27bd4e462d64a2179cc12b22a564f2187bb95450e837f7d3579bee010152181a0d8854bee0841f8aa8409da348a19b2f5f0bc70fa52bf0e48f8e4e5adb33ff9e9e85dfea99b9a17bd21ddde36feb1eb3aa7bf48aae91cbbb862feb1abeb46bc8e2aec10bbb6e99df79d39c43d7361dba6cd2c10b47eff9c6a857b77db7931b506a21648eeeadb4901d2b1f7a74fdbf3db6e1f11db7b76c5ff1e0f625f76d5ff8ad6df3efd9367763cb9ce696391b5a66ad6f99b16eebb4dbb74e5ebd65fcb24d23e6df7b4bd31d83e66efb4ea780521626e5504ab92e604c1a2a1223603a729630453fb131b66051185e92b8c506db5a16fb8c043339cab7a154ce7f55e5b1813cb7213e3dc8668fe661f84914e535faf780d2a032290e3841657142a9038a4ab885d7475677a454b2a8819a9aec8ebe2110113e65d11fb204df44f613d93f79efe5cf5cf807e74c601e9415e152e0362794e6b8932094d6c735974d2b114ab3d1b17e4ab1a074f71953defa2fb3f7fc87e9bbffddb4dda74fdbfd3b4d7b7e77c69e3f9cfdceef35edfadde9bb7e7be2cfffc3b45dbf3de9e7a7cdecfcc7396f91779f54a4743d5d75830657835537f0431115283495a1f1a840560a3cf9e291d1abba177dab67f1bd3db337f44c5ddbddb8a67bfceaee312bbb472def1ab9ac6bc4d2ae618bbb862cec1a38aff3e6d99dd7cf3874e5e483178fd973cecd2f3ef134494f23a52516425f1c2550fae2916d0bbff9d886271e6bfede8e3bb6ef58f5f0f665f76f5ff4ed6d0bbed932ef9e6d73366e9bbdb165e68696a6f55ba7deb175d2ad5b26acd8346ae1b707ce5c75f5446209799b944fdf55502a2237c1d8db66274ead3610ca5ba367165e088c0cb9239ff09d3a1d1c7dd2b75ae0ea888f8110250cabba235bb49df150aae1848c9b05513b19823639d98ed4d5cf8823654be3a1d4f6a9b38b425ce46c0a63daea690bb3d3d94fe04963968106c9664b1d9377791284d2949d02b315400184d20238295726ea504a97386a18f1e38611af378c7ead61d4eb9f1affc669e3c8e7d71b46eda4ff1db3f3ac751d0dc3779e73efc98f87ff2df973e4a2170494b2302942691129146d460550015b018282439674131c9ddbdc337d5d77e36ddd6357111ced1ebeb47be8a2ee41f3bb6e99dbd57f7627396e98d179edf4ceaba61dba7c52c7d7c7ee3def961f7def991e5e6089854c5dfd2e392894cebeebd13b763cbaf6d11dab376f5f4a88f45bdb088ece6e6e99b1be65fa3ac6a2b7311c5db965dcb2cd63966c1ab1e0be41b3575f3b995842a05470e9a4d745a454dc848251b92761c201bd6796806c09369aa37f391cd798cd8a39a683524a0e81b9300816890dc6ad39164a0d66a165036bc9c7c66639df18a7ef9634f0f18252233e190ba5d4a2e00181dd490c40950069f42b9fde15357937044acd071925a9976d668c9466ab676d9786505adbfecdbe753694fea46dcf136fec7ae2a7ef3cf1c63bf4bff4d845cf903fdfd8f59d9d6f3ffefaaec776befdc81bedffb4e2cd110b7e88508a037a540015a83d059e7cf1e8c045dd53d612bcec21444a02a42396311c5dd035604ef78db3baae6beaba7a5ae755533baf98d279f9e4cecb26777e6362c725e3de3d7fd04bdf7ba6378052ad90d85f70a390004a8fb6cc5cb763d5233b566d2244daf6eadba41c86a36bb74eb97dcb44325f77c596b14bb68c5e4cceef7deed5cd23173c327cfe7d43e6de7afd346289034ad51c4236f8159146d7f45d63eaac6c8018347b4fdf95b31a790c5606a260ac893382c18d5ee9b5973a69093a1c82770e79d5709670a84fe2a01458262d37019bcde8b44ee675099bd8ee59b504f1506afb547551f03a2877877400444a7b7a7968995407f1dcc3074a7997734fded5de318633cd71a1a3aaf536ac383b05104ab3d3b23e4ae20b1dd151cbc25d645f0132558cb5fb571e47df806f1fb0a174da83875f3ef8e1dbe2787f63b0939edc522f8b0f5d4f92f25fe98a2b8a243bbef93eb99b9ff1a7dae52fae9c9094f7c1967ef872ebc194e59445a2f4adab3dbac016a102291478eac5a30316f44cb8ad77c29a9eb1ab7a462eeb19b6980448bb07ccedbe69563723d2ae2ba65216bd741239bac8f18d89872e1ddf76fee097bfd72aa0d42824f6ae6214c2a19414d232fd8e1d2440baec81ed8bee9585102225d1d1ad1308912edd3c6a913cbf79f8bc4dc3e7dd4fa0f48669c49249f37659915215bbd1e27b2af6a7af51c4c7e076a4548ccdf58590420b116fddc9efc5b2b55ac051f12ac4615e41447ab9928c5c0a57b6102e8ecb4f8a2607ebd5b8df00744edf95598cb9cd0274f5659c20a9aa8cced70d63fb45bd27f080527db62d7c16107485a027c00ea7dc21fa06584a39404f6d6123b35f7942690893425358d797c5e7f7c105464aebfd6a4cd27e84d2246a61dabe3e02a57495a379bb262fa19bdd0550facbbe3e7218682acf7cdcd7f71b22dea07bdb08948a2df5d6efa7d37719a70578d6f5e4db87979785b8fca0543366dff41def13547e724714ad6d7ce5c3b7fd6d86e573408de4e464859745372f529db6761f1ea8002af0d40b476f9a47a6ecf68e5bdd337a45cff0253d4316f6dc32afbbffecee1b66765ddbd475e5b4aecba65016fdfa447a5c42b9f4d025144a7ffce4b387b9804621b1f71ca31001a52f1c6d997aebf685f7d2f748e77f93bc41aab8b471d5d6f1cbb78ca13152fe6fcbb0395b86cfdd347ceefd43e6dc76c33462c9e479ef9083be561a4cdf8d35a3a2095c3315a35ebbacd4cc461c7c57b41b445686be405fe44701b4c45f0184527fad3025558043291db52cdb4d07406bde65ba10fefca8afefd791f1d2bea177ef56504a36ac275cfa583cf865114ef4835246a1121497b71e277f46c63359b1e9a074dd3e563e0ccc1a0498b0f0ea4169160ef2a25fac0815c8b3029c27472eef19b5a29785497b062feca161d2d9ddd7cfe8be7a7ad715d3babe31a5ebeb93ba2e9ad8f5b5895d17532e3d74c90401a5bc694621e4b735a210f2ad51c8b4d56d3452caa074dbbcbbd972bb776f9bd5bcade94e45a1e396aacf43676d193273cbd0d99b87cf7960c89c35004a49b0b438501ab914104269fd0d5e104af3e373f4457e7c917f4b104af3efa37c5948a0940c5626cfdf3d65c55e42a464925b00a5244c6a074bb5d8e9f0e69f8f58fc9c8894122825c78347d8dcdd631bd753465587384fa7f5befc6c073f4f23876296eff1cd0ff2c49c368f6c7e9b7d45028ff46487f89312e391e532999a242cb36b952e7f965268604c508828539a2a4d02b50455bb2c341b259bc3dbceffb432262fdc1010ff44057c14c06719d9294026cd5e3bab7be8929ee1cb7a862fed19bab867d082ee01f31894ceeabe7a46f7154ddd974eebfefa94ee8b26775f38a9fb6b93bac856a5178fdfd76ff02b243e29a0542f84fcba461442be350a99b6a68d7029b164ebc4e5db666fe00bed6ea30bed92dd5fee30ee255b47ccd93a6cd696a1044a676e1e36eb81c1b3d65c3f95464ae7ef268f1d21949261251ea8002a800aa002a84059154028cd17f2e5df1a01a50bf790e7f17400b4761f80d2e8374b7f3d62c35b2316fdb069e3017eccd8d04eb854f1988e7f02de1e3b46e7d03ea6d123cbc239964129893712467db06b2325551e60e42c4a0ae7fc094f72deb3309893e1dbc70928d2ea28311e7ff21582a92c2500c8e9ca24ad2e08d5c0422f289579cda6050d892fdc8740300d2a800a944d81a75e7cefaa19dd0317f50c59d243d0740881d285dd03e677df34b7fbfa39ddd7cceebe7266f73766f47c7d7acf4553bb2f9cd273e1e4eeaf4deefada84fde751283dc2af71a3100aa5e185906fcd42d6ec273fcba490ad13966e9bb16edbacbbb6cddab06de65d044a5bc896a4536e95b7989631f35b46cd69193eab65d80c726c1936f3c1c133d75c3f855842a174fe6efe5a29d91586ec539aff1b531e2cc488501ebcc06d405fa02ff2a3005ae2af0042a9bf5698922a40a0943c449fb2742f791e4f88948ca2fca174d4fad786ce7f66c63d07c9c1a1541c0f1d0dd63a3a76f786f695dfa7f35ab73cc4bfed798a40e6ab3df433a341192c6509c0b7bc3496e6a9c7829245155a32bd7c99b273cb2e5ad1ddaf7ef8f2f73b6939bb8eaea4a5514b424c62c59264b2210e0b8125ac99b4709e1efe19d634ffc2a50df801154005aaa1c0d33f7aef8a193d64ada3c18b0991f60e5ed4336851cf80853dfde7f7dc30afe7dab93d57ceeeb96c56cfd767f47eada9e782693d174cedb96072f705130e9c3bf8274f7dff28ff59300aa1501a5e08f9d62c641d5d3e8d14b275dce296e9b76f9bb59e72e9ccf504505b9acc48e9b6d173b78d9cd532bca96558d3d6a14d0f0e6abafdbac9c492a98bde9dbc700f7fad14a1d4ffc68f20e4af55b953a22fcaadb07ff9e80b7fad30254229f681640a50289dbf7bda321a26a5f3cdeee2504ade2625ef94c6444ac7ad7d65f8fcd659f71ce2c7cc8d1df020344827ebfea08b7fd08e577b677e87d226f9966459f583136f1f3cb1f51192bd97216baf2c077c050bd79245a4a1e5938a761ddd4ad0947c7e8462e453dfe9709bc46bdf7574156f88db4260062b8d3741a627854735cdbf705d4c43dbb2fea91e2e548304b0765420270a3cfdd2fbdf68eabd697eefc045bd8309942eee1db4b8f79645bdfd17f6dcb8a0e7baf93d57cdebb96c4eefd767f75e34b3f782a6de7ed37bfb4dedfeea84f6af0cdef9d40f0328d50ba1501a5e08f9d62c647dfb8c750789255bc72e6c9976dbb6196bb7cfba733b81d299ea9dd26d5356f01ffd5f9d3cb57df4aced23676c1b31bd65d8f487064ebbe3ba49c412f2f3ceb994044b338352ff173bfd53daf7ae1479536409b967e2e03bd960a29ca9ddbe0896aa75af546bf784ecfa4639db9af7b2f1bac8bb87f2641f42699ebc51045b38944e5d41de26a5444a029eccea582225bcfad184db7f347c51ebac7b0f8923a05381a99bdea3ccf6c3ee553f64ccb949b02bff169ebcfb2704597982c3140b7f725882eeacef7e4023a5dfd5f21ac99ce5cf0a6a178941f961268994bbde5b156521b04455414fca564435cdbf70434cfc1315f050a0ac4f2beaadf0675e3e76c9f4deebe7f5debcb077e0e2c3ce9ff3cbe6f55e32e7f045b37bcf9f75b8df8cdef3a6f69c3be1e09709943ef71e97cb2e64e092de5b16f7debca8f7');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 15, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 16, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 17, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 18, NULL, '5326882439d2963d26558b80a509d613b002abe5d24d49247e9b864f0defd155c2517f2441a9b2408be4724bc79d8c4088869692fcbe8093be4bb26ea930aaa39f6128b5567ed38835b9f740bcc93b0569cb77c7c6b0259dbb78d704afb8b8dad9f108505ac735d1861580d236fc548f9580d27a7c9169498c3947a605fcde01a5991e41352850810209cb77e53e47a12d6122cf7fea71d18f97c44d62e44e47fcf152b1c592d883d6baad667895e65307cb9ba335d4beb6fa893dbad3ad78d3dee8486e8ce47b2c0d4aad2d95bc3d95c443b13a47a6b660a2393d014df6c738af337ee7e10aa26e261312a0d473849654854234de8c8be87a5ab2bd97f14ed7168dd99e181e625209a3e25268e74418644a678af175360b285da75fe71b15a0743e6d176ad987526bd992f9be0dec39c94bf2dd3503fb2c004a17f220ba81023328d0331b98a1b7094d866eabd1a58d6ed3b94b3fc69a888cd058c5e62b5fbb2f968ac9f9144e6fb9765fa48f0425e75700503abfc6ebea0150dabc3fad3c03c74b0b4ae9babbd0fe84f183d200a5cdc70606b061055a86d23e26751712cfe6624cbe67937674c3b5fb02503adaa5a8b0090500a59b7073c141024a0b8ab99fa60632a5bd7b4ef67e95024af7e350f40a054a28d0331b60537cbca00014800250000accaa00a0b4c497f996da009436efed51501adc9f302201a0b4f9d8c00036ac403399d25a7d547b76ae56dde6b00bbe9843d5bc36e18b3cddb6590b50ba4dbfe78f1a509aaf5d253553a0543e32eaedea884c69254e841950a0b40280d2898a62f23d51c082d5e18b82624e6c0abe9828e0a6aa034a37e5ee02830594161071bf4d0c42a93a8e30b0e724a074bfbe43ef50603605e685d2f487e8d24bfa5264d4cda812710126dfb3c5e6e886c3be50dbea06b6e9633dc4be1947771e6a2aa391b554c175b1164f2e310e40e9122aafa90f40e99abc59762c58be5b564fb40605965460049466805c7a95f4929e3a39557bea8c6c2e70248c3edb45ec0fe734a8ff49369fd3b702cd93137a233ad35a4b27822c19c3baaf1008a90348636e4db85d9b3a969191136b561e0f2c8e2cb58fb0e96221ccd6a9362e560e50ba98d42be80850ba02272e3a0440e9a27237d519a0b42977c15828602930024a33944b9fa6a797f4cc38dc8da7b559a1949e9dea1d2eaa1855c152371cce1f9d49eaf854c1224edd0e621b21928c502951257c4e69bf68d541a9c3a4962e34684a0836631b80d219c55d5dd380d2d5b974e601014a6716b8e1e601a50d3b0fa66f5e817e2835c93c0a48e65dce487c5acfcf31f6123981aca0c2aa5023471cd04e9d3a7d70c8914c78c7e0196336bf177e300c458b9ef22439c93a61ed3bd94afa46e0c4e650b40432a5da7271664d3853ea9d67238ae9b77d28eda40194f65db11e08a995bb226a845fac988e6c3befdf4ab02a168f613928dbdcd0d5d44e00004a37ffdd32420040e908b150942900284518c41400942236a040bb0af4cc068e486aaecbe549b8321ba1c9bff359be9ca73ba99c58158e9e6675a22637dd631032255508705560e0839fc639b73ca9e6e7c71c1aec3cea9dd89c08a5ce82db3094f241d0d598aa98ecd587d286d2647bba1ec29952cda2dd2fa153b8e5fb2aa402b703e4cd122b620bc630954bacda95e9524bc7b6fc0f28ddd345d064b780d226ddb647a301a57b14bff2ae01a5953b08e641811e05faa0547213c90b051794fa00a9fb8bad4175aa88542745b470e653e54e3bc3643ad24238d16f38c718cabe8ac29a212d7a497d98af2f531ac41b8751059bd2842aade59b87688e2b300ca5544fa17b3044a38bae5580f9c9f909314c07145dbc4bee1035110280d226dc54899180d24a1cd18c1980d2665cb5b8a180d2c525478750a09802bd502a7a51d8944898f401cfc42a6a8a7fa89f9a4c8552552ea53c6bdd5f12acb3a9ba05ff975eb1fba054e4e5229952d2aa5b8cd5d81dd8cf94b6c624c502744c4349501a3c857b207eecddaa842f823756f8ad0fb306a0efe9622ff1d9bb78b7ad3429731aa0744ce46ebd2ca074eb113076fc80d2b18a6da73c8352f68182171480028d2a403fac1efecf571efefadb7fb13bff677ffe345bbebb93b9493e0197501759792b5a0903985725b6f49113b07a985366683b047032577a864e0192acbe8c9437137bbf4df98e1842ecc4e6d0c7fac033a57269a8b5abaecc8beae7430309550e28fea8db79a4702fdf80c3506aadfca611db171bfad64cd2f2ddb1316c291559bcdbe02d0940e95e2e81463b059436eab8bd990d28dd9bf4e8180a400128b094021694aac71ee51e311601925d8dfc2c93b6365645b25fb0918ec7048ec9ed69c496b4fadf6495af9bac12dbd9c4cbeb01e96d6e75768a6e7c2bdeb4373a52dbe4788ee83d12c6df1147b743c7a3f65ca2493c414936e4f33a4ea66fa9c868a19f0428f5166c6b85552844e3c7786c68a323b95b57520c2730a9b961d28213a48d80d2869cb5775301a57b77416306004a1b7318cc850250000a8c578042e9f8da73d67072b02a7b15dd8e36547e0efb30f99e43d5bc366bf7c5523199a75ed95ab5fba2ec68d1da340500a5d3f4db5e6d40e9f67c8e11430128b039059a8252b293aaefa8a5000093ef7a2e92da7db1544cd6e091da7d518346b041290028452c8c5300503a4e2f94860250000a34a800855236adc40b0a4001280005a0c0ac0a004a1b9c2cecd56440e95ee547e750000a40812514a83753bac4e873fa40462847b579eac017f3e89ad32a7c91a3da56eb004ab7eaf9dc71034a7395433d280005a040330a004ac7ba0a93efb18acd571ebe984fdbb12dc3176315db727940e996bd9f337640698e6aa80305a00014684a81c2509afe105d7a495fcf8cba1955227ec4e4bb9e000ffb426dab1bde13cb8f84ecd8c8ae588f82e52cc175514ecbf5b704285dbf8fcb8e10505a564fb40605a00014a850813e28cd9873a757492fe9a99653b5a7cec8e6928e84f10e22918320e7c2f07360c52138e607c7bf8cba464220a40e208db93506a523c3a0b333a34a6878f278607164a9685646444be100281d15ba1b2f0c28dd78008c1e3ea074b464a80005a00014684d811633a587bbf193f559a1549b4380881c2f2a0f623de94eb324457522af10dbb4167a05ec0d9f537a2a7a6c50982485fe195ec8a81218b4c3a4a4511a2f05d49ab70940e9bcfaaeab7540e9bafc39ff6800a5f36b8c1ea0001480027b56c081522b49a3a7c7e65d3edde7ef1fec6436c7228058152bff631a3962ef0b64635943cd6b0612763b953322bdf08361280ff494279949c18356aab2ebde4e4b2524a9029952c3c8e2d01a0f26a4b591236dcab0cd9e03692fdd7b20a456ee8ad8147e717c1a08515e32984175623c742164c5b054cb36b7ebcc8aeca6020350ba974ba0d14e01a58d3a6e6f66034af7263d3a860250000a2ca50085d26e5eaeb24cdd5a428352f25df9773e359794e8f057ac0a474f51c534224840bc1d844c9d5734b539c4b21a49e549357f7eaf09d1fc8940639c077aa0b41b4d38e7265b9610e264f29a628fa50233a99f70a654b368f78be7532f44652cb95ef022b6600cd3c18955bb325d2afea05975fc8a8024d9662904289d45d695360a285da963671b16a0743669d13014800250a016052c2895b361c54c2603c9334e1a287d20d4a349ac2212422233a45b0e644a55bf24f728212308a556c632947d954350cf705af4623f064a6db37dd5f74ca9d3a0a968e748057460f9eee48b60184a69aa9c662207e2c7bb4be227e727c4301db7fb40a9baeb22c3b17725f264fd4a3600282da9e6dadb0294aeddc3a5c707282dad28da830250000a54a7800da5c23cc54c898449d3398955d414ff50a7665320b32363552ea53c6bdd075d9d7dd52df8bff47aa977f9ae16d0ce710572a14959d9eac2a5328392a0d449370643d4cf6f3b01168352b15d955e0390766345aa185abc6b6f9ed4520e1d505ad9c551b53980d2aadd53a17180d20a9d0293a00014800265157096efee646e92cf8625d44556de0a3b9c69b3b736b2cb547553f6682372fdaf2a279a7417c1ea45c2142055aa315edeac2df6cbc877647f822ae82ae1a8cc0950aa8640e0a3a315d665303bda127a948dbea9ad0d43a9ef5313a2922003f1630743e118b606ed2fdeb5d79cf76fda3455bf92f501a525d55c7b5b80d2b57bb8f4f800a5a515457b50000a4081ea14082ddf557bc458042896bc469effd4c38a5591ec176c44ec74c41f2f15dbd3b0ed8de8bfc95257377d35545e3f9d27dba48feb895eb8e5226525b9519fcf1279a02f054aade15a6b9443ad034a732f8b0428f50ee7d16aab446534de7444d245e674eb23e3b811313cc0a456e8e099d2dcc840bdba150094d6ed9ffaac0394d6e713580405a0001428ac40e123610a5a1742b5c8f6b5bcd7a5d00e19a1824e9ed854edbe582a2627ca58a47aedbe283248345248014069212137d30ca07433aec640a10014d8ae024d41691f93024a3718c4b58310a07483418921272800284d1009458802805284031480025060f50a502865537cbca00014800250000accaa00a074f5538bc2030494161614cd4101280005ea53a0de4c697d5a098b6acfced5aadb1c76c11773a89ad7267c91a7db366b014ab7e9f7fc51034af3b5434d280005a040230a004ac73a0a93efb18acd571ebe984fdbb12dc3176315db727940e996bd9f337640698e6aa8d39a020f3df8406b260fd8bbbe11adcc41b50da73094a63f44975ed2972ca36e469588ab30f9ae2786c3be50dbeaeaf3772c83fd48c88e8dec8af52858ce125c17e5b45c7f4b80d2f5fbb8ec0801a565f55c716becc3a5d1d7233ffc4e10e11a1d0e333b36a215871f863651813e28cd9873a757492fe98d30a76a4f9d91cdf51d09630e3f6546f36d99ccb122a10375263a6ff3d54320a40ea78db93506a523c3a0d33ea34ac8654707fc7860716469f7a3a8ba9d434a99d180d2cd5f8e230400948e100b45990280528441a202ecc365d607e2e76bbc074ae7eb74d69601a589418b625a811633a587bbf1e737ce07a5023eb9a05d27a74f937ff0d357b5b102970a910c62380c42dd5d80708a542a561d943a4c4a06a0f8ba095f034a9b70532546024a2b71443366004a9b71d5be0d0594ceca99a31a0794eefb6a68af7f074a4d628fe29379974ff7f9b4fe60c7527fdd8f45007ac6ef5411b5680d5db24b0b9d3e3824f026fed4fd77b7b3ea0879550652c35e4f799aa8e4e5c91ba2be3562e75f4177fa936f0dc95dae8bfca3ebc04220cff2f6e2a52e8b3d5fe81c230fb590878d479cd808c2aa13e3c56258ca689b2bae267aee51ef194875b90299d2cafc51b73980d2bafd539f7580d2fa7c52a94580d251dc386b614069a51749c5665128ed38503166c757729adecd9c0579cabff3a9b96451279913abc25724ba8d08f2146f5324d09029a942ac67246b1bd9af49e549351f39f484dffc8930805f5e39d187525556a4bc2495cab6483bdd5891292d7a2d04b273f4b64807a59e4fbd1095b1e47adc8bd882314c4510ab7665ba54dc73716eb714956cb6c690299d4dda15360c285da153671d12a0745679d7d438a07456ce1cd538a0744d57d63263b1a0543ecca6f0cf6420794e5153a90f84dad6c42ae6614bbb2fdd8b0b6f66a6eec35e082a78793ffb2a8720f35f2693e6a6d402');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 19, NULL, '39603dc43008094e1678d1fd4ffe836666ddee9671f0aa7b1986529a0e1599c86088fa370b9c20d7159d0b81ae1508de28312bcdc38b71bd074aad6cbeb310a16667024a6bf64e6db6014a6bf348edf6004a6bf75035f6014a4771e3e8c2e7bef6f9cf7fedb5eb97522a024aabb92c9a31c4865261b658541899befbb373fa80e72828e5d868f2a781e5b80a864dfac86425cdb39a7ea7a2bc0fa53259a9005bb3a8f34baff7229beb74eb2e552a98254cd52a5e3fe31acfc1361334d5189a04a5ce03c865a1342786957ca1c5bb96b44d850aa0b49acba2014300a50d38a92a1301a555b9a366630a42e96bdffc9c4a619cfafc379fe9308c22d9a35f607ffdd2a349783605e1f247c42d943f5ffc7e8a0dc36500a535477ffbb639cb77f936a0ec874f8725d44556deea94910fa5fe42c7d8d247bd5ab1c345b34390bbcc552799e8e2cce1f22637e52f9d357c6abaa6ab84a3ae0d4ebe1983b21f291efd07a074ce6b64184aad95dff466445f6ce85b33d682f352316c09e22ede257fa47750e614b150db80d242426ea21940e926dc5c709080d28262aebba97c84b3b37f1d919a94e0f7bf748a73a94632f6cba9cf7deb5c312265dfa06577dfe544fd85c7d5a01effa2f97d983c7b12a180d2755f3ffb1e5d68f9aeda23c62240b2a27570f9aea0dac44d62f85c5f3e5e2ab6a761db1bd17f931592ee9acaa1f2fa700dd926396d43bfc38c15292bb92f91beaf14d9e23738f9b600828fddda83977ad95a50dabb4fecbe63a3fefe13a0d45e0d4b97e9aa446534dee689e16126d586e98502f57b0247c2b4e0a37a6c0494d6e38b362c0194b6e1a70aac2c04a58c426de61430a6ff5b9a484b43e933dffa7c809949ee97ff950fe75b5f94d35e95f5ed085cfc74ef74f82d7e4c152cdfad20d2d76942e123610a8a145abbd8b71be9526b1d91112ae8e4894dd5ee8ba56272a28c45aad7ee8b228344238514009416127233cd004a37e3eaa9032d03a5817c2043b52f3cdebdffb9e2395291ba2c9929ed48b23735ca56f6b205bd1c38258bb277bacc30a359ba26998f5a244e2996e399d2a9718afa61059a82d2de13329602004cbeebb9966af7c552315983476af7450d1ac106a500a014b1304e0140e938bd365c7a76286509c36f0a7e2bb976b73c94062d34694fb61c59257e7b989396ef92a502cb53c78e8d8e367c21660e9d42e9a475e6a52f4f180305a000148002ab5400509af985bdd96a80d2cdba7eecc0cb40e9f5dee5bbd72f75eb604b6d1da466cf2533a5befd22d5a9571dfb69cf6022d4475040e9d88844f9310ad49b291d338a25cb2223b4a4dafd7dc117f0453d0ac092740500a5e95aa164a700a0147190a8402128e5d8d9b3d1115fe62ab7e42d9493290aa5dc7e67a323c29372749430e5effef25d7b876140696220a258960280d2b1b20184c62a365f79f8623e6dc7b60c5f8c556ccbe501a55bf67eced801a539aa6db24e2928655f69f44818f9e0a585646a4bde2aa1d4b15fe4751f577b1a7dfe8b5f30fb36d1e5bb32a11adce8c85bf13b34702cdfdde4253869d085a134fd21baf492fef832ea665489e88ac9f7a4802b5a39ec0bb57b6d786be38287f4940baaa2aaeca7315c17fbd1bdcd5e01a56dfa6d7f56034af7a77d633d1784d2859f9d289b295dd8f8607780d2c62e9e0acced83d28c39777a95f4929e4a39557bea8c6cce9d7c87abf3e344f4a132f6bfc429b047d6d930ea08990a42a221134220a40e208db93506a523c3a05329a34a48dca3037e3cb038b2d4fcb0e36ef599308ab32b0e1340694317cede4d0594eedd058d1900286dcc61fb33b71494ead3019d5fe683bdb2501ab47f3ee301a5fb0bf955f5dc62a694ced6539db1309476dd89e356b981817f7228b5a9158796a67a53950b805087fabd425607a5012695f72b5478e85da707073756c082e501a505c55c7d5380d2d5bbb8f00001a585055d6f73a5a074617e2bbcfbeed0c2da6546874ce97aafb3b946e640a9c9de89549e98169b77f9749fbf7fb093f7612c0288558934d235de25814e1f1cda84267b675ce7f7c2a7e80ed1c5cad36c241f0b79c31d5bf76f6bfc61cd5332a5c23a95b3532935ca16545ed14fa1b4db5c815265bb1e08e98c220f9b90878dce4e6c0461d589bed0859015c3524ddbdcae337335197bc84948150709a0b4ca4ba452a300a5953aa65ab300a5d5baa636c300a5cb00674a2f80d2daae8efaeda150ca1794ca5971b79650ce80bb99b37857fe9d4fcd7539b348d590955785a3a7db885cc26a40b79bdfeb46ba5e48aa484fd7c5143d08a56e79d36900f91c44ec3a4e9afd2740a9324e532979a31badf8a70b18bda7b0d61f49fbb0309c29d52cdafde2f9d48beab83bec882d18c3542bb16a57a64bc91f82504a87b30fc17bfa049456e690aacd019456ed9e0a8d039456e8943a4d0294a6e0e2326500a5755e23355b6541299f769b6c8dcf4e824a7d20d4234cac221af1fb72a0d47aa64efe43424638534a9fc10b655f2558abb5f616bd5859545e22bc0a74184a2d9c50f959da17a0b4d025310ca5341d2a7c1a0cd1fec47530ec27c4301d7de481529a39a7772beabd7301282d14d49b680650ba0937171c24a0b4a098eb6e0a50ba0c70a6f402285df7b536c7e86c28153d28344d244c838ea11c60cf849e63a3c946d1072c5d48f0728e79504ab3afba05ff975ea107a1d4e120b92a983c5eba3b08654a2b5e993947e0156933094a697c8abb124e7405ef113801e6df8b51ef8c8f6135f4bec5bb1128ad384800a545427a238d004a37e2e862c30494169372ed0d31106af7f5d0830ff8fe69773880d2b55f6de5c7e72cdfe5db80aa993b9b6ecb0590a195b7c2166796ecad8d144c2a4037b07c97ff413dcc293393921c69cb1e93aa95c4d284ae894079eba14ea78ce153652235b247e8212835cd49c00f00367fdcd1928eac342eefe4d5b6380ca524f0a40a264425ad06e24ddd9ab122b6540c5bde882ddeb5ae2c6c74b4da08deeac000a55bf57ceeb801a5b9ca6dab1e83bad65f8ec35a1f4e10b3b7159418ed180542cb77d51e31348548777cf1b394bac7581581afe146c44e47e68414b96dad957034bc4af3a9a2bd9ef232e9abcba82cb0a9c52d17292b7ba32372a08bad67004acdd6dbf6da664da512ef55430296ad013ae9bc312edc70d90428b55765d37b012a51198d1f27620bc5700a93d2d0e0a1af93aaf5eed08c4ce9862fc4d14307948e966ce31500a51b0f000c1f0a40812d2850f84898829285562af63d51b7d4ca464cbe0b3a796253b5fb62a9989c286391eab5fba2c820d148210500a58584dc4c3380d2cdb81a0385025060bb0a3405a5bdbbbc2c0500987cd773b5d4ee8ba562b2068fd4ee8b1a34820d4a01402962619c0280d2717aa13414800250a041052894a66ca6853250000a4001280005a62800286d70b2b057932594fecd3b0f7fe3ed87bf71a59bb8e00505a0001480022b53e0eb6fffbbaf5efe8bddf93ffbf3a7f7fa9dd34ce7c808d5e32af802bea847015892ae00a0345d2b94ec143050faf5b71fc60b0a400128000556aa00a074d4b73e4068945cb316862f66957754e3f0c528b9365e1850baf100183d7c06a5ecde395e50000a400128b00505ca644ad31fa24b2fe97f7d65d4cda812f9dac4e47bf47c62b60a615fa8ad6ac33bd5fa91901d1bd9156713648f0de3bad8a3f8cd750d286dce657b369841299ba3e00505a0001480021b51c0fdd6c99873a757492fe97d19e654eda933b2b9e0e49b9ee1e11e2d238e9b61a7c2989363f891add69130f210573556fe37728e26a9aa4eafd9f31ca18aee43be5087d3c6dc1a83d29161d08d3fa34a48b6a3037e3cb038b2d4fc1ceedc7382fc77aaf0823002505a9133aa3705505abd8b9a3250c4937ecaf9911f7e879d8ef8dd337f60afa6c60163a100148002e314086e02273e03ed19a5c48c0e2fc464d34c3ae564566f266bca446c099c8d699fd759cbf185e9d3f4f4929e263973f339a1b4739fe1078e18fde938f1575a8643a87162f7a7ddae2b44063f41b17121de4ee9f039a50ee03bc3a90e4a034c2aef5710fffbefd4e62540696d1ea9d91e4069cdde69cf3640697b3e83c550000a9450200d4ac9e1250196107fed2f63d9da07a5ac20851cc9335d3e6d7728a7b292764c6a8ecf7679ad839d4cc2893256116db97997970a5594e6c6aa584d9b463ae6ea165bf24422c56cc96c0ccc2cf3782f5c3787e862e58de532f148de10fdd9a238128502c69b7cabd41c2ddc0fa5c2f34e19f24ff1abdb2ea0d47347c81724a91cf2b091dd898da0cb9ce80b5d0859312c47a2161a1b9bed1b13d64d895289d9129f82813600a53309bbca6601a5ab74ebde060528dd9bf4e8180a4081bd2a301a4a297c4a0452995393d2e93d81d35f1ae74ea009a775f3663e1917b0277ee9feef31309f61cb49b028d3bda3dfd0e0d735649055d09453517b441ae655e1d6b88dd01e8390a9f38fa6b664526b82ae99dc2d4faaf9c841f3d49287936e130cdc20105250e0e1ab77b9b6fac7dc14e890c6108a56883a4efd1d503a0ca56449ad0945057a3a4ee4e5a062dd7a9fbac359ec502e86e940c4020a992e257fe8bfafb1d7cfc060e780d2fa7c52af4580d27a7dd3a26580d216bd069ba1001498aec0342815fd0b04a4205a144a758288fee2605230d9c8d1d12c23f527eb825a7d8074a0d429e057f192b861c834cb174dd6502a158458a7fca1977d7570d117ca7a7633bc263a0ea54a626769aec6d4402a98a6c2540c98a1d9b95240690694c6c27e207eece74583613f2186e938220f94861e58ad3b0000a5d3bf5cb6d302a0743bbe5e62a480d22554461f50000ad4a7c068280d4d25397f24e5e584002397efaa75a90e943afba644d952a1e9dc502a76ffb1b383dd6803992b8d67cae83c28ede842a9a05bf07fe98dba81e5bbe1b49bc318de0a643dea5092559a533793ece54a0d3f539a12f6a5a034278695547d8b7701a57b092874ba900280d28584de483780d28d381ac3840250c051200d4acd62599165e1d0c1f7d8ec7edc05b5ba4c4ced5e2855ab0a1d1c72598b2e81e5fd84e6e5ca44fe3799698cac5a14b63aa424ff99bc7c576b412490e4485bf69894af8f258fca3ac94923b04450bf4dc3a7a6294fa2903f7c10a2a81b226a4f28bd58da4aedaa30d103339112921a576670c7d7d4b03759e840bcc98b346df9eed818b61c175bbc0b28457caf590140e99abdbbfcd800a5cb6b8e1ea10014a84181442815cf74f21fb50a942446bcb70676cf0d40a9f380a2e6c39e046037fb563f0ec5119814253a5ca24dd1b1f834ab1d13ab22cc0b37d2e9421fba94fbce526beda7ff340e4b53c53eb5a1f2da097a2f5bed04babbad78530ed97ef0d30fb91247c2a8ad9e624e34bd9215bcc8947ace18ce945a81a7e24cdc0b50a1108d3727620bc5700a93d258767720a3bb34d7f081a86cc0f2dd9abc51bb2d80d2da3dd4967d80d2b6fc056ba1001428a540329496eab06b678b13be1083f53d7abb14b36dd1172563b9645bb5fb62a9982ca9696e5bb5fb22775ca837870280d23954dd6e9b80d2edfa1e238702db560050ba90ff0313fadeeda09602004cbe170a80846e6af7c552319920d5ec456af7c5ec02a083110a004a478885a2830a004a0725420128000556a9400f94b269195e50000a4001280005a0408f0280d255ce8ef63628');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 20, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 21, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 22, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 23, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(2, 0, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(2, 1, NULL, '8efbf6c0e591aad2cd75720fafff31a251190ae5cdf48f35ab61d40a7f8240a908886f93d89a46407fd5788fb85d6bdd9bfe8c26d9365cb870f4dd6fd874d9a24d972fda74d9296397bd61ecb2d78dbff7e48977bf6cf2e293365ff83c9a5ea3406772c9319b16cd7be45547fde885738475cedea5c21db20e3d7d4d58e7cf5788c0c7b70e29872ecff84b641f98fbc183475f7f60fef5878ffef011dae6df70787eeb08dfe4fe7059f8e5b3a41fb995ea3383ca800008800008a42410f986e1bb87ccb1fa754f7f7cf173d69dfde227def957234b5fb5fee257af5fba70fd450b375cf48a8d4b5fbae98293369df7bcb1b38f1f1b5c30b6f8699b4e9dbffef547fdf1afbc1f3edf53d691e221eba819b6a875a4788475ae3970f4b587c83a6223e558d621032588471b082f6a4c20e5798c6420000215226088676cdba107ce7cf1fdaf5f70ffa9cf5eb1e4c4156f3b69c5db5eb8e28c17ac7cdbf3ff78c689abde7ac2c36f7df6c36f39f691d3163cbce8e98fbce14f1e7ecd53fef8ca39f7bed4fb97373d4f58e7fcdd2adc91d611774e33ebd03dc43adc9111cfd1cbf69beeb941453f71caa9105c541504400004402072ddc1984bbce2d0d5dfda3dfdc8ca7f5bf2e21ffce5d36e7fe57ff99785cff8e793ffec9f5ff98cdb4f5ef0af272fb863e19fdef9caa7fdcf573cf5ae970fdcf9d2a3ef7cf1dcbb5e34e78e1778b7bfe9795b1e5a71f53fec88b30edd4de05fd791bff47cf74efae1a7d844d0b35bb987f4e31b486e34ff666fb2ea324ec2d6040298ee070110a81b01754527b8cff63dfbe7bd77dfd537073f3a8cdc8195f4c7d8d42152cebc736722d77558ace35b871eb943cf9c96cf8df67f2eea5d21ee2f987bd58cda8481f4266e5a3336a2afee3dc39dc14d2180bb9b9a400037fa378300ddb146caf1ef5b53b74d5fbcd7bb649fd8e8c5d2dd226a91ff952ff476fe0eefeced1efd57be4b5771e4851c638bceb0adf76f9e5eef2dbadf5bbc62ce929547bd556c6275517f9b73ce5ab989c546494e7a7dd37079ed60c553fe886cbc060110a8018133e8f77cd81a40801470d6a8bbaf17af15abe1d0460fb291dba98fa93fe57edae41efa2f3d758d367abca77cfc9a7cfa2729c66d9dc52b84757cf168f74803199b4c20369d9e1d18beab93e1451d09d0d982adf604d4675c7ec0b1d59a400f4f66f9441c750fdbf12be6bffab163974d0f2c5d977aca0e0941000440000440202d016f70c63be531efc47ff616dce879b04e5a6e48070220000220d0090158a7136a38060440000440a03302b04e67dc70545a029fbdf51e6c20000220a0870c5827ede889749d11a00f5b6707e228100081da10e0e300ac5368b70eb73cff5f6bb8a36a8c0c0d0e0e8da439347dca34b9654903eb64a185b420504f02b04e4cbfd2d0ec79e130def3919a9c93521a568565ddec1ac6d5b9fbb6749a03ac53cf5104ad02812c04609d78eb0cb65a3a7ce8749c4ddb1742721d0639aa88f4354c9f32aef69de600eba43d1f900e04ea4b00d649b0ced0084520d205c138eb8740f29f1f9a88fd24273933a6de54f608935a414cf8964c1b4cae05b90625ba7376d5c18a756496b264a33856671ece85f6321b3834a426ff240cd630dfcbfebbf40e37a73b74cbdf3a86ff3ad5a1ee01d1c08e33a9ef30819681408e04609d44ebf842708f44f20d31d2fa43bb18e58317e2ffda57f62826926a9719560b6b139b33abb0ae43d20c9b559cce590a24e244abdabe629447b54af4b8ccdf95f6d41a75456e0eeb980acd786ee7639da061323758276327203908642200ebb4b18efae61b1d67c36080efd781851cb98298c8bc45800f6a3a3cb047bab89c23c1866fbab8b1d2de2f8b73564062b0ab6d24e66d64216000516987b92b82d7b20e0f89865b1d4c31e6621d1ea4391a95e90385c42000026d08c03aedace30fc5ada1e05bb00e0d8c31dd9044c2f7e52eadc3c3135e87386fd9c5255bc7980ecc661d19edc44967d6651d4b35a1f9f41ca631c517b523afb0e3cb41903f17aa19deb12f083cd6316a12995b4c77bb20c61f1000018b00acd3de3aeaba4b74ee450dfeb1114938af6515907a86cd1958300d44ea101b2db966d88261d7f8962f5b1af1409c75f4251edb528e8b458a813dc3a6ae688545a699e2639574c73a36e1f843787013f926e1ac899e6bec202ec3f00302202008c03a69ace38fc6faf28dbc9740dee0166b9df8efe391892cf64d3c2ec8b08ad0f71e44ea106b1dd7dd04facbbd7db7b6111338ad13dcffc0eff20b3826447976acc366e6c23b12f8d4a4351f685c77715aa76d78978c5abbc79c2395e0e11b0c9d20d0150158a72b7ca53ed87d1f598fab9c5868e23d6c7e6c91e04e1d94c48850342c12acf82d95d11caf55b29e13ae932972704f8f4f21645f7702b04e2d7b588e8c9dfeecb40b24b19774fc3c4deb900074e4a06490668a2f74889a63d415b63209a6109976525ac735d9d852577392e2b92ee0e1501068040158a711dd5c92465ab18eeb127f9a29be6092d19ce2e3b3916a7e2cd09a9e97b4756ccc613a3291060fb328c0e725e942540304ba2600eb748d1019a42690ffaf4453171d264c0ec73ac81087800008642100eb64a185b4dd1128d03a2cd4c1ed00ddf5228e0681ee082459e74fb08275777071b441a040eba02f4000044a42c0b4cea2b5de73bfab56b086754ad249b5a906ac539bae444340a06302b04ec7e87060660274b66103011000013d768855dd10eb641e4a71000880000880404704609d8eb0e1201000011000818e08c03a1d61c3412000022000021d1180753ac286834000044000043a2200eb74840d07810008800008744400d6e9081b0e4a4d00b7ee8000088000ee9c4e3d642261d704f07b9dae11220310a83c0158a7f25d984f03929718c8a78cf8f57572ca1fd9800008949f00acd35d1ff10724675af0cb5e0e2e4d453a3b2a53ce3a710f1ee78f58274d57200d08d49b00acd35dff9acb56a65e69b2b331bdb3a3d23411b14e1a4a48030220d0350158a73b84ce159429cb3006524bb14477b0bfd84ad843fe5a6c7a91641647c94caca322fbfc4729fbf531f2e1d14bb02873b0408cbdc08d6b791b3fc3207f9585b35d76bb237863639de196f12068558b7e3e1e1a6b8476f751c0d120909200ac9312544c323344908bb7b0255c648260494bca450db0f64a627a82ce5e045ae767ceb0852b6faa12fcd15a8dd5098b49ab0cd9c29d2a676b0fcfb06dbbec6646b1a5b64e50f5e804a6585b6d5834904794a2c6e1226bfe01facff0f098b5b15d12eea7e9ba3bf9703408549200acd35db739ad638e95d243d1c1d2b60e1f2bcdd8261849938fa2c1d898f133d6bc74c53122880a82246147a31ac69e60980e4232a35d6de205a775f8229f6ce1cf307453350ceb29c3435dedc1689dd9bbba5dfc85ea70eee430d4c2926fdd7d1e703408b42700ebb4679494c239c366aa4867c006e5b6d61186e0636b30c7a6852443a8c8f7fa44ebd819b6758c5d847be9e6b4ee715827080e2311868e996c92fe1e0a786445c4d1432104993c12e399d121ef0b475403eb74f779c0d120d09e00acd39e516aebe8e929364f157c436fb12fe7e2a531b0260a20f485391cbb66d8ec988947334184e01b2d1c9f8322ac3d9171bf5dbb8687cc6646d9b9ade38b821b209ca833a2c6d082be1d64ddc21a06afb87662ada3c24ff3f68f8469c9eece141c0d02202009c03add9d099161910502c65c5630c4d1c4944e24038441763781f8f64effd8e02927b4541affcdc8513231bf05c1b6176b9f9ecb0a330c76c5eeb183393dc9a6bcc5ef2e0867cb9c41917386cd68813b52d1ad88c211ae727885e5116f1d95a53d29c883c2eece0e1c0d0220601348b2cec0c235c72e9b1e58ba0ee040201702c97713685744621dfbd25478d12b72edc78e8bb8c24339395ac2e6d510ebe4d2d3c80404e209c03a383bfa47c0b60ea942a8c39f618bceee25dc4da0262b55bd553413aa4a8584fc02188b20c3a3f4a41e8be7705da77f67034a6a2a0158a7a93d5f44bb1db10e8f50c26b3bc1e06fc42ff2ce6967f463cc044a8551623dfd18c98a4a32e740250f58a788f30265368b00acd3acfe2eb6b5997fafd3efea4603a67e978ef240a01104609d467473491a99da3a4124d2cf5f6cdab71594841aaa0102f52200ebd4ab3fcbdd1a3cfdb3dcfd83da81403f08c03afda08c32240158076702088000ac8373a07f04e86cc306022000027ad03157b0c6ef75fa371ea32410000110681e0158a7797d8e1683000880407104609de2d8a36410000110681e0158a7797d8e1683000880407104609de2d8a36410000110681e0158a7797ddedf16e3d61d10000110c09dd3fd1d779b5d1a7eafd3ecfe47eb4140108075701ef48f00acd33fd6280904ca4a00d6296bcf18f5628f4816cf5c967fb2c79489a78889a5d9f49a6bc1626b917dd673cd8c6c7b0c03d6e93160640f02152000eb54a093fc07f0b33548e573faf90aa3e24ffa172c3c13b7a2a8b96499956d8f61c03a3d068cec41a00204609d0a749263d917df2b7aad19b12acc105b7826761d6b63f918d76a3261f4e34bcccf6a482cb6dd1a8eac03602f8163a5b7d0f6c93ac13adaed9f586daeca538993019504816a1348b2cefc85abb1827549ba570da4e6f297fed02f87ce38d3b0fdc21ad125d1cc6cf9aa663a5b3693176a4abd62de72a537e8756e9d0c7ac8b20675866c4b7222a01a205079020eeb9cf05d6fc18d9e77fc0a58a774ddabd7800986cb70519804ebe86b3dc62a9cba793cdbc885a140693ca56fbee15610d924a78f12ec8775322dcc06eb94ee144785ea4f00d6a95c1fb3f886eaae07d914b14e6253a3d9eaa4e6b84c7f93769474e4fc1bcdc385ff12c771db3a91f93c75b14a784c4ee705374cb054747304bb69c29a430b26d7e84819ffe915ac65158d3dac44ff806812b987cf311a041db905b39191b274de953bd9506110c89f00ac933fd3fc739443bd1e378df934be3ff9b53d683aa6ecf89d716acce55e1175a1a15fb9468cf291a13f9375585c32dc92a2f133f66fc8532f64493a5b3e4b6815aea4a12a17be1d9463ed61b9f18c1527397de8abc57589c8999b4ec92a87882aff8f0472ac300158a7129d177ea956c37172901117f7986db5b2b5bfa13b0be283b0914726ebf87a098774ae165b36c61ed116d7251c3b13d5a8e86ca11491014ab62b658bec63e3b0c33a95f890a192fd2200ebf48b34ca895d4b34704f19acc3431e599f3867245b870b11d6c1c90f028c00ac83d3a17f04cceb3a23432d3553e70fccc3c15522a77e7420c27eb9a4aec50433689dccb005b9a93c982194800c678465b966d8c2ab5c4c3bb04eff4e3194540102b04e053aa93655b4ee26082ffeab072ec44dacc96b3de6e31782ab2d6eeb58f70e4466cf5c93693e685d27f533dc58eb38ef4d60f756b03b1b8c1bd66bd3a1680808744000d6e9001a0ee99040e7774eeb02ab1837b01f3575080e8781408d08c03a35eaccd237a551d661a14efb872494beeb504110c88d00ac931b4a64d496400ed6695b0612800008949b00ac53eefea957ed609d7af5275a03029d1080753aa186633a2340671b3610000110d003885ac11acf61eb6c48c5512000022000029908c03a997021310880000880405704609daef0e1601000011000814c04609d4cb890180440000440a02b');
INSERT INTO SYSTEM_LOB_STREAM VALUES(2, 2, NULL, '02b04e57f870300880000880402602b04e265c480c0220000220d0150158a72b7c38b82d81e79cffb9345bdb7c90000440a01e04609df2f563151f3b164f9194b376eda3727be28935ebd73fbe71e31363631b2727c7a6a6366fdf3e3533b39dd294af1b50231000819e1080755260b59f406c2ce19c228ff6499c4b93b53f8ca5e820870e0e618f5d4e83415b274e39bb76cdc03a99fa198941a0d204609d14dd5739eba468934ad2555c95eab9cad23a09cad9b36737ac93bec7901204aa4e00d649d18331d609573dd62bc488e560c48a306cc515913f5b1fd97fcbb1ec31cbacd5a2d5ce86fca565c2a59e8dc2fc1ca269cc1ca81cb6708c581fcdac06dba1d69589d435588dc6ae8c6296d63ac9cad9b76f2fac93e22c441210a80901582745473aadc356151b6ed100cd86e0840042a6725887a9c897837a50be5a9dd2cadc91269a835a312dc8c768a5cecf9c6173ad95695626744e4cee91c2c828ce6b3934b146510e2967fffe27619d1467219280404d08c03a293ad21debc8b554f8d2962a3ae1214a3891a5df241fb4b58e0e96644a16a4a8ccd3e460cb8fe7e35cc1d3c8965ae72cc85f7b33cd451d6a3e19c5be7d802be7e0c103b04e8ab3104940a02604609d141d99745d27704f427c23c6fa6088d61631bc22a7b60c13e89d4e7fb4cdc1aeb6510dbbd00cd649bb6a1919c5b863cd50cee1c387609d1467219280404d08c03a693a52cd73c9a46a6a6d64a8a5aedec8a13a9c9b32736443b912109b9d0b95a4773ac20b2bf3b85847c65eea5d560c178c6c42782d8a1fe29a61b3f596865990868cc26f92b69573e4c81158270b51a405816a138075d2f59f3d37e5cf32456e1e70a45199eba4faa2bd4e1b5ec60f2efdf33d9100a8ed1c9d9d03ab92bcf4a42aecdfb030e2d74eee4cbe9b40a66497a3221a4e264846d1bfcb712a870e8775d29d85480502752000ebd4a117cbdc06328afc29689c72609d32771fea0602b913807572478a0c2304c83ac9ca817570c68040a308c03a8deaee021a9be6216c98612ba063502408144400d629083c8a0501100081461280751ad9ed683408800008144400d629083c8a0501100081461280751ad9ed683408800008144400d629083c8a0501100081461280751ad9ed6834088000081444c0b4cec0c2d5c72e9b1e58baaea0faa0581000011000813a1310d63975adf7dcdbbc05377adef12b609d3af776116dfbecadf76003011000013dfcc03a458cc44d2a933e6c4d6a2eda0a0220e020c0c70158a77fa7c8edfff4adfe15569a92609dd274052a02028511807572434f224976097fb733eb7490430787e446c4ca08d6e91d5be40c02552100ebe4d6537db64eca7a77a6b79499674d06eb642586f420503f02b04e3e7daa0777fb051520774a2d19af8d5884ab4ba7e779f21c64d579b6c97f3af3e187d88a72864a6d4bd44d36e0c23af99c6dc80504aa4c00d6c9a7f7525a4717668fe6ddef315aa2f566149aa6a094f534ecc285eac40aebe473b6211710a8320158279fdecbc53a467093460fcee8c408aa72b78e333eb383309b2cac93cfd9865c40a0ca04609d1c7a8fdbc239f8c6851d7a8acc3925d58175b21e925c316728a3eb6c1fcb9b83582787130b5980401d09c03a39f4aa1170a49fda8ab34efa1c9c45779f6dc20c5ba6c8c9808b582787b30d598040c509c03a397460dcd06fcc98c9d02121bcb0afd2dba3bf9d43dcb57d3ee967149aa6205eb43165a7ebc0e31e7b8e11336c399c5bc802046a4700d6a95d9796b84188754adc39a81a08f48900acd327d0288608c03a380d400004601d9c03fd2300ebf48f354a0281b2128075cada3375ac17ac53c75e459b40201b0158271b2fa4ee8600acd30d3d1c0b02f52000ebd4a31fabd10a58a71afd845a82402f09c03abda48bbca304601d9c11200002b00ece81fe11a0b30d1b08800008e841c75cd56dfec2d5c72e9b1e58baae7fc3124a020110000110680c01619d45ebbc136ef316dce879c7af80751ad3f5682808800008144000d629003a8a0401100081c61280751adbf5683808800008144000d629003a8a0401100081c61280751adbf57d6a386edd0101100001f3ce69dc4dd0a701b891c5e0f73a8dec76341a042204609d0c2784bd5c7486831b96d4c90ad669d85980e682808340d3ad632c506613b2d784ce7a1e759043078764ad55afd3c33abd268cfc41a0a204601db5b8675cff752f800e22a40e0e29dbf907eb94ad47501f10280981465bc75e74d9768c73f16623190f98e256ad6ebb86b433133a4b8c85a8ed3fedf1ddae83cca7edcad33a410219e7ead7696a4575c00c5b493ef6a80608144800d611f0ed4156ef8c8b750c8b24a4779a2c39b44a3e24ae689d67727c661fce09c84ce2ac136765e3283b439900d629f0a38ea241a02404609d6ead6304165985a1c76b23a832149226db64ebd8f5b4233667a1dc52e9ab614760b04e493ef3a80608144ba0b9d6e1a3b03db3d441ac13f77dbf6dac9366284f9326c13a09119bd33db669d2c77636075d31c43ac57eda513a08948140a3adc33ba0b351358d0cca6c1d7b2a2c61b2d1489c3cd18758a70c1f6fd401044a4800d6519dc2475b3ed92587da8411d64e6cc71c760ece22743267a1690a72ced7c54de2d9c5258444bc51c68186bc8d7af27711eb947008409540a0cf049a6b9d3e83ee6771ce38a39f15882b0bd629432fa00e20502c0158a758fe3d291dd6e90956640a022090070158270f8ac8231d01c43ae938211508d49940927506b082759dbbbe80b6c13a05404791205032029675d67acffdae5ac11ad629596755be3ab04ee5bb100d0081ae09c03a5d234406a909c03aa951212108d49600ac53dbae2d61c3609d12760aaa04027d2600ebf41978a38bc32a8a2000022000eb345a03683c088000081448c01b9cf116e16e82027b004583000880409308c03a4dea6db415044000048a2600eb14dd03281f044000049a4400d669526fa3ad2000022050340158a7e81ea87bf9b87b0704400004700f5bdd47fa32b50fbfd729536fa02e20500c0158a718eef9973a3234383834d271bef6e15d66e8aa09acd371ffe04010a80d0158a7645d4963bda7ff65d148979280754a7622a03a20505702b04ec97a968ffec240ade194158475528242321000814209c03a85e2b70b8fc863b8a5ad13c6407e002492b55a415824d4a40ee4a6a2c323d1128ba382fd3cb492fb8c3d7eb6432d0abf7cff19d5b07658ef475ad8ef19b66e4c4cf0fc7fedb5df4d29253bfb501d10e8030158a70f90b314c187b0d01a51fd901ec4e81e98438c8fad617da04ecb0e326ba0de9247fa6faac3ad3dbe468291d7590df5e670cbaf439056fc69b5bb7cd609dc620ac614765217c23a594e70a4050158a764e7801d7c18f187fcfe6d86448343c3fa6e825029e6c0ef8a63447ca3ad63ccef49bde9782972cd49860172d4d6e5187f9a6ccb651d6e6e852030793fe7364b7602a23a20d06b02b04eaf0967cc5f8ff27ce0b3bf4d275947a8a0356c453a7c909587b7758c338da34169dd635a279cbe63ee0add66454bc9d37de2ddf4b38e945a4d4c06376fd09f72270b805458199d6c336a182957299a095acf88b2894aced0919b734ad38b4e97663caf901c044a4320d93a6b8e5d363db0745d696adb808a701384d35d6ce28b8726f2b59c0db28212f3063896201050388f14bbc7d45bf43ac7c8504bddadeda71b8efea9c2a8b0d71cd6d18192aa4bd85247bce10fd089d37da9671d65cdc3324209b18b6412ae2a31486bed613a37c3279981d499fb12913337de46630ab4011f0134b1ee041cd639215cc11ad6e97bff47c31a7fb00abe2cf31baad977e9f03a7fe899682e4123f477781112c8c4c1aed83d464ebc5c91431816f8f9197f9af49cb18e72932cc87467241c19fcd2ff9e34dd670a3271d671b8252a1c1ea2ac432d8858c7ae4f9a3dd46e0394bb43f4e5341f94d49a913f9fdecc72237ddf4f5c1408026909c03a6949952b5ddc28c6a39f72d558d4a633eb84ed881b91658a24eb58b38eb1b18e1fbce9acd238c699464f87d936e5fd929c3fbfa721b9c7cbd7d7a81108c4118075aa796e248e410937af15dbdaf6d671cc68b12a9b5e31a7fbc248a8fdac23bb8d2ffc596e70ed242c28dd0c1bbf115dcea7f13d460ca7c31ad132d70c5b18d330edc03ac59ebb283d3f02b04e7e2c91533b0229acc3e7a6dc77135028a2fed9b358a13f825f1725cc3a5a17cb62832a956d509fb05ce3374ce1057f7332d33151199f1b9f49e3b7766386addd0986f72b4100d6a94437d5a492bdbd73ba9359473ea8b7ff3d6891dd50da00b6482828bb9204609d4a765b452b5da0752a3a68332b965b8a153d2351ed2208c03a45506f6a99bdb54e53a9a2dd20502d02b04eb5faabdab58575aadd7fa83d08e44100d6c98322f2484780ce366c20000220a0070cb582357e259a6e08452a100001100081ae08c03a5de1c3c12000022000029908c03a997021310880000880405704609daef0e1601000011000814c04609d4cb890180440000440a02b02b04e57f870705b02b875070440000470e774dba11209722380dfebe486121981406509c03a95edbade55bc678f3786757ad769c81904aa4200d6a94a4fe5574ff6a866f7538c9dd649afa2f894b04e7ebd889c40a0aa0492ac33ff64ac255ad57e8daf375f294c2e9c69fd4b2f186731b04efdce1ab40804f2236059679da79f4d00ebe4c7b93c39590f5fb617e8147b688d6bb9aa0c5b995a464661a8a423a5f0c9c8fe0acc6a391a3b90aa52acd3a57a7bd7e101ecc84adbbd2b0e398340de04609dbc89963e3f356ae928c7699d600166e1102d1bf182494b1d28924442a6f4b10e5f96cd8b6662604ce3007335682ec5eccb04a429b19bbeee30ff2054958777984937f5c6b120d02d0158a75b82553d5eca27badcb25a7ad91cbed9ba9c514f88e3ed812f9375b41afc9c63e5906a780d8d289253bc26a70f531d9bf73463dbd3a2e35a71489d65d2b66e480002bd2400ebf4926ed9f3f68769f70c9b3f99a6e6d3a2d63126cef2b20ed303539b6352cf7a37a43cdc52951317acd81f662e327cf36b3e24e46b2c446dbcabec1cd090f387d60ad901077386316ec6d1c92d76a96c39d3c9573ef5f7e84cac52e28a2dfb2989fa358000acd3804ee64da4d1c8985b633364e26574de267c530d7062e08b4624ec784354165af3ba8e39f25ad79cf40ee797fad84b5423432d7f8c0eae499921943c30125d593387fc5d35ad15b65db5d929ec008f7fab863d21194071b45d1d190065a8b95df88467d8294113e51ed62731778c34ecb44773cb4400d629536ff4a32e2c54e0176fe49d03740f811ab3d4b7ee20099ba7b233607be4e027bf93b7bf9b20ce3ace22a27371ee3b16a4539559237f44239568a0a042baa0c93294711a255207571ad574e6009e6bc2e498519cb3022c1c8ccc85725c2a0ed3f3a7fd38a5500608642200eb64c2d5e0c4fc8eeb4e31b48975c2efe9c1e8eefc8eaf75e60880fcd822f87aef873cc1449b8ae3fcaaeb82b84512660e9de9e3c4106ad775d14ba3332a6f5b87034f8e759c8120af46a7fd85e340a01704609d5e50ad599e71a14be666265a279850626368680a3d65e47c9755842443ffd45529fe877d6064b0b6660eed58c78f636414a3aac326b25455e5dc5e68367b4232a8ab23ceb367d812');
INSERT INTO SYSTEM_LOB_STREAM VALUES(2, 3, NULL, 'ed1bce853a2a1fad46e69ec20120d03b02b04eefd822679380c33ae10454186be88be66ac6cfcf46abcff92e0f2122b382ec2a9479a01d6de8ca183725f350237ac15f4f6e05550d2ff8abf6d8b385b2ae916931e3768660828edf3d10b97fdd0ad7cc52ac6ae0640481d21080754ad3150da848957e255aaaeeb0ee9b2855ed501910c84400d6c9840b89bb2200eb64c2c7429decbf72cd54121283401f09c03a7d84ddf8a2609dc69f02000002b3b00e4e82fe118075fac71a2581405909c03a65ed993ad60bab288200088000ac53c7d11d6d02011000812a10f00667bc4558e9a00a5d853a82000880400d08c03a35e8443401044000042a4300d6a94c57a1a220000220500302a6750616ae3e76d9f4c0d27535681b9a000220000220503602be75d6862b58c33a65eb21d40704400004ea4400d6a9536f96b12dcf39ff7369b632561d75020110e801015827dd6ac7b10f9677f549a6c43de8d4526549cad9b8719ddc464747c6c6364c4c8c6ed9323e35b579fbf6a99999edbb76cd509a52d51995010110e81d819a5a277c1c6f8a8759a591449a34ba971212a7c9274d9ade9d1129720e1fba1cac799d7090b64e9c72f6ecd905eba4a08e242050130235b50ef54efab13b4dca3469f2b24e654ead544f4596d6712ae7c4db4e24e5ecdbb717d6a94c9fa3a220d035810658c717c690bfbeb2bf4cb164163edbb735142c3b6faf32692f9412eeb1166bb612b31d7aa514b60a735c56d270ee6afb75176fd1bad37ad565d62e2b4f6347ec9f7cb14ebee48c2ccebd76745aebc42987ac43cad9bfff4958a7eb0f32320081ca10688675b46cd40ac1621c0da7ded8283f223b4e45366cb9c6704f709c19fdd889d949a0c7e7f02836641b59e9fa98d50e3214d5f73526ca0c5e88ff5b79b2868a259e8d3ff959aa0ecdd0e4f8253323673f19455ecb21c7e86b39f45a6ea49c0307f6c33a951930505110e89a4033ac63043171a37c4232668270254c66aec8849ecedf192a99614f3406d3cee395745638b4235b659255ce77960ce9b4618d3fa3ab5b3a17d3e44d08b3d2ba6b7f029251e4ed03523374fb80a19c43870ec23aed39220508d48500ac632d0c9c30ee275cddb125a123125b0f7c8f7d26c5c65e2cd6495edbd8cc33c63d760d552cc8023e779353cdadc95a9051e41d6b5a363cca21e51c3e7c18d6a9cb78827680407b028db48e7fa5c231c316ec0b46e3700c667b7880634c51a958492566e37538bc8725c74f50756c1d3fb289dcb43732d452b799f9990e9b7f8a0b488162fcb93aa61d7b9ab1fde9e4484146899b5893ca3972e408acd3115a1c040295245053eb84f342fec58cc4db04d4dd046cb6495caa978704f71c847bec4933ddef56627dc742787890a5c83e2eabcead63cd98b19b26f485203909176d9f6737394ce4a8278f89da9cf76414fdbb1cba634d5fcbd1ca91f150253f3da834088040760235b54e761038c2312d97e2c74e6db99151e44f41e54dd2f2f601ae1c58a72d432400813a118075ead49b39b425bca33c6e2a316321649d64e5c03a1989223908549b00ac53edfe2b7fedd33c840d336ce5ef47d41004f22200ebe44512f9800008800008b42700ebb467841420000220000279118075f222897c400004400004da138075da33420a100001100081bc0898d6997ff21aac609d175ce403022000022060108075704a800008800008f48f00acd33fd62809044000044000d6c139000220000220d03f02b04eff5837b324fc4ab499fd8e5683401c015827e3b991b0d881cc2978a48c788659dbc4190baf6272b982b5dc9c8b8ad2f372f06c822af62cea0c029d11688e75fc2727f355a713964d4b60d94624c1c398ede746a7ec9f2a884a3f84da5ac4dbd1486d9d38e5d05341619d9467079281400d0834c63a6234d70b18f81dd70beb4417eee924d6a9827582f33ed5da6ed23a4ee5d0aa07f241d4b04e0d86123401045212688a75e4601e5db34cadf62c163ba33028587586ad26a3bfca870f62968bf10cf9eb42f3a5a123936b3c2f73bd6ab6f21b5fe8467557587874019ee89203caa0b202ea1095229a81746bd8b6843f751868afa663e599d53a71ca21ebc8b50f609d941f572403811a106888758208c25ea159f6a133c2505fe5a3f18b3f04ab21de5edb4ce7139961633181de1fe6611b45aeef192e0c6a4450be49f4226dc10bb51268909bb32096d1702b5aaeaa235b8d54b5c5aa3c734e9ac510c82863631b262646c931718b8ac23a35184ad004104849a019d609a562afd0ec9a6d53d1817f1dc81052f2bc9cd33a3c7a5001920c9e5c8ba619396829f2c4769ad031baea327fa320ab5c23b2b15be7a8bc32629a8b3a94948c42cad9b2659cac431badf0265ff04545619d941f572403811a106884758c91339ce472af6c1dec8dc42b415f77661df708ed724f97d649555050ae8e9974b467c782ce2850c82ced3aa36414520e45395a3686720e1f3e0cebd460284113402025812658273a41a50756be5bbf66836c30265b336cb6ab34ecd819b6e8203d32d492b368f6d45e585ae20c9bbe5c1479c1e6c782202952d070b4dc61ff6257500f7fd2ce8e05ad3c539e594132324adcc49a5ec71ad6c90815c941a0c2041a601df3db7a38b0caeffc72e0d5aff59d03e12d6f2c56927713c891da7135c86d1d7e115f9617de9e60072761adc27263aefd38a7daf8f4a0599059aea3b16192008d310b275a6e5fd18afd0c9051b66f9fa28935b98e359f58a328e7c891237424ac53e121045507818c041a609d8c44905c11c8308b96c48c8ca29523ef583b7060bf8e72e491b00ece3a10680e0158a7397d9daaa52cd4497be526395f328a8c72e29403eba4ea18240281ba108075ead293656d079ec356d69e41bd40a01802b04e31dc512a08800008349300acd3cc7e47ab41000440a01802a6750616aec60ad6c574054a0501100081061010d63975ad77c26dde821b3deff815b04e033a1d4d0401100081c208c03a85a147c120000220d04002b04e033b1d4d0601100081c208c03a85a147c120000220d04002b04e033bbdaf4dfeecadf76003011000013deec03a7d1d821b58187dd81ad86a341904408013e0e340efade37e547ef61ec92b9f3425b72d2b786e8c78684cdbc4694aac4a9aec8d8575aad2b7a82708f48e40aed6610f2476afed927e9c72a674ae37d33b3632e73685064f5c762ec0e3ac5b7a08599bd671cec90b05c555237b71b04ed62e457a10a81f811cadc39f786fae89acc0a51fa7aa629de8823ba9629df410b29e6e1de75c63eb74cc242b7ca40701104847205feb584f260ea31f3ff8e171835afa450745e1038e5bc3c6613ae8088e69b568619b217f459c70f167e74141b0e227f6ab67258becb0c75fb5c7993b5f7f26bac4755c6522c50f0f0dea15de7c67d30eb1924f9b76c5e41ddd1dfe65768a1591f2034595e43fb96077b0408fab9bfce585cc5e483ced8c5887e5af56364a77d2664905eb64a185b420d00702395a2758352c1ce5d8aa2cf2c3af86006bbf3f164746c7b6b18e72885e54ccce33a0e78f6d41e6ae2a056f8a002dd63a31d76cb847931ac8ba9217a1ab235f88aa06e3bb5ab7b35d85f93912e61cbff6284faff3b65b6d9c7a2a65b49b38d8744bbbf1b38db755c00d163acdf9a4877572068aec40a05b02795a47d54506006a0cd58b59fabbb47bf86ebddf3d80bac66ba71b8c3cf57146623399aeae7f402ed6e1dfe15930a66a141907d5701e8eeae105b120fa49aeb0139ad9646bf9d1c81aa3ae569be1653492d3ef262ca5ea3a33d9d916a329238ef31bd226a80dd3a8fb3922f119acd3ed1081e3412067023db08ea8a13f8ada1ff848c413f3f5df1ed16c7f24b8c1e6d3f68bbcaa30f322af8311cd18f93b639de4912efaae4f2a083a4c21c939b76091ec48d151591ad012acc3430c67d3f84e1d78393b2e15d848a5c3b3cd8dc819d885a168b0e0772051f625c6b1ea9c0e1fdd0073fe20213b1000819404f2b30e0d01faa3afc694709e27fa35dfdaef9c618b4eb9a940445f9b31bf65db790604cca1dc9cca0ba676fc7434ca07efabf139320abb2e5cc99a44c6e5f8cac894bc0afeb77bd51a5e55150c3818462a2cca662d5539c7cfb0b1224201f12ae9d78e94d1aae7631dbffdd6752475c1ce2e22481e0434d6971b9e209cf34cf97140321000819e13c8cf3aec3ab91e45cd7d91113c7aa19a0d167268975fe68defa96aa77f37811a6f13f2342200fd67647e49661996a52b22aeeb47872d47958c70a16d65fc3a44f33146775d39f68d3eb1c2fc1c09730e799aa6d40d560db4aaa43371a4e4dde4df4d60f642e2191b3bc3167176d4a3461191ef107e4ac34cc9f159cf3f5028000440a00d811cad03d61d11e01738ec21b5a32c4b7b50ecdd04aae171c131b74b9a344a46ea3e3cccb095f68440c51a4900d629b8dbd9a58cfa3fdaa0fd9dd309f36371716454d5667c567791177cfaa27810c84e00d6c9ce0c47744a00cf26e8941c8e0381fa1048b6ce1aac605d9fae2e414b609d127402aa0002051380750aee8046152fcfb685cb7e830d0440a09904680480751a35ec17dc5858a799030d5a0d029a00ac53f028dcb4e2611d8c3e20d07002b04ed386fd82db1b5ae78ba3a39b472fc3541b088040c308c03a058fc24d2b1ed669f8f75c341f04609da60dfb05b737c93a14fda8da4d7d417efb0bf7ccce22306ad837628cce752500eb143c0a37adf878ebacf9cdecec6fbe276473d9ffb377f6c1350b97857b847e601d5807046a4100d669dab05f707b63adc3bd22429ca92f187b609d5a8c3875fdfe8e76a52700eb143c0a37adf80cd6f9de5438ab865807ca0181ba1080759a36ec17dcde8c336c7b7ff0c5e0020f629dba0c3ae9bf1423652d09c03a058fc24d2b3e629db0f1feed03f6dd0414eee87fb00eac0302b52000eb346dd82fb8bd1dfe4a94f423ee2fc073744000042a4f00d62978146e5af199acf38507359ee05e6a88070440a0e204609da60dfb05b717cf9c2eb803503c089480009efe59824e684c15609dc674351a0a02b104601d9c1cfd23d043eb60cdd0fe75234a0281ae08c03a5de1c3c1990884671b5fa9daa37f8343239972b2124bebc03ddd51c4d120d00702b04e1f20a3084520629dae4513c10adfe02c03818a1080752ad251b5a86692757c6d0cb528ee690df3d7d4f030306a0dcb3f754a8d85c73a61021146f9c7f04cf2d55d2d3a068d00813e128075fa08bbf145c5ceb0c9c9b1a821942d6687c944f2b54842af78ca38ebe8ace8686119fa5f901fa2a2c69f8700502c0158a758fecd2abd6dac332279703118af834848a58c8f7522599997910203350b3f5a0b02a52000eb94a21b1a528922ad8379b5869c646866e909c03aa5efa21a55b013eb3867d86c8558d775a26153384d57239c680a08549200ac53c96eab68a593ee9c1ef66f7db667d8e4849bb82d20b833c07961a68d75782639dca75d51fea83608948100ac53865e684a1d7af82bd1a620443b41a0f204609dca7761851a00eb54a8b3505510e8110158a7476091ad8300ac83d302044000d6c139d03f02b04eff58a32410282b0158a7ac3d53c77ac13a75ec55b40904b2118075b2f142ea6e08f4f0e99fdd540bc7820008f49100acd347d88d2faa874fff6c3c5b000081aa108075aad25375a867db5f8976fef4cf3ae0411b40a01104609d4674');
INSERT INTO SYSTEM_LOB_STREAM VALUES(2, 4, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(2, 5, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(2, 6, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(2, 7, NULL, '02200002ed09c03aed1921050880000880405e04609dbc48221f100001100081f6041cd679c63bc78e5d363db074ddfc776c49b9895cb081000880000880405b028bd67a2fff0f8faf60fdb4b73df6a7178e3cf5cc354f397d75cacd3b755dda8dca2b6a3b75ad97725bb4ce4bbbf5a239a94b4fd91c912c5d07f5a26b52164dc9d297de8b3cd3f678eade49df9c0c297b507afab32803a2dc3f173d68782fb0170c3325a5f4bd9332c34cc9d67aaf5be9bdec17de09dff716dce879c7dee19df05d7fbb2d7821ffcc71a39c536e3916ea67456acd7d4b4f267dd169f9dc96a13969f34ccdfcb9547aba2d3da2b4954c79fef8c952563253b2942d4a9f672f1a9eb292d992a5279ffa444a5b81028bcebd2d72384a7d72a64524c7edf26f54cfef8b7a3efb7ff8d6f9b36f89ff610301100001100081de13f8ff01c1dc1e11cf668d740000000049454e44ae426082');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 0, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 1, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 2, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 3, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 4, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 5, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 6, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 7, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 8, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 9, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 10, NULL, '40990a497c901f431c4a0d89845b666d68410e8cd8e991c7a68568b4abcded2d69f19c48e574919f824af52d98ec2b81fc4385d45617d8311030c8f5efaaff39c0eba002a8002ae051010076f0d571d28cb2c90b2b08ad83afb507cee46ea8aa7ef7a4fddd3396678ed5fef770fd33078d4f65343dbea7a6fffac6d013f79e1fb326726d75d4fa5a0815b94bb06483d3ea8483f76a413ae789860527c07b256e03d1e3836fc31f8138b20f8e34ec2d013397650139bb9a901d61976a094389ddc566a431096104694c3e4155e72a747b765b485f25d1ba37819a46ae451c998c495f489c30e15c6c776940c7fa8edc1d75fbc225603471e69a09eb29a02394560411d8910185c7a1790aab6bf4f4d1c84ea4733967eab1ea3e1da12379cae4726e9fb8bba7e9fa7512acbdba9a32774f6077defad654c3f0b9c690f9c69079c6e1738c1fcd340c9e2e00bba98637a20daf46195e8c303c3fd9f0ec24c33361868161cdcf85353e37bebaffd05cf0b589c04e3d087c3cba1904ce3283442cab02660729b1491317a4c4ac25056153f882b02b932296331fb6492362933e9e9a381c80dd94bd1f4fdd3174eab2b7c37987dd8c32f8071204761eff36f5b006fac00e509dee7dba3a4e1a9797d5a79faf0bb9c84d2ee2624bb9e965fceff0626ec4456ee8ccf3f1f3b6da6d2decb0aaafe85eae5a755f1f81f45dae53809d9012eb95c3ce8d7f4d615e6a1f9cdc85ee4b0894f61439422d2d277ce9a55aeaaf85d7416027e6c3eaa1375d6047b9f97854e7faea54b2ad58b68212414aa415ec72521aaf52dd422d35f12d2aec0fd7b0f3feeda8e520e2db5fcfe8e42b3461a899bcb09a9ecb8d38fa548c89766069e99b6a4d34c13347b3225d60275bf3e80df5c79d68bfd36601fb7aefde3f8280b4d49f9e88e7e45b54fb1845b55567c5c9c85c4f8be7dc7bf474f36c55fc54ea4f63515902d78307b9fe01798838082a800aa0028150400476b3cac139c27f1d5d511db9aa3ae3746e9aa9e0f523a6978e58feb3ef5adf94f281c975ffdd53f6efcdc503e2cbc6a639de9c7370ccc21c02ece4885e5b27f21a0166115447b08bb0ad001deaa00089f6f1804fa445f2364570540df439940e0f62afe205c0125011e16284c4913937afe7299eea12eb7309daa30f126a46ba53db7edf1dad003d207523ec8415eee9259ca280a3aaaf5a4f1528d4dca08be7ab1241c361d9a723dd2c79d950e8d0cb1bc1663d5c81a3e76daf471b86cc360e9b6b046c370c80dd2cc3e01986f7a619de8e35bc1963786d8ae1a568e3f391c667c30dcf4c363e33c9307052f3c009354ff1c0ce42302e33080fec5c0f0267d94196d5c087240c9234615e4af4ca94a96b52a6ae4d99b206805d72447cd2e425f24772f29819c9a3629343a6267f1c0d91f8f19484a15396bd3d1966c203bb19656419bb31e3f206bd7b36101fe43846b02be012d8b5b7dfb97b570cd86e6fbf7de37a8b7b600735259292725f3bcd0dcee23ecee3391dfcfe309b7bfd0cf7f6f2ba59912bed56a70eb0532f10eedd4af3f74fd6ce047693d7e47bebb0f30cece41c5509dbf907ec9835dd3c18e5749352b58e36c58346557d95699dda2be7322596c673ae1269e90b51b638da61a7ba23751b0225995b16ca5c20b0f3e71da80bec84445865e932058479ca7c6466a0a5667403e1ac7221051549d8aecb809d9b55fc74e7e08fd09ddcc705cff2b0b69cbe1d8e866e5ea6c4ca77e7621efa326a1bebe6db0a8323b0ebe457100e8f0aa0023d4601007660f7983caf029c233cad83afb56b6a524fe6e6dfb81c92d9f874526dbfdd85ffd9913f60db95015b8a1f5f953760eea5900de5c3b694be3d6977f4c67a3900db01b08bde69e57d52279bf86d01541ddd57476f2f3ac993bbc49dc2c1b5c6a300c5f28cd16b9b124b6f96945a17291b752e5a928eda1086e247e04ff9d8579caa6cb213a627cf4dba167d3bca0454cda8eb0a7754efd8c0b7f4f7ee6831f5f4d499b0a4800b955ce8263904c507273f1a7934e1de559753cf4db9719773561e90fed3211d4b05c84b5e3f18a800a5c0b10bb657a38d507762e81ca075a6a1b38d1fcd360e9e657c7f86f19de9c6b7a6195f8b31be3cd5f87cb4696094f1e908e3d3e1c6a727199e9e50fbe4d08b474f5ac9cb8919840776ae0781b3ec202bf90a303048d2b839c991f1295357f3cc6eca6a8077c951acc32e65f4b49491539343a2923f8e4a1a1e95f05154fca0493093f0d9959366959365ec10d8f598bfa41e6fc425b0bb71a34d885688ebd75b1d765343cd35f7c00e2e76e4f095d792adcf1ce75e3cc9bd729aff0ddbcf1fb835626e49d8c773cd269b3b60477f5352ac28ec2252ac554327758e5a5e2a53b3fe14ff654c6f7929eab87209d6fca24cab331c76e1eb7860e795c3cea0498995b241790b98608e1b21965b9520949224ab97124bc01c0bf594965a631ac5da142ea65b7442077b31063d3927573aee4dd1096843ad28c7bbed740b53508bf1518bd929188eba4759222aa15858ef8fc9b4a5d8a2ea2c0b22312556f57e7701ecaa04c39b68c892df712eec532e3fd154835369ada4837456be50a8b0369d72827f67937f2c502ecc1ff33225964aa2e5bb68999178c4e5c4549c48998cc70ff0fbd18092ba6a9d2424a59b664e9290cc09cd6119a1c902688fc075a8d5005d149fd5cd6e56b2a195d34c8d0b718208eceec7cb0aaf890aa002dd51011ed8cd288b98cfdbebf8acb1353580de524ee65dbe9d35eb62cdd3dbcbfb6c3affe4faec016bf3faafb8f0f88253fda34e7fbc3067fccee617c6ae99baa571ea4625a6ac6f98b25bc02ea79af9edfd02b0dbdf406f6fc81330169ce5c324003b136cc79d6a2ba96f4b3aa574115aaa4368e92284a14aad7142035757d1ef2bcc93cc599cc66ed5dc482fea143d07e516d46d9a9308b0a3fbfa7a77b498b4b66e262c29a0ba53a13d49aa1500221d0247e3112a4d18255e49809d40eb084453589b1a5fba04760abf53809df874c46948c4536829ced367ec8874afe72b702ccbfe5294e9bd19a621b34d4301d8cd317d34c7f4e16cd3fbb38cefce340e9a617c7dbaf1e558d3f331a667a7989e8e32f58f34f50f37fc77425ddfa1f9474f4bc04e3d087c62bb1904ceb283acae8b5e590f33491a3b2b3962694af48ad4a9ab5201d84d51d6b04b99bc90fc21b87dfd46eae8a9a923a3534644267f1cb97348c4f241613013f8b025cc0e4c7608ecbae31f4dffe6ec12d8b5b539545965bd7a55955df608ec4e9f2a7b2fa1f94f69dcffcbe0feb19f1b77b475eeceeae8f0fd43de5c183b71996760a75dba88f9eee46a2928e5ee992fbb9af5a7e46f89ccf252f4b747d249d7b3231dec0c6017b656ac120b4bd7c5a5542c49ad74572596ca570526259798e8133298cf661516aa233fb21d0c7896b8abf4552f6fa79b1b2bbf0e4892ac9b62afd2027962feac44df94f2172ed6bfa31b481396e74fc3323215f9885cf3415e7b4ed34bad92aa6aad30168ff39436d2386a0c27e9c6179d10f11f55a05651158b4eb8fe105250379d89aabcc58477a308d2c953f6d16bcb7c50d0d7a3099a58de422ef3a0f07e82f92540276cc37c5c159da0c68789ca7b621797c08efef703e162ba1f3252caaebe29cdbf4ffa00f5629fa3f28f237a0f4c3aab7b23f450a2f262aa32fdf4e50b5079d3d22792f625c24e4fd9d7ae6147e02cfb62d37fa106483d1c0615400550811ea6000176e10b61f53a91d681692ee544deb53b055babaebeb0a5a4cf92634f2c3af2df85e7fa2e3cfbc4bcec17e7158fd95436727bc5934366476ea8e0999d1c00eff6d8786077dac083bc834e1ed81d14889eb41d775a00737b08e633f3b4e8a259d9e6a19b2d4e8080ea962a32485342695b184abf2f7d159d71e80b6db808cc884c4fd38bbe1d0553aa9a5143190460e7dc20b6149af97a77b4982e3464272c29a02791ae86d4fc851b543d0e61347d7d84c6e283a6dbb898b3a8a766404567a1237f75f5c85edf88c75748f036708da15de1e907f1f8f16cc70b91a6b7a79b3e98651a32c7acfb39fcf274d30bb1e667634c03a69afb479b9e0a373e39a1fe3f00ecced888c8da4186cc357d38c7f4c16cd3bbb34c8366995e9f699207e1819d7a90680076abeb6090a431d393c3e352a2e253a7ac0466274f263572496af8a2d430a5ee44daa8a8d49111c9c3c3770d99b4625028cc2472510d04303bb28c1da6c4f6b03fa9ae6ec725b0733aad76bbd96269329b1a8d86babaead2b22bb91e815d7151e3b06d8d7f4bbd37f5d4f5ed4995a3471f79eaa92d43de8a5d327bd385d3972067969d07eb65101c15cc3739f99ba0ccd45c3580d1b5dfdb5dad3fc57ca9567514b860a6662d796afcce007613d664137bdda294720076d3b6e4c76eba18b5e67cccfa9cf8f8f8b2b232e2d8d2b5b6e1c12054001d760fc8c728de262a800aa002a8002af0002a00c00ebe3a02b0037b1defbdda583f754b43d289dc4b37b24e5a8a3e48a9edbf3eebb53d05238f96455c2c9b72a5e8df21cbfa0f99f5c288a5ef45ee89de5a1793d01cb3bd0942c4764902b03b63e0770f09c0ee9040f4e46daa41dc1901de2589c84fd895fa4217a16549be99ef0edbc07a6838c86e0b804c6ee3fa2a2ac2280c42ae2bcc935036b22d902c7275312426c8eff22db5cda83b92809dd4ddcbbbdb902f4f40544014539c9b7383cb09ab1570a715c558d5b7495d5db95977fa00915434141e25fd02a0e62cea491e90eed3a10e0ad3505e18da4786471e40058ee7389e0d37bd39cdfcde4cf3e0d9fac0ee9599e6176658064eb30c88b13c156dee176eea3bbefe89a1978e9db313c5b4837c38d732788ef9fd39e677e79807cd36bf31db2c0f027f0e9841a6ac6d8080419246c5244f5a9012b934355ac9844d8d5a9616b524356251dae4f9e961b3e4bf266923c253874fdaf561d88a4113602604d881cf0eb26211d83d387f735d02bbfa9ad2f292fc92c2acab97cf5f29387739f744fe85231e815d61617ddcaafc7dfbcab76f2f58b932eba9a756438c18be7e7fca29fd12b1ba7c4d3f2389b2ceb94959eab6c0ce60306c39d13a67e795c92bcf46ae3a17b32e7beef6c2989898850b176edcb8f1e4c993cdcdcd4106ec54755a05a78a5e95559d4ab2b2678f6c78d34b77d9bb603f88c0eec1f924c53b4505500154001540051e340508b08305ec78f38840eb62b637ee3b9d778dcbcfba7e36c57875497de67ad3f9ad75e5ab8a4aa2d24a1e7b7a52d4968ae97b0cd37689c1333b1240ee52ec3cb03b67e4b78f08c0ee088ff3b4db24f9513c2b20bf98ed96a3f5ce8de2b6d24b68d9969c42dab80ee1727c5cb32f96aea87715ed08c6e46b6232e6d173f2fc6132374b2e59d457140e0a21de233f67a5d9e2733c8214a64ac6a46fc7abbbdb788992451053c90b26f7c587ee8445911505dccba5684edf26b9417edad44c5c5c8edcbb12c28dbb9c333d203555f93540bf72c820cafd7a7af45edd290ed2bd15389eeb7c3adcfc6a8c79d00cf37b2e80ddcbb32d2fccb20c9c61e91f6b7932daf29f70d313e31b1e1f7ae9f8393b79237b3308fd27801984f83d6190a491539227ce4d8958941ab5b42aa710baa4452f4b8d5e9a1ab5382d62615af8bcf449b3d2274e87e3d567b3d3474c4e1d3671f7e0092bde1a0f33895ac2033b08b03623b07b70fee0ba0476977333cf1d4f3a7570e7');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 11, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 12, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 13, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 14, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 15, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 16, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 17, NULL, '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');
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 18, NULL, '5d8e3c756c1762dc31c221ec123f0550200880000880408e0840d8e5a8b3505510000110000110c80b81ac083bce4b634a2c8f9773e2d5f168c10a8f97978cb0e365f1a9b5d076314f845061a778fc9c61c798777305b2dd32bc70ea6cc391598e8fb670ad26f2d3168ad733451b4934553954ac28caf9f0bb51a75af91d190c79c72b63966c6e21035873ea70a3aab36bfc9fa3a7e3ec9cc2ce13016a8c4373147a86b71d62cadf9919bc91a7e616fabc965e75c6f0769e85107631073a76030110000110a80802107615d18d680408800008800008648b40ee841d7fee9c6bd109d54c556f3c9d6b8bec32cc4e514d89951e8ad720ed62cfbdf51ca8d6148a453c122c5b83a40cb5d116764caeb197addb2c616747b7793f257136f8bc5ba44527b85093ff75c5ee891050ef8184c87ba973d4a952249d5c01b63b93773cc3a8530d5dc83522fdeb3f5536d4d939849d8eb9963bd35273a67ef38b3cb5fc1c9be2cda49da1f69c2e1ac2ae0c27090e090220000220901902107699e90a5404044000044000042a8740b6849dcc3540013826b3dacfaeb366b652293a536279362162b87793b6f08279a41c4516052c3ac176b40f6a2f5be19dbc5b390327e596840a3bc79458af6893e3e9141a2e8ab00b298afb413eb3d50a97f3137fc644dd9a5b783663975b789c5d500a767621c24e0e485508642edeac703921ec5431acb5753c9bb18be7e98c1076299f10281e044000044020d30420ec32dd3da81c08800008800008e4934026841ddded2b533e91a2d609100815768e452794c2ce9a6a6ae694578a704c8095a6ac2aa7c44a3b2a8ab25c1b9fe56a2e566b4f80f54cad7d747acd0f06f36c378d1c4ebbb89fc4a79277dcd951f22e43a13125d6d26faa884f3ecbd5cc614f89f5cce56e9841c6da72da6c5eac6b5a3a845d02831e45800008800008e49600845d6ebb0e150701100001100081ec1228bfb0cb2e1bd4ac7c0442859d21bc068bf848a6c09c8bb7d273e5f8eb3be4d1f83c56919b3f5a4eceef527e52668a805314e5