/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.util;

import org.pentaho.reporting.designer.extensions.pentaho.repository.Messages;

public class PublishException
extends Exception {
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_FILE_EXISTS = 1;
    public static final int ERROR_FAILED = 2;
    public static final int ERROR_SUCCESSFUL = 3;
    public static final int ERROR_INVALID_PASSWORD = 4;
    public static final int ERROR_INVALID_USERNAME_OR_PASSWORD = 5;
    private int errorCode;
    private int httpReason;

    public PublishException(int errorCode) {
        super(PublishException.translateReturnValue(errorCode));
        this.errorCode = errorCode;
    }

    public PublishException(int errorCode, int httpReason) {
        super(PublishException.translateReturnValue(errorCode) + ": " + httpReason);
        this.errorCode = errorCode;
        this.httpReason = httpReason;
    }

    public PublishException(int errorCode, Throwable cause) {
        super(PublishException.translateReturnValue(errorCode), cause);
        this.errorCode = errorCode;
    }

    public int getHttpReason() {
        return this.httpReason;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private static String translateReturnValue(int errorCode) {
        switch (errorCode) {
            case 0: {
                return Messages.getInstance().getString("PublishToServerAction.Successful");
            }
            case 1: {
                return Messages.getInstance().getString("PublishToServerAction.FileExistsError");
            }
            case 2: {
                return Messages.getInstance().getString("PublishToServerAction.Failed");
            }
            case 3: {
                return Messages.getInstance().getString("PublishToServerAction.Successful");
            }
            case 4: {
                return Messages.getInstance().getString("PublishToServerAction.InvalidPassword");
            }
            case 5: {
                return Messages.getInstance().getString("PublishToServerAction.InvalidUsernameOrPassword");
            }
        }
        return Messages.getInstance().getString("PublishToServerAction.Successful");
    }
}

