/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.reporting.designer.extensions.pentaho.repository.model.RepositoryTableModel;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.RepositoryEntryCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.GenericCellRenderer;

public class RepositoryTable
extends JTable {
    private RepositoryTableModel repositoryTableModel = new RepositoryTableModel();
    private FileObject selectedPath;

    public RepositoryTable() {
        this.setAutoCreateRowSorter(true);
        this.setAutoResizeMode(3);
        this.setSelectionMode(0);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setModel(this.repositoryTableModel);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setDefaultRenderer(String.class, new RepositoryEntryCellRenderer());
        this.setDefaultRenderer(Date.class, new DateCellRenderer());
        this.setDefaultRenderer(Object.class, (TableCellRenderer)new GenericCellRenderer());
    }

    public boolean isShowHiddenFiles() {
        return this.repositoryTableModel.isShowHiddenFiles();
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.repositoryTableModel.setShowHiddenFiles(showHiddenFiles);
    }

    public String[] getFilters() {
        return this.repositoryTableModel.getFilters();
    }

    public void setFilters(String[] filters) {
        this.repositoryTableModel.setFilters(filters);
    }

    public FileObject getSelectedPath() {
        return this.selectedPath;
    }

    public void setSelectedPath(FileObject selectedPath) {
        FileObject oldSelectedPath = this.selectedPath;
        this.selectedPath = selectedPath;
        this.repositoryTableModel.setSelectedPath(selectedPath);
        this.firePropertyChange("selectedPath", oldSelectedPath, selectedPath);
    }

    public FileObject getSelectedFileObject(int rowIndex) {
        return this.repositoryTableModel.getElementForRow(rowIndex);
    }

    public void refresh() {
        this.repositoryTableModel.fireTableDataChanged();
    }

    private class DateCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!(value instanceof Date)) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            Date date = (Date)value;
            return super.getTableCellRendererComponent(table, DateFormat.getDateTimeInstance().format(date), isSelected, hasFocus, row, column);
        }
    }
}

