/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.extensions.pentaho.repository.Messages;
import org.pentaho.reporting.designer.extensions.pentaho.repository.dialogs.RepositoryTable;
import org.pentaho.reporting.designer.extensions.pentaho.repository.dialogs.RepositoryTreeDialog;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishUtil;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.event.DocumentChangeHandler;
import org.pentaho.reporting.libraries.pensol.WebSolutionFileObject;
import org.pentaho.reporting.libraries.pensol.vfs.WebSolutionFileSystem;

public class RepositoryOpenDialog
extends CommonDialog {
    private static final String[] REPORT_FILTER = new String[]{".prpt", ".report", ".prpti"};
    private static final Log logger = LogFactory.getLog(RepositoryOpenDialog.class);
    private RepositoryTable table;
    private JTextField fileNameTextField;
    private JComboBox locationCombo;
    private FileObject fileSystemRoot;
    private FileObject selectedView;

    public RepositoryOpenDialog() {
        this.init();
    }

    public RepositoryOpenDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public RepositoryOpenDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public void init() {
        this.locationCombo = new JComboBox();
        this.locationCombo.setRenderer(new FileObjectRenderer());
        this.locationCombo.addActionListener(new SelectLocationAction());
        this.fileNameTextField = new JTextField();
        this.fileNameTextField.getDocument().addDocumentListener((DocumentListener)((Object)new FileNameValidator()));
        this.table = new RepositoryTable();
        this.table.setFilters(REPORT_FILTER);
        this.table.addKeyListener(new TableInputHandler());
        this.table.addMouseListener(new TableInputHandler());
        this.table.getSelectionModel().addListSelectionListener(new TableInputHandler());
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Pentaho.RepositoryOpen";
    }

    public String[] getFilters() {
        return this.table.getFilters();
    }

    public void setFilters(String[] filters) {
        this.table.setFilters(filters);
    }

    protected FileObject getSelectedView() {
        return this.selectedView;
    }

    public void setSelectedView(FileObject selectedView) {
        this.selectedView = selectedView;
        if (selectedView != null) {
            logger.debug((Object)("Setting selected view to " + selectedView));
            try {
                if (selectedView.getType() == FileType.FILE) {
                    logger.debug((Object)("Setting filename in selected view to " + selectedView.getName().getBaseName()));
                    this.fileNameTextField.setText(URLDecoder.decode(selectedView.getName().getBaseName(), "UTF-8"));
                }
            }
            catch (Exception e) {
                logger.debug((Object)"Unable to determine file type. This is not fatal.", (Throwable)e);
            }
            ComboBoxModel comboBoxModel = this.createLocationModel(selectedView);
            this.locationCombo.setModel(comboBoxModel);
            this.table.setSelectedPath((FileObject)comboBoxModel.getSelectedItem());
        } else {
            this.fileNameTextField.setText(null);
            this.table.setSelectedPath(null);
            this.locationCombo.setModel(new DefaultComboBoxModel());
        }
    }

    private ComboBoxModel createLocationModel(FileObject selectedFolder) {
        if (this.fileSystemRoot == null) {
            return new DefaultComboBoxModel();
        }
        try {
            ArrayList<FileObject> list = new ArrayList<FileObject>();
            FileObject folder = selectedFolder;
            while (folder != null && !this.fileSystemRoot.equals(folder)) {
                FileObject parent;
                if (folder.getType() != FileType.FILE) {
                    list.add(folder);
                }
                if (folder.equals(parent = folder.getParent())) break;
                folder = parent;
            }
            list.add(this.fileSystemRoot);
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(list.toArray());
            model.setSelectedItem(list.get(0));
            return model;
        }
        catch (FileSystemException e) {
            return new DefaultComboBoxModel();
        }
    }

    public String performOpen(AuthenticationData loginData, String previousSelection) throws FileSystemException, UnsupportedEncodingException {
        this.fileSystemRoot = PublishUtil.createVFSConnection(VFS.getManager(), loginData);
        if (previousSelection == null) {
            this.setSelectedView(this.fileSystemRoot);
        } else {
            FileObject view = this.fileSystemRoot.resolveFile(previousSelection);
            if (view == null) {
                this.setSelectedView(this.fileSystemRoot);
            } else if (!view.exists()) {
                this.setSelectedView(this.fileSystemRoot);
            } else if (view.getType() == FileType.FOLDER) {
                this.setSelectedView(view);
            } else {
                this.setSelectedView(view.getParent());
            }
        }
        if (StringUtils.isEmpty((String)this.fileNameTextField.getText(), (boolean)true) && previousSelection != null) {
            String fileName = IOUtils.getInstance().getFileName(previousSelection);
            DebugLog.log((Object)("Setting filename to " + fileName));
            this.fileNameTextField.setText(fileName);
        }
        this.getConfirmAction().setEnabled(this.validateInputs(false));
        if (!super.performEdit() || this.selectedView == null) {
            return null;
        }
        return this.getSelectedFile();
    }

    protected String getSelectedFile() throws FileSystemException, UnsupportedEncodingException {
        if (StringUtils.isEmpty((String)this.fileNameTextField.getText())) {
            return null;
        }
        if (this.selectedView.getType() == FileType.FILE) {
            this.selectedView = this.selectedView.getParent();
        }
        FileObject targetFile = this.selectedView.resolveFile(this.fileNameTextField.getText().replaceAll("\\%", "%25").replaceAll("\\!", "%21").replaceAll(":", "%3A"));
        return targetFile.getName().getPathDecoded();
    }

    protected RepositoryTable getTable() {
        return this.table;
    }

    protected JTextField getFileNameTextField() {
        return this.fileNameTextField;
    }

    protected JComboBox getLocationCombo() {
        return this.locationCombo;
    }

    protected Component createContentPane() {
        JPanel centerCarrier = new JPanel();
        centerCarrier.setLayout(new BorderLayout());
        centerCarrier.setBorder(new EmptyBorder(5, 5, 5, 5));
        centerCarrier.add((Component)new JScrollPane(this.table), "Center");
        centerCarrier.add((Component)new JCheckBox(new ShowHiddenFilesAction()), "South");
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)centerCarrier, "Center");
        contentPanel.add((Component)this.createHeaderPanel(), "North");
        return contentPanel;
    }

    protected boolean isCreateFolderAllowed() {
        return false;
    }

    protected boolean isDoubleClickConfirmsDialog() {
        return true;
    }

    protected JPanel createHeaderPanel() {
        JPanel publishHeaderPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        publishHeaderPanel.add((Component)new JLabel(Messages.getInstance().getString("RepositoryPublishDialog.ReportName")), c);
        c.gridy = 1;
        c.insets = new Insets(2, 5, 0, 5);
        publishHeaderPanel.add((Component)this.fileNameTextField, c);
        c.gridy = 4;
        c.fill = 2;
        c.insets = new Insets(2, 5, 0, 5);
        publishHeaderPanel.add((Component)new JLabel(Messages.getInstance().getString("RepositoryPublishDialog.Location")), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        publishHeaderPanel.add((Component)this.createLocationFieldPanel(), c);
        return publishHeaderPanel;
    }

    protected JPanel createLocationFieldPanel() {
        GridBagConstraints c = new GridBagConstraints();
        JPanel locationFieldPanel = new JPanel();
        locationFieldPanel.setLayout(new GridBagLayout());
        c.insets = new Insets(0, 5, 5, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        locationFieldPanel.add((Component)this.locationCombo, c);
        c.insets = new Insets(5, 8, 5, 0);
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 17;
        locationFieldPanel.add((Component)new BorderlessButton((Action)new LevelUpAction()), c);
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 13;
        locationFieldPanel.add((Component)new BorderlessButton((Action)new BrowseRepositoryAction()), c);
        return locationFieldPanel;
    }

    protected boolean validateInputs(boolean onConfirm) {
        return !StringUtils.isEmpty((String)this.fileNameTextField.getText());
    }

    public void refresh() throws IOException {
        WebSolutionFileSystem fileSystem = (WebSolutionFileSystem)this.fileSystemRoot.getFileSystem();
        fileSystem.getLocalFileModel().refresh();
        this.table.refresh();
    }

    private class ShowHiddenFilesAction
    extends AbstractAction {
        private ShowHiddenFilesAction() {
            this.putValue("Name", Messages.getInstance().getString("ShowHiddenFilesAction.Name"));
            this.setSelected(Boolean.FALSE);
        }

        private Boolean getSelected() {
            return (Boolean)this.getValue("SwingSelectedKey");
        }

        private void setSelected(Boolean selected) {
            this.putValue("SwingSelectedKey", selected);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RepositoryOpenDialog.this.table.setShowHiddenFiles(Boolean.TRUE.equals(this.getSelected()));
        }
    }

    private class SelectLocationAction
    implements ActionListener {
        private SelectLocationAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileObject selectedItem;
            if (RepositoryOpenDialog.this.locationCombo.getSelectedItem() instanceof FileObject && !(selectedItem = (FileObject)RepositoryOpenDialog.this.locationCombo.getSelectedItem()).equals(RepositoryOpenDialog.this.getSelectedView())) {
                RepositoryOpenDialog.this.setSelectedView(selectedItem);
            }
        }
    }

    private class FileNameValidator
    extends DocumentChangeHandler {
        private FileNameValidator() {
        }

        protected void handleChange(DocumentEvent e) {
            RepositoryOpenDialog.this.getConfirmAction().setEnabled(RepositoryOpenDialog.this.validateInputs(false));
        }
    }

    private static class FileObjectRenderer
    extends DefaultListCellRenderer {
        private FileObjectRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof WebSolutionFileObject) {
                WebSolutionFileObject fo = (WebSolutionFileObject)value;
                FileName fileName = fo.getName();
                try {
                    return super.getListCellRendererComponent((JList<?>)list, fileName.getPathDecoded(), index, isSelected, cellHasFocus);
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private class TableInputHandler
    extends MouseAdapter
    implements KeyListener,
    ListSelectionListener {
        private TableInputHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                int selectedRowRaw = RepositoryOpenDialog.this.table.getSelectedRow();
                if (selectedRowRaw == -1) {
                    return;
                }
                int selectedRow = RepositoryOpenDialog.this.table.convertRowIndexToModel(selectedRowRaw);
                FileObject selectedFileObject = RepositoryOpenDialog.this.table.getSelectedFileObject(selectedRow);
                if (selectedFileObject == null) {
                    return;
                }
                try {
                    if (FileType.FOLDER.equals((Object)selectedFileObject.getType())) {
                        RepositoryOpenDialog.this.setSelectedView(selectedFileObject);
                    }
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            if (e.getClickCount() < 2) {
                return;
            }
            int selectedRowRaw = RepositoryOpenDialog.this.table.getSelectedRow();
            if (selectedRowRaw == -1) {
                return;
            }
            int selectedRow = RepositoryOpenDialog.this.table.convertRowIndexToModel(selectedRowRaw);
            FileObject selectedFileObject = RepositoryOpenDialog.this.table.getSelectedFileObject(selectedRow);
            if (selectedFileObject == null) {
                return;
            }
            try {
                if (FileType.FOLDER.equals((Object)selectedFileObject.getType())) {
                    RepositoryOpenDialog.this.setSelectedView(selectedFileObject);
                } else if (FileType.FILE.equals((Object)selectedFileObject.getType())) {
                    if (!RepositoryOpenDialog.this.isDoubleClickConfirmsDialog()) {
                        return;
                    }
                    RepositoryOpenDialog.this.setConfirmed(true);
                    RepositoryOpenDialog.this.setVisible(false);
                }
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRowRaw = RepositoryOpenDialog.this.table.getSelectedRow();
            if (selectedRowRaw == -1) {
                return;
            }
            int selectedRow = RepositoryOpenDialog.this.table.convertRowIndexToModel(selectedRowRaw);
            FileObject selectedFileObject = RepositoryOpenDialog.this.table.getSelectedFileObject(selectedRow);
            if (selectedFileObject == null) {
                return;
            }
            try {
                if (selectedFileObject.getType() == FileType.FILE) {
                    RepositoryOpenDialog.this.fileNameTextField.setText(URLDecoder.decode(selectedFileObject.getName().getBaseName().replaceAll("\\+", "%2B"), "UTF-8"));
                }
            }
            catch (FileSystemException fileSystemException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    protected class BrowseRepositoryAction
    extends AbstractAction {
        public BrowseRepositoryAction() {
            this.putValue("ShortDescription", Messages.getInstance().getString("RepositoryPublishDialog.BrowseRepositoryAction.Description"));
            URL location = RepositoryOpenDialog.class.getResource("/org/pentaho/reporting/designer/extensions/pentaho/repository/resources/exploreSolution.png");
            if (location != null) {
                this.putValue("SmallIcon", new ImageIcon(location));
            } else {
                this.putValue("Name", Messages.getInstance().getString("RepositoryPublishDialog.BrowseRepositoryAction.Name"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RepositoryOpenDialog.this.fileSystemRoot == null) {
                return;
            }
            RepositoryTreeDialog treeDialog = new RepositoryTreeDialog((JDialog)((Object)RepositoryOpenDialog.this), RepositoryOpenDialog.this.isCreateFolderAllowed());
            try {
                FileObject newLocation = treeDialog.performSelectLocation(RepositoryOpenDialog.this.fileSystemRoot, RepositoryOpenDialog.this.getFilters(), RepositoryOpenDialog.this.selectedView);
                if (newLocation != null) {
                    RepositoryOpenDialog.this.setSelectedView(newLocation);
                }
                if (treeDialog.isDirty()) {
                    RepositoryOpenDialog.this.table.refresh();
                }
            }
            catch (FileSystemException e1) {
                UncaughtExceptionsModel.getInstance().addException((Throwable)e1);
            }
        }
    }

    protected class LevelUpAction
    extends AbstractAction {
        public LevelUpAction() {
            this.putValue("ShortDescription", Messages.getInstance().getString("RepositoryPublishDialog.LevelUpAction.Description"));
            URL location = RepositoryOpenDialog.class.getResource("/org/pentaho/reporting/designer/extensions/pentaho/repository/resources/upOneFolder.png");
            if (location != null) {
                this.putValue("SmallIcon", new ImageIcon(location));
            } else {
                this.putValue("Name", Messages.getInstance().getString("RepositoryPublishDialog.LevelUpAction.Name"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RepositoryOpenDialog.this.fileSystemRoot == null) {
                return;
            }
            if (RepositoryOpenDialog.this.fileSystemRoot.equals(RepositoryOpenDialog.this.selectedView)) {
                return;
            }
            try {
                RepositoryOpenDialog.this.setSelectedView(RepositoryOpenDialog.this.selectedView.getParent());
            }
            catch (FileSystemException e1) {
                UncaughtExceptionsModel.getInstance().addException((Throwable)e1);
            }
        }
    }
}

