/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.actions;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.AuthenticatedServerTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishException;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishUtil;
import org.pentaho.reporting.engine.classic.core.util.HttpClientManager;
import org.pentaho.reporting.engine.classic.core.util.HttpClientUtil;

public class UpdateReservedCharsTask
implements AuthenticatedServerTask {
    private AuthenticationData loginData;

    public UpdateReservedCharsTask(AuthenticationData loginData) {
        this.loginData = loginData;
    }

    @Override
    public void setLoginData(AuthenticationData loginData, boolean storeUpdates) {
        this.loginData = loginData;
    }

    private HttpClient createHttpClient() {
        HttpClientManager.HttpClientBuilderFacade clientBuilder = HttpClientManager.getInstance().createBuilder();
        CloseableHttpClient client = clientBuilder.setSocketTimeout(WorkspaceSettings.getInstance().getConnectionTimeout() * 1000).setCredentials(this.loginData.getUsername(), this.loginData.getPassword()).setCookieSpec("default").build();
        return client;
    }

    private boolean checkResult(int result) throws PublishException {
        return result == 200;
    }

    @Override
    public void run() {
        int result;
        HttpResponse httpResponse;
        HttpClient client = this.createHttpClient();
        HttpGet reservedCharactersMethod = new HttpGet(this.loginData.getUrl() + "/api/repo/files/reservedCharacters");
        HttpGet reservedCharactersDisplayMethod = new HttpGet(this.loginData.getUrl() + "/api/repo/files/reservedCharactersDisplay");
        try {
            httpResponse = client.execute((HttpUriRequest)reservedCharactersMethod);
            result = httpResponse.getStatusLine().getStatusCode();
            if (!this.checkResult(result)) {
                throw new PublishException(1);
            }
            PublishUtil.setReservedChars(HttpClientUtil.responseToString((HttpResponse)httpResponse));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            httpResponse = client.execute((HttpUriRequest)reservedCharactersDisplayMethod);
            result = httpResponse.getStatusLine().getStatusCode();
            if (!this.checkResult(result)) {
                throw new PublishException(1);
            }
            PublishUtil.setReservedCharsDisplay(HttpClientUtil.responseToString((HttpResponse)httpResponse));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

