/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.auth.AuthenticationStore;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.extensions.pentaho.repository.Messages;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.AuthenticatedServerTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.UpdateReservedCharsTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.ValidateLoginTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.dialogs.RepositoryLoginDialog;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishSettings;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.background.BackgroundCancellableProcessHelper;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelListener;
import org.pentaho.reporting.libraries.designtime.swing.background.GenericCancelHandler;

public class LoginTask
implements Runnable {
    private final ReportDesignerContext designerContext;
    private final Component uiContext;
    private final AuthenticatedServerTask followUpTask;
    private final boolean loginForPublish;
    private boolean skipFirstShowDialog;
    private RepositoryLoginDialog loginDialog;
    private AuthenticationData loginData;

    public LoginTask(ReportDesignerContext designerContext, Component uiContext, AuthenticatedServerTask followUpTask) {
        this(designerContext, uiContext, followUpTask, null, false);
    }

    public LoginTask(ReportDesignerContext designerContext, Component uiContext, AuthenticatedServerTask followUpTask, AuthenticationData loginData) {
        this(designerContext, uiContext, followUpTask, loginData, false);
    }

    public LoginTask(ReportDesignerContext designerContext, Component uiContext, AuthenticatedServerTask followUpTask, AuthenticationData loginData, boolean loginForPublish) {
        if (designerContext == null) {
            throw new NullPointerException();
        }
        if (uiContext == null) {
            throw new NullPointerException();
        }
        this.loginForPublish = loginForPublish;
        this.designerContext = designerContext;
        this.uiContext = uiContext;
        this.followUpTask = followUpTask;
        if (loginData != null) {
            this.loginData = loginData;
            this.skipFirstShowDialog = true;
        } else {
            Object o;
            ReportDocumentContext reportRenderContext = designerContext.getActiveContext();
            if (reportRenderContext != null && (o = reportRenderContext.getProperties().get("pentaho-login-url")) != null) {
                this.loginData = RepositoryLoginDialog.getStoredLoginData(String.valueOf(o), designerContext);
            }
            if (this.loginData == null) {
                this.loginData = RepositoryLoginDialog.getDefaultData(designerContext);
            }
            this.skipFirstShowDialog = false;
        }
    }

    @Override
    public void run() {
        boolean loginComplete;
        do {
            if (this.loginDialog == null) {
                Window window = LibSwingUtil.getWindowAncestor((Component)this.uiContext);
                this.loginDialog = window instanceof Frame ? new RepositoryLoginDialog((Frame)window, this.loginForPublish) : (window instanceof Dialog ? new RepositoryLoginDialog((Dialog)window, this.loginForPublish) : new RepositoryLoginDialog(this.loginForPublish));
            }
            if (this.skipFirstShowDialog) {
                this.skipFirstShowDialog = false;
            } else {
                this.loginData = this.loginDialog.performLogin(this.designerContext, this.loginData);
                if (this.loginData == null) {
                    return;
                }
            }
            ValidateLoginTask validateLoginTask = new ValidateLoginTask(this);
            Thread loginThread = new Thread(validateLoginTask);
            loginThread.setDaemon(true);
            loginThread.setPriority(1);
            GenericCancelHandler cancelHandler = new GenericCancelHandler(loginThread);
            BackgroundCancellableProcessHelper.executeProcessWithCancelDialog((Thread)loginThread, (CancelListener)cancelHandler, (Component)this.uiContext, (String)Messages.getInstance().getString("LoginTask.ValidateLoginMessage"));
            if (cancelHandler.isCancelled()) {
                return;
            }
            if (validateLoginTask.getException() != null) {
                Exception exception = validateLoginTask.getException();
                ExceptionDialog.showExceptionDialog((Component)this.uiContext, (String)Messages.getInstance().getString("LoadReportFromRepositoryAction.LoginError.Title"), (String)Messages.getInstance().formatMessage("LoadReportFromRepositoryAction.LoginError.Message", exception.getMessage()), (Exception)exception);
                loginComplete = false;
                continue;
            }
            loginComplete = validateLoginTask.isLoginComplete();
        } while (!loginComplete);
        if (this.loginDialog != null && this.loginDialog.isRememberSettings()) {
            ReportDocumentContext reportRenderContext = this.designerContext.getActiveContext();
            if (reportRenderContext != null) {
                AuthenticationStore store = reportRenderContext.getAuthenticationStore();
                store.add(this.loginData, true);
            } else {
                this.designerContext.getGlobalAuthenticationStore().add(this.loginData, true);
            }
        }
        boolean storeUpdates = this.loginDialog == null ? PublishSettings.getInstance().isRememberSettings() : this.loginDialog.isRememberSettings();
        if (this.followUpTask != null) {
            this.followUpTask.setLoginData(this.loginData, storeUpdates);
            SwingUtilities.invokeLater(this.followUpTask);
        }
        UpdateReservedCharsTask updateReservedCharsTask = new UpdateReservedCharsTask(this.loginData);
        SwingUtilities.invokeLater(updateReservedCharsTask);
    }

    public AuthenticationData getLoginData() {
        return this.loginData;
    }
}

