/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.drilldown.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.ObjectUtils;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.auth.AuthenticationStore;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterRefreshEvent;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterRefreshListener;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterTable;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.DrillDownModelWrapper;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownParameter;
import org.pentaho.reporting.designer.core.editor.drilldown.swing.DocumentBindingListener;
import org.pentaho.reporting.designer.extensions.pentaho.drilldown.PentahoParameterRefreshHandler;
import org.pentaho.reporting.designer.extensions.pentaho.drilldown.PentahoPathModel;
import org.pentaho.reporting.designer.extensions.pentaho.drilldown.SelectDrillTargetTask;
import org.pentaho.reporting.designer.extensions.pentaho.drilldown.swing.SwingRemoteDrillDownUi;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.AuthenticatedServerTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.LoginTask;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfile;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfileMetaData;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class SwingRemoteDrillDownController {
    private final SwingRemoteDrillDownUi drillDownUi;
    private final DrillDownModelWrapper modelWrapper;
    private final ReportDesignerContext reportDesignerContext;
    private final PentahoPathModel pentahoPathWrapper;
    private ModelWrapperUpdateHandler modelWrapperUpdateHandler;
    private PathWrapperUpdateHandler pathWrapperUpdateHandler;

    public SwingRemoteDrillDownController(SwingRemoteDrillDownUi drillDownUi, ReportDesignerContext reportDesignerContext, DrillDownModelWrapper modelWrapper) {
        this.drillDownUi = drillDownUi;
        this.reportDesignerContext = reportDesignerContext;
        this.modelWrapper = modelWrapper;
        this.pentahoPathWrapper = new PentahoPathModel(reportDesignerContext);
    }

    public void init() {
        this.modelWrapperUpdateHandler = new ModelWrapperUpdateHandler();
        this.pathWrapperUpdateHandler = new PathWrapperUpdateHandler();
        this.modelWrapper.addPropertyChangeListener((PropertyChangeListener)this.modelWrapperUpdateHandler);
        this.pentahoPathWrapper.addPropertyChangeListener(this.pathWrapperUpdateHandler);
        this.initExtensionsMap(this.pentahoPathWrapper);
        final JCheckBox includeServerUrl = (JCheckBox)this.drillDownUi.getComponent(SwingRemoteDrillDownUi.ComponentLookup.SERVER_URL_CHECKBOX);
        includeServerUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingRemoteDrillDownController.this.pentahoPathWrapper.setUseRemoteServer(includeServerUrl.isSelected());
            }
        });
        JTextField serverUrlField = (JTextField)this.drillDownUi.getComponent(SwingRemoteDrillDownUi.ComponentLookup.SERVER_URL_FIELD);
        serverUrlField.getDocument().addDocumentListener((DocumentListener)new DocumentBindingListener(){

            protected void setData(String data) {
                SwingRemoteDrillDownController.this.pentahoPathWrapper.setServerPath(data);
            }
        });
        JButton loginButton = (JButton)this.drillDownUi.getComponent(SwingRemoteDrillDownUi.ComponentLookup.LOGIN_BUTTON);
        loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginTask loginTask = new LoginTask(SwingRemoteDrillDownController.this.reportDesignerContext, SwingRemoteDrillDownController.this.drillDownUi.getEditorPanel().getParent(), new LoginCompleteTask(null));
                SwingUtilities.invokeLater(loginTask);
            }
        });
        JTextField pathField = (JTextField)this.drillDownUi.getComponent(SwingRemoteDrillDownUi.ComponentLookup.PATH_FIELD);
        pathField.getDocument().addDocumentListener((DocumentListener)new DocumentBindingListener(){

            protected void setData(String data) {
                if (data == null || data.isEmpty()) {
                    return;
                }
                DrillDownParameter parameterPath = new DrillDownParameter("::pentaho-path", new String("\"" + data + "\""));
                DrillDownParameter[] currentParams = SwingRemoteDrillDownController.this.modelWrapper.getDrillDownParameter();
                ArrayList<DrillDownParameter> currentParamsList = new ArrayList<DrillDownParameter>(Arrays.asList(currentParams));
                Optional<DrillDownParameter> lookupItem = currentParamsList.stream().filter(a -> a.getName().equals("::pentaho-path")).findFirst();
                if (lookupItem.isPresent()) {
                    lookupItem.get().setFormulaFragment(new String("\"" + data + "\""));
                } else {
                    currentParamsList.add(parameterPath);
                }
                DrillDownParameter[] result = currentParamsList.toArray(new DrillDownParameter[currentParamsList.size()]);
                ((DrillDownParameterTable)SwingRemoteDrillDownController.this.drillDownUi.getComponent(SwingRemoteDrillDownUi.ComponentLookup.PARAMETER_TABLE)).setDrillDownParameter(result);
            }
        });
        JButton browseButton = (JButton)this.drillDownUi.getComponent(SwingRemoteDrillDownUi.ComponentLookup.BROWSE_BUTTON);
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path;
                ReportDocumentContext activeContext = SwingRemoteDrillDownController.this.reportDesignerContext.getActiveContext();
                if (SwingRemoteDrillDownController.this.pentahoPathWrapper.getLoginData() == null && (path = SwingRemoteDrillDownController.this.modelWrapper.getDrillDownPath()) != null) {
                    AuthenticationStore authStore = activeContext.getAuthenticationStore();
                    String username = authStore.getUsername(path);
                    String password = authStore.getPassword(path);
                    int timeout = authStore.getIntOption(path, "timeout", 0);
                    SwingRemoteDrillDownController.this.pentahoPathWrapper.setLoginData(new AuthenticationData(path, username, password, timeout));
                }
                LoginTask loginTask = new LoginTask(SwingRemoteDrillDownController.this.reportDesignerContext, SwingRemoteDrillDownController.this.drillDownUi.getEditorPanel().getParent(), new LoginCompleteTask(new SelectDrillTargetTask(SwingRemoteDrillDownController.this.pentahoPathWrapper, SwingRemoteDrillDownController.this.drillDownUi.getEditorPanel().getParent(), new RefreshParameterTask(), activeContext)), SwingRemoteDrillDownController.this.pentahoPathWrapper.getLoginData());
                SwingUtilities.invokeLater(loginTask);
            }
        });
        DrillDownParameterTable table = (DrillDownParameterTable)this.drillDownUi.getComponent(SwingRemoteDrillDownUi.ComponentLookup.PARAMETER_TABLE);
        table.addDrillDownParameterRefreshListener((DrillDownParameterRefreshListener)new UpdateParametersHandler());
        table.addPropertyChangeListener("drillDownParameter", (PropertyChangeListener)new TableModelBinding());
        PentahoParameterRefreshHandler parameterRefreshHandler = new PentahoParameterRefreshHandler(this.pentahoPathWrapper, this.reportDesignerContext, this.drillDownUi.getEditorPanel());
        table.addDrillDownParameterRefreshListener((DrillDownParameterRefreshListener)parameterRefreshHandler);
        parameterRefreshHandler.setParameterTable(table);
        table.setReportDesignerContext(this.reportDesignerContext);
        this.pentahoPathWrapper.addPropertyChangeListener("localPath", new CheckEmptyPathHandler(table));
        SwingUtilities.invokeLater(new RefreshParameterTask());
        this.modelWrapper.setDrillDownParameter(this.modelWrapper.getDrillDownParameter());
        this.pentahoPathWrapper.setLocalPathFromParameter(this.modelWrapper.getDrillDownParameter());
        if (StringUtils.isEmpty((String)this.modelWrapper.getDrillDownPath())) {
            this.pentahoPathWrapper.setUseRemoteServer(false);
            ReportDocumentContext reportRenderContext = this.reportDesignerContext.getActiveContext();
            if (reportRenderContext != null) {
                Object o = reportRenderContext.getProperties().get("pentaho-login-url");
                if (o != null) {
                    this.pentahoPathWrapper.setServerPath(String.valueOf(o));
                } else {
                    this.pentahoPathWrapper.setServerPath(null);
                }
            } else {
                this.pentahoPathWrapper.setServerPath(null);
            }
        } else {
            this.pentahoPathWrapper.setUseRemoteServer(true);
            this.pentahoPathWrapper.setServerPath(this.modelWrapper.getDrillDownPath());
        }
    }

    private void initExtensionsMap(PentahoPathModel pentahoPathWrapper) {
        DrillDownProfile[] drillDownProfileByGroup = DrillDownProfileMetaData.getInstance().getDrillDownProfileByGroup("pentaho-sugar");
        for (int i = 0; i < drillDownProfileByGroup.length; ++i) {
            DrillDownProfile profile = drillDownProfileByGroup[i];
            String profileName = profile.getName();
            String extension = profile.getAttribute("extension");
            boolean noParameter = profileName.endsWith("-no-parameter");
            boolean local = profileName.startsWith("local-");
            if (StringUtils.isEmpty((String)extension)) {
                pentahoPathWrapper.registerExtension(null, local, noParameter, profileName);
                continue;
            }
            pentahoPathWrapper.registerExtension("." + extension, local, noParameter, profileName);
        }
    }

    public void deactivate() {
        this.modelWrapper.removePropertyChangeListener((PropertyChangeListener)this.modelWrapperUpdateHandler);
        this.pentahoPathWrapper.removePropertyChangeListener(this.pathWrapperUpdateHandler);
    }

    protected class RefreshParameterTask
    implements Runnable {
        protected RefreshParameterTask() {
        }

        @Override
        public void run() {
            ((DrillDownParameterTable)SwingRemoteDrillDownController.this.drillDownUi.getComponent(SwingRemoteDrillDownUi.ComponentLookup.PARAMETER_TABLE)).refreshParameterData();
        }
    }

    private class UpdateParametersHandler
    implements DrillDownParameterRefreshListener {
        private UpdateParametersHandler() {
        }

        public void requestParameterRefresh(DrillDownParameterRefreshEvent event) {
            HashMap<String, DrillDownParameter> entries = new HashMap<String, DrillDownParameter>();
            DrillDownParameter[] originalParams = event.getParameter();
            for (int i = 0; i < originalParams.length; ++i) {
                DrillDownParameter param = originalParams[i];
                param.setType(DrillDownParameter.Type.MANUAL);
                entries.put(param.getName(), param);
            }
            ReportDocumentContext activeContext = SwingRemoteDrillDownController.this.reportDesignerContext.getActiveContext();
            MasterReport masterReportElement = (MasterReport)activeContext.getContextRoot();
            ReportParameterDefinition reportParams = masterReportElement.getParameterDefinition();
            ParameterDefinitionEntry[] parameterDefinitionEntries = reportParams.getParameterDefinitions();
            for (int i = 0; i < parameterDefinitionEntries.length; ++i) {
                ParameterDefinitionEntry entry = parameterDefinitionEntries[i];
                if (!entries.containsKey(entry.getName())) {
                    entries.put(entry.getName(), new DrillDownParameter(entry.getName(), null, DrillDownParameter.Type.PREDEFINED, false, false));
                    continue;
                }
                DrillDownParameter parameter = (DrillDownParameter)entries.get(entry.getName());
                parameter.setType(DrillDownParameter.Type.PREDEFINED);
            }
            DrillDownParameter[] parameters = entries.values().toArray(new DrillDownParameter[entries.size()]);
            SwingRemoteDrillDownController.this.modelWrapper.setDrillDownParameter(parameters);
            ((DrillDownParameterTable)SwingRemoteDrillDownController.this.drillDownUi.getComponent(SwingRemoteDrillDownUi.ComponentLookup.PARAMETER_TABLE)).setDrillDownParameter(parameters);
        }
    }

    private class TableModelBinding
    implements PropertyChangeListener {
        private TableModelBinding() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DrillDownParameter[] unfilterParams;
            ArrayList<DrillDownParameter> filterParams = new ArrayList<DrillDownParameter>();
            for (DrillDownParameter param : unfilterParams = ((DrillDownParameterTable)SwingRemoteDrillDownController.this.drillDownUi.getComponent(SwingRemoteDrillDownUi.ComponentLookup.PARAMETER_TABLE)).getDrillDownParameter()) {
                if (param.getType() == DrillDownParameter.Type.SYSTEM && param.getFormulaFragment() != null && !param.getFormulaFragment().equals("NA()")) {
                    filterParams.add(param);
                    continue;
                }
                if (param.getType() == DrillDownParameter.Type.SYSTEM) continue;
                filterParams.add(param);
            }
            SwingRemoteDrillDownController.this.modelWrapper.setDrillDownParameter(filterParams.toArray(new DrillDownParameter[filterParams.size()]));
        }
    }

    private class PathWrapperUpdateHandler
    implements PropertyChangeListener {
        private PathWrapperUpdateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("localPath".equals(evt.getPropertyName())) {
                SwingRemoteDrillDownController.this.modelWrapper.setDrillDownParameter(SwingRemoteDrillDownController.this.modelWrapper.getDrillDownParameter());
                SwingRemoteDrillDownController.this.modelWrapper.setDrillDownConfig(SwingRemoteDrillDownController.this.pentahoPathWrapper.getDrillDownProfile());
            } else if ("useRemoteServer".equals(evt.getPropertyName())) {
                SwingRemoteDrillDownController.this.modelWrapper.setDrillDownConfig(SwingRemoteDrillDownController.this.pentahoPathWrapper.getDrillDownProfile());
                if (!SwingRemoteDrillDownController.this.pentahoPathWrapper.isUseRemoteServer()) {
                    SwingRemoteDrillDownController.this.modelWrapper.setDrillDownPath(null);
                } else {
                    SwingRemoteDrillDownController.this.modelWrapper.setDrillDownPath(SwingRemoteDrillDownController.this.pentahoPathWrapper.getServerPath());
                }
            } else if ("hideParameterUi".equals(evt.getPropertyName())) {
                SwingRemoteDrillDownController.this.modelWrapper.setDrillDownConfig(SwingRemoteDrillDownController.this.pentahoPathWrapper.getDrillDownProfile());
            } else if ("loginData".equals(evt.getPropertyName())) {
                if (!SwingRemoteDrillDownController.this.pentahoPathWrapper.isUseRemoteServer()) {
                    SwingRemoteDrillDownController.this.modelWrapper.setDrillDownPath(null);
                } else {
                    SwingRemoteDrillDownController.this.modelWrapper.setDrillDownPath(SwingRemoteDrillDownController.this.pentahoPathWrapper.getServerPath());
                }
            }
        }
    }

    private class CheckEmptyPathHandler
    implements PropertyChangeListener {
        private DrillDownParameterTable paramTableElement;

        private CheckEmptyPathHandler(DrillDownParameterTable paramTableElement) {
            this.paramTableElement = paramTableElement;
            this.propertyChange(null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (StringUtils.isEmpty((String)SwingRemoteDrillDownController.this.pentahoPathWrapper.getLocalPath())) {
                this.paramTableElement.setEnabled(false);
            } else {
                this.paramTableElement.setEnabled(true);
            }
        }
    }

    private class ModelWrapperUpdateHandler
    implements PropertyChangeListener {
        private ModelWrapperUpdateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AuthenticationData loginData = SwingRemoteDrillDownController.this.pentahoPathWrapper.getLoginData();
            String serverUrl = loginData == null ? "" : loginData.getUrl();
            JTextField serverUrlField = (JTextField)SwingRemoteDrillDownController.this.drillDownUi.getComponent(SwingRemoteDrillDownUi.ComponentLookup.SERVER_URL_FIELD);
            if (!ObjectUtils.equals((Object)serverUrlField.getText(), (Object)serverUrl)) {
                serverUrlField.setText(serverUrl);
            }
            String path = SwingRemoteDrillDownController.this.pentahoPathWrapper.getLocalPath();
            JTextField pathField = (JTextField)SwingRemoteDrillDownController.this.drillDownUi.getComponent(SwingRemoteDrillDownUi.ComponentLookup.PATH_FIELD);
            if (!ObjectUtils.equals((Object)pathField.getText(), (Object)path)) {
                pathField.setText(path);
            }
        }
    }

    private class LoginCompleteTask
    implements AuthenticatedServerTask {
        private AuthenticationData loginData;
        private boolean storeUpdates;
        private AuthenticatedServerTask nextTask;

        private LoginCompleteTask(AuthenticatedServerTask nextTask) {
            this.nextTask = nextTask;
        }

        @Override
        public void setLoginData(AuthenticationData loginData, boolean storeUpdates) {
            this.loginData = loginData;
            this.storeUpdates = storeUpdates;
        }

        @Override
        public void run() {
            SwingRemoteDrillDownController.this.pentahoPathWrapper.setLoginData(this.loginData);
            ReportDocumentContext reportRenderContext = SwingRemoteDrillDownController.this.reportDesignerContext.getActiveContext();
            Object o = reportRenderContext.getProperties().get("pentaho-login-url");
            if (o == null) {
                reportRenderContext.getProperties().put("pentaho-login-url", this.loginData.getUrl());
            }
            if (this.nextTask != null) {
                this.nextTask.setLoginData(this.loginData, this.storeUpdates);
                SwingUtilities.invokeLater(this.nextTask);
            }
        }
    }
}

