/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.orc;

import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.log4j.Logger;
import org.apache.orc.TypeDescription;
import org.pentaho.hadoop.shim.api.format.IOrcOutputField;
import org.pentaho.hadoop.shim.api.format.IPentahoOrcOutputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoOutputFormat;
import org.pentaho.hadoop.shim.common.ConfigurationProxy;
import org.pentaho.hadoop.shim.common.format.HadoopFormatBase;
import org.pentaho.hadoop.shim.common.format.S3NCredentialUtils;
import org.pentaho.hadoop.shim.common.format.orc.OrcSchemaConverter;
import org.pentaho.hadoop.shim.common.format.orc.PentahoOrcRecordWriter;

public class PentahoOrcOutputFormat
extends HadoopFormatBase
implements IPentahoOrcOutputFormat {
    private Job job;
    private TypeDescription schema;
    private String outputFilename;
    private Configuration conf;
    private IPentahoOrcOutputFormat.COMPRESSION compression = IPentahoOrcOutputFormat.COMPRESSION.NONE;
    private int compressSize = 0;
    private int stripeSize = 64;
    private int rowIndexStride = 0;
    private List<? extends IOrcOutputField> fields;
    private static final Logger logger = Logger.getLogger(PentahoOrcOutputFormat.class);

    public PentahoOrcOutputFormat() throws Exception {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.conf = new ConfigurationProxy();
        this.job = Job.getInstance((Configuration)this.conf);
        this.conf.addResource("hive-site.xml");
    }

    public IPentahoOutputFormat.IPentahoRecordWriter createRecordWriter() throws Exception {
        logger.info((Object)"Initializing Orc Writer");
        if (this.fields == null) {
            throw new Exception("Invalid state.  The fields to write are null");
        }
        if (this.outputFilename == null) {
            throw new Exception("Invalid state.  The outputFileName is null");
        }
        OrcSchemaConverter converter = new OrcSchemaConverter();
        this.schema = converter.buildTypeDescription(this.fields);
        return new PentahoOrcRecordWriter(this.fields, this.schema, this.outputFilename, this.conf);
    }

    public void setFields(List<? extends IOrcOutputField> fields) throws Exception {
        this.fields = fields;
    }

    public void setOutputFile(String file, boolean override) throws Exception {
        this.outputFilename = S3NCredentialUtils.scrubFilePathIfNecessary(file);
        S3NCredentialUtils.applyS3CredentialsToHadoopConfigurationIfNecessary(file, this.job.getConfiguration());
        Path outputFile = new Path(this.outputFilename);
        FileSystem fs = FileSystem.get((URI)outputFile.toUri(), (Configuration)this.job.getConfiguration());
        if (fs.exists(outputFile)) {
            if (override) {
                fs.delete(outputFile, true);
            } else {
                throw new FileAlreadyExistsException(file);
            }
        }
    }

    public void setCompression(IPentahoOrcOutputFormat.COMPRESSION compression) {
        this.compression = compression;
        this.conf.set("orc.compress", compression.toString());
        if (compression == IPentahoOrcOutputFormat.COMPRESSION.NONE) {
            this.compressSize = 0;
            this.conf.unset("orc.compress.size");
        } else if (this.compressSize == 0) {
            this.compressSize = 256;
            this.conf.set("orc.compress.size", Integer.toString(256));
        }
    }

    public void setStripeSize(int megabytes) {
        if (this.stripeSize > 0) {
            this.stripeSize = megabytes;
            this.conf.set("orc.stripe.size", Integer.toString(0x100000 * this.stripeSize));
        }
    }

    public void setRowIndexStride(int numRows) {
        if (numRows > 0) {
            this.rowIndexStride = numRows;
            this.conf.set("orc.create.index", "true");
            this.conf.set("orc.row.index.stride", Integer.toString(0x100000 * this.rowIndexStride));
        } else if (numRows == 0) {
            this.rowIndexStride = numRows;
            this.conf.set("orc.create.index", "false");
            this.conf.unset("orc.row.index.stride");
        }
    }

    public void setCompressSize(int kilobytes) {
        if (kilobytes > 0) {
            this.compressSize = kilobytes;
            this.conf.set("orc.compress.size", Integer.toString(1024 * this.compressSize));
        } else if (kilobytes == 0) {
            this.compressSize = kilobytes;
            this.compression = IPentahoOrcOutputFormat.COMPRESSION.NONE;
            this.conf.unset("orc.compress.size");
            this.conf.set("orc.compress", this.compression.toString());
        }
    }
}

