/*
 * Decompiled with CFR 0.152.
 */
package org.apache.connectors.td.options;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import com.teradata.hadoop.db.TeradataConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.commons.io.FileUtils;
import org.apache.connectors.td.TeradataManager;
import org.apache.connectors.td.options.Option;
import org.apache.connectors.td.options.ParameterValidationException;
import org.apache.connectors.td.types.TeradataDataType;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.avro.AvroUtil;
import org.apache.sqoop.orm.AvroSchemaGenerator;
import org.apache.sqoop.orm.ClassWriter;
import org.apache.sqoop.orm.TableClassName;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;

public abstract class Options {
    private Map<String, Option> options = new HashMap<String, Option>();
    private ArrayList<String> columns = new ArrayList();
    private List<Schema.Field> fields = new ArrayList<Schema.Field>();
    private ArrayList<String> schema = new ArrayList();

    protected Options() {
    }

    protected Options add(Option newOption) {
        this.options.put(newOption.getName(), newOption);
        return this;
    }

    public void set(String name, String value) throws ParameterValidationException {
        Option opt = this.options.get(name);
        if (opt == null) {
            throw new ParameterValidationException("No such option named " + name);
        }
        opt.setValue(value);
    }

    public Option get(String name) {
        return this.options.get(name);
    }

    public abstract Collection<String> prepare(Option var1);

    public abstract void mapOptions(Configuration var1, TeradataManager var2) throws Exception;

    public String[] build() {
        ArrayList<String> vals = new ArrayList<String>();
        for (Option opt : this.options.values()) {
            if (!opt.hasValue()) continue;
            vals.addAll(this.prepare(opt));
        }
        String[] values = new String[]{};
        return vals.toArray(values);
    }

    public File createAvroSchemaFile(List<Schema.Field> fields, org.apache.sqoop.SqoopOptions options) {
        TableClassName tableClassName = new TableClassName((SqoopOptions)options);
        String shortClassName = options.getTableName() == null ? "avro" : tableClassName.getShortClassForTable(options.getTableName());
        String avroTableName = options.getTableName() == null ? "QueryResult" : options.getTableName();
        String avroNamespace = tableClassName.getPackageForTable();
        String doc = "Sqoop import of " + avroTableName;
        Schema schemaAvro = Schema.createRecord((String)shortClassName, (String)doc, (String)avroNamespace, (boolean)false);
        schemaAvro.setFields(fields);
        schemaAvro.addProp("tableName", avroTableName);
        File avroSchema = new File(System.getProperty("java.io.tmpdir"), "avro.avsc");
        try {
            FileUtils.writeStringToFile((File)avroSchema, (String)schemaAvro.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return avroSchema;
    }

    public ArrayList<String> getColumns() {
        return this.columns;
    }

    public List<Schema.Field> getFields() {
        return this.fields;
    }

    public ArrayList<String> getSchema() {
        return this.schema;
    }

    public void generateSchemas(TeradataColumnDesc[] descriptors, Configuration conf, org.apache.sqoop.SqoopOptions options, ConnManager connManager, String tableName) throws ParameterValidationException {
        AvroSchemaGenerator generator = new AvroSchemaGenerator((SqoopOptions)options, connManager, tableName);
        for (TeradataColumnDesc desc : descriptors) {
            try {
                this.schema.add(desc.getName() + " " + TeradataDataType.find(desc.getType()).getHiveDataType().toString());
                this.columns.add(desc.getName());
            }
            catch (NullPointerException e) {
                throw new ParameterValidationException("Unsupported data type " + desc.getTypeName() + " [" + desc.getType() + "] for column " + desc.getName());
            }
            if (!TeradataConfiguration.getInputFileFormat((Configuration)conf).equals("avrofile")) continue;
            String cleanedCol = AvroUtil.toAvroIdentifier((String)ClassWriter.toJavaIdentifier((String)desc.getName()));
            int sqlType = desc.getType();
            Schema avroSchema = generator.toAvroSchema(sqlType, desc.getName());
            Schema.Field field = new Schema.Field(cleanedCol, avroSchema, null, (JsonNode)NullNode.getInstance());
            field.addProp("columnName", desc.getName());
            field.addProp("sqlType", Integer.toString(sqlType));
            this.fields.add(field);
        }
    }
}

