/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.management.BackupManager;
import org.firebirdsql.management.FBServiceManager;

public class FBBackupManager
extends FBServiceManager
implements BackupManager {
    private boolean noLimitBackup = false;
    private ArrayList backupPaths = new ArrayList();
    private boolean noLimitRestore = false;
    private ArrayList restorePaths = new ArrayList();
    private boolean verbose;
    private int restoreBufferCount;
    private int restorePageSize;
    private boolean restoreReadOnly;
    private boolean restoreReplace;
    private static final int RESTORE_REPLACE = 4096;
    private static final int RESTORE_CREATE = 8192;

    public FBBackupManager() {
        this.init();
    }

    public FBBackupManager(String gdsType) {
        super(gdsType);
        this.init();
    }

    public FBBackupManager(GDSType gdsType) {
        super(gdsType);
        this.init();
    }

    private void init() {
        this.verbose = false;
        this.restoreBufferCount = -1;
        this.restorePageSize = -1;
        this.restoreReadOnly = false;
        this.restoreReplace = false;
    }

    public void setBackupPath(String backupPath) {
        this.addBackupPath(backupPath, -1);
        this.noLimitBackup = true;
    }

    public void addBackupPath(String path) {
        this.addBackupPath(path, -1);
    }

    public void addBackupPath(String path, int size) {
        if (this.noLimitBackup) {
            throw new IllegalArgumentException("You cannot use setBackupPath(String) and addBackupPath(String, int) methods simultaneously.");
        }
        this.backupPaths.add(new PathSizeStruct(path, size));
    }

    public void clearBackupPaths() {
        this.backupPaths.clear();
        this.noLimitBackup = false;
    }

    public void setDatabase(String database) {
        super.setDatabase(database);
        this.addRestorePath(database, -1);
        this.noLimitRestore = true;
    }

    public void addRestorePath(String path, int size) {
        if (this.noLimitRestore) {
            throw new IllegalArgumentException("You cannot use setDatabase(String) and addRestorePath(String, int) methods simultaneously.");
        }
        this.restorePaths.add(new PathSizeStruct(path, size));
    }

    public void clearRestorePaths() {
        this.restorePaths.clear();
        this.noLimitRestore = false;
    }

    public void backupDatabase() throws SQLException {
        this.backupDatabase(0);
    }

    public void backupMetadata() throws SQLException {
        this.backupDatabase(4);
    }

    public void backupDatabase(int options) throws SQLException {
        this.executeServicesOperation(this.getBackupSRB(options));
    }

    private ServiceRequestBuffer getBackupSRB(int options) throws SQLException {
        ServiceRequestBuffer backupSPB = this.getGds().createServiceRequestBuffer(1);
        backupSPB.addArgument(106, this.getDatabase());
        Iterator iter = this.backupPaths.iterator();
        while (iter.hasNext()) {
            PathSizeStruct pathSize = (PathSizeStruct)iter.next();
            backupSPB.addArgument(5, pathSize.getPath());
            if (iter.hasNext() && pathSize.getSize() == -1) {
                throw new FBSQLException("No size specified for a backup file " + pathSize.getPath());
            }
            if (!iter.hasNext()) continue;
            backupSPB.addArgument(7, pathSize.size);
        }
        if (this.verbose) {
            backupSPB.addArgument(107);
        }
        backupSPB.addArgument(108, options);
        return backupSPB;
    }

    public void restoreDatabase() throws SQLException {
        this.restoreDatabase(0);
    }

    public void restoreDatabase(int options) throws SQLException {
        this.executeServicesOperation(this.getRestoreSRB(options));
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setRestorePageBufferCount(int bufferCount) {
        if (bufferCount < 0) {
            throw new IllegalArgumentException("Buffer count must be positive");
        }
        this.restoreBufferCount = bufferCount;
    }

    public void setRestorePageSize(int pageSize) {
        if (pageSize != 1024 && pageSize != 2048 && pageSize != 4096 && pageSize != 8192) {
            throw new IllegalArgumentException("Page size must be one of 1024, 2048, 4096 or 8192");
        }
        this.restorePageSize = pageSize;
    }

    public void setRestoreReplace(boolean replace) {
        this.restoreReplace = replace;
    }

    public void setRestoreReadOnly(boolean readOnly) {
        this.restoreReadOnly = readOnly;
    }

    private ServiceRequestBuffer getRestoreSRB(int options) {
        GDS gds = this.getGds();
        ServiceRequestBuffer restoreSPB = gds.createServiceRequestBuffer(2);
        for (PathSizeStruct pathSize : this.backupPaths) {
            restoreSPB.addArgument(5, pathSize.getPath());
        }
        Iterator iter = this.restorePaths.iterator();
        while (iter.hasNext()) {
            PathSizeStruct pathSize;
            pathSize = (PathSizeStruct)iter.next();
            restoreSPB.addArgument(106, pathSize.getPath());
            if (!iter.hasNext() || pathSize.getSize() == -1) continue;
            restoreSPB.addArgument(11, pathSize.getSize());
        }
        if (this.restoreBufferCount != -1) {
            restoreSPB.addArgument(9, this.restoreBufferCount);
        }
        if (this.restorePageSize != -1) {
            restoreSPB.addArgument(10, this.restorePageSize);
        }
        restoreSPB.addArgument(12, (byte)(this.restoreReadOnly ? 39 : 40));
        if (this.verbose) {
            restoreSPB.addArgument(107);
        }
        if ((options & 0x2000) != 8192 && (options & 0x1000) != 4096) {
            options |= this.restoreReplace ? 4096 : 8192;
        }
        restoreSPB.addArgument(108, options);
        return restoreSPB;
    }

    private static class PathSizeStruct {
        private int size;
        private String path;

        private PathSizeStruct(String path, int size) {
            this.path = path;
            this.size = size;
        }

        public String getPath() {
            return this.path;
        }

        public int getSize() {
            return this.size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PathSizeStruct)) {
                return false;
            }
            PathSizeStruct that = (PathSizeStruct)obj;
            return this.path.equals(that.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return this.path + " " + this.size;
        }
    }
}

