/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle.step;

import com.google.common.base.Joiner;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.ProgressNullMonitorListener;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.IClonableDocumentAnalyzer;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IConnectionAnalyzer;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseObjectFactory;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.Namespace;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.BaseKettleMetaverseComponent;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IFieldLineageMetadataProvider;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepNodes;
import org.pentaho.metaverse.api.messages.Messages;
import org.pentaho.metaverse.api.model.kettle.IFieldMapping;

public abstract class StepAnalyzer<T extends BaseStepMeta>
extends BaseKettleMetaverseComponent
implements IClonableStepAnalyzer<T>,
IFieldLineageMetadataProvider<T> {
    private static final Logger LOGGER = LogManager.getLogger(StepAnalyzer.class);
    public static final String NONE = "_none_";
    protected IClonableDocumentAnalyzer documentAnalyzer;
    protected IComponentDescriptor documentDescriptor;
    protected String documentPath;
    protected IComponentDescriptor descriptor;
    private StepNodes inputs;
    private StepNodes outputs;
    protected String[] prevStepNames = null;
    protected T baseStepMeta = null;
    protected StepMeta parentStepMeta = null;
    protected TransMeta parentTransMeta = null;
    protected IMetaverseNode rootNode = null;
    protected IConnectionAnalyzer connectionAnalyzer = null;
    protected Map<String, RowMetaInterface> prevFields = null;
    protected RowMetaInterface stepFields = null;

    @Override
    public IMetaverseNode analyze(IComponentDescriptor descriptor, T meta) throws MetaverseAnalyzerException {
        LOGGER.info((Object)Messages.getString("INFO.runningAnalyzer", meta.getParentStepMeta().getParentTransMeta().getName(), meta.getParentStepMeta().getName()));
        this.setDescriptor(descriptor);
        this.baseStepMeta = meta;
        this.validateState(descriptor, meta);
        this.rootNode = this.createNodeFromDescriptor(descriptor);
        String stepType = null;
        try {
            stepType = PluginRegistry.getInstance().findPluginWithId(StepPluginType.class, this.parentStepMeta.getStepID()).getName();
        }
        catch (Throwable t) {
            stepType = this.parentStepMeta.getStepID();
        }
        this.rootNode.setProperty("pluginId", this.parentStepMeta.getStepID());
        this.rootNode.setProperty("stepType", stepType);
        this.rootNode.setProperty("copies", meta.getParentStepMeta().getCopies());
        this.rootNode.setProperty("_analyzer", this.getClass().getSimpleName());
        this.rootNode.setProperty("description", this.parentStepMeta.getDescription());
        this.metaverseBuilder.addNode(this.rootNode);
        this.inputs = this.processInputs(meta);
        this.outputs = this.processOutputs(meta);
        Set<StepField> usedFields = this.getUsedFields(meta);
        if (CollectionUtils.isNotEmpty(usedFields)) {
            this.processUsedFields(usedFields);
        }
        Set<ComponentDerivationRecord> changes = this.getChanges();
        for (ComponentDerivationRecord change : changes) {
            this.mapChange(change);
        }
        this.customAnalyze(meta, this.rootNode);
        return this.rootNode;
    }

    protected void processUsedFields(Set<StepField> usedFields) {
        for (StepField usedField : usedFields) {
            IMetaverseNode usedNode = this.getInputs().findNode(usedField);
            if (usedNode == null) continue;
            this.getMetaverseBuilder().addLink(this.rootNode, "uses", usedNode);
        }
    }

    protected abstract Set<StepField> getUsedFields(T var1);

    protected abstract void customAnalyze(T var1, IMetaverseNode var2) throws MetaverseAnalyzerException;

    @Override
    public void postAnalyze(T meta) throws MetaverseAnalyzerException {
    }

    protected Set<ComponentDerivationRecord> getChanges() {
        HashSet<ComponentDerivationRecord> changes = new HashSet<ComponentDerivationRecord>();
        try {
            Set<ComponentDerivationRecord> changeRecords = this.getChangeRecords(this.baseStepMeta);
            if (CollectionUtils.isNotEmpty(changeRecords)) {
                changes.addAll(changeRecords);
            }
        }
        catch (MetaverseAnalyzerException e) {
            LOGGER.warn((Object)"Error getting change records", (Throwable)e);
        }
        Set<ComponentDerivationRecord> passthroughChanges = this.getPassthroughChanges();
        if (CollectionUtils.isNotEmpty(passthroughChanges)) {
            changes.addAll(passthroughChanges);
        }
        return changes;
    }

    protected Set<ComponentDerivationRecord> getPassthroughChanges() {
        HashSet<ComponentDerivationRecord> passthroughs = new HashSet<ComponentDerivationRecord>();
        if (this.getInputs() != null) {
            Set<StepField> incomingFieldNames = this.getInputs().getFieldNames();
            for (StepField incomingFieldName : incomingFieldNames) {
                if (!this.isPassthrough(incomingFieldName)) continue;
                ComponentDerivationRecord change = new ComponentDerivationRecord(incomingFieldName.getFieldName(), incomingFieldName.getFieldName());
                change.setOriginalEntityStepName(incomingFieldName.getStepName());
                passthroughs.add(change);
            }
        }
        return passthroughs;
    }

    protected boolean isPassthrough(StepField originalFieldName) {
        if (this.getOutputs() != null) {
            Set<StepField> fieldNames = this.getOutputs().getFieldNames();
            for (StepField fieldName : fieldNames) {
                if (!fieldName.getFieldName().equals(originalFieldName.getFieldName())) continue;
                return true;
            }
        }
        return false;
    }

    protected void mapChange(ComponentDerivationRecord change) {
        if (change != null) {
            ValueMeta tmp;
            List<Object> inputNodes = new ArrayList<IMetaverseNode>();
            ArrayList<IMetaverseNode> outputNodes = new ArrayList<IMetaverseNode>();
            if (StringUtils.isNotEmpty((String)change.getOriginalEntityStepName())) {
                IMetaverseNode inputNode = this.getInputs().findNode(change.getOriginalField());
                if (inputNode != null) {
                    inputNodes.add(inputNode);
                }
            } else {
                inputNodes.addAll(this.getInputs().findNodes(change.getOriginalEntityName()));
            }
            if (StringUtils.isNotEmpty((String)change.getChangedEntityStepName())) {
                IMetaverseNode outputNode = this.getOutputs().findNode(change.getChangedField());
                if (outputNode != null) {
                    outputNodes.add(outputNode);
                }
            } else {
                outputNodes.addAll(this.getOutputs().findNodes(change.getChangedEntityName()));
            }
            if (CollectionUtils.isEmpty(inputNodes) && CollectionUtils.isEmpty(inputNodes = this.getOutputs().findNodes(change.getOriginalEntityName()))) {
                tmp = new ValueMeta(change.getOriginalEntityName());
                IMetaverseNode iMetaverseNode = this.createOutputFieldNode(this.getDescriptor().getContext(), (ValueMetaInterface)tmp, null, this.getTransientNodeType());
                this.getMetaverseBuilder().addLink(this.rootNode, "transient", iMetaverseNode);
                this.getMetaverseBuilder().addLink(this.rootNode, "uses", iMetaverseNode);
                inputNodes.add(iMetaverseNode);
            }
            if (CollectionUtils.isEmpty(outputNodes)) {
                tmp = new ValueMeta(change.getChangedEntityName());
                IMetaverseNode iMetaverseNode = this.createOutputFieldNode(this.getDescriptor().getContext(), (ValueMetaInterface)tmp, null, this.getTransientNodeType());
                this.getMetaverseBuilder().addLink(this.rootNode, "transient", iMetaverseNode);
                this.getMetaverseBuilder().addLink(this.rootNode, "uses", iMetaverseNode);
                outputNodes.add(iMetaverseNode);
            }
            for (IMetaverseNode iMetaverseNode : inputNodes) {
                for (IMetaverseNode outputNode : outputNodes) {
                    if (change.getOperations().size() > 0) {
                        outputNode.setProperty("operations", change.toString());
                    }
                    this.linkChangeNodes(iMetaverseNode, outputNode);
                }
            }
        }
    }

    protected void linkChangeNodes(IMetaverseNode inputNode, IMetaverseNode outputNode) {
        this.getMetaverseBuilder().addLink(inputNode, this.getInputToOutputLinkLabel(), outputNode);
    }

    protected StepNodes processOutputs(T meta) {
        StepNodes outputs = new StepNodes();
        Map<String, RowMetaInterface> outputRowMetaInterfaces = this.getOutputRowMetaInterfaces(meta);
        if (MapUtils.isNotEmpty(outputRowMetaInterfaces)) {
            for (Map.Entry<String, RowMetaInterface> entry : outputRowMetaInterfaces.entrySet()) {
                String nextStepName = entry.getKey();
                RowMetaInterface outputFields = entry.getValue();
                if (outputFields != null) {
                    for (ValueMetaInterface valueMetaInterface : outputFields.getValueMetaList()) {
                        IMetaverseNode fieldNode = this.createOutputFieldNode(this.getDescriptor().getContext(), valueMetaInterface, nextStepName, this.getOutputNodeType());
                        this.getMetaverseBuilder().addLink(this.rootNode, "outputs", fieldNode);
                        outputs.addNode(nextStepName, valueMetaInterface.getName(), fieldNode);
                    }
                    continue;
                }
                LOGGER.warn((Object)("No output fields found for step " + this.getStepName()));
            }
        }
        return outputs;
    }

    protected IMetaverseNode createInputFieldNode(IAnalysisContext context, ValueMetaInterface fieldMeta, String previousStepName, String nodeType) {
        IComponentDescriptor prevFieldDescriptor = this.getPrevFieldDescriptor(previousStepName, fieldMeta.getName());
        return this.createFieldNode(prevFieldDescriptor, fieldMeta, this.getStepName(), false);
    }

    protected IMetaverseNode createOutputFieldNode(IAnalysisContext context, ValueMetaInterface fieldMeta, String targetStepName, String nodeType) {
        MetaverseComponentDescriptor fieldDescriptor = new MetaverseComponentDescriptor(fieldMeta.getName(), nodeType, this.rootNode, context);
        return this.createFieldNode((IComponentDescriptor)fieldDescriptor, fieldMeta, targetStepName, true);
    }

    @Override
    protected IMetaverseNode createNodeFromDescriptor(IComponentDescriptor descriptor) {
        return super.createNodeFromDescriptor(descriptor);
    }

    protected IMetaverseNode createFieldNode(IComponentDescriptor fieldDescriptor, ValueMetaInterface fieldMeta, String targetStepName, boolean addTheNode) {
        return this.createFieldNode(fieldDescriptor, fieldMeta.getTypeDesc(), targetStepName, addTheNode);
    }

    protected IMetaverseNode createFieldNode(IComponentDescriptor fieldDescriptor, String kettleType, String targetStepName, boolean addTheNode) {
        IMetaverseNode newFieldNode = this.createNodeFromDescriptor(fieldDescriptor);
        newFieldNode.setProperty("kettleType", kettleType);
        if (targetStepName != null) {
            newFieldNode.setProperty("targetStep", targetStepName);
            newFieldNode.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_TARGET_AWARE);
            if (addTheNode) {
                this.getMetaverseBuilder().addNode(newFieldNode);
            }
        }
        return newFieldNode;
    }

    protected StepNodes processInputs(T meta) {
        StepNodes inputs = new StepNodes();
        Map<String, RowMetaInterface> inputRowMetaInterfaces = this.getInputRowMetaInterfaces(meta);
        if (MapUtils.isNotEmpty(inputRowMetaInterfaces)) {
            for (Map.Entry<String, RowMetaInterface> entry : inputRowMetaInterfaces.entrySet()) {
                String prevStepName = entry.getKey();
                RowMetaInterface inputFields = entry.getValue();
                if (inputFields != null) {
                    String[] stepInputFieldNames = inputFields.getFieldNames();
                    try {
                        RowMetaInterface stepInputFields;
                        if (!"_resource_".equals(prevStepName) && (stepInputFields = this.parentTransMeta.getPrevStepFields(this.parentStepMeta, prevStepName, null)) != null) {
                            stepInputFieldNames = stepInputFields.getFieldNames();
                        }
                    }
                    catch (KettleStepException kettleStepException) {
                        // empty catch block
                    }
                    for (ValueMetaInterface valueMetaInterface : inputFields.getValueMetaList()) {
                        boolean addLink = Arrays.asList(stepInputFieldNames).contains(valueMetaInterface.getName());
                        IMetaverseNode prevFieldNode = this.createInputFieldNode(this.getDescriptor().getContext(), valueMetaInterface, prevStepName, this.getInputNodeType());
                        if (!addLink) continue;
                        this.getMetaverseBuilder().addLink(prevFieldNode, "inputs", this.rootNode);
                        inputs.addNode(prevStepName, valueMetaInterface.getName(), prevFieldNode);
                    }
                    continue;
                }
                LOGGER.warn((Object)("No input fields found for step " + this.getStepName()));
            }
        }
        return inputs;
    }

    protected IComponentDescriptor getPrevFieldDescriptor(String prevStepName, String fieldName) {
        MetaverseComponentDescriptor prevFieldDescriptor = null;
        if (StringUtils.isNotEmpty((String)prevStepName)) {
            Object nsObj = this.rootNode.getProperty("namespace");
            Namespace ns = new Namespace(nsObj != null ? nsObj.toString() : null);
            IMetaverseNode tmpOriginNode = this.getMetaverseObjectFactory().createNodeObject((INamespace)ns, prevStepName, "Transformation Step");
            Namespace stepFieldNamespace = new Namespace(tmpOriginNode.getLogicalId());
            prevFieldDescriptor = new MetaverseComponentDescriptor(fieldName, this.getInputNodeType(), stepFieldNamespace, this.getDescriptor().getContext());
        }
        return prevFieldDescriptor;
    }

    public Set<String> getInputStepNames(T meta, String fieldName) {
        Map<String, RowMetaInterface> inputRowMetaInterfaces = this.getInputRowMetaInterfaces(meta);
        HashSet<String> prevStepNames = new HashSet<String>();
        if (MapUtils.isNotEmpty(inputRowMetaInterfaces)) {
            for (Map.Entry<String, RowMetaInterface> entry : inputRowMetaInterfaces.entrySet()) {
                String prevStepName = entry.getKey();
                RowMetaInterface inputFields = entry.getValue();
                if (inputFields == null) continue;
                for (ValueMetaInterface valueMetaInterface : inputFields.getValueMetaList()) {
                    if (!valueMetaInterface.getName().equalsIgnoreCase(fieldName)) continue;
                    prevStepNames.add(prevStepName);
                }
            }
        }
        return prevStepNames;
    }

    public String getStepName() {
        return this.parentStepMeta.getName();
    }

    public StepNodes getInputs() {
        return this.inputs;
    }

    public StepNodes getOutputs() {
        return this.outputs;
    }

    public void setDescriptor(IComponentDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public IComponentDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Set<StepField> createStepFields(String fieldName, StepNodes stepNodes) {
        HashSet<StepField> fields = new HashSet<StepField>();
        for (String stepName : stepNodes.getStepNames()) {
            fields.add(new StepField(stepName, fieldName));
        }
        return fields;
    }

    protected String getInputToOutputLinkLabel() {
        return "derives";
    }

    protected String getInputNodeType() {
        return "Transformation Stream field";
    }

    protected String getOutputNodeType() {
        return "Transformation Stream field";
    }

    protected String getTransientNodeType() {
        return "Transformation Stream field";
    }

    protected Map<String, RowMetaInterface> getOutputRowMetaInterfaces(T meta) {
        return this.getOutputRowMetaInterfaces(this.parentTransMeta, this.parentStepMeta, (BaseStepMeta)meta, true);
    }

    protected Map<String, RowMetaInterface> getOutputRowMetaInterfaces(TransMeta transMeta, StepMeta stepMeta, BaseStepMeta meta, boolean validateState) {
        RowMetaInterface outputFields;
        Object[] nextStepNames = transMeta.getNextStepNames(stepMeta);
        HashMap<String, RowMetaInterface> outputRows = new HashMap<String, RowMetaInterface>();
        RowMetaInterface rowMetaInterface = outputFields = validateState ? this.getOutputFields(meta) : this.getOutputFields(transMeta, stepMeta);
        if (outputFields != null && ArrayUtils.isEmpty((Object[])nextStepNames)) {
            nextStepNames = new String[]{NONE};
        }
        for (Object stepName : nextStepNames) {
            outputRows.put((String)stepName, outputFields);
        }
        return outputRows;
    }

    protected Map<String, RowMetaInterface> getInputRowMetaInterfaces(T meta) {
        Map<String, RowMetaInterface> inputFields = this.getInputFields(meta);
        return inputFields;
    }

    protected void setMetaverseObjectFactory(IMetaverseObjectFactory factory) {
        this.metaverseObjectFactory = factory;
    }

    public void validateState(IComponentDescriptor descriptor, T object) throws MetaverseAnalyzerException {
        this.baseStepMeta = object;
        if (this.baseStepMeta == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.StepMetaInterface.IsNull"));
        }
        this.parentStepMeta = this.baseStepMeta.getParentStepMeta();
        if (this.parentStepMeta == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.StepMeta.IsNull"));
        }
        this.parentTransMeta = this.parentStepMeta.getParentTransMeta();
        if (this.parentTransMeta == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.ParentTransMeta.IsNull"));
        }
        if (this.metaverseBuilder == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.MetaverseBuilder.IsNull"));
        }
        if (this.metaverseObjectFactory == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.MetaverseObjectFactory.IsNull"));
        }
    }

    public IConnectionAnalyzer getConnectionAnalyzer() {
        return this.connectionAnalyzer;
    }

    public void setConnectionAnalyzer(IConnectionAnalyzer connectionAnalyzer) {
        this.connectionAnalyzer = connectionAnalyzer;
    }

    public Map<String, RowMetaInterface> getInputFields(TransMeta parentTransMeta, StepMeta parentStepMeta) {
        HashMap<String, RowMetaInterface> rowMeta = null;
        if (parentTransMeta != null) {
            try {
                rowMeta = new HashMap<String, RowMetaInterface>();
                ProgressNullMonitorListener progressMonitor = new ProgressNullMonitorListener();
                this.prevStepNames = parentTransMeta.getPrevStepNames(parentStepMeta);
                RowMetaInterface rmi = parentTransMeta.getPrevStepFields(parentStepMeta, (ProgressMonitorListener)progressMonitor);
                progressMonitor.done();
                if (!ArrayUtils.isEmpty((Object[])this.prevStepNames)) {
                    this.populateInputFieldsRowMeta(rowMeta, rmi);
                }
            }
            catch (KettleStepException e) {
                rowMeta = null;
            }
        }
        return rowMeta;
    }

    @Override
    public Map<String, RowMetaInterface> getInputFields(T meta) {
        try {
            this.validateState(null, meta);
        }
        catch (MetaverseAnalyzerException metaverseAnalyzerException) {
            // empty catch block
        }
        return this.getInputFields(this.parentTransMeta, this.parentStepMeta);
    }

    protected void populateInputFieldsRowMeta(Map<String, RowMetaInterface> rowMeta, RowMetaInterface rmi) {
        for (String previousStepName : this.prevStepNames) {
            rowMeta.put(previousStepName, rmi);
        }
    }

    @Override
    public RowMetaInterface getOutputFields(T meta) {
        Object rmi = null;
        try {
            this.validateState(null, meta);
        }
        catch (MetaverseAnalyzerException metaverseAnalyzerException) {
            // empty catch block
        }
        return this.getOutputFields(this.parentTransMeta, this.parentStepMeta);
    }

    protected RowMetaInterface getOutputFields(TransMeta transMeta, StepMeta stepMeta) {
        RowMetaInterface rmi = null;
        if (transMeta != null) {
            try {
                ProgressNullMonitorListener progressMonitor = new ProgressNullMonitorListener();
                rmi = transMeta.getStepFields(stepMeta, (ProgressMonitorListener)progressMonitor);
                progressMonitor.done();
            }
            catch (KettleStepException e) {
                rmi = null;
            }
        }
        return rmi;
    }

    @Override
    public Set<IFieldMapping> getFieldMappings(T meta) throws MetaverseAnalyzerException {
        return null;
    }

    @Override
    public Set<ComponentDerivationRecord> getChangeRecords(T meta) throws MetaverseAnalyzerException {
        return null;
    }

    public void loadInputAndOutputStreamFields(T meta) {
        this.prevFields = this.getInputFields(meta);
        this.stepFields = this.getOutputFields(meta);
    }

    protected IComponentDescriptor getStepFieldOriginDescriptor(IComponentDescriptor descriptor, String fieldName) throws MetaverseAnalyzerException {
        String origin;
        if (descriptor == null || this.stepFields == null) {
            return null;
        }
        ValueMetaInterface vmi = this.stepFields.searchValueMeta(fieldName);
        String string = origin = vmi == null ? fieldName : vmi.getOrigin();
        if (origin == null && !ArrayUtils.isEmpty((Object[])this.prevStepNames)) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.NoOriginForField", fieldName));
        }
        IMetaverseNode tmpOriginNode = this.metaverseObjectFactory.createNodeObject(UUID.randomUUID().toString(), origin, "Transformation Step");
        tmpOriginNode.setProperty("namespace", this.rootNode.getProperty("namespace"));
        Namespace stepFieldNamespace = new Namespace(tmpOriginNode.getLogicalId());
        MetaverseComponentDescriptor d = new MetaverseComponentDescriptor(fieldName, "Transformation Stream field", tmpOriginNode, descriptor.getContext());
        return d;
    }

    @Override
    public final IClonableStepAnalyzer cloneAnalyzer() {
        IClonableStepAnalyzer newInstance = this.newInstance();
        this.copyState(newInstance);
        return newInstance;
    }

    protected IClonableStepAnalyzer newInstance() {
        return this;
    }

    protected boolean copyState(IClonableStepAnalyzer newAnalyzer) {
        if (newAnalyzer instanceof StepAnalyzer) {
            ((StepAnalyzer)newAnalyzer).setConnectionAnalyzer(this.getConnectionAnalyzer());
            return true;
        }
        return false;
    }

    protected IMetaverseNode getNode(String name, String type, String namespaceId, String nodeKey, Map<String, IMetaverseNode> nodeMap) {
        return this.getNode(name, type, new Namespace(namespaceId), nodeKey, nodeMap);
    }

    public IMetaverseNode getNode(String name, String type, INamespace namespace, String nodeKey, Map<String, IMetaverseNode> nodeMap) {
        IMetaverseNode node;
        IMetaverseNode iMetaverseNode = node = nodeMap == null ? null : nodeMap.get(nodeKey);
        if (node == null) {
            node = this.createNode(name, type, namespace);
            if (nodeMap != null) {
                nodeMap.put(nodeKey, node);
            }
        }
        return node;
    }

    protected IMetaverseNode createNode(String name, String type, INamespace namespace) {
        MetaverseComponentDescriptor descriptor = new MetaverseComponentDescriptor(name, type, namespace);
        IMetaverseNode node = this.createNodeFromDescriptor(descriptor);
        node.setProperty("virtual", false);
        return node;
    }

    @Override
    public void setDocumentAnalyzer(IClonableDocumentAnalyzer documentAnalyzer) {
        this.documentAnalyzer = documentAnalyzer;
    }

    @Override
    public IClonableDocumentAnalyzer getDocumentAnalyzer() {
        return this.documentAnalyzer;
    }

    @Override
    public void setDocumentDescriptor(IComponentDescriptor documentDescriptor) {
        this.documentDescriptor = documentDescriptor;
    }

    @Override
    public IComponentDescriptor getDocumentDescriptor() {
        return this.documentDescriptor;
    }

    @Override
    public void setDocumentPath(String documentPath) {
        this.documentPath = documentPath;
    }

    protected List<Vertex> findVertices(Map<String, String> properties) {
        return this.findVertices(this.getMetaverseBuilder().getGraph().getVertices().iterator(), properties);
    }

    protected List<Vertex> findVertices(Iterator<Vertex> vertices, Map<String, String> properties) {
        ArrayList<Vertex> matchingNodes = new ArrayList<Vertex>();
        block0: while (vertices.hasNext()) {
            Vertex vertex = vertices.next();
            if (properties != null) {
                for (Map.Entry<String, String> property : properties.entrySet()) {
                    String propName = property.getKey();
                    String propValue = property.getValue();
                    if (vertex.getProperty(propName) != null && vertex.getProperty(propName).equals(propValue)) continue;
                    continue block0;
                }
            }
            matchingNodes.add(vertex);
        }
        return matchingNodes;
    }

    protected Vertex findStepVertex(TransMeta transMeta, String stepName) {
        HashMap<String, String> propsLookupMap = new HashMap<String, String>();
        propsLookupMap.put("name", stepName);
        return this.findStepVertex(transMeta, propsLookupMap);
    }

    protected Vertex findStepVertex(TransMeta transMeta, Map<String, String> properties) {
        List<Vertex> matchingVertices = this.findStepVertices(transMeta, properties);
        if (matchingVertices.size() > 0) {
            if (matchingVertices.size() > 1) {
                LOGGER.warn((Object)Messages.getString("WARN.MultipleMatchingStepVerticesFound", transMeta.getName(), Joiner.on((String)", ").withKeyValueSeparator(": ").join((Map)(properties == null ? new HashMap() : properties))));
            }
            return matchingVertices.get(0);
        }
        return null;
    }

    protected List<Vertex> findStepVertices(TransMeta transMeta, Map<String, String> properties) {
        ArrayList<Vertex> matchingNodes = new ArrayList<Vertex>();
        HashMap<String, String> propsLookupMap = properties == null ? new HashMap<String, String>() : new HashMap<String, String>(properties);
        propsLookupMap.put("type", "Transformation Step");
        List<Vertex> potentialMatches = this.findVertices(propsLookupMap);
        String transPath = KettleAnalyzerUtil.normalizeFilePathSafely(transMeta.getFilename());
        for (Vertex potentialMatch : potentialMatches) {
            for (Vertex containingVertex : potentialMatch.getVertices(Direction.IN, new String[]{"contains"})) {
                String containingVertexPath = KettleAnalyzerUtil.normalizeFilePathSafely((String)containingVertex.getProperty("path"));
                if (!transPath.equalsIgnoreCase(containingVertexPath)) continue;
                matchingNodes.add(potentialMatch);
            }
        }
        return matchingNodes;
    }

    protected Vertex findFieldVertex(TransMeta transMeta, String stepName, String fieldName) {
        HashMap<String, String> propsLookupMap = new HashMap<String, String>();
        propsLookupMap.put("name", fieldName);
        return this.findFieldVertex(transMeta, stepName, propsLookupMap);
    }

    protected Vertex findFieldVertex(TransMeta transMeta, String stepName, Map<String, String> properties) {
        List<Vertex> matchingVertices = this.findFieldVertices(transMeta, stepName, properties);
        if (matchingVertices.size() > 0) {
            if (matchingVertices.size() > 1) {
                LOGGER.warn((Object)Messages.getString("WARN.MultipleMatchingFieldVerticesFound", transMeta.getName(), stepName, Joiner.on((String)", ").withKeyValueSeparator(": ").join((Map)(properties == null ? new HashMap() : properties))));
            }
            return matchingVertices.get(0);
        }
        return null;
    }

    protected List<Vertex> findFieldVertices(TransMeta transMeta, String stepName, Map<String, String> properties) {
        Vertex stepVertex = this.findStepVertex(transMeta, stepName);
        HashMap<String, String> propsLookupMap = properties == null ? new HashMap<String, String>() : new HashMap<String, String>(properties);
        propsLookupMap.put("type", "Transformation Stream field");
        return this.findVertices(stepVertex.getVertices(Direction.OUT, new String[]{"outputs"}).iterator(), propsLookupMap);
    }

    protected Vertex findVertexById(String id) {
        for (Vertex vertex : this.getMetaverseBuilder().getGraph().getVertices()) {
            if (!vertex.getId().equals(id)) continue;
            return vertex;
        }
        return null;
    }

    protected List<Vertex> findFieldVertices(TransMeta transMeta, String stepName) {
        return this.findFieldVertices(transMeta, stepName, null);
    }

    protected boolean setPropertySafely(Vertex vertex, String propertyName, String propertyValue) {
        if (vertex == null || propertyName == null || propertyValue == null) {
            return false;
        }
        vertex.setProperty(propertyName, (Object)propertyValue);
        return true;
    }
}

