/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle.step;

import java.util.Collection;
import java.util.Collections;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputStep;
import org.pentaho.di.trans.steps.file.BaseFileMeta;
import org.pentaho.metaverse.api.AnalysisContext;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepExternalResourceConsumer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public abstract class BaseStepExternalResourceConsumer<S extends BaseStep, M extends BaseStepMeta>
implements IStepExternalResourceConsumer<S, M> {
    private boolean fetchResources(M meta) {
        return !(meta instanceof BaseFileMeta) || ((BaseFileMeta)meta).writesToFile();
    }

    @Override
    public boolean isDataDriven(M meta) {
        return false;
    }

    @Override
    public Collection<IExternalResourceInfo> getResourcesFromMeta(M meta) {
        return this.getResourcesFromMeta(meta, (IAnalysisContext)new AnalysisContext("runtime"));
    }

    @Override
    public Collection<IExternalResourceInfo> getResourcesFromMeta(M meta, IAnalysisContext context) {
        if (!(meta instanceof BaseFileMeta) || !this.fetchResources(meta) || this.isDataDriven(meta)) {
            return Collections.emptyList();
        }
        return KettleAnalyzerUtil.getResourcesFromMeta(meta.getParentStepMeta(), ((BaseFileMeta)meta).getFilePaths(false));
    }

    @Override
    public Collection<IExternalResourceInfo> getResourcesFromRow(S step, RowMetaInterface rowMeta, Object[] row) {
        if (!this.fetchResources(null)) {
            return Collections.emptyList();
        }
        if (step instanceof BaseFileInputStep) {
            Collection<IExternalResourceInfo> resourcesFromRow = KettleAnalyzerUtil.getResourcesFromRow((BaseFileInputStep)step, rowMeta, row);
            return resourcesFromRow;
        }
        return Collections.emptyList();
    }
}

