/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle.jobentry;

import java.lang.reflect.Method;
import java.util.List;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.api.IClonableDocumentAnalyzer;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IConnectionAnalyzer;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.analyzer.kettle.BaseKettleMetaverseComponent;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IClonableJobEntryAnalyzer;
import org.pentaho.metaverse.api.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobEntryAnalyzer<T extends JobEntryInterface>
extends BaseKettleMetaverseComponent
implements IClonableJobEntryAnalyzer<IMetaverseNode, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobEntryAnalyzer.class);
    protected IClonableDocumentAnalyzer documentAnalyzer;
    protected IComponentDescriptor documentDescriptor;
    protected String documentPath;
    protected String[] prevJobNames = null;
    protected T jobEntryInterface = null;
    protected Job parentJob = null;
    JobMeta parentJobMeta = null;
    protected IMetaverseNode rootNode = null;
    protected IConnectionAnalyzer<Object, T> connectionAnalyzer = null;
    protected IComponentDescriptor descriptor;

    @Override
    public IMetaverseNode analyze(IComponentDescriptor descriptor, T entry) throws MetaverseAnalyzerException {
        this.validateState(descriptor, entry);
        this.descriptor = descriptor;
        this.rootNode = this.createNodeFromDescriptor(descriptor);
        String stepType = null;
        try {
            stepType = PluginRegistry.getInstance().findPluginWithId(JobEntryPluginType.class, entry.getPluginId()).getName();
        }
        catch (Throwable t) {
            stepType = entry.getClass().getSimpleName();
        }
        this.rootNode.setProperty("pluginId", entry.getPluginId());
        this.rootNode.setProperty("jobEntryType", stepType);
        this.rootNode.setProperty("copies", entry.getParentJob().getJobMeta().getJobCopies().size());
        this.rootNode.setProperty("description", entry.getDescription());
        this.rootNode.setProperty("_analyzer", this.getClass().getSimpleName());
        this.metaverseBuilder.addNode(this.rootNode);
        this.customAnalyze(entry, this.rootNode);
        return this.rootNode;
    }

    protected abstract void customAnalyze(T var1, IMetaverseNode var2) throws MetaverseAnalyzerException;

    protected void addConnectionNodes(IComponentDescriptor descriptor) throws MetaverseAnalyzerException {
        if (this.jobEntryInterface == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.JobEntryInterface.IsNull"));
        }
        if (this.connectionAnalyzer != null) {
            List<Object> connections = this.connectionAnalyzer.getUsedConnections(this.jobEntryInterface);
            for (Object connection : connections) {
                String connName = null;
                try {
                    Method getNameMethod = connection.getClass().getMethod("getName", null);
                    connName = (String)getNameMethod.invoke(connection, null);
                }
                catch (Exception getNameMethod) {
                    // empty catch block
                }
                try {
                    IComponentDescriptor connDescriptor = this.connectionAnalyzer.buildComponentDescriptor(descriptor, connection);
                    connName = connName == null ? descriptor.getName() : connName;
                    IMetaverseNode connNode = (IMetaverseNode)this.connectionAnalyzer.analyze(connDescriptor, connection);
                    this.metaverseBuilder.addLink(connNode, "dependencyof", this.rootNode);
                }
                catch (Throwable t) {
                    LOGGER.warn(Messages.getString("WARNING.AnalyzingDatabaseConnection", connName), t);
                }
            }
        }
    }

    protected void validateState(IComponentDescriptor descriptor, T entry) throws MetaverseAnalyzerException {
        if (entry == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.JobEntryInterface.IsNull"));
        }
        this.jobEntryInterface = entry;
        this.parentJob = entry.getParentJob();
        if (this.parentJob == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.ParentJob.IsNull"));
        }
        this.parentJobMeta = this.parentJob.getJobMeta();
        if (this.parentJobMeta == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.ParentJobMeta.IsNull"));
        }
        if (this.metaverseBuilder == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.MetaverseBuilder.IsNull"));
        }
        if (this.metaverseObjectFactory == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.MetaverseObjectFactory.IsNull"));
        }
    }

    public IConnectionAnalyzer<Object, T> getConnectionAnalyzer() {
        return this.connectionAnalyzer;
    }

    public void setConnectionAnalyzer(IConnectionAnalyzer<Object, T> connectionAnalyzer) {
        this.connectionAnalyzer = connectionAnalyzer;
    }

    public IComponentDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(IComponentDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected IMetaverseNode createFieldNode(IComponentDescriptor fieldDescriptor, ValueMetaInterface fieldMeta, String targetStepName, boolean addTheNode) {
        IMetaverseNode newFieldNode = this.createNodeFromDescriptor(fieldDescriptor);
        newFieldNode.setProperty("kettleType", fieldMeta.getTypeDesc());
        if (targetStepName != null) {
            newFieldNode.setProperty("targetStep", targetStepName);
            newFieldNode.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_TARGET_AWARE);
            if (addTheNode) {
                this.getMetaverseBuilder().addNode(newFieldNode);
            }
        }
        return newFieldNode;
    }

    @Override
    public final IClonableJobEntryAnalyzer cloneAnalyzer() {
        IClonableJobEntryAnalyzer newInstance = this.newInstance();
        this.copyState(newInstance);
        return newInstance;
    }

    protected IClonableJobEntryAnalyzer newInstance() {
        return this;
    }

    protected boolean copyState(IClonableJobEntryAnalyzer newAnalyzer) {
        if (newAnalyzer instanceof JobEntryAnalyzer) {
            ((JobEntryAnalyzer)newAnalyzer).setConnectionAnalyzer(this.getConnectionAnalyzer());
            return true;
        }
        return false;
    }

    @Override
    public void setDocumentAnalyzer(IClonableDocumentAnalyzer documentAnalyzer) {
        this.documentAnalyzer = documentAnalyzer;
    }

    @Override
    public IClonableDocumentAnalyzer getDocumentAnalyzer() {
        return this.documentAnalyzer;
    }

    @Override
    public void setDocumentDescriptor(IComponentDescriptor documentDescriptor) {
        this.documentDescriptor = documentDescriptor;
    }

    @Override
    public void setDocumentPath(String documentPath) {
        this.documentPath = documentPath;
    }

    @Override
    public IComponentDescriptor getDocumentDescriptor() {
        return this.documentDescriptor;
    }
}

