/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.api;

import com.debortoliwines.openerp.api.Field;
import com.debortoliwines.openerp.api.FieldCollection;
import com.debortoliwines.openerp.api.OpeneERPApiException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class Row {
    private final HashMap<String, Object> openERPResult;
    private final FieldCollection fields;
    private final ArrayList<RowChangedListener> rowChangedListeners = new ArrayList();
    private final FieldCollection changedFields = new FieldCollection();

    public Row(HashMap<String, Object> openERPResult, FieldCollection fields) throws OpeneERPApiException {
        this.openERPResult = openERPResult;
        this.fields = fields;
        if (openERPResult.isEmpty()) {
            this.put("id", 0);
            for (int i = 0; i < fields.size(); ++i) {
                this.put(((Field)fields.get(i)).getName(), null);
            }
        }
    }

    public int getID() {
        Object idValue = this.get("id");
        return Integer.parseInt(idValue.toString());
    }

    public void addRowChangedLisener(RowChangedListener listener) {
        if (!this.rowChangedListeners.contains(listener)) {
            this.rowChangedListeners.add(listener);
        }
    }

    public Row(Row templateRow) {
        this.openERPResult = (HashMap)templateRow.openERPResult.clone();
        this.fields = (FieldCollection)templateRow.fields.clone();
    }

    public FieldCollection getFields() {
        return this.fields;
    }

    public Object get(Field field) {
        return this.get(field.getName());
    }

    public Object get(String fieldName) {
        if (fieldName != null && fieldName.equals("id")) {
            return this.openERPResult.get(fieldName);
        }
        Field fieldMeta = this.getField(fieldName);
        if (fieldMeta == null) {
            return null;
        }
        Object value = this.openERPResult.get(fieldName);
        Field.FieldType fieldType = fieldMeta.getType();
        if (fieldType != Field.FieldType.BOOLEAN && value instanceof Boolean) {
            return null;
        }
        if (value instanceof Object[] && ((Object[])value).length == 0) {
            return null;
        }
        if (value instanceof String && fieldType == Field.FieldType.DATE) {
            SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return dfm.parse(value.toString());
            }
            catch (ParseException p) {
                return null;
            }
        }
        if (value instanceof String && fieldType == Field.FieldType.DATETIME) {
            SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                return dfm.parse(value.toString());
            }
            catch (ParseException p) {
                return null;
            }
        }
        return value;
    }

    private Field getField(String fieldName) {
        for (Field fld : this.fields) {
            if (!fld.getName().equals(fieldName)) continue;
            return fld;
        }
        return null;
    }

    public void put(String fieldName, Object value) throws OpeneERPApiException {
        if (fieldName.equals("id")) {
            this.openERPResult.put(fieldName, value);
            return;
        }
        Field fld = this.getField(fieldName);
        if (fld == null) {
            throw new OpeneERPApiException("Field '" + fieldName + "' was not found in row");
        }
        Field.FieldType fieldType = fld.getType();
        if (fieldType == Field.FieldType.ONE2MANY) {
            value = new Object[]{value, null};
        }
        if (this.openERPResult.containsKey(fieldName)) {
            Object oldValue = this.openERPResult.get(fieldName);
            if (oldValue == null && value == null) {
                return;
            }
            if (oldValue == null && value != null || oldValue != null && value == null || !oldValue.equals(value)) {
                this.openERPResult.remove(fieldName);
            } else {
                return;
            }
        }
        this.openERPResult.put(fieldName, value);
        this.getChangedFields().add(fld);
        for (RowChangedListener listener : this.rowChangedListeners) {
            listener.rowChanged(fld, this);
        }
    }

    public void putMany2ManyValue(String fieldName, Object[] values, boolean append) throws OpeneERPApiException {
        Field fld = this.getField(fieldName);
        if (fld.getType() != Field.FieldType.MANY2MANY) {
            throw new OpeneERPApiException("Field '" + fieldName + "' is not a many2many field");
        }
        Object currentValue = this.get(fieldName);
        if (currentValue == null) {
            this.put(fieldName, values);
        }
        ArrayList<Object> newValues = new ArrayList<Object>();
        if (append) {
            Collections.addAll(newValues, (Object[])currentValue);
        }
        for (Object val : values) {
            if (newValues.contains(val)) continue;
            newValues.add(val);
        }
        this.put(fieldName, newValues.toArray(new Object[newValues.size()]));
    }

    public void changesApplied() {
        this.changedFields.clear();
    }

    public FieldCollection getChangedFields() {
        return this.changedFields;
    }

    public static interface RowChangedListener {
        public void rowChanged(Field var1, Row var2);
    }
}

