/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl.extension;

import org.pentaho.di.core.attributes.metastore.EmbeddedMetaStore;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.impl.EmbeddedRunConfigurationManager;
import org.pentaho.di.engine.configuration.impl.RunConfigurationManager;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobExecutionExtension;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.job.entries.trans.JobEntryTrans;

@ExtensionPoint(id="RunConfigurationInjectExtensionPoint", description="Inject run cofiguration before job entry start", extensionPointId="JobBeforeJobEntryExecution")
public class RunConfigurationInjectExtensionPoint
implements ExtensionPointInterface {
    private RunConfigurationManager runConfigurationManager;

    public RunConfigurationInjectExtensionPoint(RunConfigurationManager runConfigurationManager) {
        this.runConfigurationManager = runConfigurationManager;
    }

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        RunConfiguration loadedRunConfiguration;
        if (!(object instanceof JobExecutionExtension)) {
            return;
        }
        JobExecutionExtension extension = (JobExecutionExtension)object;
        Job job = extension.job;
        JobMeta jobMeta = job.getJobMeta();
        EmbeddedMetaStore embeddedMetaStore = jobMeta.getEmbeddedMetaStore();
        RunConfigurationManager embeddedRunConfigurationManager = EmbeddedRunConfigurationManager.build(embeddedMetaStore);
        for (JobEntryTrans trans : job.getActiveJobEntryTransformations().values()) {
            loadedRunConfiguration = this.runConfigurationManager.load(jobMeta.environmentSubstitute(trans.getRunConfiguration()));
            embeddedRunConfigurationManager.save(loadedRunConfiguration);
        }
        for (JobEntryJob subJob : job.getActiveJobEntryJobs().values()) {
            loadedRunConfiguration = this.runConfigurationManager.load(jobMeta.environmentSubstitute(subJob.getRunConfiguration()));
            embeddedRunConfigurationManager.save(loadedRunConfiguration);
        }
    }
}

