/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.ws;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.pentaho.platform.scheduler2.messsages.Messages;
import org.pentaho.platform.scheduler2.ws.ListParamValue;
import org.pentaho.platform.scheduler2.ws.MapParamValue;
import org.pentaho.platform.scheduler2.ws.ParamValue;
import org.pentaho.platform.scheduler2.ws.StringParamValue;

@XmlRootElement
public class JaxBSafeMap {
    public List<JaxBSafeEntry> entry = new ArrayList<JaxBSafeEntry>();

    public JaxBSafeMap(Map<String, ParamValue> map) {
        for (Map.Entry<String, ParamValue> e : map.entrySet()) {
            this.entry.add(new JaxBSafeEntry(e));
        }
    }

    public JaxBSafeMap() {
    }

    public static class JaxBSafeEntry {
        public String key;
        private StringParamValue stringValue;
        public boolean listValueIsEmptyList;
        private ListParamValue listValue;
        private MapParamValue mapValue;

        public JaxBSafeEntry() {
        }

        public JaxBSafeEntry(Map.Entry<String, ParamValue> e) {
            this.key = e.getKey();
            ParamValue v = e.getValue();
            if (v instanceof StringParamValue) {
                this.stringValue = (StringParamValue)v;
            } else if (v instanceof ListParamValue) {
                this.listValue = (ListParamValue)v;
                if (this.listValue.size() == 0) {
                    this.listValueIsEmptyList = true;
                }
            } else if (v instanceof MapParamValue) {
                this.mapValue = (MapParamValue)v;
            } else {
                throw new UnsupportedOperationException(MessageFormat.format(Messages.getInstance().getErrorString("JobParamsAdapter.ERROR_0001"), v.getClass(), this.getClass()));
            }
        }

        public ListParamValue getListValue() {
            if (this.listValue == null && this.listValueIsEmptyList) {
                return new ListParamValue();
            }
            if (this.listValue != null) {
                return this.listValue;
            }
            return this.listValue;
        }

        public void setListValue(ListParamValue v) {
            this.listValue = v;
        }

        public StringParamValue getStringValue() {
            return this.stringValue;
        }

        public void setStringValue(StringParamValue v) {
            this.stringValue = v;
        }

        public MapParamValue getMapValue() {
            return this.mapValue;
        }

        public void setMapValue(MapParamValue v) {
            this.mapValue = v;
        }
    }
}

