/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.ws;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.scheduler2.ComplexJobTrigger;
import org.pentaho.platform.api.scheduler2.IJobTrigger;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.scheduler2.JobTrigger;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.api.scheduler2.SimpleJobTrigger;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.scheduler2.ws.ISchedulerService;
import org.pentaho.platform.scheduler2.ws.ParamValue;
import org.pentaho.platform.scheduler2.ws.StringParamValue;

@WebService(endpointInterface="org.pentaho.platform.scheduler2.ws.ISchedulerService", name="Scheduler", serviceName="Scheduler", portName="SchedulerPort", targetNamespace="http://www.pentaho.org/ws/1.0")
public class DefaultSchedulerService
implements ISchedulerService {
    private static Log logger = LogFactory.getLog(DefaultSchedulerService.class);
    private static final String ADMIN_PERM = "org.pentaho.security.administerSecurity";
    private String defaultActionId;

    public void setDefaultActionId(String defaultActionId) {
        this.defaultActionId = defaultActionId;
    }

    private String getDefaultActionId() {
        return this.defaultActionId == null ? "PdiAction" : this.defaultActionId;
    }

    @Override
    public String createSimpleJob(String jobName, Map<String, ParamValue> jobParams, SimpleJobTrigger trigger) throws SchedulerException {
        return this.createJob(jobName, jobParams, trigger);
    }

    @Override
    public String createComplexJob(String jobName, Map<String, ParamValue> jobParams, ComplexJobTrigger trigger) throws SchedulerException {
        return this.createJob(jobName, jobParams, trigger);
    }

    private String createJob(String jobName, Map<String, ParamValue> jobParams, JobTrigger trigger) throws SchedulerException {
        logger.debug((Object)("Creating job with schedule " + trigger.toString()));
        Job job = null;
        try {
            IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
            Map<String, Serializable> properJobParams = this.toProperMap(jobParams);
            scheduler.validateJobParams(properJobParams);
            job = scheduler.createJob(jobName, this.getDefaultActionId(), properJobParams, (IJobTrigger)trigger);
        }
        catch (SchedulerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return job.getJobId();
    }

    private void updateJob(String jobId, Map<String, ParamValue> jobParams, JobTrigger trigger) throws SchedulerException {
        logger.debug((Object)("Creating job with schedule " + trigger.toString()));
        try {
            IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
            Map<String, Serializable> properJobParams = this.toProperMap(jobParams);
            scheduler.updateJob(jobId, properJobParams, trigger);
        }
        catch (SchedulerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Job[] getJobs() throws SchedulerException {
        IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
        IPentahoSession session = PentahoSessionHolder.getSession();
        String principalName = session.getName();
        Boolean canAdminister = ((IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class)).isAllowed(ADMIN_PERM);
        return scheduler.getJobs(job -> {
            if (canAdminister.booleanValue()) {
                return !"BlockoutAction".equals(job.getJobName());
            }
            return principalName.equals(job.getUserName());
        }).toArray(new Job[0]);
    }

    @Override
    public void pause() throws SchedulerException {
        IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
        scheduler.pause();
    }

    @Override
    public void pauseJob(String jobId) throws SchedulerException {
        IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
        scheduler.pauseJob(jobId);
    }

    @Override
    public void removeJob(String jobId) throws SchedulerException {
        IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
        scheduler.removeJob(jobId);
    }

    @Override
    public void start() throws SchedulerException {
        IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
        scheduler.start();
    }

    @Override
    public void resumeJob(String jobId) throws SchedulerException {
        IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
        scheduler.resumeJob(jobId);
    }

    @Override
    public int getSchedulerStatus() throws SchedulerException {
        IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
        return scheduler.getStatus().ordinal();
    }

    @Override
    public void updateJobToUseSimpleTrigger(String jobId, Map<String, ParamValue> jobParams, SimpleJobTrigger trigger) throws SchedulerException {
        this.updateJob(jobId, jobParams, trigger);
    }

    @Override
    public void updateJobToUseComplexTrigger(String jobId, Map<String, ParamValue> jobParams, ComplexJobTrigger trigger) throws SchedulerException {
        this.updateJob(jobId, jobParams, trigger);
    }

    private Map<String, Serializable> toProperMap(Map<String, ParamValue> liteMap) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        for (Map.Entry<String, ParamValue> entry : liteMap.entrySet()) {
            ParamValue val = entry.getValue();
            if (val instanceof StringParamValue) {
                ret.put(entry.getKey(), (Serializable)((Object)val.toString()));
                continue;
            }
            ret.put(entry.getKey(), (Serializable)((Object)val));
        }
        return ret;
    }
}

