/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.quartz;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.action.IActionInvokeStatus;
import org.pentaho.platform.api.action.IActionInvoker;
import org.pentaho.platform.api.scheduler2.IBackgroundExecutionStreamProvider;
import org.pentaho.platform.api.scheduler2.IJobTrigger;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.JobTrigger;
import org.pentaho.platform.api.scheduler2.SimpleJobTrigger;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.scheduler2.action.DefaultActionInvoker;
import org.pentaho.platform.scheduler2.blockout.BlockoutAction;
import org.pentaho.platform.scheduler2.messsages.Messages;
import org.pentaho.platform.scheduler2.quartz.QuartzJobKey;
import org.pentaho.platform.scheduler2.quartz.QuartzScheduler;
import org.pentaho.platform.scheduler2.ws.ListParamValue;
import org.pentaho.platform.scheduler2.ws.MapParamValue;
import org.pentaho.platform.scheduler2.ws.StringParamValue;
import org.pentaho.platform.util.ActionUtil;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.workitem.WorkItemLifecycleEventUtil;
import org.pentaho.platform.workitem.WorkItemLifecyclePhase;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ActionAdapterQuartzJob
implements Job {
    static final Log log = LogFactory.getLog(ActionAdapterQuartzJob.class);
    private IActionInvoker actionInvoker = new DefaultActionInvoker();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        String actionUser = jobDataMap.getString("ActionAdapterQuartzJob-ActionUser");
        String actionClassName = jobDataMap.getString("ActionAdapterQuartzJob-ActionClass");
        String actionId = jobDataMap.getString("ActionAdapterQuartzJob-ActionId");
        try {
            this.invokeAction(actionClassName, actionId, actionUser, context, jobDataMap.getWrappedMap());
        }
        catch (Throwable t) {
            throw new LoggingJobExecutionException(Messages.getInstance().getErrorString("ActionAdapterQuartzJob.ERROR_0004_ACTION_FAILED", new Object[]{ActionAdapterQuartzJob.getActionIdentifier(null, actionClassName, actionId)}), t);
        }
    }

    private static String getActionIdentifier(IAction actionBean, String actionClassName, String actionId) {
        if (actionBean != null) {
            return actionBean.getClass().getName();
        }
        if (!StringUtil.isEmpty((String)actionClassName)) {
            return actionClassName;
        }
        if (!StringUtil.isEmpty((String)actionId)) {
            return actionId;
        }
        return "?";
    }

    @Deprecated
    protected void invokeAction(IAction actionBean, String actionUser, JobExecutionContext context, Map<String, Serializable> params) throws Exception {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        String actionClass = jobDataMap.getString("ActionAdapterQuartzJob-ActionClass");
        String actionId = jobDataMap.getString("ActionAdapterQuartzJob-ActionId");
        this.invokeAction(actionClass, actionId, actionUser, context, params);
    }

    private static Map<String, Serializable> getSerializableMap(Map<String, Serializable> originalMap) {
        HashMap<String, Serializable> serializableMap = new HashMap<String, Serializable>();
        for (Map.Entry<String, Serializable> entry : originalMap.entrySet()) {
            String key = entry.getKey();
            Serializable value = entry.getValue();
            if (value instanceof MapParamValue) {
                serializableMap.put(key, new HashMap<String, String>((MapParamValue)value));
                continue;
            }
            if (value instanceof ListParamValue) {
                serializableMap.put(key, new ArrayList<String>((ListParamValue)value));
                continue;
            }
            if (value instanceof StringParamValue) {
                serializableMap.put(key, (Serializable)((Object)((StringParamValue)((Object)value)).getStringValue()));
                continue;
            }
            serializableMap.put(key, value);
        }
        return serializableMap;
    }

    protected void invokeAction(String actionClassName, String actionId, String actionUser, final JobExecutionContext context, final Map<String, Serializable> params) throws Exception {
        IActionInvokeStatus status;
        final String workItemName = ActionUtil.extractName(params);
        WorkItemLifecycleEventUtil.publish((String)workItemName, params, (WorkItemLifecyclePhase)WorkItemLifecyclePhase.SUBMITTED);
        IActionInvoker actionInvoker = (IActionInvoker)Optional.ofNullable(PentahoSystem.get(IActionInvoker.class)).orElse(this.getActionInvoker());
        IAction actionBean = ActionUtil.createActionBean((String)actionClassName, (String)actionId);
        if (actionInvoker == null || actionBean == null) {
            String failureMessage = Messages.getInstance().getErrorString("ActionAdapterQuartzJob.ERROR_0002_FAILED_TO_CREATE_ACTION", new Object[]{ActionAdapterQuartzJob.getActionIdentifier(null, actionClassName, actionId), StringUtil.getMapAsPrettyString(params)});
            WorkItemLifecycleEventUtil.publish((String)workItemName, params, (WorkItemLifecyclePhase)WorkItemLifecyclePhase.FAILED, (String)failureMessage);
            throw new LoggingJobExecutionException(failureMessage);
        }
        if (actionBean instanceof BlockoutAction) {
            params.put("scheduledFireTime", context.getScheduledFireTime());
        }
        if ((status = actionInvoker.invokeAction(actionBean, actionUser, ActionAdapterQuartzJob.getSerializableMap(params))) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)Messages.getInstance().getErrorString("ActionAdapterQuartzJob.WARN_0002_NO_STATUS", new Object[]{ActionAdapterQuartzJob.getActionIdentifier(actionBean, actionClassName, actionId), StringUtil.getMapAsPrettyString(params)}));
            }
            return;
        }
        if (!status.isExecutionSuccessful()) {
            throw new JobExecutionException(Messages.getInstance().getActionFailedToExecute(actionBean.getClass().getName()));
        }
        boolean requiresUpdate = status.requiresUpdate();
        Throwable throwable = status.getThrowable();
        Object objsp = status.getStreamProvider();
        IBackgroundExecutionStreamProvider sp = null;
        if (objsp != null && IBackgroundExecutionStreamProvider.class.isAssignableFrom(objsp.getClass())) {
            sp = (IBackgroundExecutionStreamProvider)objsp;
        }
        final IBackgroundExecutionStreamProvider streamProvider = sp;
        final HashMap<String, Serializable> jobParams = new HashMap<String, Serializable>(params);
        final IScheduler scheduler = (IScheduler)PentahoSystem.getObjectFactory().get(IScheduler.class, "IScheduler2", null);
        if (throwable != null) {
            Object restartFlag = jobParams.get("ActionAdapterQuartzJob-Restart");
            if (restartFlag == null) {
                final SimpleJobTrigger trigger = new SimpleJobTrigger(new Date(), null, 0, 0L);
                final Class<?> iaction = actionBean.getClass();
                SecurityHelper.getInstance().runAsUser(actionUser, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (streamProvider != null) {
                            streamProvider.setStreamingAction(null);
                        }
                        QuartzJobKey jobKey = QuartzJobKey.parse(context.getJobDetail().getName());
                        String jobName = jobKey.getJobName();
                        jobParams.put("ActionAdapterQuartzJob-Restart", Boolean.TRUE);
                        WorkItemLifecycleEventUtil.publish((String)workItemName, (Map)params, (WorkItemLifecyclePhase)WorkItemLifecyclePhase.RESTARTED);
                        scheduler.createJob(jobName, iaction, (Map<String, Serializable>)jobParams, (IJobTrigger)trigger, streamProvider);
                        log.warn((Object)("New RunOnce job created for " + jobName + " -> possible startup synchronization error"));
                        return null;
                    }
                });
            } else {
                log.warn((Object)"RunOnce already created, skipping");
            }
            throw new JobExecutionException(throwable);
        }
        scheduler.fireJobCompleted(actionBean, actionUser, params, streamProvider);
        if (requiresUpdate) {
            log.warn((Object)("Output path for job: " + context.getJobDetail().getName() + " has changed. Job requires update"));
            try {
                final JobTrigger trigger = scheduler.getJob(context.getJobDetail().getName()).getJobTrigger();
                final Class<?> iaction = actionBean.getClass();
                scheduler.removeJob(context.getJobDetail().getName());
                SecurityHelper.getInstance().runAsUser(actionUser, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        streamProvider.setStreamingAction(null);
                        QuartzJobKey jobKey = QuartzJobKey.parse(context.getJobDetail().getName());
                        String jobName = jobKey.getJobName();
                        WorkItemLifecycleEventUtil.publish((String)workItemName, (Map)params, (WorkItemLifecyclePhase)WorkItemLifecyclePhase.RESTARTED);
                        org.pentaho.platform.api.scheduler2.Job j = scheduler.createJob(jobName, iaction, (Map<String, Serializable>)jobParams, trigger, streamProvider);
                        log.warn((Object)("New Job: " + j.getJobId() + " created"));
                        return null;
                    }
                });
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Scheduling system successfully invoked action {0} as user {1} with params [ {2} ]", actionBean.getClass().getName(), actionUser, QuartzScheduler.prettyPrintMap(params)));
        }
    }

    public IActionInvoker getActionInvoker() {
        return this.actionInvoker;
    }

    public void setActionInvoker(IActionInvoker actionInvoker) {
        this.actionInvoker = actionInvoker;
    }

    class LoggingJobExecutionException
    extends JobExecutionException {
        private static final long serialVersionUID = -4124907454208034326L;

        public LoggingJobExecutionException(String msg) {
            super(msg);
            log.error((Object)msg);
        }

        public LoggingJobExecutionException(String msg, Throwable t) {
            super(msg, t);
            log.error((Object)msg, t);
        }
    }
}

