/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.action;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.action.ActionInvokeStatus;
import org.pentaho.platform.api.action.ActionInvocationException;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.action.IActionInvokeStatus;
import org.pentaho.platform.api.action.IActionInvoker;
import org.pentaho.platform.api.scheduler2.IBackgroundExecutionStreamProvider;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.scheduler2.action.ActionRunner;
import org.pentaho.platform.scheduler2.messsages.Messages;
import org.pentaho.platform.util.ActionUtil;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.workitem.WorkItemLifecycleEventUtil;
import org.pentaho.platform.workitem.WorkItemLifecyclePhase;

public class DefaultActionInvoker
implements IActionInvoker {
    private static final Log logger = LogFactory.getLog(DefaultActionInvoker.class);

    protected IBackgroundExecutionStreamProvider getStreamProvider(Map<String, Serializable> params) {
        if (params == null) {
            logger.warn((Object)Messages.getInstance().getMapNullCantReturnSp());
            return null;
        }
        Serializable obj = params.get("ActionAdapterQuartzJob-StreamProvider");
        return obj instanceof IBackgroundExecutionStreamProvider ? (IBackgroundExecutionStreamProvider)obj : null;
    }

    public void validate(IAction actionBean, String actionUser, Map<String, Serializable> params) throws ActionInvocationException {
        String workItemName = ActionUtil.extractName(params);
        if (actionBean == null || params == null) {
            String failureMessage = Messages.getInstance().getCantInvokeNullAction();
            WorkItemLifecycleEventUtil.publish((String)workItemName, params, (WorkItemLifecyclePhase)WorkItemLifecyclePhase.FAILED, (String)failureMessage);
            throw new ActionInvocationException(failureMessage);
        }
        if (!this.isSupportedAction(actionBean)) {
            String failureMessage = Messages.getInstance().getUnsupportedAction(actionBean.getClass().getName());
            WorkItemLifecycleEventUtil.publish((String)workItemName, params, (WorkItemLifecyclePhase)WorkItemLifecyclePhase.FAILED, (String)failureMessage);
            throw new ActionInvocationException(failureMessage);
        }
    }

    public IActionInvokeStatus invokeAction(IAction actionBean, String actionUser, Map<String, Serializable> params) throws Exception {
        this.validate(actionBean, actionUser, params);
        return this.invokeActionImpl(actionBean, actionUser, params);
    }

    protected IActionInvokeStatus invokeActionImpl(IAction actionBean, String actionUser, Map<String, Serializable> params) throws Exception {
        String workItemName = ActionUtil.extractName(params);
        if (actionBean == null || params == null) {
            String failureMessage = Messages.getInstance().getCantInvokeNullAction();
            WorkItemLifecycleEventUtil.publish((String)workItemName, params, (WorkItemLifecyclePhase)WorkItemLifecyclePhase.FAILED, (String)failureMessage);
            throw new ActionInvocationException(failureMessage);
        }
        WorkItemLifecycleEventUtil.publish((String)workItemName, params, (WorkItemLifecyclePhase)WorkItemLifecyclePhase.IN_PROGRESS);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Messages.getInstance().getRunningInBackgroundLocally(actionBean.getClass().getName(), params));
        }
        if (params.get("user_locale") == null || StringUtils.isEmpty((String)params.get("user_locale").toString())) {
            params.put("user_locale", LocaleHelper.getLocale());
        }
        ActionUtil.removeKeyFromMap(params, (String)"actionClass");
        ActionUtil.removeKeyFromMap(params, (String)"actionId");
        ActionUtil.removeKeyFromMap(params, (String)"actionUser");
        IBackgroundExecutionStreamProvider streamProvider = this.getStreamProvider(params);
        ActionUtil.removeKeyFromMap(params, (String)"streamProvider");
        ActionUtil.removeKeyFromMap(params, (String)"uiPassParam");
        ActionRunner actionBeanRunner = new ActionRunner(actionBean, actionUser, params, streamProvider);
        ActionInvokeStatus status = new ActionInvokeStatus();
        status.setStreamProvider((Object)streamProvider);
        boolean requiresUpdate = false;
        try {
            requiresUpdate = StringUtil.isEmpty((String)actionUser) || actionUser.equals("system session") ? ((Boolean)SecurityHelper.getInstance().runAsAnonymous((Callable)actionBeanRunner)).booleanValue() : ((Boolean)SecurityHelper.getInstance().runAsUser(actionUser, (Callable)actionBeanRunner)).booleanValue();
        }
        catch (Throwable t) {
            WorkItemLifecycleEventUtil.publish((String)workItemName, params, (WorkItemLifecyclePhase)WorkItemLifecyclePhase.FAILED, (String)t.toString());
            status.setThrowable(t);
        }
        status.setRequiresUpdate(requiresUpdate);
        status.setExecutionStatus(actionBean.isExecutionSuccessful());
        return status;
    }

    public boolean isSupportedAction(IAction action) {
        return true;
    }
}

