/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.scheduler2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.pentaho.platform.api.scheduler2.JobParam;
import org.pentaho.platform.api.scheduler2.JobParams;

public class JobParamsAdapter
extends XmlAdapter<JobParams, Map<String, Serializable>> {
    private static final String VARIABLES = "variables";
    private static final String PARAMETERS = "parameters";

    public JobParams marshal(Map<String, Serializable> v) throws Exception {
        Serializable variables = v.get(VARIABLES);
        Serializable parameters = v.get(PARAMETERS);
        if (parameters != null && parameters instanceof Map && variables != null && variables instanceof Map) {
            Map paramMap = (Map)((Object)parameters);
            Map variableMap = (Map)((Object)variables);
            if (!paramMap.isEmpty() && !variableMap.isEmpty()) {
                for (Map.Entry paramEntry : paramMap.entrySet()) {
                    if (!variableMap.containsKey(paramEntry.getKey()) || paramEntry.getValue() == null) continue;
                    variableMap.remove(paramEntry.getKey());
                }
            }
        }
        ArrayList<JobParam> params = new ArrayList<JobParam>();
        for (Map.Entry<String, Serializable> entry : v.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            if (entry.getValue() instanceof Collection) {
                for (Object iValue : (Collection)((Object)entry.getValue())) {
                    if (iValue == null) continue;
                    JobParam jobParam = new JobParam();
                    jobParam.name = entry.getKey();
                    jobParam.value = iValue.toString();
                    params.add(jobParam);
                }
                continue;
            }
            if (entry.getValue() instanceof Map) {
                ((Map)((Object)entry.getValue())).forEach((key, value) -> {
                    if (value != null) {
                        JobParam jobParam = new JobParam();
                        jobParam.name = key;
                        jobParam.value = value.toString();
                        params.add(jobParam);
                    }
                });
                continue;
            }
            JobParam jobParam = new JobParam();
            jobParam.name = entry.getKey();
            jobParam.value = entry.getValue().toString();
            params.add(jobParam);
        }
        JobParams jobParams = new JobParams();
        jobParams.jobParams = params.toArray(new JobParam[0]);
        return jobParams;
    }

    public Map<String, Serializable> unmarshal(JobParams v) throws Exception {
        HashMap<String, ArrayList<String>> draftParamMap = new HashMap<String, ArrayList<String>>();
        for (JobParam jobParam : v.jobParams) {
            ArrayList<String> p = (ArrayList<String>)draftParamMap.get(jobParam.name);
            if (p == null) {
                p = new ArrayList<String>();
                draftParamMap.put(jobParam.name, p);
            }
            p.add(jobParam.value);
        }
        HashMap<String, Serializable> paramMap = new HashMap<String, Serializable>();
        for (String paramName : draftParamMap.keySet()) {
            ArrayList p = (ArrayList)draftParamMap.get(paramName);
            if (p.size() == 1) {
                paramMap.put(paramName, (Serializable)p.get(0));
                continue;
            }
            paramMap.put(paramName, p);
        }
        return paramMap;
    }
}

