/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.scheduler2;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.pentaho.platform.api.scheduler2.JobTrigger;
import org.pentaho.platform.api.scheduler2.recur.ITimeRecurrence;
import org.pentaho.platform.api.scheduler2.wrappers.DayOfMonthWrapper;
import org.pentaho.platform.api.scheduler2.wrappers.DayOfWeekWrapper;
import org.pentaho.platform.api.scheduler2.wrappers.HourlyWrapper;
import org.pentaho.platform.api.scheduler2.wrappers.ITimeWrapper;
import org.pentaho.platform.api.scheduler2.wrappers.MinuteWrapper;
import org.pentaho.platform.api.scheduler2.wrappers.MonthlyWrapper;
import org.pentaho.platform.api.scheduler2.wrappers.SecondWrapper;
import org.pentaho.platform.api.scheduler2.wrappers.YearlyWrapper;
import org.pentaho.platform.scheduler2.quartz.QuartzCronStringFactory;
import org.pentaho.platform.scheduler2.recur.RecurrenceList;
import org.pentaho.platform.scheduler2.recur.SequentialRecurrence;

@XmlRootElement
public class ComplexJobTrigger
extends JobTrigger {
    private static final long serialVersionUID = -2742874361158319735L;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    private YearlyWrapper yearlyRecurrences = new YearlyWrapper();
    private MonthlyWrapper monthlyRecurrences = new MonthlyWrapper();
    private DayOfMonthWrapper dayOfMonthRecurrences = new DayOfMonthWrapper();
    private DayOfWeekWrapper dayOfWeekRecurrences = new DayOfWeekWrapper();
    private HourlyWrapper hourlyRecurrences = new HourlyWrapper();
    private MinuteWrapper minuteRecurrences = new MinuteWrapper();
    private SecondWrapper secondRecurrences = new SecondWrapper();

    public ComplexJobTrigger(Integer year, Integer month, Integer dayOfMonth, Integer dayOfWeek, Integer hourOfDay) {
        this();
        this.setYearlyRecurrence(year);
        this.setMonthlyRecurrence(month);
        if (dayOfMonth != null && dayOfWeek == null) {
            this.setDayOfMonthRecurrence(dayOfMonth);
        }
        if (dayOfMonth == null && dayOfWeek != null) {
            this.setDayOfWeekRecurrence(dayOfWeek);
        }
        this.setHourlyRecurrence(hourOfDay);
    }

    public ComplexJobTrigger() {
        this.setHourlyRecurrence(0);
        this.setMinuteRecurrence(0);
        this.setSecondRecurrence(0);
    }

    private void setRecurrences(ITimeWrapper theList, Integer ... recurrences) {
        theList.clear();
        this.addRecurrences(theList, recurrences);
    }

    private void addRecurrences(ITimeWrapper theList, Integer ... recurrences) {
        List<Object> nonNullRecurrences;
        List<Object> list = nonNullRecurrences = recurrences == null ? new ArrayList() : this.filterNulls(recurrences);
        if (nonNullRecurrences.size() == 0) {
            return;
        }
        if (nonNullRecurrences.size() == 1) {
            theList.add(new RecurrenceList((Integer)nonNullRecurrences.get(0)));
        } else if (nonNullRecurrences.size() == 2) {
            TreeSet<Object> sortedRecurrences = new TreeSet<Object>(nonNullRecurrences);
            theList.add(new RecurrenceList(sortedRecurrences.toArray(new Integer[0])));
        } else {
            TreeSet<Object> sortedRecurrences = new TreeSet<Object>(nonNullRecurrences);
            Integer previourOcurrence = null;
            boolean isSequential = true;
            for (Integer n : sortedRecurrences) {
                if (previourOcurrence != null && n != previourOcurrence + 1) {
                    isSequential = false;
                    break;
                }
                previourOcurrence = n;
            }
            if (isSequential) {
                theList.add(new SequentialRecurrence((Integer)sortedRecurrences.first(), (Integer)sortedRecurrences.last()));
            } else {
                theList.add(new RecurrenceList(sortedRecurrences.toArray(new Integer[0])));
            }
        }
    }

    public void addYearlyRecurrence(ITimeRecurrence recurrence) {
        if (recurrence != null) {
            this.yearlyRecurrences.add(recurrence);
        }
    }

    public void addYearlyRecurrence(Integer ... recurrence) {
        this.addRecurrences(this.yearlyRecurrences, recurrence);
    }

    public void setYearlyRecurrence(ITimeRecurrence recurrence) {
        this.yearlyRecurrences.clear();
        if (recurrence != null) {
            this.yearlyRecurrences.add(recurrence);
        }
    }

    public void setYearlyRecurrence(Integer ... recurrence) {
        this.setRecurrences(this.yearlyRecurrences, recurrence);
    }

    public void addMonthlyRecurrence(ITimeRecurrence recurrence) {
        if (recurrence != null) {
            this.monthlyRecurrences.add(recurrence);
        }
    }

    public void addMonthlyRecurrence(Integer ... recurrence) {
        this.addRecurrences(this.monthlyRecurrences, recurrence);
    }

    public void setMonthlyRecurrence(ITimeRecurrence recurrence) {
        this.monthlyRecurrences.clear();
        if (recurrence != null) {
            this.monthlyRecurrences.add(recurrence);
        }
    }

    public void setMonthlyRecurrence(Integer ... recurrence) {
        this.setRecurrences(this.monthlyRecurrences, recurrence);
    }

    public void addDayOfMonthRecurrence(ITimeRecurrence recurrence) {
        if (recurrence != null) {
            this.dayOfMonthRecurrences.add(recurrence);
            this.dayOfWeekRecurrences.clear();
        }
    }

    public void addDayOfMonthRecurrence(Integer ... recurrence) {
        this.addRecurrences(this.dayOfMonthRecurrences, recurrence);
        this.dayOfWeekRecurrences.clear();
    }

    public void setDayOfMonthRecurrence(ITimeRecurrence recurrence) {
        this.dayOfMonthRecurrences.clear();
        if (recurrence != null) {
            this.dayOfMonthRecurrences.add(recurrence);
            this.dayOfWeekRecurrences.clear();
        }
    }

    public void setDayOfMonthRecurrence(Integer ... recurrence) {
        this.setRecurrences(this.dayOfMonthRecurrences, recurrence);
        if (this.dayOfMonthRecurrences.size() > 0) {
            this.dayOfWeekRecurrences.clear();
        }
    }

    public void addDayOfWeekRecurrence(ITimeRecurrence recurrence) {
        if (recurrence != null) {
            this.dayOfWeekRecurrences.add(recurrence);
            this.dayOfMonthRecurrences.clear();
        }
    }

    public void addDayOfWeekRecurrence(Integer ... recurrence) {
        this.addRecurrences(this.dayOfWeekRecurrences, recurrence);
        this.dayOfMonthRecurrences.clear();
    }

    public void setDayOfWeekRecurrence(ITimeRecurrence recurrence) {
        this.dayOfWeekRecurrences.clear();
        if (recurrence != null) {
            this.dayOfWeekRecurrences.add(recurrence);
            this.dayOfMonthRecurrences.clear();
        }
    }

    public void setDayOfWeekRecurrence(Integer ... recurrence) {
        this.setRecurrences(this.dayOfWeekRecurrences, recurrence);
        if (this.dayOfWeekRecurrences.size() > 0) {
            this.dayOfMonthRecurrences.clear();
        }
    }

    public void addHourlyRecurrence(ITimeRecurrence recurrence) {
        if (recurrence != null) {
            this.hourlyRecurrences.add(recurrence);
        }
    }

    public void addHourlyRecurrence(Integer ... recurrence) {
        this.addRecurrences(this.hourlyRecurrences, recurrence);
    }

    public void setHourlyRecurrence(ITimeRecurrence recurrence) {
        this.hourlyRecurrences.clear();
        if (recurrence != null) {
            this.hourlyRecurrences.add(recurrence);
        }
    }

    public void setHourlyRecurrence(Integer ... recurrence) {
        this.setRecurrences(this.hourlyRecurrences, recurrence);
    }

    public void addMinuteRecurrence(ITimeRecurrence recurrence) {
        if (recurrence != null) {
            this.minuteRecurrences.add(recurrence);
        }
    }

    public void addMinuteRecurrence(Integer ... recurrence) {
        this.addRecurrences(this.minuteRecurrences, recurrence);
    }

    public void setMinuteRecurrence(ITimeRecurrence recurrence) {
        this.minuteRecurrences.clear();
        if (recurrence != null) {
            this.minuteRecurrences.add(recurrence);
        }
    }

    public void setMinuteRecurrence(Integer ... recurrence) {
        this.setRecurrences(this.minuteRecurrences, recurrence);
    }

    public void addSecondRecurrence(ITimeRecurrence recurrence) {
        if (recurrence != null) {
            this.secondRecurrences.add(recurrence);
        }
    }

    public void addSecondRecurrence(Integer ... recurrence) {
        this.addRecurrences(this.secondRecurrences, recurrence);
    }

    public void setSecondRecurrence(ITimeRecurrence recurrence) {
        this.secondRecurrences.clear();
        if (recurrence != null) {
            this.secondRecurrences.add(recurrence);
        }
    }

    public void setSecondRecurrence(Integer ... recurrence) {
        this.setRecurrences(this.secondRecurrences, recurrence);
    }

    @XmlElement
    public YearlyWrapper getYearlyRecurrences() {
        return this.yearlyRecurrences;
    }

    @XmlElement
    public MonthlyWrapper getMonthlyRecurrences() {
        return this.monthlyRecurrences;
    }

    @XmlElement
    public DayOfMonthWrapper getDayOfMonthRecurrences() {
        return this.dayOfMonthRecurrences;
    }

    @XmlElement
    public DayOfWeekWrapper getDayOfWeekRecurrences() {
        return this.dayOfWeekRecurrences;
    }

    @XmlElement
    public SecondWrapper getSecondRecurrences() {
        return this.secondRecurrences;
    }

    @XmlElement
    public HourlyWrapper getHourlyRecurrences() {
        return this.hourlyRecurrences;
    }

    @XmlElement
    public MinuteWrapper getMinuteRecurrences() {
        return this.minuteRecurrences;
    }

    private void setYearlyRecurrences(YearlyWrapper yearlyRecurrences) {
        this.yearlyRecurrences = yearlyRecurrences;
    }

    private void setMonthlyRecurrences(MonthlyWrapper monthlyRecurrences) {
        this.monthlyRecurrences = monthlyRecurrences;
    }

    private void setDayOfMonthRecurrences(DayOfMonthWrapper dayOfMonthRecurrences) {
        this.dayOfMonthRecurrences = dayOfMonthRecurrences;
    }

    private void setDayOfWeekRecurrences(DayOfWeekWrapper dayOfWeekRecurrences) {
        this.dayOfWeekRecurrences = dayOfWeekRecurrences;
    }

    private void setHourlyRecurrences(HourlyWrapper hourlyRecurrences) {
        this.hourlyRecurrences = hourlyRecurrences;
    }

    private void setMinuteRecurrences(MinuteWrapper minuteRecurrences) {
        this.minuteRecurrences = minuteRecurrences;
    }

    private void setSecondRecurrences(SecondWrapper secondRecurrences) {
        this.secondRecurrences = secondRecurrences;
    }

    public String toString() {
        return QuartzCronStringFactory.createCronString(this);
    }

    private <U> List<U> filterNulls(U[] args) {
        ArrayList<U> nonNullArgs = new ArrayList<U>();
        for (U recurrence : args) {
            if (recurrence == null) continue;
            nonNullArgs.add(recurrence);
        }
        return nonNullArgs;
    }
}

