/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapOutputFormat;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.DelimitedJSONSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlanUtils {
    protected static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.hive.ql.plan.PlanUtils");
    private static long countForMapJoinDumpFilePrefix = 0L;

    public static synchronized long getCountForMapJoinDumpFilePrefix() {
        return countForMapJoinDumpFilePrefix++;
    }

    public static MapredWork getMapRedWork() {
        return new MapredWork();
    }

    public static TableDesc getDefaultTableDesc(CreateTableDesc directoryDesc, String cols, String colTypes) {
        TableDesc ret = PlanUtils.getDefaultTableDesc(Integer.toString(1), cols, colTypes, false);
        if (directoryDesc == null) {
            return ret;
        }
        try {
            Properties properties = ret.getProperties();
            if (directoryDesc.getFieldDelim() != null) {
                properties.setProperty("field.delim", directoryDesc.getFieldDelim());
                properties.setProperty("serialization.format", directoryDesc.getFieldDelim());
            }
            if (directoryDesc.getLineDelim() != null) {
                properties.setProperty("line.delim", directoryDesc.getLineDelim());
            }
            if (directoryDesc.getCollItemDelim() != null) {
                properties.setProperty("colelction.delim", directoryDesc.getCollItemDelim());
            }
            if (directoryDesc.getMapKeyDelim() != null) {
                properties.setProperty("mapkey.delim", directoryDesc.getMapKeyDelim());
            }
            if (directoryDesc.getFieldEscape() != null) {
                properties.setProperty("escape.delim", directoryDesc.getFieldEscape());
            }
            if (directoryDesc.getSerName() != null) {
                properties.setProperty("serialization.lib", directoryDesc.getSerName());
            }
            if (directoryDesc.getSerdeProps() != null) {
                properties.putAll(directoryDesc.getSerdeProps());
            }
            if (directoryDesc.getOutputFormat() != null) {
                ret.setOutputFileFormatClass(JavaUtils.loadClass((String)directoryDesc.getOutputFormat()));
            }
            if (directoryDesc.getNullFormat() != null) {
                properties.setProperty("serialization.null.format", directoryDesc.getNullFormat());
            }
            if (directoryDesc.getTblProps() != null) {
                properties.putAll(directoryDesc.getTblProps());
            }
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Unable to find class in getDefaultTableDesc: " + e.getMessage(), (Throwable)e);
            return null;
        }
        return ret;
    }

    public static TableDesc getDefaultTableDesc(String separatorCode, String columns) {
        return PlanUtils.getDefaultTableDesc(separatorCode, columns, false);
    }

    public static TableDesc getTableDesc(Class<? extends Deserializer> serdeClass, String separatorCode, String columns) {
        return PlanUtils.getTableDesc(serdeClass, separatorCode, columns, false);
    }

    public static TableDesc getDefaultTableDesc(String separatorCode, String columns, boolean lastColumnTakesRestOfTheLine) {
        return PlanUtils.getDefaultTableDesc(separatorCode, columns, null, lastColumnTakesRestOfTheLine);
    }

    public static TableDesc getTableDesc(Class<? extends Deserializer> serdeClass, String separatorCode, String columns, boolean lastColumnTakesRestOfTheLine) {
        return PlanUtils.getTableDesc(serdeClass, separatorCode, columns, null, lastColumnTakesRestOfTheLine);
    }

    public static TableDesc getDefaultTableDesc(String separatorCode, String columns, String columnTypes, boolean lastColumnTakesRestOfTheLine) {
        return PlanUtils.getTableDesc(LazySimpleSerDe.class, separatorCode, columns, columnTypes, lastColumnTakesRestOfTheLine);
    }

    public static TableDesc getTableDesc(Class<? extends Deserializer> serdeClass, String separatorCode, String columns, String columnTypes, boolean lastColumnTakesRestOfTheLine) {
        return PlanUtils.getTableDesc(serdeClass, separatorCode, columns, columnTypes, lastColumnTakesRestOfTheLine, false);
    }

    public static TableDesc getTableDesc(Class<? extends Deserializer> serdeClass, String separatorCode, String columns, String columnTypes, boolean lastColumnTakesRestOfTheLine, boolean useDelimitedJSON) {
        return PlanUtils.getTableDesc(serdeClass, separatorCode, columns, columnTypes, lastColumnTakesRestOfTheLine, useDelimitedJSON, "TextFile");
    }

    public static TableDesc getTableDesc(Class<? extends Deserializer> serdeClass, String separatorCode, String columns, String columnTypes, boolean lastColumnTakesRestOfTheLine, boolean useDelimitedJSON, String fileFormat) {
        Class outputFormat;
        Class inputFormat;
        Properties properties = Utilities.makeProperties("serialization.format", separatorCode, "columns", columns);
        if (!separatorCode.equals(Integer.toString(1))) {
            properties.setProperty("field.delim", separatorCode);
        }
        if (columnTypes != null) {
            properties.setProperty("columns.types", columnTypes);
        }
        if (lastColumnTakesRestOfTheLine) {
            properties.setProperty("serialization.last.column.takes.rest", "true");
        }
        if (useDelimitedJSON) {
            serdeClass = DelimitedJSONSerDe.class;
        }
        if ("SequenceFile".equalsIgnoreCase(fileFormat)) {
            inputFormat = SequenceFileInputFormat.class;
            outputFormat = SequenceFileOutputFormat.class;
        } else if ("RCFile".equalsIgnoreCase(fileFormat)) {
            inputFormat = RCFileInputFormat.class;
            outputFormat = RCFileOutputFormat.class;
            assert (serdeClass == ColumnarSerDe.class);
        } else if ("Llap".equalsIgnoreCase(fileFormat)) {
            inputFormat = TextInputFormat.class;
            outputFormat = LlapOutputFormat.class;
            properties.setProperty("storage_handler", "org.apache.hadoop.hive.llap.LlapStorageHandler");
        } else {
            inputFormat = TextInputFormat.class;
            outputFormat = IgnoreKeyTextOutputFormat.class;
        }
        properties.setProperty("serialization.lib", serdeClass.getName());
        return new TableDesc(inputFormat, outputFormat, properties);
    }

    public static TableDesc getDefaultQueryOutputTableDesc(String cols, String colTypes, String fileFormat, Class<? extends Deserializer> serdeClass) {
        TableDesc tblDesc = PlanUtils.getTableDesc(serdeClass, "1", cols, colTypes, false, false, fileFormat);
        tblDesc.getProperties().setProperty("escape.delim", "\\");
        tblDesc.getProperties().setProperty("serialization.escape.crlf", "true");
        tblDesc.getProperties().setProperty("hive.serialization.extend.additional.nesting.levels", "true");
        return tblDesc;
    }

    public static TableDesc getTableDesc(CreateTableDesc crtTblDesc, String cols, String colTypes) {
        TableDesc ret;
        Class serdeClass = LazySimpleSerDe.class;
        String separatorCode = Integer.toString(1);
        String columns = cols;
        String columnTypes = colTypes;
        boolean lastColumnTakesRestOfTheLine = false;
        try {
            if (crtTblDesc.getSerName() != null) {
                Class c;
                serdeClass = c = JavaUtils.loadClass((String)crtTblDesc.getSerName());
            }
            if (crtTblDesc.getFieldDelim() != null) {
                separatorCode = crtTblDesc.getFieldDelim();
            }
            ret = PlanUtils.getTableDesc(serdeClass, separatorCode, columns, columnTypes, lastColumnTakesRestOfTheLine, false);
            Properties properties = ret.getProperties();
            if (crtTblDesc.getCollItemDelim() != null) {
                properties.setProperty("colelction.delim", crtTblDesc.getCollItemDelim());
            }
            if (crtTblDesc.getMapKeyDelim() != null) {
                properties.setProperty("mapkey.delim", crtTblDesc.getMapKeyDelim());
            }
            if (crtTblDesc.getFieldEscape() != null) {
                properties.setProperty("escape.delim", crtTblDesc.getFieldEscape());
            }
            if (crtTblDesc.getLineDelim() != null) {
                properties.setProperty("line.delim", crtTblDesc.getLineDelim());
            }
            if (crtTblDesc.getNullFormat() != null) {
                properties.setProperty("serialization.null.format", crtTblDesc.getNullFormat());
            }
            if (crtTblDesc.getTableName() != null && crtTblDesc.getDatabaseName() != null) {
                properties.setProperty("name", crtTblDesc.getTableName());
            }
            if (crtTblDesc.getTblProps() != null) {
                properties.putAll(crtTblDesc.getTblProps());
            }
            if (crtTblDesc.getSerdeProps() != null) {
                properties.putAll(crtTblDesc.getSerdeProps());
            }
            Class c1 = JavaUtils.loadClass((String)crtTblDesc.getInputFormat());
            Class c2 = JavaUtils.loadClass((String)crtTblDesc.getOutputFormat());
            Class in_class = c1;
            Class out_class = c2;
            ret.setInputFileFormatClass(in_class);
            ret.setOutputFileFormatClass(out_class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to find class in getTableDesc: " + e.getMessage(), e);
        }
        return ret;
    }

    public static TableDesc getDefaultTableDesc(String separatorCode) {
        return new TableDesc(TextInputFormat.class, IgnoreKeyTextOutputFormat.class, Utilities.makeProperties("serialization.format", separatorCode, "serialization.lib", MetadataTypedColumnsetSerDe.class.getName()));
    }

    public static TableDesc getReduceKeyTableDesc(List<FieldSchema> fieldSchemas, String order, String nullOrder) {
        return new TableDesc(SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "serialization.sort.order", order, "serialization.sort.order.null", nullOrder, "serialization.lib", BinarySortableSerDe.class.getName()));
    }

    public static TableDesc getMapJoinKeyTableDesc(Configuration conf, List<FieldSchema> fieldSchemas) {
        if (HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
            StringBuilder order = new StringBuilder();
            StringBuilder nullOrder = new StringBuilder();
            for (FieldSchema f : fieldSchemas) {
                order.append("+");
                nullOrder.append("a");
            }
            return new TableDesc(SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "serialization.sort.order", order.toString(), "serialization.sort.order.null", nullOrder.toString(), "serialization.lib", BinarySortableSerDe.class.getName()));
        }
        return new TableDesc(SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "escape.delim", "\\", "serialization.lib", LazyBinarySerDe.class.getName()));
    }

    public static TableDesc getMapJoinValueTableDesc(List<FieldSchema> fieldSchemas) {
        return new TableDesc(SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "escape.delim", "\\", "serialization.lib", LazyBinarySerDe.class.getName()));
    }

    public static TableDesc getIntermediateFileTableDesc(List<FieldSchema> fieldSchemas) {
        return new TableDesc(SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "escape.delim", "\\", "serialization.lib", LazyBinarySerDe.class.getName()));
    }

    public static TableDesc getReduceValueTableDesc(List<FieldSchema> fieldSchemas) {
        return new TableDesc(SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "escape.delim", "\\", "serialization.lib", LazyBinarySerDe.class.getName()));
    }

    public static List<FieldSchema> getFieldSchemasFromColumnListWithLength(List<ExprNodeDesc> cols, List<List<Integer>> distinctColIndices, List<String> outputColumnNames, int length, String fieldPrefix) {
        ArrayList<FieldSchema> schemas = new ArrayList<FieldSchema>(length + 1);
        for (int i = 0; i < length; ++i) {
            schemas.add(MetaStoreUtils.getFieldSchemaFromTypeInfo((String)(fieldPrefix + outputColumnNames.get(i)), (TypeInfo)cols.get(i).getTypeInfo()));
        }
        ArrayList<TypeInfo> unionTypes = new ArrayList<TypeInfo>();
        for (List<Integer> distinctCols : distinctColIndices) {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<TypeInfo> types = new ArrayList<TypeInfo>();
            int numExprs = 0;
            for (int i : distinctCols) {
                names.add(HiveConf.getColumnInternalName((int)numExprs));
                types.add(cols.get(i).getTypeInfo());
                ++numExprs;
            }
            unionTypes.add(TypeInfoFactory.getStructTypeInfo(names, types));
        }
        if (outputColumnNames.size() - length > 0) {
            schemas.add(MetaStoreUtils.getFieldSchemaFromTypeInfo((String)(fieldPrefix + outputColumnNames.get(length)), (TypeInfo)TypeInfoFactory.getUnionTypeInfo(unionTypes)));
        }
        return schemas;
    }

    public static List<FieldSchema> getFieldSchemasFromColumnList(List<ExprNodeDesc> cols, List<String> outputColumnNames, int start, String fieldPrefix) {
        ArrayList<FieldSchema> schemas = new ArrayList<FieldSchema>(cols.size());
        for (int i = 0; i < cols.size(); ++i) {
            schemas.add(MetaStoreUtils.getFieldSchemaFromTypeInfo((String)(fieldPrefix + outputColumnNames.get(i + start)), (TypeInfo)cols.get(i).getTypeInfo()));
        }
        return schemas;
    }

    public static List<FieldSchema> getFieldSchemasFromColumnList(List<ExprNodeDesc> cols, String fieldPrefix) {
        ArrayList<FieldSchema> schemas = new ArrayList<FieldSchema>(cols.size());
        for (int i = 0; i < cols.size(); ++i) {
            schemas.add(MetaStoreUtils.getFieldSchemaFromTypeInfo((String)(fieldPrefix + i), (TypeInfo)cols.get(i).getTypeInfo()));
        }
        return schemas;
    }

    public static List<FieldSchema> getFieldSchemasFromRowSchema(RowSchema row, String fieldPrefix) {
        ArrayList<ColumnInfo> c = row.getSignature();
        return PlanUtils.getFieldSchemasFromColumnInfo(c, fieldPrefix);
    }

    public static List<FieldSchema> getFieldSchemasFromColumnInfo(ArrayList<ColumnInfo> cols, String fieldPrefix) {
        if (cols == null || cols.size() == 0) {
            return new ArrayList<FieldSchema>();
        }
        ArrayList<FieldSchema> schemas = new ArrayList<FieldSchema>(cols.size());
        for (int i = 0; i < cols.size(); ++i) {
            String name = cols.get(i).getInternalName();
            if (name.equals(String.valueOf(i))) {
                name = fieldPrefix + name;
            }
            schemas.add(MetaStoreUtils.getFieldSchemaFromTypeInfo((String)name, (TypeInfo)cols.get(i).getType()));
        }
        return schemas;
    }

    public static List<FieldSchema> sortFieldSchemas(List<FieldSchema> schema) {
        Collections.sort(schema, new Comparator<FieldSchema>(){

            @Override
            public int compare(FieldSchema o1, FieldSchema o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return schema;
    }

    public static ReduceSinkDesc getReduceSinkDesc(ArrayList<ExprNodeDesc> keyCols, ArrayList<ExprNodeDesc> valueCols, List<String> outputColumnNames, boolean includeKeyCols, int tag, ArrayList<ExprNodeDesc> partitionCols, String order, String nullOrder, int numReducers, AcidUtils.Operation writeType) {
        return PlanUtils.getReduceSinkDesc(keyCols, keyCols.size(), valueCols, new ArrayList<List<Integer>>(), includeKeyCols ? outputColumnNames.subList(0, keyCols.size()) : new ArrayList(), includeKeyCols ? outputColumnNames.subList(keyCols.size(), outputColumnNames.size()) : outputColumnNames, includeKeyCols, tag, partitionCols, order, nullOrder, numReducers, writeType);
    }

    public static ReduceSinkDesc getReduceSinkDesc(ArrayList<ExprNodeDesc> keyCols, int numKeys, ArrayList<ExprNodeDesc> valueCols, List<List<Integer>> distinctColIndices, List<String> outputKeyColumnNames, List<String> outputValueColumnNames, boolean includeKeyCols, int tag, ArrayList<ExprNodeDesc> partitionCols, String order, String nullOrder, int numReducers, AcidUtils.Operation writeType) {
        TableDesc keyTable = null;
        TableDesc valueTable = null;
        ArrayList<String> outputKeyCols = new ArrayList<String>();
        ArrayList<String> outputValCols = new ArrayList<String>();
        if (includeKeyCols) {
            List<FieldSchema> keySchema = PlanUtils.getFieldSchemasFromColumnListWithLength(keyCols, distinctColIndices, outputKeyColumnNames, numKeys, "");
            if (order.length() < outputKeyColumnNames.size()) {
                order = order + "+";
            }
            if (nullOrder.length() < outputKeyColumnNames.size()) {
                nullOrder = nullOrder + "a";
            }
            keyTable = PlanUtils.getReduceKeyTableDesc(keySchema, order, nullOrder);
            outputKeyCols.addAll(outputKeyColumnNames);
        } else {
            keyTable = PlanUtils.getReduceKeyTableDesc(PlanUtils.getFieldSchemasFromColumnList(keyCols, "reducesinkkey"), order, nullOrder);
            for (int i = 0; i < keyCols.size(); ++i) {
                outputKeyCols.add("reducesinkkey" + i);
            }
        }
        valueTable = PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(valueCols, outputValueColumnNames, 0, ""));
        outputValCols.addAll(outputValueColumnNames);
        return new ReduceSinkDesc(keyCols, numKeys, valueCols, outputKeyCols, distinctColIndices, outputValCols, tag, partitionCols, numReducers, keyTable, valueTable, writeType);
    }

    public static ReduceSinkDesc getReduceSinkDesc(ArrayList<ExprNodeDesc> keyCols, ArrayList<ExprNodeDesc> valueCols, List<String> outputColumnNames, boolean includeKey, int tag, int numPartitionFields, int numReducers, AcidUtils.Operation writeType) throws SemanticException {
        return PlanUtils.getReduceSinkDesc(keyCols, keyCols.size(), valueCols, new ArrayList<List<Integer>>(), includeKey ? outputColumnNames.subList(0, keyCols.size()) : new ArrayList(), includeKey ? outputColumnNames.subList(keyCols.size(), outputColumnNames.size()) : outputColumnNames, includeKey, tag, numPartitionFields, numReducers, writeType);
    }

    public static ReduceSinkDesc getReduceSinkDesc(ArrayList<ExprNodeDesc> keyCols, int numKeys, ArrayList<ExprNodeDesc> valueCols, List<List<Integer>> distinctColIndices, List<String> outputKeyColumnNames, List<String> outputValueColumnNames, boolean includeKey, int tag, int numPartitionFields, int numReducers, AcidUtils.Operation writeType) throws SemanticException {
        ArrayList<ExprNodeDesc> partitionCols = new ArrayList<ExprNodeDesc>();
        if (numPartitionFields >= keyCols.size()) {
            partitionCols.addAll(keyCols);
        } else if (numPartitionFields >= 0) {
            partitionCols.addAll(keyCols.subList(0, numPartitionFields));
        } else {
            partitionCols.add(TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("rand", new ExprNodeDesc[0]));
        }
        StringBuilder order = new StringBuilder();
        StringBuilder nullOrder = new StringBuilder();
        for (int i = 0; i < keyCols.size(); ++i) {
            order.append("+");
            nullOrder.append("a");
        }
        return PlanUtils.getReduceSinkDesc(keyCols, numKeys, valueCols, distinctColIndices, outputKeyColumnNames, outputValueColumnNames, includeKey, tag, partitionCols, order.toString(), nullOrder.toString(), numReducers, writeType);
    }

    public static void configureInputJobPropertiesForStorageHandler(TableDesc tableDesc) {
        PlanUtils.configureJobPropertiesForStorageHandler(true, tableDesc);
    }

    public static void configureOutputJobPropertiesForStorageHandler(TableDesc tableDesc) {
        PlanUtils.configureJobPropertiesForStorageHandler(false, tableDesc);
    }

    private static void configureJobPropertiesForStorageHandler(boolean input, TableDesc tableDesc) {
        block10: {
            if (tableDesc == null) {
                return;
            }
            try {
                HiveStorageHandler storageHandler = HiveUtils.getStorageHandler((Configuration)Hive.get().getConf(), tableDesc.getProperties().getProperty("storage_handler"));
                if (storageHandler == null) break block10;
                LinkedHashMap<String, String> jobProperties = new LinkedHashMap<String, String>();
                if (input) {
                    try {
                        storageHandler.configureInputJobProperties(tableDesc, jobProperties);
                    }
                    catch (AbstractMethodError e) {
                        LOG.info("configureInputJobProperties not found using configureTableJobProperties", (Throwable)e);
                        storageHandler.configureTableJobProperties(tableDesc, jobProperties);
                    }
                } else {
                    try {
                        storageHandler.configureOutputJobProperties(tableDesc, jobProperties);
                    }
                    catch (AbstractMethodError e) {
                        LOG.info("configureOutputJobProperties not foundusing configureTableJobProperties", (Throwable)e);
                        storageHandler.configureTableJobProperties(tableDesc, jobProperties);
                    }
                }
                if (!jobProperties.isEmpty()) {
                    tableDesc.setJobProperties(jobProperties);
                }
            }
            catch (HiveException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        String handlerClass = tableDesc.getProperties().getProperty("storage_handler");
        try {
            HiveStorageHandler storageHandler = HiveUtils.getStorageHandler((Configuration)jobConf, handlerClass);
            if (storageHandler != null) {
                storageHandler.configureJobConf(tableDesc, jobConf);
            }
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }

    public static String stripQuotes(String val) {
        if (val.charAt(0) == '\'' && val.charAt(val.length() - 1) == '\'' || val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static String removePrefixFromWarehouseConfig(String origiKey) {
        int index;
        String prefix = SessionState.get().getConf().getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
        if (prefix != null && prefix.length() > 0 && (index = origiKey.indexOf(prefix = prefix.replace("pfile:///", "pfile:/"))) > -1) {
            origiKey = origiKey.substring(index + prefix.length());
        }
        return origiKey;
    }

    private PlanUtils() {
    }

    public static ReadEntity addInput(Set<ReadEntity> inputs, ReadEntity newInput) {
        return PlanUtils.addInput(inputs, newInput, false);
    }

    public static ReadEntity addInput(Set<ReadEntity> inputs, ReadEntity newInput, boolean mergeIsDirectFlag) {
        if (inputs.contains(newInput)) {
            for (ReadEntity input : inputs) {
                if (!input.equals(newInput)) continue;
                if (newInput.getParents() != null && !newInput.getParents().isEmpty()) {
                    input.getParents().addAll(newInput.getParents());
                    input.setDirect(input.isDirect() || newInput.isDirect());
                } else if (mergeIsDirectFlag) {
                    input.setDirect(input.isDirect() || newInput.isDirect());
                }
                return input;
            }
            assert (false);
        } else {
            inputs.add(newInput);
            return newInput;
        }
        return null;
    }

    public static String getExprListString(Collection<? extends ExprNodeDesc> exprs) {
        return PlanUtils.getExprListString(exprs, false);
    }

    public static String getExprListString(Collection<? extends ExprNodeDesc> exprs, boolean userLevelExplain) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ExprNodeDesc exprNodeDesc : exprs) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            PlanUtils.addExprToStringBuffer(exprNodeDesc, sb, userLevelExplain);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    public static void addExprToStringBuffer(ExprNodeDesc expr, Appendable sb, boolean userLevelExplain) {
        try {
            sb.append(expr.getExprString());
            if (!userLevelExplain) {
                sb.append(" (type: ");
                sb.append(expr.getTypeString());
                sb.append(")");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addPartitionInputs(Collection<Partition> parts, Collection<ReadEntity> inputs, ReadEntity parentViewInfo, boolean isDirectRead) {
        LinkedHashMap<ReadEntity, ReadEntity> readEntityMap = new LinkedHashMap<ReadEntity, ReadEntity>(inputs.size());
        for (ReadEntity input : inputs) {
            readEntityMap.put(input, input);
        }
        for (Partition part : parts) {
            ReadEntity newInput = null;
            newInput = part.getTable().isPartitioned() ? new ReadEntity(part, parentViewInfo, isDirectRead) : new ReadEntity(part.getTable(), parentViewInfo, isDirectRead);
            if (readEntityMap.containsKey(newInput)) {
                ReadEntity input = (ReadEntity)readEntityMap.get(newInput);
                if (newInput.getParents() == null || newInput.getParents().isEmpty()) continue;
                input.getParents().addAll(newInput.getParents());
                input.setDirect(input.isDirect() || newInput.isDirect());
                continue;
            }
            readEntityMap.put(newInput, newInput);
        }
        if (inputs.size() != readEntityMap.size()) {
            inputs.addAll(readEntityMap.keySet());
        }
    }

    public static void addInputsForView(ParseContext parseCtx) throws HiveException {
        HashSet<ReadEntity> inputs = parseCtx.getSemanticInputs();
        for (Map.Entry<String, TableScanOperator> entry : parseCtx.getTopOps().entrySet()) {
            String alias = entry.getKey();
            TableScanOperator topOp = entry.getValue();
            ReadEntity parentViewInfo = PlanUtils.getParentViewInfo(alias, parseCtx.getViewAliasToInput());
            Table table = ((TableScanDesc)topOp.getConf()).getTableMetadata();
            PlanUtils.addInput(inputs, new ReadEntity(table, parentViewInfo));
        }
    }

    public static ReadEntity getParentViewInfo(String alias_id, Map<String, ReadEntity> viewAliasToInput) {
        String[] aliases = alias_id.split(":");
        String currentAlias = null;
        ReadEntity currentInput = null;
        for (int pos = 0; pos < aliases.length; ++pos) {
            currentAlias = currentAlias == null ? aliases[pos] : currentAlias + ":" + aliases[pos];
            ReadEntity input = viewAliasToInput.get(currentAlias = currentAlias.replace("-subquery1", "").replace("-subquery2", ""));
            if (input == null && currentInput != null) {
                return currentInput;
            }
            currentInput = input;
        }
        return currentInput;
    }

    public static enum ExpressionTypes {
        FIELD,
        JEXL;

    }
}

