/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class VectorElt
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int[] inputColumns;
    private int outputColumn;

    public VectorElt(int[] inputColumns, int outputColumn) {
        this();
        this.inputColumns = inputColumns;
        this.outputColumn = outputColumn;
    }

    public VectorElt() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        int[] sel = batch.selected;
        int n = batch.size;
        BytesColumnVector outputVector = (BytesColumnVector)batch.cols[this.outputColumn];
        if (n <= 0) {
            return;
        }
        outputVector.init();
        outputVector.noNulls = false;
        outputVector.isRepeating = false;
        LongColumnVector inputIndexVector = (LongColumnVector)batch.cols[this.inputColumns[0]];
        long[] indexVector = inputIndexVector.vector;
        if (inputIndexVector.isRepeating) {
            int index = (int)indexVector[0];
            if (index > 0 && index < this.inputColumns.length) {
                BytesColumnVector cv = (BytesColumnVector)batch.cols[this.inputColumns[index]];
                if (cv.isRepeating) {
                    outputVector.setElement(0, 0, (ColumnVector)cv);
                    outputVector.isRepeating = true;
                } else if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector.setVal(i, cv.vector[0], cv.start[0], cv.length[0]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector.setVal(i, cv.vector[0], cv.start[0], cv.length[0]);
                    }
                }
            } else {
                outputVector.isNull[0] = true;
                outputVector.isRepeating = true;
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                int index = (int)indexVector[i];
                if (index > 0 && index < this.inputColumns.length) {
                    BytesColumnVector cv = (BytesColumnVector)batch.cols[this.inputColumns[index]];
                    int cvi = cv.isRepeating ? 0 : i;
                    outputVector.setVal(i, cv.vector[cvi], cv.start[cvi], cv.length[cvi]);
                    continue;
                }
                outputVector.isNull[i] = true;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                int index = (int)indexVector[i];
                if (index > 0 && index < this.inputColumns.length) {
                    BytesColumnVector cv = (BytesColumnVector)batch.cols[this.inputColumns[index]];
                    int cvi = cv.isRepeating ? 0 : i;
                    outputVector.setVal(i, cv.vector[cvi], cv.start[cvi], cv.length[cvi]);
                    continue;
                }
                outputVector.isNull[i] = true;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return this.outputType;
    }

    public int[] getInputColumns() {
        return this.inputColumns;
    }

    public void setInputColumns(int[] inputColumns) {
        this.inputColumns = inputColumns;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        throw new UnsupportedOperationException("Undefined descriptor");
    }
}

